// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <openssl/types-parsers.hxx>
//
// End prologue.

#include <openssl/agent/pkcs11/options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace openssl
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace openssl
{
  namespace agent
  {
    namespace pkcs11
    {
      // options
      //

      options::
      options ()
      : help_ (),
        version_ (),
        simulate_ (),
        simulate_specified_ (false)
      {
      }

      bool options::
      parse (int& argc,
             char** argv,
             bool erase,
             ::openssl::cli::unknown_mode opt,
             ::openssl::cli::unknown_mode arg)
      {
        ::openssl::cli::argv_scanner s (argc, argv, erase);
        bool r = _parse (s, opt, arg);
        return r;
      }

      bool options::
      parse (int start,
             int& argc,
             char** argv,
             bool erase,
             ::openssl::cli::unknown_mode opt,
             ::openssl::cli::unknown_mode arg)
      {
        ::openssl::cli::argv_scanner s (start, argc, argv, erase);
        bool r = _parse (s, opt, arg);
        return r;
      }

      bool options::
      parse (int& argc,
             char** argv,
             int& end,
             bool erase,
             ::openssl::cli::unknown_mode opt,
             ::openssl::cli::unknown_mode arg)
      {
        ::openssl::cli::argv_scanner s (argc, argv, erase);
        bool r = _parse (s, opt, arg);
        end = s.end ();
        return r;
      }

      bool options::
      parse (int start,
             int& argc,
             char** argv,
             int& end,
             bool erase,
             ::openssl::cli::unknown_mode opt,
             ::openssl::cli::unknown_mode arg)
      {
        ::openssl::cli::argv_scanner s (start, argc, argv, erase);
        bool r = _parse (s, opt, arg);
        end = s.end ();
        return r;
      }

      bool options::
      parse (::openssl::cli::scanner& s,
             ::openssl::cli::unknown_mode opt,
             ::openssl::cli::unknown_mode arg)
      {
        bool r = _parse (s, opt, arg);
        return r;
      }

      ::openssl::cli::usage_para options::
      print_usage (::std::ostream& os, ::openssl::cli::usage_para p)
      {
        CLI_POTENTIALLY_UNUSED (os);

        if (p != ::openssl::cli::usage_para::none)
          os << ::std::endl;

        os << "\033[1mOPTIONS\033[0m" << ::std::endl;

        os << std::endl
           << "\033[1m--help\033[0m               Print usage information and exit." << ::std::endl;

        os << std::endl
           << "\033[1m--version\033[0m            Print version and exit." << ::std::endl;

        os << std::endl
           << "\033[1m--simulate\033[0m \033[4moutcome\033[0m   Run the daemon in the simulation mode." << ::std::endl;

        p = ::openssl::cli::usage_para::option;

        return p;
      }

      typedef
      std::map<std::string, void (*) (options&, ::openssl::cli::scanner&)>
      _cli_options_map;

      static _cli_options_map _cli_options_map_;

      struct _cli_options_map_init
      {
        _cli_options_map_init ()
        {
          _cli_options_map_["--help"] =
          &::openssl::cli::thunk< options, &options::help_ >;
          _cli_options_map_["--version"] =
          &::openssl::cli::thunk< options, &options::version_ >;
          _cli_options_map_["--simulate"] =
          &::openssl::cli::thunk< options, simulate_outcome, &options::simulate_,
            &options::simulate_specified_ >;
        }
      };

      static _cli_options_map_init _cli_options_map_init_;

      bool options::
      _parse (const char* o, ::openssl::cli::scanner& s)
      {
        _cli_options_map::const_iterator i (_cli_options_map_.find (o));

        if (i != _cli_options_map_.end ())
        {
          (*(i->second)) (*this, s);
          return true;
        }

        return false;
      }

      bool options::
      _parse (::openssl::cli::scanner& s,
              ::openssl::cli::unknown_mode opt_mode,
              ::openssl::cli::unknown_mode arg_mode)
      {
        // Can't skip combined flags (--no-combined-flags).
        //
        assert (opt_mode != ::openssl::cli::unknown_mode::skip);

        bool r = false;
        bool opt = true;

        while (s.more ())
        {
          const char* o = s.peek ();

          if (std::strcmp (o, "--") == 0)
          {
            opt = false;
            s.skip ();
            r = true;
            continue;
          }

          if (opt)
          {
            if (_parse (o, s))
            {
              r = true;
              continue;
            }

            if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
            {
              // Handle combined option values.
              //
              std::string co;
              if (const char* v = std::strchr (o, '='))
              {
                co.assign (o, 0, v - o);
                ++v;

                int ac (2);
                char* av[] =
                {
                  const_cast<char*> (co.c_str ()),
                  const_cast<char*> (v)
                };

                ::openssl::cli::argv_scanner ns (0, ac, av);

                if (_parse (co.c_str (), ns))
                {
                  // Parsed the option but not its value?
                  //
                  if (ns.end () != 2)
                    throw ::openssl::cli::invalid_value (co, v);

                  s.next ();
                  r = true;
                  continue;
                }
                else
                {
                  // Set the unknown option and fall through.
                  //
                  o = co.c_str ();
                }
              }

              // Handle combined flags.
              //
              char cf[3];
              {
                const char* p = o + 1;
                for (; *p != '\0'; ++p)
                {
                  if (!((*p >= 'a' && *p <= 'z') ||
                        (*p >= 'A' && *p <= 'Z') ||
                        (*p >= '0' && *p <= '9')))
                    break;
                }

                if (*p == '\0')
                {
                  for (p = o + 1; *p != '\0'; ++p)
                  {
                    std::strcpy (cf, "-");
                    cf[1] = *p;
                    cf[2] = '\0';

                    int ac (1);
                    char* av[] =
                    {
                      cf
                    };

                    ::openssl::cli::argv_scanner ns (0, ac, av);

                    if (!_parse (cf, ns))
                      break;
                  }

                  if (*p == '\0')
                  {
                    // All handled.
                    //
                    s.next ();
                    r = true;
                    continue;
                  }
                  else
                  {
                    // Set the unknown option and fall through.
                    //
                    o = cf;
                  }
                }
              }

              switch (opt_mode)
              {
                case ::openssl::cli::unknown_mode::skip:
                {
                  s.skip ();
                  r = true;
                  continue;
                }
                case ::openssl::cli::unknown_mode::stop:
                {
                  break;
                }
                case ::openssl::cli::unknown_mode::fail:
                {
                  throw ::openssl::cli::unknown_option (o);
                }
              }

              break;
            }
          }

          switch (arg_mode)
          {
            case ::openssl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::openssl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::openssl::cli::unknown_mode::fail:
            {
              throw ::openssl::cli::unknown_argument (o);
            }
          }

          break;
        }

        return r;
      }
    }
  }
}

namespace openssl
{
  ::openssl::cli::usage_para
  print_openssl_agent_pkcs11_usage (::std::ostream& os, ::openssl::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::openssl::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mopenssl-agent-pkcs11 --help\033[0m" << ::std::endl
       << "\033[1mopenssl-agent-pkcs11 --version\033[0m" << ::std::endl
       << "\033[1mopenssl-agent-pkcs11\033[0m [\033[4moptions\033[0m] \033[4murl\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mPKCS#11\033[0m key agent prompts for a PIN for the specified token and forks off" << ::std::endl
       << "the daemon, which unlocks the key, opens a UNIX domain socket, and waits for" << ::std::endl
       << "cryptographic operation requests from the OpenSSL client \033[1mopenssl-client(1)\033[0m. The" << ::std::endl
       << "agent also prints to \033[1mstdout\033[0m a shell script fragment that sets the environment" << ::std::endl
       << "variables necessary for locating the agent. See the ENVIRONMENT section for" << ::std::endl
       << "details." << ::std::endl
       << ::std::endl
       << "The daemon can be run in the simulation mode without actually logging into the" << ::std::endl
       << "\033[1mPKCS#11\033[0m token. If the \033[1m--simulate\033[0m option is specified with the \033[1msuccess\033[0m outcome," << ::std::endl
       << "the daemon pretends to unlock the requested key and responds with a dummy" << ::std::endl
       << "signature to the subsequent data signing requests. The \033[1mfailure\033[0m outcome causes" << ::std::endl
       << "the daemon to exit with non-zero status, as if it failed to find the key. This" << ::std::endl
       << "mode is mostly useful for testing." << ::std::endl;

    p = ::openssl::agent::pkcs11::options::print_usage (os, ::openssl::cli::usage_para::text);

    if (p != ::openssl::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mENVIRONMENT\033[0m" << ::std::endl
       << ::std::endl
       << "The printed shell script fragment sets the \033[1mOPENSSL_AGENT_PKCS11_SOCK\033[0m and" << ::std::endl
       << "\033[1mOPENSSL_AGENT_PKCS11_PID\033[0m environment variables. The former refers to the" << ::std::endl
       << "Unix-domain socket that should be used by \033[1mopenssl-client(1)\033[0m for communicating" << ::std::endl
       << "with the daemon. The latter contains the daemon process id that can be used to" << ::std::endl
       << "terminate the daemon by sending it the \033[1mSIGTERM\033[0m signal." << ::std::endl;

    os << std::endl
       << "\033[1mEXIT STATUS\033[0m" << ::std::endl
       << ::std::endl
       << "Non-zero exit status is returned in case of an error." << ::std::endl;

    p = ::openssl::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

