// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

#ifndef LIBBUTL_BUILTIN_OPTIONS_HXX
#define LIBBUTL_BUILTIN_OPTIONS_HXX

// Begin prologue.
//
//
// End prologue.

#include <vector>
#include <iosfwd>
#include <string>
#include <cstddef>
#include <exception>

#ifndef CLI_POTENTIALLY_UNUSED
#  if defined(_MSC_VER) || defined(__xlC__)
#    define CLI_POTENTIALLY_UNUSED(x) (void*)&x
#  else
#    define CLI_POTENTIALLY_UNUSED(x) (void)x
#  endif
#endif

namespace butl
{
  namespace cli
  {
    class unknown_mode
    {
      public:
      enum value
      {
        skip,
        stop,
        fail
      };

      unknown_mode (value);

      operator value () const 
      {
        return v_;
      }

      private:
      value v_;
    };

    // Exceptions.
    //

    class exception: public std::exception
    {
      public:
      virtual void
      print (::std::ostream&) const = 0;
    };

    ::std::ostream&
    operator<< (::std::ostream&, const exception&);

    class unknown_option: public exception
    {
      public:
      virtual
      ~unknown_option () noexcept;

      unknown_option (const std::string& option);

      const std::string&
      option () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string option_;
    };

    class unknown_argument: public exception
    {
      public:
      virtual
      ~unknown_argument () noexcept;

      unknown_argument (const std::string& argument);

      const std::string&
      argument () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string argument_;
    };

    class missing_value: public exception
    {
      public:
      virtual
      ~missing_value () noexcept;

      missing_value (const std::string& option);

      const std::string&
      option () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string option_;
    };

    class invalid_value: public exception
    {
      public:
      virtual
      ~invalid_value () noexcept;

      invalid_value (const std::string& option,
                     const std::string& value,
                     const std::string& message = std::string ());

      const std::string&
      option () const;

      const std::string&
      value () const;

      const std::string&
      message () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string option_;
      std::string value_;
      std::string message_;
    };

    class eos_reached: public exception
    {
      public:
      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;
    };

    // Command line argument scanner interface.
    //
    // The values returned by next() are guaranteed to be valid
    // for the two previous arguments up until a call to a third
    // peek() or next().
    //
    // The position() function returns a monotonically-increasing
    // number which, if stored, can later be used to determine the
    // relative position of the argument returned by the following
    // call to next(). Note that if multiple scanners are used to
    // extract arguments from multiple sources, then the end
    // position of the previous scanner should be used as the
    // start position of the next.
    //
    class scanner
    {
      public:
      virtual
      ~scanner ();

      virtual bool
      more () = 0;

      virtual const char*
      peek () = 0;

      virtual const char*
      next () = 0;

      virtual void
      skip () = 0;

      virtual std::size_t
      position () = 0;
    };

    class argv_scanner: public scanner
    {
      public:
      argv_scanner (int& argc,
                    char** argv,
                    bool erase = false,
                    std::size_t start_position = 0);

      argv_scanner (int start,
                    int& argc,
                    char** argv,
                    bool erase = false,
                    std::size_t start_position = 0);

      int
      end () const;

      virtual bool
      more ();

      virtual const char*
      peek ();

      virtual const char*
      next ();

      virtual void
      skip ();

      virtual std::size_t
      position ();

      protected:
      std::size_t start_position_;
      int i_;
      int& argc_;
      char** argv_;
      bool erase_;
    };

    class vector_scanner: public scanner
    {
      public:
      vector_scanner (const std::vector<std::string>&,
                      std::size_t start = 0,
                      std::size_t start_position = 0);

      std::size_t
      end () const;

      void
      reset (std::size_t start = 0, std::size_t start_position = 0);

      virtual bool
      more ();

      virtual const char*
      peek ();

      virtual const char*
      next ();

      virtual void
      skip ();

      virtual std::size_t
      position ();

      private:
      std::size_t start_position_;
      const std::vector<std::string>& v_;
      std::size_t i_;
    };

    template <typename X>
    struct parser;
  }
}

#include <string>

#include <vector>

namespace butl
{
  class cat_options
  {
    public:
    cat_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
  };

  class cp_options
  {
    public:
    cp_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    recursive () const;

    const bool&
    preserve () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool recursive_;
    bool preserve_;
  };

  class date_options
  {
    public:
    date_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    utc () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool utc_;
  };

  class find_options
  {
    public:
    find_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
  };

  class ln_options
  {
    public:
    ln_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    symbolic () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool symbolic_;
  };

  class mkdir_options
  {
    public:
    mkdir_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    parents () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool parents_;
  };

  class mv_options
  {
    public:
    mv_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    force () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool force_;
  };

  class rm_options
  {
    public:
    rm_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    recursive () const;

    const bool&
    force () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool recursive_;
    bool force_;
  };

  class rmdir_options
  {
    public:
    rmdir_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    force () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool force_;
  };

  class sed_options
  {
    public:
    sed_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    quiet () const;

    const bool&
    in_place () const;

    const std::vector<std::string>&
    expression () const;

    bool
    expression_specified () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool quiet_;
    bool in_place_;
    std::vector<std::string> expression_;
    bool expression_specified_;
  };

  class sha256sum_options
  {
    public:
    sha256sum_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    binary () const;

    const bool&
    text () const;

    const bool&
    sum_only () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool binary_;
    bool text_;
    bool sum_only_;
  };

  class sleep_options
  {
    public:
    sleep_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
  };

  class test_options
  {
    public:
    test_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const bool&
    file () const;

    const bool&
    directory () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    bool file_;
    bool directory_;
  };

  class touch_options
  {
    public:
    touch_options ();

    // Return true if anything has been parsed.
    //
    bool
    parse (int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    bool
    parse (::butl::cli::scanner&,
           ::butl::cli::unknown_mode option = ::butl::cli::unknown_mode::fail,
           ::butl::cli::unknown_mode argument = ::butl::cli::unknown_mode::stop);

    // Option accessors.
    //
    const std::string&
    after () const;

    bool
    after_specified () const;

    // Implementation details.
    //
    protected:
    bool
    _parse (const char*, ::butl::cli::scanner&);

    private:
    bool
    _parse (::butl::cli::scanner&,
            ::butl::cli::unknown_mode option,
            ::butl::cli::unknown_mode argument);

    public:
    std::string after_;
    bool after_specified_;
  };
}

#include <libbutl/builtin-options.ixx>

// Begin epilogue.
//
//
// End epilogue.

#endif // LIBBUTL_BUILTIN_OPTIONS_HXX
