// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
//
// End prologue.

#include <libbutl/builtin-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace butl
{
  namespace cli
  {
    // unknown_option
    //
    unknown_option::
    ~unknown_option () noexcept
    {
    }

    void unknown_option::
    print (::std::ostream& os) const
    {
      os << "unknown option '" << option ().c_str () << "'";
    }

    const char* unknown_option::
    what () const noexcept
    {
      return "unknown option";
    }

    // unknown_argument
    //
    unknown_argument::
    ~unknown_argument () noexcept
    {
    }

    void unknown_argument::
    print (::std::ostream& os) const
    {
      os << "unknown argument '" << argument ().c_str () << "'";
    }

    const char* unknown_argument::
    what () const noexcept
    {
      return "unknown argument";
    }

    // missing_value
    //
    missing_value::
    ~missing_value () noexcept
    {
    }

    void missing_value::
    print (::std::ostream& os) const
    {
      os << "missing value for option '" << option ().c_str () << "'";
    }

    const char* missing_value::
    what () const noexcept
    {
      return "missing option value";
    }

    // invalid_value
    //
    invalid_value::
    ~invalid_value () noexcept
    {
    }

    void invalid_value::
    print (::std::ostream& os) const
    {
      os << "invalid value '" << value ().c_str () << "' for option '"
         << option ().c_str () << "'";

      if (!message ().empty ())
        os << ": " << message ().c_str ();
    }

    const char* invalid_value::
    what () const noexcept
    {
      return "invalid option value";
    }

    // eos_reached
    //
    void eos_reached::
    print (::std::ostream& os) const
    {
      os << what ();
    }

    const char* eos_reached::
    what () const noexcept
    {
      return "end of argument stream reached";
    }

    // scanner
    //
    scanner::
    ~scanner ()
    {
    }

    // argv_scanner
    //
    bool argv_scanner::
    more ()
    {
      return i_ < argc_;
    }

    const char* argv_scanner::
    peek ()
    {
      if (i_ < argc_)
        return argv_[i_];
      else
        throw eos_reached ();
    }

    const char* argv_scanner::
    next ()
    {
      if (i_ < argc_)
      {
        const char* r (argv_[i_]);

        if (erase_)
        {
          for (int i (i_ + 1); i < argc_; ++i)
            argv_[i - 1] = argv_[i];

          --argc_;
          argv_[argc_] = 0;
        }
        else
          ++i_;

        ++start_position_;
        return r;
      }
      else
        throw eos_reached ();
    }

    void argv_scanner::
    skip ()
    {
      if (i_ < argc_)
      {
        ++i_;
        ++start_position_;
      }
      else
        throw eos_reached ();
    }

    std::size_t argv_scanner::
    position ()
    {
      return start_position_;
    }

    // vector_scanner
    //
    bool vector_scanner::
    more ()
    {
      return i_ < v_.size ();
    }

    const char* vector_scanner::
    peek ()
    {
      if (i_ < v_.size ())
        return v_[i_].c_str ();
      else
        throw eos_reached ();
    }

    const char* vector_scanner::
    next ()
    {
      if (i_ < v_.size ())
        return v_[i_++].c_str ();
      else
        throw eos_reached ();
    }

    void vector_scanner::
    skip ()
    {
      if (i_ < v_.size ())
        ++i_;
      else
        throw eos_reached ();
    }

    std::size_t vector_scanner::
    position ()
    {
      return start_position_ + i_;
    }

    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace butl
{
  // cat_options
  //

  cat_options::
  cat_options ()
  {
  }

  bool cat_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cat_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cat_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cat_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cat_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (cat_options&, ::butl::cli::scanner&)>
  _cli_cat_options_map;

  static _cli_cat_options_map _cli_cat_options_map_;

  struct _cli_cat_options_map_init
  {
    _cli_cat_options_map_init ()
    {
    }
  };

  static _cli_cat_options_map_init _cli_cat_options_map_init_;

  bool cat_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_cat_options_map::const_iterator i (_cli_cat_options_map_.find (o));

    if (i != _cli_cat_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cat_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cp_options
  //

  cp_options::
  cp_options ()
  : recursive_ (),
    preserve_ ()
  {
  }

  bool cp_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cp_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cp_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cp_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cp_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (cp_options&, ::butl::cli::scanner&)>
  _cli_cp_options_map;

  static _cli_cp_options_map _cli_cp_options_map_;

  struct _cli_cp_options_map_init
  {
    _cli_cp_options_map_init ()
    {
      _cli_cp_options_map_["--recursive"] =
      &::butl::cli::thunk< cp_options, &cp_options::recursive_ >;
      _cli_cp_options_map_["-R"] =
      &::butl::cli::thunk< cp_options, &cp_options::recursive_ >;
      _cli_cp_options_map_["-r"] =
      &::butl::cli::thunk< cp_options, &cp_options::recursive_ >;
      _cli_cp_options_map_["--preserve"] =
      &::butl::cli::thunk< cp_options, &cp_options::preserve_ >;
      _cli_cp_options_map_["-p"] =
      &::butl::cli::thunk< cp_options, &cp_options::preserve_ >;
    }
  };

  static _cli_cp_options_map_init _cli_cp_options_map_init_;

  bool cp_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_cp_options_map::const_iterator i (_cli_cp_options_map_.find (o));

    if (i != _cli_cp_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cp_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // date_options
  //

  date_options::
  date_options ()
  : utc_ ()
  {
  }

  bool date_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool date_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool date_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool date_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool date_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (date_options&, ::butl::cli::scanner&)>
  _cli_date_options_map;

  static _cli_date_options_map _cli_date_options_map_;

  struct _cli_date_options_map_init
  {
    _cli_date_options_map_init ()
    {
      _cli_date_options_map_["--utc"] =
      &::butl::cli::thunk< date_options, &date_options::utc_ >;
      _cli_date_options_map_["-u"] =
      &::butl::cli::thunk< date_options, &date_options::utc_ >;
    }
  };

  static _cli_date_options_map_init _cli_date_options_map_init_;

  bool date_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_date_options_map::const_iterator i (_cli_date_options_map_.find (o));

    if (i != _cli_date_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool date_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // find_options
  //

  find_options::
  find_options ()
  {
  }

  bool find_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool find_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool find_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool find_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool find_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (find_options&, ::butl::cli::scanner&)>
  _cli_find_options_map;

  static _cli_find_options_map _cli_find_options_map_;

  struct _cli_find_options_map_init
  {
    _cli_find_options_map_init ()
    {
    }
  };

  static _cli_find_options_map_init _cli_find_options_map_init_;

  bool find_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_find_options_map::const_iterator i (_cli_find_options_map_.find (o));

    if (i != _cli_find_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool find_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // ln_options
  //

  ln_options::
  ln_options ()
  : symbolic_ ()
  {
  }

  bool ln_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool ln_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool ln_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool ln_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool ln_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (ln_options&, ::butl::cli::scanner&)>
  _cli_ln_options_map;

  static _cli_ln_options_map _cli_ln_options_map_;

  struct _cli_ln_options_map_init
  {
    _cli_ln_options_map_init ()
    {
      _cli_ln_options_map_["--symbolic"] =
      &::butl::cli::thunk< ln_options, &ln_options::symbolic_ >;
      _cli_ln_options_map_["-s"] =
      &::butl::cli::thunk< ln_options, &ln_options::symbolic_ >;
    }
  };

  static _cli_ln_options_map_init _cli_ln_options_map_init_;

  bool ln_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_ln_options_map::const_iterator i (_cli_ln_options_map_.find (o));

    if (i != _cli_ln_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool ln_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // mkdir_options
  //

  mkdir_options::
  mkdir_options ()
  : parents_ ()
  {
  }

  bool mkdir_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool mkdir_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool mkdir_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool mkdir_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool mkdir_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (mkdir_options&, ::butl::cli::scanner&)>
  _cli_mkdir_options_map;

  static _cli_mkdir_options_map _cli_mkdir_options_map_;

  struct _cli_mkdir_options_map_init
  {
    _cli_mkdir_options_map_init ()
    {
      _cli_mkdir_options_map_["--parents"] =
      &::butl::cli::thunk< mkdir_options, &mkdir_options::parents_ >;
      _cli_mkdir_options_map_["-p"] =
      &::butl::cli::thunk< mkdir_options, &mkdir_options::parents_ >;
    }
  };

  static _cli_mkdir_options_map_init _cli_mkdir_options_map_init_;

  bool mkdir_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_mkdir_options_map::const_iterator i (_cli_mkdir_options_map_.find (o));

    if (i != _cli_mkdir_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool mkdir_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // mv_options
  //

  mv_options::
  mv_options ()
  : force_ ()
  {
  }

  bool mv_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool mv_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool mv_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool mv_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool mv_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (mv_options&, ::butl::cli::scanner&)>
  _cli_mv_options_map;

  static _cli_mv_options_map _cli_mv_options_map_;

  struct _cli_mv_options_map_init
  {
    _cli_mv_options_map_init ()
    {
      _cli_mv_options_map_["--force"] =
      &::butl::cli::thunk< mv_options, &mv_options::force_ >;
      _cli_mv_options_map_["-f"] =
      &::butl::cli::thunk< mv_options, &mv_options::force_ >;
    }
  };

  static _cli_mv_options_map_init _cli_mv_options_map_init_;

  bool mv_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_mv_options_map::const_iterator i (_cli_mv_options_map_.find (o));

    if (i != _cli_mv_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool mv_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // rm_options
  //

  rm_options::
  rm_options ()
  : recursive_ (),
    force_ ()
  {
  }

  bool rm_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool rm_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool rm_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool rm_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool rm_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (rm_options&, ::butl::cli::scanner&)>
  _cli_rm_options_map;

  static _cli_rm_options_map _cli_rm_options_map_;

  struct _cli_rm_options_map_init
  {
    _cli_rm_options_map_init ()
    {
      _cli_rm_options_map_["--recursive"] =
      &::butl::cli::thunk< rm_options, &rm_options::recursive_ >;
      _cli_rm_options_map_["-r"] =
      &::butl::cli::thunk< rm_options, &rm_options::recursive_ >;
      _cli_rm_options_map_["--force"] =
      &::butl::cli::thunk< rm_options, &rm_options::force_ >;
      _cli_rm_options_map_["-f"] =
      &::butl::cli::thunk< rm_options, &rm_options::force_ >;
    }
  };

  static _cli_rm_options_map_init _cli_rm_options_map_init_;

  bool rm_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_rm_options_map::const_iterator i (_cli_rm_options_map_.find (o));

    if (i != _cli_rm_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool rm_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // rmdir_options
  //

  rmdir_options::
  rmdir_options ()
  : force_ ()
  {
  }

  bool rmdir_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool rmdir_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool rmdir_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool rmdir_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool rmdir_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (rmdir_options&, ::butl::cli::scanner&)>
  _cli_rmdir_options_map;

  static _cli_rmdir_options_map _cli_rmdir_options_map_;

  struct _cli_rmdir_options_map_init
  {
    _cli_rmdir_options_map_init ()
    {
      _cli_rmdir_options_map_["--force"] =
      &::butl::cli::thunk< rmdir_options, &rmdir_options::force_ >;
      _cli_rmdir_options_map_["-f"] =
      &::butl::cli::thunk< rmdir_options, &rmdir_options::force_ >;
    }
  };

  static _cli_rmdir_options_map_init _cli_rmdir_options_map_init_;

  bool rmdir_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_rmdir_options_map::const_iterator i (_cli_rmdir_options_map_.find (o));

    if (i != _cli_rmdir_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool rmdir_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // sed_options
  //

  sed_options::
  sed_options ()
  : quiet_ (),
    in_place_ (),
    expression_ (),
    expression_specified_ (false)
  {
  }

  bool sed_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool sed_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool sed_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool sed_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool sed_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (sed_options&, ::butl::cli::scanner&)>
  _cli_sed_options_map;

  static _cli_sed_options_map _cli_sed_options_map_;

  struct _cli_sed_options_map_init
  {
    _cli_sed_options_map_init ()
    {
      _cli_sed_options_map_["--quiet"] =
      &::butl::cli::thunk< sed_options, &sed_options::quiet_ >;
      _cli_sed_options_map_["-n"] =
      &::butl::cli::thunk< sed_options, &sed_options::quiet_ >;
      _cli_sed_options_map_["--in-place"] =
      &::butl::cli::thunk< sed_options, &sed_options::in_place_ >;
      _cli_sed_options_map_["-i"] =
      &::butl::cli::thunk< sed_options, &sed_options::in_place_ >;
      _cli_sed_options_map_["--expression"] =
      &::butl::cli::thunk< sed_options, std::vector<std::string>, &sed_options::expression_,
        &sed_options::expression_specified_ >;
      _cli_sed_options_map_["-e"] =
      &::butl::cli::thunk< sed_options, std::vector<std::string>, &sed_options::expression_,
        &sed_options::expression_specified_ >;
    }
  };

  static _cli_sed_options_map_init _cli_sed_options_map_init_;

  bool sed_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_sed_options_map::const_iterator i (_cli_sed_options_map_.find (o));

    if (i != _cli_sed_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool sed_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // sha256sum_options
  //

  sha256sum_options::
  sha256sum_options ()
  : binary_ (),
    text_ (),
    sum_only_ ()
  {
  }

  bool sha256sum_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool sha256sum_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool sha256sum_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool sha256sum_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool sha256sum_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (sha256sum_options&, ::butl::cli::scanner&)>
  _cli_sha256sum_options_map;

  static _cli_sha256sum_options_map _cli_sha256sum_options_map_;

  struct _cli_sha256sum_options_map_init
  {
    _cli_sha256sum_options_map_init ()
    {
      _cli_sha256sum_options_map_["--binary"] =
      &::butl::cli::thunk< sha256sum_options, &sha256sum_options::binary_ >;
      _cli_sha256sum_options_map_["-b"] =
      &::butl::cli::thunk< sha256sum_options, &sha256sum_options::binary_ >;
      _cli_sha256sum_options_map_["--text"] =
      &::butl::cli::thunk< sha256sum_options, &sha256sum_options::text_ >;
      _cli_sha256sum_options_map_["-t"] =
      &::butl::cli::thunk< sha256sum_options, &sha256sum_options::text_ >;
      _cli_sha256sum_options_map_["--sum-only"] =
      &::butl::cli::thunk< sha256sum_options, &sha256sum_options::sum_only_ >;
    }
  };

  static _cli_sha256sum_options_map_init _cli_sha256sum_options_map_init_;

  bool sha256sum_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_sha256sum_options_map::const_iterator i (_cli_sha256sum_options_map_.find (o));

    if (i != _cli_sha256sum_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool sha256sum_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // sleep_options
  //

  sleep_options::
  sleep_options ()
  {
  }

  bool sleep_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool sleep_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool sleep_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool sleep_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool sleep_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (sleep_options&, ::butl::cli::scanner&)>
  _cli_sleep_options_map;

  static _cli_sleep_options_map _cli_sleep_options_map_;

  struct _cli_sleep_options_map_init
  {
    _cli_sleep_options_map_init ()
    {
    }
  };

  static _cli_sleep_options_map_init _cli_sleep_options_map_init_;

  bool sleep_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_sleep_options_map::const_iterator i (_cli_sleep_options_map_.find (o));

    if (i != _cli_sleep_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool sleep_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // test_options
  //

  test_options::
  test_options ()
  : file_ (),
    directory_ ()
  {
  }

  bool test_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool test_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool test_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool test_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool test_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (test_options&, ::butl::cli::scanner&)>
  _cli_test_options_map;

  static _cli_test_options_map _cli_test_options_map_;

  struct _cli_test_options_map_init
  {
    _cli_test_options_map_init ()
    {
      _cli_test_options_map_["--file"] =
      &::butl::cli::thunk< test_options, &test_options::file_ >;
      _cli_test_options_map_["-f"] =
      &::butl::cli::thunk< test_options, &test_options::file_ >;
      _cli_test_options_map_["--directory"] =
      &::butl::cli::thunk< test_options, &test_options::directory_ >;
      _cli_test_options_map_["-d"] =
      &::butl::cli::thunk< test_options, &test_options::directory_ >;
    }
  };

  static _cli_test_options_map_init _cli_test_options_map_init_;

  bool test_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_test_options_map::const_iterator i (_cli_test_options_map_.find (o));

    if (i != _cli_test_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool test_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // touch_options
  //

  touch_options::
  touch_options ()
  : after_ (),
    after_specified_ (false)
  {
  }

  bool touch_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool touch_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool touch_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool touch_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    ::butl::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool touch_options::
  parse (::butl::cli::scanner& s,
         ::butl::cli::unknown_mode opt,
         ::butl::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  typedef
  std::map<std::string, void (*) (touch_options&, ::butl::cli::scanner&)>
  _cli_touch_options_map;

  static _cli_touch_options_map _cli_touch_options_map_;

  struct _cli_touch_options_map_init
  {
    _cli_touch_options_map_init ()
    {
      _cli_touch_options_map_["--after"] =
      &::butl::cli::thunk< touch_options, std::string, &touch_options::after_,
        &touch_options::after_specified_ >;
    }
  };

  static _cli_touch_options_map_init _cli_touch_options_map_init_;

  bool touch_options::
  _parse (const char* o, ::butl::cli::scanner& s)
  {
    _cli_touch_options_map::const_iterator i (_cli_touch_options_map_.find (o));

    if (i != _cli_touch_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool touch_options::
  _parse (::butl::cli::scanner& s,
          ::butl::cli::unknown_mode opt_mode,
          ::butl::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::butl::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::butl::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::butl::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::butl::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::butl::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::butl::cli::unknown_mode::stop:
            {
              break;
            }
            case ::butl::cli::unknown_mode::fail:
            {
              throw ::butl::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::butl::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::butl::cli::unknown_mode::stop:
        {
          break;
        }
        case ::butl::cli::unknown_mode::fail:
        {
          throw ::butl::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

// Begin epilogue.
//
//
// End epilogue.

