// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
//
// End prologue.

#include <cassert>

namespace bpkg
{
  namespace cli
  {
    // usage_para
    //
    inline usage_para::
    usage_para (value v)
    : v_ (v)
    {
    }

    // unknown_mode
    //
    inline unknown_mode::
    unknown_mode (value v)
    : v_ (v)
    {
    }

    // exception
    //
    inline ::std::ostream&
    operator<< (::std::ostream& os, const exception& e)
    {
      e.print (os);
      return os;
    }

    // unknown_option
    //
    inline unknown_option::
    unknown_option (const std::string& option)
    : option_ (option)
    {
    }

    inline const std::string& unknown_option::
    option () const
    {
      return option_;
    }

    // unknown_argument
    //
    inline unknown_argument::
    unknown_argument (const std::string& argument)
    : argument_ (argument)
    {
    }

    inline const std::string& unknown_argument::
    argument () const
    {
      return argument_;
    }

    // missing_value
    //
    inline missing_value::
    missing_value (const std::string& option)
    : option_ (option)
    {
    }

    inline const std::string& missing_value::
    option () const
    {
      return option_;
    }

    // invalid_value
    //
    inline invalid_value::
    invalid_value (const std::string& option,
                   const std::string& value,
                   const std::string& message)
    : option_ (option),
      value_ (value),
      message_ (message)
    {
    }

    inline const std::string& invalid_value::
    option () const
    {
      return option_;
    }

    inline const std::string& invalid_value::
    value () const
    {
      return value_;
    }

    inline const std::string& invalid_value::
    message () const
    {
      return message_;
    }

    // file_io_failure
    //
    inline file_io_failure::
    file_io_failure (const std::string& file)
    : file_ (file)
    {
    }

    inline const std::string& file_io_failure::
    file () const
    {
      return file_;
    }

    // unmatched_quote
    //
    inline unmatched_quote::
    unmatched_quote (const std::string& argument)
    : argument_ (argument)
    {
    }

    inline const std::string& unmatched_quote::
    argument () const
    {
      return argument_;
    }

    // unexpected_group
    //
    inline unexpected_group::
    unexpected_group (const std::string& argument,
                      const std::string& group)
    : argument_ (argument), group_ (group)
    {
    }

    inline const std::string& unexpected_group::
    argument () const
    {
      return argument_;
    }

    inline const std::string& unexpected_group::
    group () const
    {
      return group_;
    }

    // group_separator
    //
    inline group_separator::
    group_separator (const std::string& encountered,
                     const std::string& expected)
    : encountered_ (encountered), expected_ (expected)
    {
    }

    inline const std::string& group_separator::
    encountered () const
    {
      return encountered_;
    }

    inline const std::string& group_separator::
    expected () const
    {
      return expected_;
    }

    // argv_scanner
    //
    inline argv_scanner::
    argv_scanner (int& argc,
                  char** argv,
                  bool erase,
                  std::size_t sp)
    : start_position_ (sp + 1),
      i_ (1),
      argc_ (argc),
      argv_ (argv),
      erase_ (erase)
    {
    }

    inline argv_scanner::
    argv_scanner (int start,
                  int& argc,
                  char** argv,
                  bool erase,
                  std::size_t sp)
    : start_position_ (sp + static_cast<std::size_t> (start)),
      i_ (start),
      argc_ (argc),
      argv_ (argv),
      erase_ (erase)
    {
    }

    inline int argv_scanner::
    end () const
    {
      return i_;
    }

    // vector_scanner
    //
    inline vector_scanner::
    vector_scanner (const std::vector<std::string>& v,
                    std::size_t i,
                    std::size_t sp)
    : start_position_ (sp), v_ (v), i_ (i)
    {
    }

    inline std::size_t vector_scanner::
    end () const
    {
      return i_;
    }

    inline void vector_scanner::
    reset (std::size_t i, std::size_t sp)
    {
      i_ = i;
      start_position_ = sp;
    }

    // argv_file_scanner
    //
    inline argv_file_scanner::
    argv_file_scanner (int& argc,
                       char** argv,
                       const std::string& option,
                       bool erase,
                       std::size_t sp)
    : argv_scanner (argc, argv, erase, sp),
      option_ (option),
      options_ (&option_info_),
      options_count_ (1),
      i_ (1),
      skip_ (false)
    {
      option_info_.option = option_.c_str ();
      option_info_.search_func = 0;
    }

    inline argv_file_scanner::
    argv_file_scanner (int start,
                       int& argc,
                       char** argv,
                       const std::string& option,
                       bool erase,
                       std::size_t sp)
    : argv_scanner (start, argc, argv, erase, sp),
      option_ (option),
      options_ (&option_info_),
      options_count_ (1),
      i_ (1),
      skip_ (false)
    {
      option_info_.option = option_.c_str ();
      option_info_.search_func = 0;
    }

    inline argv_file_scanner::
    argv_file_scanner (const std::string& file,
                       const std::string& option,
                       std::size_t sp)
    : argv_scanner (0, zero_argc_, 0, sp),
      option_ (option),
      options_ (&option_info_),
      options_count_ (1),
      i_ (1),
      skip_ (false)
    {
      option_info_.option = option_.c_str ();
      option_info_.search_func = 0;

      load (file);
    }

    inline argv_file_scanner::
    argv_file_scanner (int& argc,
                       char** argv,
                       const option_info* options,
                       std::size_t options_count,
                       bool erase,
                       std::size_t sp)
    : argv_scanner (argc, argv, erase, sp),
      options_ (options),
      options_count_ (options_count),
      i_ (1),
      skip_ (false)
    {
    }

    inline argv_file_scanner::
    argv_file_scanner (int start,
                       int& argc,
                       char** argv,
                       const option_info* options,
                       std::size_t options_count,
                       bool erase,
                       std::size_t sp)
    : argv_scanner (start, argc, argv, erase, sp),
      options_ (options),
      options_count_ (options_count),
      i_ (1),
      skip_ (false)
    {
    }

    inline argv_file_scanner::
    argv_file_scanner (const std::string& file,
                       const option_info* options,
                       std::size_t options_count,
                       std::size_t sp)
    : argv_scanner (0, zero_argc_, 0, sp),
      options_ (options),
      options_count_ (options_count),
      i_ (1),
      skip_ (false)
    {
      load (file);
    }

    // group_scanner
    //
    inline group_scanner::
    group_scanner (scanner& s)
    : scan_ (s), state_ (skipped), i_ (1), j_ (0), group_scan_ (group_)
    {
    }

    inline scanner& group_scanner::
    group ()
    {
      assert (state_ == scanned || state_ == skipped);
      return group_scan_;
    }

    inline const char* group_scanner::
    escape (const char* a)
    {
      switch (sense (a))
      {
        case separator::none:       break;
        case separator::open:       return "\\{";
        case separator::close:      return "\\}";
        case separator::open_plus:  return "\\+{";
        case separator::close_plus: return "\\}+";
      }

      return a;
    }

    inline group_scanner::separator group_scanner::
    sense (const char* s)
    {
      switch (s[0])
      {
        case '{': return s[1] == '\0' ? open  : none;
        case '}':
        {
          switch (s[1])
          {
            case '+': return s[2] == '\0' ? close_plus  : none;
            default:  return s[1] == '\0' ? close       : none;
          }
        }
        case '+':
        {
          switch (s[1])
          {
            case '{': return s[2] == '\0' ? open_plus  : none;
            default:  return                             none;
          }
        }
      }

      return none;
    }
  }
}

namespace bpkg
{
  // common_options
  //

  inline const bool& common_options::
  v () const
  {
    return this->v_;
  }

  inline bool& common_options::
  v ()
  {
    return this->v_;
  }

  inline void common_options::
  v (const bool& x)
  {
    this->v_ = x;
  }

  inline const bool& common_options::
  V () const
  {
    return this->V_;
  }

  inline bool& common_options::
  V ()
  {
    return this->V_;
  }

  inline void common_options::
  V (const bool& x)
  {
    this->V_ = x;
  }

  inline const bool& common_options::
  quiet () const
  {
    return this->quiet_;
  }

  inline bool& common_options::
  quiet ()
  {
    return this->quiet_;
  }

  inline void common_options::
  quiet (const bool& x)
  {
    this->quiet_ = x;
  }

  inline const uint16_t& common_options::
  verbose () const
  {
    return this->verbose_;
  }

  inline uint16_t& common_options::
  verbose ()
  {
    return this->verbose_;
  }

  inline void common_options::
  verbose (const uint16_t& x)
  {
    this->verbose_ = x;
  }

  inline bool common_options::
  verbose_specified () const
  {
    return this->verbose_specified_;
  }

  inline void common_options::
  verbose_specified (bool x)
  {
    this->verbose_specified_ = x;
  }

  inline const bpkg::stdout_format& common_options::
  stdout_format () const
  {
    return this->stdout_format_;
  }

  inline bpkg::stdout_format& common_options::
  stdout_format ()
  {
    return this->stdout_format_;
  }

  inline void common_options::
  stdout_format (const bpkg::stdout_format& x)
  {
    this->stdout_format_ = x;
  }

  inline bool common_options::
  stdout_format_specified () const
  {
    return this->stdout_format_specified_;
  }

  inline void common_options::
  stdout_format_specified (bool x)
  {
    this->stdout_format_specified_ = x;
  }

  inline const int32_t& common_options::
  jobs () const
  {
    return this->jobs_;
  }

  inline int32_t& common_options::
  jobs ()
  {
    return this->jobs_;
  }

  inline void common_options::
  jobs (const int32_t& x)
  {
    this->jobs_ = x;
  }

  inline bool common_options::
  jobs_specified () const
  {
    return this->jobs_specified_;
  }

  inline void common_options::
  jobs_specified (bool x)
  {
    this->jobs_specified_ = x;
  }

  inline const bool& common_options::
  no_result () const
  {
    return this->no_result_;
  }

  inline bool& common_options::
  no_result ()
  {
    return this->no_result_;
  }

  inline void common_options::
  no_result (const bool& x)
  {
    this->no_result_ = x;
  }

  inline const string& common_options::
  structured_result () const
  {
    return this->structured_result_;
  }

  inline string& common_options::
  structured_result ()
  {
    return this->structured_result_;
  }

  inline void common_options::
  structured_result (const string& x)
  {
    this->structured_result_ = x;
  }

  inline bool common_options::
  structured_result_specified () const
  {
    return this->structured_result_specified_;
  }

  inline void common_options::
  structured_result_specified (bool x)
  {
    this->structured_result_specified_ = x;
  }

  inline const bool& common_options::
  progress () const
  {
    return this->progress_;
  }

  inline bool& common_options::
  progress ()
  {
    return this->progress_;
  }

  inline void common_options::
  progress (const bool& x)
  {
    this->progress_ = x;
  }

  inline const bool& common_options::
  no_progress () const
  {
    return this->no_progress_;
  }

  inline bool& common_options::
  no_progress ()
  {
    return this->no_progress_;
  }

  inline void common_options::
  no_progress (const bool& x)
  {
    this->no_progress_ = x;
  }

  inline const bool& common_options::
  diag_color () const
  {
    return this->diag_color_;
  }

  inline bool& common_options::
  diag_color ()
  {
    return this->diag_color_;
  }

  inline void common_options::
  diag_color (const bool& x)
  {
    this->diag_color_ = x;
  }

  inline const bool& common_options::
  no_diag_color () const
  {
    return this->no_diag_color_;
  }

  inline bool& common_options::
  no_diag_color ()
  {
    return this->no_diag_color_;
  }

  inline void common_options::
  no_diag_color (const bool& x)
  {
    this->no_diag_color_ = x;
  }

  inline const path& common_options::
  build () const
  {
    return this->build_;
  }

  inline path& common_options::
  build ()
  {
    return this->build_;
  }

  inline void common_options::
  build (const path& x)
  {
    this->build_ = x;
  }

  inline bool common_options::
  build_specified () const
  {
    return this->build_specified_;
  }

  inline void common_options::
  build_specified (bool x)
  {
    this->build_specified_ = x;
  }

  inline const strings& common_options::
  build_option () const
  {
    return this->build_option_;
  }

  inline strings& common_options::
  build_option ()
  {
    return this->build_option_;
  }

  inline void common_options::
  build_option (const strings& x)
  {
    this->build_option_ = x;
  }

  inline bool common_options::
  build_option_specified () const
  {
    return this->build_option_specified_;
  }

  inline void common_options::
  build_option_specified (bool x)
  {
    this->build_option_specified_ = x;
  }

  inline const path& common_options::
  fetch () const
  {
    return this->fetch_;
  }

  inline path& common_options::
  fetch ()
  {
    return this->fetch_;
  }

  inline void common_options::
  fetch (const path& x)
  {
    this->fetch_ = x;
  }

  inline bool common_options::
  fetch_specified () const
  {
    return this->fetch_specified_;
  }

  inline void common_options::
  fetch_specified (bool x)
  {
    this->fetch_specified_ = x;
  }

  inline const strings& common_options::
  fetch_option () const
  {
    return this->fetch_option_;
  }

  inline strings& common_options::
  fetch_option ()
  {
    return this->fetch_option_;
  }

  inline void common_options::
  fetch_option (const strings& x)
  {
    this->fetch_option_ = x;
  }

  inline bool common_options::
  fetch_option_specified () const
  {
    return this->fetch_option_specified_;
  }

  inline void common_options::
  fetch_option_specified (bool x)
  {
    this->fetch_option_specified_ = x;
  }

  inline const path& common_options::
  curl () const
  {
    return this->curl_;
  }

  inline path& common_options::
  curl ()
  {
    return this->curl_;
  }

  inline void common_options::
  curl (const path& x)
  {
    this->curl_ = x;
  }

  inline bool common_options::
  curl_specified () const
  {
    return this->curl_specified_;
  }

  inline void common_options::
  curl_specified (bool x)
  {
    this->curl_specified_ = x;
  }

  inline const strings& common_options::
  curl_option () const
  {
    return this->curl_option_;
  }

  inline strings& common_options::
  curl_option ()
  {
    return this->curl_option_;
  }

  inline void common_options::
  curl_option (const strings& x)
  {
    this->curl_option_ = x;
  }

  inline bool common_options::
  curl_option_specified () const
  {
    return this->curl_option_specified_;
  }

  inline void common_options::
  curl_option_specified (bool x)
  {
    this->curl_option_specified_ = x;
  }

  inline const size_t& common_options::
  fetch_timeout () const
  {
    return this->fetch_timeout_;
  }

  inline size_t& common_options::
  fetch_timeout ()
  {
    return this->fetch_timeout_;
  }

  inline void common_options::
  fetch_timeout (const size_t& x)
  {
    this->fetch_timeout_ = x;
  }

  inline bool common_options::
  fetch_timeout_specified () const
  {
    return this->fetch_timeout_specified_;
  }

  inline void common_options::
  fetch_timeout_specified (bool x)
  {
    this->fetch_timeout_specified_ = x;
  }

  inline const bool& common_options::
  offline () const
  {
    return this->offline_;
  }

  inline bool& common_options::
  offline ()
  {
    return this->offline_;
  }

  inline void common_options::
  offline (const bool& x)
  {
    this->offline_ = x;
  }

  inline const bool& common_options::
  no_fetch_cache () const
  {
    return this->no_fetch_cache_;
  }

  inline bool& common_options::
  no_fetch_cache ()
  {
    return this->no_fetch_cache_;
  }

  inline void common_options::
  no_fetch_cache (const bool& x)
  {
    this->no_fetch_cache_ = x;
  }

  inline const string& common_options::
  fetch_cache () const
  {
    return this->fetch_cache_;
  }

  inline string& common_options::
  fetch_cache ()
  {
    return this->fetch_cache_;
  }

  inline void common_options::
  fetch_cache (const string& x)
  {
    this->fetch_cache_ = x;
  }

  inline bool common_options::
  fetch_cache_specified () const
  {
    return this->fetch_cache_specified_;
  }

  inline void common_options::
  fetch_cache_specified (bool x)
  {
    this->fetch_cache_specified_ = x;
  }

  inline const dir_path& common_options::
  fetch_cache_path () const
  {
    return this->fetch_cache_path_;
  }

  inline dir_path& common_options::
  fetch_cache_path ()
  {
    return this->fetch_cache_path_;
  }

  inline void common_options::
  fetch_cache_path (const dir_path& x)
  {
    this->fetch_cache_path_ = x;
  }

  inline bool common_options::
  fetch_cache_path_specified () const
  {
    return this->fetch_cache_path_specified_;
  }

  inline void common_options::
  fetch_cache_path_specified (bool x)
  {
    this->fetch_cache_path_specified_ = x;
  }

  inline const string& common_options::
  fetch_cache_session () const
  {
    return this->fetch_cache_session_;
  }

  inline string& common_options::
  fetch_cache_session ()
  {
    return this->fetch_cache_session_;
  }

  inline void common_options::
  fetch_cache_session (const string& x)
  {
    this->fetch_cache_session_ = x;
  }

  inline bool common_options::
  fetch_cache_session_specified () const
  {
    return this->fetch_cache_session_specified_;
  }

  inline void common_options::
  fetch_cache_session_specified (bool x)
  {
    this->fetch_cache_session_specified_ = x;
  }

  inline const bpkg::sqlite_synchronous& common_options::
  sqlite_synchronous () const
  {
    return this->sqlite_synchronous_;
  }

  inline bpkg::sqlite_synchronous& common_options::
  sqlite_synchronous ()
  {
    return this->sqlite_synchronous_;
  }

  inline void common_options::
  sqlite_synchronous (const bpkg::sqlite_synchronous& x)
  {
    this->sqlite_synchronous_ = x;
  }

  inline bool common_options::
  sqlite_synchronous_specified () const
  {
    return this->sqlite_synchronous_specified_;
  }

  inline void common_options::
  sqlite_synchronous_specified (bool x)
  {
    this->sqlite_synchronous_specified_ = x;
  }

  inline const butl::url& common_options::
  pkg_proxy () const
  {
    return this->pkg_proxy_;
  }

  inline butl::url& common_options::
  pkg_proxy ()
  {
    return this->pkg_proxy_;
  }

  inline void common_options::
  pkg_proxy (const butl::url& x)
  {
    this->pkg_proxy_ = x;
  }

  inline bool common_options::
  pkg_proxy_specified () const
  {
    return this->pkg_proxy_specified_;
  }

  inline void common_options::
  pkg_proxy_specified (bool x)
  {
    this->pkg_proxy_specified_ = x;
  }

  inline const path& common_options::
  git () const
  {
    return this->git_;
  }

  inline path& common_options::
  git ()
  {
    return this->git_;
  }

  inline void common_options::
  git (const path& x)
  {
    this->git_ = x;
  }

  inline bool common_options::
  git_specified () const
  {
    return this->git_specified_;
  }

  inline void common_options::
  git_specified (bool x)
  {
    this->git_specified_ = x;
  }

  inline const strings& common_options::
  git_option () const
  {
    return this->git_option_;
  }

  inline strings& common_options::
  git_option ()
  {
    return this->git_option_;
  }

  inline void common_options::
  git_option (const strings& x)
  {
    this->git_option_ = x;
  }

  inline bool common_options::
  git_option_specified () const
  {
    return this->git_option_specified_;
  }

  inline void common_options::
  git_option_specified (bool x)
  {
    this->git_option_specified_ = x;
  }

  inline const path& common_options::
  sha256 () const
  {
    return this->sha256_;
  }

  inline path& common_options::
  sha256 ()
  {
    return this->sha256_;
  }

  inline void common_options::
  sha256 (const path& x)
  {
    this->sha256_ = x;
  }

  inline bool common_options::
  sha256_specified () const
  {
    return this->sha256_specified_;
  }

  inline void common_options::
  sha256_specified (bool x)
  {
    this->sha256_specified_ = x;
  }

  inline const strings& common_options::
  sha256_option () const
  {
    return this->sha256_option_;
  }

  inline strings& common_options::
  sha256_option ()
  {
    return this->sha256_option_;
  }

  inline void common_options::
  sha256_option (const strings& x)
  {
    this->sha256_option_ = x;
  }

  inline bool common_options::
  sha256_option_specified () const
  {
    return this->sha256_option_specified_;
  }

  inline void common_options::
  sha256_option_specified (bool x)
  {
    this->sha256_option_specified_ = x;
  }

  inline const path& common_options::
  tar () const
  {
    return this->tar_;
  }

  inline path& common_options::
  tar ()
  {
    return this->tar_;
  }

  inline void common_options::
  tar (const path& x)
  {
    this->tar_ = x;
  }

  inline bool common_options::
  tar_specified () const
  {
    return this->tar_specified_;
  }

  inline void common_options::
  tar_specified (bool x)
  {
    this->tar_specified_ = x;
  }

  inline const strings& common_options::
  tar_option () const
  {
    return this->tar_option_;
  }

  inline strings& common_options::
  tar_option ()
  {
    return this->tar_option_;
  }

  inline void common_options::
  tar_option (const strings& x)
  {
    this->tar_option_ = x;
  }

  inline bool common_options::
  tar_option_specified () const
  {
    return this->tar_option_specified_;
  }

  inline void common_options::
  tar_option_specified (bool x)
  {
    this->tar_option_specified_ = x;
  }

  inline const qualified_option<openssl_commands, path>& common_options::
  openssl () const
  {
    return this->openssl_;
  }

  inline qualified_option<openssl_commands, path>& common_options::
  openssl ()
  {
    return this->openssl_;
  }

  inline void common_options::
  openssl (const qualified_option<openssl_commands, path>& x)
  {
    this->openssl_ = x;
  }

  inline bool common_options::
  openssl_specified () const
  {
    return this->openssl_specified_;
  }

  inline void common_options::
  openssl_specified (bool x)
  {
    this->openssl_specified_ = x;
  }

  inline const qualified_option<openssl_commands, strings>& common_options::
  openssl_option () const
  {
    return this->openssl_option_;
  }

  inline qualified_option<openssl_commands, strings>& common_options::
  openssl_option ()
  {
    return this->openssl_option_;
  }

  inline void common_options::
  openssl_option (const qualified_option<openssl_commands, strings>& x)
  {
    this->openssl_option_ = x;
  }

  inline bool common_options::
  openssl_option_specified () const
  {
    return this->openssl_option_specified_;
  }

  inline void common_options::
  openssl_option_specified (bool x)
  {
    this->openssl_option_specified_ = x;
  }

  inline const bpkg::auth& common_options::
  auth () const
  {
    return this->auth_;
  }

  inline bpkg::auth& common_options::
  auth ()
  {
    return this->auth_;
  }

  inline void common_options::
  auth (const bpkg::auth& x)
  {
    this->auth_ = x;
  }

  inline bool common_options::
  auth_specified () const
  {
    return this->auth_specified_;
  }

  inline void common_options::
  auth_specified (bool x)
  {
    this->auth_specified_ = x;
  }

  inline const std::set<string, icase_compare_string>& common_options::
  trust () const
  {
    return this->trust_;
  }

  inline std::set<string, icase_compare_string>& common_options::
  trust ()
  {
    return this->trust_;
  }

  inline void common_options::
  trust (const std::set<string, icase_compare_string>& x)
  {
    this->trust_ = x;
  }

  inline bool common_options::
  trust_specified () const
  {
    return this->trust_specified_;
  }

  inline void common_options::
  trust_specified (bool x)
  {
    this->trust_specified_ = x;
  }

  inline const bool& common_options::
  trust_yes () const
  {
    return this->trust_yes_;
  }

  inline bool& common_options::
  trust_yes ()
  {
    return this->trust_yes_;
  }

  inline void common_options::
  trust_yes (const bool& x)
  {
    this->trust_yes_ = x;
  }

  inline const bool& common_options::
  trust_no () const
  {
    return this->trust_no_;
  }

  inline bool& common_options::
  trust_no ()
  {
    return this->trust_no_;
  }

  inline void common_options::
  trust_no (const bool& x)
  {
    this->trust_no_ = x;
  }

  inline const git_capabilities_map& common_options::
  git_capabilities () const
  {
    return this->git_capabilities_;
  }

  inline git_capabilities_map& common_options::
  git_capabilities ()
  {
    return this->git_capabilities_;
  }

  inline void common_options::
  git_capabilities (const git_capabilities_map& x)
  {
    this->git_capabilities_ = x;
  }

  inline bool common_options::
  git_capabilities_specified () const
  {
    return this->git_capabilities_specified_;
  }

  inline void common_options::
  git_capabilities_specified (bool x)
  {
    this->git_capabilities_specified_ = x;
  }

  inline const string& common_options::
  pager () const
  {
    return this->pager_;
  }

  inline string& common_options::
  pager ()
  {
    return this->pager_;
  }

  inline void common_options::
  pager (const string& x)
  {
    this->pager_ = x;
  }

  inline bool common_options::
  pager_specified () const
  {
    return this->pager_specified_;
  }

  inline void common_options::
  pager_specified (bool x)
  {
    this->pager_specified_ = x;
  }

  inline const strings& common_options::
  pager_option () const
  {
    return this->pager_option_;
  }

  inline strings& common_options::
  pager_option ()
  {
    return this->pager_option_;
  }

  inline void common_options::
  pager_option (const strings& x)
  {
    this->pager_option_ = x;
  }

  inline bool common_options::
  pager_option_specified () const
  {
    return this->pager_option_specified_;
  }

  inline void common_options::
  pager_option_specified (bool x)
  {
    this->pager_option_specified_ = x;
  }

  inline const string& common_options::
  options_file () const
  {
    return this->options_file_;
  }

  inline string& common_options::
  options_file ()
  {
    return this->options_file_;
  }

  inline void common_options::
  options_file (const string& x)
  {
    this->options_file_ = x;
  }

  inline bool common_options::
  options_file_specified () const
  {
    return this->options_file_specified_;
  }

  inline void common_options::
  options_file_specified (bool x)
  {
    this->options_file_specified_ = x;
  }

  inline const dir_path& common_options::
  default_options () const
  {
    return this->default_options_;
  }

  inline dir_path& common_options::
  default_options ()
  {
    return this->default_options_;
  }

  inline void common_options::
  default_options (const dir_path& x)
  {
    this->default_options_ = x;
  }

  inline bool common_options::
  default_options_specified () const
  {
    return this->default_options_specified_;
  }

  inline void common_options::
  default_options_specified (bool x)
  {
    this->default_options_specified_ = x;
  }

  inline const bool& common_options::
  no_default_options () const
  {
    return this->no_default_options_;
  }

  inline bool& common_options::
  no_default_options ()
  {
    return this->no_default_options_;
  }

  inline void common_options::
  no_default_options (const bool& x)
  {
    this->no_default_options_ = x;
  }

  inline const bool& common_options::
  keep_tmp () const
  {
    return this->keep_tmp_;
  }

  inline bool& common_options::
  keep_tmp ()
  {
    return this->keep_tmp_;
  }

  inline void common_options::
  keep_tmp (const bool& x)
  {
    this->keep_tmp_ = x;
  }
}

// Begin epilogue.
//
//
// End epilogue.
