// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bdep/types-parsers.hxx>
//
// End prologue.

#include <bdep/bdep-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bdep
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bdep
{
  // commands
  //

  commands::
  commands ()
  : help_ (),
    new__ (),
    init_ (),
    sync_ (),
    fetch_ (),
    status_ (),
    ci_ (),
    release_ (),
    publish_ (),
    deinit_ (),
    config_ (),
    test_ (),
    update_ (),
    clean_ ()
  {
  }

  bool commands::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool commands::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool commands::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool commands::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool commands::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void commands::
  merge (const commands& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.help_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->help_, a.help_);
    }

    if (a.new__)
    {
      ::bdep::cli::parser< bool>::merge (
        this->new__, a.new__);
    }

    if (a.init_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->init_, a.init_);
    }

    if (a.sync_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sync_, a.sync_);
    }

    if (a.fetch_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->fetch_, a.fetch_);
    }

    if (a.status_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->status_, a.status_);
    }

    if (a.ci_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->ci_, a.ci_);
    }

    if (a.release_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->release_, a.release_);
    }

    if (a.publish_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->publish_, a.publish_);
    }

    if (a.deinit_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->deinit_, a.deinit_);
    }

    if (a.config_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->config_, a.config_);
    }

    if (a.test_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->test_, a.test_);
    }

    if (a.update_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->update_, a.update_);
    }

    if (a.clean_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->clean_, a.clean_);
    }
  }

  ::bdep::cli::usage_para commands::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mCOMMANDS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1mhelp\033[0m [\033[4mtopic\033[0m]              \033[1mbdep-help(1)\033[0m -- show help for a command or help topic" << ::std::endl;

    os << "\033[1mnew\033[0m                       \033[1mbdep-new(1)\033[0m -- create and initialize new project" << ::std::endl;

    os << "\033[1minit\033[0m                      \033[1mbdep-init(1)\033[0m -- initialize project in build" << ::std::endl
       << "                          configurations" << ::std::endl;

    os << "\033[1msync\033[0m                      \033[1mbdep-sync(1)\033[0m -- synchronize project and build" << ::std::endl
       << "                          configurations" << ::std::endl;

    os << "\033[1mfetch\033[0m                     \033[1mbdep-fetch(1)\033[0m -- fetch list of available project" << ::std::endl
       << "                          dependencies" << ::std::endl;

    os << "\033[1mstatus\033[0m                    \033[1mbdep-status(1)\033[0m -- print status of project and/or its" << ::std::endl
       << "                          dependencies" << ::std::endl;

    os << "\033[1mci\033[0m                        \033[1mbdep-ci(1)\033[0m -- submit project test request to CI" << ::std::endl
       << "                          server" << ::std::endl;

    os << "\033[1mrelease\033[0m                   \033[1mbdep-release(1)\033[0m -- manage project's version during" << ::std::endl
       << "                          release" << ::std::endl;

    os << "\033[1mpublish\033[0m                   \033[1mbdep-publish(1)\033[0m -- publish project to archive" << ::std::endl
       << "                          repository" << ::std::endl;

    os << "\033[1mdeinit\033[0m                    \033[1mbdep-deinit(1)\033[0m -- deinitialize project in build" << ::std::endl
       << "                          configurations" << ::std::endl;

    os << "\033[1mconfig\033[0m                    \033[1mbdep-config(1)\033[0m -- manage project's build" << ::std::endl
       << "                          configurations" << ::std::endl;

    os << "\033[1mtest\033[0m                      \033[1mbdep-test(1)\033[0m -- test project in build configurations" << ::std::endl;

    os << "\033[1mupdate\033[0m                    \033[1mbdep-update(1)\033[0m -- update project in build" << ::std::endl
       << "                          configurations" << ::std::endl;

    os << "\033[1mclean\033[0m                     \033[1mbdep-clean(1)\033[0m -- clean project in build" << ::std::endl
       << "                          configurations" << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    return p;
  }

  struct _cli_commands_desc_type: ::bdep::cli::options
  {
    _cli_commands_desc_type ()
    {
      ::bdep::commands::fill (*this);
    }
  };

  void commands::
  fill (::bdep::cli::options& os)
  {
    // help
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("help", a, true, dv);
      os.push_back (o);
    }

    // new
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("new", a, true, dv);
      os.push_back (o);
    }

    // init
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("init", a, true, dv);
      os.push_back (o);
    }

    // sync
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("sync", a, true, dv);
      os.push_back (o);
    }

    // fetch
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("fetch", a, true, dv);
      os.push_back (o);
    }

    // status
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("status", a, true, dv);
      os.push_back (o);
    }

    // ci
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("ci", a, true, dv);
      os.push_back (o);
    }

    // release
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("release", a, true, dv);
      os.push_back (o);
    }

    // publish
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("publish", a, true, dv);
      os.push_back (o);
    }

    // deinit
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("deinit", a, true, dv);
      os.push_back (o);
    }

    // config
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("config", a, true, dv);
      os.push_back (o);
    }

    // test
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("test", a, true, dv);
      os.push_back (o);
    }

    // update
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("update", a, true, dv);
      os.push_back (o);
    }

    // clean
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("clean", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& commands::
  description ()
  {
    static _cli_commands_desc_type _cli_commands_desc_;
    return _cli_commands_desc_;
  }

  typedef
  std::map<std::string, void (*) (commands&, ::bdep::cli::scanner&)>
  _cli_commands_map;

  static _cli_commands_map _cli_commands_map_;

  struct _cli_commands_map_init
  {
    _cli_commands_map_init ()
    {
      _cli_commands_map_["help"] =
      &::bdep::cli::thunk< commands, &commands::help_ >;
      _cli_commands_map_["new"] =
      &::bdep::cli::thunk< commands, &commands::new__ >;
      _cli_commands_map_["init"] =
      &::bdep::cli::thunk< commands, &commands::init_ >;
      _cli_commands_map_["sync"] =
      &::bdep::cli::thunk< commands, &commands::sync_ >;
      _cli_commands_map_["fetch"] =
      &::bdep::cli::thunk< commands, &commands::fetch_ >;
      _cli_commands_map_["status"] =
      &::bdep::cli::thunk< commands, &commands::status_ >;
      _cli_commands_map_["ci"] =
      &::bdep::cli::thunk< commands, &commands::ci_ >;
      _cli_commands_map_["release"] =
      &::bdep::cli::thunk< commands, &commands::release_ >;
      _cli_commands_map_["publish"] =
      &::bdep::cli::thunk< commands, &commands::publish_ >;
      _cli_commands_map_["deinit"] =
      &::bdep::cli::thunk< commands, &commands::deinit_ >;
      _cli_commands_map_["config"] =
      &::bdep::cli::thunk< commands, &commands::config_ >;
      _cli_commands_map_["test"] =
      &::bdep::cli::thunk< commands, &commands::test_ >;
      _cli_commands_map_["update"] =
      &::bdep::cli::thunk< commands, &commands::update_ >;
      _cli_commands_map_["clean"] =
      &::bdep::cli::thunk< commands, &commands::clean_ >;
    }
  };

  static _cli_commands_map_init _cli_commands_map_init_;

  bool commands::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_commands_map::const_iterator i (_cli_commands_map_.find (o));

    if (i != _cli_commands_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool commands::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // topics
  //

  topics::
  topics ()
  : common_options_ (),
    projects_configs_ (),
    default_options_files_ (),
    argument_grouping_ ()
  {
  }

  bool topics::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool topics::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool topics::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool topics::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool topics::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void topics::
  merge (const topics& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.common_options_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->common_options_, a.common_options_);
    }

    if (a.projects_configs_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->projects_configs_, a.projects_configs_);
    }

    if (a.default_options_files_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->default_options_files_, a.default_options_files_);
    }

    if (a.argument_grouping_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->argument_grouping_, a.argument_grouping_);
    }
  }

  ::bdep::cli::usage_para topics::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mHELP TOPICS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1mcommon-options\033[0m            \033[1mbdep-common-options(1)\033[0m -- details on common options" << ::std::endl;

    os << "\033[1mprojects-configs\033[0m          \033[1mbdep-projects-configs(1)\033[0m -- specifying projects and" << ::std::endl
       << "                          configurations" << ::std::endl;

    os << "\033[1mdefault-options-files\033[0m     \033[1mbdep-default-options-files(1)\033[0m -- specifying default" << ::std::endl
       << "                          options" << ::std::endl;

    os << "\033[1margument-grouping\033[0m         \033[1mbdep-argument-grouping(1)\033[0m -- argument grouping" << ::std::endl
       << "                          facility" << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    return p;
  }

  struct _cli_topics_desc_type: ::bdep::cli::options
  {
    _cli_topics_desc_type ()
    {
      ::bdep::topics::fill (*this);
    }
  };

  void topics::
  fill (::bdep::cli::options& os)
  {
    // common-options
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("common-options", a, true, dv);
      os.push_back (o);
    }

    // projects-configs
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("projects-configs", a, true, dv);
      os.push_back (o);
    }

    // default-options-files
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("default-options-files", a, true, dv);
      os.push_back (o);
    }

    // argument-grouping
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("argument-grouping", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& topics::
  description ()
  {
    static _cli_topics_desc_type _cli_topics_desc_;
    return _cli_topics_desc_;
  }

  typedef
  std::map<std::string, void (*) (topics&, ::bdep::cli::scanner&)>
  _cli_topics_map;

  static _cli_topics_map _cli_topics_map_;

  struct _cli_topics_map_init
  {
    _cli_topics_map_init ()
    {
      _cli_topics_map_["common-options"] =
      &::bdep::cli::thunk< topics, &topics::common_options_ >;
      _cli_topics_map_["projects-configs"] =
      &::bdep::cli::thunk< topics, &topics::projects_configs_ >;
      _cli_topics_map_["default-options-files"] =
      &::bdep::cli::thunk< topics, &topics::default_options_files_ >;
      _cli_topics_map_["argument-grouping"] =
      &::bdep::cli::thunk< topics, &topics::argument_grouping_ >;
    }
  };

  static _cli_topics_map_init _cli_topics_map_init_;

  bool topics::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_topics_map::const_iterator i (_cli_topics_map_.find (o));

    if (i != _cli_topics_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool topics::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // options
  //

  options::
  options ()
  : help_ (),
    version_ ()
  {
  }

  bool options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void options::
  merge (const options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // common_options base
    //
    ::bdep::common_options::merge (a);

    if (a.help_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->help_, a.help_);
    }

    if (a.version_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->version_, a.version_);
    }
  }

  ::bdep::cli::usage_para options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    // common_options base
    //
    p = ::bdep::common_options::print_usage (os, p);

    return p;
  }

  struct _cli_options_desc_type: ::bdep::cli::options
  {
    _cli_options_desc_type ()
    {
      ::bdep::options::fill (*this);
    }
  };

  void options::
  fill (::bdep::cli::options& os)
  {
    // common_options base
    //
    ::bdep::common_options::fill (os);

    // --help
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--help", a, true, dv);
      os.push_back (o);
    }

    // --version
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--version", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& options::
  description ()
  {
    static _cli_options_desc_type _cli_options_desc_;
    return _cli_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (options&, ::bdep::cli::scanner&)>
  _cli_options_map;

  static _cli_options_map _cli_options_map_;

  struct _cli_options_map_init
  {
    _cli_options_map_init ()
    {
      _cli_options_map_["--help"] =
      &::bdep::cli::thunk< options, &options::help_ >;
      _cli_options_map_["--version"] =
      &::bdep::cli::thunk< options, &options::version_ >;
    }
  };

  static _cli_options_map_init _cli_options_map_init_;

  bool options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_options_map::const_iterator i (_cli_options_map_.find (o));

    if (i != _cli_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // common_options base
    //
    if (::bdep::common_options::_parse (o, s))
      return true;

    return false;
  }

  bool options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bdep
{
  ::bdep::cli::usage_para
  print_bdep_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbdep --help\033[0m" << ::std::endl
       << "\033[1mbdep --version\033[0m" << ::std::endl
       << "\033[1mbdep help\033[0m [\033[4mcommand\033[0m | \033[4mtopic\033[0m]" << ::std::endl
       << "\033[1mbdep\033[0m [\033[4mcommon-options\033[0m] \033[4mcommand\033[0m [\033[4mcommand-options\033[0m] \033[4mcommand-args\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mbuild2\033[0m project dependency manager is used to manage the dependencies of a" << ::std::endl
       << "project during development." << ::std::endl
       << ::std::endl
       << "For a detailed description of any command or help topic, use the \033[1mhelp\033[0m command" << ::std::endl
       << "or see the corresponding man page (the man pages have the \033[1mbdep-\033[0m prefix, for" << ::std::endl
       << "example \033[1mbdep-help(1)\033[0m). Note also that \033[4mcommand-options\033[0m and \033[4mcommand-args\033[0m can be" << ::std::endl
       << "specified in any order and \033[4mcommon-options\033[0m can be specified as part of" << ::std::endl
       << "\033[4mcommand-options\033[0m." << ::std::endl;

    p = ::bdep::commands::print_usage (os, ::bdep::cli::usage_para::text);

    p = ::bdep::topics::print_usage (os, p);

    p = ::bdep::options::print_usage (os, p);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mEXIT STATUS\033[0m" << ::std::endl
       << ::std::endl
       << "Non-zero exit status is returned in case of an error." << ::std::endl
       << ::std::endl
       << "\033[1mENVIRONMENT\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mBDEP_DEF_OPT\033[0m environment variable is used to suppress loading of default" << ::std::endl
       << "options files in nested \033[1mbdep\033[0m invocations. Its values are \033[1mfalse\033[0m or \033[1m0\033[0m to suppress" << ::std::endl
       << "and \033[1mtrue\033[0m or \033[1m1\033[0m to load." << ::std::endl
       << ::std::endl
       << "The \033[1mBUILD2_SQLITE_SYNCHRONOUS\033[0m environment variable can be used to select the" << ::std::endl
       << "filesystem synchronization mode for the project SQLite database. See the" << ::std::endl
       << "description of the \033[1m--sqlite-synchronous\033[0m option in \033[1mbdep-common-options(1)\033[0m for" << ::std::endl
       << "the list of valid values and details on their semantics." << ::std::endl;

    p = ::bdep::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

