// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#ifndef BPKG_FETCH_CACHE_DATA_ODB_HXX
#define BPKG_FETCH_CACHE_DATA_ODB_HXX

#include <odb/version.hxx>

#if ODB_VERSION != 20500UL
#error ODB runtime version mismatch
#endif

#include <odb/pre.hxx>

#include <bpkg/fetch-cache-data.hxx>

#include <bpkg/package-common-odb.hxx>

#include <memory>
#include <cstddef>
#include <utility>

#include <odb/core.hxx>
#include <odb/traits.hxx>
#include <odb/callback.hxx>
#include <odb/wrapper-traits.hxx>
#include <odb/pointer-traits.hxx>
#include <odb/container-traits.hxx>
#include <odb/no-op-cache-traits.hxx>
#include <odb/result.hxx>
#include <odb/simple-object-result.hxx>
#include <odb/view-image.hxx>
#include <odb/view-result.hxx>

#include <odb/details/unused.hxx>
#include <odb/details/shared-ptr.hxx>

namespace odb
{
  // pkg_repository_auth
  //
  template <>
  struct class_traits< ::bpkg::pkg_repository_auth >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::pkg_repository_auth >
  {
    public:
    typedef ::bpkg::pkg_repository_auth object_type;
    typedef ::std::unique_ptr< ::bpkg::pkg_repository_auth > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::std::string id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    no_op_pointer_cache_traits<pointer_type>
    pointer_cache_traits;

    typedef
    no_op_reference_cache_traits<object_type>
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // pkg_repository_auth_count
  //
  template <>
  struct class_traits< ::bpkg::pkg_repository_auth_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::pkg_repository_auth_count >
  {
    public:
    typedef ::bpkg::pkg_repository_auth_count view_type;
    typedef ::bpkg::pkg_repository_auth_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // pkg_repository_metadata
  //
  template <>
  struct class_traits< ::bpkg::pkg_repository_metadata >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::pkg_repository_metadata >
  {
    public:
    typedef ::bpkg::pkg_repository_metadata object_type;
    typedef ::std::unique_ptr< ::bpkg::pkg_repository_metadata > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::bpkg::repository_url id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    no_op_pointer_cache_traits<pointer_type>
    pointer_cache_traits;

    typedef
    no_op_reference_cache_traits<object_type>
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // pkg_repository_package
  //
  template <>
  struct class_traits< ::bpkg::pkg_repository_package >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::pkg_repository_package >
  {
    public:
    typedef ::bpkg::pkg_repository_package object_type;
    typedef ::std::unique_ptr< ::bpkg::pkg_repository_package > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::bpkg::package_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    no_op_pointer_cache_traits<pointer_type>
    pointer_cache_traits;

    typedef
    no_op_reference_cache_traits<object_type>
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // git_repository_state
  //
  template <>
  struct class_traits< ::bpkg::git_repository_state >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::git_repository_state >
  {
    public:
    typedef ::bpkg::git_repository_state object_type;
    typedef ::std::unique_ptr< ::bpkg::git_repository_state > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::bpkg::repository_url id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    no_op_pointer_cache_traits<pointer_type>
    pointer_cache_traits;

    typedef
    no_op_reference_cache_traits<object_type>
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // shared_source_directory
  //
  template <>
  struct class_traits< ::bpkg::shared_source_directory >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::shared_source_directory >
  {
    public:
    typedef ::bpkg::shared_source_directory object_type;
    typedef ::std::unique_ptr< ::bpkg::shared_source_directory > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::bpkg::package_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    no_op_pointer_cache_traits<pointer_type>
    pointer_cache_traits;

    typedef
    no_op_reference_cache_traits<object_type>
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };
}

#include <odb/details/buffer.hxx>

#include <odb/sqlite/version.hxx>
#include <odb/sqlite/forward.hxx>
#include <odb/sqlite/binding.hxx>
#include <odb/sqlite/sqlite-types.hxx>
#include <odb/sqlite/query.hxx>

namespace odb
{
  // pkg_repository_auth
  //
  template <typename A>
  struct query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >
  {
    // id
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    id_type_;

    static const id_type_ id;

    // fingerprint
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    fingerprint_type_;

    static const fingerprint_type_ fingerprint;

    // name
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    name_type_;

    static const name_type_ name;

    // end_date
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::odb::wrapper_traits_for_optional_uint64_t::wrapped_type,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    end_date_type_;

    static const end_date_type_ end_date;
  };

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >::id_type_
  query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >::
  id (A::table_name, "\"id\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >::fingerprint_type_
  query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >::
  fingerprint (A::table_name, "\"fingerprint\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >::name_type_
  query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >::
  name (A::table_name, "\"name\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >::end_date_type_
  query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >::
  end_date (A::table_name, "\"end_date\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >:
    query_columns< ::bpkg::pkg_repository_auth, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::pkg_repository_auth, id_sqlite >:
    public access::object_traits< ::bpkg::pkg_repository_auth >
  {
    public:
    struct id_image_type
    {
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      // fingerprint
      //
      details::buffer fingerprint_value;
      std::size_t fingerprint_size;
      bool fingerprint_null;

      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // end_date
      //
      long long end_date_value;
      bool end_date_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 4UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::pkg_repository_auth, id_common >:
    public access::object_traits_impl< ::bpkg::pkg_repository_auth, id_sqlite >
  {
  };

  // pkg_repository_auth_count
  //
  template <>
  class access::view_traits_impl< ::bpkg::pkg_repository_auth_count, id_sqlite >:
    public access::view_traits< ::bpkg::pkg_repository_auth_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::pkg_repository_auth_count, id_common >:
    public access::view_traits_impl< ::bpkg::pkg_repository_auth_count, id_sqlite >
  {
  };

  // pkg_repository_metadata
  //
  template <typename A>
  struct query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >
  {
    // url
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::bpkg::repository_url,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    url_type_;

    static const url_type_ url;

    // directory
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    directory_type_;

    static const directory_type_ directory;

    // session
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    session_type_;

    static const session_type_ session;

    // access_time
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::uint64_t,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    access_time_type_;

    static const access_time_type_ access_time;

    // repositories_path
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    repositories_path_type_;

    static const repositories_path_type_ repositories_path;

    // repositories_checksum
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    repositories_checksum_type_;

    static const repositories_checksum_type_ repositories_checksum;

    // packages_path
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    packages_path_type_;

    static const packages_path_type_ packages_path;

    // packages_checksum
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    packages_checksum_type_;

    static const packages_checksum_type_ packages_checksum;
  };

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::url_type_
  query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::
  url (A::table_name, "\"url\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::directory_type_
  query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::
  directory (A::table_name, "\"directory\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::session_type_
  query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::
  session (A::table_name, "\"session\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::access_time_type_
  query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::
  access_time (A::table_name, "\"access_time\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::repositories_path_type_
  query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::
  repositories_path (A::table_name, "\"repositories_path\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::repositories_checksum_type_
  query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::
  repositories_checksum (A::table_name, "\"repositories_checksum\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::packages_path_type_
  query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::
  packages_path (A::table_name, "\"packages_path\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::packages_checksum_type_
  query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >::
  packages_checksum (A::table_name, "\"packages_checksum\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >:
    query_columns< ::bpkg::pkg_repository_metadata, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::pkg_repository_metadata, id_sqlite >:
    public access::object_traits< ::bpkg::pkg_repository_metadata >
  {
    public:
    struct id_image_type
    {
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // url
      //
      details::buffer url_value;
      std::size_t url_size;
      bool url_null;

      // directory
      //
      details::buffer directory_value;
      std::size_t directory_size;
      bool directory_null;

      // session
      //
      details::buffer session_value;
      std::size_t session_size;
      bool session_null;

      // access_time
      //
      long long access_time_value;
      bool access_time_null;

      // repositories_path
      //
      details::buffer repositories_path_value;
      std::size_t repositories_path_size;
      bool repositories_path_null;

      // repositories_checksum
      //
      details::buffer repositories_checksum_value;
      std::size_t repositories_checksum_size;
      bool repositories_checksum_null;

      // packages_path
      //
      details::buffer packages_path_value;
      std::size_t packages_path_size;
      bool packages_path_null;

      // packages_checksum
      //
      details::buffer packages_checksum_value;
      std::size_t packages_checksum_size;
      bool packages_checksum_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 8UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::pkg_repository_metadata, id_common >:
    public access::object_traits_impl< ::bpkg::pkg_repository_metadata, id_sqlite >
  {
  };

  // pkg_repository_package
  //
  template <typename A>
  struct query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // name
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      name_type_;

      static const name_type_ name;

      // version
      //
      struct version_class_1_
      {
        version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::uint16_t,
            sqlite::id_integer >::query_type,
          sqlite::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::std::string,
            sqlite::id_text >::query_type,
          sqlite::id_text >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::std::string,
            sqlite::id_text >::query_type,
          sqlite::id_text >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::uint16_t,
            sqlite::id_integer >::query_type,
          sqlite::id_integer >
        revision_type_;

        static const revision_type_ revision;

        // iteration
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::uint32_t,
            sqlite::id_integer >::query_type,
          sqlite::id_integer >
        iteration_type_;

        static const iteration_type_ iteration;
      };

      static const version_class_1_ version;
    };

    static const id_class_ id;

    // version
    //
    struct version_class_
    {
      version_class_ ()
      {
      }

      // upstream
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::basic_string< char >,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      release_type_;

      static const release_type_ release;
    };

    static const version_class_ version;

    // access_time
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::uint64_t,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    access_time_type_;

    static const access_time_type_ access_time;

    // archive
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    archive_type_;

    static const archive_type_ archive;

    // checksum
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    checksum_type_;

    static const checksum_type_ checksum;

    // repository
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::bpkg::repository_url,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    repository_type_;

    static const repository_type_ repository;
  };

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::name_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::
  name (A::table_name, "\"name\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::epoch_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::
  epoch (A::table_name, "\"version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::canonical_upstream_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::
  canonical_upstream (A::table_name, "\"version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::canonical_release_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::
  canonical_release (A::table_name, "\"version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::revision_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::
  revision (A::table_name, "\"version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::iteration_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_::
  iteration (A::table_name, "\"version_iteration\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version_class_1_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_::version;

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id_class_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::id;

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::version_class_::upstream_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::version_class_::
  upstream (A::table_name, "\"version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::version_class_::release_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::version_class_::
  release (A::table_name, "\"version_release\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::version_class_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::version;

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::access_time_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::
  access_time (A::table_name, "\"access_time\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::archive_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::
  archive (A::table_name, "\"archive\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::checksum_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::
  checksum (A::table_name, "\"checksum\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::repository_type_
  query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >::
  repository (A::table_name, "\"repository\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >:
    query_columns< ::bpkg::pkg_repository_package, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::pkg_repository_package, id_sqlite >:
    public access::object_traits< ::bpkg::pkg_repository_package >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::bpkg::package_id, id_sqlite >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::bpkg::package_id, id_sqlite >::image_type id_value;

      // version
      //
      composite_value_traits< ::bpkg::original_version, id_sqlite >::image_type version_value;

      // access_time
      //
      long long access_time_value;
      bool access_time_null;

      // archive
      //
      details::buffer archive_value;
      std::size_t archive_size;
      bool archive_null;

      // checksum
      //
      details::buffer checksum_value;
      std::size_t checksum_size;
      bool checksum_null;

      // repository
      //
      details::buffer repository_value;
      std::size_t repository_size;
      bool repository_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 12UL;
    static const std::size_t id_column_count = 6UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::pkg_repository_package, id_common >:
    public access::object_traits_impl< ::bpkg::pkg_repository_package, id_sqlite >
  {
  };

  // git_repository_state
  //
  template <typename A>
  struct query_columns< ::bpkg::git_repository_state, id_sqlite, A >
  {
    // url
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::bpkg::repository_url,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    url_type_;

    static const url_type_ url;

    // directory
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    directory_type_;

    static const directory_type_ directory;

    // session
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    session_type_;

    static const session_type_ session;

    // access_time
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::uint64_t,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    access_time_type_;

    static const access_time_type_ access_time;
  };

  template <typename A>
  const typename query_columns< ::bpkg::git_repository_state, id_sqlite, A >::url_type_
  query_columns< ::bpkg::git_repository_state, id_sqlite, A >::
  url (A::table_name, "\"url\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::git_repository_state, id_sqlite, A >::directory_type_
  query_columns< ::bpkg::git_repository_state, id_sqlite, A >::
  directory (A::table_name, "\"directory\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::git_repository_state, id_sqlite, A >::session_type_
  query_columns< ::bpkg::git_repository_state, id_sqlite, A >::
  session (A::table_name, "\"session\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::git_repository_state, id_sqlite, A >::access_time_type_
  query_columns< ::bpkg::git_repository_state, id_sqlite, A >::
  access_time (A::table_name, "\"access_time\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::git_repository_state, id_sqlite, A >:
    query_columns< ::bpkg::git_repository_state, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::git_repository_state, id_sqlite >:
    public access::object_traits< ::bpkg::git_repository_state >
  {
    public:
    struct id_image_type
    {
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // url
      //
      details::buffer url_value;
      std::size_t url_size;
      bool url_null;

      // directory
      //
      details::buffer directory_value;
      std::size_t directory_size;
      bool directory_null;

      // session
      //
      details::buffer session_value;
      std::size_t session_size;
      bool session_null;

      // access_time
      //
      long long access_time_value;
      bool access_time_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 4UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::git_repository_state, id_common >:
    public access::object_traits_impl< ::bpkg::git_repository_state, id_sqlite >
  {
  };

  // shared_source_directory
  //
  template <typename A>
  struct query_columns< ::bpkg::shared_source_directory, id_sqlite, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // name
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      name_type_;

      static const name_type_ name;

      // version
      //
      struct version_class_1_
      {
        version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::uint16_t,
            sqlite::id_integer >::query_type,
          sqlite::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::std::string,
            sqlite::id_text >::query_type,
          sqlite::id_text >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::std::string,
            sqlite::id_text >::query_type,
          sqlite::id_text >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::uint16_t,
            sqlite::id_integer >::query_type,
          sqlite::id_integer >
        revision_type_;

        static const revision_type_ revision;

        // iteration
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::uint32_t,
            sqlite::id_integer >::query_type,
          sqlite::id_integer >
        iteration_type_;

        static const iteration_type_ iteration;
      };

      static const version_class_1_ version;
    };

    static const id_class_ id;

    // version
    //
    struct version_class_
    {
      version_class_ ()
      {
      }

      // upstream
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::basic_string< char >,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      release_type_;

      static const release_type_ release;
    };

    static const version_class_ version;

    // access_time
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::uint64_t,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    access_time_type_;

    static const access_time_type_ access_time;

    // directory
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    directory_type_;

    static const directory_type_ directory;

    // repository
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::bpkg::repository_url,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    repository_type_;

    static const repository_type_ repository;

    // origin_id
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    origin_id_type_;

    static const origin_id_type_ origin_id;

    // src_root_file
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    src_root_file_type_;

    static const src_root_file_type_ src_root_file;
  };

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::name_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::
  name (A::table_name, "\"name\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::epoch_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::
  epoch (A::table_name, "\"version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::canonical_upstream_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::
  canonical_upstream (A::table_name, "\"version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::canonical_release_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::
  canonical_release (A::table_name, "\"version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::revision_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::
  revision (A::table_name, "\"version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::iteration_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_::
  iteration (A::table_name, "\"version_iteration\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version_class_1_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_::version;

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id_class_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::id;

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::version_class_::upstream_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::version_class_::
  upstream (A::table_name, "\"version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::version_class_::release_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::version_class_::
  release (A::table_name, "\"version_release\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::version_class_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::version;

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::access_time_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::
  access_time (A::table_name, "\"access_time\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::directory_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::
  directory (A::table_name, "\"directory\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::repository_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::
  repository (A::table_name, "\"repository\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::origin_id_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::
  origin_id (A::table_name, "\"origin_id\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::src_root_file_type_
  query_columns< ::bpkg::shared_source_directory, id_sqlite, A >::
  src_root_file (A::table_name, "\"src_root_file\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::shared_source_directory, id_sqlite, A >:
    query_columns< ::bpkg::shared_source_directory, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::shared_source_directory, id_sqlite >:
    public access::object_traits< ::bpkg::shared_source_directory >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::bpkg::package_id, id_sqlite >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::bpkg::package_id, id_sqlite >::image_type id_value;

      // version
      //
      composite_value_traits< ::bpkg::original_version, id_sqlite >::image_type version_value;

      // access_time
      //
      long long access_time_value;
      bool access_time_null;

      // directory
      //
      details::buffer directory_value;
      std::size_t directory_size;
      bool directory_null;

      // repository
      //
      details::buffer repository_value;
      std::size_t repository_size;
      bool repository_null;

      // origin_id
      //
      details::buffer origin_id_value;
      std::size_t origin_id_size;
      bool origin_id_null;

      // src_root_file
      //
      details::buffer src_root_file_value;
      std::size_t src_root_file_size;
      bool src_root_file_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    // untracked_configurations
    //
    struct untracked_configurations_traits
    {
      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 7UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::bpkg::paths container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< untracked_configurations_traits > statements_type;

      struct data_image_type
      {
        // value
        //
        details::buffer value_value;
        std::size_t value_size;
        bool value_null;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const value_type&);

      static void
      init (value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // untracked_configurations_section
    //
    struct untracked_configurations_section_traits
    {
      typedef object_traits_impl<object_type, id_sqlite>::image_type image_type;
      typedef object_traits_impl<object_type, id_sqlite>::id_image_type id_image_type;

      static const std::size_t id_column_count = 6UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);

      static void
      update (extra_statement_cache_type&, const object_type&);
    };

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 13UL;
    static const std::size_t id_column_count = 6UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static bool
    load (connection&, object_type&, section&);

    static bool
    update (connection&, const object_type&, const section&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::shared_source_directory, id_common >:
    public access::object_traits_impl< ::bpkg::shared_source_directory, id_sqlite >
  {
  };

  // pkg_repository_auth
  //
  // pkg_repository_auth_count
  //
  struct access::view_traits_impl< ::bpkg::pkg_repository_auth_count, id_sqlite >::query_columns:
    odb::pointer_query_columns<
      ::bpkg::pkg_repository_auth,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::pkg_repository_auth, id_sqlite > >
  {
  };

  // pkg_repository_metadata
  //
  // pkg_repository_package
  //
  // git_repository_state
  //
  // shared_source_directory
  //
}

#include <bpkg/fetch-cache-data-odb.ixx>

#include <odb/post.hxx>

#endif // BPKG_FETCH_CACHE_DATA_ODB_HXX
