// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <libbuild2/types-parsers.hxx>
//
// End prologue.

#include <libbuild2/b-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace build2
{
  namespace build
  {
    namespace cli
    {
      template <typename X>
      struct parser
      {
        static void
        parse (X& x, bool& xs, scanner& s)
        {
          using namespace std;

          const char* o (s.next ());
          if (s.more ())
          {
            string v (s.next ());
            istringstream is (v);
            if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
              throw invalid_value (o, v);
          }
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (X& b, const X& a)
        {
          b = a;
        }
      };

      template <>
      struct parser<bool>
      {
        static void
        parse (bool& x, bool& xs, scanner& s)
        {
          const char* o (s.next ());

          if (s.more ())
          {
            const char* v (s.next ());

            if (std::strcmp (v, "1")    == 0 ||
                std::strcmp (v, "true") == 0 ||
                std::strcmp (v, "TRUE") == 0 ||
                std::strcmp (v, "True") == 0)
              x = true;
            else if (std::strcmp (v, "0")     == 0 ||
                     std::strcmp (v, "false") == 0 ||
                     std::strcmp (v, "FALSE") == 0 ||
                     std::strcmp (v, "False") == 0)
              x = false;
            else
              throw invalid_value (o, v);
          }
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (bool& b, const bool&)
        {
          b = true;
        }
      };

      template <>
      struct parser<std::string>
      {
        static void
        parse (std::string& x, bool& xs, scanner& s)
        {
          const char* o (s.next ());

          if (s.more ())
            x = s.next ();
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (std::string& b, const std::string& a)
        {
          b = a;
        }
      };

      template <typename X>
      struct parser<std::pair<X, std::size_t> >
      {
        static void
        parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
        {
          x.second = s.position ();
          parser<X>::parse (x.first, xs, s);
        }

        static void
        merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
        {
          b = a;
        }
      };

      template <typename X>
      struct parser<std::vector<X> >
      {
        static void
        parse (std::vector<X>& c, bool& xs, scanner& s)
        {
          X x;
          bool dummy;
          parser<X>::parse (x, dummy, s);
          c.push_back (x);
          xs = true;
        }

        static void
        merge (std::vector<X>& b, const std::vector<X>& a)
        {
          b.insert (b.end (), a.begin (), a.end ());
        }
      };

      template <typename X, typename C>
      struct parser<std::set<X, C> >
      {
        static void
        parse (std::set<X, C>& c, bool& xs, scanner& s)
        {
          X x;
          bool dummy;
          parser<X>::parse (x, dummy, s);
          c.insert (x);
          xs = true;
        }

        static void
        merge (std::set<X, C>& b, const std::set<X, C>& a)
        {
          b.insert (a.begin (), a.end ());
        }
      };

      template <typename K, typename V, typename C>
      struct parser<std::map<K, V, C> >
      {
        static void
        parse (std::map<K, V, C>& m, bool& xs, scanner& s)
        {
          const char* o (s.next ());

          if (s.more ())
          {
            std::size_t pos (s.position ());
            std::string ov (s.next ());
            std::string::size_type p = ov.find ('=');

            K k = K ();
            V v = V ();
            std::string kstr (ov, 0, p);
            std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (o),
              0
            };

            bool dummy;
            if (!kstr.empty ())
            {
              av[1] = const_cast<char*> (kstr.c_str ());
              argv_scanner s (0, ac, av, false, pos);
              parser<K>::parse (k, dummy, s);
            }

            if (!vstr.empty ())
            {
              av[1] = const_cast<char*> (vstr.c_str ());
              argv_scanner s (0, ac, av, false, pos);
              parser<V>::parse (v, dummy, s);
            }

            m[k] = v;
          }
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
        {
          for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
               i != a.end (); 
               ++i)
            b[i->first] = i->second;
        }
      };

      template <typename K, typename V, typename C>
      struct parser<std::multimap<K, V, C> >
      {
        static void
        parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
        {
          const char* o (s.next ());

          if (s.more ())
          {
            std::size_t pos (s.position ());
            std::string ov (s.next ());
            std::string::size_type p = ov.find ('=');

            K k = K ();
            V v = V ();
            std::string kstr (ov, 0, p);
            std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (o),
              0
            };

            bool dummy;
            if (!kstr.empty ())
            {
              av[1] = const_cast<char*> (kstr.c_str ());
              argv_scanner s (0, ac, av, false, pos);
              parser<K>::parse (k, dummy, s);
            }

            if (!vstr.empty ())
            {
              av[1] = const_cast<char*> (vstr.c_str ());
              argv_scanner s (0, ac, av, false, pos);
              parser<V>::parse (v, dummy, s);
            }

            m.insert (typename std::multimap<K, V, C>::value_type (k, v));
          }
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
        {
          for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
               i != a.end (); 
               ++i)
            b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                   i->second));
        }
      };

      template <typename X, typename T, T X::*M>
      void
      thunk (X& x, scanner& s)
      {
        parser<T>::parse (x.*M, s);
      }

      template <typename X, bool X::*M>
      void
      thunk (X& x, scanner& s)
      {
        s.next ();
        x.*M = true;
      }

      template <typename X, typename T, T X::*M, bool X::*S>
      void
      thunk (X& x, scanner& s)
      {
        parser<T>::parse (x.*M, x.*S, s);
      }
    }
  }
}

#include <map>

namespace build2
{
  // b_options
  //

  b_options::
  b_options ()
  : build2_metadata_ (),
    build2_metadata_specified_ (false),
    v_ (),
    V_ (),
    quiet_ (),
    silent_ (),
    verbose_ (1),
    verbose_specified_ (false),
    stat_ (),
    progress_ (),
    no_progress_ (),
    diag_color_ (),
    no_diag_color_ (),
    jobs_ (),
    jobs_specified_ (false),
    max_jobs_ (),
    max_jobs_specified_ (false),
    queue_depth_ (4),
    queue_depth_specified_ (false),
    jobserver_ (),
    jobserver_specified_ (false),
    file_cache_ (),
    file_cache_specified_ (false),
    max_stack_ (),
    max_stack_specified_ (false),
    serial_stop_ (),
    dry_run_ (),
    no_diag_buffer_ (),
    match_only_ (),
    load_only_ (),
    no_external_modules_ (),
    structured_result_ (),
    structured_result_specified_ (false),
    mtime_check_ (),
    no_mtime_check_ (),
    dump_ (),
    dump_specified_ (false),
    dump_format_ (),
    dump_format_specified_ (false),
    dump_scope_ (),
    dump_scope_specified_ (false),
    dump_target_ (),
    dump_target_specified_ (false),
    trace_match_ (),
    trace_match_specified_ (false),
    trace_execute_ (),
    trace_execute_specified_ (false),
    no_column_ (),
    no_line_ (),
    buildfile_ (),
    buildfile_specified_ (false),
    config_guess_ (),
    config_guess_specified_ (false),
    config_sub_ (),
    config_sub_specified_ (false),
    pager_ (),
    pager_specified_ (false),
    pager_option_ (),
    pager_option_specified_ (false),
    options_file_ (),
    options_file_specified_ (false),
    default_options_ (),
    default_options_specified_ (false),
    no_default_options_ (),
    help_ (),
    version_ ()
  {
  }

  bool b_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    ::build2::build::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool b_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    ::build2::build::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool b_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    ::build2::build::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool b_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    ::build2::build::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool b_options::
  parse (::build2::build::cli::scanner& s,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void b_options::
  merge (const b_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.build2_metadata_specified_)
    {
      ::build2::build::cli::parser< uint64_t>::merge (
        this->build2_metadata_, a.build2_metadata_);
      this->build2_metadata_specified_ = true;
    }

    if (a.v_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->v_, a.v_);
    }

    if (a.V_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->V_, a.V_);
    }

    if (a.quiet_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->quiet_, a.quiet_);
    }

    if (a.silent_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->silent_, a.silent_);
    }

    if (a.verbose_specified_)
    {
      ::build2::build::cli::parser< uint16_t>::merge (
        this->verbose_, a.verbose_);
      this->verbose_specified_ = true;
    }

    if (a.stat_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->stat_, a.stat_);
    }

    if (a.progress_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->progress_, a.progress_);
    }

    if (a.no_progress_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_progress_, a.no_progress_);
    }

    if (a.diag_color_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->diag_color_, a.diag_color_);
    }

    if (a.no_diag_color_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_diag_color_, a.no_diag_color_);
    }

    if (a.jobs_specified_)
    {
      ::build2::build::cli::parser< int32_t>::merge (
        this->jobs_, a.jobs_);
      this->jobs_specified_ = true;
    }

    if (a.max_jobs_specified_)
    {
      ::build2::build::cli::parser< size_t>::merge (
        this->max_jobs_, a.max_jobs_);
      this->max_jobs_specified_ = true;
    }

    if (a.queue_depth_specified_)
    {
      ::build2::build::cli::parser< size_t>::merge (
        this->queue_depth_, a.queue_depth_);
      this->queue_depth_specified_ = true;
    }

    if (a.jobserver_specified_)
    {
      ::build2::build::cli::parser< string>::merge (
        this->jobserver_, a.jobserver_);
      this->jobserver_specified_ = true;
    }

    if (a.file_cache_specified_)
    {
      ::build2::build::cli::parser< string>::merge (
        this->file_cache_, a.file_cache_);
      this->file_cache_specified_ = true;
    }

    if (a.max_stack_specified_)
    {
      ::build2::build::cli::parser< size_t>::merge (
        this->max_stack_, a.max_stack_);
      this->max_stack_specified_ = true;
    }

    if (a.serial_stop_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->serial_stop_, a.serial_stop_);
    }

    if (a.dry_run_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->dry_run_, a.dry_run_);
    }

    if (a.no_diag_buffer_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_diag_buffer_, a.no_diag_buffer_);
    }

    if (a.match_only_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->match_only_, a.match_only_);
    }

    if (a.load_only_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->load_only_, a.load_only_);
    }

    if (a.no_external_modules_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_external_modules_, a.no_external_modules_);
    }

    if (a.structured_result_specified_)
    {
      ::build2::build::cli::parser< structured_result_format>::merge (
        this->structured_result_, a.structured_result_);
      this->structured_result_specified_ = true;
    }

    if (a.mtime_check_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->mtime_check_, a.mtime_check_);
    }

    if (a.no_mtime_check_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_mtime_check_, a.no_mtime_check_);
    }

    if (a.dump_specified_)
    {
      ::build2::build::cli::parser< strings>::merge (
        this->dump_, a.dump_);
      this->dump_specified_ = true;
    }

    if (a.dump_format_specified_)
    {
      ::build2::build::cli::parser< string>::merge (
        this->dump_format_, a.dump_format_);
      this->dump_format_specified_ = true;
    }

    if (a.dump_scope_specified_)
    {
      ::build2::build::cli::parser< dir_paths>::merge (
        this->dump_scope_, a.dump_scope_);
      this->dump_scope_specified_ = true;
    }

    if (a.dump_target_specified_)
    {
      ::build2::build::cli::parser< vector<pair<name, optional<name>>>>::merge (
        this->dump_target_, a.dump_target_);
      this->dump_target_specified_ = true;
    }

    if (a.trace_match_specified_)
    {
      ::build2::build::cli::parser< vector<name>>::merge (
        this->trace_match_, a.trace_match_);
      this->trace_match_specified_ = true;
    }

    if (a.trace_execute_specified_)
    {
      ::build2::build::cli::parser< vector<name>>::merge (
        this->trace_execute_, a.trace_execute_);
      this->trace_execute_specified_ = true;
    }

    if (a.no_column_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_column_, a.no_column_);
    }

    if (a.no_line_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_line_, a.no_line_);
    }

    if (a.buildfile_specified_)
    {
      ::build2::build::cli::parser< path>::merge (
        this->buildfile_, a.buildfile_);
      this->buildfile_specified_ = true;
    }

    if (a.config_guess_specified_)
    {
      ::build2::build::cli::parser< path>::merge (
        this->config_guess_, a.config_guess_);
      this->config_guess_specified_ = true;
    }

    if (a.config_sub_specified_)
    {
      ::build2::build::cli::parser< path>::merge (
        this->config_sub_, a.config_sub_);
      this->config_sub_specified_ = true;
    }

    if (a.pager_specified_)
    {
      ::build2::build::cli::parser< string>::merge (
        this->pager_, a.pager_);
      this->pager_specified_ = true;
    }

    if (a.pager_option_specified_)
    {
      ::build2::build::cli::parser< strings>::merge (
        this->pager_option_, a.pager_option_);
      this->pager_option_specified_ = true;
    }

    if (a.options_file_specified_)
    {
      ::build2::build::cli::parser< string>::merge (
        this->options_file_, a.options_file_);
      this->options_file_specified_ = true;
    }

    if (a.default_options_specified_)
    {
      ::build2::build::cli::parser< dir_path>::merge (
        this->default_options_, a.default_options_);
      this->default_options_specified_ = true;
    }

    if (a.no_default_options_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_default_options_, a.no_default_options_);
    }

    if (a.help_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->help_, a.help_);
    }

    if (a.version_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->version_, a.version_);
    }
  }

  ::build2::build::cli::usage_para b_options::
  print_usage (::std::ostream& os, ::build2::build::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::build2::build::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mOPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m-v\033[0m                      Print actual commands being executed. This options is" << ::std::endl
       << "                        equivalent to \033[1m--verbose 2\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m-V\033[0m                      Print all underlying commands being executed. This" << ::std::endl
       << "                        options is equivalent to \033[1m--verbose 3\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--quiet\033[0m|\033[1m-q\033[0m              Run quietly, only printing error messages in most" << ::std::endl
       << "                        contexts. In certain contexts (for example, while" << ::std::endl
       << "                        updating build system modules) this verbosity level may" << ::std::endl
       << "                        be ignored. Use \033[1m--silent\033[0m to run quietly in all" << ::std::endl
       << "                        contexts. This option is equivalent to \033[1m--verbose 0\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--silent\033[0m                Run quietly, only printing error messages in all" << ::std::endl
       << "                        contexts." << ::std::endl;

    os << std::endl
       << "\033[1m--verbose\033[0m \033[4mlevel\033[0m         Set the diagnostics verbosity to \033[4mlevel\033[0m between 0 and 6." << ::std::endl
       << "                        Level 0 disables any non-error messages (but see the" << ::std::endl
       << "                        difference between \033[1m--quiet\033[0m and \033[1m--silent\033[0m) while level 6" << ::std::endl
       << "                        produces lots of information, with level 1 being the" << ::std::endl
       << "                        default. The following additional types of diagnostics" << ::std::endl
       << "                        are produced at each level:" << ::std::endl
       << ::std::endl
       << "                        1. High-level information messages." << ::std::endl
       << "                        2. Essential underlying commands being executed." << ::std::endl
       << "                        3. All underlying commands being executed." << ::std::endl
       << "                        4. Information that could be helpful to the user." << ::std::endl
       << "                        5. Information that could be helpful to the developer." << ::std::endl
       << "                        6. Even more detailed information." << ::std::endl;

    os << std::endl
       << "\033[1m--stat\033[0m                  Display build statistics." << ::std::endl;

    os << std::endl
       << "\033[1m--progress\033[0m              Display build progress. If printing to a terminal the" << ::std::endl
       << "                        progress is displayed by default for low verbosity" << ::std::endl
       << "                        levels. Use \033[1m--no-progress\033[0m to suppress." << ::std::endl;

    os << std::endl
       << "\033[1m--no-progress\033[0m           Don't display build progress." << ::std::endl;

    os << std::endl
       << "\033[1m--diag-color\033[0m            Use color in diagnostics. If printing to a terminal the" << ::std::endl
       << "                        color is used by default provided the terminal is not" << ::std::endl
       << "                        dumb. Use \033[1m--no-diag-color\033[0m to suppress." << ::std::endl
       << ::std::endl
       << "                        This option affects the diagnostics printed by the" << ::std::endl
       << "                        build system itself. Some rules may also choose to" << ::std::endl
       << "                        propagate its value to tools (such as compilers) that" << ::std::endl
       << "                        they invoke." << ::std::endl;

    os << std::endl
       << "\033[1m--no-diag-color\033[0m         Don't use color in diagnostics." << ::std::endl;

    os << std::endl
       << "\033[1m--jobs\033[0m|\033[1m-j\033[0m \033[4mnum\033[0m           Number of active jobs to perform in parallel. This" << ::std::endl
       << "                        includes both the number of active threads inside the" << ::std::endl
       << "                        build system as well as the number of external commands" << ::std::endl
       << "                        (compilers, linkers, etc) started but not yet finished." << ::std::endl
       << "                        The jobserver requests (see \033[1m--jobserver\033[0m) are also" << ::std::endl
       << "                        counted against this number. If this option is not" << ::std::endl
       << "                        specified or specified with the \033[1m0\033[0m value, then the" << ::std::endl
       << "                        number of available hardware threads is used. If the" << ::std::endl
       << "                        specified value is negative, then the number of" << ::std::endl
       << "                        available hardware threads reduced by this value is" << ::std::endl
       << "                        used." << ::std::endl;

    os << std::endl
       << "\033[1m--max-jobs\033[0m|\033[1m-J\033[0m \033[4mnum\033[0m       Maximum number of jobs (threads) to create. The default" << ::std::endl
       << "                        is 8x the number of active jobs (\033[1m--jobs|j\033[0m) on 32-bit" << ::std::endl
       << "                        architectures and 32x on 64-bit. See the build system" << ::std::endl
       << "                        scheduler implementation for details." << ::std::endl;

    os << std::endl
       << "\033[1m--queue-depth\033[0m|\033[1m-Q\033[0m \033[4mnum\033[0m    The queue depth as a multiplier over the number of" << ::std::endl
       << "                        active jobs. Normally we want a deeper queue if the" << ::std::endl
       << "                        jobs take long (for example, compilation) and shorter" << ::std::endl
       << "                        if they are quick (for example, simple tests). The" << ::std::endl
       << "                        default is 4. See the build system scheduler" << ::std::endl
       << "                        implementation for details." << ::std::endl;

    os << std::endl
       << "\033[1m--jobserver\033[0m \033[4mtype\033[0m        The GNU make jobserver type to start. Valid values are" << ::std::endl
       << "                        \033[1mfifo\033[0m (named pipe on POSIX) or \033[1mnone\033[0m (disable the" << ::std::endl
       << "                        jobserver). If this option is not specified, then the" << ::std::endl
       << "                        platform-appropriate jobserver type is started, if" << ::std::endl
       << "                        available." << ::std::endl
       << ::std::endl
       << "                        If the jobserver is started, then all external commands" << ::std::endl
       << "                        (compilers, linkers, etc) are passed the jobserver" << ::std::endl
       << "                        information as part of the \033[1mMAKEFLAGS\033[0m environment" << ::std::endl
       << "                        variable." << ::std::endl;

    os << std::endl
       << "\033[1m--file-cache\033[0m \033[4mimpl\033[0m       File cache implementation to use for intermediate build" << ::std::endl
       << "                        results. Valid values are \033[1mnoop\033[0m (no caching or" << ::std::endl
       << "                        compression) and \033[1msync-lz4\033[0m (no caching with synchronous" << ::std::endl
       << "                        LZ4 on-disk compression). If this option is not" << ::std::endl
       << "                        specified, then a suitable default implementation is" << ::std::endl
       << "                        used (currently \033[1msync-lz4\033[0m)." << ::std::endl;

    os << std::endl
       << "\033[1m--max-stack\033[0m \033[4mnum\033[0m         The maximum stack size in KBytes to allow for newly" << ::std::endl
       << "                        created threads. For \033[4mpthreads\033[0m-based systems the driver" << ::std::endl
       << "                        queries the stack size of the main thread and uses the" << ::std::endl
       << "                        same size for creating additional threads. This allows" << ::std::endl
       << "                        adjusting the stack size using familiar mechanisms," << ::std::endl
       << "                        such as \033[1mulimit\033[0m. Sometimes, however, the stack size of" << ::std::endl
       << "                        the main thread is excessively large. As a result, the" << ::std::endl
       << "                        driver checks if it is greater than a predefined limit" << ::std::endl
       << "                        (64MB on 64-bit systems and 32MB on 32-bit ones) and" << ::std::endl
       << "                        caps it to a more sensible value (8MB) if that's the" << ::std::endl
       << "                        case. This option allows you to override this check" << ::std::endl
       << "                        with the special zero value indicating that the main" << ::std::endl
       << "                        thread stack size should be used as is." << ::std::endl;

    os << std::endl
       << "\033[1m--serial-stop\033[0m|\033[1m-s\033[0m        Run serially and stop at the first error. This mode is" << ::std::endl
       << "                        useful to investigate build failures that are caused by" << ::std::endl
       << "                        build system errors rather than compilation errors." << ::std::endl
       << "                        Note that if you don't want to keep going but still" << ::std::endl
       << "                        want parallel execution, add \033[1m--jobs|-j\033[0m (for example \033[1m-j" << ::std::endl
       << "                        0\033[0m for default concurrency). Note also that during" << ::std::endl
       << "                        serial execution there is no diagnostics buffering and" << ::std::endl
       << "                        child process' \033[1mstderr\033[0m is a terminal (unless redirected;" << ::std::endl
       << "                        see \033[1m--no-diag-buffer\033[0m for details)." << ::std::endl;

    os << std::endl
       << "\033[1m--dry-run\033[0m|\033[1m-n\033[0m            Print commands without actually executing them. Note" << ::std::endl
       << "                        that commands that are required to create an accurate" << ::std::endl
       << "                        build state will still be executed and the extracted" << ::std::endl
       << "                        auxiliary dependency information saved. In other words," << ::std::endl
       << "                        this is not the \033[4m\"don't touch the filesystem\"\033[0m mode but" << ::std::endl
       << "                        rather \033[4m\"do minimum amount of work to show what needs to" << ::std::endl
       << "                        be done\"\033[0m. Note also that only the \033[1mperform\033[0m" << ::std::endl
       << "                        meta-operation supports this mode." << ::std::endl;

    os << std::endl
       << "\033[1m--no-diag-buffer\033[0m        Do not buffer diagnostics from child processes. By" << ::std::endl
       << "                        default, unless running serially, such diagnostics is" << ::std::endl
       << "                        buffered and printed all at once after each child exits" << ::std::endl
       << "                        in order to prevent interleaving. However, this can" << ::std::endl
       << "                        have side-effects since the child process' \033[1mstderr\033[0m is no" << ::std::endl
       << "                        longer a terminal. Most notably, the use of color in" << ::std::endl
       << "                        diagnostics may be disabled by some programs. On the" << ::std::endl
       << "                        other hand, depending on the platform and programs" << ::std::endl
       << "                        invoked, the interleaving diagnostics may not break" << ::std::endl
       << "                        lines and thus could be tolerable." << ::std::endl;

    os << std::endl
       << "\033[1m--match-only\033[0m            Match the rules without executing the operation. This" << ::std::endl
       << "                        mode is primarily useful for profiling and dumping the" << ::std::endl
       << "                        build system state." << ::std::endl;

    os << std::endl
       << "\033[1m--load-only\033[0m             Match the rules only to \033[1malias{}\033[0m targets ignoring other" << ::std::endl
       << "                        targets and without executing the operation. In" << ::std::endl
       << "                        particular, this has the effect of loading all the" << ::std::endl
       << "                        subdirectory \033[1mbuildfiles\033[0m that are not explicitly" << ::std::endl
       << "                        included. Note that this option can only be used with" << ::std::endl
       << "                        the \033[1mperform(update)\033[0m action on an \033[1malias{}\033[0m target," << ::std::endl
       << "                        usually \033[1mdir{}\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--no-external-modules\033[0m   Don't load external modules during project bootstrap." << ::std::endl
       << "                        Note that this option can only be used with" << ::std::endl
       << "                        meta-operations that do not load the project's" << ::std::endl
       << "                        \033[1mbuildfiles\033[0m, such as \033[1minfo\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--structured-result\033[0m \033[4mfmt\033[0m Write the result of execution in a structured form. In" << ::std::endl
       << "                        this mode, instead of printing to \033[1mstderr\033[0m diagnostics" << ::std::endl
       << "                        messages about the outcome of executing actions on" << ::std::endl
       << "                        targets, the driver writes to \033[1mstdout\033[0m a machine-readable" << ::std::endl
       << "                        result description in the specified format. Valid" << ::std::endl
       << "                        values for this option are \033[1mlines\033[0m and \033[1mjson\033[0m. Note that" << ::std::endl
       << "                        currently only the \033[1mperform\033[0m meta-operation supports the" << ::std::endl
       << "                        structured result output." << ::std::endl
       << ::std::endl
       << "                        If the output format is \033[1mlines\033[0m, then the result is" << ::std::endl
       << "                        written one line per the buildspec action/target pair." << ::std::endl
       << "                        Each line has the following form:" << ::std::endl
       << ::std::endl
       << "                        \033[4mstate\033[0m \033[4mmeta-operation\033[0m \033[4moperation\033[0m \033[4mtarget\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "                        Where \033[4mstate\033[0m can be one of \033[1munchanged\033[0m, \033[1mchanged\033[0m, or" << ::std::endl
       << "                        \033[1mfailed\033[0m. If the action is a pre or post operation, then" << ::std::endl
       << "                        the outer operation is specified in parenthesis. For" << ::std::endl
       << "                        example:" << ::std::endl
       << ::std::endl
       << "                        unchanged perform update(test)" << ::std::endl
       << "                        /tmp/hello/hello/exe{hello}" << ::std::endl
       << "                        changed perform test /tmp/hello/hello/exe{hello}" << ::std::endl
       << ::std::endl
       << "                        If the output format is \033[1mjson\033[0m, then the output is a JSON" << ::std::endl
       << "                        array of objects which are the serialized" << ::std::endl
       << "                        representation of the following C++ \033[1mstruct\033[0m" << ::std::endl
       << "                        \033[1mtarget_action_result\033[0m:" << ::std::endl
       << ::std::endl
       << "                        struct target_action_result" << ::std::endl
       << "                        {" << ::std::endl
       << "                          string           target;" << ::std::endl
       << "                          string           display_target;" << ::std::endl
       << "                          string           target_type;" << ::std::endl
       << "                          optional<string> target_path;" << ::std::endl
       << "                          string           meta_operation;" << ::std::endl
       << "                          string           operation;" << ::std::endl
       << "                          optional<string> outer_operation;" << ::std::endl
       << "                          string           state;" << ::std::endl
       << "                        };" << ::std::endl
       << ::std::endl
       << "                        For example:" << ::std::endl
       << ::std::endl
       << "                        [" << ::std::endl
       << "                          {" << ::std::endl
       << "                            \"target\": \"/tmp/hello/hello/exe{hello.}\"," << ::std::endl
       << "                            \"display_target\": \"/tmp/hello/hello/exe{hello}\"," << ::std::endl
       << "                            \"target_type\": \"exe\"," << ::std::endl
       << "                            \"target_path\": \"/tmp/hello/hello/hello\"," << ::std::endl
       << "                            \"meta_operation\": \"perform\"," << ::std::endl
       << "                            \"operation\": \"update\"," << ::std::endl
       << "                            \"outer_operation\": \"test\"," << ::std::endl
       << "                            \"state\": \"unchanged\"" << ::std::endl
       << "                          }," << ::std::endl
       << "                          {" << ::std::endl
       << "                            \"target\": \"/tmp/hello/hello/exe{hello.}\"," << ::std::endl
       << "                            \"display_target\": \"/tmp/hello/hello/exe{hello}\"," << ::std::endl
       << "                            \"target_type\": \"exe\"," << ::std::endl
       << "                            \"target_path\": \"/tmp/hello/hello/hello\"," << ::std::endl
       << "                            \"meta_operation\": \"perform\"," << ::std::endl
       << "                            \"operation\": \"test\"," << ::std::endl
       << "                            \"state\": \"changed\"" << ::std::endl
       << "                          }" << ::std::endl
       << "                        ]" << ::std::endl
       << ::std::endl
       << "                        See the JSON OUTPUT section below for details on the" << ::std::endl
       << "                        overall properties of this format and the semantics of" << ::std::endl
       << "                        the \033[1mstruct\033[0m serialization." << ::std::endl
       << ::std::endl
       << "                        The \033[1mtarget\033[0m member is the target name that is qualified" << ::std::endl
       << "                        with the extension (if applicable) and, if required, is" << ::std::endl
       << "                        quoted so that it can be passed back to the build" << ::std::endl
       << "                        system driver on the command line. The \033[1mdisplay_target\033[0m" << ::std::endl
       << "                        member is the unqualified and unquoted \"display\" target" << ::std::endl
       << "                        name, the same as in the \033[1mlines\033[0m format. The \033[1mtarget_type\033[0m" << ::std::endl
       << "                        member is the type of target.  The \033[1mtarget_path\033[0m member" << ::std::endl
       << "                        is an absolute path to the target if the target type is" << ::std::endl
       << "                        path-based or \033[1mdir\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--mtime-check\033[0m           Perform file modification time sanity checks. These" << ::std::endl
       << "                        checks can be helpful in diagnosing spurious rebuilds" << ::std::endl
       << "                        and are enabled by default on Windows (which is known" << ::std::endl
       << "                        not to guarantee monotonically increasing mtimes) and" << ::std::endl
       << "                        for the staged version of the build system on other" << ::std::endl
       << "                        platforms. Use \033[1m--no-mtime-check\033[0m to disable." << ::std::endl;

    os << std::endl
       << "\033[1m--no-mtime-check\033[0m        Don't perform file modification time sanity checks. See" << ::std::endl
       << "                        \033[1m--mtime-check\033[0m for details." << ::std::endl;

    os << std::endl
       << "\033[1m--dump\033[0m \033[4mphase\033[0m            Dump the build system state after the specified phase." << ::std::endl
       << "                        Valid \033[4mphase\033[0m values are \033[1mload\033[0m (after loading \033[1mbuildfiles\033[0m)" << ::std::endl
       << "                        and \033[1mmatch\033[0m (after matching rules to targets). The \033[1mmatch\033[0m" << ::std::endl
       << "                        value also has the \033[1mmatch-pre\033[0m and \033[1mmatch-post\033[0m variants to" << ::std::endl
       << "                        dump the state for the pre/post-operations (\033[1mmatch\033[0m dumps" << ::std::endl
       << "                        the main operation only). Repeat this option to dump" << ::std::endl
       << "                        the state after multiple phases/variants. By default" << ::std::endl
       << "                        the entire build state is dumped but this behavior can" << ::std::endl
       << "                        be altered with the \033[1m--dump-scope\033[0m and \033[1m--dump-target\033[0m" << ::std::endl
       << "                        options. See also the \033[1m--match-only\033[0m and \033[1m--load-only\033[0m" << ::std::endl
       << "                        options." << ::std::endl;

    os << std::endl
       << "\033[1m--dump-format\033[0m \033[4mformat\033[0m    Representation format and output stream to use when" << ::std::endl
       << "                        dumping the build system state. Valid values for this" << ::std::endl
       << "                        option are \033[1mbuildfile\033[0m (a human-readable, Buildfile-like" << ::std::endl
       << "                        format written to \033[1mstderr\033[0m; this is the default), and" << ::std::endl
       << "                        \033[1mjson-v0.1\033[0m (machine-readable, JSON-based format written" << ::std::endl
       << "                        to \033[1mstdout\033[0m). For details on the \033[1mbuildfile\033[0m format, see" << ::std::endl
       << "                        Diagnostics and Debugging (b#intro-diag-debug). For" << ::std::endl
       << "                        details on the \033[1mjson-v0.1\033[0m format, see the JSON OUTPUT" << ::std::endl
       << "                        section below (overall properties) and JSON Dump Format" << ::std::endl
       << "                        (b#json-dump) (format specifics). Note that the JSON" << ::std::endl
       << "                        format is currently unstable (thus the temporary \033[1m-v0.1\033[0m" << ::std::endl
       << "                        suffix)." << ::std::endl
       << ::std::endl
       << "                        Note that because it's possible to end up with multiple" << ::std::endl
       << "                        dumps (for example, by specifying the \033[1m--dump-scope\033[0m" << ::std::endl
       << "                        and/or \033[1m--dump-target\033[0m options multiple times), the JSON" << ::std::endl
       << "                        output is in the \"JSON Lines\" form, that is, without" << ::std::endl
       << "                        pretty-printing and with the top-level JSON objects" << ::std::endl
       << "                        delimited by newlines. Note also that if the JSON dump" << ::std::endl
       << "                        output is combined with \033[1m--structured-result=json\033[0m, then" << ::std::endl
       << "                        the structured result is the last line." << ::std::endl;

    os << std::endl
       << "\033[1m--dump-scope\033[0m \033[4mdir\033[0m        Dump the build system state for the specified scope" << ::std::endl
       << "                        only. Repeat this option to dump the state of multiple" << ::std::endl
       << "                        scopes." << ::std::endl;

    os << std::endl
       << "\033[1m--dump-target\033[0m \033[4mtarget\033[0m    Dump the build system state for the specified target" << ::std::endl
       << "                        only. Repeat this option to dump the state of multiple" << ::std::endl
       << "                        targets." << ::std::endl;

    os << std::endl
       << "\033[1m--trace-match\033[0m \033[4mtarget\033[0m    Trace rule matching for the specified target. This is" << ::std::endl
       << "                        primarily useful during troubleshooting. Repeat this" << ::std::endl
       << "                        option to trace multiple targets." << ::std::endl;

    os << std::endl
       << "\033[1m--trace-execute\033[0m \033[4mtarget\033[0m  Trace rule execution for the specified target. This is" << ::std::endl
       << "                        primarily useful during troubleshooting. Repeat this" << ::std::endl
       << "                        option to trace multiple targets." << ::std::endl;

    os << std::endl
       << "\033[1m--no-column\033[0m             Don't print column numbers in diagnostics." << ::std::endl;

    os << std::endl
       << "\033[1m--no-line\033[0m               Don't print line and column numbers in diagnostics." << ::std::endl;

    os << std::endl
       << "\033[1m--buildfile\033[0m \033[4mpath\033[0m        The alternative file to read build information from." << ::std::endl
       << "                        The default is \033[1mbuildfile\033[0m or \033[1mbuild2file\033[0m, depending on" << ::std::endl
       << "                        the project's build file/directory naming scheme. If" << ::std::endl
       << "                        \033[4mpath\033[0m is '\033[1m-\033[0m', then read from \033[1mstdin\033[0m. Note that this" << ::std::endl
       << "                        option only affects the files read as part of the" << ::std::endl
       << "                        buildspec processing. Specifically, it has no effect on" << ::std::endl
       << "                        the \033[1msource\033[0m and \033[1minclude\033[0m directives. As a result, this" << ::std::endl
       << "                        option is primarily intended for testing rather than" << ::std::endl
       << "                        changing the build file names in real projects." << ::std::endl;

    os << std::endl
       << "\033[1m--config-guess\033[0m \033[4mpath\033[0m     The path to the \033[1mconfig.guess(1)\033[0m script that should be" << ::std::endl
       << "                        used to guess the host machine triplet. If this option" << ::std::endl
       << "                        is not specified, then \033[1mb\033[0m will fall back on to using the" << ::std::endl
       << "                        target it was built for as host." << ::std::endl;

    os << std::endl
       << "\033[1m--config-sub\033[0m \033[4mpath\033[0m       The path to the \033[1mconfig.sub(1)\033[0m script that should be" << ::std::endl
       << "                        used to canonicalize machine triplets. If this option" << ::std::endl
       << "                        is not specified, then \033[1mb\033[0m will use its built-in" << ::std::endl
       << "                        canonicalization support which should be sufficient for" << ::std::endl
       << "                        commonly-used platforms." << ::std::endl;

    os << std::endl
       << "\033[1m--pager\033[0m \033[4mpath\033[0m            The pager program to be used to show long text." << ::std::endl
       << "                        Commonly used pager programs are \033[1mless\033[0m and \033[1mmore\033[0m. You can" << ::std::endl
       << "                        also specify additional options that should be passed" << ::std::endl
       << "                        to the pager program with \033[1m--pager-option\033[0m. If an empty" << ::std::endl
       << "                        string is specified as the pager program, then no pager" << ::std::endl
       << "                        will be used. If the pager program is not explicitly" << ::std::endl
       << "                        specified, then \033[1mb\033[0m will try to use \033[1mless\033[0m. If it is not" << ::std::endl
       << "                        available, then no pager will be used." << ::std::endl;

    os << std::endl
       << "\033[1m--pager-option\033[0m \033[4mopt\033[0m      Additional option to be passed to the pager program." << ::std::endl
       << "                        See \033[1m--pager\033[0m for more information on the pager program." << ::std::endl
       << "                        Repeat this option to specify multiple pager options." << ::std::endl;

    os << std::endl
       << "\033[1m--options-file\033[0m \033[4mfile\033[0m     Read additional options from \033[4mfile\033[0m. Each option should" << ::std::endl
       << "                        appear on a separate line optionally followed by space" << ::std::endl
       << "                        or equal sign (\033[1m=\033[0m) and an option value. Empty lines and" << ::std::endl
       << "                        lines starting with \033[1m#\033[0m are ignored. Option values can be" << ::std::endl
       << "                        enclosed in double (\033[1m\"\033[0m) or single (\033[1m'\033[0m) quotes to preserve" << ::std::endl
       << "                        leading and trailing whitespaces as well as to specify" << ::std::endl
       << "                        empty values. If the value itself contains trailing or" << ::std::endl
       << "                        leading quotes, enclose it with an extra pair of" << ::std::endl
       << "                        quotes, for example \033[1m'\"x\"'\033[0m. Non-leading and non-trailing" << ::std::endl
       << "                        quotes are interpreted as being part of the option" << ::std::endl
       << "                        value." << ::std::endl
       << ::std::endl
       << "                        The semantics of providing options in a file is" << ::std::endl
       << "                        equivalent to providing the same set of options in the" << ::std::endl
       << "                        same order on the command line at the point where the" << ::std::endl
       << "                        \033[1m--options-file\033[0m option is specified except that the" << ::std::endl
       << "                        shell escaping and quoting is not required. Repeat this" << ::std::endl
       << "                        option to specify more than one options file." << ::std::endl;

    os << std::endl
       << "\033[1m--default-options\033[0m \033[4mdir\033[0m   The directory to load additional default options files" << ::std::endl
       << "                        from." << ::std::endl;

    os << std::endl
       << "\033[1m--no-default-options\033[0m    Don't load default options files." << ::std::endl;

    os << std::endl
       << "\033[1m--help\033[0m                  Print usage information and exit." << ::std::endl;

    os << std::endl
       << "\033[1m--version\033[0m               Print version and exit." << ::std::endl;

    p = ::build2::build::cli::usage_para::option;

    return p;
  }

  typedef
  std::map<std::string, void (*) (b_options&, ::build2::build::cli::scanner&)>
  _cli_b_options_map;

  static _cli_b_options_map _cli_b_options_map_;

  struct _cli_b_options_map_init
  {
    _cli_b_options_map_init ()
    {
      _cli_b_options_map_["--build2-metadata"] =
      &::build2::build::cli::thunk< b_options, uint64_t, &b_options::build2_metadata_,
        &b_options::build2_metadata_specified_ >;
      _cli_b_options_map_["-v"] =
      &::build2::build::cli::thunk< b_options, &b_options::v_ >;
      _cli_b_options_map_["-V"] =
      &::build2::build::cli::thunk< b_options, &b_options::V_ >;
      _cli_b_options_map_["--quiet"] =
      &::build2::build::cli::thunk< b_options, &b_options::quiet_ >;
      _cli_b_options_map_["-q"] =
      &::build2::build::cli::thunk< b_options, &b_options::quiet_ >;
      _cli_b_options_map_["--silent"] =
      &::build2::build::cli::thunk< b_options, &b_options::silent_ >;
      _cli_b_options_map_["--verbose"] =
      &::build2::build::cli::thunk< b_options, uint16_t, &b_options::verbose_,
        &b_options::verbose_specified_ >;
      _cli_b_options_map_["--stat"] =
      &::build2::build::cli::thunk< b_options, &b_options::stat_ >;
      _cli_b_options_map_["--progress"] =
      &::build2::build::cli::thunk< b_options, &b_options::progress_ >;
      _cli_b_options_map_["--no-progress"] =
      &::build2::build::cli::thunk< b_options, &b_options::no_progress_ >;
      _cli_b_options_map_["--diag-color"] =
      &::build2::build::cli::thunk< b_options, &b_options::diag_color_ >;
      _cli_b_options_map_["--no-diag-color"] =
      &::build2::build::cli::thunk< b_options, &b_options::no_diag_color_ >;
      _cli_b_options_map_["--jobs"] =
      &::build2::build::cli::thunk< b_options, int32_t, &b_options::jobs_,
        &b_options::jobs_specified_ >;
      _cli_b_options_map_["-j"] =
      &::build2::build::cli::thunk< b_options, int32_t, &b_options::jobs_,
        &b_options::jobs_specified_ >;
      _cli_b_options_map_["--max-jobs"] =
      &::build2::build::cli::thunk< b_options, size_t, &b_options::max_jobs_,
        &b_options::max_jobs_specified_ >;
      _cli_b_options_map_["-J"] =
      &::build2::build::cli::thunk< b_options, size_t, &b_options::max_jobs_,
        &b_options::max_jobs_specified_ >;
      _cli_b_options_map_["--queue-depth"] =
      &::build2::build::cli::thunk< b_options, size_t, &b_options::queue_depth_,
        &b_options::queue_depth_specified_ >;
      _cli_b_options_map_["-Q"] =
      &::build2::build::cli::thunk< b_options, size_t, &b_options::queue_depth_,
        &b_options::queue_depth_specified_ >;
      _cli_b_options_map_["--jobserver"] =
      &::build2::build::cli::thunk< b_options, string, &b_options::jobserver_,
        &b_options::jobserver_specified_ >;
      _cli_b_options_map_["--file-cache"] =
      &::build2::build::cli::thunk< b_options, string, &b_options::file_cache_,
        &b_options::file_cache_specified_ >;
      _cli_b_options_map_["--max-stack"] =
      &::build2::build::cli::thunk< b_options, size_t, &b_options::max_stack_,
        &b_options::max_stack_specified_ >;
      _cli_b_options_map_["--serial-stop"] =
      &::build2::build::cli::thunk< b_options, &b_options::serial_stop_ >;
      _cli_b_options_map_["-s"] =
      &::build2::build::cli::thunk< b_options, &b_options::serial_stop_ >;
      _cli_b_options_map_["--dry-run"] =
      &::build2::build::cli::thunk< b_options, &b_options::dry_run_ >;
      _cli_b_options_map_["-n"] =
      &::build2::build::cli::thunk< b_options, &b_options::dry_run_ >;
      _cli_b_options_map_["--no-diag-buffer"] =
      &::build2::build::cli::thunk< b_options, &b_options::no_diag_buffer_ >;
      _cli_b_options_map_["--match-only"] =
      &::build2::build::cli::thunk< b_options, &b_options::match_only_ >;
      _cli_b_options_map_["--load-only"] =
      &::build2::build::cli::thunk< b_options, &b_options::load_only_ >;
      _cli_b_options_map_["--no-external-modules"] =
      &::build2::build::cli::thunk< b_options, &b_options::no_external_modules_ >;
      _cli_b_options_map_["--structured-result"] =
      &::build2::build::cli::thunk< b_options, structured_result_format, &b_options::structured_result_,
        &b_options::structured_result_specified_ >;
      _cli_b_options_map_["--mtime-check"] =
      &::build2::build::cli::thunk< b_options, &b_options::mtime_check_ >;
      _cli_b_options_map_["--no-mtime-check"] =
      &::build2::build::cli::thunk< b_options, &b_options::no_mtime_check_ >;
      _cli_b_options_map_["--dump"] =
      &::build2::build::cli::thunk< b_options, strings, &b_options::dump_,
        &b_options::dump_specified_ >;
      _cli_b_options_map_["--dump-format"] =
      &::build2::build::cli::thunk< b_options, string, &b_options::dump_format_,
        &b_options::dump_format_specified_ >;
      _cli_b_options_map_["--dump-scope"] =
      &::build2::build::cli::thunk< b_options, dir_paths, &b_options::dump_scope_,
        &b_options::dump_scope_specified_ >;
      _cli_b_options_map_["--dump-target"] =
      &::build2::build::cli::thunk< b_options, vector<pair<name, optional<name>>>, &b_options::dump_target_,
        &b_options::dump_target_specified_ >;
      _cli_b_options_map_["--trace-match"] =
      &::build2::build::cli::thunk< b_options, vector<name>, &b_options::trace_match_,
        &b_options::trace_match_specified_ >;
      _cli_b_options_map_["--trace-execute"] =
      &::build2::build::cli::thunk< b_options, vector<name>, &b_options::trace_execute_,
        &b_options::trace_execute_specified_ >;
      _cli_b_options_map_["--no-column"] =
      &::build2::build::cli::thunk< b_options, &b_options::no_column_ >;
      _cli_b_options_map_["--no-line"] =
      &::build2::build::cli::thunk< b_options, &b_options::no_line_ >;
      _cli_b_options_map_["--buildfile"] =
      &::build2::build::cli::thunk< b_options, path, &b_options::buildfile_,
        &b_options::buildfile_specified_ >;
      _cli_b_options_map_["--config-guess"] =
      &::build2::build::cli::thunk< b_options, path, &b_options::config_guess_,
        &b_options::config_guess_specified_ >;
      _cli_b_options_map_["--config-sub"] =
      &::build2::build::cli::thunk< b_options, path, &b_options::config_sub_,
        &b_options::config_sub_specified_ >;
      _cli_b_options_map_["--pager"] =
      &::build2::build::cli::thunk< b_options, string, &b_options::pager_,
        &b_options::pager_specified_ >;
      _cli_b_options_map_["--pager-option"] =
      &::build2::build::cli::thunk< b_options, strings, &b_options::pager_option_,
        &b_options::pager_option_specified_ >;
      _cli_b_options_map_["--options-file"] =
      &::build2::build::cli::thunk< b_options, string, &b_options::options_file_,
        &b_options::options_file_specified_ >;
      _cli_b_options_map_["--default-options"] =
      &::build2::build::cli::thunk< b_options, dir_path, &b_options::default_options_,
        &b_options::default_options_specified_ >;
      _cli_b_options_map_["--no-default-options"] =
      &::build2::build::cli::thunk< b_options, &b_options::no_default_options_ >;
      _cli_b_options_map_["--help"] =
      &::build2::build::cli::thunk< b_options, &b_options::help_ >;
      _cli_b_options_map_["--version"] =
      &::build2::build::cli::thunk< b_options, &b_options::version_ >;
    }
  };

  static _cli_b_options_map_init _cli_b_options_map_init_;

  bool b_options::
  _parse (const char* o, ::build2::build::cli::scanner& s)
  {
    _cli_b_options_map::const_iterator i (_cli_b_options_map_.find (o));

    if (i != _cli_b_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool b_options::
  _parse (::build2::build::cli::scanner& s,
          ::build2::build::cli::unknown_mode opt_mode,
          ::build2::build::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::build2::build::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::build2::build::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::build2::build::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::build2::build::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::build2::build::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::build2::build::cli::unknown_mode::stop:
            {
              break;
            }
            case ::build2::build::cli::unknown_mode::fail:
            {
              throw ::build2::build::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::build2::build::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::build2::build::cli::unknown_mode::stop:
        {
          break;
        }
        case ::build2::build::cli::unknown_mode::fail:
        {
          throw ::build2::build::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace build2
{
  ::build2::build::cli::usage_para
  print_b_usage (::std::ostream& os, ::build2::build::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::build2::build::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mb\033[0m [\033[4moptions\033[0m] [\033[4mvariables\033[0m] [\033[4mbuildspec\033[0m]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[4mbuildspec\033[0m = \033[4mmeta-operation\033[0m\033[1m(\033[0m\033[4moperation\033[0m\033[1m(\033[0m\033[4mtarget\033[0m...[\033[1m,\033[0m\033[4mparameters\033[0m]\033[1m)\033[0m...\033[1m)\033[0m...\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mbuild2\033[0m build system driver executes a set of meta-operations on operations" << ::std::endl
       << "on targets according to the build specification, or \033[4mbuildspec\033[0m for short.  This" << ::std::endl
       << "process can be controlled by specifying driver \033[4moptions\033[0m and build system" << ::std::endl
       << "\033[4mvariables\033[0m." << ::std::endl
       << ::std::endl
       << "Note that \033[4moptions\033[0m, \033[4mvariables\033[0m, and \033[4mbuildspec\033[0m fragments can be specified in any" << ::std::endl
       << "order. To avoid treating an argument that starts with \033[1m'-'\033[0m as an option, add the" << ::std::endl
       << "\033[1m'--'\033[0m separator. To avoid treating an argument that contains \033[1m'='\033[0m as a variable," << ::std::endl
       << "add the second \033[1m'--'\033[0m separator." << ::std::endl;

    p = ::build2::b_options::print_usage (os, ::build2::build::cli::usage_para::text);

    if (p != ::build2::build::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "Instead of having a separate config file format for tool configuration, the" << ::std::endl
       << "\033[1mbuild2\033[0m toolchain uses \033[4mdefault options files\033[0m which contain the same options as" << ::std::endl
       << "what can be specified on the command line. The default options files are like" << ::std::endl
       << "options files that one can specify with \033[1m--options-file\033[0m except that they are" << ::std::endl
       << "loaded by default." << ::std::endl
       << ::std::endl
       << "The default options files for the build system driver are called \033[1mb.options\033[0m and" << ::std::endl
       << "are searched for in the \033[1m.build2/\033[0m subdirectory of the home directory and in the" << ::std::endl
       << "system directory (for example, \033[1m/etc/build2/\033[0m) if configured. Note that besides" << ::std::endl
       << "options these files can also contain global variable overrides." << ::std::endl
       << ::std::endl
       << "Once the search is complete, the files are loaded in the reverse order, that" << ::std::endl
       << "is, beginning from the system directory (if any), followed by the home" << ::std::endl
       << "directory, and finishing off with the options specified on the command line. In" << ::std::endl
       << "other words, the files are loaded from the more generic to the more specific" << ::std::endl
       << "with the command line options having the ability to override any values" << ::std::endl
       << "specified in the default options files." << ::std::endl
       << ::std::endl
       << "If a default options file contains \033[1m--no-default-options\033[0m, then the search is" << ::std::endl
       << "stopped at the directory containing this file and no outer files are loaded. If" << ::std::endl
       << "this option is specified on the command line, then none of the default options" << ::std::endl
       << "files are searched for or loaded." << ::std::endl
       << ::std::endl
       << "An additional directory containing default options files can be specified with" << ::std::endl
       << "\033[1m--default-options\033[0m. Its configuration files are loaded after the home directory." << ::std::endl
       << ::std::endl
       << "The order in which default options files are loaded is traced at the verbosity" << ::std::endl
       << "level 3 (\033[1m-V\033[0m option) or higher." << ::std::endl
       << ::std::endl
       << "\033[1mJSON OUTPUT\033[0m" << ::std::endl
       << ::std::endl
       << "Commands that support the JSON output specify their formats as a serialized" << ::std::endl
       << "representation of a C++ \033[1mstruct\033[0m or an array thereof. For example:" << ::std::endl
       << ::std::endl
       << "struct package" << ::std::endl
       << "{" << ::std::endl
       << "  string name;" << ::std::endl
       << "};" << ::std::endl
       << ::std::endl
       << "struct configuration" << ::std::endl
       << "{" << ::std::endl
       << "  uint64_t         id;" << ::std::endl
       << "  string           path;" << ::std::endl
       << "  optional<string> name;" << ::std::endl
       << "  bool             default;" << ::std::endl
       << "  vector<package>  packages;" << ::std::endl
       << "};" << ::std::endl
       << ::std::endl
       << "An example of the serialized JSON representation of \033[1mstruct\033[0m \033[1mconfiguration\033[0m:" << ::std::endl
       << ::std::endl
       << "{" << ::std::endl
       << "  \"id\": 1," << ::std::endl
       << "  \"path\": \"/tmp/hello-gcc\"," << ::std::endl
       << "  \"name\": \"gcc\"," << ::std::endl
       << "  \"default\": true," << ::std::endl
       << "  \"packages\": [" << ::std::endl
       << "    {" << ::std::endl
       << "      \"name\": \"hello\"" << ::std::endl
       << "    }" << ::std::endl
       << "  ]" << ::std::endl
       << "}" << ::std::endl
       << ::std::endl
       << "This sections provides details on the overall properties of such formats and" << ::std::endl
       << "the semantics of the \033[1mstruct\033[0m serialization." << ::std::endl
       << ::std::endl
       << "The order of members in a JSON object is fixed as specified in the" << ::std::endl
       << "corresponding \033[1mstruct\033[0m. While new members may be added in the future (and should" << ::std::endl
       << "be ignored by older consumers), the semantics of the existing members" << ::std::endl
       << "(including whether the top-level entry is an object or array) may not change." << ::std::endl
       << ::std::endl
       << "An object member is required unless its type is \033[1moptional<>\033[0m, \033[1mbool\033[0m, or \033[1mvector<>\033[0m" << ::std::endl
       << "(array). For \033[1mbool\033[0m members absent means \033[1mfalse\033[0m. For \033[1mvector<>\033[0m members absent means" << ::std::endl
       << "empty. An empty top-level array is always present." << ::std::endl
       << ::std::endl
       << "For example, the following JSON text is a possible serialization of the above" << ::std::endl
       << "\033[1mstruct\033[0m \033[1mconfiguration\033[0m:" << ::std::endl
       << ::std::endl
       << "{" << ::std::endl
       << "  \"id\": 1," << ::std::endl
       << "  \"path\": \"/tmp/hello-gcc\"" << ::std::endl
       << "}" << ::std::endl
       << ::std::endl
       << "\033[1mEXIT STATUS\033[0m" << ::std::endl
       << ::std::endl
       << "Non-zero exit status is returned in case of an error." << ::std::endl;

    os << std::endl
       << "\033[1mENVIRONMENT\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mHOME\033[0m environment variable is used to determine the user's home directory." << ::std::endl
       << "If it is not set, then \033[1mgetpwuid(3)\033[0m is used instead. This value is used to" << ::std::endl
       << "shorten paths printed in diagnostics by replacing the home directory with \033[1m~/\033[0m." << ::std::endl
       << "It is also made available to \033[1mbuildfile\033[0m's as the \033[1mbuild.home\033[0m variable." << ::std::endl
       << ::std::endl
       << "The \033[1mBUILD2_VAR_OVR\033[0m environment variable is used to propagate global variable" << ::std::endl
       << "overrides to nested build system driver invocations. Its value is a list of" << ::std::endl
       << "global variable assignments separated with newlines." << ::std::endl
       << ::std::endl
       << "The \033[1mBUILD2_DEF_OPT\033[0m environment variable is used to suppress loading of default" << ::std::endl
       << "options files in nested build system driver invocations. Its values are \033[1mfalse\033[0m" << ::std::endl
       << "or \033[1m0\033[0m to suppress and \033[1mtrue\033[0m or \033[1m1\033[0m to load." << ::std::endl;

    p = ::build2::build::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

