// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

#ifndef MOD_MODULE_OPTIONS_HXX
#define MOD_MODULE_OPTIONS_HXX

// Begin prologue.
//
//
// End prologue.

#include <list>
#include <deque>
#include <map>
#include <vector>
#include <iosfwd>
#include <string>
#include <cstddef>
#include <exception>

#ifndef CLI_POTENTIALLY_UNUSED
#  if defined(_MSC_VER) || defined(__xlC__)
#    define CLI_POTENTIALLY_UNUSED(x) (void*)&x
#  else
#    define CLI_POTENTIALLY_UNUSED(x) (void)x
#  endif
#endif

namespace brep
{
  namespace cli
  {
    class usage_para
    {
      public:
      enum value
      {
        none,
        text,
        option
      };

      usage_para (value);

      operator value () const 
      {
        return v_;
      }

      private:
      value v_;
    };

    class unknown_mode
    {
      public:
      enum value
      {
        skip,
        stop,
        fail
      };

      unknown_mode (value);

      operator value () const 
      {
        return v_;
      }

      private:
      value v_;
    };

    // Exceptions.
    //

    class exception: public std::exception
    {
      public:
      virtual void
      print (::std::ostream&) const = 0;
    };

    ::std::ostream&
    operator<< (::std::ostream&, const exception&);

    class unknown_option: public exception
    {
      public:
      virtual
      ~unknown_option () noexcept;

      unknown_option (const std::string& option);

      const std::string&
      option () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string option_;
    };

    class unknown_argument: public exception
    {
      public:
      virtual
      ~unknown_argument () noexcept;

      unknown_argument (const std::string& argument);

      const std::string&
      argument () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string argument_;
    };

    class missing_value: public exception
    {
      public:
      virtual
      ~missing_value () noexcept;

      missing_value (const std::string& option);

      const std::string&
      option () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string option_;
    };

    class invalid_value: public exception
    {
      public:
      virtual
      ~invalid_value () noexcept;

      invalid_value (const std::string& option,
                     const std::string& value,
                     const std::string& message = std::string ());

      const std::string&
      option () const;

      const std::string&
      value () const;

      const std::string&
      message () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string option_;
      std::string value_;
      std::string message_;
    };

    class eos_reached: public exception
    {
      public:
      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;
    };

    class file_io_failure: public exception
    {
      public:
      virtual
      ~file_io_failure () noexcept;

      file_io_failure (const std::string& file);

      const std::string&
      file () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string file_;
    };

    class unmatched_quote: public exception
    {
      public:
      virtual
      ~unmatched_quote () noexcept;

      unmatched_quote (const std::string& argument);

      const std::string&
      argument () const;

      virtual void
      print (::std::ostream&) const;

      virtual const char*
      what () const noexcept;

      private:
      std::string argument_;
    };

    // Command line argument scanner interface.
    //
    // The values returned by next() are guaranteed to be valid
    // for the two previous arguments up until a call to a third
    // peek() or next().
    //
    // The position() function returns a monotonically-increasing
    // number which, if stored, can later be used to determine the
    // relative position of the argument returned by the following
    // call to next(). Note that if multiple scanners are used to
    // extract arguments from multiple sources, then the end
    // position of the previous scanner should be used as the
    // start position of the next.
    //
    class scanner
    {
      public:
      virtual
      ~scanner ();

      virtual bool
      more () = 0;

      virtual const char*
      peek () = 0;

      virtual const char*
      next () = 0;

      virtual void
      skip () = 0;

      virtual std::size_t
      position () = 0;
    };

    class argv_scanner: public scanner
    {
      public:
      argv_scanner (int& argc,
                    char** argv,
                    bool erase = false,
                    std::size_t start_position = 0);

      argv_scanner (int start,
                    int& argc,
                    char** argv,
                    bool erase = false,
                    std::size_t start_position = 0);

      int
      end () const;

      virtual bool
      more ();

      virtual const char*
      peek ();

      virtual const char*
      next ();

      virtual void
      skip ();

      virtual std::size_t
      position ();

      protected:
      std::size_t start_position_;
      int i_;
      int& argc_;
      char** argv_;
      bool erase_;
    };

    class argv_file_scanner: public argv_scanner
    {
      public:
      argv_file_scanner (int& argc,
                         char** argv,
                         const std::string& option,
                         bool erase = false,
                         std::size_t start_position = 0);

      argv_file_scanner (int start,
                         int& argc,
                         char** argv,
                         const std::string& option,
                         bool erase = false,
                         std::size_t start_position = 0);

      argv_file_scanner (const std::string& file,
                         const std::string& option,
                         std::size_t start_position = 0);

      struct option_info
      {
        // If search_func is not NULL, it is called, with the arg
        // value as the second argument, to locate the options file.
        // If it returns an empty string, then the file is ignored.
        //
        const char* option;
        std::string (*search_func) (const char*, void* arg);
        void* arg;
      };

      argv_file_scanner (int& argc,
                          char** argv,
                          const option_info* options,
                          std::size_t options_count,
                          bool erase = false,
                          std::size_t start_position = 0);

      argv_file_scanner (int start,
                         int& argc,
                         char** argv,
                         const option_info* options,
                         std::size_t options_count,
                         bool erase = false,
                         std::size_t start_position = 0);

      argv_file_scanner (const std::string& file,
                         const option_info* options = 0,
                         std::size_t options_count = 0,
                         std::size_t start_position = 0);

      virtual bool
      more ();

      virtual const char*
      peek ();

      virtual const char*
      next ();

      virtual void
      skip ();

      virtual std::size_t
      position ();

      // Return the file path if the peeked at argument came from a file and
      // the empty string otherwise. The reference is guaranteed to be valid
      // till the end of the scanner lifetime.
      //
      const std::string&
      peek_file ();

      // Return the 1-based line number if the peeked at argument came from
      // a file and zero otherwise.
      //
      std::size_t
      peek_line ();

      private:
      const option_info*
      find (const char*) const;

      void
      load (const std::string& file);

      typedef argv_scanner base;

      const std::string option_;
      option_info option_info_;
      const option_info* options_;
      std::size_t options_count_;

      struct arg
      {
        std::string value;
        const std::string* file;
        std::size_t line;
      };

      std::deque<arg> args_;
      std::list<std::string> files_;

      // Circular buffer of two arguments.
      //
      std::string hold_[2];
      std::size_t i_;

      bool skip_;

      static int zero_argc_;
      static std::string empty_string_;
    };

    typedef std::vector<std::string> option_names;

    class option
    {
      public:

      const std::string&
      name () const;

      const option_names&
      aliases () const;

      bool
      flag () const;

      const std::string&
      default_value () const;

      public:option ();
      option (const std::string& name,
              const option_names& aliases,
              bool flag,
              const std::string& default_value);

      private:
      std::string name_;
      option_names aliases_;
      bool flag_;
      std::string default_value_;
    };

    class options: public std::vector<option>
    {
      public:
      typedef std::vector<option> container_type;

      container_type::const_iterator
      find (const std::string& name) const;

      void
      push_back (const option&);
      private:
      typedef std::map<std::string, container_type::size_type> map_type;
      map_type map_;
    };

    template <typename X>
    struct parser;
  }
}

#include <map>

#include <regex>

#include <libbpkg/manifest.hxx>

#include <libbbot/manifest.hxx>

#include <web/xhtml/fragment.hxx>

#include <libbrep/types.hxx>

#include <mod/options-types.hxx>

namespace brep
{
  namespace options
  {
    class repository_email
    {
      public:
      repository_email ();

      repository_email (int& argc,
                        char** argv,
                        bool erase = false,
                        ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                        ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_email (int start,
                        int& argc,
                        char** argv,
                        bool erase = false,
                        ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                        ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_email (int& argc,
                        char** argv,
                        int& end,
                        bool erase = false,
                        ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                        ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_email (int start,
                        int& argc,
                        char** argv,
                        int& end,
                        bool erase = false,
                        ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                        ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_email (::brep::cli::scanner&,
                        ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                        ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      email () const;

      string&
      email ();

      void
      email (const string&);

      bool
      email_specified () const;

      void
      email_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_repository_email_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string email_;
      bool email_specified_;
    };

    class repository_url
    {
      public:
      repository_url ();

      repository_url (int& argc,
                      char** argv,
                      bool erase = false,
                      ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                      ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_url (int start,
                      int& argc,
                      char** argv,
                      bool erase = false,
                      ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                      ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_url (int& argc,
                      char** argv,
                      int& end,
                      bool erase = false,
                      ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                      ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_url (int start,
                      int& argc,
                      char** argv,
                      int& end,
                      bool erase = false,
                      ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                      ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_url (::brep::cli::scanner&,
                      ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                      ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      host () const;

      string&
      host ();

      void
      host (const string&);

      bool
      host_specified () const;

      void
      host_specified (bool);

      const dir_path&
      root () const;

      dir_path&
      root ();

      void
      root (const dir_path&);

      bool
      root_specified () const;

      void
      root_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_repository_url_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string host_;
      bool host_specified_;
      dir_path root_;
      bool root_specified_;
    };

    class build_email_notification: public ::brep::options::repository_email,
      public ::brep::options::repository_url
    {
      public:
      build_email_notification ();

      build_email_notification (int& argc,
                                char** argv,
                                bool erase = false,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_email_notification (int start,
                                int& argc,
                                char** argv,
                                bool erase = false,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_email_notification (int& argc,
                                char** argv,
                                int& end,
                                bool erase = false,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_email_notification (int start,
                                int& argc,
                                char** argv,
                                int& end,
                                bool erase = false,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_email_notification (::brep::cli::scanner&,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const std::map<string, build_email>&
      build_toolchain_email () const;

      std::map<string, build_email>&
      build_toolchain_email ();

      void
      build_toolchain_email (const std::map<string, build_email>&);

      bool
      build_toolchain_email_specified () const;

      void
      build_toolchain_email_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_email_notification_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      std::map<string, build_email> build_toolchain_email_;
      bool build_toolchain_email_specified_;
    };

    class handler
    {
      public:
      handler ();

      handler (int& argc,
               char** argv,
               bool erase = false,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      handler (int start,
               int& argc,
               char** argv,
               bool erase = false,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      handler (int& argc,
               char** argv,
               int& end,
               bool erase = false,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      handler (int start,
               int& argc,
               char** argv,
               int& end,
               bool erase = false,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      handler (::brep::cli::scanner&,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      tenant_name () const;

      string&
      tenant_name ();

      void
      tenant_name (const string&);

      bool
      tenant_name_specified () const;

      void
      tenant_name_specified (bool);

      const uint16_t&
      verbosity () const;

      uint16_t&
      verbosity ();

      void
      verbosity (const uint16_t&);

      bool
      verbosity_specified () const;

      void
      verbosity_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_handler_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string tenant_name_;
      bool tenant_name_specified_;
      uint16_t verbosity_;
      bool verbosity_specified_;
    };

    class openssl_options
    {
      public:
      openssl_options ();

      openssl_options (int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      openssl_options (int start,
                       int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      openssl_options (int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      openssl_options (int start,
                       int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      openssl_options (::brep::cli::scanner&,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const path&
      openssl () const;

      path&
      openssl ();

      void
      openssl (const path&);

      bool
      openssl_specified () const;

      void
      openssl_specified (bool);

      const strings&
      openssl_option () const;

      strings&
      openssl_option ();

      void
      openssl_option (const strings&);

      bool
      openssl_option_specified () const;

      void
      openssl_option_specified (bool);

      const strings&
      openssl_envvar () const;

      strings&
      openssl_envvar ();

      void
      openssl_envvar (const strings&);

      bool
      openssl_envvar_specified () const;

      void
      openssl_envvar_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_openssl_options_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      path openssl_;
      bool openssl_specified_;
      strings openssl_option_;
      bool openssl_option_specified_;
      strings openssl_envvar_;
      bool openssl_envvar_specified_;
    };

    class package_db
    {
      public:
      package_db ();

      package_db (int& argc,
                  char** argv,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_db (int start,
                  int& argc,
                  char** argv,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_db (int& argc,
                  char** argv,
                  int& end,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_db (int start,
                  int& argc,
                  char** argv,
                  int& end,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_db (::brep::cli::scanner&,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      package_db_user () const;

      string&
      package_db_user ();

      void
      package_db_user (const string&);

      bool
      package_db_user_specified () const;

      void
      package_db_user_specified (bool);

      const string&
      package_db_role () const;

      string&
      package_db_role ();

      void
      package_db_role (const string&);

      bool
      package_db_role_specified () const;

      void
      package_db_role_specified (bool);

      const string&
      package_db_password () const;

      string&
      package_db_password ();

      void
      package_db_password (const string&);

      bool
      package_db_password_specified () const;

      void
      package_db_password_specified (bool);

      const string&
      package_db_name () const;

      string&
      package_db_name ();

      void
      package_db_name (const string&);

      bool
      package_db_name_specified () const;

      void
      package_db_name_specified (bool);

      const string&
      package_db_host () const;

      string&
      package_db_host ();

      void
      package_db_host (const string&);

      bool
      package_db_host_specified () const;

      void
      package_db_host_specified (bool);

      const uint16_t&
      package_db_port () const;

      uint16_t&
      package_db_port ();

      void
      package_db_port (const uint16_t&);

      bool
      package_db_port_specified () const;

      void
      package_db_port_specified (bool);

      const size_t&
      package_db_max_connections () const;

      size_t&
      package_db_max_connections ();

      void
      package_db_max_connections (const size_t&);

      bool
      package_db_max_connections_specified () const;

      void
      package_db_max_connections_specified (bool);

      const size_t&
      package_db_retry () const;

      size_t&
      package_db_retry ();

      void
      package_db_retry (const size_t&);

      bool
      package_db_retry_specified () const;

      void
      package_db_retry_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_package_db_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string package_db_user_;
      bool package_db_user_specified_;
      string package_db_role_;
      bool package_db_role_specified_;
      string package_db_password_;
      bool package_db_password_specified_;
      string package_db_name_;
      bool package_db_name_specified_;
      string package_db_host_;
      bool package_db_host_specified_;
      uint16_t package_db_port_;
      bool package_db_port_specified_;
      size_t package_db_max_connections_;
      bool package_db_max_connections_specified_;
      size_t package_db_retry_;
      bool package_db_retry_specified_;
    };

    class build: public ::brep::options::openssl_options
    {
      public:
      build ();

      build (int& argc,
             char** argv,
             bool erase = false,
             ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
             ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build (int start,
             int& argc,
             char** argv,
             bool erase = false,
             ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
             ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build (int& argc,
             char** argv,
             int& end,
             bool erase = false,
             ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
             ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build (int start,
             int& argc,
             char** argv,
             int& end,
             bool erase = false,
             ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
             ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build (::brep::cli::scanner&,
             ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
             ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const path&
      build_config () const;

      path&
      build_config ();

      void
      build_config (const path&);

      bool
      build_config_specified () const;

      void
      build_config_specified (bool);

      const dir_path&
      build_bot_agent_keys () const;

      dir_path&
      build_bot_agent_keys ();

      void
      build_bot_agent_keys (const dir_path&);

      bool
      build_bot_agent_keys_specified () const;

      void
      build_bot_agent_keys_specified (bool);

      const size_t&
      build_forced_rebuild_timeout () const;

      size_t&
      build_forced_rebuild_timeout ();

      void
      build_forced_rebuild_timeout (const size_t&);

      bool
      build_forced_rebuild_timeout_specified () const;

      void
      build_forced_rebuild_timeout_specified (bool);

      const size_t&
      build_soft_rebuild_timeout () const;

      size_t&
      build_soft_rebuild_timeout ();

      void
      build_soft_rebuild_timeout (const size_t&);

      bool
      build_soft_rebuild_timeout_specified () const;

      void
      build_soft_rebuild_timeout_specified (bool);

      const size_t&
      build_alt_soft_rebuild_timeout () const;

      size_t&
      build_alt_soft_rebuild_timeout ();

      void
      build_alt_soft_rebuild_timeout (const size_t&);

      bool
      build_alt_soft_rebuild_timeout_specified () const;

      void
      build_alt_soft_rebuild_timeout_specified (bool);

      const duration&
      build_alt_soft_rebuild_start () const;

      duration&
      build_alt_soft_rebuild_start ();

      void
      build_alt_soft_rebuild_start (const duration&);

      bool
      build_alt_soft_rebuild_start_specified () const;

      void
      build_alt_soft_rebuild_start_specified (bool);

      const duration&
      build_alt_soft_rebuild_stop () const;

      duration&
      build_alt_soft_rebuild_stop ();

      void
      build_alt_soft_rebuild_stop (const duration&);

      bool
      build_alt_soft_rebuild_stop_specified () const;

      void
      build_alt_soft_rebuild_stop_specified (bool);

      const size_t&
      build_hard_rebuild_timeout () const;

      size_t&
      build_hard_rebuild_timeout ();

      void
      build_hard_rebuild_timeout (const size_t&);

      bool
      build_hard_rebuild_timeout_specified () const;

      void
      build_hard_rebuild_timeout_specified (bool);

      const size_t&
      build_alt_hard_rebuild_timeout () const;

      size_t&
      build_alt_hard_rebuild_timeout ();

      void
      build_alt_hard_rebuild_timeout (const size_t&);

      bool
      build_alt_hard_rebuild_timeout_specified () const;

      void
      build_alt_hard_rebuild_timeout_specified (bool);

      const duration&
      build_alt_hard_rebuild_start () const;

      duration&
      build_alt_hard_rebuild_start ();

      void
      build_alt_hard_rebuild_start (const duration&);

      bool
      build_alt_hard_rebuild_start_specified () const;

      void
      build_alt_hard_rebuild_start_specified (bool);

      const duration&
      build_alt_hard_rebuild_stop () const;

      duration&
      build_alt_hard_rebuild_stop ();

      void
      build_alt_hard_rebuild_stop (const duration&);

      bool
      build_alt_hard_rebuild_stop_specified () const;

      void
      build_alt_hard_rebuild_stop_specified (bool);

      const size_t&
      build_queued_timeout () const;

      size_t&
      build_queued_timeout ();

      void
      build_queued_timeout (const size_t&);

      bool
      build_queued_timeout_specified () const;

      void
      build_queued_timeout_specified (bool);

      const size_t&
      build_queued_batch () const;

      size_t&
      build_queued_batch ();

      void
      build_queued_batch (const size_t&);

      bool
      build_queued_batch_specified () const;

      void
      build_queued_batch_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      path build_config_;
      bool build_config_specified_;
      dir_path build_bot_agent_keys_;
      bool build_bot_agent_keys_specified_;
      size_t build_forced_rebuild_timeout_;
      bool build_forced_rebuild_timeout_specified_;
      size_t build_soft_rebuild_timeout_;
      bool build_soft_rebuild_timeout_specified_;
      size_t build_alt_soft_rebuild_timeout_;
      bool build_alt_soft_rebuild_timeout_specified_;
      duration build_alt_soft_rebuild_start_;
      bool build_alt_soft_rebuild_start_specified_;
      duration build_alt_soft_rebuild_stop_;
      bool build_alt_soft_rebuild_stop_specified_;
      size_t build_hard_rebuild_timeout_;
      bool build_hard_rebuild_timeout_specified_;
      size_t build_alt_hard_rebuild_timeout_;
      bool build_alt_hard_rebuild_timeout_specified_;
      duration build_alt_hard_rebuild_start_;
      bool build_alt_hard_rebuild_start_specified_;
      duration build_alt_hard_rebuild_stop_;
      bool build_alt_hard_rebuild_stop_specified_;
      size_t build_queued_timeout_;
      bool build_queued_timeout_specified_;
      size_t build_queued_batch_;
      bool build_queued_batch_specified_;
    };

    class build_db
    {
      public:
      build_db ();

      build_db (int& argc,
                char** argv,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_db (int start,
                int& argc,
                char** argv,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_db (int& argc,
                char** argv,
                int& end,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_db (int start,
                int& argc,
                char** argv,
                int& end,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_db (::brep::cli::scanner&,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      build_db_user () const;

      string&
      build_db_user ();

      void
      build_db_user (const string&);

      bool
      build_db_user_specified () const;

      void
      build_db_user_specified (bool);

      const string&
      build_db_role () const;

      string&
      build_db_role ();

      void
      build_db_role (const string&);

      bool
      build_db_role_specified () const;

      void
      build_db_role_specified (bool);

      const string&
      build_db_password () const;

      string&
      build_db_password ();

      void
      build_db_password (const string&);

      bool
      build_db_password_specified () const;

      void
      build_db_password_specified (bool);

      const string&
      build_db_name () const;

      string&
      build_db_name ();

      void
      build_db_name (const string&);

      bool
      build_db_name_specified () const;

      void
      build_db_name_specified (bool);

      const string&
      build_db_host () const;

      string&
      build_db_host ();

      void
      build_db_host (const string&);

      bool
      build_db_host_specified () const;

      void
      build_db_host_specified (bool);

      const uint16_t&
      build_db_port () const;

      uint16_t&
      build_db_port ();

      void
      build_db_port (const uint16_t&);

      bool
      build_db_port_specified () const;

      void
      build_db_port_specified (bool);

      const size_t&
      build_db_max_connections () const;

      size_t&
      build_db_max_connections ();

      void
      build_db_max_connections (const size_t&);

      bool
      build_db_max_connections_specified () const;

      void
      build_db_max_connections_specified (bool);

      const size_t&
      build_db_retry () const;

      size_t&
      build_db_retry ();

      void
      build_db_retry (const size_t&);

      bool
      build_db_retry_specified () const;

      void
      build_db_retry_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_db_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string build_db_user_;
      bool build_db_user_specified_;
      string build_db_role_;
      bool build_db_role_specified_;
      string build_db_password_;
      bool build_db_password_specified_;
      string build_db_name_;
      bool build_db_name_specified_;
      string build_db_host_;
      bool build_db_host_specified_;
      uint16_t build_db_port_;
      bool build_db_port_specified_;
      size_t build_db_max_connections_;
      bool build_db_max_connections_specified_;
      size_t build_db_retry_;
      bool build_db_retry_specified_;
    };

    class build_upload
    {
      public:
      build_upload ();

      build_upload (int& argc,
                    char** argv,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_upload (int start,
                    int& argc,
                    char** argv,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_upload (int& argc,
                    char** argv,
                    int& end,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_upload (int start,
                    int& argc,
                    char** argv,
                    int& end,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_upload (::brep::cli::scanner&,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const std::map<string, dir_path>&
      upload_data () const;

      std::map<string, dir_path>&
      upload_data ();

      void
      upload_data (const std::map<string, dir_path>&);

      bool
      upload_data_specified () const;

      void
      upload_data_specified (bool);

      const std::map<string, size_t>&
      upload_max_size () const;

      std::map<string, size_t>&
      upload_max_size ();

      void
      upload_max_size (const std::map<string, size_t>&);

      bool
      upload_max_size_specified () const;

      void
      upload_max_size_specified (bool);

      const std::map<string, string>&
      upload_email () const;

      std::map<string, string>&
      upload_email ();

      void
      upload_email (const std::map<string, string>&);

      bool
      upload_email_specified () const;

      void
      upload_email_specified (bool);

      const std::map<string, path>&
      upload_handler () const;

      std::map<string, path>&
      upload_handler ();

      void
      upload_handler (const std::map<string, path>&);

      bool
      upload_handler_specified () const;

      void
      upload_handler_specified (bool);

      const std::multimap<string, string>&
      upload_handler_argument () const;

      std::multimap<string, string>&
      upload_handler_argument ();

      void
      upload_handler_argument (const std::multimap<string, string>&);

      bool
      upload_handler_argument_specified () const;

      void
      upload_handler_argument_specified (bool);

      const std::map<string, size_t>&
      upload_handler_timeout () const;

      std::map<string, size_t>&
      upload_handler_timeout ();

      void
      upload_handler_timeout (const std::map<string, size_t>&);

      bool
      upload_handler_timeout_specified () const;

      void
      upload_handler_timeout_specified (bool);

      const std::multimap<string, string>&
      upload_toolchain_exclude () const;

      std::multimap<string, string>&
      upload_toolchain_exclude ();

      void
      upload_toolchain_exclude (const std::multimap<string, string>&);

      bool
      upload_toolchain_exclude_specified () const;

      void
      upload_toolchain_exclude_specified (bool);

      const std::multimap<string, string>&
      upload_repository_exclude () const;

      std::multimap<string, string>&
      upload_repository_exclude ();

      void
      upload_repository_exclude (const std::multimap<string, string>&);

      bool
      upload_repository_exclude_specified () const;

      void
      upload_repository_exclude_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_upload_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      std::map<string, dir_path> upload_data_;
      bool upload_data_specified_;
      std::map<string, size_t> upload_max_size_;
      bool upload_max_size_specified_;
      std::map<string, string> upload_email_;
      bool upload_email_specified_;
      std::map<string, path> upload_handler_;
      bool upload_handler_specified_;
      std::multimap<string, string> upload_handler_argument_;
      bool upload_handler_argument_specified_;
      std::map<string, size_t> upload_handler_timeout_;
      bool upload_handler_timeout_specified_;
      std::multimap<string, string> upload_toolchain_exclude_;
      bool upload_toolchain_exclude_specified_;
      std::multimap<string, string> upload_repository_exclude_;
      bool upload_repository_exclude_specified_;
    };

    class package_version_metadata
    {
      public:
      package_version_metadata ();

      package_version_metadata (int& argc,
                                char** argv,
                                bool erase = false,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_metadata (int start,
                                int& argc,
                                char** argv,
                                bool erase = false,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_metadata (int& argc,
                                char** argv,
                                int& end,
                                bool erase = false,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_metadata (int start,
                                int& argc,
                                char** argv,
                                int& end,
                                bool erase = false,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_metadata (::brep::cli::scanner&,
                                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      reviews_url () const;

      string&
      reviews_url ();

      void
      reviews_url (const string&);

      bool
      reviews_url_specified () const;

      void
      reviews_url_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_package_version_metadata_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string reviews_url_;
      bool reviews_url_specified_;
    };

    class page
    {
      public:
      page ();

      page (int& argc,
            char** argv,
            bool erase = false,
            ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
            ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      page (int start,
            int& argc,
            char** argv,
            bool erase = false,
            ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
            ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      page (int& argc,
            char** argv,
            int& end,
            bool erase = false,
            ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
            ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      page (int start,
            int& argc,
            char** argv,
            int& end,
            bool erase = false,
            ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
            ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      page (::brep::cli::scanner&,
            ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
            ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const web::xhtml::fragment&
      logo () const;

      web::xhtml::fragment&
      logo ();

      void
      logo (const web::xhtml::fragment&);

      bool
      logo_specified () const;

      void
      logo_specified (bool);

      const vector<page_menu>&
      menu () const;

      vector<page_menu>&
      menu ();

      void
      menu (const vector<page_menu>&);

      bool
      menu_specified () const;

      void
      menu_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_page_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      web::xhtml::fragment logo_;
      bool logo_specified_;
      vector<page_menu> menu_;
      bool menu_specified_;
    };

    class search
    {
      public:
      search ();

      search (int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      search (int start,
              int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      search (int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      search (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      search (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const uint16_t&
      search_page_entries () const;

      uint16_t&
      search_page_entries ();

      void
      search_page_entries (const uint16_t&);

      bool
      search_page_entries_specified () const;

      void
      search_page_entries_specified (bool);

      const uint16_t&
      search_pages () const;

      uint16_t&
      search_pages ();

      void
      search_pages (const uint16_t&);

      bool
      search_pages_specified () const;

      void
      search_pages_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_search_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      uint16_t search_page_entries_;
      bool search_page_entries_specified_;
      uint16_t search_pages_;
      bool search_pages_specified_;
    };

    class package
    {
      public:
      package ();

      package (int& argc,
               char** argv,
               bool erase = false,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package (int start,
               int& argc,
               char** argv,
               bool erase = false,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package (int& argc,
               char** argv,
               int& end,
               bool erase = false,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package (int start,
               int& argc,
               char** argv,
               int& end,
               bool erase = false,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package (::brep::cli::scanner&,
               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const uint16_t&
      package_description () const;

      uint16_t&
      package_description ();

      void
      package_description (const uint16_t&);

      bool
      package_description_specified () const;

      void
      package_description_specified (bool);

      const uint16_t&
      package_changes () const;

      uint16_t&
      package_changes ();

      void
      package_changes (const uint16_t&);

      bool
      package_changes_specified () const;

      void
      package_changes_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_package_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      uint16_t package_description_;
      bool package_description_specified_;
      uint16_t package_changes_;
      bool package_changes_specified_;
    };

    class packages: public ::brep::options::search,
      public ::brep::options::package_db,
      public ::brep::options::page,
      public ::brep::options::repository_url,
      public ::brep::options::handler
    {
      public:
      packages ();

      packages (int& argc,
                char** argv,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      packages (int start,
                int& argc,
                char** argv,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      packages (int& argc,
                char** argv,
                int& end,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      packages (int start,
                int& argc,
                char** argv,
                int& end,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      packages (::brep::cli::scanner&,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      search_title () const;

      string&
      search_title ();

      void
      search_title (const string&);

      bool
      search_title_specified () const;

      void
      search_title_specified (bool);

      const web::xhtml::fragment&
      search_description () const;

      web::xhtml::fragment&
      search_description ();

      void
      search_description (const web::xhtml::fragment&);

      bool
      search_description_specified () const;

      void
      search_description_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_packages_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string search_title_;
      bool search_title_specified_;
      web::xhtml::fragment search_description_;
      bool search_description_specified_;
    };

    class advanced_search: public ::brep::options::package_db,
      public ::brep::options::search,
      public ::brep::options::page,
      public ::brep::options::repository_url,
      public ::brep::options::package_version_metadata,
      public ::brep::options::handler
    {
      public:
      advanced_search ();

      advanced_search (int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      advanced_search (int start,
                       int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      advanced_search (int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      advanced_search (int start,
                       int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      advanced_search (::brep::cli::scanner&,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_advanced_search_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class package_details: public ::brep::options::package,
      public ::brep::options::package_db,
      public ::brep::options::search,
      public ::brep::options::page,
      public ::brep::options::repository_url,
      public ::brep::options::package_version_metadata,
      public ::brep::options::handler
    {
      public:
      package_details ();

      package_details (int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_details (int start,
                       int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_details (int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_details (int start,
                       int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_details (::brep::cli::scanner&,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_package_details_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class package_version_details: public ::brep::options::package,
      public ::brep::options::package_db,
      public ::brep::options::build,
      public ::brep::options::build_db,
      public ::brep::options::page,
      public ::brep::options::repository_url,
      public ::brep::options::package_version_metadata,
      public ::brep::options::handler
    {
      public:
      package_version_details ();

      package_version_details (int& argc,
                               char** argv,
                               bool erase = false,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_details (int start,
                               int& argc,
                               char** argv,
                               bool erase = false,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_details (int& argc,
                               char** argv,
                               int& end,
                               bool erase = false,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_details (int start,
                               int& argc,
                               char** argv,
                               int& end,
                               bool erase = false,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_details (::brep::cli::scanner&,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const dir_path&
      bindist_root () const;

      dir_path&
      bindist_root ();

      void
      bindist_root (const dir_path&);

      bool
      bindist_root_specified () const;

      void
      bindist_root_specified (bool);

      const string&
      bindist_url () const;

      string&
      bindist_url ();

      void
      bindist_url (const string&);

      bool
      bindist_url_specified () const;

      void
      bindist_url_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_package_version_details_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      dir_path bindist_root_;
      bool bindist_root_specified_;
      string bindist_url_;
      bool bindist_url_specified_;
    };

    class repository_details: public ::brep::options::package_db,
      public ::brep::options::page,
      public ::brep::options::repository_url,
      public ::brep::options::handler
    {
      public:
      repository_details ();

      repository_details (int& argc,
                          char** argv,
                          bool erase = false,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_details (int start,
                          int& argc,
                          char** argv,
                          bool erase = false,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_details (int& argc,
                          char** argv,
                          int& end,
                          bool erase = false,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_details (int start,
                          int& argc,
                          char** argv,
                          int& end,
                          bool erase = false,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_details (::brep::cli::scanner&,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_repository_details_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class build_task: public ::brep::options::build,
      public ::brep::options::build_db,
      public ::brep::options::build_upload,
      public ::brep::options::build_email_notification,
      public ::brep::options::handler
    {
      public:
      build_task ();

      build_task (int& argc,
                  char** argv,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_task (int start,
                  int& argc,
                  char** argv,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_task (int& argc,
                  char** argv,
                  int& end,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_task (int start,
                  int& argc,
                  char** argv,
                  int& end,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_task (::brep::cli::scanner&,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const size_t&
      build_task_request_max_size () const;

      size_t&
      build_task_request_max_size ();

      void
      build_task_request_max_size (const size_t&);

      bool
      build_task_request_max_size_specified () const;

      void
      build_task_request_max_size_specified (bool);

      const size_t&
      build_result_timeout () const;

      size_t&
      build_result_timeout ();

      void
      build_result_timeout (const size_t&);

      bool
      build_result_timeout_specified () const;

      void
      build_result_timeout_specified (bool);

      const vector<pair<std::regex, string>>&
      build_interactive_login () const;

      vector<pair<std::regex, string>>&
      build_interactive_login ();

      void
      build_interactive_login (const vector<pair<std::regex, string>>&);

      bool
      build_interactive_login_specified () const;

      void
      build_interactive_login_specified (bool);

      const build_order&
      build_package_order () const;

      build_order&
      build_package_order ();

      void
      build_package_order (const build_order&);

      bool
      build_package_order_specified () const;

      void
      build_package_order_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_task_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      size_t build_task_request_max_size_;
      bool build_task_request_max_size_specified_;
      size_t build_result_timeout_;
      bool build_result_timeout_specified_;
      vector<pair<std::regex, string>> build_interactive_login_;
      bool build_interactive_login_specified_;
      build_order build_package_order_;
      bool build_package_order_specified_;
    };

    class build_result: public ::brep::options::build,
      public ::brep::options::build_db,
      public ::brep::options::build_email_notification,
      public ::brep::options::handler
    {
      public:
      build_result ();

      build_result (int& argc,
                    char** argv,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_result (int start,
                    int& argc,
                    char** argv,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_result (int& argc,
                    char** argv,
                    int& end,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_result (int start,
                    int& argc,
                    char** argv,
                    int& end,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_result (::brep::cli::scanner&,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const size_t&
      build_result_request_max_size () const;

      size_t&
      build_result_request_max_size ();

      void
      build_result_request_max_size (const size_t&);

      bool
      build_result_request_max_size_specified () const;

      void
      build_result_request_max_size_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_result_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      size_t build_result_request_max_size_;
      bool build_result_request_max_size_specified_;
    };

    class build_log: public ::brep::options::build,
      public ::brep::options::build_db,
      public ::brep::options::repository_url,
      public ::brep::options::handler
    {
      public:
      build_log ();

      build_log (int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_log (int start,
                 int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_log (int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_log (int start,
                 int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_log (::brep::cli::scanner&,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_log_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class build_force: public ::brep::options::build,
      public ::brep::options::build_db,
      public ::brep::options::handler
    {
      public:
      build_force ();

      build_force (int& argc,
                   char** argv,
                   bool erase = false,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_force (int start,
                   int& argc,
                   char** argv,
                   bool erase = false,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_force (int& argc,
                   char** argv,
                   int& end,
                   bool erase = false,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_force (int start,
                   int& argc,
                   char** argv,
                   int& end,
                   bool erase = false,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_force (::brep::cli::scanner&,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_force_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class builds: public ::brep::options::build,
      public ::brep::options::build_db,
      public ::brep::options::page,
      public ::brep::options::repository_url,
      public ::brep::options::handler
    {
      public:
      builds ();

      builds (int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      builds (int start,
              int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      builds (int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      builds (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      builds (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const uint16_t&
      build_page_entries () const;

      uint16_t&
      build_page_entries ();

      void
      build_page_entries (const uint16_t&);

      bool
      build_page_entries_specified () const;

      void
      build_page_entries_specified (bool);

      const uint16_t&
      build_pages () const;

      uint16_t&
      build_pages ();

      void
      build_pages (const uint16_t&);

      bool
      build_pages_specified () const;

      void
      build_pages_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_builds_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      uint16_t build_page_entries_;
      bool build_page_entries_specified_;
      uint16_t build_pages_;
      bool build_pages_specified_;
    };

    class build_configs: public ::brep::options::build,
      public ::brep::options::page,
      public ::brep::options::repository_url,
      public ::brep::options::handler
    {
      public:
      build_configs ();

      build_configs (int& argc,
                     char** argv,
                     bool erase = false,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_configs (int start,
                     int& argc,
                     char** argv,
                     bool erase = false,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_configs (int& argc,
                     char** argv,
                     int& end,
                     bool erase = false,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_configs (int start,
                     int& argc,
                     char** argv,
                     int& end,
                     bool erase = false,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_configs (::brep::cli::scanner&,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const uint16_t&
      build_config_page_entries () const;

      uint16_t&
      build_config_page_entries ();

      void
      build_config_page_entries (const uint16_t&);

      bool
      build_config_page_entries_specified () const;

      void
      build_config_page_entries_specified (bool);

      const uint16_t&
      build_config_pages () const;

      uint16_t&
      build_config_pages ();

      void
      build_config_pages (const uint16_t&);

      bool
      build_config_pages_specified () const;

      void
      build_config_pages_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_configs_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      uint16_t build_config_page_entries_;
      bool build_config_page_entries_specified_;
      uint16_t build_config_pages_;
      bool build_config_pages_specified_;
    };

    class submit: public ::brep::options::page,
      public ::brep::options::repository_email,
      public ::brep::options::repository_url,
      public ::brep::options::handler
    {
      public:
      submit ();

      submit (int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      submit (int start,
              int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      submit (int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      submit (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      submit (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const dir_path&
      submit_data () const;

      dir_path&
      submit_data ();

      void
      submit_data (const dir_path&);

      bool
      submit_data_specified () const;

      void
      submit_data_specified (bool);

      const dir_path&
      submit_temp () const;

      dir_path&
      submit_temp ();

      void
      submit_temp (const dir_path&);

      bool
      submit_temp_specified () const;

      void
      submit_temp_specified (bool);

      const size_t&
      submit_max_size () const;

      size_t&
      submit_max_size ();

      void
      submit_max_size (const size_t&);

      bool
      submit_max_size_specified () const;

      void
      submit_max_size_specified (bool);

      const path&
      submit_form () const;

      path&
      submit_form ();

      void
      submit_form (const path&);

      bool
      submit_form_specified () const;

      void
      submit_form_specified (bool);

      const string&
      submit_email () const;

      string&
      submit_email ();

      void
      submit_email (const string&);

      bool
      submit_email_specified () const;

      void
      submit_email_specified (bool);

      const path&
      submit_handler () const;

      path&
      submit_handler ();

      void
      submit_handler (const path&);

      bool
      submit_handler_specified () const;

      void
      submit_handler_specified (bool);

      const strings&
      submit_handler_argument () const;

      strings&
      submit_handler_argument ();

      void
      submit_handler_argument (const strings&);

      bool
      submit_handler_argument_specified () const;

      void
      submit_handler_argument_specified (bool);

      const size_t&
      submit_handler_timeout () const;

      size_t&
      submit_handler_timeout ();

      void
      submit_handler_timeout (const size_t&);

      bool
      submit_handler_timeout_specified () const;

      void
      submit_handler_timeout_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_submit_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      dir_path submit_data_;
      bool submit_data_specified_;
      dir_path submit_temp_;
      bool submit_temp_specified_;
      size_t submit_max_size_;
      bool submit_max_size_specified_;
      path submit_form_;
      bool submit_form_specified_;
      string submit_email_;
      bool submit_email_specified_;
      path submit_handler_;
      bool submit_handler_specified_;
      strings submit_handler_argument_;
      bool submit_handler_argument_specified_;
      size_t submit_handler_timeout_;
      bool submit_handler_timeout_specified_;
    };

    class ci_start: public ::brep::options::repository_email
    {
      public:
      ci_start ();

      ci_start (int& argc,
                char** argv,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_start (int start,
                int& argc,
                char** argv,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_start (int& argc,
                char** argv,
                int& end,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_start (int start,
                int& argc,
                char** argv,
                int& end,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_start (::brep::cli::scanner&,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const dir_path&
      ci_data () const;

      dir_path&
      ci_data ();

      void
      ci_data (const dir_path&);

      bool
      ci_data_specified () const;

      void
      ci_data_specified (bool);

      const string&
      ci_email () const;

      string&
      ci_email ();

      void
      ci_email (const string&);

      bool
      ci_email_specified () const;

      void
      ci_email_specified (bool);

      const path&
      ci_handler () const;

      path&
      ci_handler ();

      void
      ci_handler (const path&);

      bool
      ci_handler_specified () const;

      void
      ci_handler_specified (bool);

      const strings&
      ci_handler_argument () const;

      strings&
      ci_handler_argument ();

      void
      ci_handler_argument (const strings&);

      bool
      ci_handler_argument_specified () const;

      void
      ci_handler_argument_specified (bool);

      const size_t&
      ci_handler_timeout () const;

      size_t&
      ci_handler_timeout ();

      void
      ci_handler_timeout (const size_t&);

      bool
      ci_handler_timeout_specified () const;

      void
      ci_handler_timeout_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_ci_start_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      dir_path ci_data_;
      bool ci_data_specified_;
      string ci_email_;
      bool ci_email_specified_;
      path ci_handler_;
      bool ci_handler_specified_;
      strings ci_handler_argument_;
      bool ci_handler_argument_specified_;
      size_t ci_handler_timeout_;
      bool ci_handler_timeout_specified_;
    };

    class ci: public ::brep::options::ci_start,
      public ::brep::options::build,
      public ::brep::options::build_db,
      public ::brep::options::page,
      public ::brep::options::repository_url,
      public ::brep::options::handler
    {
      public:
      ci ();

      ci (int& argc,
          char** argv,
          bool erase = false,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci (int start,
          int& argc,
          char** argv,
          bool erase = false,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci (int& argc,
          char** argv,
          int& end,
          bool erase = false,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci (int start,
          int& argc,
          char** argv,
          int& end,
          bool erase = false,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci (::brep::cli::scanner&,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const path&
      ci_form () const;

      path&
      ci_form ();

      void
      ci_form (const path&);

      bool
      ci_form_specified () const;

      void
      ci_form_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_ci_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      path ci_form_;
      bool ci_form_specified_;
    };

    class ci_cancel: public ::brep::options::build,
      public ::brep::options::build_db,
      public ::brep::options::handler
    {
      public:
      ci_cancel ();

      ci_cancel (int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_cancel (int start,
                 int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_cancel (int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_cancel (int start,
                 int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_cancel (::brep::cli::scanner&,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_ci_cancel_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class ci_github: public ::brep::options::ci_start,
      public ::brep::options::ci_cancel,
      public ::brep::options::repository_url
    {
      public:
      ci_github ();

      ci_github (int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_github (int start,
                 int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_github (int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_github (int start,
                 int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_github (::brep::cli::scanner&,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const path&
      ci_github_app_webhook_secret () const;

      path&
      ci_github_app_webhook_secret ();

      void
      ci_github_app_webhook_secret (const path&);

      bool
      ci_github_app_webhook_secret_specified () const;

      void
      ci_github_app_webhook_secret_specified (bool);

      const std::map<uint64_t, dir_path>&
      ci_github_app_id_private_key () const;

      std::map<uint64_t, dir_path>&
      ci_github_app_id_private_key ();

      void
      ci_github_app_id_private_key (const std::map<uint64_t, dir_path>&);

      bool
      ci_github_app_id_private_key_specified () const;

      void
      ci_github_app_id_private_key_specified (bool);

      const uint16_t&
      ci_github_jwt_validity_period () const;

      uint16_t&
      ci_github_jwt_validity_period ();

      void
      ci_github_jwt_validity_period (const uint16_t&);

      bool
      ci_github_jwt_validity_period_specified () const;

      void
      ci_github_jwt_validity_period_specified (bool);

      const std::map<uint64_t, string>&
      ci_github_app_id_name () const;

      std::map<uint64_t, string>&
      ci_github_app_id_name ();

      void
      ci_github_app_id_name (const std::map<uint64_t, string>&);

      bool
      ci_github_app_id_name_specified () const;

      void
      ci_github_app_id_name_specified (bool);

      const size_t&
      ci_github_builds_aggregate_report () const;

      size_t&
      ci_github_builds_aggregate_report ();

      void
      ci_github_builds_aggregate_report (const size_t&);

      bool
      ci_github_builds_aggregate_report_specified () const;

      void
      ci_github_builds_aggregate_report_specified (bool);

      const size_t&
      ci_github_max_jobs_per_window () const;

      size_t&
      ci_github_max_jobs_per_window ();

      void
      ci_github_max_jobs_per_window (const size_t&);

      bool
      ci_github_max_jobs_per_window_specified () const;

      void
      ci_github_max_jobs_per_window_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_ci_github_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      path ci_github_app_webhook_secret_;
      bool ci_github_app_webhook_secret_specified_;
      std::map<uint64_t, dir_path> ci_github_app_id_private_key_;
      bool ci_github_app_id_private_key_specified_;
      uint16_t ci_github_jwt_validity_period_;
      bool ci_github_jwt_validity_period_specified_;
      std::map<uint64_t, string> ci_github_app_id_name_;
      bool ci_github_app_id_name_specified_;
      size_t ci_github_builds_aggregate_report_;
      bool ci_github_builds_aggregate_report_specified_;
      size_t ci_github_max_jobs_per_window_;
      bool ci_github_max_jobs_per_window_specified_;
    };

    class upload: public ::brep::options::build,
      public ::brep::options::build_db,
      public ::brep::options::build_upload,
      public ::brep::options::repository_email,
      public ::brep::options::handler
    {
      public:
      upload ();

      upload (int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      upload (int start,
              int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      upload (int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      upload (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      upload (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_upload_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class repository_root: public ::brep::options::repository_url,
      public ::brep::options::handler
    {
      public:
      repository_root ();

      repository_root (int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_root (int start,
                       int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_root (int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_root (int start,
                       int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_root (::brep::cli::scanner&,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      root_global_view () const;

      string&
      root_global_view ();

      void
      root_global_view (const string&);

      bool
      root_global_view_specified () const;

      void
      root_global_view_specified (bool);

      const string&
      root_tenant_view () const;

      string&
      root_tenant_view ();

      void
      root_tenant_view (const string&);

      bool
      root_tenant_view_specified () const;

      void
      root_tenant_view_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_repository_root_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string root_global_view_;
      bool root_global_view_specified_;
      string root_tenant_view_;
      bool root_tenant_view_specified_;
    };
  }

  namespace params
  {
    class packages
    {
      public:
      packages ();

      packages (int& argc,
                char** argv,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      packages (int start,
                int& argc,
                char** argv,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      packages (int& argc,
                char** argv,
                int& end,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      packages (int start,
                int& argc,
                char** argv,
                int& end,
                bool erase = false,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      packages (::brep::cli::scanner&,
                ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const uint16_t&
      page () const;

      uint16_t&
      page ();

      void
      page (const uint16_t&);

      bool
      page_specified () const;

      void
      page_specified (bool);

      const string&
      q () const;

      string&
      q ();

      void
      q (const string&);

      bool
      q_specified () const;

      void
      q_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_packages_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      uint16_t page_;
      bool page_specified_;
      string q_;
      bool q_specified_;
    };

    class advanced_search
    {
      public:
      advanced_search ();

      advanced_search (int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      advanced_search (int start,
                       int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      advanced_search (int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      advanced_search (int start,
                       int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      advanced_search (::brep::cli::scanner&,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const uint16_t&
      page () const;

      uint16_t&
      page ();

      void
      page (const uint16_t&);

      bool
      page_specified () const;

      void
      page_specified (bool);

      const string&
      name () const;

      string&
      name ();

      void
      name (const string&);

      bool
      name_specified () const;

      void
      name_specified (bool);

      const string&
      version () const;

      string&
      version ();

      void
      version (const string&);

      bool
      version_specified () const;

      void
      version_specified (bool);

      const string&
      project () const;

      string&
      project ();

      void
      project (const string&);

      bool
      project_specified () const;

      void
      project_specified (bool);

      const string&
      repository () const;

      string&
      repository ();

      void
      repository (const string&);

      bool
      repository_specified () const;

      void
      repository_specified (bool);

      const string&
      reviews () const;

      string&
      reviews ();

      void
      reviews (const string&);

      bool
      reviews_specified () const;

      void
      reviews_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_advanced_search_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      uint16_t page_;
      bool page_specified_;
      string name_;
      bool name_specified_;
      string version_;
      bool version_specified_;
      string project_;
      bool project_specified_;
      string repository_;
      bool repository_specified_;
      string reviews_;
      bool reviews_specified_;
    };

    class package_details
    {
      public:
      package_details ();

      package_details (int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_details (int start,
                       int& argc,
                       char** argv,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_details (int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_details (int start,
                       int& argc,
                       char** argv,
                       int& end,
                       bool erase = false,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_details (::brep::cli::scanner&,
                       ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                       ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const uint16_t&
      page () const;

      uint16_t&
      page ();

      void
      page (const uint16_t&);

      bool
      page_specified () const;

      void
      page_specified (bool);

      const string&
      query () const;

      string&
      query ();

      void
      query (const string&);

      bool
      query_specified () const;

      void
      query_specified (bool);

      const page_form&
      form () const;

      page_form&
      form ();

      void
      form (const page_form&);

      bool
      form_specified () const;

      void
      form_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_package_details_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      uint16_t page_;
      bool page_specified_;
      string query_;
      bool query_specified_;
      page_form form_;
      bool form_specified_;
    };

    class package_version_details
    {
      public:
      package_version_details ();

      package_version_details (int& argc,
                               char** argv,
                               bool erase = false,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_details (int start,
                               int& argc,
                               char** argv,
                               bool erase = false,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_details (int& argc,
                               char** argv,
                               int& end,
                               bool erase = false,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_details (int start,
                               int& argc,
                               char** argv,
                               int& end,
                               bool erase = false,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      package_version_details (::brep::cli::scanner&,
                               ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                               ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const page_form&
      form () const;

      page_form&
      form ();

      void
      form (const page_form&);

      bool
      form_specified () const;

      void
      form_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_package_version_details_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      page_form form_;
      bool form_specified_;
    };

    class repository_details
    {
      public:
      repository_details ();

      repository_details (int& argc,
                          char** argv,
                          bool erase = false,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_details (int start,
                          int& argc,
                          char** argv,
                          bool erase = false,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_details (int& argc,
                          char** argv,
                          int& end,
                          bool erase = false,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_details (int start,
                          int& argc,
                          char** argv,
                          int& end,
                          bool erase = false,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      repository_details (::brep::cli::scanner&,
                          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_repository_details_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class build_task
    {
      public:
      build_task ();

      build_task (int& argc,
                  char** argv,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_task (int start,
                  int& argc,
                  char** argv,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_task (int& argc,
                  char** argv,
                  int& end,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_task (int start,
                  int& argc,
                  char** argv,
                  int& end,
                  bool erase = false,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_task (::brep::cli::scanner&,
                  ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                  ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const vector<string>&
      repository () const;

      vector<string>&
      repository ();

      void
      repository (const vector<string>&);

      bool
      repository_specified () const;

      void
      repository_specified (bool);

      const bbot::interactive_mode&
      interactive () const;

      bbot::interactive_mode&
      interactive ();

      void
      interactive (const bbot::interactive_mode&);

      bool
      interactive_specified () const;

      void
      interactive_specified (bool);

      const vector<string>&
      tenant_service_type () const;

      vector<string>&
      tenant_service_type ();

      void
      tenant_service_type (const vector<string>&);

      bool
      tenant_service_type_specified () const;

      void
      tenant_service_type_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_task_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      vector<string> repository_;
      bool repository_specified_;
      bbot::interactive_mode interactive_;
      bool interactive_specified_;
      vector<string> tenant_service_type_;
      bool tenant_service_type_specified_;
    };

    class build_result
    {
      public:
      build_result ();

      build_result (int& argc,
                    char** argv,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_result (int start,
                    int& argc,
                    char** argv,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_result (int& argc,
                    char** argv,
                    int& end,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_result (int start,
                    int& argc,
                    char** argv,
                    int& end,
                    bool erase = false,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_result (::brep::cli::scanner&,
                    ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                    ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_result_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class build_log
    {
      public:
      build_log ();

      build_log (int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_log (int start,
                 int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_log (int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_log (int start,
                 int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_log (::brep::cli::scanner&,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_log_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
    };

    class build_force
    {
      public:
      build_force ();

      build_force (int& argc,
                   char** argv,
                   bool erase = false,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_force (int start,
                   int& argc,
                   char** argv,
                   bool erase = false,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_force (int& argc,
                   char** argv,
                   int& end,
                   bool erase = false,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_force (int start,
                   int& argc,
                   char** argv,
                   int& end,
                   bool erase = false,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_force (::brep::cli::scanner&,
                   ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                   ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      package () const;

      string&
      package ();

      void
      package (const string&);

      bool
      package_specified () const;

      void
      package_specified (bool);

      const string&
      version () const;

      string&
      version ();

      void
      version (const string&);

      bool
      version_specified () const;

      void
      version_specified (bool);

      const string&
      target () const;

      string&
      target ();

      void
      target (const string&);

      bool
      target_specified () const;

      void
      target_specified (bool);

      const string&
      target_config () const;

      string&
      target_config ();

      void
      target_config (const string&);

      bool
      target_config_specified () const;

      void
      target_config_specified (bool);

      const string&
      package_config () const;

      string&
      package_config ();

      void
      package_config (const string&);

      bool
      package_config_specified () const;

      void
      package_config_specified (bool);

      const string&
      toolchain_name () const;

      string&
      toolchain_name ();

      void
      toolchain_name (const string&);

      bool
      toolchain_name_specified () const;

      void
      toolchain_name_specified (bool);

      const string&
      toolchain_version () const;

      string&
      toolchain_version ();

      void
      toolchain_version (const string&);

      bool
      toolchain_version_specified () const;

      void
      toolchain_version_specified (bool);

      const string&
      reason () const;

      string&
      reason ();

      void
      reason (const string&);

      bool
      reason_specified () const;

      void
      reason_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_force_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string package_;
      bool package_specified_;
      string version_;
      bool version_specified_;
      string target_;
      bool target_specified_;
      string target_config_;
      bool target_config_specified_;
      string package_config_;
      bool package_config_specified_;
      string toolchain_name_;
      bool toolchain_name_specified_;
      string toolchain_version_;
      bool toolchain_version_specified_;
      string reason_;
      bool reason_specified_;
    };

    class builds
    {
      public:
      builds ();

      builds (int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      builds (int start,
              int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      builds (int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      builds (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      builds (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const uint16_t&
      page () const;

      uint16_t&
      page ();

      void
      page (const uint16_t&);

      bool
      page_specified () const;

      void
      page_specified (bool);

      const string&
      name () const;

      string&
      name ();

      void
      name (const string&);

      bool
      name_specified () const;

      void
      name_specified (bool);

      const string&
      version () const;

      string&
      version ();

      void
      version (const string&);

      bool
      version_specified () const;

      void
      version_specified (bool);

      const string&
      toolchain () const;

      string&
      toolchain ();

      void
      toolchain (const string&);

      bool
      toolchain_specified () const;

      void
      toolchain_specified (bool);

      const string&
      target () const;

      string&
      target ();

      void
      target (const string&);

      bool
      target_specified () const;

      void
      target_specified (bool);

      const string&
      target_config () const;

      string&
      target_config ();

      void
      target_config (const string&);

      bool
      target_config_specified () const;

      void
      target_config_specified (bool);

      const string&
      package_config () const;

      string&
      package_config ();

      void
      package_config (const string&);

      bool
      package_config_specified () const;

      void
      package_config_specified (bool);

      const string&
      result () const;

      string&
      result ();

      void
      result (const string&);

      bool
      result_specified () const;

      void
      result_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_builds_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      uint16_t page_;
      bool page_specified_;
      string name_;
      bool name_specified_;
      string version_;
      bool version_specified_;
      string toolchain_;
      bool toolchain_specified_;
      string target_;
      bool target_specified_;
      string target_config_;
      bool target_config_specified_;
      string package_config_;
      bool package_config_specified_;
      string result_;
      bool result_specified_;
    };

    class build_configs
    {
      public:
      build_configs ();

      build_configs (int& argc,
                     char** argv,
                     bool erase = false,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_configs (int start,
                     int& argc,
                     char** argv,
                     bool erase = false,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_configs (int& argc,
                     char** argv,
                     int& end,
                     bool erase = false,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_configs (int start,
                     int& argc,
                     char** argv,
                     int& end,
                     bool erase = false,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      build_configs (::brep::cli::scanner&,
                     ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                     ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      class_name () const;

      string&
      class_name ();

      void
      class_name (const string&);

      bool
      class_name_specified () const;

      void
      class_name_specified (bool);

      const uint16_t&
      page () const;

      uint16_t&
      page ();

      void
      page (const uint16_t&);

      bool
      page_specified () const;

      void
      page_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_build_configs_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string class_name_;
      bool class_name_specified_;
      uint16_t page_;
      bool page_specified_;
    };

    class submit
    {
      public:
      submit ();

      submit (int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      submit (int start,
              int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      submit (int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      submit (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      submit (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      archive () const;

      string&
      archive ();

      void
      archive (const string&);

      bool
      archive_specified () const;

      void
      archive_specified (bool);

      const string&
      sha256sum () const;

      string&
      sha256sum ();

      void
      sha256sum (const string&);

      bool
      sha256sum_specified () const;

      void
      sha256sum_specified (bool);

      const string&
      simulate () const;

      string&
      simulate ();

      void
      simulate (const string&);

      bool
      simulate_specified () const;

      void
      simulate_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_submit_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string archive_;
      bool archive_specified_;
      string sha256sum_;
      bool sha256sum_specified_;
      string simulate_;
      bool simulate_specified_;
    };

    class ci
    {
      public:
      ci ();

      ci (int& argc,
          char** argv,
          bool erase = false,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci (int start,
          int& argc,
          char** argv,
          bool erase = false,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci (int& argc,
          char** argv,
          int& end,
          bool erase = false,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci (int start,
          int& argc,
          char** argv,
          int& end,
          bool erase = false,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci (::brep::cli::scanner&,
          ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
          ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const bpkg::repository_location&
      repository () const;

      bpkg::repository_location&
      repository ();

      void
      repository (const bpkg::repository_location&);

      bool
      repository_specified () const;

      void
      repository_specified (bool);

      const strings&
      package () const;

      strings&
      package ();

      void
      package (const strings&);

      bool
      package_specified () const;

      void
      package_specified (bool);

      const string&
      overrides () const;

      string&
      overrides ();

      void
      overrides (const string&);

      bool
      overrides_specified () const;

      void
      overrides_specified (bool);

      const string&
      interactive () const;

      string&
      interactive ();

      void
      interactive (const string&);

      bool
      interactive_specified () const;

      void
      interactive_specified (bool);

      const string&
      simulate () const;

      string&
      simulate ();

      void
      simulate (const string&);

      bool
      simulate_specified () const;

      void
      simulate_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_ci_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      bpkg::repository_location repository_;
      bool repository_specified_;
      strings package_;
      bool package_specified_;
      string overrides_;
      bool overrides_specified_;
      string interactive_;
      bool interactive_specified_;
      string simulate_;
      bool simulate_specified_;
    };

    class ci_cancel
    {
      public:
      ci_cancel ();

      ci_cancel (int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_cancel (int start,
                 int& argc,
                 char** argv,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_cancel (int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_cancel (int start,
                 int& argc,
                 char** argv,
                 int& end,
                 bool erase = false,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      ci_cancel (::brep::cli::scanner&,
                 ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
                 ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      id () const;

      string&
      id ();

      void
      id (const string&);

      bool
      id_specified () const;

      void
      id_specified (bool);

      const string&
      reason () const;

      string&
      reason ();

      void
      reason (const string&);

      bool
      reason_specified () const;

      void
      reason_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_ci_cancel_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string id_;
      bool id_specified_;
      string reason_;
      bool reason_specified_;
    };

    class upload
    {
      public:
      upload ();

      upload (int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      upload (int start,
              int& argc,
              char** argv,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      upload (int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      upload (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase = false,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      upload (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option = ::brep::cli::unknown_mode::fail,
              ::brep::cli::unknown_mode argument = ::brep::cli::unknown_mode::stop);

      // Option accessors and modifiers.
      //
      const string&
      type () const;

      string&
      type ();

      void
      type (const string&);

      bool
      type_specified () const;

      void
      type_specified (bool);

      const string&
      session () const;

      string&
      session ();

      void
      session (const string&);

      bool
      session_specified () const;

      void
      session_specified (bool);

      const string&
      challenge () const;

      string&
      challenge ();

      void
      challenge (const string&);

      bool
      challenge_specified () const;

      void
      challenge_specified (bool);

      const string&
      instance () const;

      string&
      instance ();

      void
      instance (const string&);

      bool
      instance_specified () const;

      void
      instance_specified (bool);

      const string&
      archive () const;

      string&
      archive ();

      void
      archive (const string&);

      bool
      archive_specified () const;

      void
      archive_specified (bool);

      const string&
      sha256sum () const;

      string&
      sha256sum ();

      void
      sha256sum (const string&);

      bool
      sha256sum_specified () const;

      void
      sha256sum_specified (bool);

      // Print usage information.
      //
      static ::brep::cli::usage_para
      print_usage (::std::ostream&,
                   ::brep::cli::usage_para = ::brep::cli::usage_para::none);

      // Option description.
      //
      static const ::brep::cli::options&
      description ();

      // Implementation details.
      //
      protected:
      friend struct _cli_upload_desc_type;

      static void
      fill (::brep::cli::options&);

      bool
      _parse (const char*, ::brep::cli::scanner&);

      private:
      bool
      _parse (::brep::cli::scanner&,
              ::brep::cli::unknown_mode option,
              ::brep::cli::unknown_mode argument);

      public:
      string type_;
      bool type_specified_;
      string session_;
      bool session_specified_;
      string challenge_;
      bool challenge_specified_;
      string instance_;
      bool instance_specified_;
      string archive_;
      bool archive_specified_;
      string sha256sum_;
      bool sha256sum_specified_;
    };
  }
}

#include <mod/module-options.ixx>

// Begin epilogue.
//
//
// End epilogue.

#endif // MOD_MODULE_OPTIONS_HXX
