// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <mod/types-parsers.hxx>
//
// End prologue.

#include <mod/module-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>
#include <fstream>

namespace brep
{
  namespace cli
  {
    // unknown_option
    //
    unknown_option::
    ~unknown_option () noexcept
    {
    }

    void unknown_option::
    print (::std::ostream& os) const
    {
      os << "unknown option '" << option ().c_str () << "'";
    }

    const char* unknown_option::
    what () const noexcept
    {
      return "unknown option";
    }

    // unknown_argument
    //
    unknown_argument::
    ~unknown_argument () noexcept
    {
    }

    void unknown_argument::
    print (::std::ostream& os) const
    {
      os << "unknown argument '" << argument ().c_str () << "'";
    }

    const char* unknown_argument::
    what () const noexcept
    {
      return "unknown argument";
    }

    // missing_value
    //
    missing_value::
    ~missing_value () noexcept
    {
    }

    void missing_value::
    print (::std::ostream& os) const
    {
      os << "missing value for option '" << option ().c_str () << "'";
    }

    const char* missing_value::
    what () const noexcept
    {
      return "missing option value";
    }

    // invalid_value
    //
    invalid_value::
    ~invalid_value () noexcept
    {
    }

    void invalid_value::
    print (::std::ostream& os) const
    {
      os << "invalid value '" << value ().c_str () << "' for option '"
         << option ().c_str () << "'";

      if (!message ().empty ())
        os << ": " << message ().c_str ();
    }

    const char* invalid_value::
    what () const noexcept
    {
      return "invalid option value";
    }

    // eos_reached
    //
    void eos_reached::
    print (::std::ostream& os) const
    {
      os << what ();
    }

    const char* eos_reached::
    what () const noexcept
    {
      return "end of argument stream reached";
    }

    // file_io_failure
    //
    file_io_failure::
    ~file_io_failure () noexcept
    {
    }

    void file_io_failure::
    print (::std::ostream& os) const
    {
      os << "unable to open file '" << file ().c_str () << "' or read failure";
    }

    const char* file_io_failure::
    what () const noexcept
    {
      return "unable to open file or read failure";
    }

    // unmatched_quote
    //
    unmatched_quote::
    ~unmatched_quote () noexcept
    {
    }

    void unmatched_quote::
    print (::std::ostream& os) const
    {
      os << "unmatched quote in argument '" << argument ().c_str () << "'";
    }

    const char* unmatched_quote::
    what () const noexcept
    {
      return "unmatched quote";
    }

    // scanner
    //
    scanner::
    ~scanner ()
    {
    }

    // argv_scanner
    //
    bool argv_scanner::
    more ()
    {
      return i_ < argc_;
    }

    const char* argv_scanner::
    peek ()
    {
      if (i_ < argc_)
        return argv_[i_];
      else
        throw eos_reached ();
    }

    const char* argv_scanner::
    next ()
    {
      if (i_ < argc_)
      {
        const char* r (argv_[i_]);

        if (erase_)
        {
          for (int i (i_ + 1); i < argc_; ++i)
            argv_[i - 1] = argv_[i];

          --argc_;
          argv_[argc_] = 0;
        }
        else
          ++i_;

        ++start_position_;
        return r;
      }
      else
        throw eos_reached ();
    }

    void argv_scanner::
    skip ()
    {
      if (i_ < argc_)
      {
        ++i_;
        ++start_position_;
      }
      else
        throw eos_reached ();
    }

    std::size_t argv_scanner::
    position ()
    {
      return start_position_;
    }

    // argv_file_scanner
    //
    int argv_file_scanner::zero_argc_ = 0;
    std::string argv_file_scanner::empty_string_;

    bool argv_file_scanner::
    more ()
    {
      if (!args_.empty ())
        return true;

      while (base::more ())
      {
        // See if the next argument is the file option.
        //
        const char* a (base::peek ());
        const option_info* oi = 0;
        const char* ov = 0;

        if (!skip_)
        {
          if ((oi = find (a)) != 0)
          {
            base::next ();

            if (!base::more ())
              throw missing_value (a);

            ov = base::next ();
          }
        }

        if (oi != 0)
        {
          if (oi->search_func != 0)
          {
            std::string f (oi->search_func (ov, oi->arg));

            if (!f.empty ())
              load (f);
          }
          else
            load (ov);

          if (!args_.empty ())
            return true;
        }
        else
        {
          if (!skip_)
            skip_ = (std::strcmp (a, "--") == 0);

          return true;
        }
      }

      return false;
    }

    const char* argv_file_scanner::
    peek ()
    {
      if (!more ())
        throw eos_reached ();

      return args_.empty () ? base::peek () : args_.front ().value.c_str ();
    }

    const std::string& argv_file_scanner::
    peek_file ()
    {
      if (!more ())
        throw eos_reached ();

      return args_.empty () ? empty_string_ : *args_.front ().file;
    }

    std::size_t argv_file_scanner::
    peek_line ()
    {
      if (!more ())
        throw eos_reached ();

      return args_.empty () ? 0 : args_.front ().line;
    }

    const char* argv_file_scanner::
    next ()
    {
      if (!more ())
        throw eos_reached ();

      if (args_.empty ())
        return base::next ();
      else
      {
        hold_[i_ == 0 ? ++i_ : --i_].swap (args_.front ().value);
        args_.pop_front ();
        ++start_position_;
        return hold_[i_].c_str ();
      }
    }

    void argv_file_scanner::
    skip ()
    {
      if (!more ())
        throw eos_reached ();

      if (args_.empty ())
        return base::skip ();
      else
      {
        args_.pop_front ();
        ++start_position_;
      }
    }

    const argv_file_scanner::option_info* argv_file_scanner::
    find (const char* a) const
    {
      for (std::size_t i (0); i < options_count_; ++i)
        if (std::strcmp (a, options_[i].option) == 0)
          return &options_[i];

      return 0;
    }

    std::size_t argv_file_scanner::
    position ()
    {
      return start_position_;
    }

    void argv_file_scanner::
    load (const std::string& file)
    {
      using namespace std;

      ifstream is (file.c_str ());

      if (!is.is_open ())
        throw file_io_failure (file);

      files_.push_back (file);

      arg a;
      a.file = &*files_.rbegin ();

      for (a.line = 1; !is.eof (); ++a.line)
      {
        string line;
        getline (is, line);

        if (is.fail () && !is.eof ())
          throw file_io_failure (file);

        string::size_type n (line.size ());

        // Trim the line from leading and trailing whitespaces.
        //
        if (n != 0)
        {
          const char* f (line.c_str ());
          const char* l (f + n);

          const char* of (f);
          while (f < l && (*f == ' ' || *f == '\t' || *f == '\r'))
            ++f;

          --l;

          const char* ol (l);
          while (l > f && (*l == ' ' || *l == '\t' || *l == '\r'))
            --l;

          if (f != of || l != ol)
            line = f <= l ? string (f, l - f + 1) : string ();
        }

        // Ignore empty lines, those that start with #.
        //
        if (line.empty () || line[0] == '#')
          continue;

        string::size_type p (string::npos);
        p = line.find (' ');

        string s1;
        if (p != string::npos)
        {
          s1.assign (line, 0, p);

          // Skip leading whitespaces in the argument.
          //
          n = line.size ();
          for (++p; p < n; ++p)
          {
            char c (line[p]);
            if (c != ' ' && c != '\t' && c != '\r')
              break;
          }
        }
        else if (!skip_)
          skip_ = (line == "--");

        string s2 (line, p != string::npos ? p : 0);

        // If the string (which is an option value or argument) is
        // wrapped in quotes, remove them.
        //
        n = s2.size ();
        char cf (s2[0]), cl (s2[n - 1]);

        if (cf == '"' || cf == '\'' || cl == '"' || cl == '\'')
        {
          if (n == 1 || cf != cl)
            throw unmatched_quote (s2);

          s2 = string (s2, 1, n - 2);
        }

        if (!s1.empty ())
        {
          // See if this is another file option.
          //
          const option_info* oi;
          if (!skip_ && (oi = find (s1.c_str ())))
          {
            if (s2.empty ())
              throw missing_value (oi->option);

            if (oi->search_func != 0)
            {
              string f (oi->search_func (s2.c_str (), oi->arg));
              if (!f.empty ())
                load (f);
            }
            else
            {
              // If the path of the file being parsed is not simple and the
              // path of the file that needs to be loaded is relative, then
              // complete the latter using the former as a base.
              //
#ifndef _WIN32
              string::size_type p (file.find_last_of ('/'));
              bool c (p != string::npos && s2[0] != '/');
#else
              string::size_type p (file.find_last_of ("/\\"));
              bool c (p != string::npos && s2[1] != ':');
#endif
              if (c)
                s2.insert (0, file, 0, p + 1);

              load (s2);
            }

            continue;
          }

          a.value = s1;
          args_.push_back (a);
        }

        a.value = s2;
        args_.push_back (a);
      }
    }

    void options::
    push_back (const option& o)
    {
      container_type::size_type n (size ());
      container_type::push_back (o);
      map_[o.name ()] = n;

      for (option_names::const_iterator i (o.aliases ().begin ());
           i != o.aliases ().end (); ++i)
        map_[*i] = n;
    }

    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace brep
{
  namespace options
  {
    // repository_email
    //

    repository_email::
    repository_email ()
    : email_ (),
      email_specified_ (false)
    {
    }

    repository_email::
    repository_email (int& argc,
                      char** argv,
                      bool erase,
                      ::brep::cli::unknown_mode opt,
                      ::brep::cli::unknown_mode arg)
    : email_ (),
      email_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_email::
    repository_email (int start,
                      int& argc,
                      char** argv,
                      bool erase,
                      ::brep::cli::unknown_mode opt,
                      ::brep::cli::unknown_mode arg)
    : email_ (),
      email_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_email::
    repository_email (int& argc,
                      char** argv,
                      int& end,
                      bool erase,
                      ::brep::cli::unknown_mode opt,
                      ::brep::cli::unknown_mode arg)
    : email_ (),
      email_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_email::
    repository_email (int start,
                      int& argc,
                      char** argv,
                      int& end,
                      bool erase,
                      ::brep::cli::unknown_mode opt,
                      ::brep::cli::unknown_mode arg)
    : email_ (),
      email_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_email::
    repository_email (::brep::cli::scanner& s,
                      ::brep::cli::unknown_mode opt,
                      ::brep::cli::unknown_mode arg)
    : email_ (),
      email_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para repository_email::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "email <email>                                  Repository email." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_repository_email_desc_type: ::brep::cli::options
    {
      _cli_repository_email_desc_type ()
      {
        ::brep::options::repository_email::fill (*this);
      }
    };

    void repository_email::
    fill (::brep::cli::options& os)
    {
      // email
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("email", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& repository_email::
    description ()
    {
      static _cli_repository_email_desc_type _cli_repository_email_desc_;
      return _cli_repository_email_desc_;
    }

    typedef
    std::map<std::string, void (*) (repository_email&, ::brep::cli::scanner&)>
    _cli_repository_email_map;

    static _cli_repository_email_map _cli_repository_email_map_;

    struct _cli_repository_email_map_init
    {
      _cli_repository_email_map_init ()
      {
        _cli_repository_email_map_["email"] =
        &::brep::cli::thunk< repository_email, string, &repository_email::email_,
          &repository_email::email_specified_ >;
      }
    };

    static _cli_repository_email_map_init _cli_repository_email_map_init_;

    bool repository_email::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_repository_email_map::const_iterator i (_cli_repository_email_map_.find (o));

      if (i != _cli_repository_email_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool repository_email::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // repository_url
    //

    repository_url::
    repository_url ()
    : host_ (),
      host_specified_ (false),
      root_ ("/"),
      root_specified_ (false)
    {
    }

    repository_url::
    repository_url (int& argc,
                    char** argv,
                    bool erase,
                    ::brep::cli::unknown_mode opt,
                    ::brep::cli::unknown_mode arg)
    : host_ (),
      host_specified_ (false),
      root_ ("/"),
      root_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_url::
    repository_url (int start,
                    int& argc,
                    char** argv,
                    bool erase,
                    ::brep::cli::unknown_mode opt,
                    ::brep::cli::unknown_mode arg)
    : host_ (),
      host_specified_ (false),
      root_ ("/"),
      root_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_url::
    repository_url (int& argc,
                    char** argv,
                    int& end,
                    bool erase,
                    ::brep::cli::unknown_mode opt,
                    ::brep::cli::unknown_mode arg)
    : host_ (),
      host_specified_ (false),
      root_ ("/"),
      root_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_url::
    repository_url (int start,
                    int& argc,
                    char** argv,
                    int& end,
                    bool erase,
                    ::brep::cli::unknown_mode opt,
                    ::brep::cli::unknown_mode arg)
    : host_ (),
      host_specified_ (false),
      root_ ("/"),
      root_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_url::
    repository_url (::brep::cli::scanner& s,
                    ::brep::cli::unknown_mode opt,
                    ::brep::cli::unknown_mode arg)
    : host_ (),
      host_specified_ (false),
      root_ ("/"),
      root_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para repository_url::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "host <host>                                    Repository host." << ::std::endl;

      os << "root <path>                                    Repository root." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_repository_url_desc_type: ::brep::cli::options
    {
      _cli_repository_url_desc_type ()
      {
        ::brep::options::repository_url::fill (*this);
      }
    };

    void repository_url::
    fill (::brep::cli::options& os)
    {
      // host
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("host", a, false, dv);
        os.push_back (o);
      }

      // root
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("/");
        ::brep::cli::option o ("root", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& repository_url::
    description ()
    {
      static _cli_repository_url_desc_type _cli_repository_url_desc_;
      return _cli_repository_url_desc_;
    }

    typedef
    std::map<std::string, void (*) (repository_url&, ::brep::cli::scanner&)>
    _cli_repository_url_map;

    static _cli_repository_url_map _cli_repository_url_map_;

    struct _cli_repository_url_map_init
    {
      _cli_repository_url_map_init ()
      {
        _cli_repository_url_map_["host"] =
        &::brep::cli::thunk< repository_url, string, &repository_url::host_,
          &repository_url::host_specified_ >;
        _cli_repository_url_map_["root"] =
        &::brep::cli::thunk< repository_url, dir_path, &repository_url::root_,
          &repository_url::root_specified_ >;
      }
    };

    static _cli_repository_url_map_init _cli_repository_url_map_init_;

    bool repository_url::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_repository_url_map::const_iterator i (_cli_repository_url_map_.find (o));

      if (i != _cli_repository_url_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool repository_url::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_email_notification
    //

    build_email_notification::
    build_email_notification ()
    : build_toolchain_email_ (),
      build_toolchain_email_specified_ (false)
    {
    }

    build_email_notification::
    build_email_notification (int& argc,
                              char** argv,
                              bool erase,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : build_toolchain_email_ (),
      build_toolchain_email_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_email_notification::
    build_email_notification (int start,
                              int& argc,
                              char** argv,
                              bool erase,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : build_toolchain_email_ (),
      build_toolchain_email_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_email_notification::
    build_email_notification (int& argc,
                              char** argv,
                              int& end,
                              bool erase,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : build_toolchain_email_ (),
      build_toolchain_email_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_email_notification::
    build_email_notification (int start,
                              int& argc,
                              char** argv,
                              int& end,
                              bool erase,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : build_toolchain_email_ (),
      build_toolchain_email_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_email_notification::
    build_email_notification (::brep::cli::scanner& s,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : build_toolchain_email_ (),
      build_toolchain_email_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_email_notification::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // repository_email base
      //
      p = ::brep::options::repository_email::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "build-toolchain-email <name>=<mode>            Enable or disable package build" << ::std::endl
         << "                                               notification emails." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_email_notification_desc_type: ::brep::cli::options
    {
      _cli_build_email_notification_desc_type ()
      {
        ::brep::options::build_email_notification::fill (*this);
      }
    };

    void build_email_notification::
    fill (::brep::cli::options& os)
    {
      // repository_email base
      //
      ::brep::options::repository_email::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // build-toolchain-email
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-toolchain-email", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build_email_notification::
    description ()
    {
      static _cli_build_email_notification_desc_type _cli_build_email_notification_desc_;
      return _cli_build_email_notification_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_email_notification&, ::brep::cli::scanner&)>
    _cli_build_email_notification_map;

    static _cli_build_email_notification_map _cli_build_email_notification_map_;

    struct _cli_build_email_notification_map_init
    {
      _cli_build_email_notification_map_init ()
      {
        _cli_build_email_notification_map_["build-toolchain-email"] =
        &::brep::cli::thunk< build_email_notification, std::map<string, build_email>, &build_email_notification::build_toolchain_email_,
          &build_email_notification::build_toolchain_email_specified_ >;
      }
    };

    static _cli_build_email_notification_map_init _cli_build_email_notification_map_init_;

    bool build_email_notification::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_email_notification_map::const_iterator i (_cli_build_email_notification_map_.find (o));

      if (i != _cli_build_email_notification_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // repository_email base
      //
      if (::brep::options::repository_email::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      return false;
    }

    bool build_email_notification::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // handler
    //

    handler::
    handler ()
    : tenant_name_ ("tenant"),
      tenant_name_specified_ (false),
      verbosity_ (0),
      verbosity_specified_ (false)
    {
    }

    handler::
    handler (int& argc,
             char** argv,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : tenant_name_ ("tenant"),
      tenant_name_specified_ (false),
      verbosity_ (0),
      verbosity_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    handler::
    handler (int start,
             int& argc,
             char** argv,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : tenant_name_ ("tenant"),
      tenant_name_specified_ (false),
      verbosity_ (0),
      verbosity_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    handler::
    handler (int& argc,
             char** argv,
             int& end,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : tenant_name_ ("tenant"),
      tenant_name_specified_ (false),
      verbosity_ (0),
      verbosity_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    handler::
    handler (int start,
             int& argc,
             char** argv,
             int& end,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : tenant_name_ ("tenant"),
      tenant_name_specified_ (false),
      verbosity_ (0),
      verbosity_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    handler::
    handler (::brep::cli::scanner& s,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : tenant_name_ ("tenant"),
      tenant_name_specified_ (false),
      verbosity_ (0),
      verbosity_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para handler::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "tenant-name <name>                             Name to call the tenant values" << ::std::endl
         << "                                               on web pages." << ::std::endl;

      os << "verbosity <level>                              Trace verbosity level." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_handler_desc_type: ::brep::cli::options
    {
      _cli_handler_desc_type ()
      {
        ::brep::options::handler::fill (*this);
      }
    };

    void handler::
    fill (::brep::cli::options& os)
    {
      // tenant-name
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("tenant");
        ::brep::cli::option o ("tenant-name", a, false, dv);
        os.push_back (o);
      }

      // verbosity
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("0");
        ::brep::cli::option o ("verbosity", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& handler::
    description ()
    {
      static _cli_handler_desc_type _cli_handler_desc_;
      return _cli_handler_desc_;
    }

    typedef
    std::map<std::string, void (*) (handler&, ::brep::cli::scanner&)>
    _cli_handler_map;

    static _cli_handler_map _cli_handler_map_;

    struct _cli_handler_map_init
    {
      _cli_handler_map_init ()
      {
        _cli_handler_map_["tenant-name"] =
        &::brep::cli::thunk< handler, string, &handler::tenant_name_,
          &handler::tenant_name_specified_ >;
        _cli_handler_map_["verbosity"] =
        &::brep::cli::thunk< handler, uint16_t, &handler::verbosity_,
          &handler::verbosity_specified_ >;
      }
    };

    static _cli_handler_map_init _cli_handler_map_init_;

    bool handler::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_handler_map::const_iterator i (_cli_handler_map_.find (o));

      if (i != _cli_handler_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool handler::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // openssl_options
    //

    openssl_options::
    openssl_options ()
    : openssl_ ("openssl"),
      openssl_specified_ (false),
      openssl_option_ (),
      openssl_option_specified_ (false),
      openssl_envvar_ (),
      openssl_envvar_specified_ (false)
    {
    }

    openssl_options::
    openssl_options (int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : openssl_ ("openssl"),
      openssl_specified_ (false),
      openssl_option_ (),
      openssl_option_specified_ (false),
      openssl_envvar_ (),
      openssl_envvar_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    openssl_options::
    openssl_options (int start,
                     int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : openssl_ ("openssl"),
      openssl_specified_ (false),
      openssl_option_ (),
      openssl_option_specified_ (false),
      openssl_envvar_ (),
      openssl_envvar_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    openssl_options::
    openssl_options (int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : openssl_ ("openssl"),
      openssl_specified_ (false),
      openssl_option_ (),
      openssl_option_specified_ (false),
      openssl_envvar_ (),
      openssl_envvar_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    openssl_options::
    openssl_options (int start,
                     int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : openssl_ ("openssl"),
      openssl_specified_ (false),
      openssl_option_ (),
      openssl_option_specified_ (false),
      openssl_envvar_ (),
      openssl_envvar_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    openssl_options::
    openssl_options (::brep::cli::scanner& s,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : openssl_ ("openssl"),
      openssl_specified_ (false),
      openssl_option_ (),
      openssl_option_specified_ (false),
      openssl_envvar_ (),
      openssl_envvar_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para openssl_options::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "openssl <path>                                 The openssl program to be used" << ::std::endl
         << "                                               for crypto operations." << ::std::endl;

      os << "openssl-option <opt>                           Additional option to be passed" << ::std::endl
         << "                                               to the openssl program (see" << ::std::endl
         << "                                               openssl for details)." << ::std::endl;

      os << "openssl-envvar <name>[=value]                  Environment variable to be set" << ::std::endl
         << "                                               (<name>=<value>) or unset (just" << ::std::endl
         << "                                               <name>) for the openssl program" << ::std::endl
         << "                                               (see openssl for details)." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_openssl_options_desc_type: ::brep::cli::options
    {
      _cli_openssl_options_desc_type ()
      {
        ::brep::options::openssl_options::fill (*this);
      }
    };

    void openssl_options::
    fill (::brep::cli::options& os)
    {
      // openssl
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("openssl");
        ::brep::cli::option o ("openssl", a, false, dv);
        os.push_back (o);
      }

      // openssl-option
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("openssl-option", a, false, dv);
        os.push_back (o);
      }

      // openssl-envvar
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("openssl-envvar", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& openssl_options::
    description ()
    {
      static _cli_openssl_options_desc_type _cli_openssl_options_desc_;
      return _cli_openssl_options_desc_;
    }

    typedef
    std::map<std::string, void (*) (openssl_options&, ::brep::cli::scanner&)>
    _cli_openssl_options_map;

    static _cli_openssl_options_map _cli_openssl_options_map_;

    struct _cli_openssl_options_map_init
    {
      _cli_openssl_options_map_init ()
      {
        _cli_openssl_options_map_["openssl"] =
        &::brep::cli::thunk< openssl_options, path, &openssl_options::openssl_,
          &openssl_options::openssl_specified_ >;
        _cli_openssl_options_map_["openssl-option"] =
        &::brep::cli::thunk< openssl_options, strings, &openssl_options::openssl_option_,
          &openssl_options::openssl_option_specified_ >;
        _cli_openssl_options_map_["openssl-envvar"] =
        &::brep::cli::thunk< openssl_options, strings, &openssl_options::openssl_envvar_,
          &openssl_options::openssl_envvar_specified_ >;
      }
    };

    static _cli_openssl_options_map_init _cli_openssl_options_map_init_;

    bool openssl_options::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_openssl_options_map::const_iterator i (_cli_openssl_options_map_.find (o));

      if (i != _cli_openssl_options_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool openssl_options::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // package_db
    //

    package_db::
    package_db ()
    : package_db_user_ (),
      package_db_user_specified_ (false),
      package_db_role_ ("brep"),
      package_db_role_specified_ (false),
      package_db_password_ (),
      package_db_password_specified_ (false),
      package_db_name_ ("brep_package"),
      package_db_name_specified_ (false),
      package_db_host_ (),
      package_db_host_specified_ (false),
      package_db_port_ (0),
      package_db_port_specified_ (false),
      package_db_max_connections_ (5),
      package_db_max_connections_specified_ (false),
      package_db_retry_ (20),
      package_db_retry_specified_ (false)
    {
    }

    package_db::
    package_db (int& argc,
                char** argv,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : package_db_user_ (),
      package_db_user_specified_ (false),
      package_db_role_ ("brep"),
      package_db_role_specified_ (false),
      package_db_password_ (),
      package_db_password_specified_ (false),
      package_db_name_ ("brep_package"),
      package_db_name_specified_ (false),
      package_db_host_ (),
      package_db_host_specified_ (false),
      package_db_port_ (0),
      package_db_port_specified_ (false),
      package_db_max_connections_ (5),
      package_db_max_connections_specified_ (false),
      package_db_retry_ (20),
      package_db_retry_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_db::
    package_db (int start,
                int& argc,
                char** argv,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : package_db_user_ (),
      package_db_user_specified_ (false),
      package_db_role_ ("brep"),
      package_db_role_specified_ (false),
      package_db_password_ (),
      package_db_password_specified_ (false),
      package_db_name_ ("brep_package"),
      package_db_name_specified_ (false),
      package_db_host_ (),
      package_db_host_specified_ (false),
      package_db_port_ (0),
      package_db_port_specified_ (false),
      package_db_max_connections_ (5),
      package_db_max_connections_specified_ (false),
      package_db_retry_ (20),
      package_db_retry_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_db::
    package_db (int& argc,
                char** argv,
                int& end,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : package_db_user_ (),
      package_db_user_specified_ (false),
      package_db_role_ ("brep"),
      package_db_role_specified_ (false),
      package_db_password_ (),
      package_db_password_specified_ (false),
      package_db_name_ ("brep_package"),
      package_db_name_specified_ (false),
      package_db_host_ (),
      package_db_host_specified_ (false),
      package_db_port_ (0),
      package_db_port_specified_ (false),
      package_db_max_connections_ (5),
      package_db_max_connections_specified_ (false),
      package_db_retry_ (20),
      package_db_retry_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_db::
    package_db (int start,
                int& argc,
                char** argv,
                int& end,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : package_db_user_ (),
      package_db_user_specified_ (false),
      package_db_role_ ("brep"),
      package_db_role_specified_ (false),
      package_db_password_ (),
      package_db_password_specified_ (false),
      package_db_name_ ("brep_package"),
      package_db_name_specified_ (false),
      package_db_host_ (),
      package_db_host_specified_ (false),
      package_db_port_ (0),
      package_db_port_specified_ (false),
      package_db_max_connections_ (5),
      package_db_max_connections_specified_ (false),
      package_db_retry_ (20),
      package_db_retry_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_db::
    package_db (::brep::cli::scanner& s,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : package_db_user_ (),
      package_db_user_specified_ (false),
      package_db_role_ ("brep"),
      package_db_role_specified_ (false),
      package_db_password_ (),
      package_db_password_specified_ (false),
      package_db_name_ ("brep_package"),
      package_db_name_specified_ (false),
      package_db_host_ (),
      package_db_host_specified_ (false),
      package_db_port_ (0),
      package_db_port_specified_ (false),
      package_db_max_connections_ (5),
      package_db_max_connections_specified_ (false),
      package_db_retry_ (20),
      package_db_retry_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para package_db::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "package-db-user <user>                         Package database login user" << ::std::endl
         << "                                               name." << ::std::endl;

      os << "package-db-role <user>                         Package database execution user" << ::std::endl
         << "                                               name." << ::std::endl;

      os << "package-db-password <pass>                     Package database password." << ::std::endl;

      os << "package-db-name <name>                         Package database name." << ::std::endl;

      os << "package-db-host <host>                         Package database host name," << ::std::endl
         << "                                               address, or socket." << ::std::endl;

      os << "package-db-port <port>                         Package database port number." << ::std::endl;

      os << "package-db-max-connections <num>               The maximum number of concurrent" << ::std::endl
         << "                                               package database connections per" << ::std::endl
         << "                                               web server process." << ::std::endl;

      os << "package-db-retry <num>                         The maximum number of times to" << ::std::endl
         << "                                               retry package database" << ::std::endl
         << "                                               transactions in the face of" << ::std::endl
         << "                                               recoverable failures (deadlock," << ::std::endl
         << "                                               loss of connection, etc)." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_package_db_desc_type: ::brep::cli::options
    {
      _cli_package_db_desc_type ()
      {
        ::brep::options::package_db::fill (*this);
      }
    };

    void package_db::
    fill (::brep::cli::options& os)
    {
      // package-db-user
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("package-db-user", a, false, dv);
        os.push_back (o);
      }

      // package-db-role
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("brep");
        ::brep::cli::option o ("package-db-role", a, false, dv);
        os.push_back (o);
      }

      // package-db-password
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("package-db-password", a, false, dv);
        os.push_back (o);
      }

      // package-db-name
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("brep_package");
        ::brep::cli::option o ("package-db-name", a, false, dv);
        os.push_back (o);
      }

      // package-db-host
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("package-db-host", a, false, dv);
        os.push_back (o);
      }

      // package-db-port
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("0");
        ::brep::cli::option o ("package-db-port", a, false, dv);
        os.push_back (o);
      }

      // package-db-max-connections
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("5");
        ::brep::cli::option o ("package-db-max-connections", a, false, dv);
        os.push_back (o);
      }

      // package-db-retry
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("20");
        ::brep::cli::option o ("package-db-retry", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& package_db::
    description ()
    {
      static _cli_package_db_desc_type _cli_package_db_desc_;
      return _cli_package_db_desc_;
    }

    typedef
    std::map<std::string, void (*) (package_db&, ::brep::cli::scanner&)>
    _cli_package_db_map;

    static _cli_package_db_map _cli_package_db_map_;

    struct _cli_package_db_map_init
    {
      _cli_package_db_map_init ()
      {
        _cli_package_db_map_["package-db-user"] =
        &::brep::cli::thunk< package_db, string, &package_db::package_db_user_,
          &package_db::package_db_user_specified_ >;
        _cli_package_db_map_["package-db-role"] =
        &::brep::cli::thunk< package_db, string, &package_db::package_db_role_,
          &package_db::package_db_role_specified_ >;
        _cli_package_db_map_["package-db-password"] =
        &::brep::cli::thunk< package_db, string, &package_db::package_db_password_,
          &package_db::package_db_password_specified_ >;
        _cli_package_db_map_["package-db-name"] =
        &::brep::cli::thunk< package_db, string, &package_db::package_db_name_,
          &package_db::package_db_name_specified_ >;
        _cli_package_db_map_["package-db-host"] =
        &::brep::cli::thunk< package_db, string, &package_db::package_db_host_,
          &package_db::package_db_host_specified_ >;
        _cli_package_db_map_["package-db-port"] =
        &::brep::cli::thunk< package_db, uint16_t, &package_db::package_db_port_,
          &package_db::package_db_port_specified_ >;
        _cli_package_db_map_["package-db-max-connections"] =
        &::brep::cli::thunk< package_db, size_t, &package_db::package_db_max_connections_,
          &package_db::package_db_max_connections_specified_ >;
        _cli_package_db_map_["package-db-retry"] =
        &::brep::cli::thunk< package_db, size_t, &package_db::package_db_retry_,
          &package_db::package_db_retry_specified_ >;
      }
    };

    static _cli_package_db_map_init _cli_package_db_map_init_;

    bool package_db::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_package_db_map::const_iterator i (_cli_package_db_map_.find (o));

      if (i != _cli_package_db_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool package_db::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build
    //

    build::
    build ()
    : build_config_ (),
      build_config_specified_ (false),
      build_bot_agent_keys_ (),
      build_bot_agent_keys_specified_ (false),
      build_forced_rebuild_timeout_ (600),
      build_forced_rebuild_timeout_specified_ (false),
      build_soft_rebuild_timeout_ (86400),
      build_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_timeout_ (),
      build_alt_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_start_ (),
      build_alt_soft_rebuild_start_specified_ (false),
      build_alt_soft_rebuild_stop_ (),
      build_alt_soft_rebuild_stop_specified_ (false),
      build_hard_rebuild_timeout_ (604800),
      build_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_timeout_ (),
      build_alt_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_start_ (),
      build_alt_hard_rebuild_start_specified_ (false),
      build_alt_hard_rebuild_stop_ (),
      build_alt_hard_rebuild_stop_specified_ (false),
      build_queued_timeout_ (15),
      build_queued_timeout_specified_ (false),
      build_queued_batch_ (34),
      build_queued_batch_specified_ (false)
    {
    }

    build::
    build (int& argc,
           char** argv,
           bool erase,
           ::brep::cli::unknown_mode opt,
           ::brep::cli::unknown_mode arg)
    : build_config_ (),
      build_config_specified_ (false),
      build_bot_agent_keys_ (),
      build_bot_agent_keys_specified_ (false),
      build_forced_rebuild_timeout_ (600),
      build_forced_rebuild_timeout_specified_ (false),
      build_soft_rebuild_timeout_ (86400),
      build_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_timeout_ (),
      build_alt_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_start_ (),
      build_alt_soft_rebuild_start_specified_ (false),
      build_alt_soft_rebuild_stop_ (),
      build_alt_soft_rebuild_stop_specified_ (false),
      build_hard_rebuild_timeout_ (604800),
      build_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_timeout_ (),
      build_alt_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_start_ (),
      build_alt_hard_rebuild_start_specified_ (false),
      build_alt_hard_rebuild_stop_ (),
      build_alt_hard_rebuild_stop_specified_ (false),
      build_queued_timeout_ (15),
      build_queued_timeout_specified_ (false),
      build_queued_batch_ (34),
      build_queued_batch_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build::
    build (int start,
           int& argc,
           char** argv,
           bool erase,
           ::brep::cli::unknown_mode opt,
           ::brep::cli::unknown_mode arg)
    : build_config_ (),
      build_config_specified_ (false),
      build_bot_agent_keys_ (),
      build_bot_agent_keys_specified_ (false),
      build_forced_rebuild_timeout_ (600),
      build_forced_rebuild_timeout_specified_ (false),
      build_soft_rebuild_timeout_ (86400),
      build_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_timeout_ (),
      build_alt_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_start_ (),
      build_alt_soft_rebuild_start_specified_ (false),
      build_alt_soft_rebuild_stop_ (),
      build_alt_soft_rebuild_stop_specified_ (false),
      build_hard_rebuild_timeout_ (604800),
      build_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_timeout_ (),
      build_alt_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_start_ (),
      build_alt_hard_rebuild_start_specified_ (false),
      build_alt_hard_rebuild_stop_ (),
      build_alt_hard_rebuild_stop_specified_ (false),
      build_queued_timeout_ (15),
      build_queued_timeout_specified_ (false),
      build_queued_batch_ (34),
      build_queued_batch_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build::
    build (int& argc,
           char** argv,
           int& end,
           bool erase,
           ::brep::cli::unknown_mode opt,
           ::brep::cli::unknown_mode arg)
    : build_config_ (),
      build_config_specified_ (false),
      build_bot_agent_keys_ (),
      build_bot_agent_keys_specified_ (false),
      build_forced_rebuild_timeout_ (600),
      build_forced_rebuild_timeout_specified_ (false),
      build_soft_rebuild_timeout_ (86400),
      build_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_timeout_ (),
      build_alt_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_start_ (),
      build_alt_soft_rebuild_start_specified_ (false),
      build_alt_soft_rebuild_stop_ (),
      build_alt_soft_rebuild_stop_specified_ (false),
      build_hard_rebuild_timeout_ (604800),
      build_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_timeout_ (),
      build_alt_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_start_ (),
      build_alt_hard_rebuild_start_specified_ (false),
      build_alt_hard_rebuild_stop_ (),
      build_alt_hard_rebuild_stop_specified_ (false),
      build_queued_timeout_ (15),
      build_queued_timeout_specified_ (false),
      build_queued_batch_ (34),
      build_queued_batch_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build::
    build (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase,
           ::brep::cli::unknown_mode opt,
           ::brep::cli::unknown_mode arg)
    : build_config_ (),
      build_config_specified_ (false),
      build_bot_agent_keys_ (),
      build_bot_agent_keys_specified_ (false),
      build_forced_rebuild_timeout_ (600),
      build_forced_rebuild_timeout_specified_ (false),
      build_soft_rebuild_timeout_ (86400),
      build_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_timeout_ (),
      build_alt_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_start_ (),
      build_alt_soft_rebuild_start_specified_ (false),
      build_alt_soft_rebuild_stop_ (),
      build_alt_soft_rebuild_stop_specified_ (false),
      build_hard_rebuild_timeout_ (604800),
      build_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_timeout_ (),
      build_alt_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_start_ (),
      build_alt_hard_rebuild_start_specified_ (false),
      build_alt_hard_rebuild_stop_ (),
      build_alt_hard_rebuild_stop_specified_ (false),
      build_queued_timeout_ (15),
      build_queued_timeout_specified_ (false),
      build_queued_batch_ (34),
      build_queued_batch_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build::
    build (::brep::cli::scanner& s,
           ::brep::cli::unknown_mode opt,
           ::brep::cli::unknown_mode arg)
    : build_config_ (),
      build_config_specified_ (false),
      build_bot_agent_keys_ (),
      build_bot_agent_keys_specified_ (false),
      build_forced_rebuild_timeout_ (600),
      build_forced_rebuild_timeout_specified_ (false),
      build_soft_rebuild_timeout_ (86400),
      build_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_timeout_ (),
      build_alt_soft_rebuild_timeout_specified_ (false),
      build_alt_soft_rebuild_start_ (),
      build_alt_soft_rebuild_start_specified_ (false),
      build_alt_soft_rebuild_stop_ (),
      build_alt_soft_rebuild_stop_specified_ (false),
      build_hard_rebuild_timeout_ (604800),
      build_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_timeout_ (),
      build_alt_hard_rebuild_timeout_specified_ (false),
      build_alt_hard_rebuild_start_ (),
      build_alt_hard_rebuild_start_specified_ (false),
      build_alt_hard_rebuild_stop_ (),
      build_alt_hard_rebuild_stop_specified_ (false),
      build_queued_timeout_ (15),
      build_queued_timeout_specified_ (false),
      build_queued_batch_ (34),
      build_queued_batch_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // openssl_options base
      //
      p = ::brep::options::openssl_options::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "build-config <buildtab>                        Build configuration file." << ::std::endl;

      os << "build-bot-agent-keys <dir>                     Directory containing build bot" << ::std::endl
         << "                                               agent public keys." << ::std::endl;

      os << "build-forced-rebuild-timeout <seconds>         Time to wait before considering" << ::std::endl
         << "                                               a package for a forced rebuild." << ::std::endl;

      os << "build-soft-rebuild-timeout <seconds>           Time to wait before considering" << ::std::endl
         << "                                               a package for a soft rebuild" << ::std::endl
         << "                                               (only to be performed if the" << ::std::endl
         << "                                               build environment or any of the" << ::std::endl
         << "                                               package dependencies have" << ::std::endl
         << "                                               changed)." << ::std::endl;

      os << "build-alt-soft-rebuild-timeout <seconds>       Alternative package soft rebuild" << ::std::endl
         << "                                               timeout to use instead of the" << ::std::endl
         << "                                               soft rebuild timeout (see" << ::std::endl
         << "                                               build-soft-rebuild-timeout for" << ::std::endl
         << "                                               details) during the time" << ::std::endl
         << "                                               interval specified with the" << ::std::endl
         << "                                               build-alt-soft-rebuild-start and" << ::std::endl
         << "                                               build-alt-soft-rebuild-stop" << ::std::endl
         << "                                               options." << ::std::endl;

      os << "build-alt-soft-rebuild-start <hours>:<minutes> The start time of the" << ::std::endl
         << "                                               alternative package soft rebuild" << ::std::endl
         << "                                               timeout (see" << ::std::endl
         << "                                               build-alt-soft-rebuild-timeout" << ::std::endl
         << "                                               for details)." << ::std::endl;

      os << "build-alt-soft-rebuild-stop <hours>:<minutes>  The end time of the alternative" << ::std::endl
         << "                                               package soft rebuild timeout" << ::std::endl
         << "                                               (see" << ::std::endl
         << "                                               build-alt-soft-rebuild-timeout" << ::std::endl
         << "                                               for details)." << ::std::endl;

      os << "build-hard-rebuild-timeout <seconds>           Time to wait before considering" << ::std::endl
         << "                                               a package for a hard rebuild (to" << ::std::endl
         << "                                               be performed unconditionally)." << ::std::endl;

      os << "build-alt-hard-rebuild-timeout <seconds>       Alternative package hard rebuild" << ::std::endl
         << "                                               timeout." << ::std::endl;

      os << "build-alt-hard-rebuild-start <hours>:<minutes> The start time of the" << ::std::endl
         << "                                               alternative package hard rebuild" << ::std::endl
         << "                                               timeout (see" << ::std::endl
         << "                                               build-alt-hard-rebuild-timeout" << ::std::endl
         << "                                               for details)." << ::std::endl;

      os << "build-alt-hard-rebuild-stop <hours>:<minutes>  The end time of the alternative" << ::std::endl
         << "                                               package hard rebuild timeout" << ::std::endl
         << "                                               (see" << ::std::endl
         << "                                               build-alt-hard-rebuild-timeout" << ::std::endl
         << "                                               for details)." << ::std::endl;

      os << "build-queued-timeout <seconds>                 Time to wait before assuming the" << ::std::endl
         << "                                               queued notification batch is" << ::std::endl
         << "                                               delivered for package CI" << ::std::endl
         << "                                               requests submitted via" << ::std::endl
         << "                                               third-party services (GitHub," << ::std::endl
         << "                                               etc)." << ::std::endl;

      os << "build-queued-batch <num>                       The maximum number of build" << ::std::endl
         << "                                               configurations in the queued" << ::std::endl
         << "                                               notification batch for package" << ::std::endl
         << "                                               CI requests submitted via" << ::std::endl
         << "                                               third-party services (see" << ::std::endl
         << "                                               build-queued-timeout for" << ::std::endl
         << "                                               details)." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_desc_type: ::brep::cli::options
    {
      _cli_build_desc_type ()
      {
        ::brep::options::build::fill (*this);
      }
    };

    void build::
    fill (::brep::cli::options& os)
    {
      // openssl_options base
      //
      ::brep::options::openssl_options::fill (os);

      // build-config
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-config", a, false, dv);
        os.push_back (o);
      }

      // build-bot-agent-keys
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-bot-agent-keys", a, false, dv);
        os.push_back (o);
      }

      // build-forced-rebuild-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("600");
        ::brep::cli::option o ("build-forced-rebuild-timeout", a, false, dv);
        os.push_back (o);
      }

      // build-soft-rebuild-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("86400");
        ::brep::cli::option o ("build-soft-rebuild-timeout", a, false, dv);
        os.push_back (o);
      }

      // build-alt-soft-rebuild-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-alt-soft-rebuild-timeout", a, false, dv);
        os.push_back (o);
      }

      // build-alt-soft-rebuild-start
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-alt-soft-rebuild-start", a, false, dv);
        os.push_back (o);
      }

      // build-alt-soft-rebuild-stop
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-alt-soft-rebuild-stop", a, false, dv);
        os.push_back (o);
      }

      // build-hard-rebuild-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("604800");
        ::brep::cli::option o ("build-hard-rebuild-timeout", a, false, dv);
        os.push_back (o);
      }

      // build-alt-hard-rebuild-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-alt-hard-rebuild-timeout", a, false, dv);
        os.push_back (o);
      }

      // build-alt-hard-rebuild-start
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-alt-hard-rebuild-start", a, false, dv);
        os.push_back (o);
      }

      // build-alt-hard-rebuild-stop
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-alt-hard-rebuild-stop", a, false, dv);
        os.push_back (o);
      }

      // build-queued-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("15");
        ::brep::cli::option o ("build-queued-timeout", a, false, dv);
        os.push_back (o);
      }

      // build-queued-batch
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("34");
        ::brep::cli::option o ("build-queued-batch", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build::
    description ()
    {
      static _cli_build_desc_type _cli_build_desc_;
      return _cli_build_desc_;
    }

    typedef
    std::map<std::string, void (*) (build&, ::brep::cli::scanner&)>
    _cli_build_map;

    static _cli_build_map _cli_build_map_;

    struct _cli_build_map_init
    {
      _cli_build_map_init ()
      {
        _cli_build_map_["build-config"] =
        &::brep::cli::thunk< build, path, &build::build_config_,
          &build::build_config_specified_ >;
        _cli_build_map_["build-bot-agent-keys"] =
        &::brep::cli::thunk< build, dir_path, &build::build_bot_agent_keys_,
          &build::build_bot_agent_keys_specified_ >;
        _cli_build_map_["build-forced-rebuild-timeout"] =
        &::brep::cli::thunk< build, size_t, &build::build_forced_rebuild_timeout_,
          &build::build_forced_rebuild_timeout_specified_ >;
        _cli_build_map_["build-soft-rebuild-timeout"] =
        &::brep::cli::thunk< build, size_t, &build::build_soft_rebuild_timeout_,
          &build::build_soft_rebuild_timeout_specified_ >;
        _cli_build_map_["build-alt-soft-rebuild-timeout"] =
        &::brep::cli::thunk< build, size_t, &build::build_alt_soft_rebuild_timeout_,
          &build::build_alt_soft_rebuild_timeout_specified_ >;
        _cli_build_map_["build-alt-soft-rebuild-start"] =
        &::brep::cli::thunk< build, duration, &build::build_alt_soft_rebuild_start_,
          &build::build_alt_soft_rebuild_start_specified_ >;
        _cli_build_map_["build-alt-soft-rebuild-stop"] =
        &::brep::cli::thunk< build, duration, &build::build_alt_soft_rebuild_stop_,
          &build::build_alt_soft_rebuild_stop_specified_ >;
        _cli_build_map_["build-hard-rebuild-timeout"] =
        &::brep::cli::thunk< build, size_t, &build::build_hard_rebuild_timeout_,
          &build::build_hard_rebuild_timeout_specified_ >;
        _cli_build_map_["build-alt-hard-rebuild-timeout"] =
        &::brep::cli::thunk< build, size_t, &build::build_alt_hard_rebuild_timeout_,
          &build::build_alt_hard_rebuild_timeout_specified_ >;
        _cli_build_map_["build-alt-hard-rebuild-start"] =
        &::brep::cli::thunk< build, duration, &build::build_alt_hard_rebuild_start_,
          &build::build_alt_hard_rebuild_start_specified_ >;
        _cli_build_map_["build-alt-hard-rebuild-stop"] =
        &::brep::cli::thunk< build, duration, &build::build_alt_hard_rebuild_stop_,
          &build::build_alt_hard_rebuild_stop_specified_ >;
        _cli_build_map_["build-queued-timeout"] =
        &::brep::cli::thunk< build, size_t, &build::build_queued_timeout_,
          &build::build_queued_timeout_specified_ >;
        _cli_build_map_["build-queued-batch"] =
        &::brep::cli::thunk< build, size_t, &build::build_queued_batch_,
          &build::build_queued_batch_specified_ >;
      }
    };

    static _cli_build_map_init _cli_build_map_init_;

    bool build::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_map::const_iterator i (_cli_build_map_.find (o));

      if (i != _cli_build_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // openssl_options base
      //
      if (::brep::options::openssl_options::_parse (o, s))
        return true;

      return false;
    }

    bool build::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_db
    //

    build_db::
    build_db ()
    : build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_role_ ("brep"),
      build_db_role_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_build"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (0),
      build_db_port_specified_ (false),
      build_db_max_connections_ (5),
      build_db_max_connections_specified_ (false),
      build_db_retry_ (20),
      build_db_retry_specified_ (false)
    {
    }

    build_db::
    build_db (int& argc,
              char** argv,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_role_ ("brep"),
      build_db_role_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_build"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (0),
      build_db_port_specified_ (false),
      build_db_max_connections_ (5),
      build_db_max_connections_specified_ (false),
      build_db_retry_ (20),
      build_db_retry_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_db::
    build_db (int start,
              int& argc,
              char** argv,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_role_ ("brep"),
      build_db_role_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_build"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (0),
      build_db_port_specified_ (false),
      build_db_max_connections_ (5),
      build_db_max_connections_specified_ (false),
      build_db_retry_ (20),
      build_db_retry_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_db::
    build_db (int& argc,
              char** argv,
              int& end,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_role_ ("brep"),
      build_db_role_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_build"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (0),
      build_db_port_specified_ (false),
      build_db_max_connections_ (5),
      build_db_max_connections_specified_ (false),
      build_db_retry_ (20),
      build_db_retry_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_db::
    build_db (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_role_ ("brep"),
      build_db_role_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_build"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (0),
      build_db_port_specified_ (false),
      build_db_max_connections_ (5),
      build_db_max_connections_specified_ (false),
      build_db_retry_ (20),
      build_db_retry_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_db::
    build_db (::brep::cli::scanner& s,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_role_ ("brep"),
      build_db_role_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_build"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (0),
      build_db_port_specified_ (false),
      build_db_max_connections_ (5),
      build_db_max_connections_specified_ (false),
      build_db_retry_ (20),
      build_db_retry_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_db::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "build-db-user <user>                           Build database login user name." << ::std::endl;

      os << "build-db-role <user>                           Build database execution user" << ::std::endl
         << "                                               name." << ::std::endl;

      os << "build-db-password <pass>                       Build database password." << ::std::endl;

      os << "build-db-name <name>                           Build database name." << ::std::endl;

      os << "build-db-host <host>                           Build database host name," << ::std::endl
         << "                                               address, or socket." << ::std::endl;

      os << "build-db-port <port>                           Build database port number." << ::std::endl;

      os << "build-db-max-connections <num>                 The maximum number of concurrent" << ::std::endl
         << "                                               build database connections per" << ::std::endl
         << "                                               web server process." << ::std::endl;

      os << "build-db-retry <num>                           The maximum number of times to" << ::std::endl
         << "                                               retry build database" << ::std::endl
         << "                                               transactions in the face of" << ::std::endl
         << "                                               recoverable failures (deadlock," << ::std::endl
         << "                                               loss of connection, etc)." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_db_desc_type: ::brep::cli::options
    {
      _cli_build_db_desc_type ()
      {
        ::brep::options::build_db::fill (*this);
      }
    };

    void build_db::
    fill (::brep::cli::options& os)
    {
      // build-db-user
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-db-user", a, false, dv);
        os.push_back (o);
      }

      // build-db-role
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("brep");
        ::brep::cli::option o ("build-db-role", a, false, dv);
        os.push_back (o);
      }

      // build-db-password
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-db-password", a, false, dv);
        os.push_back (o);
      }

      // build-db-name
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("brep_build");
        ::brep::cli::option o ("build-db-name", a, false, dv);
        os.push_back (o);
      }

      // build-db-host
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-db-host", a, false, dv);
        os.push_back (o);
      }

      // build-db-port
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("0");
        ::brep::cli::option o ("build-db-port", a, false, dv);
        os.push_back (o);
      }

      // build-db-max-connections
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("5");
        ::brep::cli::option o ("build-db-max-connections", a, false, dv);
        os.push_back (o);
      }

      // build-db-retry
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("20");
        ::brep::cli::option o ("build-db-retry", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build_db::
    description ()
    {
      static _cli_build_db_desc_type _cli_build_db_desc_;
      return _cli_build_db_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_db&, ::brep::cli::scanner&)>
    _cli_build_db_map;

    static _cli_build_db_map _cli_build_db_map_;

    struct _cli_build_db_map_init
    {
      _cli_build_db_map_init ()
      {
        _cli_build_db_map_["build-db-user"] =
        &::brep::cli::thunk< build_db, string, &build_db::build_db_user_,
          &build_db::build_db_user_specified_ >;
        _cli_build_db_map_["build-db-role"] =
        &::brep::cli::thunk< build_db, string, &build_db::build_db_role_,
          &build_db::build_db_role_specified_ >;
        _cli_build_db_map_["build-db-password"] =
        &::brep::cli::thunk< build_db, string, &build_db::build_db_password_,
          &build_db::build_db_password_specified_ >;
        _cli_build_db_map_["build-db-name"] =
        &::brep::cli::thunk< build_db, string, &build_db::build_db_name_,
          &build_db::build_db_name_specified_ >;
        _cli_build_db_map_["build-db-host"] =
        &::brep::cli::thunk< build_db, string, &build_db::build_db_host_,
          &build_db::build_db_host_specified_ >;
        _cli_build_db_map_["build-db-port"] =
        &::brep::cli::thunk< build_db, uint16_t, &build_db::build_db_port_,
          &build_db::build_db_port_specified_ >;
        _cli_build_db_map_["build-db-max-connections"] =
        &::brep::cli::thunk< build_db, size_t, &build_db::build_db_max_connections_,
          &build_db::build_db_max_connections_specified_ >;
        _cli_build_db_map_["build-db-retry"] =
        &::brep::cli::thunk< build_db, size_t, &build_db::build_db_retry_,
          &build_db::build_db_retry_specified_ >;
      }
    };

    static _cli_build_db_map_init _cli_build_db_map_init_;

    bool build_db::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_db_map::const_iterator i (_cli_build_db_map_.find (o));

      if (i != _cli_build_db_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool build_db::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_upload
    //

    build_upload::
    build_upload ()
    : upload_data_ (),
      upload_data_specified_ (false),
      upload_max_size_ (),
      upload_max_size_specified_ (false),
      upload_email_ (),
      upload_email_specified_ (false),
      upload_handler_ (),
      upload_handler_specified_ (false),
      upload_handler_argument_ (),
      upload_handler_argument_specified_ (false),
      upload_handler_timeout_ (),
      upload_handler_timeout_specified_ (false),
      upload_toolchain_exclude_ (),
      upload_toolchain_exclude_specified_ (false),
      upload_repository_exclude_ (),
      upload_repository_exclude_specified_ (false)
    {
    }

    build_upload::
    build_upload (int& argc,
                  char** argv,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : upload_data_ (),
      upload_data_specified_ (false),
      upload_max_size_ (),
      upload_max_size_specified_ (false),
      upload_email_ (),
      upload_email_specified_ (false),
      upload_handler_ (),
      upload_handler_specified_ (false),
      upload_handler_argument_ (),
      upload_handler_argument_specified_ (false),
      upload_handler_timeout_ (),
      upload_handler_timeout_specified_ (false),
      upload_toolchain_exclude_ (),
      upload_toolchain_exclude_specified_ (false),
      upload_repository_exclude_ (),
      upload_repository_exclude_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_upload::
    build_upload (int start,
                  int& argc,
                  char** argv,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : upload_data_ (),
      upload_data_specified_ (false),
      upload_max_size_ (),
      upload_max_size_specified_ (false),
      upload_email_ (),
      upload_email_specified_ (false),
      upload_handler_ (),
      upload_handler_specified_ (false),
      upload_handler_argument_ (),
      upload_handler_argument_specified_ (false),
      upload_handler_timeout_ (),
      upload_handler_timeout_specified_ (false),
      upload_toolchain_exclude_ (),
      upload_toolchain_exclude_specified_ (false),
      upload_repository_exclude_ (),
      upload_repository_exclude_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_upload::
    build_upload (int& argc,
                  char** argv,
                  int& end,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : upload_data_ (),
      upload_data_specified_ (false),
      upload_max_size_ (),
      upload_max_size_specified_ (false),
      upload_email_ (),
      upload_email_specified_ (false),
      upload_handler_ (),
      upload_handler_specified_ (false),
      upload_handler_argument_ (),
      upload_handler_argument_specified_ (false),
      upload_handler_timeout_ (),
      upload_handler_timeout_specified_ (false),
      upload_toolchain_exclude_ (),
      upload_toolchain_exclude_specified_ (false),
      upload_repository_exclude_ (),
      upload_repository_exclude_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_upload::
    build_upload (int start,
                  int& argc,
                  char** argv,
                  int& end,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : upload_data_ (),
      upload_data_specified_ (false),
      upload_max_size_ (),
      upload_max_size_specified_ (false),
      upload_email_ (),
      upload_email_specified_ (false),
      upload_handler_ (),
      upload_handler_specified_ (false),
      upload_handler_argument_ (),
      upload_handler_argument_specified_ (false),
      upload_handler_timeout_ (),
      upload_handler_timeout_specified_ (false),
      upload_toolchain_exclude_ (),
      upload_toolchain_exclude_specified_ (false),
      upload_repository_exclude_ (),
      upload_repository_exclude_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_upload::
    build_upload (::brep::cli::scanner& s,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : upload_data_ (),
      upload_data_specified_ (false),
      upload_max_size_ (),
      upload_max_size_specified_ (false),
      upload_email_ (),
      upload_email_specified_ (false),
      upload_handler_ (),
      upload_handler_specified_ (false),
      upload_handler_argument_ (),
      upload_handler_argument_specified_ (false),
      upload_handler_timeout_ (),
      upload_handler_timeout_specified_ (false),
      upload_toolchain_exclude_ (),
      upload_toolchain_exclude_specified_ (false),
      upload_repository_exclude_ (),
      upload_repository_exclude_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_upload::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "upload-data <type>=<dir>                       The directory to save upload" << ::std::endl
         << "                                               data to for the specified upload" << ::std::endl
         << "                                               type." << ::std::endl;

      os << "upload-max-size <type>=<bytes>                 The maximum size of the upload" << ::std::endl
         << "                                               data accepted for the specified" << ::std::endl
         << "                                               upload type." << ::std::endl;

      os << "upload-email <type>=<email>                    The build artifacts upload" << ::std::endl
         << "                                               email." << ::std::endl;

      os << "upload-handler <type>=<path>                   The handler program to be" << ::std::endl
         << "                                               executed on build artifacts" << ::std::endl
         << "                                               upload of the specified type." << ::std::endl;

      os << "upload-handler-argument <type>=<arg>           Additional arguments to be" << ::std::endl
         << "                                               passed to the upload handler" << ::std::endl
         << "                                               program for the specified upload" << ::std::endl
         << "                                               type (see upload-handler for" << ::std::endl
         << "                                               details)." << ::std::endl;

      os << "upload-handler-timeout <type>=<seconds>        The upload handler program" << ::std::endl
         << "                                               timeout in seconds for the" << ::std::endl
         << "                                               specified upload type." << ::std::endl;

      os << "upload-toolchain-exclude <type>=<name>         Disable upload of the specified" << ::std::endl
         << "                                               type for the specified toolchain" << ::std::endl
         << "                                               name." << ::std::endl;

      os << "upload-repository-exclude <type>=<name>        Disable upload of the specified" << ::std::endl
         << "                                               type for packages from the" << ::std::endl
         << "                                               repository with the specified" << ::std::endl
         << "                                               canonical name." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_upload_desc_type: ::brep::cli::options
    {
      _cli_build_upload_desc_type ()
      {
        ::brep::options::build_upload::fill (*this);
      }
    };

    void build_upload::
    fill (::brep::cli::options& os)
    {
      // upload-data
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("upload-data", a, false, dv);
        os.push_back (o);
      }

      // upload-max-size
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("upload-max-size", a, false, dv);
        os.push_back (o);
      }

      // upload-email
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("upload-email", a, false, dv);
        os.push_back (o);
      }

      // upload-handler
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("upload-handler", a, false, dv);
        os.push_back (o);
      }

      // upload-handler-argument
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("upload-handler-argument", a, false, dv);
        os.push_back (o);
      }

      // upload-handler-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("upload-handler-timeout", a, false, dv);
        os.push_back (o);
      }

      // upload-toolchain-exclude
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("upload-toolchain-exclude", a, false, dv);
        os.push_back (o);
      }

      // upload-repository-exclude
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("upload-repository-exclude", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build_upload::
    description ()
    {
      static _cli_build_upload_desc_type _cli_build_upload_desc_;
      return _cli_build_upload_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_upload&, ::brep::cli::scanner&)>
    _cli_build_upload_map;

    static _cli_build_upload_map _cli_build_upload_map_;

    struct _cli_build_upload_map_init
    {
      _cli_build_upload_map_init ()
      {
        _cli_build_upload_map_["upload-data"] =
        &::brep::cli::thunk< build_upload, std::map<string, dir_path>, &build_upload::upload_data_,
          &build_upload::upload_data_specified_ >;
        _cli_build_upload_map_["upload-max-size"] =
        &::brep::cli::thunk< build_upload, std::map<string, size_t>, &build_upload::upload_max_size_,
          &build_upload::upload_max_size_specified_ >;
        _cli_build_upload_map_["upload-email"] =
        &::brep::cli::thunk< build_upload, std::map<string, string>, &build_upload::upload_email_,
          &build_upload::upload_email_specified_ >;
        _cli_build_upload_map_["upload-handler"] =
        &::brep::cli::thunk< build_upload, std::map<string, path>, &build_upload::upload_handler_,
          &build_upload::upload_handler_specified_ >;
        _cli_build_upload_map_["upload-handler-argument"] =
        &::brep::cli::thunk< build_upload, std::multimap<string, string>, &build_upload::upload_handler_argument_,
          &build_upload::upload_handler_argument_specified_ >;
        _cli_build_upload_map_["upload-handler-timeout"] =
        &::brep::cli::thunk< build_upload, std::map<string, size_t>, &build_upload::upload_handler_timeout_,
          &build_upload::upload_handler_timeout_specified_ >;
        _cli_build_upload_map_["upload-toolchain-exclude"] =
        &::brep::cli::thunk< build_upload, std::multimap<string, string>, &build_upload::upload_toolchain_exclude_,
          &build_upload::upload_toolchain_exclude_specified_ >;
        _cli_build_upload_map_["upload-repository-exclude"] =
        &::brep::cli::thunk< build_upload, std::multimap<string, string>, &build_upload::upload_repository_exclude_,
          &build_upload::upload_repository_exclude_specified_ >;
      }
    };

    static _cli_build_upload_map_init _cli_build_upload_map_init_;

    bool build_upload::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_upload_map::const_iterator i (_cli_build_upload_map_.find (o));

      if (i != _cli_build_upload_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool build_upload::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // package_version_metadata
    //

    package_version_metadata::
    package_version_metadata ()
    : reviews_url_ (),
      reviews_url_specified_ (false)
    {
    }

    package_version_metadata::
    package_version_metadata (int& argc,
                              char** argv,
                              bool erase,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : reviews_url_ (),
      reviews_url_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_version_metadata::
    package_version_metadata (int start,
                              int& argc,
                              char** argv,
                              bool erase,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : reviews_url_ (),
      reviews_url_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_version_metadata::
    package_version_metadata (int& argc,
                              char** argv,
                              int& end,
                              bool erase,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : reviews_url_ (),
      reviews_url_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_version_metadata::
    package_version_metadata (int start,
                              int& argc,
                              char** argv,
                              int& end,
                              bool erase,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : reviews_url_ (),
      reviews_url_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_version_metadata::
    package_version_metadata (::brep::cli::scanner& s,
                              ::brep::cli::unknown_mode opt,
                              ::brep::cli::unknown_mode arg)
    : reviews_url_ (),
      reviews_url_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para package_version_metadata::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "reviews-url <url>                              The base URL for the reviews" << ::std::endl
         << "                                               manifest files." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_package_version_metadata_desc_type: ::brep::cli::options
    {
      _cli_package_version_metadata_desc_type ()
      {
        ::brep::options::package_version_metadata::fill (*this);
      }
    };

    void package_version_metadata::
    fill (::brep::cli::options& os)
    {
      // reviews-url
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("reviews-url", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& package_version_metadata::
    description ()
    {
      static _cli_package_version_metadata_desc_type _cli_package_version_metadata_desc_;
      return _cli_package_version_metadata_desc_;
    }

    typedef
    std::map<std::string, void (*) (package_version_metadata&, ::brep::cli::scanner&)>
    _cli_package_version_metadata_map;

    static _cli_package_version_metadata_map _cli_package_version_metadata_map_;

    struct _cli_package_version_metadata_map_init
    {
      _cli_package_version_metadata_map_init ()
      {
        _cli_package_version_metadata_map_["reviews-url"] =
        &::brep::cli::thunk< package_version_metadata, string, &package_version_metadata::reviews_url_,
          &package_version_metadata::reviews_url_specified_ >;
      }
    };

    static _cli_package_version_metadata_map_init _cli_package_version_metadata_map_init_;

    bool package_version_metadata::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_package_version_metadata_map::const_iterator i (_cli_package_version_metadata_map_.find (o));

      if (i != _cli_package_version_metadata_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool package_version_metadata::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // page
    //

    page::
    page ()
    : logo_ (),
      logo_specified_ (false),
      menu_ (),
      menu_specified_ (false)
    {
    }

    page::
    page (int& argc,
          char** argv,
          bool erase,
          ::brep::cli::unknown_mode opt,
          ::brep::cli::unknown_mode arg)
    : logo_ (),
      logo_specified_ (false),
      menu_ (),
      menu_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    page::
    page (int start,
          int& argc,
          char** argv,
          bool erase,
          ::brep::cli::unknown_mode opt,
          ::brep::cli::unknown_mode arg)
    : logo_ (),
      logo_specified_ (false),
      menu_ (),
      menu_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    page::
    page (int& argc,
          char** argv,
          int& end,
          bool erase,
          ::brep::cli::unknown_mode opt,
          ::brep::cli::unknown_mode arg)
    : logo_ (),
      logo_specified_ (false),
      menu_ (),
      menu_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    page::
    page (int start,
          int& argc,
          char** argv,
          int& end,
          bool erase,
          ::brep::cli::unknown_mode opt,
          ::brep::cli::unknown_mode arg)
    : logo_ (),
      logo_specified_ (false),
      menu_ (),
      menu_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    page::
    page (::brep::cli::scanner& s,
          ::brep::cli::unknown_mode opt,
          ::brep::cli::unknown_mode arg)
    : logo_ (),
      logo_specified_ (false),
      menu_ (),
      menu_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para page::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "logo <xhtml>                                   Web page logo." << ::std::endl;

      os << "menu <label=link>                              Web page menu." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_page_desc_type: ::brep::cli::options
    {
      _cli_page_desc_type ()
      {
        ::brep::options::page::fill (*this);
      }
    };

    void page::
    fill (::brep::cli::options& os)
    {
      // logo
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("logo", a, false, dv);
        os.push_back (o);
      }

      // menu
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("menu", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& page::
    description ()
    {
      static _cli_page_desc_type _cli_page_desc_;
      return _cli_page_desc_;
    }

    typedef
    std::map<std::string, void (*) (page&, ::brep::cli::scanner&)>
    _cli_page_map;

    static _cli_page_map _cli_page_map_;

    struct _cli_page_map_init
    {
      _cli_page_map_init ()
      {
        _cli_page_map_["logo"] =
        &::brep::cli::thunk< page, web::xhtml::fragment, &page::logo_,
          &page::logo_specified_ >;
        _cli_page_map_["menu"] =
        &::brep::cli::thunk< page, vector<page_menu>, &page::menu_,
          &page::menu_specified_ >;
      }
    };

    static _cli_page_map_init _cli_page_map_init_;

    bool page::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_page_map::const_iterator i (_cli_page_map_.find (o));

      if (i != _cli_page_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool page::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // search
    //

    search::
    search ()
    : search_page_entries_ (20),
      search_page_entries_specified_ (false),
      search_pages_ (5),
      search_pages_specified_ (false)
    {
    }

    search::
    search (int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : search_page_entries_ (20),
      search_page_entries_specified_ (false),
      search_pages_ (5),
      search_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    search::
    search (int start,
            int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : search_page_entries_ (20),
      search_page_entries_specified_ (false),
      search_pages_ (5),
      search_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    search::
    search (int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : search_page_entries_ (20),
      search_page_entries_specified_ (false),
      search_pages_ (5),
      search_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    search::
    search (int start,
            int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : search_page_entries_ (20),
      search_page_entries_specified_ (false),
      search_pages_ (5),
      search_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    search::
    search (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : search_page_entries_ (20),
      search_page_entries_specified_ (false),
      search_pages_ (5),
      search_pages_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para search::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "search-page-entries <num>                      Number of packages per page." << ::std::endl;

      os << "search-pages <num>                             Number of pages in navigation" << ::std::endl
         << "                                               (pager)." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_search_desc_type: ::brep::cli::options
    {
      _cli_search_desc_type ()
      {
        ::brep::options::search::fill (*this);
      }
    };

    void search::
    fill (::brep::cli::options& os)
    {
      // search-page-entries
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("20");
        ::brep::cli::option o ("search-page-entries", a, false, dv);
        os.push_back (o);
      }

      // search-pages
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("5");
        ::brep::cli::option o ("search-pages", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& search::
    description ()
    {
      static _cli_search_desc_type _cli_search_desc_;
      return _cli_search_desc_;
    }

    typedef
    std::map<std::string, void (*) (search&, ::brep::cli::scanner&)>
    _cli_search_map;

    static _cli_search_map _cli_search_map_;

    struct _cli_search_map_init
    {
      _cli_search_map_init ()
      {
        _cli_search_map_["search-page-entries"] =
        &::brep::cli::thunk< search, uint16_t, &search::search_page_entries_,
          &search::search_page_entries_specified_ >;
        _cli_search_map_["search-pages"] =
        &::brep::cli::thunk< search, uint16_t, &search::search_pages_,
          &search::search_pages_specified_ >;
      }
    };

    static _cli_search_map_init _cli_search_map_init_;

    bool search::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_search_map::const_iterator i (_cli_search_map_.find (o));

      if (i != _cli_search_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool search::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // package
    //

    package::
    package ()
    : package_description_ (500),
      package_description_specified_ (false),
      package_changes_ (5000),
      package_changes_specified_ (false)
    {
    }

    package::
    package (int& argc,
             char** argv,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : package_description_ (500),
      package_description_specified_ (false),
      package_changes_ (5000),
      package_changes_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    package::
    package (int start,
             int& argc,
             char** argv,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : package_description_ (500),
      package_description_specified_ (false),
      package_changes_ (5000),
      package_changes_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    package::
    package (int& argc,
             char** argv,
             int& end,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : package_description_ (500),
      package_description_specified_ (false),
      package_changes_ (5000),
      package_changes_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package::
    package (int start,
             int& argc,
             char** argv,
             int& end,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : package_description_ (500),
      package_description_specified_ (false),
      package_changes_ (5000),
      package_changes_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package::
    package (::brep::cli::scanner& s,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : package_description_ (500),
      package_description_specified_ (false),
      package_changes_ (5000),
      package_changes_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para package::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "package-description <len>                      Number of package description" << ::std::endl
         << "                                               characters to display in brief" << ::std::endl
         << "                                               pages." << ::std::endl;

      os << "package-changes <len>                          Number of package changes" << ::std::endl
         << "                                               characters to display in brief" << ::std::endl
         << "                                               pages." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_package_desc_type: ::brep::cli::options
    {
      _cli_package_desc_type ()
      {
        ::brep::options::package::fill (*this);
      }
    };

    void package::
    fill (::brep::cli::options& os)
    {
      // package-description
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("500");
        ::brep::cli::option o ("package-description", a, false, dv);
        os.push_back (o);
      }

      // package-changes
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("5000");
        ::brep::cli::option o ("package-changes", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& package::
    description ()
    {
      static _cli_package_desc_type _cli_package_desc_;
      return _cli_package_desc_;
    }

    typedef
    std::map<std::string, void (*) (package&, ::brep::cli::scanner&)>
    _cli_package_map;

    static _cli_package_map _cli_package_map_;

    struct _cli_package_map_init
    {
      _cli_package_map_init ()
      {
        _cli_package_map_["package-description"] =
        &::brep::cli::thunk< package, uint16_t, &package::package_description_,
          &package::package_description_specified_ >;
        _cli_package_map_["package-changes"] =
        &::brep::cli::thunk< package, uint16_t, &package::package_changes_,
          &package::package_changes_specified_ >;
      }
    };

    static _cli_package_map_init _cli_package_map_init_;

    bool package::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_package_map::const_iterator i (_cli_package_map_.find (o));

      if (i != _cli_package_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool package::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // packages
    //

    packages::
    packages ()
    : search_title_ ("Packages"),
      search_title_specified_ (false),
      search_description_ (),
      search_description_specified_ (false)
    {
    }

    packages::
    packages (int& argc,
              char** argv,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : search_title_ ("Packages"),
      search_title_specified_ (false),
      search_description_ (),
      search_description_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    packages::
    packages (int start,
              int& argc,
              char** argv,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : search_title_ ("Packages"),
      search_title_specified_ (false),
      search_description_ (),
      search_description_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    packages::
    packages (int& argc,
              char** argv,
              int& end,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : search_title_ ("Packages"),
      search_title_specified_ (false),
      search_description_ (),
      search_description_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    packages::
    packages (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : search_title_ ("Packages"),
      search_title_specified_ (false),
      search_description_ (),
      search_description_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    packages::
    packages (::brep::cli::scanner& s,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : search_title_ ("Packages"),
      search_title_specified_ (false),
      search_description_ (),
      search_description_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para packages::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // search base
      //
      p = ::brep::options::search::print_usage (os, p);

      // package_db base
      //
      p = ::brep::options::package_db::print_usage (os, p);

      // page base
      //
      p = ::brep::options::page::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "search-title <text>                            Package search page title." << ::std::endl;

      os << "search-description <xhtml>                     Package search page description." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_packages_desc_type: ::brep::cli::options
    {
      _cli_packages_desc_type ()
      {
        ::brep::options::packages::fill (*this);
      }
    };

    void packages::
    fill (::brep::cli::options& os)
    {
      // search base
      //
      ::brep::options::search::fill (os);

      // package_db base
      //
      ::brep::options::package_db::fill (os);

      // page base
      //
      ::brep::options::page::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);

      // search-title
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("Packages");
        ::brep::cli::option o ("search-title", a, false, dv);
        os.push_back (o);
      }

      // search-description
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("search-description", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& packages::
    description ()
    {
      static _cli_packages_desc_type _cli_packages_desc_;
      return _cli_packages_desc_;
    }

    typedef
    std::map<std::string, void (*) (packages&, ::brep::cli::scanner&)>
    _cli_packages_map;

    static _cli_packages_map _cli_packages_map_;

    struct _cli_packages_map_init
    {
      _cli_packages_map_init ()
      {
        _cli_packages_map_["search-title"] =
        &::brep::cli::thunk< packages, string, &packages::search_title_,
          &packages::search_title_specified_ >;
        _cli_packages_map_["search-description"] =
        &::brep::cli::thunk< packages, web::xhtml::fragment, &packages::search_description_,
          &packages::search_description_specified_ >;
      }
    };

    static _cli_packages_map_init _cli_packages_map_init_;

    bool packages::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_packages_map::const_iterator i (_cli_packages_map_.find (o));

      if (i != _cli_packages_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // search base
      //
      if (::brep::options::search::_parse (o, s))
        return true;

      // package_db base
      //
      if (::brep::options::package_db::_parse (o, s))
        return true;

      // page base
      //
      if (::brep::options::page::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool packages::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // advanced_search
    //

    advanced_search::
    advanced_search ()
    {
    }

    advanced_search::
    advanced_search (int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    advanced_search::
    advanced_search (int start,
                     int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    advanced_search::
    advanced_search (int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    advanced_search::
    advanced_search (int start,
                     int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    advanced_search::
    advanced_search (::brep::cli::scanner& s,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para advanced_search::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // package_db base
      //
      p = ::brep::options::package_db::print_usage (os, p);

      // search base
      //
      p = ::brep::options::search::print_usage (os, p);

      // page base
      //
      p = ::brep::options::page::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // package_version_metadata base
      //
      p = ::brep::options::package_version_metadata::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      return p;
    }

    struct _cli_advanced_search_desc_type: ::brep::cli::options
    {
      _cli_advanced_search_desc_type ()
      {
        ::brep::options::advanced_search::fill (*this);
      }
    };

    void advanced_search::
    fill (::brep::cli::options& os)
    {
      // package_db base
      //
      ::brep::options::package_db::fill (os);

      // search base
      //
      ::brep::options::search::fill (os);

      // page base
      //
      ::brep::options::page::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // package_version_metadata base
      //
      ::brep::options::package_version_metadata::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);
    }

    const ::brep::cli::options& advanced_search::
    description ()
    {
      static _cli_advanced_search_desc_type _cli_advanced_search_desc_;
      return _cli_advanced_search_desc_;
    }

    typedef
    std::map<std::string, void (*) (advanced_search&, ::brep::cli::scanner&)>
    _cli_advanced_search_map;

    static _cli_advanced_search_map _cli_advanced_search_map_;

    struct _cli_advanced_search_map_init
    {
      _cli_advanced_search_map_init ()
      {
      }
    };

    static _cli_advanced_search_map_init _cli_advanced_search_map_init_;

    bool advanced_search::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_advanced_search_map::const_iterator i (_cli_advanced_search_map_.find (o));

      if (i != _cli_advanced_search_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // package_db base
      //
      if (::brep::options::package_db::_parse (o, s))
        return true;

      // search base
      //
      if (::brep::options::search::_parse (o, s))
        return true;

      // page base
      //
      if (::brep::options::page::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // package_version_metadata base
      //
      if (::brep::options::package_version_metadata::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool advanced_search::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // package_details
    //

    package_details::
    package_details ()
    {
    }

    package_details::
    package_details (int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_details::
    package_details (int start,
                     int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_details::
    package_details (int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_details::
    package_details (int start,
                     int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_details::
    package_details (::brep::cli::scanner& s,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para package_details::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // package base
      //
      p = ::brep::options::package::print_usage (os, p);

      // package_db base
      //
      p = ::brep::options::package_db::print_usage (os, p);

      // search base
      //
      p = ::brep::options::search::print_usage (os, p);

      // page base
      //
      p = ::brep::options::page::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // package_version_metadata base
      //
      p = ::brep::options::package_version_metadata::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      return p;
    }

    struct _cli_package_details_desc_type: ::brep::cli::options
    {
      _cli_package_details_desc_type ()
      {
        ::brep::options::package_details::fill (*this);
      }
    };

    void package_details::
    fill (::brep::cli::options& os)
    {
      // package base
      //
      ::brep::options::package::fill (os);

      // package_db base
      //
      ::brep::options::package_db::fill (os);

      // search base
      //
      ::brep::options::search::fill (os);

      // page base
      //
      ::brep::options::page::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // package_version_metadata base
      //
      ::brep::options::package_version_metadata::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);
    }

    const ::brep::cli::options& package_details::
    description ()
    {
      static _cli_package_details_desc_type _cli_package_details_desc_;
      return _cli_package_details_desc_;
    }

    typedef
    std::map<std::string, void (*) (package_details&, ::brep::cli::scanner&)>
    _cli_package_details_map;

    static _cli_package_details_map _cli_package_details_map_;

    struct _cli_package_details_map_init
    {
      _cli_package_details_map_init ()
      {
      }
    };

    static _cli_package_details_map_init _cli_package_details_map_init_;

    bool package_details::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_package_details_map::const_iterator i (_cli_package_details_map_.find (o));

      if (i != _cli_package_details_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // package base
      //
      if (::brep::options::package::_parse (o, s))
        return true;

      // package_db base
      //
      if (::brep::options::package_db::_parse (o, s))
        return true;

      // search base
      //
      if (::brep::options::search::_parse (o, s))
        return true;

      // page base
      //
      if (::brep::options::page::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // package_version_metadata base
      //
      if (::brep::options::package_version_metadata::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool package_details::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // package_version_details
    //

    package_version_details::
    package_version_details ()
    : bindist_root_ (),
      bindist_root_specified_ (false),
      bindist_url_ (),
      bindist_url_specified_ (false)
    {
    }

    package_version_details::
    package_version_details (int& argc,
                             char** argv,
                             bool erase,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : bindist_root_ (),
      bindist_root_specified_ (false),
      bindist_url_ (),
      bindist_url_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_version_details::
    package_version_details (int start,
                             int& argc,
                             char** argv,
                             bool erase,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : bindist_root_ (),
      bindist_root_specified_ (false),
      bindist_url_ (),
      bindist_url_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_version_details::
    package_version_details (int& argc,
                             char** argv,
                             int& end,
                             bool erase,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : bindist_root_ (),
      bindist_root_specified_ (false),
      bindist_url_ (),
      bindist_url_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_version_details::
    package_version_details (int start,
                             int& argc,
                             char** argv,
                             int& end,
                             bool erase,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : bindist_root_ (),
      bindist_root_specified_ (false),
      bindist_url_ (),
      bindist_url_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_version_details::
    package_version_details (::brep::cli::scanner& s,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : bindist_root_ (),
      bindist_root_specified_ (false),
      bindist_url_ (),
      bindist_url_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para package_version_details::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // package base
      //
      p = ::brep::options::package::print_usage (os, p);

      // package_db base
      //
      p = ::brep::options::package_db::print_usage (os, p);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // build_db base
      //
      p = ::brep::options::build_db::print_usage (os, p);

      // page base
      //
      p = ::brep::options::page::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // package_version_metadata base
      //
      p = ::brep::options::package_version_metadata::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "bindist-root <dir>                             The root directory where the" << ::std::endl
         << "                                               uploaded binary distribution" << ::std::endl
         << "                                               packages are saved to under the" << ::std::endl
         << "                                               following directory hierarchy:" << ::std::endl
         << ::std::endl
         << "                                               [<tenant>/]<distribution>/<os-re" << ::std::endl
         << "                                               ease>/<project>/<package>/<versi" << ::std::endl
         << "                                               n>/<package-config>" << ::std::endl
         << ::std::endl
         << "                                               The package configuration" << ::std::endl
         << "                                               directory symlinks that match" << ::std::endl
         << "                                               these paths are mapped to web" << ::std::endl
         << "                                               URLs based on the bindist-url" << ::std::endl
         << "                                               value and displayed on the" << ::std::endl
         << "                                               package version details page." << ::std::endl;

      os << "bindist-url <url>                              The root URL of the directory" << ::std::endl
         << "                                               specified with the bindist-root" << ::std::endl
         << "                                               option." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_package_version_details_desc_type: ::brep::cli::options
    {
      _cli_package_version_details_desc_type ()
      {
        ::brep::options::package_version_details::fill (*this);
      }
    };

    void package_version_details::
    fill (::brep::cli::options& os)
    {
      // package base
      //
      ::brep::options::package::fill (os);

      // package_db base
      //
      ::brep::options::package_db::fill (os);

      // build base
      //
      ::brep::options::build::fill (os);

      // build_db base
      //
      ::brep::options::build_db::fill (os);

      // page base
      //
      ::brep::options::page::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // package_version_metadata base
      //
      ::brep::options::package_version_metadata::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);

      // bindist-root
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("bindist-root", a, false, dv);
        os.push_back (o);
      }

      // bindist-url
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("bindist-url", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& package_version_details::
    description ()
    {
      static _cli_package_version_details_desc_type _cli_package_version_details_desc_;
      return _cli_package_version_details_desc_;
    }

    typedef
    std::map<std::string, void (*) (package_version_details&, ::brep::cli::scanner&)>
    _cli_package_version_details_map;

    static _cli_package_version_details_map _cli_package_version_details_map_;

    struct _cli_package_version_details_map_init
    {
      _cli_package_version_details_map_init ()
      {
        _cli_package_version_details_map_["bindist-root"] =
        &::brep::cli::thunk< package_version_details, dir_path, &package_version_details::bindist_root_,
          &package_version_details::bindist_root_specified_ >;
        _cli_package_version_details_map_["bindist-url"] =
        &::brep::cli::thunk< package_version_details, string, &package_version_details::bindist_url_,
          &package_version_details::bindist_url_specified_ >;
      }
    };

    static _cli_package_version_details_map_init _cli_package_version_details_map_init_;

    bool package_version_details::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_package_version_details_map::const_iterator i (_cli_package_version_details_map_.find (o));

      if (i != _cli_package_version_details_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // package base
      //
      if (::brep::options::package::_parse (o, s))
        return true;

      // package_db base
      //
      if (::brep::options::package_db::_parse (o, s))
        return true;

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // build_db base
      //
      if (::brep::options::build_db::_parse (o, s))
        return true;

      // page base
      //
      if (::brep::options::page::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // package_version_metadata base
      //
      if (::brep::options::package_version_metadata::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool package_version_details::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // repository_details
    //

    repository_details::
    repository_details ()
    {
    }

    repository_details::
    repository_details (int& argc,
                        char** argv,
                        bool erase,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_details::
    repository_details (int start,
                        int& argc,
                        char** argv,
                        bool erase,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_details::
    repository_details (int& argc,
                        char** argv,
                        int& end,
                        bool erase,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_details::
    repository_details (int start,
                        int& argc,
                        char** argv,
                        int& end,
                        bool erase,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_details::
    repository_details (::brep::cli::scanner& s,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para repository_details::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // package_db base
      //
      p = ::brep::options::package_db::print_usage (os, p);

      // page base
      //
      p = ::brep::options::page::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      return p;
    }

    struct _cli_repository_details_desc_type: ::brep::cli::options
    {
      _cli_repository_details_desc_type ()
      {
        ::brep::options::repository_details::fill (*this);
      }
    };

    void repository_details::
    fill (::brep::cli::options& os)
    {
      // package_db base
      //
      ::brep::options::package_db::fill (os);

      // page base
      //
      ::brep::options::page::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);
    }

    const ::brep::cli::options& repository_details::
    description ()
    {
      static _cli_repository_details_desc_type _cli_repository_details_desc_;
      return _cli_repository_details_desc_;
    }

    typedef
    std::map<std::string, void (*) (repository_details&, ::brep::cli::scanner&)>
    _cli_repository_details_map;

    static _cli_repository_details_map _cli_repository_details_map_;

    struct _cli_repository_details_map_init
    {
      _cli_repository_details_map_init ()
      {
      }
    };

    static _cli_repository_details_map_init _cli_repository_details_map_init_;

    bool repository_details::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_repository_details_map::const_iterator i (_cli_repository_details_map_.find (o));

      if (i != _cli_repository_details_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // package_db base
      //
      if (::brep::options::package_db::_parse (o, s))
        return true;

      // page base
      //
      if (::brep::options::page::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool repository_details::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_task
    //

    build_task::
    build_task ()
    : build_task_request_max_size_ (102400),
      build_task_request_max_size_specified_ (false),
      build_result_timeout_ (10800),
      build_result_timeout_specified_ (false),
      build_interactive_login_ (),
      build_interactive_login_specified_ (false),
      build_package_order_ (build_order::stable),
      build_package_order_specified_ (false)
    {
    }

    build_task::
    build_task (int& argc,
                char** argv,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : build_task_request_max_size_ (102400),
      build_task_request_max_size_specified_ (false),
      build_result_timeout_ (10800),
      build_result_timeout_specified_ (false),
      build_interactive_login_ (),
      build_interactive_login_specified_ (false),
      build_package_order_ (build_order::stable),
      build_package_order_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_task::
    build_task (int start,
                int& argc,
                char** argv,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : build_task_request_max_size_ (102400),
      build_task_request_max_size_specified_ (false),
      build_result_timeout_ (10800),
      build_result_timeout_specified_ (false),
      build_interactive_login_ (),
      build_interactive_login_specified_ (false),
      build_package_order_ (build_order::stable),
      build_package_order_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_task::
    build_task (int& argc,
                char** argv,
                int& end,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : build_task_request_max_size_ (102400),
      build_task_request_max_size_specified_ (false),
      build_result_timeout_ (10800),
      build_result_timeout_specified_ (false),
      build_interactive_login_ (),
      build_interactive_login_specified_ (false),
      build_package_order_ (build_order::stable),
      build_package_order_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_task::
    build_task (int start,
                int& argc,
                char** argv,
                int& end,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : build_task_request_max_size_ (102400),
      build_task_request_max_size_specified_ (false),
      build_result_timeout_ (10800),
      build_result_timeout_specified_ (false),
      build_interactive_login_ (),
      build_interactive_login_specified_ (false),
      build_package_order_ (build_order::stable),
      build_package_order_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_task::
    build_task (::brep::cli::scanner& s,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : build_task_request_max_size_ (102400),
      build_task_request_max_size_specified_ (false),
      build_result_timeout_ (10800),
      build_result_timeout_specified_ (false),
      build_interactive_login_ (),
      build_interactive_login_specified_ (false),
      build_package_order_ (build_order::stable),
      build_package_order_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_task::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // build_db base
      //
      p = ::brep::options::build_db::print_usage (os, p);

      // build_upload base
      //
      p = ::brep::options::build_upload::print_usage (os, p);

      // build_email_notification base
      //
      p = ::brep::options::build_email_notification::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "build-task-request-max-size <bytes>            The maximum size of the build" << ::std::endl
         << "                                               task request manifest accepted." << ::std::endl;

      os << "build-result-timeout <seconds>                 Time to wait before considering" << ::std::endl
         << "                                               the expected task result lost." << ::std::endl;

      os << "build-interactive-login </regex/replacement/>  Regular expressions for" << ::std::endl
         << "                                               transforming the interactive" << ::std::endl
         << "                                               build login information, for" << ::std::endl
         << "                                               example, into the actual command" << ::std::endl
         << "                                               that can be used by the user." << ::std::endl;

      os << "build-package-order <order>                    Order in which packages are" << ::std::endl
         << "                                               considered for build." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_task_desc_type: ::brep::cli::options
    {
      _cli_build_task_desc_type ()
      {
        ::brep::options::build_task::fill (*this);
      }
    };

    void build_task::
    fill (::brep::cli::options& os)
    {
      // build base
      //
      ::brep::options::build::fill (os);

      // build_db base
      //
      ::brep::options::build_db::fill (os);

      // build_upload base
      //
      ::brep::options::build_upload::fill (os);

      // build_email_notification base
      //
      ::brep::options::build_email_notification::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);

      // build-task-request-max-size
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("102400");
        ::brep::cli::option o ("build-task-request-max-size", a, false, dv);
        os.push_back (o);
      }

      // build-result-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("10800");
        ::brep::cli::option o ("build-result-timeout", a, false, dv);
        os.push_back (o);
      }

      // build-interactive-login
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-interactive-login", a, false, dv);
        os.push_back (o);
      }

      // build-package-order
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("build-package-order", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build_task::
    description ()
    {
      static _cli_build_task_desc_type _cli_build_task_desc_;
      return _cli_build_task_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_task&, ::brep::cli::scanner&)>
    _cli_build_task_map;

    static _cli_build_task_map _cli_build_task_map_;

    struct _cli_build_task_map_init
    {
      _cli_build_task_map_init ()
      {
        _cli_build_task_map_["build-task-request-max-size"] =
        &::brep::cli::thunk< build_task, size_t, &build_task::build_task_request_max_size_,
          &build_task::build_task_request_max_size_specified_ >;
        _cli_build_task_map_["build-result-timeout"] =
        &::brep::cli::thunk< build_task, size_t, &build_task::build_result_timeout_,
          &build_task::build_result_timeout_specified_ >;
        _cli_build_task_map_["build-interactive-login"] =
        &::brep::cli::thunk< build_task, vector<pair<std::regex, string>>, &build_task::build_interactive_login_,
          &build_task::build_interactive_login_specified_ >;
        _cli_build_task_map_["build-package-order"] =
        &::brep::cli::thunk< build_task, build_order, &build_task::build_package_order_,
          &build_task::build_package_order_specified_ >;
      }
    };

    static _cli_build_task_map_init _cli_build_task_map_init_;

    bool build_task::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_task_map::const_iterator i (_cli_build_task_map_.find (o));

      if (i != _cli_build_task_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // build_db base
      //
      if (::brep::options::build_db::_parse (o, s))
        return true;

      // build_upload base
      //
      if (::brep::options::build_upload::_parse (o, s))
        return true;

      // build_email_notification base
      //
      if (::brep::options::build_email_notification::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool build_task::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_result
    //

    build_result::
    build_result ()
    : build_result_request_max_size_ (15728640),
      build_result_request_max_size_specified_ (false)
    {
    }

    build_result::
    build_result (int& argc,
                  char** argv,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : build_result_request_max_size_ (15728640),
      build_result_request_max_size_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_result::
    build_result (int start,
                  int& argc,
                  char** argv,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : build_result_request_max_size_ (15728640),
      build_result_request_max_size_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_result::
    build_result (int& argc,
                  char** argv,
                  int& end,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : build_result_request_max_size_ (15728640),
      build_result_request_max_size_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_result::
    build_result (int start,
                  int& argc,
                  char** argv,
                  int& end,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : build_result_request_max_size_ (15728640),
      build_result_request_max_size_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_result::
    build_result (::brep::cli::scanner& s,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    : build_result_request_max_size_ (15728640),
      build_result_request_max_size_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_result::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // build_db base
      //
      p = ::brep::options::build_db::print_usage (os, p);

      // build_email_notification base
      //
      p = ::brep::options::build_email_notification::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "build-result-request-max-size <bytes>          The maximum size of the build" << ::std::endl
         << "                                               result manifest accepted." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_result_desc_type: ::brep::cli::options
    {
      _cli_build_result_desc_type ()
      {
        ::brep::options::build_result::fill (*this);
      }
    };

    void build_result::
    fill (::brep::cli::options& os)
    {
      // build base
      //
      ::brep::options::build::fill (os);

      // build_db base
      //
      ::brep::options::build_db::fill (os);

      // build_email_notification base
      //
      ::brep::options::build_email_notification::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);

      // build-result-request-max-size
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("15728640");
        ::brep::cli::option o ("build-result-request-max-size", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build_result::
    description ()
    {
      static _cli_build_result_desc_type _cli_build_result_desc_;
      return _cli_build_result_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_result&, ::brep::cli::scanner&)>
    _cli_build_result_map;

    static _cli_build_result_map _cli_build_result_map_;

    struct _cli_build_result_map_init
    {
      _cli_build_result_map_init ()
      {
        _cli_build_result_map_["build-result-request-max-size"] =
        &::brep::cli::thunk< build_result, size_t, &build_result::build_result_request_max_size_,
          &build_result::build_result_request_max_size_specified_ >;
      }
    };

    static _cli_build_result_map_init _cli_build_result_map_init_;

    bool build_result::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_result_map::const_iterator i (_cli_build_result_map_.find (o));

      if (i != _cli_build_result_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // build_db base
      //
      if (::brep::options::build_db::_parse (o, s))
        return true;

      // build_email_notification base
      //
      if (::brep::options::build_email_notification::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool build_result::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_log
    //

    build_log::
    build_log ()
    {
    }

    build_log::
    build_log (int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_log::
    build_log (int start,
               int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_log::
    build_log (int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_log::
    build_log (int start,
               int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_log::
    build_log (::brep::cli::scanner& s,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_log::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // build_db base
      //
      p = ::brep::options::build_db::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      return p;
    }

    struct _cli_build_log_desc_type: ::brep::cli::options
    {
      _cli_build_log_desc_type ()
      {
        ::brep::options::build_log::fill (*this);
      }
    };

    void build_log::
    fill (::brep::cli::options& os)
    {
      // build base
      //
      ::brep::options::build::fill (os);

      // build_db base
      //
      ::brep::options::build_db::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);
    }

    const ::brep::cli::options& build_log::
    description ()
    {
      static _cli_build_log_desc_type _cli_build_log_desc_;
      return _cli_build_log_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_log&, ::brep::cli::scanner&)>
    _cli_build_log_map;

    static _cli_build_log_map _cli_build_log_map_;

    struct _cli_build_log_map_init
    {
      _cli_build_log_map_init ()
      {
      }
    };

    static _cli_build_log_map_init _cli_build_log_map_init_;

    bool build_log::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_log_map::const_iterator i (_cli_build_log_map_.find (o));

      if (i != _cli_build_log_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // build_db base
      //
      if (::brep::options::build_db::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool build_log::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_force
    //

    build_force::
    build_force ()
    {
    }

    build_force::
    build_force (int& argc,
                 char** argv,
                 bool erase,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_force::
    build_force (int start,
                 int& argc,
                 char** argv,
                 bool erase,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_force::
    build_force (int& argc,
                 char** argv,
                 int& end,
                 bool erase,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_force::
    build_force (int start,
                 int& argc,
                 char** argv,
                 int& end,
                 bool erase,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_force::
    build_force (::brep::cli::scanner& s,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_force::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // build_db base
      //
      p = ::brep::options::build_db::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      return p;
    }

    struct _cli_build_force_desc_type: ::brep::cli::options
    {
      _cli_build_force_desc_type ()
      {
        ::brep::options::build_force::fill (*this);
      }
    };

    void build_force::
    fill (::brep::cli::options& os)
    {
      // build base
      //
      ::brep::options::build::fill (os);

      // build_db base
      //
      ::brep::options::build_db::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);
    }

    const ::brep::cli::options& build_force::
    description ()
    {
      static _cli_build_force_desc_type _cli_build_force_desc_;
      return _cli_build_force_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_force&, ::brep::cli::scanner&)>
    _cli_build_force_map;

    static _cli_build_force_map _cli_build_force_map_;

    struct _cli_build_force_map_init
    {
      _cli_build_force_map_init ()
      {
      }
    };

    static _cli_build_force_map_init _cli_build_force_map_init_;

    bool build_force::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_force_map::const_iterator i (_cli_build_force_map_.find (o));

      if (i != _cli_build_force_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // build_db base
      //
      if (::brep::options::build_db::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool build_force::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // builds
    //

    builds::
    builds ()
    : build_page_entries_ (20),
      build_page_entries_specified_ (false),
      build_pages_ (5),
      build_pages_specified_ (false)
    {
    }

    builds::
    builds (int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : build_page_entries_ (20),
      build_page_entries_specified_ (false),
      build_pages_ (5),
      build_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    builds::
    builds (int start,
            int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : build_page_entries_ (20),
      build_page_entries_specified_ (false),
      build_pages_ (5),
      build_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    builds::
    builds (int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : build_page_entries_ (20),
      build_page_entries_specified_ (false),
      build_pages_ (5),
      build_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    builds::
    builds (int start,
            int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : build_page_entries_ (20),
      build_page_entries_specified_ (false),
      build_pages_ (5),
      build_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    builds::
    builds (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : build_page_entries_ (20),
      build_page_entries_specified_ (false),
      build_pages_ (5),
      build_pages_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para builds::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // build_db base
      //
      p = ::brep::options::build_db::print_usage (os, p);

      // page base
      //
      p = ::brep::options::page::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "build-page-entries <num>                       Number of builds per page." << ::std::endl;

      os << "build-pages <num>                              Number of pages in navigation" << ::std::endl
         << "                                               (pager)." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_builds_desc_type: ::brep::cli::options
    {
      _cli_builds_desc_type ()
      {
        ::brep::options::builds::fill (*this);
      }
    };

    void builds::
    fill (::brep::cli::options& os)
    {
      // build base
      //
      ::brep::options::build::fill (os);

      // build_db base
      //
      ::brep::options::build_db::fill (os);

      // page base
      //
      ::brep::options::page::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);

      // build-page-entries
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("20");
        ::brep::cli::option o ("build-page-entries", a, false, dv);
        os.push_back (o);
      }

      // build-pages
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("5");
        ::brep::cli::option o ("build-pages", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& builds::
    description ()
    {
      static _cli_builds_desc_type _cli_builds_desc_;
      return _cli_builds_desc_;
    }

    typedef
    std::map<std::string, void (*) (builds&, ::brep::cli::scanner&)>
    _cli_builds_map;

    static _cli_builds_map _cli_builds_map_;

    struct _cli_builds_map_init
    {
      _cli_builds_map_init ()
      {
        _cli_builds_map_["build-page-entries"] =
        &::brep::cli::thunk< builds, uint16_t, &builds::build_page_entries_,
          &builds::build_page_entries_specified_ >;
        _cli_builds_map_["build-pages"] =
        &::brep::cli::thunk< builds, uint16_t, &builds::build_pages_,
          &builds::build_pages_specified_ >;
      }
    };

    static _cli_builds_map_init _cli_builds_map_init_;

    bool builds::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_builds_map::const_iterator i (_cli_builds_map_.find (o));

      if (i != _cli_builds_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // build_db base
      //
      if (::brep::options::build_db::_parse (o, s))
        return true;

      // page base
      //
      if (::brep::options::page::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool builds::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_configs
    //

    build_configs::
    build_configs ()
    : build_config_page_entries_ (20),
      build_config_page_entries_specified_ (false),
      build_config_pages_ (5),
      build_config_pages_specified_ (false)
    {
    }

    build_configs::
    build_configs (int& argc,
                   char** argv,
                   bool erase,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : build_config_page_entries_ (20),
      build_config_page_entries_specified_ (false),
      build_config_pages_ (5),
      build_config_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_configs::
    build_configs (int start,
                   int& argc,
                   char** argv,
                   bool erase,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : build_config_page_entries_ (20),
      build_config_page_entries_specified_ (false),
      build_config_pages_ (5),
      build_config_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_configs::
    build_configs (int& argc,
                   char** argv,
                   int& end,
                   bool erase,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : build_config_page_entries_ (20),
      build_config_page_entries_specified_ (false),
      build_config_pages_ (5),
      build_config_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_configs::
    build_configs (int start,
                   int& argc,
                   char** argv,
                   int& end,
                   bool erase,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : build_config_page_entries_ (20),
      build_config_page_entries_specified_ (false),
      build_config_pages_ (5),
      build_config_pages_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_configs::
    build_configs (::brep::cli::scanner& s,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : build_config_page_entries_ (20),
      build_config_page_entries_specified_ (false),
      build_config_pages_ (5),
      build_config_pages_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_configs::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // page base
      //
      p = ::brep::options::page::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "build-config-page-entries <num>                Number of build configurations" << ::std::endl
         << "                                               per page." << ::std::endl;

      os << "build-config-pages <num>                       Number of pages in navigation" << ::std::endl
         << "                                               (pager)." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_configs_desc_type: ::brep::cli::options
    {
      _cli_build_configs_desc_type ()
      {
        ::brep::options::build_configs::fill (*this);
      }
    };

    void build_configs::
    fill (::brep::cli::options& os)
    {
      // build base
      //
      ::brep::options::build::fill (os);

      // page base
      //
      ::brep::options::page::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);

      // build-config-page-entries
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("20");
        ::brep::cli::option o ("build-config-page-entries", a, false, dv);
        os.push_back (o);
      }

      // build-config-pages
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("5");
        ::brep::cli::option o ("build-config-pages", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build_configs::
    description ()
    {
      static _cli_build_configs_desc_type _cli_build_configs_desc_;
      return _cli_build_configs_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_configs&, ::brep::cli::scanner&)>
    _cli_build_configs_map;

    static _cli_build_configs_map _cli_build_configs_map_;

    struct _cli_build_configs_map_init
    {
      _cli_build_configs_map_init ()
      {
        _cli_build_configs_map_["build-config-page-entries"] =
        &::brep::cli::thunk< build_configs, uint16_t, &build_configs::build_config_page_entries_,
          &build_configs::build_config_page_entries_specified_ >;
        _cli_build_configs_map_["build-config-pages"] =
        &::brep::cli::thunk< build_configs, uint16_t, &build_configs::build_config_pages_,
          &build_configs::build_config_pages_specified_ >;
      }
    };

    static _cli_build_configs_map_init _cli_build_configs_map_init_;

    bool build_configs::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_configs_map::const_iterator i (_cli_build_configs_map_.find (o));

      if (i != _cli_build_configs_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // page base
      //
      if (::brep::options::page::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool build_configs::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // submit
    //

    submit::
    submit ()
    : submit_data_ (),
      submit_data_specified_ (false),
      submit_temp_ (),
      submit_temp_specified_ (false),
      submit_max_size_ (10485760),
      submit_max_size_specified_ (false),
      submit_form_ (),
      submit_form_specified_ (false),
      submit_email_ (),
      submit_email_specified_ (false),
      submit_handler_ (),
      submit_handler_specified_ (false),
      submit_handler_argument_ (),
      submit_handler_argument_specified_ (false),
      submit_handler_timeout_ (),
      submit_handler_timeout_specified_ (false)
    {
    }

    submit::
    submit (int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : submit_data_ (),
      submit_data_specified_ (false),
      submit_temp_ (),
      submit_temp_specified_ (false),
      submit_max_size_ (10485760),
      submit_max_size_specified_ (false),
      submit_form_ (),
      submit_form_specified_ (false),
      submit_email_ (),
      submit_email_specified_ (false),
      submit_handler_ (),
      submit_handler_specified_ (false),
      submit_handler_argument_ (),
      submit_handler_argument_specified_ (false),
      submit_handler_timeout_ (),
      submit_handler_timeout_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    submit::
    submit (int start,
            int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : submit_data_ (),
      submit_data_specified_ (false),
      submit_temp_ (),
      submit_temp_specified_ (false),
      submit_max_size_ (10485760),
      submit_max_size_specified_ (false),
      submit_form_ (),
      submit_form_specified_ (false),
      submit_email_ (),
      submit_email_specified_ (false),
      submit_handler_ (),
      submit_handler_specified_ (false),
      submit_handler_argument_ (),
      submit_handler_argument_specified_ (false),
      submit_handler_timeout_ (),
      submit_handler_timeout_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    submit::
    submit (int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : submit_data_ (),
      submit_data_specified_ (false),
      submit_temp_ (),
      submit_temp_specified_ (false),
      submit_max_size_ (10485760),
      submit_max_size_specified_ (false),
      submit_form_ (),
      submit_form_specified_ (false),
      submit_email_ (),
      submit_email_specified_ (false),
      submit_handler_ (),
      submit_handler_specified_ (false),
      submit_handler_argument_ (),
      submit_handler_argument_specified_ (false),
      submit_handler_timeout_ (),
      submit_handler_timeout_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    submit::
    submit (int start,
            int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : submit_data_ (),
      submit_data_specified_ (false),
      submit_temp_ (),
      submit_temp_specified_ (false),
      submit_max_size_ (10485760),
      submit_max_size_specified_ (false),
      submit_form_ (),
      submit_form_specified_ (false),
      submit_email_ (),
      submit_email_specified_ (false),
      submit_handler_ (),
      submit_handler_specified_ (false),
      submit_handler_argument_ (),
      submit_handler_argument_specified_ (false),
      submit_handler_timeout_ (),
      submit_handler_timeout_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    submit::
    submit (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : submit_data_ (),
      submit_data_specified_ (false),
      submit_temp_ (),
      submit_temp_specified_ (false),
      submit_max_size_ (10485760),
      submit_max_size_specified_ (false),
      submit_form_ (),
      submit_form_specified_ (false),
      submit_email_ (),
      submit_email_specified_ (false),
      submit_handler_ (),
      submit_handler_specified_ (false),
      submit_handler_argument_ (),
      submit_handler_argument_specified_ (false),
      submit_handler_timeout_ (),
      submit_handler_timeout_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para submit::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // page base
      //
      p = ::brep::options::page::print_usage (os, p);

      // repository_email base
      //
      p = ::brep::options::repository_email::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "submit-data <dir>                              The directory to save final" << ::std::endl
         << "                                               submission data to." << ::std::endl;

      os << "submit-temp <dir>                              The directory to save temporary" << ::std::endl
         << "                                               submission data to." << ::std::endl;

      os << "submit-max-size <bytes>                        The maximum size of the" << ::std::endl
         << "                                               submission data accepted." << ::std::endl;

      os << "submit-form <file>                             The package submission form" << ::std::endl
         << "                                               fragment." << ::std::endl;

      os << "submit-email <email>                           The package submission email." << ::std::endl;

      os << "submit-handler <path>                          The handler program to be" << ::std::endl
         << "                                               executed on package submission." << ::std::endl;

      os << "submit-handler-argument <arg>                  Additional arguments to be" << ::std::endl
         << "                                               passed to the submission handler" << ::std::endl
         << "                                               program (see submit-handler for" << ::std::endl
         << "                                               details)." << ::std::endl;

      os << "submit-handler-timeout <seconds>               The submission handler program" << ::std::endl
         << "                                               timeout in seconds." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_submit_desc_type: ::brep::cli::options
    {
      _cli_submit_desc_type ()
      {
        ::brep::options::submit::fill (*this);
      }
    };

    void submit::
    fill (::brep::cli::options& os)
    {
      // page base
      //
      ::brep::options::page::fill (os);

      // repository_email base
      //
      ::brep::options::repository_email::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);

      // submit-data
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("submit-data", a, false, dv);
        os.push_back (o);
      }

      // submit-temp
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("submit-temp", a, false, dv);
        os.push_back (o);
      }

      // submit-max-size
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("10485760");
        ::brep::cli::option o ("submit-max-size", a, false, dv);
        os.push_back (o);
      }

      // submit-form
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("submit-form", a, false, dv);
        os.push_back (o);
      }

      // submit-email
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("submit-email", a, false, dv);
        os.push_back (o);
      }

      // submit-handler
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("submit-handler", a, false, dv);
        os.push_back (o);
      }

      // submit-handler-argument
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("submit-handler-argument", a, false, dv);
        os.push_back (o);
      }

      // submit-handler-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("submit-handler-timeout", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& submit::
    description ()
    {
      static _cli_submit_desc_type _cli_submit_desc_;
      return _cli_submit_desc_;
    }

    typedef
    std::map<std::string, void (*) (submit&, ::brep::cli::scanner&)>
    _cli_submit_map;

    static _cli_submit_map _cli_submit_map_;

    struct _cli_submit_map_init
    {
      _cli_submit_map_init ()
      {
        _cli_submit_map_["submit-data"] =
        &::brep::cli::thunk< submit, dir_path, &submit::submit_data_,
          &submit::submit_data_specified_ >;
        _cli_submit_map_["submit-temp"] =
        &::brep::cli::thunk< submit, dir_path, &submit::submit_temp_,
          &submit::submit_temp_specified_ >;
        _cli_submit_map_["submit-max-size"] =
        &::brep::cli::thunk< submit, size_t, &submit::submit_max_size_,
          &submit::submit_max_size_specified_ >;
        _cli_submit_map_["submit-form"] =
        &::brep::cli::thunk< submit, path, &submit::submit_form_,
          &submit::submit_form_specified_ >;
        _cli_submit_map_["submit-email"] =
        &::brep::cli::thunk< submit, string, &submit::submit_email_,
          &submit::submit_email_specified_ >;
        _cli_submit_map_["submit-handler"] =
        &::brep::cli::thunk< submit, path, &submit::submit_handler_,
          &submit::submit_handler_specified_ >;
        _cli_submit_map_["submit-handler-argument"] =
        &::brep::cli::thunk< submit, strings, &submit::submit_handler_argument_,
          &submit::submit_handler_argument_specified_ >;
        _cli_submit_map_["submit-handler-timeout"] =
        &::brep::cli::thunk< submit, size_t, &submit::submit_handler_timeout_,
          &submit::submit_handler_timeout_specified_ >;
      }
    };

    static _cli_submit_map_init _cli_submit_map_init_;

    bool submit::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_submit_map::const_iterator i (_cli_submit_map_.find (o));

      if (i != _cli_submit_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // page base
      //
      if (::brep::options::page::_parse (o, s))
        return true;

      // repository_email base
      //
      if (::brep::options::repository_email::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool submit::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // ci_start
    //

    ci_start::
    ci_start ()
    : ci_data_ (),
      ci_data_specified_ (false),
      ci_email_ (),
      ci_email_specified_ (false),
      ci_handler_ (),
      ci_handler_specified_ (false),
      ci_handler_argument_ (),
      ci_handler_argument_specified_ (false),
      ci_handler_timeout_ (),
      ci_handler_timeout_specified_ (false)
    {
    }

    ci_start::
    ci_start (int& argc,
              char** argv,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : ci_data_ (),
      ci_data_specified_ (false),
      ci_email_ (),
      ci_email_specified_ (false),
      ci_handler_ (),
      ci_handler_specified_ (false),
      ci_handler_argument_ (),
      ci_handler_argument_specified_ (false),
      ci_handler_timeout_ (),
      ci_handler_timeout_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci_start::
    ci_start (int start,
              int& argc,
              char** argv,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : ci_data_ (),
      ci_data_specified_ (false),
      ci_email_ (),
      ci_email_specified_ (false),
      ci_handler_ (),
      ci_handler_specified_ (false),
      ci_handler_argument_ (),
      ci_handler_argument_specified_ (false),
      ci_handler_timeout_ (),
      ci_handler_timeout_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci_start::
    ci_start (int& argc,
              char** argv,
              int& end,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : ci_data_ (),
      ci_data_specified_ (false),
      ci_email_ (),
      ci_email_specified_ (false),
      ci_handler_ (),
      ci_handler_specified_ (false),
      ci_handler_argument_ (),
      ci_handler_argument_specified_ (false),
      ci_handler_timeout_ (),
      ci_handler_timeout_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci_start::
    ci_start (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : ci_data_ (),
      ci_data_specified_ (false),
      ci_email_ (),
      ci_email_specified_ (false),
      ci_handler_ (),
      ci_handler_specified_ (false),
      ci_handler_argument_ (),
      ci_handler_argument_specified_ (false),
      ci_handler_timeout_ (),
      ci_handler_timeout_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci_start::
    ci_start (::brep::cli::scanner& s,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : ci_data_ (),
      ci_data_specified_ (false),
      ci_email_ (),
      ci_email_specified_ (false),
      ci_handler_ (),
      ci_handler_specified_ (false),
      ci_handler_argument_ (),
      ci_handler_argument_specified_ (false),
      ci_handler_timeout_ (),
      ci_handler_timeout_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para ci_start::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // repository_email base
      //
      p = ::brep::options::repository_email::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "ci-data <dir>                                  The directory to save CI request" << ::std::endl
         << "                                               data to." << ::std::endl;

      os << "ci-email <email>                               The package CI email." << ::std::endl;

      os << "ci-handler <path>                              The handler program to be" << ::std::endl
         << "                                               executed on CI request." << ::std::endl;

      os << "ci-handler-argument <arg>                      Additional arguments to be" << ::std::endl
         << "                                               passed to the CI handler program" << ::std::endl
         << "                                               (see ci-handler for details)." << ::std::endl;

      os << "ci-handler-timeout <seconds>                   The CI handler program timeout" << ::std::endl
         << "                                               in seconds." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_ci_start_desc_type: ::brep::cli::options
    {
      _cli_ci_start_desc_type ()
      {
        ::brep::options::ci_start::fill (*this);
      }
    };

    void ci_start::
    fill (::brep::cli::options& os)
    {
      // repository_email base
      //
      ::brep::options::repository_email::fill (os);

      // ci-data
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("ci-data", a, false, dv);
        os.push_back (o);
      }

      // ci-email
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("ci-email", a, false, dv);
        os.push_back (o);
      }

      // ci-handler
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("ci-handler", a, false, dv);
        os.push_back (o);
      }

      // ci-handler-argument
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("ci-handler-argument", a, false, dv);
        os.push_back (o);
      }

      // ci-handler-timeout
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("ci-handler-timeout", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& ci_start::
    description ()
    {
      static _cli_ci_start_desc_type _cli_ci_start_desc_;
      return _cli_ci_start_desc_;
    }

    typedef
    std::map<std::string, void (*) (ci_start&, ::brep::cli::scanner&)>
    _cli_ci_start_map;

    static _cli_ci_start_map _cli_ci_start_map_;

    struct _cli_ci_start_map_init
    {
      _cli_ci_start_map_init ()
      {
        _cli_ci_start_map_["ci-data"] =
        &::brep::cli::thunk< ci_start, dir_path, &ci_start::ci_data_,
          &ci_start::ci_data_specified_ >;
        _cli_ci_start_map_["ci-email"] =
        &::brep::cli::thunk< ci_start, string, &ci_start::ci_email_,
          &ci_start::ci_email_specified_ >;
        _cli_ci_start_map_["ci-handler"] =
        &::brep::cli::thunk< ci_start, path, &ci_start::ci_handler_,
          &ci_start::ci_handler_specified_ >;
        _cli_ci_start_map_["ci-handler-argument"] =
        &::brep::cli::thunk< ci_start, strings, &ci_start::ci_handler_argument_,
          &ci_start::ci_handler_argument_specified_ >;
        _cli_ci_start_map_["ci-handler-timeout"] =
        &::brep::cli::thunk< ci_start, size_t, &ci_start::ci_handler_timeout_,
          &ci_start::ci_handler_timeout_specified_ >;
      }
    };

    static _cli_ci_start_map_init _cli_ci_start_map_init_;

    bool ci_start::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_ci_start_map::const_iterator i (_cli_ci_start_map_.find (o));

      if (i != _cli_ci_start_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // repository_email base
      //
      if (::brep::options::repository_email::_parse (o, s))
        return true;

      return false;
    }

    bool ci_start::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // ci
    //

    ci::
    ci ()
    : ci_form_ (),
      ci_form_specified_ (false)
    {
    }

    ci::
    ci (int& argc,
        char** argv,
        bool erase,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : ci_form_ (),
      ci_form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci::
    ci (int start,
        int& argc,
        char** argv,
        bool erase,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : ci_form_ (),
      ci_form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci::
    ci (int& argc,
        char** argv,
        int& end,
        bool erase,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : ci_form_ (),
      ci_form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci::
    ci (int start,
        int& argc,
        char** argv,
        int& end,
        bool erase,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : ci_form_ (),
      ci_form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci::
    ci (::brep::cli::scanner& s,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : ci_form_ (),
      ci_form_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para ci::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // ci_start base
      //
      p = ::brep::options::ci_start::print_usage (os, p);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // build_db base
      //
      p = ::brep::options::build_db::print_usage (os, p);

      // page base
      //
      p = ::brep::options::page::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "ci-form <file>                                 The package CI form fragment." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_ci_desc_type: ::brep::cli::options
    {
      _cli_ci_desc_type ()
      {
        ::brep::options::ci::fill (*this);
      }
    };

    void ci::
    fill (::brep::cli::options& os)
    {
      // ci_start base
      //
      ::brep::options::ci_start::fill (os);

      // build base
      //
      ::brep::options::build::fill (os);

      // build_db base
      //
      ::brep::options::build_db::fill (os);

      // page base
      //
      ::brep::options::page::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);

      // ci-form
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("ci-form", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& ci::
    description ()
    {
      static _cli_ci_desc_type _cli_ci_desc_;
      return _cli_ci_desc_;
    }

    typedef
    std::map<std::string, void (*) (ci&, ::brep::cli::scanner&)>
    _cli_ci_map;

    static _cli_ci_map _cli_ci_map_;

    struct _cli_ci_map_init
    {
      _cli_ci_map_init ()
      {
        _cli_ci_map_["ci-form"] =
        &::brep::cli::thunk< ci, path, &ci::ci_form_,
          &ci::ci_form_specified_ >;
      }
    };

    static _cli_ci_map_init _cli_ci_map_init_;

    bool ci::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_ci_map::const_iterator i (_cli_ci_map_.find (o));

      if (i != _cli_ci_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // ci_start base
      //
      if (::brep::options::ci_start::_parse (o, s))
        return true;

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // build_db base
      //
      if (::brep::options::build_db::_parse (o, s))
        return true;

      // page base
      //
      if (::brep::options::page::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool ci::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // ci_cancel
    //

    ci_cancel::
    ci_cancel ()
    {
    }

    ci_cancel::
    ci_cancel (int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci_cancel::
    ci_cancel (int start,
               int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci_cancel::
    ci_cancel (int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci_cancel::
    ci_cancel (int start,
               int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci_cancel::
    ci_cancel (::brep::cli::scanner& s,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para ci_cancel::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // build_db base
      //
      p = ::brep::options::build_db::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      return p;
    }

    struct _cli_ci_cancel_desc_type: ::brep::cli::options
    {
      _cli_ci_cancel_desc_type ()
      {
        ::brep::options::ci_cancel::fill (*this);
      }
    };

    void ci_cancel::
    fill (::brep::cli::options& os)
    {
      // build base
      //
      ::brep::options::build::fill (os);

      // build_db base
      //
      ::brep::options::build_db::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);
    }

    const ::brep::cli::options& ci_cancel::
    description ()
    {
      static _cli_ci_cancel_desc_type _cli_ci_cancel_desc_;
      return _cli_ci_cancel_desc_;
    }

    typedef
    std::map<std::string, void (*) (ci_cancel&, ::brep::cli::scanner&)>
    _cli_ci_cancel_map;

    static _cli_ci_cancel_map _cli_ci_cancel_map_;

    struct _cli_ci_cancel_map_init
    {
      _cli_ci_cancel_map_init ()
      {
      }
    };

    static _cli_ci_cancel_map_init _cli_ci_cancel_map_init_;

    bool ci_cancel::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_ci_cancel_map::const_iterator i (_cli_ci_cancel_map_.find (o));

      if (i != _cli_ci_cancel_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // build_db base
      //
      if (::brep::options::build_db::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool ci_cancel::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // ci_github
    //

    ci_github::
    ci_github ()
    : ci_github_app_webhook_secret_ (),
      ci_github_app_webhook_secret_specified_ (false),
      ci_github_app_id_private_key_ (),
      ci_github_app_id_private_key_specified_ (false),
      ci_github_jwt_validity_period_ (600),
      ci_github_jwt_validity_period_specified_ (false),
      ci_github_app_id_name_ (),
      ci_github_app_id_name_specified_ (false),
      ci_github_builds_aggregate_report_ (0),
      ci_github_builds_aggregate_report_specified_ (false),
      ci_github_max_jobs_per_window_ (0),
      ci_github_max_jobs_per_window_specified_ (false)
    {
    }

    ci_github::
    ci_github (int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : ci_github_app_webhook_secret_ (),
      ci_github_app_webhook_secret_specified_ (false),
      ci_github_app_id_private_key_ (),
      ci_github_app_id_private_key_specified_ (false),
      ci_github_jwt_validity_period_ (600),
      ci_github_jwt_validity_period_specified_ (false),
      ci_github_app_id_name_ (),
      ci_github_app_id_name_specified_ (false),
      ci_github_builds_aggregate_report_ (0),
      ci_github_builds_aggregate_report_specified_ (false),
      ci_github_max_jobs_per_window_ (0),
      ci_github_max_jobs_per_window_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci_github::
    ci_github (int start,
               int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : ci_github_app_webhook_secret_ (),
      ci_github_app_webhook_secret_specified_ (false),
      ci_github_app_id_private_key_ (),
      ci_github_app_id_private_key_specified_ (false),
      ci_github_jwt_validity_period_ (600),
      ci_github_jwt_validity_period_specified_ (false),
      ci_github_app_id_name_ (),
      ci_github_app_id_name_specified_ (false),
      ci_github_builds_aggregate_report_ (0),
      ci_github_builds_aggregate_report_specified_ (false),
      ci_github_max_jobs_per_window_ (0),
      ci_github_max_jobs_per_window_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci_github::
    ci_github (int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : ci_github_app_webhook_secret_ (),
      ci_github_app_webhook_secret_specified_ (false),
      ci_github_app_id_private_key_ (),
      ci_github_app_id_private_key_specified_ (false),
      ci_github_jwt_validity_period_ (600),
      ci_github_jwt_validity_period_specified_ (false),
      ci_github_app_id_name_ (),
      ci_github_app_id_name_specified_ (false),
      ci_github_builds_aggregate_report_ (0),
      ci_github_builds_aggregate_report_specified_ (false),
      ci_github_max_jobs_per_window_ (0),
      ci_github_max_jobs_per_window_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci_github::
    ci_github (int start,
               int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : ci_github_app_webhook_secret_ (),
      ci_github_app_webhook_secret_specified_ (false),
      ci_github_app_id_private_key_ (),
      ci_github_app_id_private_key_specified_ (false),
      ci_github_jwt_validity_period_ (600),
      ci_github_jwt_validity_period_specified_ (false),
      ci_github_app_id_name_ (),
      ci_github_app_id_name_specified_ (false),
      ci_github_builds_aggregate_report_ (0),
      ci_github_builds_aggregate_report_specified_ (false),
      ci_github_max_jobs_per_window_ (0),
      ci_github_max_jobs_per_window_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci_github::
    ci_github (::brep::cli::scanner& s,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : ci_github_app_webhook_secret_ (),
      ci_github_app_webhook_secret_specified_ (false),
      ci_github_app_id_private_key_ (),
      ci_github_app_id_private_key_specified_ (false),
      ci_github_jwt_validity_period_ (600),
      ci_github_jwt_validity_period_specified_ (false),
      ci_github_app_id_name_ (),
      ci_github_app_id_name_specified_ (false),
      ci_github_builds_aggregate_report_ (0),
      ci_github_builds_aggregate_report_specified_ (false),
      ci_github_max_jobs_per_window_ (0),
      ci_github_max_jobs_per_window_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para ci_github::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // ci_start base
      //
      p = ::brep::options::ci_start::print_usage (os, p);

      // ci_cancel base
      //
      p = ::brep::options::ci_cancel::print_usage (os, p);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "ci-github-app-webhook-secret <path>            The GitHub App's configured" << ::std::endl
         << "                                               webhook secret." << ::std::endl;

      os << "ci-github-app-id-private-key <id>=<path>       The private key used during" << ::std::endl
         << "                                               GitHub API authentication for" << ::std::endl
         << "                                               the specified GitHub App ID." << ::std::endl;

      os << "ci-github-jwt-validity-period <seconds>        The number of seconds a JWT" << ::std::endl
         << "                                               (authentication token) should be" << ::std::endl
         << "                                               valid for." << ::std::endl;

      os << "ci-github-app-id-name <id>=<name>              The name of the GitHub App with" << ::std::endl
         << "                                               the specified GitHub App ID." << ::std::endl;

      os << "ci-github-builds-aggregate-report <number>     The number of builds exceeding" << ::std::endl
         << "                                               which triggers the aggregate" << ::std::endl
         << "                                               reporting mode." << ::std::endl;

      os << "ci-github-max-jobs-per-window <number>         The expected maximum number of" << ::std::endl
         << "                                               CI jobs per GitHub API calls" << ::std::endl
         << "                                               rate limit window imposed on an" << ::std::endl
         << "                                               App installation." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_ci_github_desc_type: ::brep::cli::options
    {
      _cli_ci_github_desc_type ()
      {
        ::brep::options::ci_github::fill (*this);
      }
    };

    void ci_github::
    fill (::brep::cli::options& os)
    {
      // ci_start base
      //
      ::brep::options::ci_start::fill (os);

      // ci_cancel base
      //
      ::brep::options::ci_cancel::fill (os);

      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // ci-github-app-webhook-secret
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("ci-github-app-webhook-secret", a, false, dv);
        os.push_back (o);
      }

      // ci-github-app-id-private-key
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("ci-github-app-id-private-key", a, false, dv);
        os.push_back (o);
      }

      // ci-github-jwt-validity-period
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("600");
        ::brep::cli::option o ("ci-github-jwt-validity-period", a, false, dv);
        os.push_back (o);
      }

      // ci-github-app-id-name
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("ci-github-app-id-name", a, false, dv);
        os.push_back (o);
      }

      // ci-github-builds-aggregate-report
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("0");
        ::brep::cli::option o ("ci-github-builds-aggregate-report", a, false, dv);
        os.push_back (o);
      }

      // ci-github-max-jobs-per-window
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("0");
        ::brep::cli::option o ("ci-github-max-jobs-per-window", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& ci_github::
    description ()
    {
      static _cli_ci_github_desc_type _cli_ci_github_desc_;
      return _cli_ci_github_desc_;
    }

    typedef
    std::map<std::string, void (*) (ci_github&, ::brep::cli::scanner&)>
    _cli_ci_github_map;

    static _cli_ci_github_map _cli_ci_github_map_;

    struct _cli_ci_github_map_init
    {
      _cli_ci_github_map_init ()
      {
        _cli_ci_github_map_["ci-github-app-webhook-secret"] =
        &::brep::cli::thunk< ci_github, path, &ci_github::ci_github_app_webhook_secret_,
          &ci_github::ci_github_app_webhook_secret_specified_ >;
        _cli_ci_github_map_["ci-github-app-id-private-key"] =
        &::brep::cli::thunk< ci_github, std::map<uint64_t, dir_path>, &ci_github::ci_github_app_id_private_key_,
          &ci_github::ci_github_app_id_private_key_specified_ >;
        _cli_ci_github_map_["ci-github-jwt-validity-period"] =
        &::brep::cli::thunk< ci_github, uint16_t, &ci_github::ci_github_jwt_validity_period_,
          &ci_github::ci_github_jwt_validity_period_specified_ >;
        _cli_ci_github_map_["ci-github-app-id-name"] =
        &::brep::cli::thunk< ci_github, std::map<uint64_t, string>, &ci_github::ci_github_app_id_name_,
          &ci_github::ci_github_app_id_name_specified_ >;
        _cli_ci_github_map_["ci-github-builds-aggregate-report"] =
        &::brep::cli::thunk< ci_github, size_t, &ci_github::ci_github_builds_aggregate_report_,
          &ci_github::ci_github_builds_aggregate_report_specified_ >;
        _cli_ci_github_map_["ci-github-max-jobs-per-window"] =
        &::brep::cli::thunk< ci_github, size_t, &ci_github::ci_github_max_jobs_per_window_,
          &ci_github::ci_github_max_jobs_per_window_specified_ >;
      }
    };

    static _cli_ci_github_map_init _cli_ci_github_map_init_;

    bool ci_github::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_ci_github_map::const_iterator i (_cli_ci_github_map_.find (o));

      if (i != _cli_ci_github_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // ci_start base
      //
      if (::brep::options::ci_start::_parse (o, s))
        return true;

      // ci_cancel base
      //
      if (::brep::options::ci_cancel::_parse (o, s))
        return true;

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      return false;
    }

    bool ci_github::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // upload
    //

    upload::
    upload ()
    {
    }

    upload::
    upload (int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    upload::
    upload (int start,
            int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    upload::
    upload (int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    upload::
    upload (int start,
            int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    upload::
    upload (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para upload::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // build base
      //
      p = ::brep::options::build::print_usage (os, p);

      // build_db base
      //
      p = ::brep::options::build_db::print_usage (os, p);

      // build_upload base
      //
      p = ::brep::options::build_upload::print_usage (os, p);

      // repository_email base
      //
      p = ::brep::options::repository_email::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      return p;
    }

    struct _cli_upload_desc_type: ::brep::cli::options
    {
      _cli_upload_desc_type ()
      {
        ::brep::options::upload::fill (*this);
      }
    };

    void upload::
    fill (::brep::cli::options& os)
    {
      // build base
      //
      ::brep::options::build::fill (os);

      // build_db base
      //
      ::brep::options::build_db::fill (os);

      // build_upload base
      //
      ::brep::options::build_upload::fill (os);

      // repository_email base
      //
      ::brep::options::repository_email::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);
    }

    const ::brep::cli::options& upload::
    description ()
    {
      static _cli_upload_desc_type _cli_upload_desc_;
      return _cli_upload_desc_;
    }

    typedef
    std::map<std::string, void (*) (upload&, ::brep::cli::scanner&)>
    _cli_upload_map;

    static _cli_upload_map _cli_upload_map_;

    struct _cli_upload_map_init
    {
      _cli_upload_map_init ()
      {
      }
    };

    static _cli_upload_map_init _cli_upload_map_init_;

    bool upload::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_upload_map::const_iterator i (_cli_upload_map_.find (o));

      if (i != _cli_upload_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // build base
      //
      if (::brep::options::build::_parse (o, s))
        return true;

      // build_db base
      //
      if (::brep::options::build_db::_parse (o, s))
        return true;

      // build_upload base
      //
      if (::brep::options::build_upload::_parse (o, s))
        return true;

      // repository_email base
      //
      if (::brep::options::repository_email::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool upload::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // repository_root
    //

    repository_root::
    repository_root ()
    : root_global_view_ ("packages"),
      root_global_view_specified_ (false),
      root_tenant_view_ ("packages"),
      root_tenant_view_specified_ (false)
    {
    }

    repository_root::
    repository_root (int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : root_global_view_ ("packages"),
      root_global_view_specified_ (false),
      root_tenant_view_ ("packages"),
      root_tenant_view_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_root::
    repository_root (int start,
                     int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : root_global_view_ ("packages"),
      root_global_view_specified_ (false),
      root_tenant_view_ ("packages"),
      root_tenant_view_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_root::
    repository_root (int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : root_global_view_ ("packages"),
      root_global_view_specified_ (false),
      root_tenant_view_ ("packages"),
      root_tenant_view_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_root::
    repository_root (int start,
                     int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : root_global_view_ ("packages"),
      root_global_view_specified_ (false),
      root_tenant_view_ ("packages"),
      root_tenant_view_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_root::
    repository_root (::brep::cli::scanner& s,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : root_global_view_ ("packages"),
      root_global_view_specified_ (false),
      root_tenant_view_ ("packages"),
      root_tenant_view_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para repository_root::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      // repository_url base
      //
      p = ::brep::options::repository_url::print_usage (os, p);

      // handler base
      //
      p = ::brep::options::handler::print_usage (os, p);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "root-global-view <service>                     The default view to display for" << ::std::endl
         << "                                               the global repository root." << ::std::endl;

      os << "root-tenant-view <service>                     The default view to display for" << ::std::endl
         << "                                               the tenant repository root." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_repository_root_desc_type: ::brep::cli::options
    {
      _cli_repository_root_desc_type ()
      {
        ::brep::options::repository_root::fill (*this);
      }
    };

    void repository_root::
    fill (::brep::cli::options& os)
    {
      // repository_url base
      //
      ::brep::options::repository_url::fill (os);

      // handler base
      //
      ::brep::options::handler::fill (os);

      // root-global-view
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("packages");
        ::brep::cli::option o ("root-global-view", a, false, dv);
        os.push_back (o);
      }

      // root-tenant-view
      //
      {
        ::brep::cli::option_names a;
        std::string dv ("packages");
        ::brep::cli::option o ("root-tenant-view", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& repository_root::
    description ()
    {
      static _cli_repository_root_desc_type _cli_repository_root_desc_;
      return _cli_repository_root_desc_;
    }

    typedef
    std::map<std::string, void (*) (repository_root&, ::brep::cli::scanner&)>
    _cli_repository_root_map;

    static _cli_repository_root_map _cli_repository_root_map_;

    struct _cli_repository_root_map_init
    {
      _cli_repository_root_map_init ()
      {
        _cli_repository_root_map_["root-global-view"] =
        &::brep::cli::thunk< repository_root, string, &repository_root::root_global_view_,
          &repository_root::root_global_view_specified_ >;
        _cli_repository_root_map_["root-tenant-view"] =
        &::brep::cli::thunk< repository_root, string, &repository_root::root_tenant_view_,
          &repository_root::root_tenant_view_specified_ >;
      }
    };

    static _cli_repository_root_map_init _cli_repository_root_map_init_;

    bool repository_root::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_repository_root_map::const_iterator i (_cli_repository_root_map_.find (o));

      if (i != _cli_repository_root_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      // repository_url base
      //
      if (::brep::options::repository_url::_parse (o, s))
        return true;

      // handler base
      //
      if (::brep::options::handler::_parse (o, s))
        return true;

      return false;
    }

    bool repository_root::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }
  }

  namespace params
  {
    // packages
    //

    packages::
    packages ()
    : page_ (),
      page_specified_ (false),
      q_ (),
      q_specified_ (false)
    {
    }

    packages::
    packages (int& argc,
              char** argv,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      q_ (),
      q_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    packages::
    packages (int start,
              int& argc,
              char** argv,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      q_ (),
      q_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    packages::
    packages (int& argc,
              char** argv,
              int& end,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      q_ (),
      q_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    packages::
    packages (int start,
              int& argc,
              char** argv,
              int& end,
              bool erase,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      q_ (),
      q_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    packages::
    packages (::brep::cli::scanner& s,
              ::brep::cli::unknown_mode opt,
              ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      q_ (),
      q_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para packages::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "page|p <arg>" << std::endl;

      os << "q|_ <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_packages_desc_type: ::brep::cli::options
    {
      _cli_packages_desc_type ()
      {
        ::brep::params::packages::fill (*this);
      }
    };

    void packages::
    fill (::brep::cli::options& os)
    {
      // page
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("p");
        std::string dv;
        ::brep::cli::option o ("page", a, false, dv);
        os.push_back (o);
      }

      // q
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("_");
        std::string dv;
        ::brep::cli::option o ("q", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& packages::
    description ()
    {
      static _cli_packages_desc_type _cli_packages_desc_;
      return _cli_packages_desc_;
    }

    typedef
    std::map<std::string, void (*) (packages&, ::brep::cli::scanner&)>
    _cli_packages_map;

    static _cli_packages_map _cli_packages_map_;

    struct _cli_packages_map_init
    {
      _cli_packages_map_init ()
      {
        _cli_packages_map_["page"] =
        &::brep::cli::thunk< packages, uint16_t, &packages::page_,
          &packages::page_specified_ >;
        _cli_packages_map_["p"] =
        &::brep::cli::thunk< packages, uint16_t, &packages::page_,
          &packages::page_specified_ >;
        _cli_packages_map_["q"] =
        &::brep::cli::thunk< packages, string, &packages::q_,
          &packages::q_specified_ >;
        _cli_packages_map_["_"] =
        &::brep::cli::thunk< packages, string, &packages::q_,
          &packages::q_specified_ >;
      }
    };

    static _cli_packages_map_init _cli_packages_map_init_;

    bool packages::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_packages_map::const_iterator i (_cli_packages_map_.find (o));

      if (i != _cli_packages_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool packages::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // advanced_search
    //

    advanced_search::
    advanced_search ()
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      project_ (),
      project_specified_ (false),
      repository_ ("*"),
      repository_specified_ (false),
      reviews_ ("*"),
      reviews_specified_ (false)
    {
    }

    advanced_search::
    advanced_search (int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      project_ (),
      project_specified_ (false),
      repository_ ("*"),
      repository_specified_ (false),
      reviews_ ("*"),
      reviews_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    advanced_search::
    advanced_search (int start,
                     int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      project_ (),
      project_specified_ (false),
      repository_ ("*"),
      repository_specified_ (false),
      reviews_ ("*"),
      reviews_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    advanced_search::
    advanced_search (int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      project_ (),
      project_specified_ (false),
      repository_ ("*"),
      repository_specified_ (false),
      reviews_ ("*"),
      reviews_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    advanced_search::
    advanced_search (int start,
                     int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      project_ (),
      project_specified_ (false),
      repository_ ("*"),
      repository_specified_ (false),
      reviews_ ("*"),
      reviews_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    advanced_search::
    advanced_search (::brep::cli::scanner& s,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      project_ (),
      project_specified_ (false),
      repository_ ("*"),
      repository_specified_ (false),
      reviews_ ("*"),
      reviews_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para advanced_search::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "page|p <arg>" << std::endl;

      os << "name|_ <arg>" << std::endl;

      os << "version|pv <arg>" << std::endl;

      os << "project|pr <arg>" << std::endl;

      os << "repository|rp <arg>" << std::endl;

      os << "reviews|rv <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_advanced_search_desc_type: ::brep::cli::options
    {
      _cli_advanced_search_desc_type ()
      {
        ::brep::params::advanced_search::fill (*this);
      }
    };

    void advanced_search::
    fill (::brep::cli::options& os)
    {
      // page
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("p");
        std::string dv;
        ::brep::cli::option o ("page", a, false, dv);
        os.push_back (o);
      }

      // name
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("_");
        std::string dv;
        ::brep::cli::option o ("name", a, false, dv);
        os.push_back (o);
      }

      // version
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("pv");
        std::string dv;
        ::brep::cli::option o ("version", a, false, dv);
        os.push_back (o);
      }

      // project
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("pr");
        std::string dv;
        ::brep::cli::option o ("project", a, false, dv);
        os.push_back (o);
      }

      // repository
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("rp");
        std::string dv ("*");
        ::brep::cli::option o ("repository", a, false, dv);
        os.push_back (o);
      }

      // reviews
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("rv");
        std::string dv ("*");
        ::brep::cli::option o ("reviews", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& advanced_search::
    description ()
    {
      static _cli_advanced_search_desc_type _cli_advanced_search_desc_;
      return _cli_advanced_search_desc_;
    }

    typedef
    std::map<std::string, void (*) (advanced_search&, ::brep::cli::scanner&)>
    _cli_advanced_search_map;

    static _cli_advanced_search_map _cli_advanced_search_map_;

    struct _cli_advanced_search_map_init
    {
      _cli_advanced_search_map_init ()
      {
        _cli_advanced_search_map_["page"] =
        &::brep::cli::thunk< advanced_search, uint16_t, &advanced_search::page_,
          &advanced_search::page_specified_ >;
        _cli_advanced_search_map_["p"] =
        &::brep::cli::thunk< advanced_search, uint16_t, &advanced_search::page_,
          &advanced_search::page_specified_ >;
        _cli_advanced_search_map_["name"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::name_,
          &advanced_search::name_specified_ >;
        _cli_advanced_search_map_["_"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::name_,
          &advanced_search::name_specified_ >;
        _cli_advanced_search_map_["version"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::version_,
          &advanced_search::version_specified_ >;
        _cli_advanced_search_map_["pv"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::version_,
          &advanced_search::version_specified_ >;
        _cli_advanced_search_map_["project"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::project_,
          &advanced_search::project_specified_ >;
        _cli_advanced_search_map_["pr"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::project_,
          &advanced_search::project_specified_ >;
        _cli_advanced_search_map_["repository"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::repository_,
          &advanced_search::repository_specified_ >;
        _cli_advanced_search_map_["rp"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::repository_,
          &advanced_search::repository_specified_ >;
        _cli_advanced_search_map_["reviews"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::reviews_,
          &advanced_search::reviews_specified_ >;
        _cli_advanced_search_map_["rv"] =
        &::brep::cli::thunk< advanced_search, string, &advanced_search::reviews_,
          &advanced_search::reviews_specified_ >;
      }
    };

    static _cli_advanced_search_map_init _cli_advanced_search_map_init_;

    bool advanced_search::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_advanced_search_map::const_iterator i (_cli_advanced_search_map_.find (o));

      if (i != _cli_advanced_search_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool advanced_search::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // package_details
    //

    package_details::
    package_details ()
    : page_ (),
      page_specified_ (false),
      query_ (),
      query_specified_ (false),
      form_ (page_form::brief),
      form_specified_ (false)
    {
    }

    package_details::
    package_details (int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      query_ (),
      query_specified_ (false),
      form_ (page_form::brief),
      form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_details::
    package_details (int start,
                     int& argc,
                     char** argv,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      query_ (),
      query_specified_ (false),
      form_ (page_form::brief),
      form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_details::
    package_details (int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      query_ (),
      query_specified_ (false),
      form_ (page_form::brief),
      form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_details::
    package_details (int start,
                     int& argc,
                     char** argv,
                     int& end,
                     bool erase,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      query_ (),
      query_specified_ (false),
      form_ (page_form::brief),
      form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_details::
    package_details (::brep::cli::scanner& s,
                     ::brep::cli::unknown_mode opt,
                     ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      query_ (),
      query_specified_ (false),
      form_ (page_form::brief),
      form_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para package_details::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "page|p <arg>" << std::endl;

      os << "query|q <arg>" << std::endl;

      os << "form|f <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_package_details_desc_type: ::brep::cli::options
    {
      _cli_package_details_desc_type ()
      {
        ::brep::params::package_details::fill (*this);
      }
    };

    void package_details::
    fill (::brep::cli::options& os)
    {
      // page
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("p");
        std::string dv;
        ::brep::cli::option o ("page", a, false, dv);
        os.push_back (o);
      }

      // query
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("q");
        std::string dv;
        ::brep::cli::option o ("query", a, false, dv);
        os.push_back (o);
      }

      // form
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("f");
        std::string dv;
        ::brep::cli::option o ("form", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& package_details::
    description ()
    {
      static _cli_package_details_desc_type _cli_package_details_desc_;
      return _cli_package_details_desc_;
    }

    typedef
    std::map<std::string, void (*) (package_details&, ::brep::cli::scanner&)>
    _cli_package_details_map;

    static _cli_package_details_map _cli_package_details_map_;

    struct _cli_package_details_map_init
    {
      _cli_package_details_map_init ()
      {
        _cli_package_details_map_["page"] =
        &::brep::cli::thunk< package_details, uint16_t, &package_details::page_,
          &package_details::page_specified_ >;
        _cli_package_details_map_["p"] =
        &::brep::cli::thunk< package_details, uint16_t, &package_details::page_,
          &package_details::page_specified_ >;
        _cli_package_details_map_["query"] =
        &::brep::cli::thunk< package_details, string, &package_details::query_,
          &package_details::query_specified_ >;
        _cli_package_details_map_["q"] =
        &::brep::cli::thunk< package_details, string, &package_details::query_,
          &package_details::query_specified_ >;
        _cli_package_details_map_["form"] =
        &::brep::cli::thunk< package_details, page_form, &package_details::form_,
          &package_details::form_specified_ >;
        _cli_package_details_map_["f"] =
        &::brep::cli::thunk< package_details, page_form, &package_details::form_,
          &package_details::form_specified_ >;
      }
    };

    static _cli_package_details_map_init _cli_package_details_map_init_;

    bool package_details::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_package_details_map::const_iterator i (_cli_package_details_map_.find (o));

      if (i != _cli_package_details_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool package_details::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // package_version_details
    //

    package_version_details::
    package_version_details ()
    : form_ (page_form::brief),
      form_specified_ (false)
    {
    }

    package_version_details::
    package_version_details (int& argc,
                             char** argv,
                             bool erase,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : form_ (page_form::brief),
      form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_version_details::
    package_version_details (int start,
                             int& argc,
                             char** argv,
                             bool erase,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : form_ (page_form::brief),
      form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    package_version_details::
    package_version_details (int& argc,
                             char** argv,
                             int& end,
                             bool erase,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : form_ (page_form::brief),
      form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_version_details::
    package_version_details (int start,
                             int& argc,
                             char** argv,
                             int& end,
                             bool erase,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : form_ (page_form::brief),
      form_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    package_version_details::
    package_version_details (::brep::cli::scanner& s,
                             ::brep::cli::unknown_mode opt,
                             ::brep::cli::unknown_mode arg)
    : form_ (page_form::brief),
      form_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para package_version_details::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "form|f <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_package_version_details_desc_type: ::brep::cli::options
    {
      _cli_package_version_details_desc_type ()
      {
        ::brep::params::package_version_details::fill (*this);
      }
    };

    void package_version_details::
    fill (::brep::cli::options& os)
    {
      // form
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("f");
        std::string dv;
        ::brep::cli::option o ("form", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& package_version_details::
    description ()
    {
      static _cli_package_version_details_desc_type _cli_package_version_details_desc_;
      return _cli_package_version_details_desc_;
    }

    typedef
    std::map<std::string, void (*) (package_version_details&, ::brep::cli::scanner&)>
    _cli_package_version_details_map;

    static _cli_package_version_details_map _cli_package_version_details_map_;

    struct _cli_package_version_details_map_init
    {
      _cli_package_version_details_map_init ()
      {
        _cli_package_version_details_map_["form"] =
        &::brep::cli::thunk< package_version_details, page_form, &package_version_details::form_,
          &package_version_details::form_specified_ >;
        _cli_package_version_details_map_["f"] =
        &::brep::cli::thunk< package_version_details, page_form, &package_version_details::form_,
          &package_version_details::form_specified_ >;
      }
    };

    static _cli_package_version_details_map_init _cli_package_version_details_map_init_;

    bool package_version_details::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_package_version_details_map::const_iterator i (_cli_package_version_details_map_.find (o));

      if (i != _cli_package_version_details_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool package_version_details::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // repository_details
    //

    repository_details::
    repository_details ()
    {
    }

    repository_details::
    repository_details (int& argc,
                        char** argv,
                        bool erase,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_details::
    repository_details (int start,
                        int& argc,
                        char** argv,
                        bool erase,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    repository_details::
    repository_details (int& argc,
                        char** argv,
                        int& end,
                        bool erase,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_details::
    repository_details (int start,
                        int& argc,
                        char** argv,
                        int& end,
                        bool erase,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    repository_details::
    repository_details (::brep::cli::scanner& s,
                        ::brep::cli::unknown_mode opt,
                        ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para repository_details::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      return p;
    }

    struct _cli_repository_details_desc_type: ::brep::cli::options
    {
      _cli_repository_details_desc_type ()
      {
        ::brep::params::repository_details::fill (*this);
      }
    };

    void repository_details::
    fill (::brep::cli::options&)
    {
    }

    const ::brep::cli::options& repository_details::
    description ()
    {
      static _cli_repository_details_desc_type _cli_repository_details_desc_;
      return _cli_repository_details_desc_;
    }

    typedef
    std::map<std::string, void (*) (repository_details&, ::brep::cli::scanner&)>
    _cli_repository_details_map;

    static _cli_repository_details_map _cli_repository_details_map_;

    struct _cli_repository_details_map_init
    {
      _cli_repository_details_map_init ()
      {
      }
    };

    static _cli_repository_details_map_init _cli_repository_details_map_init_;

    bool repository_details::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_repository_details_map::const_iterator i (_cli_repository_details_map_.find (o));

      if (i != _cli_repository_details_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool repository_details::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_task
    //

    build_task::
    build_task ()
    : repository_ (),
      repository_specified_ (false),
      interactive_ (bbot::interactive_mode::both),
      interactive_specified_ (false),
      tenant_service_type_ (),
      tenant_service_type_specified_ (false)
    {
    }

    build_task::
    build_task (int& argc,
                char** argv,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      interactive_ (bbot::interactive_mode::both),
      interactive_specified_ (false),
      tenant_service_type_ (),
      tenant_service_type_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_task::
    build_task (int start,
                int& argc,
                char** argv,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      interactive_ (bbot::interactive_mode::both),
      interactive_specified_ (false),
      tenant_service_type_ (),
      tenant_service_type_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_task::
    build_task (int& argc,
                char** argv,
                int& end,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      interactive_ (bbot::interactive_mode::both),
      interactive_specified_ (false),
      tenant_service_type_ (),
      tenant_service_type_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_task::
    build_task (int start,
                int& argc,
                char** argv,
                int& end,
                bool erase,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      interactive_ (bbot::interactive_mode::both),
      interactive_specified_ (false),
      tenant_service_type_ (),
      tenant_service_type_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_task::
    build_task (::brep::cli::scanner& s,
                ::brep::cli::unknown_mode opt,
                ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      interactive_ (bbot::interactive_mode::both),
      interactive_specified_ (false),
      tenant_service_type_ (),
      tenant_service_type_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_task::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "repository|r <arg>" << std::endl;

      os << "interactive <arg>" << std::endl;

      os << "tenant_service_type|t <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_task_desc_type: ::brep::cli::options
    {
      _cli_build_task_desc_type ()
      {
        ::brep::params::build_task::fill (*this);
      }
    };

    void build_task::
    fill (::brep::cli::options& os)
    {
      // repository
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("r");
        std::string dv;
        ::brep::cli::option o ("repository", a, false, dv);
        os.push_back (o);
      }

      // interactive
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("interactive", a, false, dv);
        os.push_back (o);
      }

      // tenant_service_type
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("t");
        std::string dv;
        ::brep::cli::option o ("tenant_service_type", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build_task::
    description ()
    {
      static _cli_build_task_desc_type _cli_build_task_desc_;
      return _cli_build_task_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_task&, ::brep::cli::scanner&)>
    _cli_build_task_map;

    static _cli_build_task_map _cli_build_task_map_;

    struct _cli_build_task_map_init
    {
      _cli_build_task_map_init ()
      {
        _cli_build_task_map_["repository"] =
        &::brep::cli::thunk< build_task, vector<string>, &build_task::repository_,
          &build_task::repository_specified_ >;
        _cli_build_task_map_["r"] =
        &::brep::cli::thunk< build_task, vector<string>, &build_task::repository_,
          &build_task::repository_specified_ >;
        _cli_build_task_map_["interactive"] =
        &::brep::cli::thunk< build_task, bbot::interactive_mode, &build_task::interactive_,
          &build_task::interactive_specified_ >;
        _cli_build_task_map_["tenant_service_type"] =
        &::brep::cli::thunk< build_task, vector<string>, &build_task::tenant_service_type_,
          &build_task::tenant_service_type_specified_ >;
        _cli_build_task_map_["t"] =
        &::brep::cli::thunk< build_task, vector<string>, &build_task::tenant_service_type_,
          &build_task::tenant_service_type_specified_ >;
      }
    };

    static _cli_build_task_map_init _cli_build_task_map_init_;

    bool build_task::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_task_map::const_iterator i (_cli_build_task_map_.find (o));

      if (i != _cli_build_task_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool build_task::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_result
    //

    build_result::
    build_result ()
    {
    }

    build_result::
    build_result (int& argc,
                  char** argv,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_result::
    build_result (int start,
                  int& argc,
                  char** argv,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_result::
    build_result (int& argc,
                  char** argv,
                  int& end,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_result::
    build_result (int start,
                  int& argc,
                  char** argv,
                  int& end,
                  bool erase,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_result::
    build_result (::brep::cli::scanner& s,
                  ::brep::cli::unknown_mode opt,
                  ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_result::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      return p;
    }

    struct _cli_build_result_desc_type: ::brep::cli::options
    {
      _cli_build_result_desc_type ()
      {
        ::brep::params::build_result::fill (*this);
      }
    };

    void build_result::
    fill (::brep::cli::options&)
    {
    }

    const ::brep::cli::options& build_result::
    description ()
    {
      static _cli_build_result_desc_type _cli_build_result_desc_;
      return _cli_build_result_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_result&, ::brep::cli::scanner&)>
    _cli_build_result_map;

    static _cli_build_result_map _cli_build_result_map_;

    struct _cli_build_result_map_init
    {
      _cli_build_result_map_init ()
      {
      }
    };

    static _cli_build_result_map_init _cli_build_result_map_init_;

    bool build_result::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_result_map::const_iterator i (_cli_build_result_map_.find (o));

      if (i != _cli_build_result_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool build_result::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_log
    //

    build_log::
    build_log ()
    {
    }

    build_log::
    build_log (int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_log::
    build_log (int start,
               int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_log::
    build_log (int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_log::
    build_log (int start,
               int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_log::
    build_log (::brep::cli::scanner& s,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_log::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      return p;
    }

    struct _cli_build_log_desc_type: ::brep::cli::options
    {
      _cli_build_log_desc_type ()
      {
        ::brep::params::build_log::fill (*this);
      }
    };

    void build_log::
    fill (::brep::cli::options&)
    {
    }

    const ::brep::cli::options& build_log::
    description ()
    {
      static _cli_build_log_desc_type _cli_build_log_desc_;
      return _cli_build_log_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_log&, ::brep::cli::scanner&)>
    _cli_build_log_map;

    static _cli_build_log_map _cli_build_log_map_;

    struct _cli_build_log_map_init
    {
      _cli_build_log_map_init ()
      {
      }
    };

    static _cli_build_log_map_init _cli_build_log_map_init_;

    bool build_log::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_log_map::const_iterator i (_cli_build_log_map_.find (o));

      if (i != _cli_build_log_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool build_log::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_force
    //

    build_force::
    build_force ()
    : package_ (),
      package_specified_ (false),
      version_ (),
      version_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      toolchain_name_ (),
      toolchain_name_specified_ (false),
      toolchain_version_ (),
      toolchain_version_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
    }

    build_force::
    build_force (int& argc,
                 char** argv,
                 bool erase,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    : package_ (),
      package_specified_ (false),
      version_ (),
      version_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      toolchain_name_ (),
      toolchain_name_specified_ (false),
      toolchain_version_ (),
      toolchain_version_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_force::
    build_force (int start,
                 int& argc,
                 char** argv,
                 bool erase,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    : package_ (),
      package_specified_ (false),
      version_ (),
      version_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      toolchain_name_ (),
      toolchain_name_specified_ (false),
      toolchain_version_ (),
      toolchain_version_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_force::
    build_force (int& argc,
                 char** argv,
                 int& end,
                 bool erase,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    : package_ (),
      package_specified_ (false),
      version_ (),
      version_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      toolchain_name_ (),
      toolchain_name_specified_ (false),
      toolchain_version_ (),
      toolchain_version_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_force::
    build_force (int start,
                 int& argc,
                 char** argv,
                 int& end,
                 bool erase,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    : package_ (),
      package_specified_ (false),
      version_ (),
      version_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      toolchain_name_ (),
      toolchain_name_specified_ (false),
      toolchain_version_ (),
      toolchain_version_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_force::
    build_force (::brep::cli::scanner& s,
                 ::brep::cli::unknown_mode opt,
                 ::brep::cli::unknown_mode arg)
    : package_ (),
      package_specified_ (false),
      version_ (),
      version_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      toolchain_name_ (),
      toolchain_name_specified_ (false),
      toolchain_version_ (),
      toolchain_version_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_force::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "package|pn <arg>" << std::endl;

      os << "version|pv <arg>" << std::endl;

      os << "target|tg <arg>" << std::endl;

      os << "target_config|tc <arg>" << std::endl;

      os << "package_config|pc <arg>" << std::endl;

      os << "toolchain_name|tn <arg>" << std::endl;

      os << "toolchain_version|tv <arg>" << std::endl;

      os << "reason <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_force_desc_type: ::brep::cli::options
    {
      _cli_build_force_desc_type ()
      {
        ::brep::params::build_force::fill (*this);
      }
    };

    void build_force::
    fill (::brep::cli::options& os)
    {
      // package
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("pn");
        std::string dv;
        ::brep::cli::option o ("package", a, false, dv);
        os.push_back (o);
      }

      // version
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("pv");
        std::string dv;
        ::brep::cli::option o ("version", a, false, dv);
        os.push_back (o);
      }

      // target
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("tg");
        std::string dv;
        ::brep::cli::option o ("target", a, false, dv);
        os.push_back (o);
      }

      // target_config
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("tc");
        std::string dv;
        ::brep::cli::option o ("target_config", a, false, dv);
        os.push_back (o);
      }

      // package_config
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("pc");
        std::string dv;
        ::brep::cli::option o ("package_config", a, false, dv);
        os.push_back (o);
      }

      // toolchain_name
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("tn");
        std::string dv;
        ::brep::cli::option o ("toolchain_name", a, false, dv);
        os.push_back (o);
      }

      // toolchain_version
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("tv");
        std::string dv;
        ::brep::cli::option o ("toolchain_version", a, false, dv);
        os.push_back (o);
      }

      // reason
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("reason", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build_force::
    description ()
    {
      static _cli_build_force_desc_type _cli_build_force_desc_;
      return _cli_build_force_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_force&, ::brep::cli::scanner&)>
    _cli_build_force_map;

    static _cli_build_force_map _cli_build_force_map_;

    struct _cli_build_force_map_init
    {
      _cli_build_force_map_init ()
      {
        _cli_build_force_map_["package"] =
        &::brep::cli::thunk< build_force, string, &build_force::package_,
          &build_force::package_specified_ >;
        _cli_build_force_map_["pn"] =
        &::brep::cli::thunk< build_force, string, &build_force::package_,
          &build_force::package_specified_ >;
        _cli_build_force_map_["version"] =
        &::brep::cli::thunk< build_force, string, &build_force::version_,
          &build_force::version_specified_ >;
        _cli_build_force_map_["pv"] =
        &::brep::cli::thunk< build_force, string, &build_force::version_,
          &build_force::version_specified_ >;
        _cli_build_force_map_["target"] =
        &::brep::cli::thunk< build_force, string, &build_force::target_,
          &build_force::target_specified_ >;
        _cli_build_force_map_["tg"] =
        &::brep::cli::thunk< build_force, string, &build_force::target_,
          &build_force::target_specified_ >;
        _cli_build_force_map_["target_config"] =
        &::brep::cli::thunk< build_force, string, &build_force::target_config_,
          &build_force::target_config_specified_ >;
        _cli_build_force_map_["tc"] =
        &::brep::cli::thunk< build_force, string, &build_force::target_config_,
          &build_force::target_config_specified_ >;
        _cli_build_force_map_["package_config"] =
        &::brep::cli::thunk< build_force, string, &build_force::package_config_,
          &build_force::package_config_specified_ >;
        _cli_build_force_map_["pc"] =
        &::brep::cli::thunk< build_force, string, &build_force::package_config_,
          &build_force::package_config_specified_ >;
        _cli_build_force_map_["toolchain_name"] =
        &::brep::cli::thunk< build_force, string, &build_force::toolchain_name_,
          &build_force::toolchain_name_specified_ >;
        _cli_build_force_map_["tn"] =
        &::brep::cli::thunk< build_force, string, &build_force::toolchain_name_,
          &build_force::toolchain_name_specified_ >;
        _cli_build_force_map_["toolchain_version"] =
        &::brep::cli::thunk< build_force, string, &build_force::toolchain_version_,
          &build_force::toolchain_version_specified_ >;
        _cli_build_force_map_["tv"] =
        &::brep::cli::thunk< build_force, string, &build_force::toolchain_version_,
          &build_force::toolchain_version_specified_ >;
        _cli_build_force_map_["reason"] =
        &::brep::cli::thunk< build_force, string, &build_force::reason_,
          &build_force::reason_specified_ >;
      }
    };

    static _cli_build_force_map_init _cli_build_force_map_init_;

    bool build_force::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_force_map::const_iterator i (_cli_build_force_map_.find (o));

      if (i != _cli_build_force_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool build_force::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // builds
    //

    builds::
    builds ()
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      toolchain_ ("*"),
      toolchain_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      result_ ("*"),
      result_specified_ (false)
    {
    }

    builds::
    builds (int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      toolchain_ ("*"),
      toolchain_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      result_ ("*"),
      result_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    builds::
    builds (int start,
            int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      toolchain_ ("*"),
      toolchain_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      result_ ("*"),
      result_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    builds::
    builds (int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      toolchain_ ("*"),
      toolchain_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      result_ ("*"),
      result_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    builds::
    builds (int start,
            int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      toolchain_ ("*"),
      toolchain_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      result_ ("*"),
      result_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    builds::
    builds (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : page_ (),
      page_specified_ (false),
      name_ (),
      name_specified_ (false),
      version_ (),
      version_specified_ (false),
      toolchain_ ("*"),
      toolchain_specified_ (false),
      target_ (),
      target_specified_ (false),
      target_config_ (),
      target_config_specified_ (false),
      package_config_ (),
      package_config_specified_ (false),
      result_ ("*"),
      result_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para builds::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "page|p <arg>" << std::endl;

      os << "name|_ <arg>" << std::endl;

      os << "version|pv <arg>" << std::endl;

      os << "toolchain|th <arg>" << std::endl;

      os << "target|tg <arg>" << std::endl;

      os << "target_config|tc <arg>" << std::endl;

      os << "package_config|pc <arg>" << std::endl;

      os << "result|rs <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_builds_desc_type: ::brep::cli::options
    {
      _cli_builds_desc_type ()
      {
        ::brep::params::builds::fill (*this);
      }
    };

    void builds::
    fill (::brep::cli::options& os)
    {
      // page
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("p");
        std::string dv;
        ::brep::cli::option o ("page", a, false, dv);
        os.push_back (o);
      }

      // name
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("_");
        std::string dv;
        ::brep::cli::option o ("name", a, false, dv);
        os.push_back (o);
      }

      // version
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("pv");
        std::string dv;
        ::brep::cli::option o ("version", a, false, dv);
        os.push_back (o);
      }

      // toolchain
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("th");
        std::string dv ("*");
        ::brep::cli::option o ("toolchain", a, false, dv);
        os.push_back (o);
      }

      // target
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("tg");
        std::string dv;
        ::brep::cli::option o ("target", a, false, dv);
        os.push_back (o);
      }

      // target_config
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("tc");
        std::string dv;
        ::brep::cli::option o ("target_config", a, false, dv);
        os.push_back (o);
      }

      // package_config
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("pc");
        std::string dv;
        ::brep::cli::option o ("package_config", a, false, dv);
        os.push_back (o);
      }

      // result
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("rs");
        std::string dv ("*");
        ::brep::cli::option o ("result", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& builds::
    description ()
    {
      static _cli_builds_desc_type _cli_builds_desc_;
      return _cli_builds_desc_;
    }

    typedef
    std::map<std::string, void (*) (builds&, ::brep::cli::scanner&)>
    _cli_builds_map;

    static _cli_builds_map _cli_builds_map_;

    struct _cli_builds_map_init
    {
      _cli_builds_map_init ()
      {
        _cli_builds_map_["page"] =
        &::brep::cli::thunk< builds, uint16_t, &builds::page_,
          &builds::page_specified_ >;
        _cli_builds_map_["p"] =
        &::brep::cli::thunk< builds, uint16_t, &builds::page_,
          &builds::page_specified_ >;
        _cli_builds_map_["name"] =
        &::brep::cli::thunk< builds, string, &builds::name_,
          &builds::name_specified_ >;
        _cli_builds_map_["_"] =
        &::brep::cli::thunk< builds, string, &builds::name_,
          &builds::name_specified_ >;
        _cli_builds_map_["version"] =
        &::brep::cli::thunk< builds, string, &builds::version_,
          &builds::version_specified_ >;
        _cli_builds_map_["pv"] =
        &::brep::cli::thunk< builds, string, &builds::version_,
          &builds::version_specified_ >;
        _cli_builds_map_["toolchain"] =
        &::brep::cli::thunk< builds, string, &builds::toolchain_,
          &builds::toolchain_specified_ >;
        _cli_builds_map_["th"] =
        &::brep::cli::thunk< builds, string, &builds::toolchain_,
          &builds::toolchain_specified_ >;
        _cli_builds_map_["target"] =
        &::brep::cli::thunk< builds, string, &builds::target_,
          &builds::target_specified_ >;
        _cli_builds_map_["tg"] =
        &::brep::cli::thunk< builds, string, &builds::target_,
          &builds::target_specified_ >;
        _cli_builds_map_["target_config"] =
        &::brep::cli::thunk< builds, string, &builds::target_config_,
          &builds::target_config_specified_ >;
        _cli_builds_map_["tc"] =
        &::brep::cli::thunk< builds, string, &builds::target_config_,
          &builds::target_config_specified_ >;
        _cli_builds_map_["package_config"] =
        &::brep::cli::thunk< builds, string, &builds::package_config_,
          &builds::package_config_specified_ >;
        _cli_builds_map_["pc"] =
        &::brep::cli::thunk< builds, string, &builds::package_config_,
          &builds::package_config_specified_ >;
        _cli_builds_map_["result"] =
        &::brep::cli::thunk< builds, string, &builds::result_,
          &builds::result_specified_ >;
        _cli_builds_map_["rs"] =
        &::brep::cli::thunk< builds, string, &builds::result_,
          &builds::result_specified_ >;
      }
    };

    static _cli_builds_map_init _cli_builds_map_init_;

    bool builds::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_builds_map::const_iterator i (_cli_builds_map_.find (o));

      if (i != _cli_builds_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool builds::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // build_configs
    //

    build_configs::
    build_configs ()
    : class_name_ (),
      class_name_specified_ (false),
      page_ (),
      page_specified_ (false)
    {
    }

    build_configs::
    build_configs (int& argc,
                   char** argv,
                   bool erase,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : class_name_ (),
      class_name_specified_ (false),
      page_ (),
      page_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_configs::
    build_configs (int start,
                   int& argc,
                   char** argv,
                   bool erase,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : class_name_ (),
      class_name_specified_ (false),
      page_ (),
      page_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    build_configs::
    build_configs (int& argc,
                   char** argv,
                   int& end,
                   bool erase,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : class_name_ (),
      class_name_specified_ (false),
      page_ (),
      page_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_configs::
    build_configs (int start,
                   int& argc,
                   char** argv,
                   int& end,
                   bool erase,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : class_name_ (),
      class_name_specified_ (false),
      page_ (),
      page_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    build_configs::
    build_configs (::brep::cli::scanner& s,
                   ::brep::cli::unknown_mode opt,
                   ::brep::cli::unknown_mode arg)
    : class_name_ (),
      class_name_specified_ (false),
      page_ (),
      page_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para build_configs::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "class_name|_ <arg>" << std::endl;

      os << "page|p <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_build_configs_desc_type: ::brep::cli::options
    {
      _cli_build_configs_desc_type ()
      {
        ::brep::params::build_configs::fill (*this);
      }
    };

    void build_configs::
    fill (::brep::cli::options& os)
    {
      // class_name
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("_");
        std::string dv;
        ::brep::cli::option o ("class_name", a, false, dv);
        os.push_back (o);
      }

      // page
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("p");
        std::string dv;
        ::brep::cli::option o ("page", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& build_configs::
    description ()
    {
      static _cli_build_configs_desc_type _cli_build_configs_desc_;
      return _cli_build_configs_desc_;
    }

    typedef
    std::map<std::string, void (*) (build_configs&, ::brep::cli::scanner&)>
    _cli_build_configs_map;

    static _cli_build_configs_map _cli_build_configs_map_;

    struct _cli_build_configs_map_init
    {
      _cli_build_configs_map_init ()
      {
        _cli_build_configs_map_["class_name"] =
        &::brep::cli::thunk< build_configs, string, &build_configs::class_name_,
          &build_configs::class_name_specified_ >;
        _cli_build_configs_map_["_"] =
        &::brep::cli::thunk< build_configs, string, &build_configs::class_name_,
          &build_configs::class_name_specified_ >;
        _cli_build_configs_map_["page"] =
        &::brep::cli::thunk< build_configs, uint16_t, &build_configs::page_,
          &build_configs::page_specified_ >;
        _cli_build_configs_map_["p"] =
        &::brep::cli::thunk< build_configs, uint16_t, &build_configs::page_,
          &build_configs::page_specified_ >;
      }
    };

    static _cli_build_configs_map_init _cli_build_configs_map_init_;

    bool build_configs::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_build_configs_map::const_iterator i (_cli_build_configs_map_.find (o));

      if (i != _cli_build_configs_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool build_configs::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // submit
    //

    submit::
    submit ()
    : archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
    }

    submit::
    submit (int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    submit::
    submit (int start,
            int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    submit::
    submit (int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    submit::
    submit (int start,
            int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    submit::
    submit (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para submit::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "archive <arg>" << std::endl;

      os << "sha256sum <arg>" << std::endl;

      os << "simulate <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_submit_desc_type: ::brep::cli::options
    {
      _cli_submit_desc_type ()
      {
        ::brep::params::submit::fill (*this);
      }
    };

    void submit::
    fill (::brep::cli::options& os)
    {
      // archive
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("archive", a, false, dv);
        os.push_back (o);
      }

      // sha256sum
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("sha256sum", a, false, dv);
        os.push_back (o);
      }

      // simulate
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("simulate", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& submit::
    description ()
    {
      static _cli_submit_desc_type _cli_submit_desc_;
      return _cli_submit_desc_;
    }

    typedef
    std::map<std::string, void (*) (submit&, ::brep::cli::scanner&)>
    _cli_submit_map;

    static _cli_submit_map _cli_submit_map_;

    struct _cli_submit_map_init
    {
      _cli_submit_map_init ()
      {
        _cli_submit_map_["archive"] =
        &::brep::cli::thunk< submit, string, &submit::archive_,
          &submit::archive_specified_ >;
        _cli_submit_map_["sha256sum"] =
        &::brep::cli::thunk< submit, string, &submit::sha256sum_,
          &submit::sha256sum_specified_ >;
        _cli_submit_map_["simulate"] =
        &::brep::cli::thunk< submit, string, &submit::simulate_,
          &submit::simulate_specified_ >;
      }
    };

    static _cli_submit_map_init _cli_submit_map_init_;

    bool submit::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_submit_map::const_iterator i (_cli_submit_map_.find (o));

      if (i != _cli_submit_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool submit::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // ci
    //

    ci::
    ci ()
    : repository_ (),
      repository_specified_ (false),
      package_ (),
      package_specified_ (false),
      overrides_ (),
      overrides_specified_ (false),
      interactive_ (),
      interactive_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
    }

    ci::
    ci (int& argc,
        char** argv,
        bool erase,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      package_ (),
      package_specified_ (false),
      overrides_ (),
      overrides_specified_ (false),
      interactive_ (),
      interactive_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci::
    ci (int start,
        int& argc,
        char** argv,
        bool erase,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      package_ (),
      package_specified_ (false),
      overrides_ (),
      overrides_specified_ (false),
      interactive_ (),
      interactive_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci::
    ci (int& argc,
        char** argv,
        int& end,
        bool erase,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      package_ (),
      package_specified_ (false),
      overrides_ (),
      overrides_specified_ (false),
      interactive_ (),
      interactive_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci::
    ci (int start,
        int& argc,
        char** argv,
        int& end,
        bool erase,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      package_ (),
      package_specified_ (false),
      overrides_ (),
      overrides_specified_ (false),
      interactive_ (),
      interactive_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci::
    ci (::brep::cli::scanner& s,
        ::brep::cli::unknown_mode opt,
        ::brep::cli::unknown_mode arg)
    : repository_ (),
      repository_specified_ (false),
      package_ (),
      package_specified_ (false),
      overrides_ (),
      overrides_specified_ (false),
      interactive_ (),
      interactive_specified_ (false),
      simulate_ (),
      simulate_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para ci::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "repository|_ <arg>" << std::endl;

      os << "package <arg>" << std::endl;

      os << "overrides <arg>" << std::endl;

      os << "interactive <arg>" << std::endl;

      os << "simulate <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_ci_desc_type: ::brep::cli::options
    {
      _cli_ci_desc_type ()
      {
        ::brep::params::ci::fill (*this);
      }
    };

    void ci::
    fill (::brep::cli::options& os)
    {
      // repository
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("_");
        std::string dv;
        ::brep::cli::option o ("repository", a, false, dv);
        os.push_back (o);
      }

      // package
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("package", a, false, dv);
        os.push_back (o);
      }

      // overrides
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("overrides", a, false, dv);
        os.push_back (o);
      }

      // interactive
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("interactive", a, false, dv);
        os.push_back (o);
      }

      // simulate
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("simulate", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& ci::
    description ()
    {
      static _cli_ci_desc_type _cli_ci_desc_;
      return _cli_ci_desc_;
    }

    typedef
    std::map<std::string, void (*) (ci&, ::brep::cli::scanner&)>
    _cli_ci_map;

    static _cli_ci_map _cli_ci_map_;

    struct _cli_ci_map_init
    {
      _cli_ci_map_init ()
      {
        _cli_ci_map_["repository"] =
        &::brep::cli::thunk< ci, bpkg::repository_location, &ci::repository_,
          &ci::repository_specified_ >;
        _cli_ci_map_["_"] =
        &::brep::cli::thunk< ci, bpkg::repository_location, &ci::repository_,
          &ci::repository_specified_ >;
        _cli_ci_map_["package"] =
        &::brep::cli::thunk< ci, strings, &ci::package_,
          &ci::package_specified_ >;
        _cli_ci_map_["overrides"] =
        &::brep::cli::thunk< ci, string, &ci::overrides_,
          &ci::overrides_specified_ >;
        _cli_ci_map_["interactive"] =
        &::brep::cli::thunk< ci, string, &ci::interactive_,
          &ci::interactive_specified_ >;
        _cli_ci_map_["simulate"] =
        &::brep::cli::thunk< ci, string, &ci::simulate_,
          &ci::simulate_specified_ >;
      }
    };

    static _cli_ci_map_init _cli_ci_map_init_;

    bool ci::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_ci_map::const_iterator i (_cli_ci_map_.find (o));

      if (i != _cli_ci_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool ci::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // ci_cancel
    //

    ci_cancel::
    ci_cancel ()
    : id_ (),
      id_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
    }

    ci_cancel::
    ci_cancel (int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : id_ (),
      id_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci_cancel::
    ci_cancel (int start,
               int& argc,
               char** argv,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : id_ (),
      id_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    ci_cancel::
    ci_cancel (int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : id_ (),
      id_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci_cancel::
    ci_cancel (int start,
               int& argc,
               char** argv,
               int& end,
               bool erase,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : id_ (),
      id_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    ci_cancel::
    ci_cancel (::brep::cli::scanner& s,
               ::brep::cli::unknown_mode opt,
               ::brep::cli::unknown_mode arg)
    : id_ (),
      id_specified_ (false),
      reason_ (),
      reason_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para ci_cancel::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "id|_ <arg>" << std::endl;

      os << "reason <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_ci_cancel_desc_type: ::brep::cli::options
    {
      _cli_ci_cancel_desc_type ()
      {
        ::brep::params::ci_cancel::fill (*this);
      }
    };

    void ci_cancel::
    fill (::brep::cli::options& os)
    {
      // id
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("_");
        std::string dv;
        ::brep::cli::option o ("id", a, false, dv);
        os.push_back (o);
      }

      // reason
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("reason", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& ci_cancel::
    description ()
    {
      static _cli_ci_cancel_desc_type _cli_ci_cancel_desc_;
      return _cli_ci_cancel_desc_;
    }

    typedef
    std::map<std::string, void (*) (ci_cancel&, ::brep::cli::scanner&)>
    _cli_ci_cancel_map;

    static _cli_ci_cancel_map _cli_ci_cancel_map_;

    struct _cli_ci_cancel_map_init
    {
      _cli_ci_cancel_map_init ()
      {
        _cli_ci_cancel_map_["id"] =
        &::brep::cli::thunk< ci_cancel, string, &ci_cancel::id_,
          &ci_cancel::id_specified_ >;
        _cli_ci_cancel_map_["_"] =
        &::brep::cli::thunk< ci_cancel, string, &ci_cancel::id_,
          &ci_cancel::id_specified_ >;
        _cli_ci_cancel_map_["reason"] =
        &::brep::cli::thunk< ci_cancel, string, &ci_cancel::reason_,
          &ci_cancel::reason_specified_ >;
      }
    };

    static _cli_ci_cancel_map_init _cli_ci_cancel_map_init_;

    bool ci_cancel::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_ci_cancel_map::const_iterator i (_cli_ci_cancel_map_.find (o));

      if (i != _cli_ci_cancel_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool ci_cancel::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }

    // upload
    //

    upload::
    upload ()
    : type_ (),
      type_specified_ (false),
      session_ (),
      session_specified_ (false),
      challenge_ (),
      challenge_specified_ (false),
      instance_ (),
      instance_specified_ (false),
      archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false)
    {
    }

    upload::
    upload (int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : type_ (),
      type_specified_ (false),
      session_ (),
      session_specified_ (false),
      challenge_ (),
      challenge_specified_ (false),
      instance_ (),
      instance_specified_ (false),
      archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    upload::
    upload (int start,
            int& argc,
            char** argv,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : type_ (),
      type_specified_ (false),
      session_ (),
      session_specified_ (false),
      challenge_ (),
      challenge_specified_ (false),
      instance_ (),
      instance_specified_ (false),
      archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    upload::
    upload (int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : type_ (),
      type_specified_ (false),
      session_ (),
      session_specified_ (false),
      challenge_ (),
      challenge_specified_ (false),
      instance_ (),
      instance_specified_ (false),
      archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false)
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    upload::
    upload (int start,
            int& argc,
            char** argv,
            int& end,
            bool erase,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : type_ (),
      type_specified_ (false),
      session_ (),
      session_specified_ (false),
      challenge_ (),
      challenge_specified_ (false),
      instance_ (),
      instance_specified_ (false),
      archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false)
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    upload::
    upload (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode opt,
            ::brep::cli::unknown_mode arg)
    : type_ (),
      type_specified_ (false),
      session_ (),
      session_specified_ (false),
      challenge_ (),
      challenge_specified_ (false),
      instance_ (),
      instance_specified_ (false),
      archive_ (),
      archive_specified_ (false),
      sha256sum_ (),
      sha256sum_specified_ (false)
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para upload::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p == ::brep::cli::usage_para::text)
        os << ::std::endl;

      os << "type|_ <arg>" << std::endl;

      os << "session <arg>" << std::endl;

      os << "challenge <arg>" << std::endl;

      os << "instance <arg>" << std::endl;

      os << "archive <arg>" << std::endl;

      os << "sha256sum <arg>" << std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    struct _cli_upload_desc_type: ::brep::cli::options
    {
      _cli_upload_desc_type ()
      {
        ::brep::params::upload::fill (*this);
      }
    };

    void upload::
    fill (::brep::cli::options& os)
    {
      // type
      //
      {
        ::brep::cli::option_names a;
        a.push_back ("_");
        std::string dv;
        ::brep::cli::option o ("type", a, false, dv);
        os.push_back (o);
      }

      // session
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("session", a, false, dv);
        os.push_back (o);
      }

      // challenge
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("challenge", a, false, dv);
        os.push_back (o);
      }

      // instance
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("instance", a, false, dv);
        os.push_back (o);
      }

      // archive
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("archive", a, false, dv);
        os.push_back (o);
      }

      // sha256sum
      //
      {
        ::brep::cli::option_names a;
        std::string dv;
        ::brep::cli::option o ("sha256sum", a, false, dv);
        os.push_back (o);
      }
    }

    const ::brep::cli::options& upload::
    description ()
    {
      static _cli_upload_desc_type _cli_upload_desc_;
      return _cli_upload_desc_;
    }

    typedef
    std::map<std::string, void (*) (upload&, ::brep::cli::scanner&)>
    _cli_upload_map;

    static _cli_upload_map _cli_upload_map_;

    struct _cli_upload_map_init
    {
      _cli_upload_map_init ()
      {
        _cli_upload_map_["type"] =
        &::brep::cli::thunk< upload, string, &upload::type_,
          &upload::type_specified_ >;
        _cli_upload_map_["_"] =
        &::brep::cli::thunk< upload, string, &upload::type_,
          &upload::type_specified_ >;
        _cli_upload_map_["session"] =
        &::brep::cli::thunk< upload, string, &upload::session_,
          &upload::session_specified_ >;
        _cli_upload_map_["challenge"] =
        &::brep::cli::thunk< upload, string, &upload::challenge_,
          &upload::challenge_specified_ >;
        _cli_upload_map_["instance"] =
        &::brep::cli::thunk< upload, string, &upload::instance_,
          &upload::instance_specified_ >;
        _cli_upload_map_["archive"] =
        &::brep::cli::thunk< upload, string, &upload::archive_,
          &upload::archive_specified_ >;
        _cli_upload_map_["sha256sum"] =
        &::brep::cli::thunk< upload, string, &upload::sha256sum_,
          &upload::sha256sum_specified_ >;
      }
    };

    static _cli_upload_map_init _cli_upload_map_init_;

    bool upload::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_upload_map::const_iterator i (_cli_upload_map_.find (o));

      if (i != _cli_upload_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool upload::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }
  }
}

// Begin epilogue.
//
//
// End epilogue.

