// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#include <odb/pre.hxx>

#include <libbrep/build-package-odb.hxx>

#include <cassert>
#include <cstring>  // std::memcpy


#include <odb/pgsql/traits.hxx>
#include <odb/pgsql/database.hxx>
#include <odb/pgsql/transaction.hxx>
#include <odb/pgsql/connection.hxx>
#include <odb/pgsql/statement.hxx>
#include <odb/pgsql/statement-cache.hxx>
#include <odb/pgsql/simple-object-statements.hxx>
#include <odb/pgsql/view-statements.hxx>
#include <odb/pgsql/section-statements.hxx>
#include <odb/pgsql/container-statements.hxx>
#include <odb/pgsql/exceptions.hxx>
#include <odb/pgsql/prepared-query.hxx>
#include <odb/pgsql/simple-object-result.hxx>
#include <odb/pgsql/view-result.hxx>

namespace odb
{
  // build_tenant
  //

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  persist_statement_name[] = "persist_brep_build_tenant";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  find_statement_name[] = "find_brep_build_tenant";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  update_statement_name[] = "update_brep_build_tenant";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  erase_statement_name[] = "erase_brep_build_tenant";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  query_statement_name[] = "query_brep_build_tenant";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_build_tenant";

  const unsigned int access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  update_statement_types[] =
  {
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  struct access::object_traits_impl< ::brep::build_tenant, id_pgsql >::extra_statement_cache_type
  {
    extra_statement_cache_type (
      pgsql::connection&,
      image_type&,
      id_image_type&,
      pgsql::binding&,
      pgsql::binding&,
      pgsql::native_binding&,
      const unsigned int*)
    {
    }
  };

  access::object_traits_impl< ::brep::build_tenant, id_pgsql >::id_type
  access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        id,
        i.id_value,
        i.id_size,
        i.id_null);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (t[0UL])
    {
      i.id_value.capacity (i.id_size);
      grew = true;
    }

    // private_
    //
    t[1UL] = 0;

    // interactive
    //
    if (t[2UL])
    {
      i.interactive_value.capacity (i.interactive_size);
      grew = true;
    }

    // creation_timestamp
    //
    t[3UL] = 0;

    // archived
    //
    t[4UL] = 0;

    // service
    //
    if (composite_value_traits< ::brep::tenant_service, id_pgsql >::grow (
          i.service_value, t + 5UL))
      grew = true;

    // unloaded_timestamp
    //
    t[9UL] = 0;

    // unloaded_notify_interval
    //
    t[10UL] = 0;

    // queued_timestamp
    //
    t[11UL] = 0;

    // toolchain
    //
    if (composite_value_traits< ::brep::build_toolchain, id_pgsql >::grow (
          i.toolchain_value, t + 12UL))
      grew = true;

    return grew;
  }

  void access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      b[n].type = pgsql::bind::text;
      b[n].buffer = i.id_value.data_ptr ();
      b[n].capacity = i.id_value.capacity ();
      b[n].size = &i.id_size;
      b[n].is_null = &i.id_null;
      n++;
    }

    // private_
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.private_value;
    b[n].is_null = &i.private_null;
    n++;

    // interactive
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.interactive_value.data_ptr ();
    b[n].capacity = i.interactive_value.capacity ();
    b[n].size = &i.interactive_size;
    b[n].is_null = &i.interactive_null;
    n++;

    // creation_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.creation_timestamp_value;
    b[n].is_null = &i.creation_timestamp_null;
    n++;

    // archived
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.archived_value;
    b[n].is_null = &i.archived_null;
    n++;

    // service
    //
    composite_value_traits< ::brep::tenant_service, id_pgsql >::bind (
      b + n, i.service_value, sk);
    n += 4UL;

    // unloaded_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.unloaded_timestamp_value;
    b[n].is_null = &i.unloaded_timestamp_null;
    n++;

    // unloaded_notify_interval
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.unloaded_notify_interval_value;
    b[n].is_null = &i.unloaded_notify_interval_null;
    n++;

    // queued_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.queued_timestamp_value;
    b[n].is_null = &i.queued_timestamp_null;
    n++;

    // toolchain
    //
    composite_value_traits< ::brep::build_toolchain, id_pgsql >::bind (
      b + n, i.toolchain_value, sk);
    n += 7UL;
  }

  void access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.id_value.data_ptr ();
    b[n].capacity = i.id_value.capacity ();
    b[n].size = &i.id_size;
    b[n].is_null = &i.id_null;
  }

  bool access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::std::string const& v =
        o.id;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.id_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.id_value,
        size,
        is_null,
        v);
      i.id_null = is_null;
      i.id_size = size;
      grew = grew || (cap != i.id_value.capacity ());
    }

    // private_
    //
    {
      bool const& v =
        o.private_;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.private_value, is_null, v);
      i.private_null = is_null;
    }

    // interactive
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.interactive;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.interactive_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.interactive_value,
        size,
        is_null,
        v);
      i.interactive_null = is_null;
      i.interactive_size = size;
      grew = grew || (cap != i.interactive_value.capacity ());
    }

    // creation_timestamp
    //
    {
      ::butl::timestamp const& v =
        o.creation_timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.creation_timestamp_value, is_null, vt);
      i.creation_timestamp_null = is_null;
    }

    // archived
    //
    {
      bool const& v =
        o.archived;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.archived_value, is_null, v);
      i.archived_null = is_null;
    }

    // service
    //
    {
      ::butl::optional< ::brep::tenant_service > const& v =
        o.service;

      if (wrapper_traits< ::butl::optional< ::brep::tenant_service > >::get_null (v))
        composite_value_traits< ::brep::tenant_service, id_pgsql >::set_null (
          i.service_value, sk);
      else
      {
        const::brep::tenant_service& vw = 
          wrapper_traits< ::butl::optional< ::brep::tenant_service > >::get_ref (v);

        if (composite_value_traits< ::brep::tenant_service, id_pgsql >::init (
              i.service_value,
              vw,
              sk))
          grew = true;
      }
    }

    // unloaded_timestamp
    //
    {
      ::butl::optional< ::std::chrono::time_point< ::std::chrono::system_clock, ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > > const& v =
        o.unloaded_timestamp;

      // From common.hxx:133:14
      ::brep::optional_uint64 const& vt =
        (v) ? std::chrono::duration_cast < std::chrono::nanoseconds > ((v)->time_since_epoch ()).count () : brep::optional_uint64 ();

      bool is_null (true);
      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_image (
        i.unloaded_timestamp_value, is_null, vt);
      i.unloaded_timestamp_null = is_null;
    }

    // unloaded_notify_interval
    //
    {
      ::butl::optional< ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > const& v =
        o.unloaded_notify_interval;

      // From common.hxx:150:14
      ::brep::optional_uint64 const& vt =
        (v) ? std::chrono::duration_cast < std::chrono::nanoseconds > ( * (v)).count () : brep::optional_uint64 ();

      bool is_null (true);
      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_image (
        i.unloaded_notify_interval_value, is_null, vt);
      i.unloaded_notify_interval_null = is_null;
    }

    // queued_timestamp
    //
    {
      ::butl::optional< ::std::chrono::time_point< ::std::chrono::system_clock, ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > > const& v =
        o.queued_timestamp;

      // From common.hxx:133:14
      ::brep::optional_uint64 const& vt =
        (v) ? std::chrono::duration_cast < std::chrono::nanoseconds > ((v)->time_since_epoch ()).count () : brep::optional_uint64 ();

      bool is_null (true);
      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_image (
        i.queued_timestamp_value, is_null, vt);
      i.queued_timestamp_null = is_null;
    }

    // toolchain
    //
    {
      ::butl::optional< ::brep::build_toolchain > const& v =
        o.toolchain;

      if (wrapper_traits< ::butl::optional< ::brep::build_toolchain > >::get_null (v))
        composite_value_traits< ::brep::build_toolchain, id_pgsql >::set_null (
          i.toolchain_value, sk);
      else
      {
        const::brep::build_toolchain& vw = 
          wrapper_traits< ::butl::optional< ::brep::build_toolchain > >::get_ref (v);

        if (composite_value_traits< ::brep::build_toolchain, id_pgsql >::init (
              i.toolchain_value,
              vw,
              sk))
          grew = true;
      }
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::std::string& v =
        o.id;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.id_value,
        i.id_size,
        i.id_null);
    }

    // private_
    //
    {
      bool& v =
        o.private_;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.private_value,
        i.private_null);
    }

    // interactive
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.interactive;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.interactive_value,
        i.interactive_size,
        i.interactive_null);
    }

    // creation_timestamp
    //
    {
      ::butl::timestamp& v =
        o.creation_timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.creation_timestamp_value,
        i.creation_timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // archived
    //
    {
      bool& v =
        o.archived;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.archived_value,
        i.archived_null);
    }

    // service
    //
    {
      ::butl::optional< ::brep::tenant_service >& v =
        o.service;

      if (composite_value_traits< ::brep::tenant_service, id_pgsql >::get_null (
            i.service_value))
        wrapper_traits< ::butl::optional< ::brep::tenant_service > >::set_null (v);
      else
      {
        ::brep::tenant_service& vw =
          wrapper_traits< ::butl::optional< ::brep::tenant_service > >::set_ref (v);

        composite_value_traits< ::brep::tenant_service, id_pgsql >::init (
          vw,
          i.service_value,
          db);
      }
    }

    // unloaded_timestamp
    //
    {
      ::butl::optional< ::std::chrono::time_point< ::std::chrono::system_clock, ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > >& v =
        o.unloaded_timestamp;

      ::brep::optional_uint64 vt;

      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_value (
        vt,
        i.unloaded_timestamp_value,
        i.unloaded_timestamp_null);

      // From common.hxx:133:14
      v = (vt) ? brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds ( * (vt)))) : brep::optional_timestamp ();
    }

    // unloaded_notify_interval
    //
    {
      ::butl::optional< ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > >& v =
        o.unloaded_notify_interval;

      ::brep::optional_uint64 vt;

      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_value (
        vt,
        i.unloaded_notify_interval_value,
        i.unloaded_notify_interval_null);

      // From common.hxx:150:14
      v = (vt) ? brep::duration (std::chrono::nanoseconds ( * (vt))) : brep::optional_duration ();
    }

    // queued_timestamp
    //
    {
      ::butl::optional< ::std::chrono::time_point< ::std::chrono::system_clock, ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > >& v =
        o.queued_timestamp;

      ::brep::optional_uint64 vt;

      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_value (
        vt,
        i.queued_timestamp_value,
        i.queued_timestamp_null);

      // From common.hxx:133:14
      v = (vt) ? brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds ( * (vt)))) : brep::optional_timestamp ();
    }

    // toolchain
    //
    {
      ::butl::optional< ::brep::build_toolchain >& v =
        o.toolchain;

      if (composite_value_traits< ::brep::build_toolchain, id_pgsql >::get_null (
            i.toolchain_value))
        wrapper_traits< ::butl::optional< ::brep::build_toolchain > >::set_null (v);
      else
      {
        ::brep::build_toolchain& vw =
          wrapper_traits< ::butl::optional< ::brep::build_toolchain > >::set_ref (v);

        composite_value_traits< ::brep::build_toolchain, id_pgsql >::init (
          vw,
          i.toolchain_value,
          db);
      }
    }
  }

  void access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    {
      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.id_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.id_value,
        size,
        is_null,
        id);
      i.id_null = is_null;
      i.id_size = size;
      grew = grew || (cap != i.id_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::persist_statement[] =
  "INSERT INTO \"build_tenant\" "
  "(\"id\", "
  "\"private\", "
  "\"interactive\", "
  "\"creation_timestamp\", "
  "\"archived\", "
  "\"service_id\", "
  "\"service_type\", "
  "\"service_ref_count\", "
  "\"service_data\", "
  "\"unloaded_timestamp\", "
  "\"unloaded_notify_interval\", "
  "\"queued_timestamp\", "
  "\"toolchain_name\", "
  "\"toolchain_version_epoch\", "
  "\"toolchain_version_canonical_upstream\", "
  "\"toolchain_version_canonical_release\", "
  "\"toolchain_version_revision\", "
  "\"toolchain_version_upstream\", "
  "\"toolchain_version_release\") "
  "VALUES "
  "($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19)";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::find_statement[] =
  "SELECT "
  "\"build_tenant\".\"id\", "
  "\"build_tenant\".\"private\", "
  "\"build_tenant\".\"interactive\", "
  "\"build_tenant\".\"creation_timestamp\", "
  "\"build_tenant\".\"archived\", "
  "\"build_tenant\".\"service_id\", "
  "\"build_tenant\".\"service_type\", "
  "\"build_tenant\".\"service_ref_count\", "
  "\"build_tenant\".\"service_data\", "
  "\"build_tenant\".\"unloaded_timestamp\", "
  "\"build_tenant\".\"unloaded_notify_interval\", "
  "\"build_tenant\".\"queued_timestamp\", "
  "\"build_tenant\".\"toolchain_name\", "
  "\"build_tenant\".\"toolchain_version_epoch\", "
  "\"build_tenant\".\"toolchain_version_canonical_upstream\", "
  "\"build_tenant\".\"toolchain_version_canonical_release\", "
  "\"build_tenant\".\"toolchain_version_revision\", "
  "\"build_tenant\".\"toolchain_version_upstream\", "
  "\"build_tenant\".\"toolchain_version_release\" "
  "FROM \"build_tenant\" "
  "WHERE \"build_tenant\".\"id\"=$1";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::update_statement[] =
  "UPDATE \"build_tenant\" "
  "SET "
  "\"private\"=$1, "
  "\"interactive\"=$2, "
  "\"creation_timestamp\"=$3, "
  "\"archived\"=$4, "
  "\"service_id\"=$5, "
  "\"service_type\"=$6, "
  "\"service_ref_count\"=$7, "
  "\"service_data\"=$8, "
  "\"unloaded_timestamp\"=$9, "
  "\"unloaded_notify_interval\"=$10, "
  "\"queued_timestamp\"=$11, "
  "\"toolchain_name\"=$12, "
  "\"toolchain_version_epoch\"=$13, "
  "\"toolchain_version_canonical_upstream\"=$14, "
  "\"toolchain_version_canonical_release\"=$15, "
  "\"toolchain_version_revision\"=$16, "
  "\"toolchain_version_upstream\"=$17, "
  "\"toolchain_version_release\"=$18 "
  "WHERE \"id\"=$19";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::erase_statement[] =
  "DELETE FROM \"build_tenant\" "
  "WHERE \"id\"=$1";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::query_statement[] =
  "SELECT "
  "\"build_tenant\".\"id\", "
  "\"build_tenant\".\"private\", "
  "\"build_tenant\".\"interactive\", "
  "\"build_tenant\".\"creation_timestamp\", "
  "\"build_tenant\".\"archived\", "
  "\"build_tenant\".\"service_id\", "
  "\"build_tenant\".\"service_type\", "
  "\"build_tenant\".\"service_ref_count\", "
  "\"build_tenant\".\"service_data\", "
  "\"build_tenant\".\"unloaded_timestamp\", "
  "\"build_tenant\".\"unloaded_notify_interval\", "
  "\"build_tenant\".\"queued_timestamp\", "
  "\"build_tenant\".\"toolchain_name\", "
  "\"build_tenant\".\"toolchain_version_epoch\", "
  "\"build_tenant\".\"toolchain_version_canonical_upstream\", "
  "\"build_tenant\".\"toolchain_version_canonical_release\", "
  "\"build_tenant\".\"toolchain_version_revision\", "
  "\"build_tenant\".\"toolchain_version_upstream\", "
  "\"build_tenant\".\"toolchain_version_release\" "
  "FROM \"build_tenant\"";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"build_tenant\"";

  const char access::object_traits_impl< ::brep::build_tenant, id_pgsql >::table_name[] =
  "\"build_tenant\"";

  void access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace pgsql;
    using pgsql::update_statement;

    callback (db, obj, callback_event::pre_update);

    pgsql::transaction& tr (pgsql::transaction::current ());
    pgsql::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::build_tenant, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  result< access::object_traits_impl< ::brep::build_tenant, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        false,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::build_tenant, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // build_repository
  //

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  persist_statement_name[] = "persist_brep_build_repository";

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  find_statement_name[] = "find_brep_build_repository";

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  erase_statement_name[] = "erase_brep_build_repository";

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  query_statement_name[] = "query_brep_build_repository";

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_build_repository";

  const unsigned int access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid
  };

  struct access::object_traits_impl< ::brep::build_repository, id_pgsql >::extra_statement_cache_type
  {
    extra_statement_cache_type (
      pgsql::connection&,
      image_type&,
      id_image_type&,
      pgsql::binding&,
      pgsql::binding&,
      pgsql::native_binding&,
      const unsigned int*)
    {
    }
  };

  access::object_traits_impl< ::brep::build_repository, id_pgsql >::id_type
  access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      composite_value_traits< ::brep::repository_id, id_pgsql >::init (
        id,
        i.id_value,
        db);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::repository_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // location
    //
    if (composite_value_traits< ::brep::_repository_location, id_pgsql >::grow (
          i.location_value, t + 2UL))
      grew = true;

    // certificate_fingerprint
    //
    if (t[4UL])
    {
      i.certificate_fingerprint_value.capacity (i.certificate_fingerprint_size);
      grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    assert (sk != statement_update);

    std::size_t n (0);

    // id
    //
    composite_value_traits< ::brep::repository_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
    n += 2UL;

    // location
    //
    composite_value_traits< ::brep::_repository_location, id_pgsql >::bind (
      b + n, i.location_value, sk);
    n += 2UL;

    // certificate_fingerprint
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.certificate_fingerprint_value.data_ptr ();
    b[n].capacity = i.certificate_fingerprint_value.capacity ();
    b[n].size = &i.certificate_fingerprint_size;
    b[n].is_null = &i.certificate_fingerprint_null;
    n++;
  }

  void access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    pgsql::statement_kind sk (pgsql::statement_select);
    composite_value_traits< ::brep::repository_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
  }

  bool access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    assert (sk != statement_update);

    bool grew (false);

    // id
    //
    {
      ::brep::repository_id const& v =
        o.id;

      if (composite_value_traits< ::brep::repository_id, id_pgsql >::init (
            i.id_value,
            v,
            sk))
        grew = true;
    }

    // location
    //
    {
      ::bpkg::repository_location const& v =
        o.location;

      // From common.hxx:323:14
      ::brep::_repository_location const& vt =
        brep::_repository_location 
      {
         (v).url (), (v).empty () ? brep::repository_type::pkg : (v).type () 
      };


      if (composite_value_traits< ::brep::_repository_location, id_pgsql >::init (
            i.location_value,
            vt,
            sk))
        grew = true;
    }

    // certificate_fingerprint
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.certificate_fingerprint;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.certificate_fingerprint_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.certificate_fingerprint_value,
        size,
        is_null,
        v);
      i.certificate_fingerprint_null = is_null;
      i.certificate_fingerprint_size = size;
      grew = grew || (cap != i.certificate_fingerprint_value.capacity ());
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::repository_id& v =
        o.id;

      composite_value_traits< ::brep::repository_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // location
    //
    {
      // From build-package.hxx:87:7
      ::bpkg::repository_location v;

      ::brep::_repository_location vt;

      composite_value_traits< ::brep::_repository_location, id_pgsql >::init (
        vt,
        i.location_value,
        db);

      // From common.hxx:323:14
      v = brep::repository_location (std::move ((vt).url), (vt).type);
      // From build-package.hxx:87:7
      o.location = std::move (v);
      assert (o.canonical_name == o.location.canonical_name ());
    }

    // certificate_fingerprint
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.certificate_fingerprint;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.certificate_fingerprint_value,
        i.certificate_fingerprint_size,
        i.certificate_fingerprint_null);
    }
  }

  void access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    pgsql::statement_kind sk (pgsql::statement_select);
    {
      if (composite_value_traits< ::brep::repository_id, id_pgsql >::init (
            i.id_value,
            id,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::persist_statement[] =
  "INSERT INTO \"build_repository\" "
  "(\"tenant\", "
  "\"canonical_name\", "
  "\"location_url\", "
  "\"location_type\", "
  "\"certificate_fingerprint\") "
  "VALUES "
  "($1, $2, $3, $4, $5)";

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::find_statement[] =
  "SELECT "
  "\"build_repository\".\"tenant\", "
  "\"build_repository\".\"canonical_name\", "
  "\"build_repository\".\"location_url\", "
  "\"build_repository\".\"location_type\", "
  "\"build_repository\".\"certificate_fingerprint\" "
  "FROM \"build_repository\" "
  "WHERE \"build_repository\".\"tenant\"=$1 AND \"build_repository\".\"canonical_name\"=$2";

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::erase_statement[] =
  "DELETE FROM \"build_repository\" "
  "WHERE \"tenant\"=$1 AND \"canonical_name\"=$2";

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::query_statement[] =
  "SELECT "
  "\"build_repository\".\"tenant\", "
  "\"build_repository\".\"canonical_name\", "
  "\"build_repository\".\"location_url\", "
  "\"build_repository\".\"location_type\", "
  "\"build_repository\".\"certificate_fingerprint\" "
  "FROM \"build_repository\"";

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"build_repository\"";

  const char access::object_traits_impl< ::brep::build_repository, id_pgsql >::table_name[] =
  "\"build_repository\"";

  void access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::build_repository, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  result< access::object_traits_impl< ::brep::build_repository, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        false,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::build_repository, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // build_public_key
  //

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  persist_statement_name[] = "persist_brep_build_public_key";

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  find_statement_name[] = "find_brep_build_public_key";

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  erase_statement_name[] = "erase_brep_build_public_key";

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  query_statement_name[] = "query_brep_build_public_key";

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_build_public_key";

  const unsigned int access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid
  };

  struct access::object_traits_impl< ::brep::build_public_key, id_pgsql >::extra_statement_cache_type
  {
    extra_statement_cache_type (
      pgsql::connection&,
      image_type&,
      id_image_type&,
      pgsql::binding&,
      pgsql::binding&,
      pgsql::native_binding&,
      const unsigned int*)
    {
    }
  };

  access::object_traits_impl< ::brep::build_public_key, id_pgsql >::id_type
  access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      composite_value_traits< ::brep::public_key_id, id_pgsql >::init (
        id,
        i.id_value,
        db);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::public_key_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // data
    //
    if (t[2UL])
    {
      i.data_value.capacity (i.data_size);
      grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    assert (sk != statement_update);

    std::size_t n (0);

    // id
    //
    composite_value_traits< ::brep::public_key_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
    n += 2UL;

    // data
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.data_value.data_ptr ();
    b[n].capacity = i.data_value.capacity ();
    b[n].size = &i.data_size;
    b[n].is_null = &i.data_null;
    n++;
  }

  void access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    pgsql::statement_kind sk (pgsql::statement_select);
    composite_value_traits< ::brep::public_key_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
  }

  bool access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    assert (sk != statement_update);

    bool grew (false);

    // id
    //
    {
      ::brep::public_key_id const& v =
        o.id;

      if (composite_value_traits< ::brep::public_key_id, id_pgsql >::init (
            i.id_value,
            v,
            sk))
        grew = true;
    }

    // data
    //
    {
      // From build-package.hxx:109:45
      ::std::string const& v =
        o;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.data_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.data_value,
        size,
        is_null,
        v);
      i.data_null = is_null;
      i.data_size = size;
      grew = grew || (cap != i.data_value.capacity ());
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::public_key_id& v =
        o.id;

      composite_value_traits< ::brep::public_key_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // data
    //
    {
      // From build-package.hxx:109:45
      ::std::string& v =
        o;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.data_value,
        i.data_size,
        i.data_null);
    }
  }

  void access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    pgsql::statement_kind sk (pgsql::statement_select);
    {
      if (composite_value_traits< ::brep::public_key_id, id_pgsql >::init (
            i.id_value,
            id,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::persist_statement[] =
  "INSERT INTO \"build_public_key\" "
  "(\"tenant\", "
  "\"fingerprint\", "
  "\"data\") "
  "VALUES "
  "($1, $2, $3)";

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::find_statement[] =
  "SELECT "
  "\"build_public_key\".\"tenant\", "
  "\"build_public_key\".\"fingerprint\", "
  "\"build_public_key\".\"data\" "
  "FROM \"build_public_key\" "
  "WHERE \"build_public_key\".\"tenant\"=$1 AND \"build_public_key\".\"fingerprint\"=$2";

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::erase_statement[] =
  "DELETE FROM \"build_public_key\" "
  "WHERE \"tenant\"=$1 AND \"fingerprint\"=$2";

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::query_statement[] =
  "SELECT "
  "\"build_public_key\".\"tenant\", "
  "\"build_public_key\".\"fingerprint\", "
  "\"build_public_key\".\"data\" "
  "FROM \"build_public_key\"";

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"build_public_key\"";

  const char access::object_traits_impl< ::brep::build_public_key, id_pgsql >::table_name[] =
  "\"build_public_key\"";

  void access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::build_public_key, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  result< access::object_traits_impl< ::brep::build_public_key, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        false,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::build_public_key, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // build_package_config
  //

  bool access::composite_value_traits< ::brep::build_package_config, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // arguments
    //
    if (t[1UL])
    {
      i.arguments_value.capacity (i.arguments_size);
      grew = true;
    }

    // comment
    //
    if (t[2UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    // email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.email_value, t + 3UL))
      grew = true;

    // warning_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.warning_email_value, t + 5UL))
      grew = true;

    // error_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.error_email_value, t + 7UL))
      grew = true;

    return grew;
  }

  void access::composite_value_traits< ::brep::build_package_config, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.name_value.data_ptr ();
    b[n].capacity = i.name_value.capacity ();
    b[n].size = &i.name_size;
    b[n].is_null = &i.name_null;
    n++;

    // arguments
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.arguments_value.data_ptr ();
    b[n].capacity = i.arguments_value.capacity ();
    b[n].size = &i.arguments_size;
    b[n].is_null = &i.arguments_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;

    // email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.email_value, sk);
    n += 2UL;

    // warning_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.warning_email_value, sk);
    n += 2UL;

    // error_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.error_email_value, sk);
    n += 2UL;
  }

  bool access::composite_value_traits< ::brep::build_package_config, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // name
    //
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.name_value,
        size,
        is_null,
        v);
      i.name_null = is_null;
      i.name_size = size;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // arguments
    //
    {
      ::std::string const& v =
        o.arguments;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.arguments_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.arguments_value,
        size,
        is_null,
        v);
      i.arguments_null = is_null;
      i.arguments_size = size;
      grew = grew || (cap != i.arguments_value.capacity ());
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    // email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // warning_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.warning_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.warning_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.warning_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // error_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.error_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.error_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.error_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_package_config, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // arguments
    //
    {
      ::std::string& v =
        o.arguments;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.arguments_value,
        i.arguments_size,
        i.arguments_null);
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }

    // email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.email_value,
          db);
      }
    }

    // warning_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.warning_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.warning_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.warning_email_value,
          db);
      }
    }

    // error_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.error_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.error_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.error_email_value,
          db);
      }
    }
  }

  // build_package_bot_key_key
  //

  bool access::composite_value_traits< ::brep::build_package_bot_key_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // inner
    //
    t[1UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::build_package_bot_key_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::build_package_bot_key_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::build_package_bot_key_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::build_package_bot_key_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // inner
    //
    {
      ::brep::build_package_bot_key_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::build_package_bot_key_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_package_bot_key_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::build_package_bot_key_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::build_package_bot_key_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // inner
    //
    {
      ::brep::build_package_bot_key_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::build_package_bot_key_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // build_dependency
  //

  bool access::composite_value_traits< ::brep::build_dependency, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // constraint
    //
    if (composite_value_traits< ::bpkg::version_constraint, id_pgsql >::grow (
          i.constraint_value, t + 1UL))
      grew = true;

    // package
    //
    if (composite_value_traits< ::brep::package_id, id_pgsql >::grow (
          i.package_value, t + 15UL))
      grew = true;

    return grew;
  }

  void access::composite_value_traits< ::brep::build_dependency, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.name_value.data_ptr ();
    b[n].capacity = i.name_value.capacity ();
    b[n].size = &i.name_size;
    b[n].is_null = &i.name_null;
    n++;

    // constraint
    //
    composite_value_traits< ::bpkg::version_constraint, id_pgsql >::bind (
      b + n, i.constraint_value, sk);
    n += 14UL;

    // package
    //
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.package_value, sk);
    n += 6UL;
  }

  bool access::composite_value_traits< ::brep::build_dependency, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // name
    //
    {
      ::bpkg::package_name const& v =
        o.name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.name_value.capacity ());
      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_image (
        i.name_value,
        size,
        is_null,
        v);
      i.name_null = is_null;
      i.name_size = size;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // constraint
    //
    {
      ::butl::optional< ::bpkg::version_constraint > const& v =
        o.constraint;

      if (wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::get_null (v))
        composite_value_traits< ::bpkg::version_constraint, id_pgsql >::set_null (
          i.constraint_value, sk);
      else
      {
        const::bpkg::version_constraint& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::get_ref (v);

        if (composite_value_traits< ::bpkg::version_constraint, id_pgsql >::init (
              i.constraint_value,
              vw,
              sk))
          grew = true;
      }
    }

    // package
    //
    {
      ::odb::lazy_shared_ptr< ::brep::build_package > const& v =
        o.package;

      typedef object_traits< ::brep::build_package > obj_traits;
      typedef odb::pointer_traits< ::odb::lazy_shared_ptr< ::brep::build_package > > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.package_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        composite_value_traits< obj_traits::id_type, id_pgsql >::set_null (i.package_value, sk);
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_dependency, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::bpkg::package_name& v =
        o.name;

      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // constraint
    //
    {
      ::butl::optional< ::bpkg::version_constraint >& v =
        o.constraint;

      if (composite_value_traits< ::bpkg::version_constraint, id_pgsql >::get_null (
            i.constraint_value))
        wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_null (v);
      else
      {
        ::bpkg::version_constraint& vw =
          wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_ref (v);

        composite_value_traits< ::bpkg::version_constraint, id_pgsql >::init (
          vw,
          i.constraint_value,
          db);
      }
    }

    // package
    //
    {
      ::odb::lazy_shared_ptr< ::brep::build_package >& v =
        o.package;

      typedef object_traits< ::brep::build_package > obj_traits;
      typedef odb::pointer_traits< ::odb::lazy_shared_ptr< ::brep::build_package > > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.package_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.package_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }
  }

  // build_test_dependency
  //

  bool access::composite_value_traits< ::brep::build_test_dependency, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // build_dependency base
    //
    if (composite_value_traits< ::brep::build_dependency, id_pgsql >::grow (
          i, t + 0UL))
      grew = true;

    // type
    //
    if (t[21UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    // buildtime
    //
    t[22UL] = 0;

    // enable
    //
    if (t[23UL])
    {
      i.enable_value.capacity (i.enable_size);
      grew = true;
    }

    // reflect
    //
    if (t[24UL])
    {
      i.reflect_value.capacity (i.reflect_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_test_dependency, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // build_dependency base
    //
    composite_value_traits< ::brep::build_dependency, id_pgsql >::bind (b + n, i, sk);
    n += 21UL;

    // type
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.type_value.data_ptr ();
    b[n].capacity = i.type_value.capacity ();
    b[n].size = &i.type_size;
    b[n].is_null = &i.type_null;
    n++;

    // buildtime
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.buildtime_value;
    b[n].is_null = &i.buildtime_null;
    n++;

    // enable
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.enable_value.data_ptr ();
    b[n].capacity = i.enable_value.capacity ();
    b[n].size = &i.enable_size;
    b[n].is_null = &i.enable_null;
    n++;

    // reflect
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.reflect_value.data_ptr ();
    b[n].capacity = i.reflect_value.capacity ();
    b[n].size = &i.reflect_size;
    b[n].is_null = &i.reflect_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::build_test_dependency, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // build_dependency base
    //
    if (composite_value_traits< ::brep::build_dependency, id_pgsql >::init (i, o, sk))
      grew = true;

    // type
    //
    {
      ::bpkg::test_dependency_type const& v =
        o.type;

      // From common.hxx:505:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.type_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.type_value,
        size,
        is_null,
        vt);
      i.type_null = is_null;
      i.type_size = size;
      grew = grew || (cap != i.type_value.capacity ());
    }

    // buildtime
    //
    {
      bool const& v =
        o.buildtime;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.buildtime_value, is_null, v);
      i.buildtime_null = is_null;
    }

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.enable;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.enable_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.enable_value,
        size,
        is_null,
        v);
      i.enable_null = is_null;
      i.enable_size = size;
      grew = grew || (cap != i.enable_value.capacity ());
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.reflect;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.reflect_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.reflect_value,
        size,
        is_null,
        v);
      i.reflect_null = is_null;
      i.reflect_size = size;
      grew = grew || (cap != i.reflect_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_test_dependency, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // build_dependency base
    //
    composite_value_traits< ::brep::build_dependency, id_pgsql >::init (o, i, db);

    // type
    //
    {
      ::bpkg::test_dependency_type& v =
        o.type;

      ::std::string vt;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        vt,
        i.type_value,
        i.type_size,
        i.type_null);

      // From common.hxx:505:14
      v = brep::to_test_dependency_type (vt);
    }

    // buildtime
    //
    {
      bool& v =
        o.buildtime;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.buildtime_value,
        i.buildtime_null);
    }

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.enable;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.enable_value,
        i.enable_size,
        i.enable_null);
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.reflect;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.reflect_value,
        i.reflect_size,
        i.reflect_null);
    }
  }

  // build_package
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::
  persist_statement_name[] = "persist_brep_build_package";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::
  find_statement_name[] = "find_brep_build_package";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::
  erase_statement_name[] = "erase_brep_build_package";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::
  query_statement_name[] = "query_brep_build_package";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_build_package";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::bool_oid
  };

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid
  };

  const char alias_traits<  ::brep::build_repository,
    id_pgsql,
    access::object_traits_impl< ::brep::build_package, id_pgsql >::internal_repository_tag>::
  table_name[] = "\"internal_repository\"";

  struct access::object_traits_impl< ::brep::build_package, id_pgsql >::extra_statement_cache_type
  {
    pgsql::container_statements_impl< requirements_traits > requirements;
    pgsql::container_statements_impl< requirement_alternatives_traits > requirement_alternatives;
    pgsql::container_statements_impl< requirement_alternative_requirements_traits > requirement_alternative_requirements;
    pgsql::container_statements_impl< tests_traits > tests;
    pgsql::container_statements_impl< builds_traits > builds;
    pgsql::container_statements_impl< constraints_traits > constraints;
    pgsql::container_statements_impl< auxiliaries_traits > auxiliaries;
    pgsql::container_statements_impl< bot_keys_traits > bot_keys;
    pgsql::container_statements_impl< configs_traits > configs;
    pgsql::container_statements_impl< config_builds_traits > config_builds;
    pgsql::container_statements_impl< config_constraints_traits > config_constraints;
    pgsql::container_statements_impl< config_auxiliaries_traits > config_auxiliaries;
    pgsql::container_statements_impl< config_bot_keys_traits > config_bot_keys;

    pgsql::section_statements< ::brep::build_package, requirements_tests_section_traits > requirements_tests_section;
    pgsql::section_statements< ::brep::build_package, constraints_section_traits > constraints_section;
    pgsql::section_statements< ::brep::build_package, auxiliaries_section_traits > auxiliaries_section;
    pgsql::section_statements< ::brep::build_package, bot_keys_section_traits > bot_keys_section;

    extra_statement_cache_type (
      pgsql::connection& c,
      image_type& im,
      id_image_type& idim,
      pgsql::binding& id,
      pgsql::binding& idv,
      pgsql::native_binding& idn,
      const unsigned int* idt)
    : requirements (c, id, idn, idt),
      requirement_alternatives (c, id, idn, idt),
      requirement_alternative_requirements (c, id, idn, idt),
      tests (c, id, idn, idt),
      builds (c, id, idn, idt),
      constraints (c, id, idn, idt),
      auxiliaries (c, id, idn, idt),
      bot_keys (c, id, idn, idt),
      configs (c, id, idn, idt),
      config_builds (c, id, idn, idt),
      config_constraints (c, id, idn, idt),
      config_auxiliaries (c, id, idn, idt),
      config_bot_keys (c, id, idn, idt),
      requirements_tests_section (c, im, idim, id, idv, idn, idt),
      constraints_section (c, im, idim, id, idv, idn, idt),
      auxiliaries_section (c, im, idim, id, idv, idn, idt),
      bot_keys_section (c, im, idim, id, idv, idn, idt)
    {
    }
  };

  // requirements
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  select_name[] = "select_brep_build_package_requirements";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  insert_name[] = "insert_brep_build_package_requirements";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  delete_name[] = "delete_brep_build_package_requirements";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_requirements\".\"index\", "
  "\"build_package_requirements\".\"buildtime\", "
  "\"build_package_requirements\".\"comment\" "
  "FROM \"build_package_requirements\" "
  "WHERE \"build_package_requirements\".\"tenant\"=$1 AND \"build_package_requirements\".\"name\"=$2::CITEXT AND \"build_package_requirements\".\"version_epoch\"=$3 AND \"build_package_requirements\".\"version_canonical_upstream\"=$4 AND \"build_package_requirements\".\"version_canonical_release\"=$5 AND \"build_package_requirements\".\"version_revision\"=$6 ORDER BY \"build_package_requirements\".\"index\"";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_requirements\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"buildtime\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_requirements\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // requirement_alternatives
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  select_name[] = "select_brep_build_package_requirement_alternatives";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  insert_name[] = "insert_brep_build_package_requirement_alternatives";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  delete_name[] = "delete_brep_build_package_requirement_alternatives";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_requirement_alternatives\".\"requirement_index\", "
  "\"build_package_requirement_alternatives\".\"index\", "
  "\"build_package_requirement_alternatives\".\"enable\", "
  "\"build_package_requirement_alternatives\".\"reflect\" "
  "FROM \"build_package_requirement_alternatives\" "
  "WHERE \"build_package_requirement_alternatives\".\"tenant\"=$1 AND \"build_package_requirement_alternatives\".\"name\"=$2::CITEXT AND \"build_package_requirement_alternatives\".\"version_epoch\"=$3 AND \"build_package_requirement_alternatives\".\"version_canonical_upstream\"=$4 AND \"build_package_requirement_alternatives\".\"version_canonical_release\"=$5 AND \"build_package_requirement_alternatives\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_requirement_alternatives\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"requirement_index\", "
  "\"index\", "
  "\"enable\", "
  "\"reflect\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_requirement_alternatives\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternatives_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // requirement_alternative_requirements
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  select_name[] = "select_brep_build_package_requirement_alternative_requirements";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  insert_name[] = "insert_brep_build_package_requirement_alternative_requirements";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  delete_name[] = "delete_brep_build_package_requirement_alternative_requirements";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_requirement_alternative_requirements\".\"requirement_index\", "
  "\"build_package_requirement_alternative_requirements\".\"alternative_index\", "
  "\"build_package_requirement_alternative_requirements\".\"index\", "
  "\"build_package_requirement_alternative_requirements\".\"id\" "
  "FROM \"build_package_requirement_alternative_requirements\" "
  "WHERE \"build_package_requirement_alternative_requirements\".\"tenant\"=$1 AND \"build_package_requirement_alternative_requirements\".\"name\"=$2::CITEXT AND \"build_package_requirement_alternative_requirements\".\"version_epoch\"=$3 AND \"build_package_requirement_alternative_requirements\".\"version_canonical_upstream\"=$4 AND \"build_package_requirement_alternative_requirements\".\"version_canonical_release\"=$5 AND \"build_package_requirement_alternative_requirements\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_requirement_alternative_requirements\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"requirement_index\", "
  "\"alternative_index\", "
  "\"index\", "
  "\"id\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_requirement_alternative_requirements\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 3UL;

    // value
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = d.value_value.data_ptr ();
    b[n].capacity = d.value_value.capacity ();
    b[n].size = &d.value_size;
    b[n].is_null = &d.value_null;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (t[3UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.value_value.capacity ());
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_image (
        i.value_value,
        size,
        is_null,
        v);
      i.value_null = is_null;
      i.value_size = size;
      grew = grew || (cap != i.value_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_value (
        v,
        i.value_value,
        i.value_size,
        i.value_null);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirement_alternative_requirements_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // tests
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  select_name[] = "select_brep_build_package_tests";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  insert_name[] = "insert_brep_build_package_tests";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  delete_name[] = "delete_brep_build_package_tests";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_tests\".\"index\", "
  "\"build_package_tests\".\"test_name\"::TEXT, "
  "\"build_package_tests\".\"test_min_version_epoch\", "
  "\"build_package_tests\".\"test_min_version_canonical_upstream\", "
  "\"build_package_tests\".\"test_min_version_canonical_release\", "
  "\"build_package_tests\".\"test_min_version_revision\", "
  "\"build_package_tests\".\"test_min_version_upstream\", "
  "\"build_package_tests\".\"test_min_version_release\", "
  "\"build_package_tests\".\"test_max_version_epoch\", "
  "\"build_package_tests\".\"test_max_version_canonical_upstream\", "
  "\"build_package_tests\".\"test_max_version_canonical_release\", "
  "\"build_package_tests\".\"test_max_version_revision\", "
  "\"build_package_tests\".\"test_max_version_upstream\", "
  "\"build_package_tests\".\"test_max_version_release\", "
  "\"build_package_tests\".\"test_min_open\", "
  "\"build_package_tests\".\"test_max_open\", "
  "\"build_package_tests\".\"test_package_tenant\", "
  "\"build_package_tests\".\"test_package_name\"::TEXT, "
  "\"build_package_tests\".\"test_package_version_epoch\", "
  "\"build_package_tests\".\"test_package_version_canonical_upstream\", "
  "\"build_package_tests\".\"test_package_version_canonical_release\", "
  "\"build_package_tests\".\"test_package_version_revision\", "
  "\"build_package_tests\".\"test_type\", "
  "\"build_package_tests\".\"test_buildtime\", "
  "\"build_package_tests\".\"test_enable\", "
  "\"build_package_tests\".\"test_reflect\" "
  "FROM \"build_package_tests\" "
  "WHERE \"build_package_tests\".\"tenant\"=$1 AND \"build_package_tests\".\"name\"=$2::CITEXT AND \"build_package_tests\".\"version_epoch\"=$3 AND \"build_package_tests\".\"version_canonical_upstream\"=$4 AND \"build_package_tests\".\"version_canonical_release\"=$5 AND \"build_package_tests\".\"version_revision\"=$6 ORDER BY \"build_package_tests\".\"index\"";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_tests\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"test_name\", "
  "\"test_min_version_epoch\", "
  "\"test_min_version_canonical_upstream\", "
  "\"test_min_version_canonical_release\", "
  "\"test_min_version_revision\", "
  "\"test_min_version_upstream\", "
  "\"test_min_version_release\", "
  "\"test_max_version_epoch\", "
  "\"test_max_version_canonical_upstream\", "
  "\"test_max_version_canonical_release\", "
  "\"test_max_version_revision\", "
  "\"test_max_version_upstream\", "
  "\"test_max_version_release\", "
  "\"test_min_open\", "
  "\"test_max_open\", "
  "\"test_package_tenant\", "
  "\"test_package_name\", "
  "\"test_package_version_epoch\", "
  "\"test_package_version_canonical_upstream\", "
  "\"test_package_version_canonical_release\", "
  "\"test_package_version_revision\", "
  "\"test_type\", "
  "\"test_buildtime\", "
  "\"test_enable\", "
  "\"test_reflect\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8::CITEXT, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21, $22, $23, $24::CITEXT, $25, $26, $27, $28, $29, $30, $31, $32)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_tests\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::tests_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // builds
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  select_name[] = "select_brep_build_package_builds";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  insert_name[] = "insert_brep_build_package_builds";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  delete_name[] = "delete_brep_build_package_builds";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_builds\".\"index\", "
  "\"build_package_builds\".\"expression\", "
  "\"build_package_builds\".\"comment\" "
  "FROM \"build_package_builds\" "
  "WHERE \"build_package_builds\".\"tenant\"=$1 AND \"build_package_builds\".\"name\"=$2::CITEXT AND \"build_package_builds\".\"version_epoch\"=$3 AND \"build_package_builds\".\"version_canonical_upstream\"=$4 AND \"build_package_builds\".\"version_canonical_release\"=$5 AND \"build_package_builds\".\"version_revision\"=$6 ORDER BY \"build_package_builds\".\"index\"";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_builds\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"expression\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_builds\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::builds_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // constraints
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  select_name[] = "select_brep_build_package_constraints";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  insert_name[] = "insert_brep_build_package_constraints";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  delete_name[] = "delete_brep_build_package_constraints";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_constraints\".\"index\", "
  "\"build_package_constraints\".\"exclusion\", "
  "\"build_package_constraints\".\"config\", "
  "\"build_package_constraints\".\"target\", "
  "\"build_package_constraints\".\"comment\" "
  "FROM \"build_package_constraints\" "
  "WHERE \"build_package_constraints\".\"tenant\"=$1 AND \"build_package_constraints\".\"name\"=$2::CITEXT AND \"build_package_constraints\".\"version_epoch\"=$3 AND \"build_package_constraints\".\"version_canonical_upstream\"=$4 AND \"build_package_constraints\".\"version_canonical_release\"=$5 AND \"build_package_constraints\".\"version_revision\"=$6 ORDER BY \"build_package_constraints\".\"index\"";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_constraints\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"exclusion\", "
  "\"config\", "
  "\"target\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_constraints\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // auxiliaries
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  select_name[] = "select_brep_build_package_auxiliaries";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  insert_name[] = "insert_brep_build_package_auxiliaries";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  delete_name[] = "delete_brep_build_package_auxiliaries";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_auxiliaries\".\"index\", "
  "\"build_package_auxiliaries\".\"environment_name\", "
  "\"build_package_auxiliaries\".\"config\", "
  "\"build_package_auxiliaries\".\"comment\" "
  "FROM \"build_package_auxiliaries\" "
  "WHERE \"build_package_auxiliaries\".\"tenant\"=$1 AND \"build_package_auxiliaries\".\"name\"=$2::CITEXT AND \"build_package_auxiliaries\".\"version_epoch\"=$3 AND \"build_package_auxiliaries\".\"version_canonical_upstream\"=$4 AND \"build_package_auxiliaries\".\"version_canonical_release\"=$5 AND \"build_package_auxiliaries\".\"version_revision\"=$6 ORDER BY \"build_package_auxiliaries\".\"index\"";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_auxiliaries\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"environment_name\", "
  "\"config\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_auxiliaries\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // bot_keys
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  select_name[] = "select_brep_build_package_bot_keys";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  insert_name[] = "insert_brep_build_package_bot_keys";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  delete_name[] = "delete_brep_build_package_bot_keys";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_bot_keys\".\"index\", "
  "\"build_package_bot_keys\".\"key_tenant\", "
  "\"build_package_bot_keys\".\"key_fingerprint\" "
  "FROM \"build_package_bot_keys\" "
  "WHERE \"build_package_bot_keys\".\"tenant\"=$1 AND \"build_package_bot_keys\".\"name\"=$2::CITEXT AND \"build_package_bot_keys\".\"version_epoch\"=$3 AND \"build_package_bot_keys\".\"version_canonical_upstream\"=$4 AND \"build_package_bot_keys\".\"version_canonical_release\"=$5 AND \"build_package_bot_keys\".\"version_revision\"=$6 ORDER BY \"build_package_bot_keys\".\"index\"";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_bot_keys\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"key_tenant\", "
  "\"key_fingerprint\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_bot_keys\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< ::brep::public_key_id, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< ::brep::public_key_id, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      typedef object_traits< ::brep::build_public_key > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.value_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        composite_value_traits< obj_traits::id_type, id_pgsql >::set_null (i.value_value, sk);
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      typedef object_traits< ::brep::build_public_key > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.value_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.value_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // configs
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  select_name[] = "select_brep_build_package_configs";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  insert_name[] = "insert_brep_build_package_configs";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  delete_name[] = "delete_brep_build_package_configs";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_configs\".\"index\", "
  "\"build_package_configs\".\"config_name\", "
  "\"build_package_configs\".\"config_arguments\", "
  "\"build_package_configs\".\"config_comment\", "
  "\"build_package_configs\".\"config_email\", "
  "\"build_package_configs\".\"config_email_comment\", "
  "\"build_package_configs\".\"config_warning_email\", "
  "\"build_package_configs\".\"config_warning_email_comment\", "
  "\"build_package_configs\".\"config_error_email\", "
  "\"build_package_configs\".\"config_error_email_comment\" "
  "FROM \"build_package_configs\" "
  "WHERE \"build_package_configs\".\"tenant\"=$1 AND \"build_package_configs\".\"name\"=$2::CITEXT AND \"build_package_configs\".\"version_epoch\"=$3 AND \"build_package_configs\".\"version_canonical_upstream\"=$4 AND \"build_package_configs\".\"version_canonical_release\"=$5 AND \"build_package_configs\".\"version_revision\"=$6 ORDER BY \"build_package_configs\".\"index\"";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_configs\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"config_name\", "
  "\"config_arguments\", "
  "\"config_comment\", "
  "\"config_email\", "
  "\"config_email_comment\", "
  "\"config_warning_email\", "
  "\"config_warning_email_comment\", "
  "\"config_error_email\", "
  "\"config_error_email_comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_configs\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::configs_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // config_builds
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  select_name[] = "select_brep_build_package_config_builds";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  insert_name[] = "insert_brep_build_package_config_builds";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  delete_name[] = "delete_brep_build_package_config_builds";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_config_builds\".\"config_index\", "
  "\"build_package_config_builds\".\"index\", "
  "\"build_package_config_builds\".\"expression\", "
  "\"build_package_config_builds\".\"comment\" "
  "FROM \"build_package_config_builds\" "
  "WHERE \"build_package_config_builds\".\"tenant\"=$1 AND \"build_package_config_builds\".\"name\"=$2::CITEXT AND \"build_package_config_builds\".\"version_epoch\"=$3 AND \"build_package_config_builds\".\"version_canonical_upstream\"=$4 AND \"build_package_config_builds\".\"version_canonical_release\"=$5 AND \"build_package_config_builds\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_config_builds\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"config_index\", "
  "\"index\", "
  "\"expression\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_config_builds\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_builds_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // config_constraints
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  select_name[] = "select_brep_build_package_config_constraints";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  insert_name[] = "insert_brep_build_package_config_constraints";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  delete_name[] = "delete_brep_build_package_config_constraints";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_config_constraints\".\"config_index\", "
  "\"build_package_config_constraints\".\"index\", "
  "\"build_package_config_constraints\".\"exclusion\", "
  "\"build_package_config_constraints\".\"config\", "
  "\"build_package_config_constraints\".\"target\", "
  "\"build_package_config_constraints\".\"comment\" "
  "FROM \"build_package_config_constraints\" "
  "WHERE \"build_package_config_constraints\".\"tenant\"=$1 AND \"build_package_config_constraints\".\"name\"=$2::CITEXT AND \"build_package_config_constraints\".\"version_epoch\"=$3 AND \"build_package_config_constraints\".\"version_canonical_upstream\"=$4 AND \"build_package_config_constraints\".\"version_canonical_release\"=$5 AND \"build_package_config_constraints\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_config_constraints\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"config_index\", "
  "\"index\", "
  "\"exclusion\", "
  "\"config\", "
  "\"target\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_config_constraints\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_constraints_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // config_auxiliaries
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  select_name[] = "select_brep_build_package_config_auxiliaries";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  insert_name[] = "insert_brep_build_package_config_auxiliaries";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  delete_name[] = "delete_brep_build_package_config_auxiliaries";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_config_auxiliaries\".\"config_index\", "
  "\"build_package_config_auxiliaries\".\"index\", "
  "\"build_package_config_auxiliaries\".\"environment_name\", "
  "\"build_package_config_auxiliaries\".\"config\", "
  "\"build_package_config_auxiliaries\".\"comment\" "
  "FROM \"build_package_config_auxiliaries\" "
  "WHERE \"build_package_config_auxiliaries\".\"tenant\"=$1 AND \"build_package_config_auxiliaries\".\"name\"=$2::CITEXT AND \"build_package_config_auxiliaries\".\"version_epoch\"=$3 AND \"build_package_config_auxiliaries\".\"version_canonical_upstream\"=$4 AND \"build_package_config_auxiliaries\".\"version_canonical_release\"=$5 AND \"build_package_config_auxiliaries\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_config_auxiliaries\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"config_index\", "
  "\"index\", "
  "\"environment_name\", "
  "\"config\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_config_auxiliaries\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_auxiliaries_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // config_bot_keys
  //

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  select_name[] = "select_brep_build_package_config_bot_keys";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  insert_name[] = "insert_brep_build_package_config_bot_keys";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  delete_name[] = "delete_brep_build_package_config_bot_keys";

  const unsigned int access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  select_statement[] =
  "SELECT "
  "\"build_package_config_bot_keys\".\"config_index\", "
  "\"build_package_config_bot_keys\".\"index\", "
  "\"build_package_config_bot_keys\".\"key_tenant\", "
  "\"build_package_config_bot_keys\".\"key_fingerprint\" "
  "FROM \"build_package_config_bot_keys\" "
  "WHERE \"build_package_config_bot_keys\".\"tenant\"=$1 AND \"build_package_config_bot_keys\".\"name\"=$2::CITEXT AND \"build_package_config_bot_keys\".\"version_epoch\"=$3 AND \"build_package_config_bot_keys\".\"version_canonical_upstream\"=$4 AND \"build_package_config_bot_keys\".\"version_canonical_release\"=$5 AND \"build_package_config_bot_keys\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  insert_statement[] =
  "INSERT INTO \"build_package_config_bot_keys\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"config_index\", "
  "\"index\", "
  "\"key_tenant\", "
  "\"key_fingerprint\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  delete_statement[] =
  "DELETE FROM \"build_package_config_bot_keys\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< ::brep::public_key_id, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< ::brep::public_key_id, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      typedef object_traits< ::brep::build_public_key > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.value_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        composite_value_traits< obj_traits::id_type, id_pgsql >::set_null (i.value_value, sk);
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      typedef object_traits< ::brep::build_public_key > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.value_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.value_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::config_bot_keys_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // requirements_tests_section
  //

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::requirements_tests_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // requirements
    //
    {
      ::brep::build_package::requirements_type& v =
        obj.requirements;

      requirements_traits::load (
        v,
        esc.requirements);
    }

    // requirement_alternatives
    //
    {
      ::brep::requirement_alternatives_map v;

      requirement_alternatives_traits::load (
        v,
        esc.requirement_alternatives);

      // From build-package.hxx:248:7
      odb::nested_set (obj.requirements, std::move (v));
    }

    // requirement_alternative_requirements
    //
    {
      ::brep::requirement_alternative_requirements_map v;

      requirement_alternative_requirements_traits::load (
        v,
        esc.requirement_alternative_requirements);

      // From build-package.hxx:258:7
      odb::nested2_set (obj.requirements, std::move (v));
    }

    // tests
    //
    {
      ::butl::small_vector< ::brep::build_test_dependency, 1 >& v =
        obj.tests;

      tests_traits::load (
        v,
        esc.tests);
    }
  }

  // constraints_section
  //

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::constraints_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // builds
    //
    {
      ::brep::build_class_exprs& v =
        obj.builds;

      builds_traits::load (
        v,
        esc.builds);
    }

    // constraints
    //
    {
      ::brep::build_constraints& v =
        obj.constraints;

      constraints_traits::load (
        v,
        esc.constraints);
    }

    // config_builds
    //
    {
      ::brep::build_class_exprs_map v;

      config_builds_traits::load (
        v,
        esc.config_builds);

      // From build-package.hxx:296:7
      odb::nested_set (obj.configs, & brep::build_package_config::builds, std::move (v));
    }

    // config_constraints
    //
    {
      ::brep::build_constraints_map v;

      config_constraints_traits::load (
        v,
        esc.config_constraints);

      // From build-package.hxx:307:7
      odb::nested_set (obj.configs, & brep::build_package_config::constraints, std::move (v));
    }
  }

  // auxiliaries_section
  //

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::auxiliaries_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // auxiliaries
    //
    {
      ::brep::build_auxiliaries& v =
        obj.auxiliaries;

      auxiliaries_traits::load (
        v,
        esc.auxiliaries);
    }

    // config_auxiliaries
    //
    {
      ::brep::build_auxiliaries_map v;

      config_auxiliaries_traits::load (
        v,
        esc.config_auxiliaries);

      // From build-package.hxx:318:7
      odb::nested_set (obj.configs, & brep::build_package_config::auxiliaries, std::move (v));
    }
  }

  // bot_keys_section
  //

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::bot_keys_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // bot_keys
    //
    {
      ::brep::build_package_bot_keys& v =
        obj.bot_keys;

      bot_keys_traits::load (
        v,
        esc.bot_keys);
    }

    // config_bot_keys
    //
    {
      ::brep::build_package_bot_keys_map v;

      config_bot_keys_traits::load (
        v,
        esc.config_bot_keys);

      // From build-package.hxx:329:7
      odb::nested_set (obj.configs, & brep::build_package_config::bot_keys, std::move (v));
    }
  }

  access::object_traits_impl< ::brep::build_package, id_pgsql >::id_type
  access::object_traits_impl< ::brep::build_package, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      composite_value_traits< ::brep::package_id, id_pgsql >::init (
        id,
        i.id_value,
        db);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::package_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // version
    //
    if (composite_value_traits< ::brep::upstream_version, id_pgsql >::grow (
          i.version_value, t + 6UL))
      grew = true;

    // project
    //
    if (t[8UL])
    {
      i.project_value.capacity (i.project_size);
      grew = true;
    }

    // build_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.build_email_value, t + 9UL))
      grew = true;

    // build_warning_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.build_warning_email_value, t + 11UL))
      grew = true;

    // build_error_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.build_error_email_value, t + 13UL))
      grew = true;

    // internal_repository
    //
    if (composite_value_traits< ::brep::repository_id, id_pgsql >::grow (
          i.internal_repository_value, t + 15UL))
      grew = true;

    // buildable
    //
    t[17UL] = 0;

    // custom_bot
    //
    t[18UL] = 0;

    return grew;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    assert (sk != statement_update);

    std::size_t n (0);

    // id
    //
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
    n += 6UL;

    // version
    //
    composite_value_traits< ::brep::upstream_version, id_pgsql >::bind (
      b + n, i.version_value, sk);
    n += 2UL;

    // project
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.project_value.data_ptr ();
    b[n].capacity = i.project_value.capacity ();
    b[n].size = &i.project_size;
    b[n].is_null = &i.project_null;
    n++;

    // build_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.build_email_value, sk);
    n += 2UL;

    // build_warning_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.build_warning_email_value, sk);
    n += 2UL;

    // build_error_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.build_error_email_value, sk);
    n += 2UL;

    // internal_repository
    //
    composite_value_traits< ::brep::repository_id, id_pgsql >::bind (
      b + n, i.internal_repository_value, sk);
    n += 2UL;

    // buildable
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.buildable_value;
    b[n].is_null = &i.buildable_null;
    n++;

    // custom_bot
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.custom_bot_value;
    b[n].is_null = &i.custom_bot_null;
    n++;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    pgsql::statement_kind sk (pgsql::statement_select);
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    assert (sk != statement_update);

    bool grew (false);

    // id
    //
    {
      ::brep::package_id const& v =
        o.id;

      if (composite_value_traits< ::brep::package_id, id_pgsql >::init (
            i.id_value,
            v,
            sk))
        grew = true;
    }

    // version
    //
    {
      ::brep::upstream_version const& v =
        o.version;

      if (composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
            i.version_value,
            v,
            sk))
        grew = true;
    }

    // project
    //
    {
      ::bpkg::package_name const& v =
        o.project;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.project_value.capacity ());
      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_image (
        i.project_value,
        size,
        is_null,
        v);
      i.project_null = is_null;
      i.project_size = size;
      grew = grew || (cap != i.project_value.capacity ());
    }

    // build_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.build_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.build_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.build_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // build_warning_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.build_warning_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.build_warning_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.build_warning_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // build_error_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.build_error_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.build_error_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.build_error_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // internal_repository
    //
    {
      ::odb::lazy_shared_ptr< ::brep::build_repository > const& v =
        o.internal_repository;

      typedef object_traits< ::brep::build_repository > obj_traits;
      typedef odb::pointer_traits< ::odb::lazy_shared_ptr< ::brep::build_repository > > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.internal_repository_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        composite_value_traits< obj_traits::id_type, id_pgsql >::set_null (i.internal_repository_value, sk);
    }

    // buildable
    //
    {
      bool const& v =
        o.buildable;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.buildable_value, is_null, v);
      i.buildable_null = is_null;
    }

    // custom_bot
    //
    {
      ::butl::optional< bool > const& v =
        o.custom_bot;

      bool is_null (true);
      pgsql::value_traits<
          ::butl::optional< bool >,
          pgsql::id_boolean >::set_image (
        i.custom_bot_value, is_null, v);
      i.custom_bot_null = is_null;
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::package_id& v =
        o.id;

      composite_value_traits< ::brep::package_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // version
    //
    {
      // From build-package.hxx:229:32
      ::brep::upstream_version v;

      composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
        v,
        i.version_value,
        db);

      // From build-package.hxx:229:32
      o.version.init (o.id.version, (v));
    }

    // project
    //
    {
      ::bpkg::package_name& v =
        o.project;

      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_value (
        v,
        i.project_value,
        i.project_size,
        i.project_null);
    }

    // build_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.build_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.build_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.build_email_value,
          db);
      }
    }

    // build_warning_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.build_warning_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.build_warning_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.build_warning_email_value,
          db);
      }
    }

    // build_error_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.build_error_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.build_error_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.build_error_email_value,
          db);
      }
    }

    // internal_repository
    //
    {
      ::odb::lazy_shared_ptr< ::brep::build_repository >& v =
        o.internal_repository;

      typedef object_traits< ::brep::build_repository > obj_traits;
      typedef odb::pointer_traits< ::odb::lazy_shared_ptr< ::brep::build_repository > > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.internal_repository_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.internal_repository_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }

    // buildable
    //
    {
      bool& v =
        o.buildable;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.buildable_value,
        i.buildable_null);
    }

    // custom_bot
    //
    {
      ::butl::optional< bool >& v =
        o.custom_bot;

      pgsql::value_traits<
          ::butl::optional< bool >,
          pgsql::id_boolean >::set_value (
        v,
        i.custom_bot_value,
        i.custom_bot_null);
    }
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    pgsql::statement_kind sk (pgsql::statement_select);
    {
      if (composite_value_traits< ::brep::package_id, id_pgsql >::init (
            i.id_value,
            id,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::persist_statement[] =
  "INSERT INTO \"build_package\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_upstream\", "
  "\"version_release\", "
  "\"project\", "
  "\"build_email\", "
  "\"build_email_comment\", "
  "\"build_warning_email\", "
  "\"build_warning_email_comment\", "
  "\"build_error_email\", "
  "\"build_error_email_comment\", "
  "\"internal_repository_tenant\", "
  "\"internal_repository_canonical_name\", "
  "\"buildable\", "
  "\"custom_bot\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9::CITEXT, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19)";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::find_statement[] =
  "SELECT "
  "\"build_package\".\"tenant\", "
  "\"build_package\".\"name\"::TEXT, "
  "\"build_package\".\"version_epoch\", "
  "\"build_package\".\"version_canonical_upstream\", "
  "\"build_package\".\"version_canonical_release\", "
  "\"build_package\".\"version_revision\", "
  "\"build_package\".\"version_upstream\", "
  "\"build_package\".\"version_release\", "
  "\"build_package\".\"project\"::TEXT, "
  "\"build_package\".\"build_email\", "
  "\"build_package\".\"build_email_comment\", "
  "\"build_package\".\"build_warning_email\", "
  "\"build_package\".\"build_warning_email_comment\", "
  "\"build_package\".\"build_error_email\", "
  "\"build_package\".\"build_error_email_comment\", "
  "\"build_package\".\"internal_repository_tenant\", "
  "\"build_package\".\"internal_repository_canonical_name\", "
  "\"build_package\".\"buildable\", "
  "\"build_package\".\"custom_bot\" "
  "FROM \"build_package\" "
  "WHERE \"build_package\".\"tenant\"=$1 AND \"build_package\".\"name\"=$2::CITEXT AND \"build_package\".\"version_epoch\"=$3 AND \"build_package\".\"version_canonical_upstream\"=$4 AND \"build_package\".\"version_canonical_release\"=$5 AND \"build_package\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::erase_statement[] =
  "DELETE FROM \"build_package\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::query_statement[] =
  "SELECT\n"
  "\"build_package\".\"tenant\",\n"
  "\"build_package\".\"name\"::TEXT,\n"
  "\"build_package\".\"version_epoch\",\n"
  "\"build_package\".\"version_canonical_upstream\",\n"
  "\"build_package\".\"version_canonical_release\",\n"
  "\"build_package\".\"version_revision\",\n"
  "\"build_package\".\"version_upstream\",\n"
  "\"build_package\".\"version_release\",\n"
  "\"build_package\".\"project\"::TEXT,\n"
  "\"build_package\".\"build_email\",\n"
  "\"build_package\".\"build_email_comment\",\n"
  "\"build_package\".\"build_warning_email\",\n"
  "\"build_package\".\"build_warning_email_comment\",\n"
  "\"build_package\".\"build_error_email\",\n"
  "\"build_package\".\"build_error_email_comment\",\n"
  "\"build_package\".\"internal_repository_tenant\",\n"
  "\"build_package\".\"internal_repository_canonical_name\",\n"
  "\"build_package\".\"buildable\",\n"
  "\"build_package\".\"custom_bot\"\n"
  "FROM \"build_package\"\n"
  "LEFT JOIN \"build_repository\" AS \"internal_repository\" ON \"internal_repository\".\"tenant\"=\"build_package\".\"internal_repository_tenant\" AND \"internal_repository\".\"canonical_name\"=\"build_package\".\"internal_repository_canonical_name\"";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"build_package\"";

  const char access::object_traits_impl< ::brep::build_package, id_pgsql >::table_name[] =
  "\"build_package\"";

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // requirements
    //
    {
      ::brep::build_package::requirements_type const& v =
        obj.requirements;

      requirements_traits::persist (
        v,
        esc.requirements);
    }

    // requirement_alternatives
    //
    {
      // From build-package.hxx:247:7
      ::brep::requirement_alternatives_map const& v =
        odb::nested_get (obj.requirements);

      requirement_alternatives_traits::persist (
        v,
        esc.requirement_alternatives);
    }

    // requirement_alternative_requirements
    //
    {
      // From build-package.hxx:257:7
      ::brep::requirement_alternative_requirements_map const& v =
        odb::nested2_get (obj.requirements);

      requirement_alternative_requirements_traits::persist (
        v,
        esc.requirement_alternative_requirements);
    }

    // tests
    //
    {
      ::butl::small_vector< ::brep::build_test_dependency, 1 > const& v =
        obj.tests;

      tests_traits::persist (
        v,
        esc.tests);
    }

    // builds
    //
    {
      ::brep::build_class_exprs const& v =
        obj.builds;

      builds_traits::persist (
        v,
        esc.builds);
    }

    // constraints
    //
    {
      ::brep::build_constraints const& v =
        obj.constraints;

      constraints_traits::persist (
        v,
        esc.constraints);
    }

    // auxiliaries
    //
    {
      ::brep::build_auxiliaries const& v =
        obj.auxiliaries;

      auxiliaries_traits::persist (
        v,
        esc.auxiliaries);
    }

    // bot_keys
    //
    {
      ::brep::build_package_bot_keys const& v =
        obj.bot_keys;

      bot_keys_traits::persist (
        v,
        esc.bot_keys);
    }

    // configs
    //
    {
      ::brep::build_package_configs const& v =
        obj.configs;

      configs_traits::persist (
        v,
        esc.configs);
    }

    // config_builds
    //
    {
      // From build-package.hxx:294:7
      ::brep::build_class_exprs_map const& v =
        odb::nested_get (obj.configs, & brep::build_package_config::builds);

      config_builds_traits::persist (
        v,
        esc.config_builds);
    }

    // config_constraints
    //
    {
      // From build-package.hxx:305:7
      ::brep::build_constraints_map const& v =
        odb::nested_get (obj.configs, & brep::build_package_config::constraints);

      config_constraints_traits::persist (
        v,
        esc.config_constraints);
    }

    // config_auxiliaries
    //
    {
      // From build-package.hxx:316:7
      ::brep::build_auxiliaries_map const& v =
        odb::nested_get (obj.configs, & brep::build_package_config::auxiliaries);

      config_auxiliaries_traits::persist (
        v,
        esc.config_auxiliaries);
    }

    // config_bot_keys
    //
    {
      // From build-package.hxx:327:7
      ::brep::build_package_bot_keys_map const& v =
        odb::nested_get (obj.configs, & brep::build_package_config::bot_keys);

      config_bot_keys_traits::persist (
        v,
        esc.config_bot_keys);
    }

    obj.requirements_tests_section.reset (true, false);

    obj.constraints_section.reset (true, false);

    obj.auxiliaries_section.reset (true, false);

    obj.bot_keys_section.reset (true, false);

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // requirements
    //
    {
      requirements_traits::erase (
        esc.requirements);
    }

    // requirement_alternatives
    //
    {
      requirement_alternatives_traits::erase (
        esc.requirement_alternatives);
    }

    // requirement_alternative_requirements
    //
    {
      requirement_alternative_requirements_traits::erase (
        esc.requirement_alternative_requirements);
    }

    // tests
    //
    {
      tests_traits::erase (
        esc.tests);
    }

    // builds
    //
    {
      builds_traits::erase (
        esc.builds);
    }

    // constraints
    //
    {
      constraints_traits::erase (
        esc.constraints);
    }

    // auxiliaries
    //
    {
      auxiliaries_traits::erase (
        esc.auxiliaries);
    }

    // bot_keys
    //
    {
      bot_keys_traits::erase (
        esc.bot_keys);
    }

    // configs
    //
    {
      configs_traits::erase (
        esc.configs);
    }

    // config_builds
    //
    {
      config_builds_traits::erase (
        esc.config_builds);
    }

    // config_constraints
    //
    {
      config_constraints_traits::erase (
        esc.config_constraints);
    }

    // config_auxiliaries
    //
    {
      config_auxiliaries_traits::erase (
        esc.config_auxiliaries);
    }

    // config_bot_keys
    //
    {
      config_bot_keys_traits::erase (
        esc.config_bot_keys);
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::build_package, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::build_package, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::
  load (connection& conn, object_type& obj, section& s)
  {
    using namespace pgsql;

    pgsql::connection& c (static_cast<pgsql::connection&> (conn));
    statements_type& sts (c.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    bool r (false);

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    if (!r && &s == &obj.requirements_tests_section)
    {
      requirements_tests_section_traits::load (esc, obj);
      r = true;
    }

    if (!r && &s == &obj.constraints_section)
    {
      constraints_section_traits::load (esc, obj);
      r = true;
    }

    if (!r && &s == &obj.auxiliaries_section)
    {
      auxiliaries_section_traits::load (esc, obj);
      r = true;
    }

    if (!r && &s == &obj.bot_keys_section)
    {
      bot_keys_section_traits::load (esc, obj);
      r = true;
    }

    sts.load_delayed (0);
    l.unlock ();
    return r;
  }

  bool access::object_traits_impl< ::brep::build_package, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build_package, id_pgsql >::
  load_ (statements_type& sts,
         object_type& obj,
         bool reload)
  {
    ODB_POTENTIALLY_UNUSED (reload);

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // configs
    //
    {
      ::brep::build_package_configs& v =
        obj.configs;

      configs_traits::load (
        v,
        esc.configs);
    }

    if (reload)
    {
      if (obj.requirements_tests_section.loaded ())
      {
        requirements_tests_section_traits::load (esc, obj);
        obj.requirements_tests_section.reset (true, false);
      }
    }
    else
      obj.requirements_tests_section.reset ();

    if (reload)
    {
      if (obj.constraints_section.loaded ())
      {
        constraints_section_traits::load (esc, obj);
        obj.constraints_section.reset (true, false);
      }
    }
    else
      obj.constraints_section.reset ();

    if (reload)
    {
      if (obj.auxiliaries_section.loaded ())
      {
        auxiliaries_section_traits::load (esc, obj);
        obj.auxiliaries_section.reset (true, false);
      }
    }
    else
      obj.auxiliaries_section.reset ();

    if (reload)
    {
      if (obj.bot_keys_section.loaded ())
      {
        bot_keys_section_traits::load (esc, obj);
        obj.bot_keys_section.reset (true, false);
      }
    }
    else
      obj.bot_keys_section.reset ();
  }

  result< access::object_traits_impl< ::brep::build_package, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::build_package, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += "\n";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        true,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::build_package, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::build_package, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += "\n";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        true,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::build_package, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // build_package_version
  //

  const char access::view_traits_impl< ::brep::build_package_version, id_pgsql >::
  query_statement_name[] = "query_brep_build_package_version";

  bool access::view_traits_impl< ::brep::build_package_version, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::package_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // version
    //
    if (composite_value_traits< ::brep::upstream_version, id_pgsql >::grow (
          i.version_value, t + 6UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::brep::build_package_version, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // id
    //
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
    n += 6UL;

    // version
    //
    composite_value_traits< ::brep::upstream_version, id_pgsql >::bind (
      b + n, i.version_value, sk);
    n += 2UL;
  }

  void access::view_traits_impl< ::brep::build_package_version, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::package_id& v =
        o.id;

      composite_value_traits< ::brep::package_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // version
    //
    {
      // From build-package.hxx:352:32
      ::brep::upstream_version v;

      composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
        v,
        i.version_value,
        db);

      // From build-package.hxx:352:32
      o.version.init (o.id.version, (v));
    }
  }

  access::view_traits_impl< ::brep::build_package_version, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::build_package_version, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"build_package\".\"tenant\", "
      "\"build_package\".\"name\"::TEXT, "
      "\"build_package\".\"version_epoch\", "
      "\"build_package\".\"version_canonical_upstream\", "
      "\"build_package\".\"version_canonical_release\", "
      "\"build_package\".\"version_revision\", "
      "\"build_package\".\"version_upstream\", "
      "\"build_package\".\"version_release\" ");

    r += "FROM \"build_package\"";

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::build_package_version, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::build_package_version, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::build_package_version, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::build_package_version, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // buildable_package
  //

  const char access::view_traits_impl< ::brep::buildable_package, id_pgsql >::
  query_statement_name[] = "query_brep_buildable_package";

  bool access::view_traits_impl< ::brep::buildable_package, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // package
    //
    if (object_traits_impl< ::brep::build_package, id_pgsql >::grow (
          i.package_value, t + 0UL))
      grew = true;

    // archived
    //
    t[19UL] = 0;

    // interactive
    //
    if (t[20UL])
    {
      i.interactive_value.capacity (i.interactive_size);
      grew = true;
    }

    return grew;
  }

  void access::view_traits_impl< ::brep::buildable_package, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // package
    //
    object_traits_impl< ::brep::build_package, id_pgsql >::bind (
      b + n, i.package_value, sk);
    n += 19UL;

    // archived
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.archived_value;
    b[n].is_null = &i.archived_null;
    n++;

    // interactive
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.interactive_value.data_ptr ();
    b[n].capacity = i.interactive_value.capacity ();
    b[n].size = &i.interactive_size;
    b[n].is_null = &i.interactive_null;
    n++;
  }

  void access::view_traits_impl< ::brep::buildable_package, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (*db));

    // package pre
    //
    typedef ::brep::build_package package_object_type;
    typedef object_traits_impl<package_object_type, id_pgsql> package_object_traits;
    typedef package_object_traits::pointer_type package_pointer_type;
    typedef package_object_traits::pointer_traits package_pointer_traits;
    typedef package_object_traits::pointer_cache_traits package_cache_traits;

    package_object_traits::id_type package_id;
    package_pointer_type package_p;
    package_pointer_traits::guard package_pg;
    package_cache_traits::insert_guard package_ig;
    package_object_type* package_o (0);

    {
      if (!composite_value_traits< package_object_traits::id_type, id_pgsql >::get_null (
            i.package_value.id_value))
      {
        package_id = package_object_traits::id (i.package_value);
        package_p = package_cache_traits::find (*db, package_id);

        if (package_pointer_traits::null_ptr (package_p))
        {
          package_p = object_factory<package_object_type, package_pointer_type>::create ();
          package_pg.reset (package_p);
          package_ig.reset (package_cache_traits::insert (*db, package_id, package_p));
          package_o = package_pointer_traits::get_ptr (package_p);
        }
      }
    }

    // package
    //
    {
      if (package_o != 0)
      {
        package_object_traits::callback (*db, *package_o, callback_event::pre_load);
        package_object_traits::init (*package_o, i.package_value, db);
        package_object_traits::statements_type& sts (
          conn.statement_cache ().find_object<package_object_type> ());
        package_object_traits::statements_type::auto_lock l (sts);
        assert (l.locked ()) /* Must be a top-level call. */;

        package_object_traits::id_image_type& i (sts.id_image ());
        package_object_traits::init (i, package_id);
        pgsql::binding& idb (sts.id_image_binding ());
        if (i.version != sts.id_image_version () || idb.version == 0)
        {
          package_object_traits::bind (idb.bind, i);
          sts.id_image_version (i.version);
          idb.version++;
        }

        package_object_traits::load_ (sts, *package_o, false);
        sts.load_delayed (0);
        l.unlock ();
      }
    }

    // archived
    //
    {
      bool& v =
        o.archived;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.archived_value,
        i.archived_null);
    }

    // interactive
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.interactive;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.interactive_value,
        i.interactive_size,
        i.interactive_null);
    }

    // package post
    //
    {
      if (package_o != 0)
      {
        package_object_traits::callback (*db, *package_o, callback_event::post_load);
        package_cache_traits::load (package_ig.position ());
        package_ig.release ();
        package_pg.release ();
      }

      // If a compiler error points to the line below, then
      // it most likely means that a pointer used in view
      // member cannot be initialized from an object pointer.
      //
      o.package = ::std::shared_ptr< ::brep::build_package > (
        std::move (package_p));
    }
  }

  access::view_traits_impl< ::brep::buildable_package, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::buildable_package, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"build_package\".\"tenant\", "
      "\"build_package\".\"name\"::TEXT, "
      "\"build_package\".\"version_epoch\", "
      "\"build_package\".\"version_canonical_upstream\", "
      "\"build_package\".\"version_canonical_release\", "
      "\"build_package\".\"version_revision\", "
      "\"build_package\".\"version_upstream\", "
      "\"build_package\".\"version_release\", "
      "\"build_package\".\"project\"::TEXT, "
      "\"build_package\".\"build_email\", "
      "\"build_package\".\"build_email_comment\", "
      "\"build_package\".\"build_warning_email\", "
      "\"build_package\".\"build_warning_email_comment\", "
      "\"build_package\".\"build_error_email\", "
      "\"build_package\".\"build_error_email_comment\", "
      "\"build_package\".\"internal_repository_tenant\", "
      "\"build_package\".\"internal_repository_canonical_name\", "
      "\"build_package\".\"buildable\", "
      "\"build_package\".\"custom_bot\", "
      "\"build_tenant\".\"archived\", "
      "\"build_tenant\".\"interactive\" ");

    r += "FROM \"build_package\"";

    r += " INNER JOIN \"build_repository\" ON";
    // From build-package.hxx:362:5
    r += query_columns::build_package::buildable && brep::operator == (query_columns::build_package::internal_repository, query_columns::build_repository::id);

    r += " LEFT JOIN \"build_tenant\" ON";
    // From build-package.hxx:366:5
    r += query_columns::build_package::id.tenant == query_columns::build_tenant::id;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::buildable_package, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::buildable_package, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::buildable_package, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::buildable_package, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // buildable_package_count
  //

  const char access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::
  query_statement_name[] = "query_brep_buildable_package_count";

  bool access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = 0;

    return grew;
  }

  void access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "count(\"build_package\".\"name\") ");

    r += "FROM \"build_package\"";

    r += " INNER JOIN \"build_repository\" ON";
    // From build-package.hxx:380:5
    r += query_columns::build_package::buildable && brep::operator == (query_columns::build_package::internal_repository, query_columns::build_repository::id);

    r += " LEFT JOIN \"build_tenant\" ON";
    // From build-package.hxx:384:5
    r += query_columns::build_package::id.tenant == query_columns::build_tenant::id;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }
}

#include <odb/post.hxx>
