// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
//
// End prologue.

#include <monitor/monitor-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace brep
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace brep
{
  namespace options
  {
    // monitor
    //

    monitor::
    monitor ()
    : soft_rebuild_timeout_ (),
      soft_rebuild_timeout_specified_ (false),
      hard_rebuild_timeout_ (),
      hard_rebuild_timeout_specified_ (false),
      report_timeout_ (),
      report_timeout_specified_ (false),
      full_report_ (),
      clean_ (),
      build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_package"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (),
      build_db_port_specified_ (false),
      pager_ (),
      pager_specified_ (false),
      pager_option_ (),
      pager_option_specified_ (false),
      help_ (),
      version_ ()
    {
    }

    monitor::
    monitor (int& argc,
             char** argv,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : soft_rebuild_timeout_ (),
      soft_rebuild_timeout_specified_ (false),
      hard_rebuild_timeout_ (),
      hard_rebuild_timeout_specified_ (false),
      report_timeout_ (),
      report_timeout_specified_ (false),
      full_report_ (),
      clean_ (),
      build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_package"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (),
      build_db_port_specified_ (false),
      pager_ (),
      pager_specified_ (false),
      pager_option_ (),
      pager_option_specified_ (false),
      help_ (),
      version_ ()
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
    }

    monitor::
    monitor (int start,
             int& argc,
             char** argv,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : soft_rebuild_timeout_ (),
      soft_rebuild_timeout_specified_ (false),
      hard_rebuild_timeout_ (),
      hard_rebuild_timeout_specified_ (false),
      report_timeout_ (),
      report_timeout_specified_ (false),
      full_report_ (),
      clean_ (),
      build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_package"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (),
      build_db_port_specified_ (false),
      pager_ (),
      pager_specified_ (false),
      pager_option_ (),
      pager_option_specified_ (false),
      help_ (),
      version_ ()
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
    }

    monitor::
    monitor (int& argc,
             char** argv,
             int& end,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : soft_rebuild_timeout_ (),
      soft_rebuild_timeout_specified_ (false),
      hard_rebuild_timeout_ (),
      hard_rebuild_timeout_specified_ (false),
      report_timeout_ (),
      report_timeout_specified_ (false),
      full_report_ (),
      clean_ (),
      build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_package"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (),
      build_db_port_specified_ (false),
      pager_ (),
      pager_specified_ (false),
      pager_option_ (),
      pager_option_specified_ (false),
      help_ (),
      version_ ()
    {
      ::brep::cli::argv_scanner s (argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    monitor::
    monitor (int start,
             int& argc,
             char** argv,
             int& end,
             bool erase,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : soft_rebuild_timeout_ (),
      soft_rebuild_timeout_specified_ (false),
      hard_rebuild_timeout_ (),
      hard_rebuild_timeout_specified_ (false),
      report_timeout_ (),
      report_timeout_specified_ (false),
      full_report_ (),
      clean_ (),
      build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_package"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (),
      build_db_port_specified_ (false),
      pager_ (),
      pager_specified_ (false),
      pager_option_ (),
      pager_option_specified_ (false),
      help_ (),
      version_ ()
    {
      ::brep::cli::argv_scanner s (start, argc, argv, erase);
      _parse (s, opt, arg);
      end = s.end ();
    }

    monitor::
    monitor (::brep::cli::scanner& s,
             ::brep::cli::unknown_mode opt,
             ::brep::cli::unknown_mode arg)
    : soft_rebuild_timeout_ (),
      soft_rebuild_timeout_specified_ (false),
      hard_rebuild_timeout_ (),
      hard_rebuild_timeout_specified_ (false),
      report_timeout_ (),
      report_timeout_specified_ (false),
      full_report_ (),
      clean_ (),
      build_db_user_ (),
      build_db_user_specified_ (false),
      build_db_password_ (),
      build_db_password_specified_ (false),
      build_db_name_ ("brep_package"),
      build_db_name_specified_ (false),
      build_db_host_ (),
      build_db_host_specified_ (false),
      build_db_port_ (),
      build_db_port_specified_ (false),
      pager_ (),
      pager_specified_ (false),
      pager_option_ (),
      pager_option_specified_ (false),
      help_ (),
      version_ ()
    {
      _parse (s, opt, arg);
    }

    ::brep::cli::usage_para monitor::
    print_usage (::std::ostream& os, ::brep::cli::usage_para p)
    {
      CLI_POTENTIALLY_UNUSED (os);

      if (p != ::brep::cli::usage_para::none)
        os << ::std::endl;

      os << "\033[1mOPTIONS\033[0m" << ::std::endl;

      os << std::endl
         << "\033[1m--soft-rebuild-timeout\033[0m \033[4mseconds\033[0m Time to wait (in seconds) before considering a" << ::std::endl
         << "                               package soft (re)build as delayed. If" << ::std::endl
         << "                               unspecified, it is the sum of the package" << ::std::endl
         << "                               rebuild timeout (soft rebuild timeout if the" << ::std::endl
         << "                               alternative timeout is unspecified and the" << ::std::endl
         << "                               maximum of two otherwise) and the build result" << ::std::endl
         << "                               timeout (see the \033[1mbuild-soft-rebuild-timeout\033[0m," << ::std::endl
         << "                               \033[1mbuild-alt-soft-rebuild-*\033[0m, and" << ::std::endl
         << "                               \033[1mbuild-result-timeout\033[0m \033[1mbrep\033[0m module configuration" << ::std::endl
         << "                               options for details). The special zero value" << ::std::endl
         << "                               disables monitoring of soft rebuilds." << ::std::endl
         << ::std::endl
         << "                               Note that if both soft and hard rebuilds are" << ::std::endl
         << "                               disabled in the \033[1mbrep\033[0m module configuration, then" << ::std::endl
         << "                               \033[1mbrep-monitor\033[0m is unable to come up with a" << ::std::endl
         << "                               reasonable build timeout on its own. In this" << ::std::endl
         << "                               case, to monitor the initial package build" << ::std::endl
         << "                               delays, you may need to specify either" << ::std::endl
         << "                               \033[1m--soft-rebuild-timeout\033[0m or" << ::std::endl
         << "                               \033[1m--hard-rebuild-timeout\033[0m explicitly." << ::std::endl
         << ::std::endl
         << "                               Also note that a package that was not built" << ::std::endl
         << "                               before it was archived is always considered as" << ::std::endl
         << "                               delayed. However, to distinguish this case from" << ::std::endl
         << "                               a situation where a package was archived before" << ::std::endl
         << "                               a configuration have been added, \033[1mbrep-monitor\033[0m" << ::std::endl
         << "                               needs to observe the package as buildable for" << ::std::endl
         << "                               this configuration before it is archived. As" << ::std::endl
         << "                               result, if you run \033[1mbrep-monitor\033[0m periodically" << ::std::endl
         << "                               (for example, as a cron job), then make sure its" << ::std::endl
         << "                               running period is less than the tenant archive" << ::std::endl
         << "                               timeout." << ::std::endl;

      os << std::endl
         << "\033[1m--hard-rebuild-timeout\033[0m \033[4mseconds\033[0m Time to wait (in seconds) before considering a" << ::std::endl
         << "                               package hard (re)build as delayed. If" << ::std::endl
         << "                               unspecified, it is calculated in the same way as" << ::std::endl
         << "                               for \033[1m--soft-rebuild-timeout\033[0m but using the" << ::std::endl
         << "                               \033[1mbuild-hard-rebuild-timeout\033[0m and" << ::std::endl
         << "                               \033[1mbuild-alt-hard-rebuild-*\033[0m \033[1mbrep\033[0m module" << ::std::endl
         << "                               configuration options." << ::std::endl;

      os << std::endl
         << "\033[1m--report-timeout\033[0m \033[4mseconds\033[0m       Time to wait (in seconds) before repeating a" << ::std::endl
         << "                               report of a package build delay. By default" << ::std::endl
         << "                               there is no timeout and all reports are" << ::std::endl
         << "                               repeated." << ::std::endl;

      os << std::endl
         << "\033[1m--full-report\033[0m                  Print the list of delayed package builds rather" << ::std::endl
         << "                               than just their number per build configuration." << ::std::endl;

      os << std::endl
         << "\033[1m--clean\033[0m                        Additionally clean the monitor state removing" << ::std::endl
         << "                               outdated information related to non-existent" << ::std::endl
         << "                               packages, configurations, etc." << ::std::endl;

      os << std::endl
         << "\033[1m--build-db-user\033[0m|\033[1m-u\033[0m \033[4muser\033[0m        \033[1mbuild\033[0m database user name. If unspecified, then" << ::std::endl
         << "                               operating system (login) name is used." << ::std::endl;

      os << std::endl
         << "\033[1m--build-db-password\033[0m \033[4mpass\033[0m       \033[1mbuild\033[0m database password. If unspecified, then" << ::std::endl
         << "                               login without password is expected to work." << ::std::endl;

      os << std::endl
         << "\033[1m--build-db-name\033[0m|\033[1m-n\033[0m \033[4mname\033[0m        \033[1mbuild\033[0m database name. If unspecified, then \033[1mbrep\033[0m's" << ::std::endl
         << "                               \033[1mbuild-db-name\033[0m configuration option value is" << ::std::endl
         << "                               used." << ::std::endl;

      os << std::endl
         << "\033[1m--build-db-host\033[0m|\033[1m-h\033[0m \033[4mhost\033[0m        \033[1mbuild\033[0m database host name, address, or socket. If" << ::std::endl
         << "                               unspecified, then \033[1mbrep\033[0m's \033[1mbuild-db-host\033[0m" << ::std::endl
         << "                               configuration option value is used." << ::std::endl;

      os << std::endl
         << "\033[1m--build-db-port\033[0m|\033[1m-p\033[0m \033[4mport\033[0m        \033[1mbuild\033[0m database port number. If unspecified, then" << ::std::endl
         << "                               \033[1mbrep\033[0m's \033[1mbuild-db-port\033[0m configuration option value" << ::std::endl
         << "                               is used." << ::std::endl;

      os << std::endl
         << "\033[1m--pager\033[0m \033[4mpath\033[0m                   The pager program to be used to show long text." << ::std::endl
         << "                               Commonly used pager programs are \033[1mless\033[0m and \033[1mmore\033[0m." << ::std::endl
         << "                               You can also specify additional options that" << ::std::endl
         << "                               should be passed to the pager program with" << ::std::endl
         << "                               \033[1m--pager-option\033[0m. If an empty string is specified" << ::std::endl
         << "                               as the pager program, then no pager will be" << ::std::endl
         << "                               used. If the pager program is not explicitly" << ::std::endl
         << "                               specified, then \033[1mbrep-monitor\033[0m will try to use" << ::std::endl
         << "                               \033[1mless\033[0m. If it is not available, then no pager will" << ::std::endl
         << "                               be used." << ::std::endl;

      os << std::endl
         << "\033[1m--pager-option\033[0m \033[4mopt\033[0m             Additional option to be passed to the pager" << ::std::endl
         << "                               program. See \033[1m--pager\033[0m for more information on the" << ::std::endl
         << "                               pager program. Repeat this option to specify" << ::std::endl
         << "                               multiple pager options." << ::std::endl;

      os << std::endl
         << "\033[1m--help\033[0m                         Print usage information and exit." << ::std::endl;

      os << std::endl
         << "\033[1m--version\033[0m                      Print version and exit." << ::std::endl;

      p = ::brep::cli::usage_para::option;

      return p;
    }

    typedef
    std::map<std::string, void (*) (monitor&, ::brep::cli::scanner&)>
    _cli_monitor_map;

    static _cli_monitor_map _cli_monitor_map_;

    struct _cli_monitor_map_init
    {
      _cli_monitor_map_init ()
      {
        _cli_monitor_map_["--soft-rebuild-timeout"] =
        &::brep::cli::thunk< monitor, std::size_t, &monitor::soft_rebuild_timeout_,
          &monitor::soft_rebuild_timeout_specified_ >;
        _cli_monitor_map_["--hard-rebuild-timeout"] =
        &::brep::cli::thunk< monitor, std::size_t, &monitor::hard_rebuild_timeout_,
          &monitor::hard_rebuild_timeout_specified_ >;
        _cli_monitor_map_["--report-timeout"] =
        &::brep::cli::thunk< monitor, std::size_t, &monitor::report_timeout_,
          &monitor::report_timeout_specified_ >;
        _cli_monitor_map_["--full-report"] =
        &::brep::cli::thunk< monitor, &monitor::full_report_ >;
        _cli_monitor_map_["--clean"] =
        &::brep::cli::thunk< monitor, &monitor::clean_ >;
        _cli_monitor_map_["--build-db-user"] =
        &::brep::cli::thunk< monitor, std::string, &monitor::build_db_user_,
          &monitor::build_db_user_specified_ >;
        _cli_monitor_map_["-u"] =
        &::brep::cli::thunk< monitor, std::string, &monitor::build_db_user_,
          &monitor::build_db_user_specified_ >;
        _cli_monitor_map_["--build-db-password"] =
        &::brep::cli::thunk< monitor, std::string, &monitor::build_db_password_,
          &monitor::build_db_password_specified_ >;
        _cli_monitor_map_["--build-db-name"] =
        &::brep::cli::thunk< monitor, std::string, &monitor::build_db_name_,
          &monitor::build_db_name_specified_ >;
        _cli_monitor_map_["-n"] =
        &::brep::cli::thunk< monitor, std::string, &monitor::build_db_name_,
          &monitor::build_db_name_specified_ >;
        _cli_monitor_map_["--build-db-host"] =
        &::brep::cli::thunk< monitor, std::string, &monitor::build_db_host_,
          &monitor::build_db_host_specified_ >;
        _cli_monitor_map_["-h"] =
        &::brep::cli::thunk< monitor, std::string, &monitor::build_db_host_,
          &monitor::build_db_host_specified_ >;
        _cli_monitor_map_["--build-db-port"] =
        &::brep::cli::thunk< monitor, std::uint16_t, &monitor::build_db_port_,
          &monitor::build_db_port_specified_ >;
        _cli_monitor_map_["-p"] =
        &::brep::cli::thunk< monitor, std::uint16_t, &monitor::build_db_port_,
          &monitor::build_db_port_specified_ >;
        _cli_monitor_map_["--pager"] =
        &::brep::cli::thunk< monitor, std::string, &monitor::pager_,
          &monitor::pager_specified_ >;
        _cli_monitor_map_["--pager-option"] =
        &::brep::cli::thunk< monitor, std::vector<std::string>, &monitor::pager_option_,
          &monitor::pager_option_specified_ >;
        _cli_monitor_map_["--help"] =
        &::brep::cli::thunk< monitor, &monitor::help_ >;
        _cli_monitor_map_["--version"] =
        &::brep::cli::thunk< monitor, &monitor::version_ >;
      }
    };

    static _cli_monitor_map_init _cli_monitor_map_init_;

    bool monitor::
    _parse (const char* o, ::brep::cli::scanner& s)
    {
      _cli_monitor_map::const_iterator i (_cli_monitor_map_.find (o));

      if (i != _cli_monitor_map_.end ())
      {
        (*(i->second)) (*this, s);
        return true;
      }

      return false;
    }

    bool monitor::
    _parse (::brep::cli::scanner& s,
            ::brep::cli::unknown_mode opt_mode,
            ::brep::cli::unknown_mode arg_mode)
    {
      // Can't skip combined flags (--no-combined-flags).
      //
      assert (opt_mode != ::brep::cli::unknown_mode::skip);

      bool r = false;
      bool opt = true;

      while (s.more ())
      {
        const char* o = s.peek ();

        if (std::strcmp (o, "--") == 0)
        {
          opt = false;
          s.skip ();
          r = true;
          continue;
        }

        if (opt)
        {
          if (_parse (o, s))
          {
            r = true;
            continue;
          }

          if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
          {
            // Handle combined option values.
            //
            std::string co;
            if (const char* v = std::strchr (o, '='))
            {
              co.assign (o, 0, v - o);
              ++v;

              int ac (2);
              char* av[] =
              {
                const_cast<char*> (co.c_str ()),
                const_cast<char*> (v)
              };

              ::brep::cli::argv_scanner ns (0, ac, av);

              if (_parse (co.c_str (), ns))
              {
                // Parsed the option but not its value?
                //
                if (ns.end () != 2)
                  throw ::brep::cli::invalid_value (co, v);

                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = co.c_str ();
              }
            }

            // Handle combined flags.
            //
            char cf[3];
            {
              const char* p = o + 1;
              for (; *p != '\0'; ++p)
              {
                if (!((*p >= 'a' && *p <= 'z') ||
                      (*p >= 'A' && *p <= 'Z') ||
                      (*p >= '0' && *p <= '9')))
                  break;
              }

              if (*p == '\0')
              {
                for (p = o + 1; *p != '\0'; ++p)
                {
                  std::strcpy (cf, "-");
                  cf[1] = *p;
                  cf[2] = '\0';

                  int ac (1);
                  char* av[] =
                  {
                    cf
                  };

                  ::brep::cli::argv_scanner ns (0, ac, av);

                  if (!_parse (cf, ns))
                    break;
                }

                if (*p == '\0')
                {
                  // All handled.
                  //
                  s.next ();
                  r = true;
                  continue;
                }
                else
                {
                  // Set the unknown option and fall through.
                  //
                  o = cf;
                }
              }
            }

            switch (opt_mode)
            {
              case ::brep::cli::unknown_mode::skip:
              {
                s.skip ();
                r = true;
                continue;
              }
              case ::brep::cli::unknown_mode::stop:
              {
                break;
              }
              case ::brep::cli::unknown_mode::fail:
              {
                throw ::brep::cli::unknown_option (o);
              }
            }

            break;
          }
        }

        switch (arg_mode)
        {
          case ::brep::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::brep::cli::unknown_mode::stop:
          {
            break;
          }
          case ::brep::cli::unknown_mode::fail:
          {
            throw ::brep::cli::unknown_argument (o);
          }
        }

        break;
      }

      return r;
    }
  }
}

::brep::cli::usage_para
print_usage (::std::ostream& os, ::brep::cli::usage_para p)
{
  CLI_POTENTIALLY_UNUSED (os);

  if (p != ::brep::cli::usage_para::none)
    os << ::std::endl;

  os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1mbrep-monitor --help\033[0m" << ::std::endl
     << "\033[1mbrep-monitor --version\033[0m" << ::std::endl
     << "\033[1mbrep-monitor\033[0m [\033[4moptions\033[0m] \033[4mbrep-config\033[0m \033[4mtoolchain\033[0m [\033[4mtoolchain\033[0m...]\033[0m" << ::std::endl
     << ::std::endl
     << "\033[4mtoolchain\033[0m = \033[4mname\033[0m[\033[1m/\033[0m\033[4mversion\033[0m]\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1mDESCRIPTION\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1mbrep-monitor\033[0m analyzes the \033[1mbrep\033[0m internal state and reports the infrastructure" << ::std::endl
     << "issues printing their descriptions to \033[1mstderr\033[0m." << ::std::endl
     << ::std::endl
     << "The specified \033[1mbrep\033[0m module configuration file (\033[4mbrep-config\033[0m) is used to retrieve" << ::std::endl
     << "information required to access the databases and deduce the expected behavior." << ::std::endl
     << "Most of this information can be overridden via the command line options." << ::std::endl
     << ::std::endl
     << "Currently, only delayed package builds for the specified toolchains are" << ::std::endl
     << "reported. If toolchain version is omitted then all package builds with this" << ::std::endl
     << "toolchain name are considered." << ::std::endl
     << ::std::endl
     << "\033[1mbrep-monitor\033[0m maintains its own state in the brep \033[1mbuild\033[0m database. In particular," << ::std::endl
     << "it records timestamps of the reported package build delays and optionally omits" << ::std::endl
     << "them from being reported again during the timeout specified with the" << ::std::endl
     << "\033[1m--report-timeout\033[0m option. If the timeout is unspecified, then the report" << ::std::endl
     << "timestamps are not updated. To report all delays and still update the" << ::std::endl
     << "timestamps specify the zero report timeout." << ::std::endl
     << ::std::endl
     << "By default, a brief report is printed. Use the \033[1m--full-report\033[0m option to obtain" << ::std::endl
     << "the full report (which may be large)." << ::std::endl
     << ::std::endl
     << "Note that \033[1mbrep-monitor\033[0m expects the \033[1mbuild\033[0m database schema to have already been" << ::std::endl
     << "created using \033[1mbrep-migrate(1)\033[0m." << ::std::endl;

  p = ::brep::options::monitor::print_usage (os, ::brep::cli::usage_para::text);

  if (p != ::brep::cli::usage_para::none)
    os << ::std::endl;

  os << "\033[1mEXIT STATUS\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1m0\033[0m" << ::std::endl
     << "    Success." << ::std::endl
     << "\033[1m1\033[0m" << ::std::endl
     << "    Fatal error." << ::std::endl
     << "\033[1m2\033[0m" << ::std::endl
     << "    An instance of \033[1mbrep-monitor\033[0m or some other \033[1mbrep\033[0m utility is already running." << ::std::endl
     << "    Try again." << ::std::endl
     << "\033[1m3\033[0m" << ::std::endl
     << "    Recoverable database error. Try again." << ::std::endl;

  p = ::brep::cli::usage_para::text;

  return p;
}

// Begin epilogue.
//
//
// End epilogue.

