// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#ifndef LIBBREP_PACKAGE_ODB_HXX
#define LIBBREP_PACKAGE_ODB_HXX

// Begin prologue.
//
#include <libbrep/package-traits.hxx>
//
// End prologue.

#include <odb/version.hxx>

#if ODB_VERSION != 20500UL
#error ODB runtime version mismatch
#endif

#include <odb/pre.hxx>

#include <libbrep/package.hxx>

#include <libbrep/common-odb.hxx>

#include <memory>
#include <cstddef>
#include <utility>

#include <odb/core.hxx>
#include <odb/traits.hxx>
#include <odb/callback.hxx>
#include <odb/wrapper-traits.hxx>
#include <odb/pointer-traits.hxx>
#include <odb/container-traits.hxx>
#include <odb/session.hxx>
#include <odb/cache-traits.hxx>
#include <odb/prepared-query.hxx>
#include <odb/result.hxx>
#include <odb/simple-object-result.hxx>
#include <odb/view-image.hxx>
#include <odb/view-result.hxx>

#include <odb/details/unused.hxx>
#include <odb/details/shared-ptr.hxx>

namespace odb
{
  // tenant
  //
  template <>
  struct class_traits< ::brep::tenant >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::tenant >
  {
    public:
    typedef ::brep::tenant object_type;
    typedef ::std::shared_ptr< ::brep::tenant > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::std::string id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // tenant_id
  //
  template <>
  struct class_traits< ::brep::tenant_id >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::tenant_id >
  {
    public:
    typedef ::brep::tenant_id view_type;
    typedef ::brep::tenant_id* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // repository
  //
  template <>
  struct class_traits< ::brep::repository >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::repository >
  {
    public:
    typedef ::brep::repository object_type;
    typedef ::std::shared_ptr< ::brep::repository > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::brep::repository_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // repository_count
  //
  template <>
  struct class_traits< ::brep::repository_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::repository_count >
  {
    public:
    typedef ::brep::repository_count view_type;
    typedef ::brep::repository_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // public_key
  //
  template <>
  struct class_traits< ::brep::public_key >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::public_key >
  {
    public:
    typedef ::brep::public_key object_type;
    typedef ::std::shared_ptr< ::brep::public_key > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::brep::public_key_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // package
  //
  template <>
  struct class_traits< ::brep::package >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::package >
  {
    public:
    typedef ::brep::package object_type;
    typedef ::std::shared_ptr< ::brep::package > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::brep::package_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // package_count
  //
  template <>
  struct class_traits< ::brep::package_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::package_count >
  {
    public:
    typedef ::brep::package_count view_type;
    typedef ::brep::package_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // latest_package_search_rank
  //
  template <>
  struct class_traits< ::brep::latest_package_search_rank >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::latest_package_search_rank >
  {
    public:
    typedef ::brep::latest_package_search_rank view_type;
    typedef ::brep::latest_package_search_rank* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // latest_package_count
  //
  template <>
  struct class_traits< ::brep::latest_package_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::latest_package_count >
  {
    public:
    typedef ::brep::latest_package_count view_type;
    typedef ::brep::latest_package_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // package_search_rank
  //
  template <>
  struct class_traits< ::brep::package_search_rank >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::package_search_rank >
  {
    public:
    typedef ::brep::package_search_rank view_type;
    typedef ::brep::package_search_rank* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // package_search_count
  //
  template <>
  struct class_traits< ::brep::package_search_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::package_search_count >
  {
    public:
    typedef ::brep::package_search_count view_type;
    typedef ::brep::package_search_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // latest_package
  //
  template <>
  struct class_traits< ::brep::latest_package >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::latest_package >
  {
    public:
    typedef ::brep::latest_package view_type;
    typedef ::brep::latest_package* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };
}

#include <odb/details/buffer.hxx>

#include <odb/pgsql/version.hxx>
#include <odb/pgsql/forward.hxx>
#include <odb/pgsql/binding.hxx>
#include <odb/pgsql/pgsql-types.hxx>
#include <odb/pgsql/query.hxx>

namespace odb
{
  // priority
  //
  template <>
  class access::composite_value_traits< ::bpkg::priority, id_pgsql >
  {
    public:
    typedef ::bpkg::priority value_type;

    struct image_type
    {
      // value
      //
      int value_value;
      bool value_null;

      // comment
      //
      details::buffer comment_value;
      std::size_t comment_size;
      bool comment_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // licenses
  //
  template <>
  class access::composite_value_traits< ::bpkg::licenses, id_pgsql >
  {
    public:
    typedef ::bpkg::licenses value_type;

    struct image_type
    {
      // comment
      //
      details::buffer comment_value;
      std::size_t comment_size;
      bool comment_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 1UL;
  };

  // manifest_url
  //
  template <>
  class access::composite_value_traits< ::bpkg::manifest_url, id_pgsql >
  {
    public:
    typedef ::bpkg::manifest_url value_type;

    struct image_type
    {
      // value
      //
      details::buffer value_value;
      std::size_t value_size;
      bool value_null;

      // comment
      //
      details::buffer comment_value;
      std::size_t comment_size;
      bool comment_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // dependency
  //
  template <>
  class access::composite_value_traits< ::brep::dependency, id_pgsql >
  {
    public:
    typedef ::brep::dependency value_type;

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // constraint
      //
      composite_value_traits< ::bpkg::version_constraint, id_pgsql >::image_type constraint_value;

      // package
      //
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type package_value;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 21UL;
  };

  // dependency_alternative
  //
  template <>
  class access::composite_value_traits< ::brep::dependency_alternative, id_pgsql >
  {
    public:
    typedef ::brep::dependency_alternative value_type;

    struct image_type
    {
      // enable
      //
      details::buffer enable_value;
      std::size_t enable_size;
      bool enable_null;

      // reflect
      //
      details::buffer reflect_value;
      std::size_t reflect_size;
      bool reflect_null;

      // prefer
      //
      details::buffer prefer_value;
      std::size_t prefer_size;
      bool prefer_null;

      // accept
      //
      details::buffer accept_value;
      std::size_t accept_size;
      bool accept_null;

      // require
      //
      details::buffer require_value;
      std::size_t require_size;
      bool require_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 5UL;
  };

  // dependency_alternatives
  //
  template <>
  class access::composite_value_traits< ::brep::dependency_alternatives, id_pgsql >
  {
    public:
    typedef ::brep::dependency_alternatives value_type;

    struct image_type
    {
      // buildtime
      //
      bool buildtime_value;
      bool buildtime_null;

      // comment
      //
      details::buffer comment_value;
      std::size_t comment_size;
      bool comment_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // test_dependency
  //
  template <>
  class access::composite_value_traits< ::brep::test_dependency, id_pgsql >
  {
    public:
    typedef ::brep::test_dependency value_type;

    struct image_type: composite_value_traits< ::brep::dependency, id_pgsql >::image_type
    {
      // type
      //
      details::buffer type_value;
      std::size_t type_size;
      bool type_null;

      // buildtime
      //
      bool buildtime_value;
      bool buildtime_null;

      // enable
      //
      details::buffer enable_value;
      std::size_t enable_size;
      bool enable_null;

      // reflect
      //
      details::buffer reflect_value;
      std::size_t reflect_size;
      bool reflect_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 25UL;
  };

  // certificate
  //
  template <>
  class access::composite_value_traits< ::brep::certificate, id_pgsql >
  {
    public:
    typedef ::brep::certificate value_type;

    struct image_type
    {
      // fingerprint
      //
      details::buffer fingerprint_value;
      std::size_t fingerprint_size;
      bool fingerprint_null;

      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // organization
      //
      details::buffer organization_value;
      std::size_t organization_size;
      bool organization_null;

      // email
      //
      details::buffer email_value;
      std::size_t email_size;
      bool email_null;

      // pem
      //
      details::buffer pem_value;
      std::size_t pem_size;
      bool pem_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 5UL;
  };

  // tenant
  //
  template <typename A>
  struct query_columns< ::brep::tenant, id_pgsql, A >
  {
    // id
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    id_type_;

    static const id_type_ id;

    // private_
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    private__type_;

    static const private__type_ private_;

    // interactive
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    interactive_type_;

    static const interactive_type_ interactive;

    // creation_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    creation_timestamp_type_;

    static const creation_timestamp_type_ creation_timestamp;

    // archived
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    archived_type_;

    static const archived_type_ archived;

    // service
    //
    struct service_class_
    {
      service_class_ ()
      {
      }

      // id
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      id_type_;

      static const id_type_ id;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;

      // ref_count
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::query_type,
        pgsql::id_bigint >
      ref_count_type_;

      static const ref_count_type_ ref_count;

      // data
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      data_type_;

      static const data_type_ data;
    };

    static const service_class_ service;

    // unloaded_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        long unsigned int,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    unloaded_timestamp_type_;

    static const unloaded_timestamp_type_ unloaded_timestamp;

    // unloaded_notify_interval
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        long unsigned int,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    unloaded_notify_interval_type_;

    static const unloaded_notify_interval_type_ unloaded_notify_interval;

    // queued_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        long unsigned int,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    queued_timestamp_type_;

    static const queued_timestamp_type_ queued_timestamp;

    // build_toolchain
    //
    struct build_toolchain_class_
    {
      build_toolchain_class_ ()
      {
      }

      // name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      name_type_;

      static const name_type_ name;

      // version
      //
      struct version_class_1_
      {
        version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            short unsigned int,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        revision_type_;

        static const revision_type_ revision;

        // upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        upstream_type_;

        static const upstream_type_ upstream;

        // release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::basic_string< char >,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        release_type_;

        static const release_type_ release;
      };

      static const version_class_1_ version;
    };

    static const build_toolchain_class_ build_toolchain;
  };

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::id_type_
  query_columns< ::brep::tenant, id_pgsql, A >::
  id (A::table_name, "\"id\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::private__type_
  query_columns< ::brep::tenant, id_pgsql, A >::
  private_ (A::table_name, "\"private\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::interactive_type_
  query_columns< ::brep::tenant, id_pgsql, A >::
  interactive (A::table_name, "\"interactive\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::creation_timestamp_type_
  query_columns< ::brep::tenant, id_pgsql, A >::
  creation_timestamp (A::table_name, "\"creation_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::archived_type_
  query_columns< ::brep::tenant, id_pgsql, A >::
  archived (A::table_name, "\"archived\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::service_class_::id_type_
  query_columns< ::brep::tenant, id_pgsql, A >::service_class_::
  id (A::table_name, "\"service_id\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::service_class_::type_type_
  query_columns< ::brep::tenant, id_pgsql, A >::service_class_::
  type (A::table_name, "\"service_type\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::service_class_::ref_count_type_
  query_columns< ::brep::tenant, id_pgsql, A >::service_class_::
  ref_count (A::table_name, "\"service_ref_count\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::service_class_::data_type_
  query_columns< ::brep::tenant, id_pgsql, A >::service_class_::
  data (A::table_name, "\"service_data\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::service_class_
  query_columns< ::brep::tenant, id_pgsql, A >::service;

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::unloaded_timestamp_type_
  query_columns< ::brep::tenant, id_pgsql, A >::
  unloaded_timestamp (A::table_name, "\"unloaded_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::unloaded_notify_interval_type_
  query_columns< ::brep::tenant, id_pgsql, A >::
  unloaded_notify_interval (A::table_name, "\"unloaded_notify_interval\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::queued_timestamp_type_
  query_columns< ::brep::tenant, id_pgsql, A >::
  queued_timestamp (A::table_name, "\"queued_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::name_type_
  query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::
  name (A::table_name, "\"build_toolchain_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::epoch_type_
  query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::
  epoch (A::table_name, "\"build_toolchain_version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::canonical_upstream_type_
  query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::
  canonical_upstream (A::table_name, "\"build_toolchain_version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::canonical_release_type_
  query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::
  canonical_release (A::table_name, "\"build_toolchain_version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::revision_type_
  query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::
  revision (A::table_name, "\"build_toolchain_version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::upstream_type_
  query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::
  upstream (A::table_name, "\"build_toolchain_version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::release_type_
  query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_::
  release (A::table_name, "\"build_toolchain_version_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version_class_1_
  query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_::version;

  template <typename A>
  const typename query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain_class_
  query_columns< ::brep::tenant, id_pgsql, A >::build_toolchain;

  template <typename A>
  struct pointer_query_columns< ::brep::tenant, id_pgsql, A >:
    query_columns< ::brep::tenant, id_pgsql, A >
  {
  };

  template <>
  class access::object_traits_impl< ::brep::tenant, id_pgsql >:
    public access::object_traits< ::brep::tenant >
  {
    public:
    struct id_image_type
    {
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      // private_
      //
      bool private_value;
      bool private_null;

      // interactive
      //
      details::buffer interactive_value;
      std::size_t interactive_size;
      bool interactive_null;

      // creation_timestamp
      //
      long long creation_timestamp_value;
      bool creation_timestamp_null;

      // archived
      //
      bool archived_value;
      bool archived_null;

      // service
      //
      composite_value_traits< ::brep::tenant_service, id_pgsql >::image_type service_value;

      // unloaded_timestamp
      //
      long long unloaded_timestamp_value;
      bool unloaded_timestamp_null;

      // unloaded_notify_interval
      //
      long long unloaded_notify_interval_value;
      bool unloaded_notify_interval_null;

      // queued_timestamp
      //
      long long queued_timestamp_value;
      bool queued_timestamp_null;

      // build_toolchain
      //
      composite_value_traits< ::brep::build_toolchain, id_pgsql >::image_type build_toolchain_value;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 19UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char update_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];
    static const unsigned int update_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::tenant, id_common >:
    public access::object_traits_impl< ::brep::tenant, id_pgsql >
  {
  };

  // tenant_id
  //
  template <>
  class access::view_traits_impl< ::brep::tenant_id, id_pgsql >:
    public access::view_traits< ::brep::tenant_id >
  {
    public:
    struct image_type
    {
      // value
      //
      details::buffer value_value;
      std::size_t value_size;
      bool value_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::tenant_id, id_common >:
    public access::view_traits_impl< ::brep::tenant_id, id_pgsql >
  {
  };

  // repository
  //
  template <typename A>
  struct query_columns< ::brep::repository, id_pgsql, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // canonical_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      canonical_name_type_;

      static const canonical_name_type_ canonical_name;
    };

    static const id_class_ id;

    // location
    //
    struct location_class_
    {
      location_class_ ()
      {
      }

      // url
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      url_type_;

      static const url_type_ url;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;
    };

    static const location_class_ location;

    // display_name
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    display_name_type_;

    static const display_name_type_ display_name;

    // priority
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint16_t,
        pgsql::id_integer >::query_type,
      pgsql::id_integer >
    priority_type_;

    static const priority_type_ priority;

    // interface_url
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    interface_url_type_;

    static const interface_url_type_ interface_url;

    // email
    //
    struct email_class_
    {
      email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const email_class_ email;

    // summary
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    summary_type_;

    static const summary_type_ summary;

    // description
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    description_type_;

    static const description_type_ description;

    // cache_location
    //
    struct cache_location_class_
    {
      cache_location_class_ ()
      {
      }

      // url
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      url_type_;

      static const url_type_ url;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;
    };

    static const cache_location_class_ cache_location;

    // certificate
    //
    struct certificate_class_
    {
      certificate_class_ ()
      {
      }

      // fingerprint
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      fingerprint_type_;

      static const fingerprint_type_ fingerprint;

      // name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      name_type_;

      static const name_type_ name;

      // organization
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      organization_type_;

      static const organization_type_ organization;

      // email
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      email_type_;

      static const email_type_ email;

      // pem
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      pem_type_;

      static const pem_type_ pem;
    };

    static const certificate_class_ certificate;

    // packages_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    packages_timestamp_type_;

    static const packages_timestamp_type_ packages_timestamp;

    // repositories_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    repositories_timestamp_type_;

    static const repositories_timestamp_type_ repositories_timestamp;

    // internal
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    internal_type_;

    static const internal_type_ internal;

    // buildable
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    buildable_type_;

    static const buildable_type_ buildable;
  };

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::id_class_::tenant_type_
  query_columns< ::brep::repository, id_pgsql, A >::id_class_::
  tenant (A::table_name, "\"tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::id_class_::canonical_name_type_
  query_columns< ::brep::repository, id_pgsql, A >::id_class_::
  canonical_name (A::table_name, "\"canonical_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::id_class_
  query_columns< ::brep::repository, id_pgsql, A >::id;

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::location_class_::url_type_
  query_columns< ::brep::repository, id_pgsql, A >::location_class_::
  url (A::table_name, "\"location_url\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::location_class_::type_type_
  query_columns< ::brep::repository, id_pgsql, A >::location_class_::
  type (A::table_name, "\"location_type\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::location_class_
  query_columns< ::brep::repository, id_pgsql, A >::location;

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::display_name_type_
  query_columns< ::brep::repository, id_pgsql, A >::
  display_name (A::table_name, "\"display_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::priority_type_
  query_columns< ::brep::repository, id_pgsql, A >::
  priority (A::table_name, "\"priority\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::interface_url_type_
  query_columns< ::brep::repository, id_pgsql, A >::
  interface_url (A::table_name, "\"interface_url\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::email_class_::value_type_
  query_columns< ::brep::repository, id_pgsql, A >::email_class_::
  value (A::table_name, "\"email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::email_class_::comment_type_
  query_columns< ::brep::repository, id_pgsql, A >::email_class_::
  comment (A::table_name, "\"email_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::email_class_
  query_columns< ::brep::repository, id_pgsql, A >::email;

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::summary_type_
  query_columns< ::brep::repository, id_pgsql, A >::
  summary (A::table_name, "\"summary\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::description_type_
  query_columns< ::brep::repository, id_pgsql, A >::
  description (A::table_name, "\"description\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::cache_location_class_::url_type_
  query_columns< ::brep::repository, id_pgsql, A >::cache_location_class_::
  url (A::table_name, "\"cache_location_url\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::cache_location_class_::type_type_
  query_columns< ::brep::repository, id_pgsql, A >::cache_location_class_::
  type (A::table_name, "\"cache_location_type\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::cache_location_class_
  query_columns< ::brep::repository, id_pgsql, A >::cache_location;

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::fingerprint_type_
  query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::
  fingerprint (A::table_name, "\"certificate_fingerprint\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::name_type_
  query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::
  name (A::table_name, "\"certificate_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::organization_type_
  query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::
  organization (A::table_name, "\"certificate_organization\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::email_type_
  query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::
  email (A::table_name, "\"certificate_email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::pem_type_
  query_columns< ::brep::repository, id_pgsql, A >::certificate_class_::
  pem (A::table_name, "\"certificate_pem\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::certificate_class_
  query_columns< ::brep::repository, id_pgsql, A >::certificate;

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::packages_timestamp_type_
  query_columns< ::brep::repository, id_pgsql, A >::
  packages_timestamp (A::table_name, "\"packages_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::repositories_timestamp_type_
  query_columns< ::brep::repository, id_pgsql, A >::
  repositories_timestamp (A::table_name, "\"repositories_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::internal_type_
  query_columns< ::brep::repository, id_pgsql, A >::
  internal (A::table_name, "\"internal\"", 0);

  template <typename A>
  const typename query_columns< ::brep::repository, id_pgsql, A >::buildable_type_
  query_columns< ::brep::repository, id_pgsql, A >::
  buildable (A::table_name, "\"buildable\"", 0);

  template <typename A>
  struct pointer_query_columns< ::brep::repository, id_pgsql, A >:
    query_columns< ::brep::repository, id_pgsql, A >
  {
  };

  template <>
  class access::object_traits_impl< ::brep::repository, id_pgsql >:
    public access::object_traits< ::brep::repository >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::brep::repository_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::repository_id, id_pgsql >::image_type id_value;

      // location
      //
      composite_value_traits< ::brep::_repository_location, id_pgsql >::image_type location_value;

      // display_name
      //
      details::buffer display_name_value;
      std::size_t display_name_size;
      bool display_name_null;

      // priority
      //
      int priority_value;
      bool priority_null;

      // interface_url
      //
      details::buffer interface_url_value;
      std::size_t interface_url_size;
      bool interface_url_null;

      // email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type email_value;

      // summary
      //
      details::buffer summary_value;
      std::size_t summary_size;
      bool summary_null;

      // description
      //
      details::buffer description_value;
      std::size_t description_size;
      bool description_null;

      // cache_location
      //
      composite_value_traits< ::brep::_repository_location, id_pgsql >::image_type cache_location_value;

      // certificate
      //
      composite_value_traits< ::brep::certificate, id_pgsql >::image_type certificate_value;

      // packages_timestamp
      //
      long long packages_timestamp_value;
      bool packages_timestamp_null;

      // repositories_timestamp
      //
      long long repositories_timestamp_value;
      bool repositories_timestamp_null;

      // internal
      //
      bool internal_value;
      bool internal_null;

      // buildable
      //
      bool buildable_value;
      bool buildable_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    // complements
    //
    struct complements_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 2UL;
      static const std::size_t data_column_count = 5UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::std::vector< ::odb::lazy_weak_ptr< ::brep::repository > > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< complements_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< ::brep::repository_id, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // prerequisites
    //
    struct prerequisites_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 2UL;
      static const std::size_t data_column_count = 5UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::std::vector< ::odb::lazy_weak_ptr< ::brep::repository > > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< prerequisites_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< ::brep::repository_id, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 22UL;
    static const std::size_t id_column_count = 2UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char update_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];
    static const unsigned int update_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::repository, id_common >:
    public access::object_traits_impl< ::brep::repository, id_pgsql >
  {
  };

  // repository_count
  //
  template <>
  class access::view_traits_impl< ::brep::repository_count, id_pgsql >:
    public access::view_traits< ::brep::repository_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::repository_count, id_common >:
    public access::view_traits_impl< ::brep::repository_count, id_pgsql >
  {
  };

  // typed_text
  //
  template <>
  class access::composite_value_traits< ::brep::typed_text, id_pgsql >
  {
    public:
    typedef ::brep::typed_text value_type;

    struct image_type
    {
      // text
      //
      details::buffer text_value;
      std::size_t text_size;
      bool text_null;

      // type
      //
      details::buffer type_value;
      std::size_t type_size;
      bool type_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // public_key
  //
  template <typename A>
  struct query_columns< ::brep::public_key, id_pgsql, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // fingerprint
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      fingerprint_type_;

      static const fingerprint_type_ fingerprint;
    };

    static const id_class_ id;

    // data
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    data_type_;

    static const data_type_ data;
  };

  template <typename A>
  const typename query_columns< ::brep::public_key, id_pgsql, A >::id_class_::tenant_type_
  query_columns< ::brep::public_key, id_pgsql, A >::id_class_::
  tenant (A::table_name, "\"tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::public_key, id_pgsql, A >::id_class_::fingerprint_type_
  query_columns< ::brep::public_key, id_pgsql, A >::id_class_::
  fingerprint (A::table_name, "\"fingerprint\"", 0);

  template <typename A>
  const typename query_columns< ::brep::public_key, id_pgsql, A >::id_class_
  query_columns< ::brep::public_key, id_pgsql, A >::id;

  template <typename A>
  const typename query_columns< ::brep::public_key, id_pgsql, A >::data_type_
  query_columns< ::brep::public_key, id_pgsql, A >::
  data (A::table_name, "\"data\"", 0);

  template <typename A>
  struct pointer_query_columns< ::brep::public_key, id_pgsql, A >:
    query_columns< ::brep::public_key, id_pgsql, A >
  {
  };

  template <>
  class access::object_traits_impl< ::brep::public_key, id_pgsql >:
    public access::object_traits< ::brep::public_key >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::brep::public_key_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::public_key_id, id_pgsql >::image_type id_value;

      // data
      //
      details::buffer data_value;
      std::size_t data_size;
      bool data_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 3UL;
    static const std::size_t id_column_count = 2UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char update_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];
    static const unsigned int update_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::public_key, id_common >:
    public access::object_traits_impl< ::brep::public_key, id_pgsql >
  {
  };

  // package_build_config
  //
  template <>
  class access::composite_value_traits< ::brep::package_build_config, id_pgsql >
  {
    public:
    typedef ::brep::package_build_config value_type;

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // arguments
      //
      details::buffer arguments_value;
      std::size_t arguments_size;
      bool arguments_null;

      // comment
      //
      details::buffer comment_value;
      std::size_t comment_size;
      bool comment_null;

      // email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type email_value;

      // warning_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type warning_email_value;

      // error_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type error_email_value;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 9UL;
  };

  // package_build_bot_key_key
  //
  template <>
  class access::composite_value_traits< ::brep::package_build_bot_key_key, id_pgsql >
  {
    public:
    typedef ::brep::package_build_bot_key_key value_type;

    struct image_type
    {
      // outer
      //
      long long outer_value;
      bool outer_null;

      // inner
      //
      long long inner_value;
      bool inner_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // reviews_summary
  //
  template <>
  class access::composite_value_traits< ::brep::reviews_summary, id_pgsql >
  {
    public:
    typedef ::brep::reviews_summary value_type;

    struct image_type
    {
      // pass
      //
      long long pass_value;
      bool pass_null;

      // fail
      //
      long long fail_value;
      bool fail_null;

      // manifest_file
      //
      details::buffer manifest_file_value;
      std::size_t manifest_file_size;
      bool manifest_file_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 3UL;
  };

  // _license_key
  //
  template <>
  class access::composite_value_traits< ::brep::package::_license_key, id_pgsql >
  {
    public:
    typedef ::brep::package::_license_key value_type;

    struct image_type
    {
      // outer
      //
      long long outer_value;
      bool outer_null;

      // inner
      //
      long long inner_value;
      bool inner_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // _dependency_alternative_key
  //
  template <>
  class access::composite_value_traits< ::brep::package::_dependency_alternative_key, id_pgsql >
  {
    public:
    typedef ::brep::package::_dependency_alternative_key value_type;

    struct image_type
    {
      // outer
      //
      long long outer_value;
      bool outer_null;

      // inner
      //
      long long inner_value;
      bool inner_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // _dependency_key
  //
  template <>
  class access::composite_value_traits< ::brep::package::_dependency_key, id_pgsql >
  {
    public:
    typedef ::brep::package::_dependency_key value_type;

    struct image_type
    {
      // outer
      //
      long long outer_value;
      bool outer_null;

      // middle
      //
      long long middle_value;
      bool middle_null;

      // inner
      //
      long long inner_value;
      bool inner_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 3UL;
  };

  // package
  //
  template <typename A>
  struct pointer_query_columns< ::brep::package, id_pgsql, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      name_type_;

      static const name_type_ name;

      // version
      //
      struct version_class_1_
      {
        version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        revision_type_;

        static const revision_type_ revision;
      };

      static const version_class_1_ version;
    };

    static const id_class_ id;

    // version
    //
    struct version_class_
    {
      version_class_ ()
      {
      }

      // upstream
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      release_type_;

      static const release_type_ release;
    };

    static const version_class_ version;

    // upstream_version
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    upstream_version_type_;

    static const upstream_version_type_ upstream_version;

    // project
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::bpkg::package_name,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    project_type_;

    static const project_type_ project;

    // priority
    //
    struct priority_class_
    {
      priority_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::bpkg::priority::value_type,
          pgsql::id_integer >::query_type,
        pgsql::id_integer >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const priority_class_ priority;

    // summary
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    summary_type_;

    static const summary_type_ summary;

    // description
    //
    struct description_class_
    {
      description_class_ ()
      {
      }

      // text
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      text_type_;

      static const text_type_ text;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;
    };

    static const description_class_ description;

    // package_description
    //
    struct package_description_class_
    {
      package_description_class_ ()
      {
      }

      // text
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      text_type_;

      static const text_type_ text;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;
    };

    static const package_description_class_ package_description;

    // changes
    //
    struct changes_class_
    {
      changes_class_ ()
      {
      }

      // text
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      text_type_;

      static const text_type_ text;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;
    };

    static const changes_class_ changes;

    // url
    //
    struct url_class_
    {
      url_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const url_class_ url;

    // doc_url
    //
    struct doc_url_class_
    {
      doc_url_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const doc_url_class_ doc_url;

    // src_url
    //
    struct src_url_class_
    {
      src_url_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const src_url_class_ src_url;

    // package_url
    //
    struct package_url_class_
    {
      package_url_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const package_url_class_ package_url;

    // email
    //
    struct email_class_
    {
      email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const email_class_ email;

    // package_email
    //
    struct package_email_class_
    {
      package_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const package_email_class_ package_email;

    // build_email
    //
    struct build_email_class_
    {
      build_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_email_class_ build_email;

    // build_warning_email
    //
    struct build_warning_email_class_
    {
      build_warning_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_warning_email_class_ build_warning_email;

    // build_error_email
    //
    struct build_error_email_class_
    {
      build_error_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_error_email_class_ build_error_email;

    // reviews
    //
    struct reviews_class_
    {
      reviews_class_ ()
      {
      }

      // pass
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::query_type,
        pgsql::id_bigint >
      pass_type_;

      static const pass_type_ pass;

      // fail
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::query_type,
        pgsql::id_bigint >
      fail_type_;

      static const fail_type_ fail;

      // manifest_file
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      manifest_file_type_;

      static const manifest_file_type_ manifest_file;
    };

    static const reviews_class_ reviews;

    // internal_repository
    //
    struct internal_repository_class_
    {
      internal_repository_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // canonical_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      canonical_name_type_;

      static const canonical_name_type_ canonical_name;
    };

    static const internal_repository_class_ internal_repository;

    // location
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    location_type_;

    static const location_type_ location;

    // fragment
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    fragment_type_;

    static const fragment_type_ fragment;

    // sha256sum
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    sha256sum_type_;

    static const sha256sum_type_ sha256sum;

    // buildable
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    buildable_type_;

    static const buildable_type_ buildable;

    // unbuildable_reason
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    unbuildable_reason_type_;

    static const unbuildable_reason_type_ unbuildable_reason;

    // custom_bot
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    custom_bot_type_;

    static const custom_bot_type_ custom_bot;

    // search_index
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::brep::weighted_text,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    search_index_type_;

    static const search_index_type_ search_index;
  };

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::tenant_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::
  tenant (A::table_name, "\"tenant\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::name_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::
  name (A::table_name, "\"name\"", "(?)::CITEXT");

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::epoch_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::
  epoch (A::table_name, "\"version_epoch\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::canonical_upstream_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::
  canonical_upstream (A::table_name, "\"version_canonical_upstream\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::canonical_release_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::
  canonical_release (A::table_name, "\"version_canonical_release\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::revision_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::
  revision (A::table_name, "\"version_revision\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_
  pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_::version;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::id_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::id;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::version_class_::upstream_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::version_class_::
  upstream (A::table_name, "\"version_upstream\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::version_class_::release_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::version_class_::
  release (A::table_name, "\"version_release\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::version_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::version;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::upstream_version_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  upstream_version (A::table_name, "\"upstream_version\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::project_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  project (A::table_name, "\"project\"", "(?)::CITEXT");

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::priority_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::priority_class_::
  value (A::table_name, "\"priority\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::priority_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::priority_class_::
  comment (A::table_name, "\"priority_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::priority_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::priority;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::summary_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  summary (A::table_name, "\"summary\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::description_class_::text_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::description_class_::
  text (A::table_name, "\"description\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::description_class_::type_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::description_class_::
  type (A::table_name, "\"description_type\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::description_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::description;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::package_description_class_::text_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::package_description_class_::
  text (A::table_name, "\"package_description\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::package_description_class_::type_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::package_description_class_::
  type (A::table_name, "\"package_description_type\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::package_description_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::package_description;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::changes_class_::text_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::changes_class_::
  text (A::table_name, "\"changes\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::changes_class_::type_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::changes_class_::
  type (A::table_name, "\"changes_type\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::changes_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::changes;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::url_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::url_class_::
  value (A::table_name, "\"url\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::url_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::url_class_::
  comment (A::table_name, "\"url_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::url_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::url;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::doc_url_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::doc_url_class_::
  value (A::table_name, "\"doc_url\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::doc_url_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::doc_url_class_::
  comment (A::table_name, "\"doc_url_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::doc_url_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::doc_url;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::src_url_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::src_url_class_::
  value (A::table_name, "\"src_url\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::src_url_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::src_url_class_::
  comment (A::table_name, "\"src_url_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::src_url_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::src_url;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::package_url_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::package_url_class_::
  value (A::table_name, "\"package_url\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::package_url_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::package_url_class_::
  comment (A::table_name, "\"package_url_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::package_url_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::package_url;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::email_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::email_class_::
  value (A::table_name, "\"email\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::email_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::email_class_::
  comment (A::table_name, "\"email_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::email_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::email;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::package_email_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::package_email_class_::
  value (A::table_name, "\"package_email\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::package_email_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::package_email_class_::
  comment (A::table_name, "\"package_email_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::package_email_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::package_email;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::build_email_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::build_email_class_::
  value (A::table_name, "\"build_email\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::build_email_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::build_email_class_::
  comment (A::table_name, "\"build_email_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::build_email_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::build_email;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_::
  value (A::table_name, "\"build_warning_email\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_::
  comment (A::table_name, "\"build_warning_email_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::build_warning_email;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_::value_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_::
  value (A::table_name, "\"build_error_email\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_::comment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_::
  comment (A::table_name, "\"build_error_email_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::build_error_email;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::reviews_class_::pass_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::reviews_class_::
  pass (A::table_name, "\"reviews_pass\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::reviews_class_::fail_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::reviews_class_::
  fail (A::table_name, "\"reviews_fail\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::reviews_class_::manifest_file_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::reviews_class_::
  manifest_file (A::table_name, "\"reviews_manifest_file\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::reviews_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::reviews;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::internal_repository_class_::tenant_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::internal_repository_class_::
  tenant (A::table_name, "\"internal_repository_tenant\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::internal_repository_class_::canonical_name_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::internal_repository_class_::
  canonical_name (A::table_name, "\"internal_repository_canonical_name\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::internal_repository_class_
  pointer_query_columns< ::brep::package, id_pgsql, A >::internal_repository;

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::location_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  location (A::table_name, "\"location\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::fragment_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  fragment (A::table_name, "\"fragment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::sha256sum_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  sha256sum (A::table_name, "\"sha256sum\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::buildable_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  buildable (A::table_name, "\"buildable\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::unbuildable_reason_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  unbuildable_reason (A::table_name, "\"unbuildable_reason\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::custom_bot_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  custom_bot (A::table_name, "\"custom_bot\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::package, id_pgsql, A >::search_index_type_
  pointer_query_columns< ::brep::package, id_pgsql, A >::
  search_index (A::table_name, "\"search_index\"", "to_tsvector((?)::weighted_text)");

  template <>
  class access::object_traits_impl< ::brep::package, id_pgsql >:
    public access::object_traits< ::brep::package >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type id_value;

      // version
      //
      composite_value_traits< ::brep::package::upstream_version_type, id_pgsql >::image_type version_value;

      // upstream_version
      //
      details::buffer upstream_version_value;
      std::size_t upstream_version_size;
      bool upstream_version_null;

      // project
      //
      details::buffer project_value;
      std::size_t project_size;
      bool project_null;

      // priority
      //
      composite_value_traits< ::brep::package::priority_type, id_pgsql >::image_type priority_value;

      // summary
      //
      details::buffer summary_value;
      std::size_t summary_size;
      bool summary_null;

      // description
      //
      composite_value_traits< ::brep::typed_text, id_pgsql >::image_type description_value;

      // package_description
      //
      composite_value_traits< ::brep::typed_text, id_pgsql >::image_type package_description_value;

      // changes
      //
      composite_value_traits< ::brep::typed_text, id_pgsql >::image_type changes_value;

      // url
      //
      composite_value_traits< ::bpkg::manifest_url, id_pgsql >::image_type url_value;

      // doc_url
      //
      composite_value_traits< ::bpkg::manifest_url, id_pgsql >::image_type doc_url_value;

      // src_url
      //
      composite_value_traits< ::bpkg::manifest_url, id_pgsql >::image_type src_url_value;

      // package_url
      //
      composite_value_traits< ::bpkg::manifest_url, id_pgsql >::image_type package_url_value;

      // email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type email_value;

      // package_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type package_email_value;

      // build_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type build_email_value;

      // build_warning_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type build_warning_email_value;

      // build_error_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type build_error_email_value;

      // reviews
      //
      composite_value_traits< ::brep::reviews_summary, id_pgsql >::image_type reviews_value;

      // internal_repository
      //
      composite_value_traits< ::brep::repository_id, id_pgsql >::image_type internal_repository_value;

      // location
      //
      details::buffer location_value;
      std::size_t location_size;
      bool location_null;

      // fragment
      //
      details::buffer fragment_value;
      std::size_t fragment_size;
      bool fragment_null;

      // sha256sum
      //
      details::buffer sha256sum_value;
      std::size_t sha256sum_size;
      bool sha256sum_null;

      // buildable
      //
      bool buildable_value;
      bool buildable_null;

      // unbuildable_reason
      //
      details::buffer unbuildable_reason_value;
      std::size_t unbuildable_reason_size;
      bool unbuildable_reason_null;

      // custom_bot
      //
      bool custom_bot_value;
      bool custom_bot_null;

      // search_index
      //
      details::buffer search_index_value;
      std::size_t search_index_size;
      bool search_index_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    // license_alternatives
    //
    struct license_alternatives_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 8UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package::license_alternatives_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< license_alternatives_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // licenses
    //
    struct licenses_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package::_licenses_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< licenses_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        details::buffer value_value;
        std::size_t value_size;
        bool value_null;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // topics
    //
    struct topics_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 8UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::butl::small_vector< ::std::basic_string< char >, 5 > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< topics_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        details::buffer value_value;
        std::size_t value_size;
        bool value_null;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // keywords
    //
    struct keywords_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 8UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::butl::small_vector< ::std::basic_string< char >, 5 > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< keywords_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        details::buffer value_value;
        std::size_t value_size;
        bool value_null;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // dependencies
    //
    struct dependencies_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package::dependencies_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< dependencies_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // dependency_alternatives
    //
    struct dependency_alternatives_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 13UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package::_dependency_alternatives_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< dependency_alternatives_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // dependency_alternative_dependencies
    //
    struct dependency_alternative_dependencies_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 30UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package::_dependency_alternative_dependencies_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< dependency_alternative_dependencies_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // requirements
    //
    struct requirements_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package::requirements_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< requirements_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // requirement_alternatives
    //
    struct requirement_alternatives_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::requirement_alternatives_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< requirement_alternatives_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // requirement_alternative_requirements
    //
    struct requirement_alternative_requirements_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::requirement_alternative_requirements_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< requirement_alternative_requirements_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        details::buffer value_value;
        std::size_t value_size;
        bool value_null;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // tests
    //
    struct tests_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 32UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::butl::small_vector< ::brep::test_dependency, 1 > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< tests_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // builds
    //
    struct builds_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_class_exprs container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< builds_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // build_constraints
    //
    struct build_constraints_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 11UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package::build_constraints_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< build_constraints_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // build_auxiliaries
    //
    struct build_auxiliaries_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package::build_auxiliaries_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< build_auxiliaries_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // build_bot_keys
    //
    struct build_bot_keys_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package_build_bot_keys container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< build_bot_keys_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< ::brep::public_key_id, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // build_configs
    //
    struct build_configs_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 16UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package_build_configs container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< build_configs_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // build_config_builds
    //
    struct build_config_builds_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_class_exprs_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< build_config_builds_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // build_config_constraints
    //
    struct build_config_constraints_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 12UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_constraints_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< build_config_constraints_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // build_config_auxiliaries
    //
    struct build_config_auxiliaries_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 11UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_auxiliaries_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< build_config_auxiliaries_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // build_config_bot_keys
    //
    struct build_config_bot_keys_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::package_build_bot_keys_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< build_config_bot_keys_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< ::brep::public_key_id, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // other_repositories
    //
    struct other_repositories_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::std::vector< ::odb::lazy_shared_ptr< ::brep::repository > > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< other_repositories_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< ::brep::repository_id, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // build_section
    //
    struct build_section_traits
    {
      typedef object_traits_impl<object_type, id_pgsql>::image_type image_type;
      typedef object_traits_impl<object_type, id_pgsql>::id_image_type id_image_type;

      static const std::size_t id_column_count = 6UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);

      static void
      update (extra_statement_cache_type&, const object_type&);
    };

    // unused_section
    //
    struct unused_section_traits
    {
      typedef object_traits_impl<object_type, id_pgsql>::image_type image_type;
      typedef object_traits_impl<object_type, id_pgsql>::id_image_type id_image_type;

      static const std::size_t id_column_count = 6UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);

      static void
      update (extra_statement_cache_type&, const object_type&);
    };

    // reviews_section
    //
    struct reviews_section_traits
    {
      typedef object_traits_impl<object_type, id_pgsql>::image_type image_type;
      typedef object_traits_impl<object_type, id_pgsql>::id_image_type id_image_type;

      static std::size_t
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            image_type&,
            pgsql::statement_kind);

      static bool
      grow (image_type&,
            bool*);

      static void
      init (object_type&,
            const image_type&,
            database*);

      static bool
      init (image_type&,
            const object_type&);

      static const std::size_t id_column_count = 6UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 3UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 3UL;

      static const bool versioned = false;

      static const char select_statement[];

      static const char update_statement[];

      typedef pgsql::section_statements< object_type, reviews_section_traits > statements_type;

      static void
      load (extra_statement_cache_type&, object_type&);

      static void
      update (extra_statement_cache_type&, const object_type&);

      static const char select_name[];

      static const char update_name[];

      static const unsigned int update_types[];
    };

    struct internal_repository_tag;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 49UL;
    static const std::size_t id_column_count = 6UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 3UL;
    static const std::size_t separate_update_column_count = 3UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static bool
    load (connection&, object_type&, section&);

    static bool
    update (connection&, const object_type&, const section&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char update_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];
    static const unsigned int update_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::package, id_common >:
    public access::object_traits_impl< ::brep::package, id_pgsql >
  {
  };

  // package_count
  //
  template <>
  class access::view_traits_impl< ::brep::package_count, id_pgsql >:
    public access::view_traits< ::brep::package_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::package_count, id_common >:
    public access::view_traits_impl< ::brep::package_count, id_pgsql >
  {
  };

  // latest_package_search_rank
  //
  template <>
  class access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >:
    public access::view_traits< ::brep::latest_package_search_rank >
  {
    public:
    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type id_value;

      // rank
      //
      double rank_value;
      bool rank_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns
    {
    };

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 7UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::latest_package_search_rank, id_common >:
    public access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >
  {
  };

  // latest_package_count
  //
  template <>
  class access::view_traits_impl< ::brep::latest_package_count, id_pgsql >:
    public access::view_traits< ::brep::latest_package_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns
    {
    };

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::latest_package_count, id_common >:
    public access::view_traits_impl< ::brep::latest_package_count, id_pgsql >
  {
  };

  // package_search_rank
  //
  template <>
  class access::view_traits_impl< ::brep::package_search_rank, id_pgsql >:
    public access::view_traits< ::brep::package_search_rank >
  {
    public:
    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type id_value;

      // rank
      //
      double rank_value;
      bool rank_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns
    {
    };

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 7UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::package_search_rank, id_common >:
    public access::view_traits_impl< ::brep::package_search_rank, id_pgsql >
  {
  };

  // package_search_count
  //
  template <>
  class access::view_traits_impl< ::brep::package_search_count, id_pgsql >:
    public access::view_traits< ::brep::package_search_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns
    {
    };

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::package_search_count, id_common >:
    public access::view_traits_impl< ::brep::package_search_count, id_pgsql >
  {
  };

  // latest_package
  //
  template <>
  class access::view_traits_impl< ::brep::latest_package, id_pgsql >:
    public access::view_traits< ::brep::latest_package >
  {
    public:
    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns
    {
    };

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 6UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::latest_package, id_common >:
    public access::view_traits_impl< ::brep::latest_package, id_pgsql >
  {
  };

  // tenant
  //
  // tenant_id
  //
  struct access::view_traits_impl< ::brep::tenant_id, id_pgsql >::query_columns:
    odb::pointer_query_columns<
      ::brep::tenant,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::tenant, id_pgsql > >
  {
  };

  // repository
  //
  // repository_count
  //
  struct access::view_traits_impl< ::brep::repository_count, id_pgsql >::query_columns:
    odb::pointer_query_columns<
      ::brep::repository,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::repository, id_pgsql > >
  {
  };

  // public_key
  //
  // package
  //
  template <>
  struct alias_traits<
    ::brep::repository,
    id_pgsql,
    access::object_traits_impl< ::brep::package, id_pgsql >::internal_repository_tag>
  {
    static const char table_name[];
  };

  template <>
  struct query_columns_base< ::brep::package, id_pgsql >
  {
    // internal_repository
    //
    typedef
    odb::alias_traits<
      ::brep::repository,
      id_pgsql,
      access::object_traits_impl< ::brep::package, id_pgsql >::internal_repository_tag>
    internal_repository_alias_;
  };

  template <typename A>
  struct query_columns< ::brep::package, id_pgsql, A >:
    query_columns_base< ::brep::package, id_pgsql >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      name_type_;

      static const name_type_ name;

      // version
      //
      struct version_class_1_
      {
        version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        revision_type_;

        static const revision_type_ revision;
      };

      static const version_class_1_ version;
    };

    static const id_class_ id;

    // version
    //
    struct version_class_
    {
      version_class_ ()
      {
      }

      // upstream
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      release_type_;

      static const release_type_ release;
    };

    static const version_class_ version;

    // upstream_version
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    upstream_version_type_;

    static const upstream_version_type_ upstream_version;

    // project
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::bpkg::package_name,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    project_type_;

    static const project_type_ project;

    // priority
    //
    struct priority_class_
    {
      priority_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::bpkg::priority::value_type,
          pgsql::id_integer >::query_type,
        pgsql::id_integer >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const priority_class_ priority;

    // summary
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    summary_type_;

    static const summary_type_ summary;

    // description
    //
    struct description_class_
    {
      description_class_ ()
      {
      }

      // text
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      text_type_;

      static const text_type_ text;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;
    };

    static const description_class_ description;

    // package_description
    //
    struct package_description_class_
    {
      package_description_class_ ()
      {
      }

      // text
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      text_type_;

      static const text_type_ text;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;
    };

    static const package_description_class_ package_description;

    // changes
    //
    struct changes_class_
    {
      changes_class_ ()
      {
      }

      // text
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      text_type_;

      static const text_type_ text;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;
    };

    static const changes_class_ changes;

    // url
    //
    struct url_class_
    {
      url_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const url_class_ url;

    // doc_url
    //
    struct doc_url_class_
    {
      doc_url_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const doc_url_class_ doc_url;

    // src_url
    //
    struct src_url_class_
    {
      src_url_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const src_url_class_ src_url;

    // package_url
    //
    struct package_url_class_
    {
      package_url_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const package_url_class_ package_url;

    // email
    //
    struct email_class_
    {
      email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const email_class_ email;

    // package_email
    //
    struct package_email_class_
    {
      package_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const package_email_class_ package_email;

    // build_email
    //
    struct build_email_class_
    {
      build_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_email_class_ build_email;

    // build_warning_email
    //
    struct build_warning_email_class_
    {
      build_warning_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_warning_email_class_ build_warning_email;

    // build_error_email
    //
    struct build_error_email_class_
    {
      build_error_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_error_email_class_ build_error_email;

    // reviews
    //
    struct reviews_class_
    {
      reviews_class_ ()
      {
      }

      // pass
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::query_type,
        pgsql::id_bigint >
      pass_type_;

      static const pass_type_ pass;

      // fail
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::query_type,
        pgsql::id_bigint >
      fail_type_;

      static const fail_type_ fail;

      // manifest_file
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      manifest_file_type_;

      static const manifest_file_type_ manifest_file;
    };

    static const reviews_class_ reviews;

    // internal_repository
    //
    struct internal_repository_column_class_
    {
      internal_repository_column_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // canonical_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      canonical_name_type_;

      static const canonical_name_type_ canonical_name;
    };

    typedef
    odb::query_pointer<
      odb::pointer_query_columns<
        ::brep::repository,
        id_pgsql,
        internal_repository_alias_ > >
    internal_repository_pointer_type_;

    struct internal_repository_type_: internal_repository_pointer_type_, internal_repository_column_class_
    {
      internal_repository_type_ ()
      {
      }
    };

    static const internal_repository_type_ internal_repository;

    // location
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    location_type_;

    static const location_type_ location;

    // fragment
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    fragment_type_;

    static const fragment_type_ fragment;

    // sha256sum
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    sha256sum_type_;

    static const sha256sum_type_ sha256sum;

    // buildable
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    buildable_type_;

    static const buildable_type_ buildable;

    // unbuildable_reason
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    unbuildable_reason_type_;

    static const unbuildable_reason_type_ unbuildable_reason;

    // custom_bot
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    custom_bot_type_;

    static const custom_bot_type_ custom_bot;

    // search_index
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::brep::weighted_text,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    search_index_type_;

    static const search_index_type_ search_index;
  };

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::id_class_::tenant_type_
  query_columns< ::brep::package, id_pgsql, A >::id_class_::
  tenant (A::table_name, "\"tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::id_class_::name_type_
  query_columns< ::brep::package, id_pgsql, A >::id_class_::
  name (A::table_name, "\"name\"", "(?)::CITEXT");

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::epoch_type_
  query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::
  epoch (A::table_name, "\"version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::canonical_upstream_type_
  query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::
  canonical_upstream (A::table_name, "\"version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::canonical_release_type_
  query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::
  canonical_release (A::table_name, "\"version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::revision_type_
  query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_::
  revision (A::table_name, "\"version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::id_class_::version_class_1_
  query_columns< ::brep::package, id_pgsql, A >::id_class_::version;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::id_class_
  query_columns< ::brep::package, id_pgsql, A >::id;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::version_class_::upstream_type_
  query_columns< ::brep::package, id_pgsql, A >::version_class_::
  upstream (A::table_name, "\"version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::version_class_::release_type_
  query_columns< ::brep::package, id_pgsql, A >::version_class_::
  release (A::table_name, "\"version_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::version_class_
  query_columns< ::brep::package, id_pgsql, A >::version;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::upstream_version_type_
  query_columns< ::brep::package, id_pgsql, A >::
  upstream_version (A::table_name, "\"upstream_version\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::project_type_
  query_columns< ::brep::package, id_pgsql, A >::
  project (A::table_name, "\"project\"", "(?)::CITEXT");

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::priority_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::priority_class_::
  value (A::table_name, "\"priority\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::priority_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::priority_class_::
  comment (A::table_name, "\"priority_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::priority_class_
  query_columns< ::brep::package, id_pgsql, A >::priority;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::summary_type_
  query_columns< ::brep::package, id_pgsql, A >::
  summary (A::table_name, "\"summary\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::description_class_::text_type_
  query_columns< ::brep::package, id_pgsql, A >::description_class_::
  text (A::table_name, "\"description\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::description_class_::type_type_
  query_columns< ::brep::package, id_pgsql, A >::description_class_::
  type (A::table_name, "\"description_type\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::description_class_
  query_columns< ::brep::package, id_pgsql, A >::description;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::package_description_class_::text_type_
  query_columns< ::brep::package, id_pgsql, A >::package_description_class_::
  text (A::table_name, "\"package_description\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::package_description_class_::type_type_
  query_columns< ::brep::package, id_pgsql, A >::package_description_class_::
  type (A::table_name, "\"package_description_type\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::package_description_class_
  query_columns< ::brep::package, id_pgsql, A >::package_description;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::changes_class_::text_type_
  query_columns< ::brep::package, id_pgsql, A >::changes_class_::
  text (A::table_name, "\"changes\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::changes_class_::type_type_
  query_columns< ::brep::package, id_pgsql, A >::changes_class_::
  type (A::table_name, "\"changes_type\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::changes_class_
  query_columns< ::brep::package, id_pgsql, A >::changes;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::url_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::url_class_::
  value (A::table_name, "\"url\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::url_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::url_class_::
  comment (A::table_name, "\"url_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::url_class_
  query_columns< ::brep::package, id_pgsql, A >::url;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::doc_url_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::doc_url_class_::
  value (A::table_name, "\"doc_url\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::doc_url_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::doc_url_class_::
  comment (A::table_name, "\"doc_url_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::doc_url_class_
  query_columns< ::brep::package, id_pgsql, A >::doc_url;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::src_url_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::src_url_class_::
  value (A::table_name, "\"src_url\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::src_url_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::src_url_class_::
  comment (A::table_name, "\"src_url_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::src_url_class_
  query_columns< ::brep::package, id_pgsql, A >::src_url;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::package_url_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::package_url_class_::
  value (A::table_name, "\"package_url\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::package_url_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::package_url_class_::
  comment (A::table_name, "\"package_url_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::package_url_class_
  query_columns< ::brep::package, id_pgsql, A >::package_url;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::email_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::email_class_::
  value (A::table_name, "\"email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::email_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::email_class_::
  comment (A::table_name, "\"email_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::email_class_
  query_columns< ::brep::package, id_pgsql, A >::email;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::package_email_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::package_email_class_::
  value (A::table_name, "\"package_email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::package_email_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::package_email_class_::
  comment (A::table_name, "\"package_email_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::package_email_class_
  query_columns< ::brep::package, id_pgsql, A >::package_email;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::build_email_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::build_email_class_::
  value (A::table_name, "\"build_email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::build_email_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::build_email_class_::
  comment (A::table_name, "\"build_email_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::build_email_class_
  query_columns< ::brep::package, id_pgsql, A >::build_email;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_::
  value (A::table_name, "\"build_warning_email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_::
  comment (A::table_name, "\"build_warning_email_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::build_warning_email_class_
  query_columns< ::brep::package, id_pgsql, A >::build_warning_email;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_::value_type_
  query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_::
  value (A::table_name, "\"build_error_email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_::comment_type_
  query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_::
  comment (A::table_name, "\"build_error_email_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::build_error_email_class_
  query_columns< ::brep::package, id_pgsql, A >::build_error_email;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::reviews_class_::pass_type_
  query_columns< ::brep::package, id_pgsql, A >::reviews_class_::
  pass (A::table_name, "\"reviews_pass\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::reviews_class_::fail_type_
  query_columns< ::brep::package, id_pgsql, A >::reviews_class_::
  fail (A::table_name, "\"reviews_fail\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::reviews_class_::manifest_file_type_
  query_columns< ::brep::package, id_pgsql, A >::reviews_class_::
  manifest_file (A::table_name, "\"reviews_manifest_file\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::reviews_class_
  query_columns< ::brep::package, id_pgsql, A >::reviews;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::internal_repository_column_class_::tenant_type_
  query_columns< ::brep::package, id_pgsql, A >::internal_repository_column_class_::
  tenant (A::table_name, "\"internal_repository_tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::internal_repository_column_class_::canonical_name_type_
  query_columns< ::brep::package, id_pgsql, A >::internal_repository_column_class_::
  canonical_name (A::table_name, "\"internal_repository_canonical_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::internal_repository_type_
  query_columns< ::brep::package, id_pgsql, A >::internal_repository;

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::location_type_
  query_columns< ::brep::package, id_pgsql, A >::
  location (A::table_name, "\"location\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::fragment_type_
  query_columns< ::brep::package, id_pgsql, A >::
  fragment (A::table_name, "\"fragment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::sha256sum_type_
  query_columns< ::brep::package, id_pgsql, A >::
  sha256sum (A::table_name, "\"sha256sum\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::buildable_type_
  query_columns< ::brep::package, id_pgsql, A >::
  buildable (A::table_name, "\"buildable\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::unbuildable_reason_type_
  query_columns< ::brep::package, id_pgsql, A >::
  unbuildable_reason (A::table_name, "\"unbuildable_reason\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::custom_bot_type_
  query_columns< ::brep::package, id_pgsql, A >::
  custom_bot (A::table_name, "\"custom_bot\"", 0);

  template <typename A>
  const typename query_columns< ::brep::package, id_pgsql, A >::search_index_type_
  query_columns< ::brep::package, id_pgsql, A >::
  search_index (A::table_name, "\"search_index\"", "to_tsvector((?)::weighted_text)");

  // package_count
  //
  struct access::view_traits_impl< ::brep::package_count, id_pgsql >::query_columns:
    odb::pointer_query_columns<
      ::brep::package,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::package, id_pgsql > >
  {
  };
}

#include <libbrep/package-odb.ixx>

#include <odb/post.hxx>

#endif // LIBBREP_PACKAGE_ODB_HXX
