// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#ifndef LIBBREP_BUILD_PACKAGE_ODB_HXX
#define LIBBREP_BUILD_PACKAGE_ODB_HXX

#include <odb/version.hxx>

#if ODB_VERSION != 20500UL
#error ODB runtime version mismatch
#endif

#include <odb/pre.hxx>

#include <libbrep/build-package.hxx>

#include <libbrep/common-odb.hxx>

#include <memory>
#include <cstddef>
#include <utility>

#include <odb/core.hxx>
#include <odb/traits.hxx>
#include <odb/callback.hxx>
#include <odb/wrapper-traits.hxx>
#include <odb/pointer-traits.hxx>
#include <odb/container-traits.hxx>
#include <odb/session.hxx>
#include <odb/cache-traits.hxx>
#include <odb/prepared-query.hxx>
#include <odb/result.hxx>
#include <odb/simple-object-result.hxx>
#include <odb/view-image.hxx>
#include <odb/view-result.hxx>

#include <odb/details/unused.hxx>
#include <odb/details/shared-ptr.hxx>

namespace odb
{
  // build_tenant
  //
  template <>
  struct class_traits< ::brep::build_tenant >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::build_tenant >
  {
    public:
    typedef ::brep::build_tenant object_type;
    typedef ::std::shared_ptr< ::brep::build_tenant > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::std::string id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    no_op_pointer_cache_traits<pointer_type>
    pointer_cache_traits;

    typedef
    no_op_reference_cache_traits<object_type>
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // build_repository
  //
  template <>
  struct class_traits< ::brep::build_repository >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::build_repository >
  {
    public:
    typedef ::brep::build_repository object_type;
    typedef ::std::shared_ptr< ::brep::build_repository > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::brep::repository_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    no_op_pointer_cache_traits<pointer_type>
    pointer_cache_traits;

    typedef
    no_op_reference_cache_traits<object_type>
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // build_public_key
  //
  template <>
  struct class_traits< ::brep::build_public_key >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::build_public_key >
  {
    public:
    typedef ::brep::build_public_key object_type;
    typedef ::std::shared_ptr< ::brep::build_public_key > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::brep::public_key_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    no_op_pointer_cache_traits<pointer_type>
    pointer_cache_traits;

    typedef
    no_op_reference_cache_traits<object_type>
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // build_package
  //
  template <>
  struct class_traits< ::brep::build_package >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::build_package >
  {
    public:
    typedef ::brep::build_package object_type;
    typedef ::std::shared_ptr< ::brep::build_package > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::brep::package_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // build_package_version
  //
  template <>
  struct class_traits< ::brep::build_package_version >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::build_package_version >
  {
    public:
    typedef ::brep::build_package_version view_type;
    typedef ::brep::build_package_version* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // buildable_package
  //
  template <>
  struct class_traits< ::brep::buildable_package >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::buildable_package >
  {
    public:
    typedef ::brep::buildable_package view_type;
    typedef ::brep::buildable_package* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // buildable_package_count
  //
  template <>
  struct class_traits< ::brep::buildable_package_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::buildable_package_count >
  {
    public:
    typedef ::brep::buildable_package_count view_type;
    typedef ::brep::buildable_package_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };
}

#include <odb/details/buffer.hxx>

#include <odb/pgsql/version.hxx>
#include <odb/pgsql/forward.hxx>
#include <odb/pgsql/binding.hxx>
#include <odb/pgsql/pgsql-types.hxx>
#include <odb/pgsql/query.hxx>

namespace odb
{
  // build_tenant
  //
  template <typename A>
  struct query_columns< ::brep::build_tenant, id_pgsql, A >
  {
    // id
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    id_type_;

    static const id_type_ id;

    // private_
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    private__type_;

    static const private__type_ private_;

    // interactive
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    interactive_type_;

    static const interactive_type_ interactive;

    // creation_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    creation_timestamp_type_;

    static const creation_timestamp_type_ creation_timestamp;

    // archived
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    archived_type_;

    static const archived_type_ archived;

    // service
    //
    struct service_class_
    {
      service_class_ ()
      {
      }

      // id
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      id_type_;

      static const id_type_ id;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;

      // ref_count
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::query_type,
        pgsql::id_bigint >
      ref_count_type_;

      static const ref_count_type_ ref_count;

      // data
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      data_type_;

      static const data_type_ data;
    };

    static const service_class_ service;

    // unloaded_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        long unsigned int,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    unloaded_timestamp_type_;

    static const unloaded_timestamp_type_ unloaded_timestamp;

    // unloaded_notify_interval
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        long unsigned int,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    unloaded_notify_interval_type_;

    static const unloaded_notify_interval_type_ unloaded_notify_interval;

    // queued_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        long unsigned int,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    queued_timestamp_type_;

    static const queued_timestamp_type_ queued_timestamp;

    // toolchain
    //
    struct toolchain_class_
    {
      toolchain_class_ ()
      {
      }

      // name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      name_type_;

      static const name_type_ name;

      // version
      //
      struct version_class_1_
      {
        version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            short unsigned int,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        revision_type_;

        static const revision_type_ revision;

        // upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        upstream_type_;

        static const upstream_type_ upstream;

        // release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::basic_string< char >,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        release_type_;

        static const release_type_ release;
      };

      static const version_class_1_ version;
    };

    static const toolchain_class_ toolchain;
  };

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::id_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::
  id (A::table_name, "\"id\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::private__type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::
  private_ (A::table_name, "\"private\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::interactive_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::
  interactive (A::table_name, "\"interactive\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::creation_timestamp_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::
  creation_timestamp (A::table_name, "\"creation_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::archived_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::
  archived (A::table_name, "\"archived\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::service_class_::id_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::service_class_::
  id (A::table_name, "\"service_id\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::service_class_::type_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::service_class_::
  type (A::table_name, "\"service_type\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::service_class_::ref_count_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::service_class_::
  ref_count (A::table_name, "\"service_ref_count\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::service_class_::data_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::service_class_::
  data (A::table_name, "\"service_data\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::service_class_
  query_columns< ::brep::build_tenant, id_pgsql, A >::service;

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::unloaded_timestamp_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::
  unloaded_timestamp (A::table_name, "\"unloaded_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::unloaded_notify_interval_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::
  unloaded_notify_interval (A::table_name, "\"unloaded_notify_interval\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::queued_timestamp_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::
  queued_timestamp (A::table_name, "\"queued_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::name_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::
  name (A::table_name, "\"toolchain_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::epoch_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::
  epoch (A::table_name, "\"toolchain_version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::canonical_upstream_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::
  canonical_upstream (A::table_name, "\"toolchain_version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::canonical_release_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::
  canonical_release (A::table_name, "\"toolchain_version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::revision_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::
  revision (A::table_name, "\"toolchain_version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::upstream_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::
  upstream (A::table_name, "\"toolchain_version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::release_type_
  query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_::
  release (A::table_name, "\"toolchain_version_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version_class_1_
  query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_::version;

  template <typename A>
  const typename query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain_class_
  query_columns< ::brep::build_tenant, id_pgsql, A >::toolchain;

  template <typename A>
  struct pointer_query_columns< ::brep::build_tenant, id_pgsql, A >:
    query_columns< ::brep::build_tenant, id_pgsql, A >
  {
  };

  template <>
  class access::object_traits_impl< ::brep::build_tenant, id_pgsql >:
    public access::object_traits< ::brep::build_tenant >
  {
    public:
    struct id_image_type
    {
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      // private_
      //
      bool private_value;
      bool private_null;

      // interactive
      //
      details::buffer interactive_value;
      std::size_t interactive_size;
      bool interactive_null;

      // creation_timestamp
      //
      long long creation_timestamp_value;
      bool creation_timestamp_null;

      // archived
      //
      bool archived_value;
      bool archived_null;

      // service
      //
      composite_value_traits< ::brep::tenant_service, id_pgsql >::image_type service_value;

      // unloaded_timestamp
      //
      long long unloaded_timestamp_value;
      bool unloaded_timestamp_null;

      // unloaded_notify_interval
      //
      long long unloaded_notify_interval_value;
      bool unloaded_notify_interval_null;

      // queued_timestamp
      //
      long long queued_timestamp_value;
      bool queued_timestamp_null;

      // toolchain
      //
      composite_value_traits< ::brep::build_toolchain, id_pgsql >::image_type toolchain_value;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 19UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char update_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];
    static const unsigned int update_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::build_tenant, id_common >:
    public access::object_traits_impl< ::brep::build_tenant, id_pgsql >
  {
  };

  // build_repository
  //
  template <typename A>
  struct query_columns< ::brep::build_repository, id_pgsql, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // canonical_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      canonical_name_type_;

      static const canonical_name_type_ canonical_name;
    };

    static const id_class_ id;

    // location
    //
    struct location_class_
    {
      location_class_ ()
      {
      }

      // url
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      url_type_;

      static const url_type_ url;

      // type
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      type_type_;

      static const type_type_ type;
    };

    static const location_class_ location;

    // certificate_fingerprint
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    certificate_fingerprint_type_;

    static const certificate_fingerprint_type_ certificate_fingerprint;
  };

  template <typename A>
  const typename query_columns< ::brep::build_repository, id_pgsql, A >::id_class_::tenant_type_
  query_columns< ::brep::build_repository, id_pgsql, A >::id_class_::
  tenant (A::table_name, "\"tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_repository, id_pgsql, A >::id_class_::canonical_name_type_
  query_columns< ::brep::build_repository, id_pgsql, A >::id_class_::
  canonical_name (A::table_name, "\"canonical_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_repository, id_pgsql, A >::id_class_
  query_columns< ::brep::build_repository, id_pgsql, A >::id;

  template <typename A>
  const typename query_columns< ::brep::build_repository, id_pgsql, A >::location_class_::url_type_
  query_columns< ::brep::build_repository, id_pgsql, A >::location_class_::
  url (A::table_name, "\"location_url\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_repository, id_pgsql, A >::location_class_::type_type_
  query_columns< ::brep::build_repository, id_pgsql, A >::location_class_::
  type (A::table_name, "\"location_type\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_repository, id_pgsql, A >::location_class_
  query_columns< ::brep::build_repository, id_pgsql, A >::location;

  template <typename A>
  const typename query_columns< ::brep::build_repository, id_pgsql, A >::certificate_fingerprint_type_
  query_columns< ::brep::build_repository, id_pgsql, A >::
  certificate_fingerprint (A::table_name, "\"certificate_fingerprint\"", 0);

  template <typename A>
  struct pointer_query_columns< ::brep::build_repository, id_pgsql, A >:
    query_columns< ::brep::build_repository, id_pgsql, A >
  {
  };

  template <>
  class access::object_traits_impl< ::brep::build_repository, id_pgsql >:
    public access::object_traits< ::brep::build_repository >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::brep::repository_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::repository_id, id_pgsql >::image_type id_value;

      // location
      //
      composite_value_traits< ::brep::_repository_location, id_pgsql >::image_type location_value;

      // certificate_fingerprint
      //
      details::buffer certificate_fingerprint_value;
      std::size_t certificate_fingerprint_size;
      bool certificate_fingerprint_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 5UL;
    static const std::size_t id_column_count = 2UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 3UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::build_repository, id_common >:
    public access::object_traits_impl< ::brep::build_repository, id_pgsql >
  {
  };

  // build_public_key
  //
  template <typename A>
  struct query_columns< ::brep::build_public_key, id_pgsql, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // fingerprint
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      fingerprint_type_;

      static const fingerprint_type_ fingerprint;
    };

    static const id_class_ id;

    // data
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    data_type_;

    static const data_type_ data;
  };

  template <typename A>
  const typename query_columns< ::brep::build_public_key, id_pgsql, A >::id_class_::tenant_type_
  query_columns< ::brep::build_public_key, id_pgsql, A >::id_class_::
  tenant (A::table_name, "\"tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_public_key, id_pgsql, A >::id_class_::fingerprint_type_
  query_columns< ::brep::build_public_key, id_pgsql, A >::id_class_::
  fingerprint (A::table_name, "\"fingerprint\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_public_key, id_pgsql, A >::id_class_
  query_columns< ::brep::build_public_key, id_pgsql, A >::id;

  template <typename A>
  const typename query_columns< ::brep::build_public_key, id_pgsql, A >::data_type_
  query_columns< ::brep::build_public_key, id_pgsql, A >::
  data (A::table_name, "\"data\"", 0);

  template <typename A>
  struct pointer_query_columns< ::brep::build_public_key, id_pgsql, A >:
    query_columns< ::brep::build_public_key, id_pgsql, A >
  {
  };

  template <>
  class access::object_traits_impl< ::brep::build_public_key, id_pgsql >:
    public access::object_traits< ::brep::build_public_key >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::brep::public_key_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::public_key_id, id_pgsql >::image_type id_value;

      // data
      //
      details::buffer data_value;
      std::size_t data_size;
      bool data_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 3UL;
    static const std::size_t id_column_count = 2UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 1UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::build_public_key, id_common >:
    public access::object_traits_impl< ::brep::build_public_key, id_pgsql >
  {
  };

  // build_package_config
  //
  template <>
  class access::composite_value_traits< ::brep::build_package_config, id_pgsql >
  {
    public:
    typedef ::brep::build_package_config value_type;

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // arguments
      //
      details::buffer arguments_value;
      std::size_t arguments_size;
      bool arguments_null;

      // comment
      //
      details::buffer comment_value;
      std::size_t comment_size;
      bool comment_null;

      // email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type email_value;

      // warning_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type warning_email_value;

      // error_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type error_email_value;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 9UL;
  };

  // build_package_bot_key_key
  //
  template <>
  class access::composite_value_traits< ::brep::build_package_bot_key_key, id_pgsql >
  {
    public:
    typedef ::brep::build_package_bot_key_key value_type;

    struct image_type
    {
      // outer
      //
      long long outer_value;
      bool outer_null;

      // inner
      //
      long long inner_value;
      bool inner_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // build_dependency
  //
  template <>
  class access::composite_value_traits< ::brep::build_dependency, id_pgsql >
  {
    public:
    typedef ::brep::build_dependency value_type;

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // constraint
      //
      composite_value_traits< ::bpkg::version_constraint, id_pgsql >::image_type constraint_value;

      // package
      //
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type package_value;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 21UL;
  };

  // build_test_dependency
  //
  template <>
  class access::composite_value_traits< ::brep::build_test_dependency, id_pgsql >
  {
    public:
    typedef ::brep::build_test_dependency value_type;

    struct image_type: composite_value_traits< ::brep::build_dependency, id_pgsql >::image_type
    {
      // type
      //
      details::buffer type_value;
      std::size_t type_size;
      bool type_null;

      // buildtime
      //
      bool buildtime_value;
      bool buildtime_null;

      // enable
      //
      details::buffer enable_value;
      std::size_t enable_size;
      bool enable_null;

      // reflect
      //
      details::buffer reflect_value;
      std::size_t reflect_size;
      bool reflect_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 25UL;
  };

  // build_package
  //
  template <typename A>
  struct pointer_query_columns< ::brep::build_package, id_pgsql, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      name_type_;

      static const name_type_ name;

      // version
      //
      struct version_class_1_
      {
        version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        revision_type_;

        static const revision_type_ revision;
      };

      static const version_class_1_ version;
    };

    static const id_class_ id;

    // version
    //
    struct version_class_
    {
      version_class_ ()
      {
      }

      // upstream
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      release_type_;

      static const release_type_ release;
    };

    static const version_class_ version;

    // project
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::bpkg::package_name,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    project_type_;

    static const project_type_ project;

    // build_email
    //
    struct build_email_class_
    {
      build_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_email_class_ build_email;

    // build_warning_email
    //
    struct build_warning_email_class_
    {
      build_warning_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_warning_email_class_ build_warning_email;

    // build_error_email
    //
    struct build_error_email_class_
    {
      build_error_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_error_email_class_ build_error_email;

    // internal_repository
    //
    struct internal_repository_class_
    {
      internal_repository_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // canonical_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      canonical_name_type_;

      static const canonical_name_type_ canonical_name;
    };

    static const internal_repository_class_ internal_repository;

    // buildable
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    buildable_type_;

    static const buildable_type_ buildable;

    // custom_bot
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    custom_bot_type_;

    static const custom_bot_type_ custom_bot;
  };

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::tenant_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::
  tenant (A::table_name, "\"tenant\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::name_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::
  name (A::table_name, "\"name\"", "(?)::CITEXT");

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::epoch_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::
  epoch (A::table_name, "\"version_epoch\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::canonical_upstream_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::
  canonical_upstream (A::table_name, "\"version_canonical_upstream\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::canonical_release_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::
  canonical_release (A::table_name, "\"version_canonical_release\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::revision_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::
  revision (A::table_name, "\"version_revision\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version;

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::id_class_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::id;

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::version_class_::upstream_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::version_class_::
  upstream (A::table_name, "\"version_upstream\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::version_class_::release_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::version_class_::
  release (A::table_name, "\"version_release\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::version_class_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::version;

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::project_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::
  project (A::table_name, "\"project\"", "(?)::CITEXT");

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_::value_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_::
  value (A::table_name, "\"build_email\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_::comment_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_::
  comment (A::table_name, "\"build_email_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_email;

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_::value_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_::
  value (A::table_name, "\"build_warning_email\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_::comment_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_::
  comment (A::table_name, "\"build_warning_email_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email;

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_::value_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_::
  value (A::table_name, "\"build_error_email\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_::comment_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_::
  comment (A::table_name, "\"build_error_email_comment\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::build_error_email;

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_class_::tenant_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_class_::
  tenant (A::table_name, "\"internal_repository_tenant\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_class_::canonical_name_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_class_::
  canonical_name (A::table_name, "\"internal_repository_canonical_name\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_class_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::internal_repository;

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::buildable_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::
  buildable (A::table_name, "\"buildable\"", 0);

  template <typename A>
  const typename pointer_query_columns< ::brep::build_package, id_pgsql, A >::custom_bot_type_
  pointer_query_columns< ::brep::build_package, id_pgsql, A >::
  custom_bot (A::table_name, "\"custom_bot\"", 0);

  template <>
  class access::object_traits_impl< ::brep::build_package, id_pgsql >:
    public access::object_traits< ::brep::build_package >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type id_value;

      // version
      //
      composite_value_traits< ::brep::upstream_version, id_pgsql >::image_type version_value;

      // project
      //
      details::buffer project_value;
      std::size_t project_size;
      bool project_null;

      // build_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type build_email_value;

      // build_warning_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type build_warning_email_value;

      // build_error_email
      //
      composite_value_traits< ::bpkg::email, id_pgsql >::image_type build_error_email_value;

      // internal_repository
      //
      composite_value_traits< ::brep::repository_id, id_pgsql >::image_type internal_repository_value;

      // buildable
      //
      bool buildable_value;
      bool buildable_null;

      // custom_bot
      //
      bool custom_bot_value;
      bool custom_bot_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    // requirements
    //
    struct requirements_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_package::requirements_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< requirements_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // requirement_alternatives
    //
    struct requirement_alternatives_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::requirement_alternatives_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< requirement_alternatives_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // requirement_alternative_requirements
    //
    struct requirement_alternative_requirements_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::requirement_alternative_requirements_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< requirement_alternative_requirements_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        details::buffer value_value;
        std::size_t value_size;
        bool value_null;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // tests
    //
    struct tests_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 32UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::butl::small_vector< ::brep::build_test_dependency, 1 > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< tests_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // builds
    //
    struct builds_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_class_exprs container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< builds_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // constraints
    //
    struct constraints_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 11UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_constraints container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< constraints_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // auxiliaries
    //
    struct auxiliaries_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_auxiliaries container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< auxiliaries_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // bot_keys
    //
    struct bot_keys_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_package_bot_keys container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< bot_keys_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< ::brep::public_key_id, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // configs
    //
    struct configs_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 16UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_package_configs container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< configs_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // config_builds
    //
    struct config_builds_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_class_exprs_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< config_builds_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // config_constraints
    //
    struct config_constraints_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 12UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_constraints_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< config_constraints_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // config_auxiliaries
    //
    struct config_auxiliaries_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 11UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_auxiliaries_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< config_auxiliaries_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // config_bot_keys
    //
    struct config_bot_keys_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::brep::build_package_bot_keys_map container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef pgsql::container_statements< config_bot_keys_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_pgsql >::image_type key_value;

        // value
        //
        composite_value_traits< ::brep::public_key_id, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      erase (statements_type&);
    };

    // requirements_tests_section
    //
    struct requirements_tests_section_traits
    {
      typedef object_traits_impl<object_type, id_pgsql>::image_type image_type;
      typedef object_traits_impl<object_type, id_pgsql>::id_image_type id_image_type;

      static const std::size_t id_column_count = 6UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);
    };

    // constraints_section
    //
    struct constraints_section_traits
    {
      typedef object_traits_impl<object_type, id_pgsql>::image_type image_type;
      typedef object_traits_impl<object_type, id_pgsql>::id_image_type id_image_type;

      static const std::size_t id_column_count = 6UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);
    };

    // auxiliaries_section
    //
    struct auxiliaries_section_traits
    {
      typedef object_traits_impl<object_type, id_pgsql>::image_type image_type;
      typedef object_traits_impl<object_type, id_pgsql>::id_image_type id_image_type;

      static const std::size_t id_column_count = 6UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);
    };

    // bot_keys_section
    //
    struct bot_keys_section_traits
    {
      typedef object_traits_impl<object_type, id_pgsql>::image_type image_type;
      typedef object_traits_impl<object_type, id_pgsql>::id_image_type id_image_type;

      static const std::size_t id_column_count = 6UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);
    };

    struct internal_repository_tag;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 19UL;
    static const std::size_t id_column_count = 6UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 13UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static bool
    load (connection&, object_type&, section&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::build_package, id_common >:
    public access::object_traits_impl< ::brep::build_package, id_pgsql >
  {
  };

  // build_package_version
  //
  template <>
  class access::view_traits_impl< ::brep::build_package_version, id_pgsql >:
    public access::view_traits< ::brep::build_package_version >
  {
    public:
    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type id_value;

      // version
      //
      composite_value_traits< ::brep::upstream_version, id_pgsql >::image_type version_value;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 8UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::build_package_version, id_common >:
    public access::view_traits_impl< ::brep::build_package_version, id_pgsql >
  {
  };

  // buildable_package
  //
  template <>
  class access::view_traits_impl< ::brep::buildable_package, id_pgsql >:
    public access::view_traits< ::brep::buildable_package >
  {
    public:
    struct image_type
    {
      // package
      //
      object_traits_impl< ::brep::build_package, id_pgsql >::image_type package_value;

      // archived
      //
      bool archived_value;
      bool archived_null;

      // interactive
      //
      details::buffer interactive_value;
      std::size_t interactive_size;
      bool interactive_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 21UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::buildable_package, id_common >:
    public access::view_traits_impl< ::brep::buildable_package, id_pgsql >
  {
  };

  // buildable_package_count
  //
  template <>
  class access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >:
    public access::view_traits< ::brep::buildable_package_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::buildable_package_count, id_common >:
    public access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >
  {
  };

  // build_tenant
  //
  // build_repository
  //
  // build_public_key
  //
  // build_package
  //
  template <>
  struct alias_traits<
    ::brep::build_repository,
    id_pgsql,
    access::object_traits_impl< ::brep::build_package, id_pgsql >::internal_repository_tag>
  {
    static const char table_name[];
  };

  template <>
  struct query_columns_base< ::brep::build_package, id_pgsql >
  {
    // internal_repository
    //
    typedef
    odb::alias_traits<
      ::brep::build_repository,
      id_pgsql,
      access::object_traits_impl< ::brep::build_package, id_pgsql >::internal_repository_tag>
    internal_repository_alias_;
  };

  template <typename A>
  struct query_columns< ::brep::build_package, id_pgsql, A >:
    query_columns_base< ::brep::build_package, id_pgsql >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      name_type_;

      static const name_type_ name;

      // version
      //
      struct version_class_1_
      {
        version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        revision_type_;

        static const revision_type_ revision;
      };

      static const version_class_1_ version;
    };

    static const id_class_ id;

    // version
    //
    struct version_class_
    {
      version_class_ ()
      {
      }

      // upstream
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      release_type_;

      static const release_type_ release;
    };

    static const version_class_ version;

    // project
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::bpkg::package_name,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    project_type_;

    static const project_type_ project;

    // build_email
    //
    struct build_email_class_
    {
      build_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_email_class_ build_email;

    // build_warning_email
    //
    struct build_warning_email_class_
    {
      build_warning_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_warning_email_class_ build_warning_email;

    // build_error_email
    //
    struct build_error_email_class_
    {
      build_error_email_class_ ()
      {
      }

      // value
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      value_type_;

      static const value_type_ value;

      // comment
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      comment_type_;

      static const comment_type_ comment;
    };

    static const build_error_email_class_ build_error_email;

    // internal_repository
    //
    struct internal_repository_column_class_
    {
      internal_repository_column_class_ ()
      {
      }

      // tenant
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      tenant_type_;

      static const tenant_type_ tenant;

      // canonical_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      canonical_name_type_;

      static const canonical_name_type_ canonical_name;
    };

    typedef
    odb::query_pointer<
      odb::pointer_query_columns<
        ::brep::build_repository,
        id_pgsql,
        internal_repository_alias_ > >
    internal_repository_pointer_type_;

    struct internal_repository_type_: internal_repository_pointer_type_, internal_repository_column_class_
    {
      internal_repository_type_ ()
      {
      }
    };

    static const internal_repository_type_ internal_repository;

    // buildable
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    buildable_type_;

    static const buildable_type_ buildable;

    // custom_bot
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        bool,
        pgsql::id_boolean >::query_type,
      pgsql::id_boolean >
    custom_bot_type_;

    static const custom_bot_type_ custom_bot;
  };

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::id_class_::tenant_type_
  query_columns< ::brep::build_package, id_pgsql, A >::id_class_::
  tenant (A::table_name, "\"tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::id_class_::name_type_
  query_columns< ::brep::build_package, id_pgsql, A >::id_class_::
  name (A::table_name, "\"name\"", "(?)::CITEXT");

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::epoch_type_
  query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::
  epoch (A::table_name, "\"version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::canonical_upstream_type_
  query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::
  canonical_upstream (A::table_name, "\"version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::canonical_release_type_
  query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::
  canonical_release (A::table_name, "\"version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::revision_type_
  query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_::
  revision (A::table_name, "\"version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version_class_1_
  query_columns< ::brep::build_package, id_pgsql, A >::id_class_::version;

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::id_class_
  query_columns< ::brep::build_package, id_pgsql, A >::id;

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::version_class_::upstream_type_
  query_columns< ::brep::build_package, id_pgsql, A >::version_class_::
  upstream (A::table_name, "\"version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::version_class_::release_type_
  query_columns< ::brep::build_package, id_pgsql, A >::version_class_::
  release (A::table_name, "\"version_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::version_class_
  query_columns< ::brep::build_package, id_pgsql, A >::version;

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::project_type_
  query_columns< ::brep::build_package, id_pgsql, A >::
  project (A::table_name, "\"project\"", "(?)::CITEXT");

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_::value_type_
  query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_::
  value (A::table_name, "\"build_email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_::comment_type_
  query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_::
  comment (A::table_name, "\"build_email_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::build_email_class_
  query_columns< ::brep::build_package, id_pgsql, A >::build_email;

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_::value_type_
  query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_::
  value (A::table_name, "\"build_warning_email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_::comment_type_
  query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_::
  comment (A::table_name, "\"build_warning_email_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email_class_
  query_columns< ::brep::build_package, id_pgsql, A >::build_warning_email;

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_::value_type_
  query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_::
  value (A::table_name, "\"build_error_email\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_::comment_type_
  query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_::
  comment (A::table_name, "\"build_error_email_comment\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::build_error_email_class_
  query_columns< ::brep::build_package, id_pgsql, A >::build_error_email;

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_column_class_::tenant_type_
  query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_column_class_::
  tenant (A::table_name, "\"internal_repository_tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_column_class_::canonical_name_type_
  query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_column_class_::
  canonical_name (A::table_name, "\"internal_repository_canonical_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::internal_repository_type_
  query_columns< ::brep::build_package, id_pgsql, A >::internal_repository;

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::buildable_type_
  query_columns< ::brep::build_package, id_pgsql, A >::
  buildable (A::table_name, "\"buildable\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_package, id_pgsql, A >::custom_bot_type_
  query_columns< ::brep::build_package, id_pgsql, A >::
  custom_bot (A::table_name, "\"custom_bot\"", 0);

  // build_package_version
  //
  struct access::view_traits_impl< ::brep::build_package_version, id_pgsql >::query_columns:
    odb::pointer_query_columns<
      ::brep::build_package,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_package, id_pgsql > >
  {
  };

  // buildable_package
  //
  struct access::view_traits_impl< ::brep::buildable_package, id_pgsql >::query_columns
  {
    // build_package
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_package,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_package, id_pgsql > >
    build_package;

    // build_repository
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_repository,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_repository, id_pgsql > >
    build_repository;

    // build_tenant
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_tenant,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_tenant, id_pgsql > >
    build_tenant;
  };

  // buildable_package_count
  //
  struct access::view_traits_impl< ::brep::buildable_package_count, id_pgsql >::query_columns
  {
    // build_package
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_package,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_package, id_pgsql > >
    build_package;

    // build_repository
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_repository,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_repository, id_pgsql > >
    build_repository;

    // build_tenant
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_tenant,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_tenant, id_pgsql > >
    build_tenant;
  };
}

#include <libbrep/build-package-odb.ixx>

#include <odb/post.hxx>

#endif // LIBBREP_BUILD_PACKAGE_ODB_HXX
