// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
//
// End prologue.

#include <clean/clean-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace cli
{
  // unknown_option
  //
  unknown_option::
  ~unknown_option () noexcept
  {
  }

  void unknown_option::
  print (::std::ostream& os) const
  {
    os << "unknown option '" << option ().c_str () << "'";
  }

  const char* unknown_option::
  what () const noexcept
  {
    return "unknown option";
  }

  // unknown_argument
  //
  unknown_argument::
  ~unknown_argument () noexcept
  {
  }

  void unknown_argument::
  print (::std::ostream& os) const
  {
    os << "unknown argument '" << argument ().c_str () << "'";
  }

  const char* unknown_argument::
  what () const noexcept
  {
    return "unknown argument";
  }

  // missing_value
  //
  missing_value::
  ~missing_value () noexcept
  {
  }

  void missing_value::
  print (::std::ostream& os) const
  {
    os << "missing value for option '" << option ().c_str () << "'";
  }

  const char* missing_value::
  what () const noexcept
  {
    return "missing option value";
  }

  // invalid_value
  //
  invalid_value::
  ~invalid_value () noexcept
  {
  }

  void invalid_value::
  print (::std::ostream& os) const
  {
    os << "invalid value '" << value ().c_str () << "' for option '"
       << option ().c_str () << "'";

    if (!message ().empty ())
      os << ": " << message ().c_str ();
  }

  const char* invalid_value::
  what () const noexcept
  {
    return "invalid option value";
  }

  // eos_reached
  //
  void eos_reached::
  print (::std::ostream& os) const
  {
    os << what ();
  }

  const char* eos_reached::
  what () const noexcept
  {
    return "end of argument stream reached";
  }

  // scanner
  //
  scanner::
  ~scanner ()
  {
  }

  // argv_scanner
  //
  bool argv_scanner::
  more ()
  {
    return i_ < argc_;
  }

  const char* argv_scanner::
  peek ()
  {
    if (i_ < argc_)
      return argv_[i_];
    else
      throw eos_reached ();
  }

  const char* argv_scanner::
  next ()
  {
    if (i_ < argc_)
    {
      const char* r (argv_[i_]);

      if (erase_)
      {
        for (int i (i_ + 1); i < argc_; ++i)
          argv_[i - 1] = argv_[i];

        --argc_;
        argv_[argc_] = 0;
      }
      else
        ++i_;

      ++start_position_;
      return r;
    }
    else
      throw eos_reached ();
  }

  void argv_scanner::
  skip ()
  {
    if (i_ < argc_)
    {
      ++i_;
      ++start_position_;
    }
    else
      throw eos_reached ();
  }

  std::size_t argv_scanner::
  position ()
  {
    return start_position_;
  }

  template <typename X>
  struct parser
  {
    static void
    parse (X& x, bool& xs, scanner& s)
    {
      using namespace std;

      const char* o (s.next ());
      if (s.more ())
      {
        string v (s.next ());
        istringstream is (v);
        if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
          throw invalid_value (o, v);
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <>
  struct parser<bool>
  {
    static void
    parse (bool& x, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
      {
        const char* v (s.next ());

        if (std::strcmp (v, "1")    == 0 ||
            std::strcmp (v, "true") == 0 ||
            std::strcmp (v, "TRUE") == 0 ||
            std::strcmp (v, "True") == 0)
          x = true;
        else if (std::strcmp (v, "0")     == 0 ||
                 std::strcmp (v, "false") == 0 ||
                 std::strcmp (v, "FALSE") == 0 ||
                 std::strcmp (v, "False") == 0)
          x = false;
        else
          throw invalid_value (o, v);
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <>
  struct parser<std::string>
  {
    static void
    parse (std::string& x, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
        x = s.next ();
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename X>
  struct parser<std::pair<X, std::size_t> >
  {
    static void
    parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
    {
      x.second = s.position ();
      parser<X>::parse (x.first, xs, s);
    }
  };

  template <typename X>
  struct parser<std::vector<X> >
  {
    static void
    parse (std::vector<X>& c, bool& xs, scanner& s)
    {
      X x;
      bool dummy;
      parser<X>::parse (x, dummy, s);
      c.push_back (x);
      xs = true;
    }
  };

  template <typename X, typename C>
  struct parser<std::set<X, C> >
  {
    static void
    parse (std::set<X, C>& c, bool& xs, scanner& s)
    {
      X x;
      bool dummy;
      parser<X>::parse (x, dummy, s);
      c.insert (x);
      xs = true;
    }
  };

  template <typename K, typename V, typename C>
  struct parser<std::map<K, V, C> >
  {
    static void
    parse (std::map<K, V, C>& m, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
      {
        std::size_t pos (s.position ());
        std::string ov (s.next ());
        std::string::size_type p = ov.find ('=');

        K k = K ();
        V v = V ();
        std::string kstr (ov, 0, p);
        std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

        int ac (2);
        char* av[] =
        {
          const_cast<char*> (o),
          0
        };

        bool dummy;
        if (!kstr.empty ())
        {
          av[1] = const_cast<char*> (kstr.c_str ());
          argv_scanner s (0, ac, av, false, pos);
          parser<K>::parse (k, dummy, s);
        }

        if (!vstr.empty ())
        {
          av[1] = const_cast<char*> (vstr.c_str ());
          argv_scanner s (0, ac, av, false, pos);
          parser<V>::parse (v, dummy, s);
        }

        m[k] = v;
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename K, typename V, typename C>
  struct parser<std::multimap<K, V, C> >
  {
    static void
    parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
      {
        std::size_t pos (s.position ());
        std::string ov (s.next ());
        std::string::size_type p = ov.find ('=');

        K k = K ();
        V v = V ();
        std::string kstr (ov, 0, p);
        std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

        int ac (2);
        char* av[] =
        {
          const_cast<char*> (o),
          0
        };

        bool dummy;
        if (!kstr.empty ())
        {
          av[1] = const_cast<char*> (kstr.c_str ());
          argv_scanner s (0, ac, av, false, pos);
          parser<K>::parse (k, dummy, s);
        }

        if (!vstr.empty ())
        {
          av[1] = const_cast<char*> (vstr.c_str ());
          argv_scanner s (0, ac, av, false, pos);
          parser<V>::parse (v, dummy, s);
        }

        m.insert (typename std::multimap<K, V, C>::value_type (k, v));
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename X, typename T, T X::*M>
  void
  thunk (X& x, scanner& s)
  {
    parser<T>::parse (x.*M, s);
  }

  template <typename X, bool X::*M>
  void
  thunk (X& x, scanner& s)
  {
    s.next ();
    x.*M = true;
  }

  template <typename X, typename T, T X::*M, bool X::*S>
  void
  thunk (X& x, scanner& s)
  {
    parser<T>::parse (x.*M, x.*S, s);
  }
}

#include <map>

// options
//

options::
options ()
: archive_ (),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ (),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
}

options::
options (int& argc,
         char** argv,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: archive_ (),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ (),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  ::cli::argv_scanner s (argc, argv, erase);
  _parse (s, opt, arg);
}

options::
options (int start,
         int& argc,
         char** argv,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: archive_ (),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ (),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  ::cli::argv_scanner s (start, argc, argv, erase);
  _parse (s, opt, arg);
}

options::
options (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: archive_ (),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ (),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  ::cli::argv_scanner s (argc, argv, erase);
  _parse (s, opt, arg);
  end = s.end ();
}

options::
options (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: archive_ (),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ (),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  ::cli::argv_scanner s (start, argc, argv, erase);
  _parse (s, opt, arg);
  end = s.end ();
}

options::
options (::cli::scanner& s,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: archive_ (),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ (),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  _parse (s, opt, arg);
}

::cli::usage_para options::
print_usage (::std::ostream& os, ::cli::usage_para p)
{
  CLI_POTENTIALLY_UNUSED (os);

  if (p != ::cli::usage_para::none)
    os << ::std::endl;

  os << "\033[1mOPTIONS\033[0m" << ::std::endl;

  os << std::endl
     << "\033[1m--archive\033[0m          Archive old tenants." << ::std::endl;

  os << std::endl
     << "\033[1m--db-user\033[0m \033[4muser\033[0m     Database user name. If not specified, then operating system" << ::std::endl
     << "                   (login) name is used." << ::std::endl;

  os << std::endl
     << "\033[1m--db-password\033[0m \033[4mpass\033[0m Database password. If not specified, then login without" << ::std::endl
     << "                   password is expected to work." << ::std::endl;

  os << std::endl
     << "\033[1m--db-name\033[0m \033[4mname\033[0m     Database name. If not specified, then \033[1mbrep_build\033[0m is used for" << ::std::endl
     << "                   the first form and \033[1mbrep_package\033[0m for the second." << ::std::endl;

  os << std::endl
     << "\033[1m--db-host\033[0m \033[4mhost\033[0m     Database host name, address, or socket. If not specified," << ::std::endl
     << "                   then connect to \033[1mlocalhost\033[0m using the operating system-default" << ::std::endl
     << "                   mechanism (Unix-domain socket, etc)." << ::std::endl;

  os << std::endl
     << "\033[1m--db-port\033[0m \033[4mport\033[0m     Database port number. If not specified, the default port is" << ::std::endl
     << "                   used." << ::std::endl;

  os << std::endl
     << "\033[1m--pager\033[0m \033[4mpath\033[0m       The pager program to be used to show long text. Commonly" << ::std::endl
     << "                   used pager programs are \033[1mless\033[0m and \033[1mmore\033[0m. You can also specify" << ::std::endl
     << "                   additional options that should be passed to the pager" << ::std::endl
     << "                   program with \033[1m--pager-option\033[0m. If an empty string is specified" << ::std::endl
     << "                   as the pager program, then no pager will be used. If the" << ::std::endl
     << "                   pager program is not explicitly specified, then \033[1mbrep-clean\033[0m" << ::std::endl
     << "                   will try to use \033[1mless\033[0m. If it is not available, then no pager" << ::std::endl
     << "                   will be used." << ::std::endl;

  os << std::endl
     << "\033[1m--pager-option\033[0m \033[4mopt\033[0m Additional option to be passed to the pager program. See" << ::std::endl
     << "                   \033[1m--pager\033[0m for more information on the pager program. Repeat" << ::std::endl
     << "                   this option to specify multiple pager options." << ::std::endl;

  os << std::endl
     << "\033[1m--help\033[0m             Print usage information and exit." << ::std::endl;

  os << std::endl
     << "\033[1m--version\033[0m          Print version and exit." << ::std::endl;

  p = ::cli::usage_para::option;

  return p;
}

typedef
std::map<std::string, void (*) (options&, ::cli::scanner&)>
_cli_options_map;

static _cli_options_map _cli_options_map_;

struct _cli_options_map_init
{
  _cli_options_map_init ()
  {
    _cli_options_map_["--archive"] =
    &::cli::thunk< options, &options::archive_ >;
    _cli_options_map_["--db-user"] =
    &::cli::thunk< options, std::string, &options::db_user_,
      &options::db_user_specified_ >;
    _cli_options_map_["--db-password"] =
    &::cli::thunk< options, std::string, &options::db_password_,
      &options::db_password_specified_ >;
    _cli_options_map_["--db-name"] =
    &::cli::thunk< options, std::string, &options::db_name_,
      &options::db_name_specified_ >;
    _cli_options_map_["--db-host"] =
    &::cli::thunk< options, std::string, &options::db_host_,
      &options::db_host_specified_ >;
    _cli_options_map_["--db-port"] =
    &::cli::thunk< options, std::uint16_t, &options::db_port_,
      &options::db_port_specified_ >;
    _cli_options_map_["--pager"] =
    &::cli::thunk< options, std::string, &options::pager_,
      &options::pager_specified_ >;
    _cli_options_map_["--pager-option"] =
    &::cli::thunk< options, std::vector<std::string>, &options::pager_option_,
      &options::pager_option_specified_ >;
    _cli_options_map_["--help"] =
    &::cli::thunk< options, &options::help_ >;
    _cli_options_map_["--version"] =
    &::cli::thunk< options, &options::version_ >;
  }
};

static _cli_options_map_init _cli_options_map_init_;

bool options::
_parse (const char* o, ::cli::scanner& s)
{
  _cli_options_map::const_iterator i (_cli_options_map_.find (o));

  if (i != _cli_options_map_.end ())
  {
    (*(i->second)) (*this, s);
    return true;
  }

  return false;
}

bool options::
_parse (::cli::scanner& s,
        ::cli::unknown_mode opt_mode,
        ::cli::unknown_mode arg_mode)
{
  // Can't skip combined flags (--no-combined-flags).
  //
  assert (opt_mode != ::cli::unknown_mode::skip);

  bool r = false;
  bool opt = true;

  while (s.more ())
  {
    const char* o = s.peek ();

    if (std::strcmp (o, "--") == 0)
    {
      opt = false;
      s.skip ();
      r = true;
      continue;
    }

    if (opt)
    {
      if (_parse (o, s))
      {
        r = true;
        continue;
      }

      if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
      {
        // Handle combined option values.
        //
        std::string co;
        if (const char* v = std::strchr (o, '='))
        {
          co.assign (o, 0, v - o);
          ++v;

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (co.c_str ()),
            const_cast<char*> (v)
          };

          ::cli::argv_scanner ns (0, ac, av);

          if (_parse (co.c_str (), ns))
          {
            // Parsed the option but not its value?
            //
            if (ns.end () != 2)
              throw ::cli::invalid_value (co, v);

            s.next ();
            r = true;
            continue;
          }
          else
          {
            // Set the unknown option and fall through.
            //
            o = co.c_str ();
          }
        }

        // Handle combined flags.
        //
        char cf[3];
        {
          const char* p = o + 1;
          for (; *p != '\0'; ++p)
          {
            if (!((*p >= 'a' && *p <= 'z') ||
                  (*p >= 'A' && *p <= 'Z') ||
                  (*p >= '0' && *p <= '9')))
              break;
          }

          if (*p == '\0')
          {
            for (p = o + 1; *p != '\0'; ++p)
            {
              std::strcpy (cf, "-");
              cf[1] = *p;
              cf[2] = '\0';

              int ac (1);
              char* av[] =
              {
                cf
              };

              ::cli::argv_scanner ns (0, ac, av);

              if (!_parse (cf, ns))
                break;
            }

            if (*p == '\0')
            {
              // All handled.
              //
              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = cf;
            }
          }
        }

        switch (opt_mode)
        {
          case ::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::cli::unknown_mode::stop:
          {
            break;
          }
          case ::cli::unknown_mode::fail:
          {
            throw ::cli::unknown_option (o);
          }
        }

        break;
      }
    }

    switch (arg_mode)
    {
      case ::cli::unknown_mode::skip:
      {
        s.skip ();
        r = true;
        continue;
      }
      case ::cli::unknown_mode::stop:
      {
        break;
      }
      case ::cli::unknown_mode::fail:
      {
        throw ::cli::unknown_argument (o);
      }
    }

    break;
  }

  return r;
}

::cli::usage_para
print_usage (::std::ostream& os, ::cli::usage_para p)
{
  CLI_POTENTIALLY_UNUSED (os);

  if (p != ::cli::usage_para::none)
    os << ::std::endl;

  os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1mbrep-clean --help\033[0m" << ::std::endl
     << "\033[1mbrep-clean --version\033[0m" << ::std::endl
     << "\033[1mbrep-clean\033[0m [\033[4moptions\033[0m] builds \033[4mbuildtab\033[0m [\033[4mtimeout\033[0m...]" << ::std::endl
     << "\033[1mbrep-clean\033[0m [\033[4moptions\033[0m] tenants \033[4mtimeout\033[0m\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1mDESCRIPTION\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1mbrep-clean\033[0m deletes expired package builds from the brep \033[1mbuild\033[0m database or" << ::std::endl
     << "deletes/archives tenants from the brep \033[1mpackage\033[0m database." << ::std::endl
     << ::std::endl
     << "The first form considers a build as expired if the corresponding package" << ::std::endl
     << "version is not in the \033[1mpackage\033[0m database, or the configuration is not listed in" << ::std::endl
     << "the \033[4mbuildtab\033[0m file, or its age is older than the specified timeout for this" << ::std::endl
     << "build toolchain." << ::std::endl
     << ::std::endl
     << "Build \033[4mtimeout\033[0m, if specified, should have the [\033[4mname\033[0m=]\033[4mhours\033[0m\033[0m form. Specify zero" << ::std::endl
     << "for \033[4mhours\033[0m to make builds for a toolchain to never expire. Omit \033[4mname\033[0m (including" << ::std::endl
     << "\033[1m=\033[0m) to specify the default timeout. It will apply to all the toolchains that" << ::std::endl
     << "don't have a toolchain-specific timeout." << ::std::endl
     << ::std::endl
     << "The second form considers a tenant as expired if its age is older than the" << ::std::endl
     << "specified \033[4mtimeout\033[0m." << ::std::endl
     << ::std::endl
     << "If the \033[1m--archive\033[0m option is specified, then the tenant is archived rather than" << ::std::endl
     << "deleted. In this state the tenant packages (and their builds) are still visible" << ::std::endl
     << "in \033[1mbrep\033[0m but are not (re-)built by build bots." << ::std::endl
     << ::std::endl
     << "Note that \033[1mbrep-clean\033[0m expects the \033[1mbuild\033[0m and \033[1mpackage\033[0m database schemas to have" << ::std::endl
     << "already been created using \033[1mbrep-migrate(1)\033[0m." << ::std::endl;

  p = ::options::print_usage (os, ::cli::usage_para::text);

  if (p != ::cli::usage_para::none)
    os << ::std::endl;

  os << "\033[1mEXIT STATUS\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1m0\033[0m" << ::std::endl
     << "    Success." << ::std::endl
     << "\033[1m1\033[0m" << ::std::endl
     << "    Fatal error." << ::std::endl
     << "\033[1m2\033[0m" << ::std::endl
     << "    An instance of \033[1mbrep-clean\033[0m or some other \033[1mbrep\033[0m utility is already running." << ::std::endl
     << "    Try again." << ::std::endl
     << "\033[1m3\033[0m" << ::std::endl
     << "    Recoverable database error. Try again." << ::std::endl;

  p = ::cli::usage_para::text;

  return p;
}

// Begin epilogue.
//
//
// End epilogue.

