// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
//
// End prologue.

#include <cassert>

namespace brep
{
  namespace cli
  {
    // usage_para
    //
    inline usage_para::
    usage_para (value v)
    : v_ (v)
    {
    }

    // unknown_mode
    //
    inline unknown_mode::
    unknown_mode (value v)
    : v_ (v)
    {
    }

    // exception
    //
    inline ::std::ostream&
    operator<< (::std::ostream& os, const exception& e)
    {
      e.print (os);
      return os;
    }

    // unknown_option
    //
    inline unknown_option::
    unknown_option (const std::string& option)
    : option_ (option)
    {
    }

    inline const std::string& unknown_option::
    option () const
    {
      return option_;
    }

    // unknown_argument
    //
    inline unknown_argument::
    unknown_argument (const std::string& argument)
    : argument_ (argument)
    {
    }

    inline const std::string& unknown_argument::
    argument () const
    {
      return argument_;
    }

    // missing_value
    //
    inline missing_value::
    missing_value (const std::string& option)
    : option_ (option)
    {
    }

    inline const std::string& missing_value::
    option () const
    {
      return option_;
    }

    // invalid_value
    //
    inline invalid_value::
    invalid_value (const std::string& option,
                   const std::string& value,
                   const std::string& message)
    : option_ (option),
      value_ (value),
      message_ (message)
    {
    }

    inline const std::string& invalid_value::
    option () const
    {
      return option_;
    }

    inline const std::string& invalid_value::
    value () const
    {
      return value_;
    }

    inline const std::string& invalid_value::
    message () const
    {
      return message_;
    }

    // file_io_failure
    //
    inline file_io_failure::
    file_io_failure (const std::string& file)
    : file_ (file)
    {
    }

    inline const std::string& file_io_failure::
    file () const
    {
      return file_;
    }

    // unmatched_quote
    //
    inline unmatched_quote::
    unmatched_quote (const std::string& argument)
    : argument_ (argument)
    {
    }

    inline const std::string& unmatched_quote::
    argument () const
    {
      return argument_;
    }

    // argv_scanner
    //
    inline argv_scanner::
    argv_scanner (int& argc,
                  char** argv,
                  bool erase,
                  std::size_t sp)
    : start_position_ (sp + 1),
      i_ (1),
      argc_ (argc),
      argv_ (argv),
      erase_ (erase)
    {
    }

    inline argv_scanner::
    argv_scanner (int start,
                  int& argc,
                  char** argv,
                  bool erase,
                  std::size_t sp)
    : start_position_ (sp + static_cast<std::size_t> (start)),
      i_ (start),
      argc_ (argc),
      argv_ (argv),
      erase_ (erase)
    {
    }

    inline int argv_scanner::
    end () const
    {
      return i_;
    }

    // argv_file_scanner
    //
    inline argv_file_scanner::
    argv_file_scanner (int& argc,
                       char** argv,
                       const std::string& option,
                       bool erase,
                       std::size_t sp)
    : argv_scanner (argc, argv, erase, sp),
      option_ (option),
      options_ (&option_info_),
      options_count_ (1),
      i_ (1),
      skip_ (false)
    {
      option_info_.option = option_.c_str ();
      option_info_.search_func = 0;
    }

    inline argv_file_scanner::
    argv_file_scanner (int start,
                       int& argc,
                       char** argv,
                       const std::string& option,
                       bool erase,
                       std::size_t sp)
    : argv_scanner (start, argc, argv, erase, sp),
      option_ (option),
      options_ (&option_info_),
      options_count_ (1),
      i_ (1),
      skip_ (false)
    {
      option_info_.option = option_.c_str ();
      option_info_.search_func = 0;
    }

    inline argv_file_scanner::
    argv_file_scanner (const std::string& file,
                       const std::string& option,
                       std::size_t sp)
    : argv_scanner (0, zero_argc_, 0, sp),
      option_ (option),
      options_ (&option_info_),
      options_count_ (1),
      i_ (1),
      skip_ (false)
    {
      option_info_.option = option_.c_str ();
      option_info_.search_func = 0;

      load (file);
    }

    inline argv_file_scanner::
    argv_file_scanner (int& argc,
                       char** argv,
                       const option_info* options,
                       std::size_t options_count,
                       bool erase,
                       std::size_t sp)
    : argv_scanner (argc, argv, erase, sp),
      options_ (options),
      options_count_ (options_count),
      i_ (1),
      skip_ (false)
    {
    }

    inline argv_file_scanner::
    argv_file_scanner (int start,
                       int& argc,
                       char** argv,
                       const option_info* options,
                       std::size_t options_count,
                       bool erase,
                       std::size_t sp)
    : argv_scanner (start, argc, argv, erase, sp),
      options_ (options),
      options_count_ (options_count),
      i_ (1),
      skip_ (false)
    {
    }

    inline argv_file_scanner::
    argv_file_scanner (const std::string& file,
                       const option_info* options,
                       std::size_t options_count,
                       std::size_t sp)
    : argv_scanner (0, zero_argc_, 0, sp),
      options_ (options),
      options_count_ (options_count),
      i_ (1),
      skip_ (false)
    {
      load (file);
    }

    inline const std::string& option::
    name () const
    {
      return name_;
    }

    inline const option_names& option::
    aliases () const
    {
      return aliases_;
    }

    inline bool option::
    flag () const
    {
      return flag_;
    }

    inline const std::string& option::
    default_value () const
    {
      return default_value_;
    }

    inline option::
    option ()
    {
    }

    inline option::
    option (const std::string& n,
            const option_names& a,
            bool f,
            const std::string& dv)
    : name_ (n), aliases_ (a), flag_ (f), default_value_ (dv)
    {
    }

    inline options::container_type::const_iterator options::
    find (const std::string& name) const
    {
      map_type::const_iterator i (map_.find (name));
      return i != map_.end () ? begin () + i->second : end ();
    }
  }
}

namespace brep
{
  namespace options
  {
    // repository_email
    //

    inline const string& repository_email::
    email () const
    {
      return this->email_;
    }

    inline string& repository_email::
    email ()
    {
      return this->email_;
    }

    inline void repository_email::
    email (const string& x)
    {
      this->email_ = x;
    }

    inline bool repository_email::
    email_specified () const
    {
      return this->email_specified_;
    }

    inline void repository_email::
    email_specified (bool x)
    {
      this->email_specified_ = x;
    }

    // repository_url
    //

    inline const string& repository_url::
    host () const
    {
      return this->host_;
    }

    inline string& repository_url::
    host ()
    {
      return this->host_;
    }

    inline void repository_url::
    host (const string& x)
    {
      this->host_ = x;
    }

    inline bool repository_url::
    host_specified () const
    {
      return this->host_specified_;
    }

    inline void repository_url::
    host_specified (bool x)
    {
      this->host_specified_ = x;
    }

    inline const dir_path& repository_url::
    root () const
    {
      return this->root_;
    }

    inline dir_path& repository_url::
    root ()
    {
      return this->root_;
    }

    inline void repository_url::
    root (const dir_path& x)
    {
      this->root_ = x;
    }

    inline bool repository_url::
    root_specified () const
    {
      return this->root_specified_;
    }

    inline void repository_url::
    root_specified (bool x)
    {
      this->root_specified_ = x;
    }

    // build_email_notification
    //

    inline const std::map<string, build_email>& build_email_notification::
    build_toolchain_email () const
    {
      return this->build_toolchain_email_;
    }

    inline std::map<string, build_email>& build_email_notification::
    build_toolchain_email ()
    {
      return this->build_toolchain_email_;
    }

    inline void build_email_notification::
    build_toolchain_email (const std::map<string, build_email>& x)
    {
      this->build_toolchain_email_ = x;
    }

    inline bool build_email_notification::
    build_toolchain_email_specified () const
    {
      return this->build_toolchain_email_specified_;
    }

    inline void build_email_notification::
    build_toolchain_email_specified (bool x)
    {
      this->build_toolchain_email_specified_ = x;
    }

    // handler
    //

    inline const string& handler::
    tenant_name () const
    {
      return this->tenant_name_;
    }

    inline string& handler::
    tenant_name ()
    {
      return this->tenant_name_;
    }

    inline void handler::
    tenant_name (const string& x)
    {
      this->tenant_name_ = x;
    }

    inline bool handler::
    tenant_name_specified () const
    {
      return this->tenant_name_specified_;
    }

    inline void handler::
    tenant_name_specified (bool x)
    {
      this->tenant_name_specified_ = x;
    }

    inline const uint16_t& handler::
    verbosity () const
    {
      return this->verbosity_;
    }

    inline uint16_t& handler::
    verbosity ()
    {
      return this->verbosity_;
    }

    inline void handler::
    verbosity (const uint16_t& x)
    {
      this->verbosity_ = x;
    }

    inline bool handler::
    verbosity_specified () const
    {
      return this->verbosity_specified_;
    }

    inline void handler::
    verbosity_specified (bool x)
    {
      this->verbosity_specified_ = x;
    }

    // openssl_options
    //

    inline const path& openssl_options::
    openssl () const
    {
      return this->openssl_;
    }

    inline path& openssl_options::
    openssl ()
    {
      return this->openssl_;
    }

    inline void openssl_options::
    openssl (const path& x)
    {
      this->openssl_ = x;
    }

    inline bool openssl_options::
    openssl_specified () const
    {
      return this->openssl_specified_;
    }

    inline void openssl_options::
    openssl_specified (bool x)
    {
      this->openssl_specified_ = x;
    }

    inline const strings& openssl_options::
    openssl_option () const
    {
      return this->openssl_option_;
    }

    inline strings& openssl_options::
    openssl_option ()
    {
      return this->openssl_option_;
    }

    inline void openssl_options::
    openssl_option (const strings& x)
    {
      this->openssl_option_ = x;
    }

    inline bool openssl_options::
    openssl_option_specified () const
    {
      return this->openssl_option_specified_;
    }

    inline void openssl_options::
    openssl_option_specified (bool x)
    {
      this->openssl_option_specified_ = x;
    }

    inline const strings& openssl_options::
    openssl_envvar () const
    {
      return this->openssl_envvar_;
    }

    inline strings& openssl_options::
    openssl_envvar ()
    {
      return this->openssl_envvar_;
    }

    inline void openssl_options::
    openssl_envvar (const strings& x)
    {
      this->openssl_envvar_ = x;
    }

    inline bool openssl_options::
    openssl_envvar_specified () const
    {
      return this->openssl_envvar_specified_;
    }

    inline void openssl_options::
    openssl_envvar_specified (bool x)
    {
      this->openssl_envvar_specified_ = x;
    }

    // package_db
    //

    inline const string& package_db::
    package_db_user () const
    {
      return this->package_db_user_;
    }

    inline string& package_db::
    package_db_user ()
    {
      return this->package_db_user_;
    }

    inline void package_db::
    package_db_user (const string& x)
    {
      this->package_db_user_ = x;
    }

    inline bool package_db::
    package_db_user_specified () const
    {
      return this->package_db_user_specified_;
    }

    inline void package_db::
    package_db_user_specified (bool x)
    {
      this->package_db_user_specified_ = x;
    }

    inline const string& package_db::
    package_db_role () const
    {
      return this->package_db_role_;
    }

    inline string& package_db::
    package_db_role ()
    {
      return this->package_db_role_;
    }

    inline void package_db::
    package_db_role (const string& x)
    {
      this->package_db_role_ = x;
    }

    inline bool package_db::
    package_db_role_specified () const
    {
      return this->package_db_role_specified_;
    }

    inline void package_db::
    package_db_role_specified (bool x)
    {
      this->package_db_role_specified_ = x;
    }

    inline const string& package_db::
    package_db_password () const
    {
      return this->package_db_password_;
    }

    inline string& package_db::
    package_db_password ()
    {
      return this->package_db_password_;
    }

    inline void package_db::
    package_db_password (const string& x)
    {
      this->package_db_password_ = x;
    }

    inline bool package_db::
    package_db_password_specified () const
    {
      return this->package_db_password_specified_;
    }

    inline void package_db::
    package_db_password_specified (bool x)
    {
      this->package_db_password_specified_ = x;
    }

    inline const string& package_db::
    package_db_name () const
    {
      return this->package_db_name_;
    }

    inline string& package_db::
    package_db_name ()
    {
      return this->package_db_name_;
    }

    inline void package_db::
    package_db_name (const string& x)
    {
      this->package_db_name_ = x;
    }

    inline bool package_db::
    package_db_name_specified () const
    {
      return this->package_db_name_specified_;
    }

    inline void package_db::
    package_db_name_specified (bool x)
    {
      this->package_db_name_specified_ = x;
    }

    inline const string& package_db::
    package_db_host () const
    {
      return this->package_db_host_;
    }

    inline string& package_db::
    package_db_host ()
    {
      return this->package_db_host_;
    }

    inline void package_db::
    package_db_host (const string& x)
    {
      this->package_db_host_ = x;
    }

    inline bool package_db::
    package_db_host_specified () const
    {
      return this->package_db_host_specified_;
    }

    inline void package_db::
    package_db_host_specified (bool x)
    {
      this->package_db_host_specified_ = x;
    }

    inline const uint16_t& package_db::
    package_db_port () const
    {
      return this->package_db_port_;
    }

    inline uint16_t& package_db::
    package_db_port ()
    {
      return this->package_db_port_;
    }

    inline void package_db::
    package_db_port (const uint16_t& x)
    {
      this->package_db_port_ = x;
    }

    inline bool package_db::
    package_db_port_specified () const
    {
      return this->package_db_port_specified_;
    }

    inline void package_db::
    package_db_port_specified (bool x)
    {
      this->package_db_port_specified_ = x;
    }

    inline const size_t& package_db::
    package_db_max_connections () const
    {
      return this->package_db_max_connections_;
    }

    inline size_t& package_db::
    package_db_max_connections ()
    {
      return this->package_db_max_connections_;
    }

    inline void package_db::
    package_db_max_connections (const size_t& x)
    {
      this->package_db_max_connections_ = x;
    }

    inline bool package_db::
    package_db_max_connections_specified () const
    {
      return this->package_db_max_connections_specified_;
    }

    inline void package_db::
    package_db_max_connections_specified (bool x)
    {
      this->package_db_max_connections_specified_ = x;
    }

    inline const size_t& package_db::
    package_db_retry () const
    {
      return this->package_db_retry_;
    }

    inline size_t& package_db::
    package_db_retry ()
    {
      return this->package_db_retry_;
    }

    inline void package_db::
    package_db_retry (const size_t& x)
    {
      this->package_db_retry_ = x;
    }

    inline bool package_db::
    package_db_retry_specified () const
    {
      return this->package_db_retry_specified_;
    }

    inline void package_db::
    package_db_retry_specified (bool x)
    {
      this->package_db_retry_specified_ = x;
    }

    // build
    //

    inline const path& build::
    build_config () const
    {
      return this->build_config_;
    }

    inline path& build::
    build_config ()
    {
      return this->build_config_;
    }

    inline void build::
    build_config (const path& x)
    {
      this->build_config_ = x;
    }

    inline bool build::
    build_config_specified () const
    {
      return this->build_config_specified_;
    }

    inline void build::
    build_config_specified (bool x)
    {
      this->build_config_specified_ = x;
    }

    inline const dir_path& build::
    build_bot_agent_keys () const
    {
      return this->build_bot_agent_keys_;
    }

    inline dir_path& build::
    build_bot_agent_keys ()
    {
      return this->build_bot_agent_keys_;
    }

    inline void build::
    build_bot_agent_keys (const dir_path& x)
    {
      this->build_bot_agent_keys_ = x;
    }

    inline bool build::
    build_bot_agent_keys_specified () const
    {
      return this->build_bot_agent_keys_specified_;
    }

    inline void build::
    build_bot_agent_keys_specified (bool x)
    {
      this->build_bot_agent_keys_specified_ = x;
    }

    inline const size_t& build::
    build_forced_rebuild_timeout () const
    {
      return this->build_forced_rebuild_timeout_;
    }

    inline size_t& build::
    build_forced_rebuild_timeout ()
    {
      return this->build_forced_rebuild_timeout_;
    }

    inline void build::
    build_forced_rebuild_timeout (const size_t& x)
    {
      this->build_forced_rebuild_timeout_ = x;
    }

    inline bool build::
    build_forced_rebuild_timeout_specified () const
    {
      return this->build_forced_rebuild_timeout_specified_;
    }

    inline void build::
    build_forced_rebuild_timeout_specified (bool x)
    {
      this->build_forced_rebuild_timeout_specified_ = x;
    }

    inline const size_t& build::
    build_soft_rebuild_timeout () const
    {
      return this->build_soft_rebuild_timeout_;
    }

    inline size_t& build::
    build_soft_rebuild_timeout ()
    {
      return this->build_soft_rebuild_timeout_;
    }

    inline void build::
    build_soft_rebuild_timeout (const size_t& x)
    {
      this->build_soft_rebuild_timeout_ = x;
    }

    inline bool build::
    build_soft_rebuild_timeout_specified () const
    {
      return this->build_soft_rebuild_timeout_specified_;
    }

    inline void build::
    build_soft_rebuild_timeout_specified (bool x)
    {
      this->build_soft_rebuild_timeout_specified_ = x;
    }

    inline const size_t& build::
    build_alt_soft_rebuild_timeout () const
    {
      return this->build_alt_soft_rebuild_timeout_;
    }

    inline size_t& build::
    build_alt_soft_rebuild_timeout ()
    {
      return this->build_alt_soft_rebuild_timeout_;
    }

    inline void build::
    build_alt_soft_rebuild_timeout (const size_t& x)
    {
      this->build_alt_soft_rebuild_timeout_ = x;
    }

    inline bool build::
    build_alt_soft_rebuild_timeout_specified () const
    {
      return this->build_alt_soft_rebuild_timeout_specified_;
    }

    inline void build::
    build_alt_soft_rebuild_timeout_specified (bool x)
    {
      this->build_alt_soft_rebuild_timeout_specified_ = x;
    }

    inline const duration& build::
    build_alt_soft_rebuild_start () const
    {
      return this->build_alt_soft_rebuild_start_;
    }

    inline duration& build::
    build_alt_soft_rebuild_start ()
    {
      return this->build_alt_soft_rebuild_start_;
    }

    inline void build::
    build_alt_soft_rebuild_start (const duration& x)
    {
      this->build_alt_soft_rebuild_start_ = x;
    }

    inline bool build::
    build_alt_soft_rebuild_start_specified () const
    {
      return this->build_alt_soft_rebuild_start_specified_;
    }

    inline void build::
    build_alt_soft_rebuild_start_specified (bool x)
    {
      this->build_alt_soft_rebuild_start_specified_ = x;
    }

    inline const duration& build::
    build_alt_soft_rebuild_stop () const
    {
      return this->build_alt_soft_rebuild_stop_;
    }

    inline duration& build::
    build_alt_soft_rebuild_stop ()
    {
      return this->build_alt_soft_rebuild_stop_;
    }

    inline void build::
    build_alt_soft_rebuild_stop (const duration& x)
    {
      this->build_alt_soft_rebuild_stop_ = x;
    }

    inline bool build::
    build_alt_soft_rebuild_stop_specified () const
    {
      return this->build_alt_soft_rebuild_stop_specified_;
    }

    inline void build::
    build_alt_soft_rebuild_stop_specified (bool x)
    {
      this->build_alt_soft_rebuild_stop_specified_ = x;
    }

    inline const size_t& build::
    build_hard_rebuild_timeout () const
    {
      return this->build_hard_rebuild_timeout_;
    }

    inline size_t& build::
    build_hard_rebuild_timeout ()
    {
      return this->build_hard_rebuild_timeout_;
    }

    inline void build::
    build_hard_rebuild_timeout (const size_t& x)
    {
      this->build_hard_rebuild_timeout_ = x;
    }

    inline bool build::
    build_hard_rebuild_timeout_specified () const
    {
      return this->build_hard_rebuild_timeout_specified_;
    }

    inline void build::
    build_hard_rebuild_timeout_specified (bool x)
    {
      this->build_hard_rebuild_timeout_specified_ = x;
    }

    inline const size_t& build::
    build_alt_hard_rebuild_timeout () const
    {
      return this->build_alt_hard_rebuild_timeout_;
    }

    inline size_t& build::
    build_alt_hard_rebuild_timeout ()
    {
      return this->build_alt_hard_rebuild_timeout_;
    }

    inline void build::
    build_alt_hard_rebuild_timeout (const size_t& x)
    {
      this->build_alt_hard_rebuild_timeout_ = x;
    }

    inline bool build::
    build_alt_hard_rebuild_timeout_specified () const
    {
      return this->build_alt_hard_rebuild_timeout_specified_;
    }

    inline void build::
    build_alt_hard_rebuild_timeout_specified (bool x)
    {
      this->build_alt_hard_rebuild_timeout_specified_ = x;
    }

    inline const duration& build::
    build_alt_hard_rebuild_start () const
    {
      return this->build_alt_hard_rebuild_start_;
    }

    inline duration& build::
    build_alt_hard_rebuild_start ()
    {
      return this->build_alt_hard_rebuild_start_;
    }

    inline void build::
    build_alt_hard_rebuild_start (const duration& x)
    {
      this->build_alt_hard_rebuild_start_ = x;
    }

    inline bool build::
    build_alt_hard_rebuild_start_specified () const
    {
      return this->build_alt_hard_rebuild_start_specified_;
    }

    inline void build::
    build_alt_hard_rebuild_start_specified (bool x)
    {
      this->build_alt_hard_rebuild_start_specified_ = x;
    }

    inline const duration& build::
    build_alt_hard_rebuild_stop () const
    {
      return this->build_alt_hard_rebuild_stop_;
    }

    inline duration& build::
    build_alt_hard_rebuild_stop ()
    {
      return this->build_alt_hard_rebuild_stop_;
    }

    inline void build::
    build_alt_hard_rebuild_stop (const duration& x)
    {
      this->build_alt_hard_rebuild_stop_ = x;
    }

    inline bool build::
    build_alt_hard_rebuild_stop_specified () const
    {
      return this->build_alt_hard_rebuild_stop_specified_;
    }

    inline void build::
    build_alt_hard_rebuild_stop_specified (bool x)
    {
      this->build_alt_hard_rebuild_stop_specified_ = x;
    }

    inline const size_t& build::
    build_queued_timeout () const
    {
      return this->build_queued_timeout_;
    }

    inline size_t& build::
    build_queued_timeout ()
    {
      return this->build_queued_timeout_;
    }

    inline void build::
    build_queued_timeout (const size_t& x)
    {
      this->build_queued_timeout_ = x;
    }

    inline bool build::
    build_queued_timeout_specified () const
    {
      return this->build_queued_timeout_specified_;
    }

    inline void build::
    build_queued_timeout_specified (bool x)
    {
      this->build_queued_timeout_specified_ = x;
    }

    inline const size_t& build::
    build_queued_batch () const
    {
      return this->build_queued_batch_;
    }

    inline size_t& build::
    build_queued_batch ()
    {
      return this->build_queued_batch_;
    }

    inline void build::
    build_queued_batch (const size_t& x)
    {
      this->build_queued_batch_ = x;
    }

    inline bool build::
    build_queued_batch_specified () const
    {
      return this->build_queued_batch_specified_;
    }

    inline void build::
    build_queued_batch_specified (bool x)
    {
      this->build_queued_batch_specified_ = x;
    }

    // build_db
    //

    inline const string& build_db::
    build_db_user () const
    {
      return this->build_db_user_;
    }

    inline string& build_db::
    build_db_user ()
    {
      return this->build_db_user_;
    }

    inline void build_db::
    build_db_user (const string& x)
    {
      this->build_db_user_ = x;
    }

    inline bool build_db::
    build_db_user_specified () const
    {
      return this->build_db_user_specified_;
    }

    inline void build_db::
    build_db_user_specified (bool x)
    {
      this->build_db_user_specified_ = x;
    }

    inline const string& build_db::
    build_db_role () const
    {
      return this->build_db_role_;
    }

    inline string& build_db::
    build_db_role ()
    {
      return this->build_db_role_;
    }

    inline void build_db::
    build_db_role (const string& x)
    {
      this->build_db_role_ = x;
    }

    inline bool build_db::
    build_db_role_specified () const
    {
      return this->build_db_role_specified_;
    }

    inline void build_db::
    build_db_role_specified (bool x)
    {
      this->build_db_role_specified_ = x;
    }

    inline const string& build_db::
    build_db_password () const
    {
      return this->build_db_password_;
    }

    inline string& build_db::
    build_db_password ()
    {
      return this->build_db_password_;
    }

    inline void build_db::
    build_db_password (const string& x)
    {
      this->build_db_password_ = x;
    }

    inline bool build_db::
    build_db_password_specified () const
    {
      return this->build_db_password_specified_;
    }

    inline void build_db::
    build_db_password_specified (bool x)
    {
      this->build_db_password_specified_ = x;
    }

    inline const string& build_db::
    build_db_name () const
    {
      return this->build_db_name_;
    }

    inline string& build_db::
    build_db_name ()
    {
      return this->build_db_name_;
    }

    inline void build_db::
    build_db_name (const string& x)
    {
      this->build_db_name_ = x;
    }

    inline bool build_db::
    build_db_name_specified () const
    {
      return this->build_db_name_specified_;
    }

    inline void build_db::
    build_db_name_specified (bool x)
    {
      this->build_db_name_specified_ = x;
    }

    inline const string& build_db::
    build_db_host () const
    {
      return this->build_db_host_;
    }

    inline string& build_db::
    build_db_host ()
    {
      return this->build_db_host_;
    }

    inline void build_db::
    build_db_host (const string& x)
    {
      this->build_db_host_ = x;
    }

    inline bool build_db::
    build_db_host_specified () const
    {
      return this->build_db_host_specified_;
    }

    inline void build_db::
    build_db_host_specified (bool x)
    {
      this->build_db_host_specified_ = x;
    }

    inline const uint16_t& build_db::
    build_db_port () const
    {
      return this->build_db_port_;
    }

    inline uint16_t& build_db::
    build_db_port ()
    {
      return this->build_db_port_;
    }

    inline void build_db::
    build_db_port (const uint16_t& x)
    {
      this->build_db_port_ = x;
    }

    inline bool build_db::
    build_db_port_specified () const
    {
      return this->build_db_port_specified_;
    }

    inline void build_db::
    build_db_port_specified (bool x)
    {
      this->build_db_port_specified_ = x;
    }

    inline const size_t& build_db::
    build_db_max_connections () const
    {
      return this->build_db_max_connections_;
    }

    inline size_t& build_db::
    build_db_max_connections ()
    {
      return this->build_db_max_connections_;
    }

    inline void build_db::
    build_db_max_connections (const size_t& x)
    {
      this->build_db_max_connections_ = x;
    }

    inline bool build_db::
    build_db_max_connections_specified () const
    {
      return this->build_db_max_connections_specified_;
    }

    inline void build_db::
    build_db_max_connections_specified (bool x)
    {
      this->build_db_max_connections_specified_ = x;
    }

    inline const size_t& build_db::
    build_db_retry () const
    {
      return this->build_db_retry_;
    }

    inline size_t& build_db::
    build_db_retry ()
    {
      return this->build_db_retry_;
    }

    inline void build_db::
    build_db_retry (const size_t& x)
    {
      this->build_db_retry_ = x;
    }

    inline bool build_db::
    build_db_retry_specified () const
    {
      return this->build_db_retry_specified_;
    }

    inline void build_db::
    build_db_retry_specified (bool x)
    {
      this->build_db_retry_specified_ = x;
    }

    // build_upload
    //

    inline const std::map<string, dir_path>& build_upload::
    upload_data () const
    {
      return this->upload_data_;
    }

    inline std::map<string, dir_path>& build_upload::
    upload_data ()
    {
      return this->upload_data_;
    }

    inline void build_upload::
    upload_data (const std::map<string, dir_path>& x)
    {
      this->upload_data_ = x;
    }

    inline bool build_upload::
    upload_data_specified () const
    {
      return this->upload_data_specified_;
    }

    inline void build_upload::
    upload_data_specified (bool x)
    {
      this->upload_data_specified_ = x;
    }

    inline const std::map<string, size_t>& build_upload::
    upload_max_size () const
    {
      return this->upload_max_size_;
    }

    inline std::map<string, size_t>& build_upload::
    upload_max_size ()
    {
      return this->upload_max_size_;
    }

    inline void build_upload::
    upload_max_size (const std::map<string, size_t>& x)
    {
      this->upload_max_size_ = x;
    }

    inline bool build_upload::
    upload_max_size_specified () const
    {
      return this->upload_max_size_specified_;
    }

    inline void build_upload::
    upload_max_size_specified (bool x)
    {
      this->upload_max_size_specified_ = x;
    }

    inline const std::map<string, string>& build_upload::
    upload_email () const
    {
      return this->upload_email_;
    }

    inline std::map<string, string>& build_upload::
    upload_email ()
    {
      return this->upload_email_;
    }

    inline void build_upload::
    upload_email (const std::map<string, string>& x)
    {
      this->upload_email_ = x;
    }

    inline bool build_upload::
    upload_email_specified () const
    {
      return this->upload_email_specified_;
    }

    inline void build_upload::
    upload_email_specified (bool x)
    {
      this->upload_email_specified_ = x;
    }

    inline const std::map<string, path>& build_upload::
    upload_handler () const
    {
      return this->upload_handler_;
    }

    inline std::map<string, path>& build_upload::
    upload_handler ()
    {
      return this->upload_handler_;
    }

    inline void build_upload::
    upload_handler (const std::map<string, path>& x)
    {
      this->upload_handler_ = x;
    }

    inline bool build_upload::
    upload_handler_specified () const
    {
      return this->upload_handler_specified_;
    }

    inline void build_upload::
    upload_handler_specified (bool x)
    {
      this->upload_handler_specified_ = x;
    }

    inline const std::multimap<string, string>& build_upload::
    upload_handler_argument () const
    {
      return this->upload_handler_argument_;
    }

    inline std::multimap<string, string>& build_upload::
    upload_handler_argument ()
    {
      return this->upload_handler_argument_;
    }

    inline void build_upload::
    upload_handler_argument (const std::multimap<string, string>& x)
    {
      this->upload_handler_argument_ = x;
    }

    inline bool build_upload::
    upload_handler_argument_specified () const
    {
      return this->upload_handler_argument_specified_;
    }

    inline void build_upload::
    upload_handler_argument_specified (bool x)
    {
      this->upload_handler_argument_specified_ = x;
    }

    inline const std::map<string, size_t>& build_upload::
    upload_handler_timeout () const
    {
      return this->upload_handler_timeout_;
    }

    inline std::map<string, size_t>& build_upload::
    upload_handler_timeout ()
    {
      return this->upload_handler_timeout_;
    }

    inline void build_upload::
    upload_handler_timeout (const std::map<string, size_t>& x)
    {
      this->upload_handler_timeout_ = x;
    }

    inline bool build_upload::
    upload_handler_timeout_specified () const
    {
      return this->upload_handler_timeout_specified_;
    }

    inline void build_upload::
    upload_handler_timeout_specified (bool x)
    {
      this->upload_handler_timeout_specified_ = x;
    }

    inline const std::multimap<string, string>& build_upload::
    upload_toolchain_exclude () const
    {
      return this->upload_toolchain_exclude_;
    }

    inline std::multimap<string, string>& build_upload::
    upload_toolchain_exclude ()
    {
      return this->upload_toolchain_exclude_;
    }

    inline void build_upload::
    upload_toolchain_exclude (const std::multimap<string, string>& x)
    {
      this->upload_toolchain_exclude_ = x;
    }

    inline bool build_upload::
    upload_toolchain_exclude_specified () const
    {
      return this->upload_toolchain_exclude_specified_;
    }

    inline void build_upload::
    upload_toolchain_exclude_specified (bool x)
    {
      this->upload_toolchain_exclude_specified_ = x;
    }

    inline const std::multimap<string, string>& build_upload::
    upload_repository_exclude () const
    {
      return this->upload_repository_exclude_;
    }

    inline std::multimap<string, string>& build_upload::
    upload_repository_exclude ()
    {
      return this->upload_repository_exclude_;
    }

    inline void build_upload::
    upload_repository_exclude (const std::multimap<string, string>& x)
    {
      this->upload_repository_exclude_ = x;
    }

    inline bool build_upload::
    upload_repository_exclude_specified () const
    {
      return this->upload_repository_exclude_specified_;
    }

    inline void build_upload::
    upload_repository_exclude_specified (bool x)
    {
      this->upload_repository_exclude_specified_ = x;
    }

    // package_version_metadata
    //

    inline const string& package_version_metadata::
    reviews_url () const
    {
      return this->reviews_url_;
    }

    inline string& package_version_metadata::
    reviews_url ()
    {
      return this->reviews_url_;
    }

    inline void package_version_metadata::
    reviews_url (const string& x)
    {
      this->reviews_url_ = x;
    }

    inline bool package_version_metadata::
    reviews_url_specified () const
    {
      return this->reviews_url_specified_;
    }

    inline void package_version_metadata::
    reviews_url_specified (bool x)
    {
      this->reviews_url_specified_ = x;
    }

    // page
    //

    inline const web::xhtml::fragment& page::
    logo () const
    {
      return this->logo_;
    }

    inline web::xhtml::fragment& page::
    logo ()
    {
      return this->logo_;
    }

    inline void page::
    logo (const web::xhtml::fragment& x)
    {
      this->logo_ = x;
    }

    inline bool page::
    logo_specified () const
    {
      return this->logo_specified_;
    }

    inline void page::
    logo_specified (bool x)
    {
      this->logo_specified_ = x;
    }

    inline const vector<page_menu>& page::
    menu () const
    {
      return this->menu_;
    }

    inline vector<page_menu>& page::
    menu ()
    {
      return this->menu_;
    }

    inline void page::
    menu (const vector<page_menu>& x)
    {
      this->menu_ = x;
    }

    inline bool page::
    menu_specified () const
    {
      return this->menu_specified_;
    }

    inline void page::
    menu_specified (bool x)
    {
      this->menu_specified_ = x;
    }

    // search
    //

    inline const uint16_t& search::
    search_page_entries () const
    {
      return this->search_page_entries_;
    }

    inline uint16_t& search::
    search_page_entries ()
    {
      return this->search_page_entries_;
    }

    inline void search::
    search_page_entries (const uint16_t& x)
    {
      this->search_page_entries_ = x;
    }

    inline bool search::
    search_page_entries_specified () const
    {
      return this->search_page_entries_specified_;
    }

    inline void search::
    search_page_entries_specified (bool x)
    {
      this->search_page_entries_specified_ = x;
    }

    inline const uint16_t& search::
    search_pages () const
    {
      return this->search_pages_;
    }

    inline uint16_t& search::
    search_pages ()
    {
      return this->search_pages_;
    }

    inline void search::
    search_pages (const uint16_t& x)
    {
      this->search_pages_ = x;
    }

    inline bool search::
    search_pages_specified () const
    {
      return this->search_pages_specified_;
    }

    inline void search::
    search_pages_specified (bool x)
    {
      this->search_pages_specified_ = x;
    }

    // package
    //

    inline const uint16_t& package::
    package_description () const
    {
      return this->package_description_;
    }

    inline uint16_t& package::
    package_description ()
    {
      return this->package_description_;
    }

    inline void package::
    package_description (const uint16_t& x)
    {
      this->package_description_ = x;
    }

    inline bool package::
    package_description_specified () const
    {
      return this->package_description_specified_;
    }

    inline void package::
    package_description_specified (bool x)
    {
      this->package_description_specified_ = x;
    }

    inline const uint16_t& package::
    package_changes () const
    {
      return this->package_changes_;
    }

    inline uint16_t& package::
    package_changes ()
    {
      return this->package_changes_;
    }

    inline void package::
    package_changes (const uint16_t& x)
    {
      this->package_changes_ = x;
    }

    inline bool package::
    package_changes_specified () const
    {
      return this->package_changes_specified_;
    }

    inline void package::
    package_changes_specified (bool x)
    {
      this->package_changes_specified_ = x;
    }

    // packages
    //

    inline const string& packages::
    search_title () const
    {
      return this->search_title_;
    }

    inline string& packages::
    search_title ()
    {
      return this->search_title_;
    }

    inline void packages::
    search_title (const string& x)
    {
      this->search_title_ = x;
    }

    inline bool packages::
    search_title_specified () const
    {
      return this->search_title_specified_;
    }

    inline void packages::
    search_title_specified (bool x)
    {
      this->search_title_specified_ = x;
    }

    inline const web::xhtml::fragment& packages::
    search_description () const
    {
      return this->search_description_;
    }

    inline web::xhtml::fragment& packages::
    search_description ()
    {
      return this->search_description_;
    }

    inline void packages::
    search_description (const web::xhtml::fragment& x)
    {
      this->search_description_ = x;
    }

    inline bool packages::
    search_description_specified () const
    {
      return this->search_description_specified_;
    }

    inline void packages::
    search_description_specified (bool x)
    {
      this->search_description_specified_ = x;
    }

    // advanced_search
    //

    // package_details
    //

    // package_version_details
    //

    inline const dir_path& package_version_details::
    bindist_root () const
    {
      return this->bindist_root_;
    }

    inline dir_path& package_version_details::
    bindist_root ()
    {
      return this->bindist_root_;
    }

    inline void package_version_details::
    bindist_root (const dir_path& x)
    {
      this->bindist_root_ = x;
    }

    inline bool package_version_details::
    bindist_root_specified () const
    {
      return this->bindist_root_specified_;
    }

    inline void package_version_details::
    bindist_root_specified (bool x)
    {
      this->bindist_root_specified_ = x;
    }

    inline const string& package_version_details::
    bindist_url () const
    {
      return this->bindist_url_;
    }

    inline string& package_version_details::
    bindist_url ()
    {
      return this->bindist_url_;
    }

    inline void package_version_details::
    bindist_url (const string& x)
    {
      this->bindist_url_ = x;
    }

    inline bool package_version_details::
    bindist_url_specified () const
    {
      return this->bindist_url_specified_;
    }

    inline void package_version_details::
    bindist_url_specified (bool x)
    {
      this->bindist_url_specified_ = x;
    }

    // repository_details
    //

    // build_task
    //

    inline const size_t& build_task::
    build_task_request_max_size () const
    {
      return this->build_task_request_max_size_;
    }

    inline size_t& build_task::
    build_task_request_max_size ()
    {
      return this->build_task_request_max_size_;
    }

    inline void build_task::
    build_task_request_max_size (const size_t& x)
    {
      this->build_task_request_max_size_ = x;
    }

    inline bool build_task::
    build_task_request_max_size_specified () const
    {
      return this->build_task_request_max_size_specified_;
    }

    inline void build_task::
    build_task_request_max_size_specified (bool x)
    {
      this->build_task_request_max_size_specified_ = x;
    }

    inline const size_t& build_task::
    build_result_timeout () const
    {
      return this->build_result_timeout_;
    }

    inline size_t& build_task::
    build_result_timeout ()
    {
      return this->build_result_timeout_;
    }

    inline void build_task::
    build_result_timeout (const size_t& x)
    {
      this->build_result_timeout_ = x;
    }

    inline bool build_task::
    build_result_timeout_specified () const
    {
      return this->build_result_timeout_specified_;
    }

    inline void build_task::
    build_result_timeout_specified (bool x)
    {
      this->build_result_timeout_specified_ = x;
    }

    inline const vector<pair<std::regex, string>>& build_task::
    build_interactive_login () const
    {
      return this->build_interactive_login_;
    }

    inline vector<pair<std::regex, string>>& build_task::
    build_interactive_login ()
    {
      return this->build_interactive_login_;
    }

    inline void build_task::
    build_interactive_login (const vector<pair<std::regex, string>>& x)
    {
      this->build_interactive_login_ = x;
    }

    inline bool build_task::
    build_interactive_login_specified () const
    {
      return this->build_interactive_login_specified_;
    }

    inline void build_task::
    build_interactive_login_specified (bool x)
    {
      this->build_interactive_login_specified_ = x;
    }

    inline const build_order& build_task::
    build_package_order () const
    {
      return this->build_package_order_;
    }

    inline build_order& build_task::
    build_package_order ()
    {
      return this->build_package_order_;
    }

    inline void build_task::
    build_package_order (const build_order& x)
    {
      this->build_package_order_ = x;
    }

    inline bool build_task::
    build_package_order_specified () const
    {
      return this->build_package_order_specified_;
    }

    inline void build_task::
    build_package_order_specified (bool x)
    {
      this->build_package_order_specified_ = x;
    }

    // build_result
    //

    inline const size_t& build_result::
    build_result_request_max_size () const
    {
      return this->build_result_request_max_size_;
    }

    inline size_t& build_result::
    build_result_request_max_size ()
    {
      return this->build_result_request_max_size_;
    }

    inline void build_result::
    build_result_request_max_size (const size_t& x)
    {
      this->build_result_request_max_size_ = x;
    }

    inline bool build_result::
    build_result_request_max_size_specified () const
    {
      return this->build_result_request_max_size_specified_;
    }

    inline void build_result::
    build_result_request_max_size_specified (bool x)
    {
      this->build_result_request_max_size_specified_ = x;
    }

    // build_log
    //

    // build_force
    //

    // builds
    //

    inline const uint16_t& builds::
    build_page_entries () const
    {
      return this->build_page_entries_;
    }

    inline uint16_t& builds::
    build_page_entries ()
    {
      return this->build_page_entries_;
    }

    inline void builds::
    build_page_entries (const uint16_t& x)
    {
      this->build_page_entries_ = x;
    }

    inline bool builds::
    build_page_entries_specified () const
    {
      return this->build_page_entries_specified_;
    }

    inline void builds::
    build_page_entries_specified (bool x)
    {
      this->build_page_entries_specified_ = x;
    }

    inline const uint16_t& builds::
    build_pages () const
    {
      return this->build_pages_;
    }

    inline uint16_t& builds::
    build_pages ()
    {
      return this->build_pages_;
    }

    inline void builds::
    build_pages (const uint16_t& x)
    {
      this->build_pages_ = x;
    }

    inline bool builds::
    build_pages_specified () const
    {
      return this->build_pages_specified_;
    }

    inline void builds::
    build_pages_specified (bool x)
    {
      this->build_pages_specified_ = x;
    }

    // build_configs
    //

    inline const uint16_t& build_configs::
    build_config_page_entries () const
    {
      return this->build_config_page_entries_;
    }

    inline uint16_t& build_configs::
    build_config_page_entries ()
    {
      return this->build_config_page_entries_;
    }

    inline void build_configs::
    build_config_page_entries (const uint16_t& x)
    {
      this->build_config_page_entries_ = x;
    }

    inline bool build_configs::
    build_config_page_entries_specified () const
    {
      return this->build_config_page_entries_specified_;
    }

    inline void build_configs::
    build_config_page_entries_specified (bool x)
    {
      this->build_config_page_entries_specified_ = x;
    }

    inline const uint16_t& build_configs::
    build_config_pages () const
    {
      return this->build_config_pages_;
    }

    inline uint16_t& build_configs::
    build_config_pages ()
    {
      return this->build_config_pages_;
    }

    inline void build_configs::
    build_config_pages (const uint16_t& x)
    {
      this->build_config_pages_ = x;
    }

    inline bool build_configs::
    build_config_pages_specified () const
    {
      return this->build_config_pages_specified_;
    }

    inline void build_configs::
    build_config_pages_specified (bool x)
    {
      this->build_config_pages_specified_ = x;
    }

    // submit
    //

    inline const dir_path& submit::
    submit_data () const
    {
      return this->submit_data_;
    }

    inline dir_path& submit::
    submit_data ()
    {
      return this->submit_data_;
    }

    inline void submit::
    submit_data (const dir_path& x)
    {
      this->submit_data_ = x;
    }

    inline bool submit::
    submit_data_specified () const
    {
      return this->submit_data_specified_;
    }

    inline void submit::
    submit_data_specified (bool x)
    {
      this->submit_data_specified_ = x;
    }

    inline const dir_path& submit::
    submit_temp () const
    {
      return this->submit_temp_;
    }

    inline dir_path& submit::
    submit_temp ()
    {
      return this->submit_temp_;
    }

    inline void submit::
    submit_temp (const dir_path& x)
    {
      this->submit_temp_ = x;
    }

    inline bool submit::
    submit_temp_specified () const
    {
      return this->submit_temp_specified_;
    }

    inline void submit::
    submit_temp_specified (bool x)
    {
      this->submit_temp_specified_ = x;
    }

    inline const size_t& submit::
    submit_max_size () const
    {
      return this->submit_max_size_;
    }

    inline size_t& submit::
    submit_max_size ()
    {
      return this->submit_max_size_;
    }

    inline void submit::
    submit_max_size (const size_t& x)
    {
      this->submit_max_size_ = x;
    }

    inline bool submit::
    submit_max_size_specified () const
    {
      return this->submit_max_size_specified_;
    }

    inline void submit::
    submit_max_size_specified (bool x)
    {
      this->submit_max_size_specified_ = x;
    }

    inline const path& submit::
    submit_form () const
    {
      return this->submit_form_;
    }

    inline path& submit::
    submit_form ()
    {
      return this->submit_form_;
    }

    inline void submit::
    submit_form (const path& x)
    {
      this->submit_form_ = x;
    }

    inline bool submit::
    submit_form_specified () const
    {
      return this->submit_form_specified_;
    }

    inline void submit::
    submit_form_specified (bool x)
    {
      this->submit_form_specified_ = x;
    }

    inline const string& submit::
    submit_email () const
    {
      return this->submit_email_;
    }

    inline string& submit::
    submit_email ()
    {
      return this->submit_email_;
    }

    inline void submit::
    submit_email (const string& x)
    {
      this->submit_email_ = x;
    }

    inline bool submit::
    submit_email_specified () const
    {
      return this->submit_email_specified_;
    }

    inline void submit::
    submit_email_specified (bool x)
    {
      this->submit_email_specified_ = x;
    }

    inline const path& submit::
    submit_handler () const
    {
      return this->submit_handler_;
    }

    inline path& submit::
    submit_handler ()
    {
      return this->submit_handler_;
    }

    inline void submit::
    submit_handler (const path& x)
    {
      this->submit_handler_ = x;
    }

    inline bool submit::
    submit_handler_specified () const
    {
      return this->submit_handler_specified_;
    }

    inline void submit::
    submit_handler_specified (bool x)
    {
      this->submit_handler_specified_ = x;
    }

    inline const strings& submit::
    submit_handler_argument () const
    {
      return this->submit_handler_argument_;
    }

    inline strings& submit::
    submit_handler_argument ()
    {
      return this->submit_handler_argument_;
    }

    inline void submit::
    submit_handler_argument (const strings& x)
    {
      this->submit_handler_argument_ = x;
    }

    inline bool submit::
    submit_handler_argument_specified () const
    {
      return this->submit_handler_argument_specified_;
    }

    inline void submit::
    submit_handler_argument_specified (bool x)
    {
      this->submit_handler_argument_specified_ = x;
    }

    inline const size_t& submit::
    submit_handler_timeout () const
    {
      return this->submit_handler_timeout_;
    }

    inline size_t& submit::
    submit_handler_timeout ()
    {
      return this->submit_handler_timeout_;
    }

    inline void submit::
    submit_handler_timeout (const size_t& x)
    {
      this->submit_handler_timeout_ = x;
    }

    inline bool submit::
    submit_handler_timeout_specified () const
    {
      return this->submit_handler_timeout_specified_;
    }

    inline void submit::
    submit_handler_timeout_specified (bool x)
    {
      this->submit_handler_timeout_specified_ = x;
    }

    // ci_start
    //

    inline const dir_path& ci_start::
    ci_data () const
    {
      return this->ci_data_;
    }

    inline dir_path& ci_start::
    ci_data ()
    {
      return this->ci_data_;
    }

    inline void ci_start::
    ci_data (const dir_path& x)
    {
      this->ci_data_ = x;
    }

    inline bool ci_start::
    ci_data_specified () const
    {
      return this->ci_data_specified_;
    }

    inline void ci_start::
    ci_data_specified (bool x)
    {
      this->ci_data_specified_ = x;
    }

    inline const string& ci_start::
    ci_email () const
    {
      return this->ci_email_;
    }

    inline string& ci_start::
    ci_email ()
    {
      return this->ci_email_;
    }

    inline void ci_start::
    ci_email (const string& x)
    {
      this->ci_email_ = x;
    }

    inline bool ci_start::
    ci_email_specified () const
    {
      return this->ci_email_specified_;
    }

    inline void ci_start::
    ci_email_specified (bool x)
    {
      this->ci_email_specified_ = x;
    }

    inline const path& ci_start::
    ci_handler () const
    {
      return this->ci_handler_;
    }

    inline path& ci_start::
    ci_handler ()
    {
      return this->ci_handler_;
    }

    inline void ci_start::
    ci_handler (const path& x)
    {
      this->ci_handler_ = x;
    }

    inline bool ci_start::
    ci_handler_specified () const
    {
      return this->ci_handler_specified_;
    }

    inline void ci_start::
    ci_handler_specified (bool x)
    {
      this->ci_handler_specified_ = x;
    }

    inline const strings& ci_start::
    ci_handler_argument () const
    {
      return this->ci_handler_argument_;
    }

    inline strings& ci_start::
    ci_handler_argument ()
    {
      return this->ci_handler_argument_;
    }

    inline void ci_start::
    ci_handler_argument (const strings& x)
    {
      this->ci_handler_argument_ = x;
    }

    inline bool ci_start::
    ci_handler_argument_specified () const
    {
      return this->ci_handler_argument_specified_;
    }

    inline void ci_start::
    ci_handler_argument_specified (bool x)
    {
      this->ci_handler_argument_specified_ = x;
    }

    inline const size_t& ci_start::
    ci_handler_timeout () const
    {
      return this->ci_handler_timeout_;
    }

    inline size_t& ci_start::
    ci_handler_timeout ()
    {
      return this->ci_handler_timeout_;
    }

    inline void ci_start::
    ci_handler_timeout (const size_t& x)
    {
      this->ci_handler_timeout_ = x;
    }

    inline bool ci_start::
    ci_handler_timeout_specified () const
    {
      return this->ci_handler_timeout_specified_;
    }

    inline void ci_start::
    ci_handler_timeout_specified (bool x)
    {
      this->ci_handler_timeout_specified_ = x;
    }

    // ci
    //

    inline const path& ci::
    ci_form () const
    {
      return this->ci_form_;
    }

    inline path& ci::
    ci_form ()
    {
      return this->ci_form_;
    }

    inline void ci::
    ci_form (const path& x)
    {
      this->ci_form_ = x;
    }

    inline bool ci::
    ci_form_specified () const
    {
      return this->ci_form_specified_;
    }

    inline void ci::
    ci_form_specified (bool x)
    {
      this->ci_form_specified_ = x;
    }

    // ci_cancel
    //

    // ci_github
    //

    inline const path& ci_github::
    ci_github_app_webhook_secret () const
    {
      return this->ci_github_app_webhook_secret_;
    }

    inline path& ci_github::
    ci_github_app_webhook_secret ()
    {
      return this->ci_github_app_webhook_secret_;
    }

    inline void ci_github::
    ci_github_app_webhook_secret (const path& x)
    {
      this->ci_github_app_webhook_secret_ = x;
    }

    inline bool ci_github::
    ci_github_app_webhook_secret_specified () const
    {
      return this->ci_github_app_webhook_secret_specified_;
    }

    inline void ci_github::
    ci_github_app_webhook_secret_specified (bool x)
    {
      this->ci_github_app_webhook_secret_specified_ = x;
    }

    inline const std::map<uint64_t, dir_path>& ci_github::
    ci_github_app_id_private_key () const
    {
      return this->ci_github_app_id_private_key_;
    }

    inline std::map<uint64_t, dir_path>& ci_github::
    ci_github_app_id_private_key ()
    {
      return this->ci_github_app_id_private_key_;
    }

    inline void ci_github::
    ci_github_app_id_private_key (const std::map<uint64_t, dir_path>& x)
    {
      this->ci_github_app_id_private_key_ = x;
    }

    inline bool ci_github::
    ci_github_app_id_private_key_specified () const
    {
      return this->ci_github_app_id_private_key_specified_;
    }

    inline void ci_github::
    ci_github_app_id_private_key_specified (bool x)
    {
      this->ci_github_app_id_private_key_specified_ = x;
    }

    inline const uint16_t& ci_github::
    ci_github_jwt_validity_period () const
    {
      return this->ci_github_jwt_validity_period_;
    }

    inline uint16_t& ci_github::
    ci_github_jwt_validity_period ()
    {
      return this->ci_github_jwt_validity_period_;
    }

    inline void ci_github::
    ci_github_jwt_validity_period (const uint16_t& x)
    {
      this->ci_github_jwt_validity_period_ = x;
    }

    inline bool ci_github::
    ci_github_jwt_validity_period_specified () const
    {
      return this->ci_github_jwt_validity_period_specified_;
    }

    inline void ci_github::
    ci_github_jwt_validity_period_specified (bool x)
    {
      this->ci_github_jwt_validity_period_specified_ = x;
    }

    inline const std::map<uint64_t, string>& ci_github::
    ci_github_app_id_name () const
    {
      return this->ci_github_app_id_name_;
    }

    inline std::map<uint64_t, string>& ci_github::
    ci_github_app_id_name ()
    {
      return this->ci_github_app_id_name_;
    }

    inline void ci_github::
    ci_github_app_id_name (const std::map<uint64_t, string>& x)
    {
      this->ci_github_app_id_name_ = x;
    }

    inline bool ci_github::
    ci_github_app_id_name_specified () const
    {
      return this->ci_github_app_id_name_specified_;
    }

    inline void ci_github::
    ci_github_app_id_name_specified (bool x)
    {
      this->ci_github_app_id_name_specified_ = x;
    }

    inline const size_t& ci_github::
    ci_github_builds_aggregate_report () const
    {
      return this->ci_github_builds_aggregate_report_;
    }

    inline size_t& ci_github::
    ci_github_builds_aggregate_report ()
    {
      return this->ci_github_builds_aggregate_report_;
    }

    inline void ci_github::
    ci_github_builds_aggregate_report (const size_t& x)
    {
      this->ci_github_builds_aggregate_report_ = x;
    }

    inline bool ci_github::
    ci_github_builds_aggregate_report_specified () const
    {
      return this->ci_github_builds_aggregate_report_specified_;
    }

    inline void ci_github::
    ci_github_builds_aggregate_report_specified (bool x)
    {
      this->ci_github_builds_aggregate_report_specified_ = x;
    }

    inline const size_t& ci_github::
    ci_github_max_jobs_per_window () const
    {
      return this->ci_github_max_jobs_per_window_;
    }

    inline size_t& ci_github::
    ci_github_max_jobs_per_window ()
    {
      return this->ci_github_max_jobs_per_window_;
    }

    inline void ci_github::
    ci_github_max_jobs_per_window (const size_t& x)
    {
      this->ci_github_max_jobs_per_window_ = x;
    }

    inline bool ci_github::
    ci_github_max_jobs_per_window_specified () const
    {
      return this->ci_github_max_jobs_per_window_specified_;
    }

    inline void ci_github::
    ci_github_max_jobs_per_window_specified (bool x)
    {
      this->ci_github_max_jobs_per_window_specified_ = x;
    }

    // upload
    //

    // repository_root
    //

    inline const string& repository_root::
    root_global_view () const
    {
      return this->root_global_view_;
    }

    inline string& repository_root::
    root_global_view ()
    {
      return this->root_global_view_;
    }

    inline void repository_root::
    root_global_view (const string& x)
    {
      this->root_global_view_ = x;
    }

    inline bool repository_root::
    root_global_view_specified () const
    {
      return this->root_global_view_specified_;
    }

    inline void repository_root::
    root_global_view_specified (bool x)
    {
      this->root_global_view_specified_ = x;
    }

    inline const string& repository_root::
    root_tenant_view () const
    {
      return this->root_tenant_view_;
    }

    inline string& repository_root::
    root_tenant_view ()
    {
      return this->root_tenant_view_;
    }

    inline void repository_root::
    root_tenant_view (const string& x)
    {
      this->root_tenant_view_ = x;
    }

    inline bool repository_root::
    root_tenant_view_specified () const
    {
      return this->root_tenant_view_specified_;
    }

    inline void repository_root::
    root_tenant_view_specified (bool x)
    {
      this->root_tenant_view_specified_ = x;
    }
  }

  namespace params
  {
    // packages
    //

    inline const uint16_t& packages::
    page () const
    {
      return this->page_;
    }

    inline uint16_t& packages::
    page ()
    {
      return this->page_;
    }

    inline void packages::
    page (const uint16_t& x)
    {
      this->page_ = x;
    }

    inline bool packages::
    page_specified () const
    {
      return this->page_specified_;
    }

    inline void packages::
    page_specified (bool x)
    {
      this->page_specified_ = x;
    }

    inline const string& packages::
    q () const
    {
      return this->q_;
    }

    inline string& packages::
    q ()
    {
      return this->q_;
    }

    inline void packages::
    q (const string& x)
    {
      this->q_ = x;
    }

    inline bool packages::
    q_specified () const
    {
      return this->q_specified_;
    }

    inline void packages::
    q_specified (bool x)
    {
      this->q_specified_ = x;
    }

    // advanced_search
    //

    inline const uint16_t& advanced_search::
    page () const
    {
      return this->page_;
    }

    inline uint16_t& advanced_search::
    page ()
    {
      return this->page_;
    }

    inline void advanced_search::
    page (const uint16_t& x)
    {
      this->page_ = x;
    }

    inline bool advanced_search::
    page_specified () const
    {
      return this->page_specified_;
    }

    inline void advanced_search::
    page_specified (bool x)
    {
      this->page_specified_ = x;
    }

    inline const string& advanced_search::
    name () const
    {
      return this->name_;
    }

    inline string& advanced_search::
    name ()
    {
      return this->name_;
    }

    inline void advanced_search::
    name (const string& x)
    {
      this->name_ = x;
    }

    inline bool advanced_search::
    name_specified () const
    {
      return this->name_specified_;
    }

    inline void advanced_search::
    name_specified (bool x)
    {
      this->name_specified_ = x;
    }

    inline const string& advanced_search::
    version () const
    {
      return this->version_;
    }

    inline string& advanced_search::
    version ()
    {
      return this->version_;
    }

    inline void advanced_search::
    version (const string& x)
    {
      this->version_ = x;
    }

    inline bool advanced_search::
    version_specified () const
    {
      return this->version_specified_;
    }

    inline void advanced_search::
    version_specified (bool x)
    {
      this->version_specified_ = x;
    }

    inline const string& advanced_search::
    project () const
    {
      return this->project_;
    }

    inline string& advanced_search::
    project ()
    {
      return this->project_;
    }

    inline void advanced_search::
    project (const string& x)
    {
      this->project_ = x;
    }

    inline bool advanced_search::
    project_specified () const
    {
      return this->project_specified_;
    }

    inline void advanced_search::
    project_specified (bool x)
    {
      this->project_specified_ = x;
    }

    inline const string& advanced_search::
    repository () const
    {
      return this->repository_;
    }

    inline string& advanced_search::
    repository ()
    {
      return this->repository_;
    }

    inline void advanced_search::
    repository (const string& x)
    {
      this->repository_ = x;
    }

    inline bool advanced_search::
    repository_specified () const
    {
      return this->repository_specified_;
    }

    inline void advanced_search::
    repository_specified (bool x)
    {
      this->repository_specified_ = x;
    }

    inline const string& advanced_search::
    reviews () const
    {
      return this->reviews_;
    }

    inline string& advanced_search::
    reviews ()
    {
      return this->reviews_;
    }

    inline void advanced_search::
    reviews (const string& x)
    {
      this->reviews_ = x;
    }

    inline bool advanced_search::
    reviews_specified () const
    {
      return this->reviews_specified_;
    }

    inline void advanced_search::
    reviews_specified (bool x)
    {
      this->reviews_specified_ = x;
    }

    // package_details
    //

    inline const uint16_t& package_details::
    page () const
    {
      return this->page_;
    }

    inline uint16_t& package_details::
    page ()
    {
      return this->page_;
    }

    inline void package_details::
    page (const uint16_t& x)
    {
      this->page_ = x;
    }

    inline bool package_details::
    page_specified () const
    {
      return this->page_specified_;
    }

    inline void package_details::
    page_specified (bool x)
    {
      this->page_specified_ = x;
    }

    inline const string& package_details::
    query () const
    {
      return this->query_;
    }

    inline string& package_details::
    query ()
    {
      return this->query_;
    }

    inline void package_details::
    query (const string& x)
    {
      this->query_ = x;
    }

    inline bool package_details::
    query_specified () const
    {
      return this->query_specified_;
    }

    inline void package_details::
    query_specified (bool x)
    {
      this->query_specified_ = x;
    }

    inline const page_form& package_details::
    form () const
    {
      return this->form_;
    }

    inline page_form& package_details::
    form ()
    {
      return this->form_;
    }

    inline void package_details::
    form (const page_form& x)
    {
      this->form_ = x;
    }

    inline bool package_details::
    form_specified () const
    {
      return this->form_specified_;
    }

    inline void package_details::
    form_specified (bool x)
    {
      this->form_specified_ = x;
    }

    // package_version_details
    //

    inline const page_form& package_version_details::
    form () const
    {
      return this->form_;
    }

    inline page_form& package_version_details::
    form ()
    {
      return this->form_;
    }

    inline void package_version_details::
    form (const page_form& x)
    {
      this->form_ = x;
    }

    inline bool package_version_details::
    form_specified () const
    {
      return this->form_specified_;
    }

    inline void package_version_details::
    form_specified (bool x)
    {
      this->form_specified_ = x;
    }

    // repository_details
    //

    // build_task
    //

    inline const vector<string>& build_task::
    repository () const
    {
      return this->repository_;
    }

    inline vector<string>& build_task::
    repository ()
    {
      return this->repository_;
    }

    inline void build_task::
    repository (const vector<string>& x)
    {
      this->repository_ = x;
    }

    inline bool build_task::
    repository_specified () const
    {
      return this->repository_specified_;
    }

    inline void build_task::
    repository_specified (bool x)
    {
      this->repository_specified_ = x;
    }

    inline const bbot::interactive_mode& build_task::
    interactive () const
    {
      return this->interactive_;
    }

    inline bbot::interactive_mode& build_task::
    interactive ()
    {
      return this->interactive_;
    }

    inline void build_task::
    interactive (const bbot::interactive_mode& x)
    {
      this->interactive_ = x;
    }

    inline bool build_task::
    interactive_specified () const
    {
      return this->interactive_specified_;
    }

    inline void build_task::
    interactive_specified (bool x)
    {
      this->interactive_specified_ = x;
    }

    inline const vector<string>& build_task::
    tenant_service_type () const
    {
      return this->tenant_service_type_;
    }

    inline vector<string>& build_task::
    tenant_service_type ()
    {
      return this->tenant_service_type_;
    }

    inline void build_task::
    tenant_service_type (const vector<string>& x)
    {
      this->tenant_service_type_ = x;
    }

    inline bool build_task::
    tenant_service_type_specified () const
    {
      return this->tenant_service_type_specified_;
    }

    inline void build_task::
    tenant_service_type_specified (bool x)
    {
      this->tenant_service_type_specified_ = x;
    }

    // build_result
    //

    // build_log
    //

    // build_force
    //

    inline const string& build_force::
    package () const
    {
      return this->package_;
    }

    inline string& build_force::
    package ()
    {
      return this->package_;
    }

    inline void build_force::
    package (const string& x)
    {
      this->package_ = x;
    }

    inline bool build_force::
    package_specified () const
    {
      return this->package_specified_;
    }

    inline void build_force::
    package_specified (bool x)
    {
      this->package_specified_ = x;
    }

    inline const string& build_force::
    version () const
    {
      return this->version_;
    }

    inline string& build_force::
    version ()
    {
      return this->version_;
    }

    inline void build_force::
    version (const string& x)
    {
      this->version_ = x;
    }

    inline bool build_force::
    version_specified () const
    {
      return this->version_specified_;
    }

    inline void build_force::
    version_specified (bool x)
    {
      this->version_specified_ = x;
    }

    inline const string& build_force::
    target () const
    {
      return this->target_;
    }

    inline string& build_force::
    target ()
    {
      return this->target_;
    }

    inline void build_force::
    target (const string& x)
    {
      this->target_ = x;
    }

    inline bool build_force::
    target_specified () const
    {
      return this->target_specified_;
    }

    inline void build_force::
    target_specified (bool x)
    {
      this->target_specified_ = x;
    }

    inline const string& build_force::
    target_config () const
    {
      return this->target_config_;
    }

    inline string& build_force::
    target_config ()
    {
      return this->target_config_;
    }

    inline void build_force::
    target_config (const string& x)
    {
      this->target_config_ = x;
    }

    inline bool build_force::
    target_config_specified () const
    {
      return this->target_config_specified_;
    }

    inline void build_force::
    target_config_specified (bool x)
    {
      this->target_config_specified_ = x;
    }

    inline const string& build_force::
    package_config () const
    {
      return this->package_config_;
    }

    inline string& build_force::
    package_config ()
    {
      return this->package_config_;
    }

    inline void build_force::
    package_config (const string& x)
    {
      this->package_config_ = x;
    }

    inline bool build_force::
    package_config_specified () const
    {
      return this->package_config_specified_;
    }

    inline void build_force::
    package_config_specified (bool x)
    {
      this->package_config_specified_ = x;
    }

    inline const string& build_force::
    toolchain_name () const
    {
      return this->toolchain_name_;
    }

    inline string& build_force::
    toolchain_name ()
    {
      return this->toolchain_name_;
    }

    inline void build_force::
    toolchain_name (const string& x)
    {
      this->toolchain_name_ = x;
    }

    inline bool build_force::
    toolchain_name_specified () const
    {
      return this->toolchain_name_specified_;
    }

    inline void build_force::
    toolchain_name_specified (bool x)
    {
      this->toolchain_name_specified_ = x;
    }

    inline const string& build_force::
    toolchain_version () const
    {
      return this->toolchain_version_;
    }

    inline string& build_force::
    toolchain_version ()
    {
      return this->toolchain_version_;
    }

    inline void build_force::
    toolchain_version (const string& x)
    {
      this->toolchain_version_ = x;
    }

    inline bool build_force::
    toolchain_version_specified () const
    {
      return this->toolchain_version_specified_;
    }

    inline void build_force::
    toolchain_version_specified (bool x)
    {
      this->toolchain_version_specified_ = x;
    }

    inline const string& build_force::
    reason () const
    {
      return this->reason_;
    }

    inline string& build_force::
    reason ()
    {
      return this->reason_;
    }

    inline void build_force::
    reason (const string& x)
    {
      this->reason_ = x;
    }

    inline bool build_force::
    reason_specified () const
    {
      return this->reason_specified_;
    }

    inline void build_force::
    reason_specified (bool x)
    {
      this->reason_specified_ = x;
    }

    // builds
    //

    inline const uint16_t& builds::
    page () const
    {
      return this->page_;
    }

    inline uint16_t& builds::
    page ()
    {
      return this->page_;
    }

    inline void builds::
    page (const uint16_t& x)
    {
      this->page_ = x;
    }

    inline bool builds::
    page_specified () const
    {
      return this->page_specified_;
    }

    inline void builds::
    page_specified (bool x)
    {
      this->page_specified_ = x;
    }

    inline const string& builds::
    name () const
    {
      return this->name_;
    }

    inline string& builds::
    name ()
    {
      return this->name_;
    }

    inline void builds::
    name (const string& x)
    {
      this->name_ = x;
    }

    inline bool builds::
    name_specified () const
    {
      return this->name_specified_;
    }

    inline void builds::
    name_specified (bool x)
    {
      this->name_specified_ = x;
    }

    inline const string& builds::
    version () const
    {
      return this->version_;
    }

    inline string& builds::
    version ()
    {
      return this->version_;
    }

    inline void builds::
    version (const string& x)
    {
      this->version_ = x;
    }

    inline bool builds::
    version_specified () const
    {
      return this->version_specified_;
    }

    inline void builds::
    version_specified (bool x)
    {
      this->version_specified_ = x;
    }

    inline const string& builds::
    toolchain () const
    {
      return this->toolchain_;
    }

    inline string& builds::
    toolchain ()
    {
      return this->toolchain_;
    }

    inline void builds::
    toolchain (const string& x)
    {
      this->toolchain_ = x;
    }

    inline bool builds::
    toolchain_specified () const
    {
      return this->toolchain_specified_;
    }

    inline void builds::
    toolchain_specified (bool x)
    {
      this->toolchain_specified_ = x;
    }

    inline const string& builds::
    target () const
    {
      return this->target_;
    }

    inline string& builds::
    target ()
    {
      return this->target_;
    }

    inline void builds::
    target (const string& x)
    {
      this->target_ = x;
    }

    inline bool builds::
    target_specified () const
    {
      return this->target_specified_;
    }

    inline void builds::
    target_specified (bool x)
    {
      this->target_specified_ = x;
    }

    inline const string& builds::
    target_config () const
    {
      return this->target_config_;
    }

    inline string& builds::
    target_config ()
    {
      return this->target_config_;
    }

    inline void builds::
    target_config (const string& x)
    {
      this->target_config_ = x;
    }

    inline bool builds::
    target_config_specified () const
    {
      return this->target_config_specified_;
    }

    inline void builds::
    target_config_specified (bool x)
    {
      this->target_config_specified_ = x;
    }

    inline const string& builds::
    package_config () const
    {
      return this->package_config_;
    }

    inline string& builds::
    package_config ()
    {
      return this->package_config_;
    }

    inline void builds::
    package_config (const string& x)
    {
      this->package_config_ = x;
    }

    inline bool builds::
    package_config_specified () const
    {
      return this->package_config_specified_;
    }

    inline void builds::
    package_config_specified (bool x)
    {
      this->package_config_specified_ = x;
    }

    inline const string& builds::
    result () const
    {
      return this->result_;
    }

    inline string& builds::
    result ()
    {
      return this->result_;
    }

    inline void builds::
    result (const string& x)
    {
      this->result_ = x;
    }

    inline bool builds::
    result_specified () const
    {
      return this->result_specified_;
    }

    inline void builds::
    result_specified (bool x)
    {
      this->result_specified_ = x;
    }

    // build_configs
    //

    inline const string& build_configs::
    class_name () const
    {
      return this->class_name_;
    }

    inline string& build_configs::
    class_name ()
    {
      return this->class_name_;
    }

    inline void build_configs::
    class_name (const string& x)
    {
      this->class_name_ = x;
    }

    inline bool build_configs::
    class_name_specified () const
    {
      return this->class_name_specified_;
    }

    inline void build_configs::
    class_name_specified (bool x)
    {
      this->class_name_specified_ = x;
    }

    inline const uint16_t& build_configs::
    page () const
    {
      return this->page_;
    }

    inline uint16_t& build_configs::
    page ()
    {
      return this->page_;
    }

    inline void build_configs::
    page (const uint16_t& x)
    {
      this->page_ = x;
    }

    inline bool build_configs::
    page_specified () const
    {
      return this->page_specified_;
    }

    inline void build_configs::
    page_specified (bool x)
    {
      this->page_specified_ = x;
    }

    // submit
    //

    inline const string& submit::
    archive () const
    {
      return this->archive_;
    }

    inline string& submit::
    archive ()
    {
      return this->archive_;
    }

    inline void submit::
    archive (const string& x)
    {
      this->archive_ = x;
    }

    inline bool submit::
    archive_specified () const
    {
      return this->archive_specified_;
    }

    inline void submit::
    archive_specified (bool x)
    {
      this->archive_specified_ = x;
    }

    inline const string& submit::
    sha256sum () const
    {
      return this->sha256sum_;
    }

    inline string& submit::
    sha256sum ()
    {
      return this->sha256sum_;
    }

    inline void submit::
    sha256sum (const string& x)
    {
      this->sha256sum_ = x;
    }

    inline bool submit::
    sha256sum_specified () const
    {
      return this->sha256sum_specified_;
    }

    inline void submit::
    sha256sum_specified (bool x)
    {
      this->sha256sum_specified_ = x;
    }

    inline const string& submit::
    simulate () const
    {
      return this->simulate_;
    }

    inline string& submit::
    simulate ()
    {
      return this->simulate_;
    }

    inline void submit::
    simulate (const string& x)
    {
      this->simulate_ = x;
    }

    inline bool submit::
    simulate_specified () const
    {
      return this->simulate_specified_;
    }

    inline void submit::
    simulate_specified (bool x)
    {
      this->simulate_specified_ = x;
    }

    // ci
    //

    inline const bpkg::repository_location& ci::
    repository () const
    {
      return this->repository_;
    }

    inline bpkg::repository_location& ci::
    repository ()
    {
      return this->repository_;
    }

    inline void ci::
    repository (const bpkg::repository_location& x)
    {
      this->repository_ = x;
    }

    inline bool ci::
    repository_specified () const
    {
      return this->repository_specified_;
    }

    inline void ci::
    repository_specified (bool x)
    {
      this->repository_specified_ = x;
    }

    inline const strings& ci::
    package () const
    {
      return this->package_;
    }

    inline strings& ci::
    package ()
    {
      return this->package_;
    }

    inline void ci::
    package (const strings& x)
    {
      this->package_ = x;
    }

    inline bool ci::
    package_specified () const
    {
      return this->package_specified_;
    }

    inline void ci::
    package_specified (bool x)
    {
      this->package_specified_ = x;
    }

    inline const string& ci::
    overrides () const
    {
      return this->overrides_;
    }

    inline string& ci::
    overrides ()
    {
      return this->overrides_;
    }

    inline void ci::
    overrides (const string& x)
    {
      this->overrides_ = x;
    }

    inline bool ci::
    overrides_specified () const
    {
      return this->overrides_specified_;
    }

    inline void ci::
    overrides_specified (bool x)
    {
      this->overrides_specified_ = x;
    }

    inline const string& ci::
    interactive () const
    {
      return this->interactive_;
    }

    inline string& ci::
    interactive ()
    {
      return this->interactive_;
    }

    inline void ci::
    interactive (const string& x)
    {
      this->interactive_ = x;
    }

    inline bool ci::
    interactive_specified () const
    {
      return this->interactive_specified_;
    }

    inline void ci::
    interactive_specified (bool x)
    {
      this->interactive_specified_ = x;
    }

    inline const string& ci::
    simulate () const
    {
      return this->simulate_;
    }

    inline string& ci::
    simulate ()
    {
      return this->simulate_;
    }

    inline void ci::
    simulate (const string& x)
    {
      this->simulate_ = x;
    }

    inline bool ci::
    simulate_specified () const
    {
      return this->simulate_specified_;
    }

    inline void ci::
    simulate_specified (bool x)
    {
      this->simulate_specified_ = x;
    }

    // ci_cancel
    //

    inline const string& ci_cancel::
    id () const
    {
      return this->id_;
    }

    inline string& ci_cancel::
    id ()
    {
      return this->id_;
    }

    inline void ci_cancel::
    id (const string& x)
    {
      this->id_ = x;
    }

    inline bool ci_cancel::
    id_specified () const
    {
      return this->id_specified_;
    }

    inline void ci_cancel::
    id_specified (bool x)
    {
      this->id_specified_ = x;
    }

    inline const string& ci_cancel::
    reason () const
    {
      return this->reason_;
    }

    inline string& ci_cancel::
    reason ()
    {
      return this->reason_;
    }

    inline void ci_cancel::
    reason (const string& x)
    {
      this->reason_ = x;
    }

    inline bool ci_cancel::
    reason_specified () const
    {
      return this->reason_specified_;
    }

    inline void ci_cancel::
    reason_specified (bool x)
    {
      this->reason_specified_ = x;
    }

    // upload
    //

    inline const string& upload::
    type () const
    {
      return this->type_;
    }

    inline string& upload::
    type ()
    {
      return this->type_;
    }

    inline void upload::
    type (const string& x)
    {
      this->type_ = x;
    }

    inline bool upload::
    type_specified () const
    {
      return this->type_specified_;
    }

    inline void upload::
    type_specified (bool x)
    {
      this->type_specified_ = x;
    }

    inline const string& upload::
    session () const
    {
      return this->session_;
    }

    inline string& upload::
    session ()
    {
      return this->session_;
    }

    inline void upload::
    session (const string& x)
    {
      this->session_ = x;
    }

    inline bool upload::
    session_specified () const
    {
      return this->session_specified_;
    }

    inline void upload::
    session_specified (bool x)
    {
      this->session_specified_ = x;
    }

    inline const string& upload::
    challenge () const
    {
      return this->challenge_;
    }

    inline string& upload::
    challenge ()
    {
      return this->challenge_;
    }

    inline void upload::
    challenge (const string& x)
    {
      this->challenge_ = x;
    }

    inline bool upload::
    challenge_specified () const
    {
      return this->challenge_specified_;
    }

    inline void upload::
    challenge_specified (bool x)
    {
      this->challenge_specified_ = x;
    }

    inline const string& upload::
    instance () const
    {
      return this->instance_;
    }

    inline string& upload::
    instance ()
    {
      return this->instance_;
    }

    inline void upload::
    instance (const string& x)
    {
      this->instance_ = x;
    }

    inline bool upload::
    instance_specified () const
    {
      return this->instance_specified_;
    }

    inline void upload::
    instance_specified (bool x)
    {
      this->instance_specified_ = x;
    }

    inline const string& upload::
    archive () const
    {
      return this->archive_;
    }

    inline string& upload::
    archive ()
    {
      return this->archive_;
    }

    inline void upload::
    archive (const string& x)
    {
      this->archive_ = x;
    }

    inline bool upload::
    archive_specified () const
    {
      return this->archive_specified_;
    }

    inline void upload::
    archive_specified (bool x)
    {
      this->archive_specified_ = x;
    }

    inline const string& upload::
    sha256sum () const
    {
      return this->sha256sum_;
    }

    inline string& upload::
    sha256sum ()
    {
      return this->sha256sum_;
    }

    inline void upload::
    sha256sum (const string& x)
    {
      this->sha256sum_ = x;
    }

    inline bool upload::
    sha256sum_specified () const
    {
      return this->sha256sum_specified_;
    }

    inline void upload::
    sha256sum_specified (bool x)
    {
      this->sha256sum_specified_ = x;
    }
  }
}

// Begin epilogue.
//
//
// End epilogue.
