// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

#ifndef LOAD_LOAD_OPTIONS_HXX
#define LOAD_LOAD_OPTIONS_HXX

// Begin prologue.
//
//
// End prologue.

#include <iosfwd>
#include <string>
#include <cstddef>
#include <exception>

#ifndef CLI_POTENTIALLY_UNUSED
#  if defined(_MSC_VER) || defined(__xlC__)
#    define CLI_POTENTIALLY_UNUSED(x) (void*)&x
#  else
#    define CLI_POTENTIALLY_UNUSED(x) (void)x
#  endif
#endif

namespace cli
{
  class usage_para
  {
    public:
    enum value
    {
      none,
      text,
      option
    };

    usage_para (value);

    operator value () const 
    {
      return v_;
    }

    private:
    value v_;
  };

  class unknown_mode
  {
    public:
    enum value
    {
      skip,
      stop,
      fail
    };

    unknown_mode (value);

    operator value () const 
    {
      return v_;
    }

    private:
    value v_;
  };

  // Exceptions.
  //

  class exception: public std::exception
  {
    public:
    virtual void
    print (::std::ostream&) const = 0;
  };

  ::std::ostream&
  operator<< (::std::ostream&, const exception&);

  class unknown_option: public exception
  {
    public:
    virtual
    ~unknown_option () noexcept;

    unknown_option (const std::string& option);

    const std::string&
    option () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const noexcept;

    private:
    std::string option_;
  };

  class unknown_argument: public exception
  {
    public:
    virtual
    ~unknown_argument () noexcept;

    unknown_argument (const std::string& argument);

    const std::string&
    argument () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const noexcept;

    private:
    std::string argument_;
  };

  class missing_value: public exception
  {
    public:
    virtual
    ~missing_value () noexcept;

    missing_value (const std::string& option);

    const std::string&
    option () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const noexcept;

    private:
    std::string option_;
  };

  class invalid_value: public exception
  {
    public:
    virtual
    ~invalid_value () noexcept;

    invalid_value (const std::string& option,
                   const std::string& value,
                   const std::string& message = std::string ());

    const std::string&
    option () const;

    const std::string&
    value () const;

    const std::string&
    message () const;

    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const noexcept;

    private:
    std::string option_;
    std::string value_;
    std::string message_;
  };

  class eos_reached: public exception
  {
    public:
    virtual void
    print (::std::ostream&) const;

    virtual const char*
    what () const noexcept;
  };

  // Command line argument scanner interface.
  //
  // The values returned by next() are guaranteed to be valid
  // for the two previous arguments up until a call to a third
  // peek() or next().
  //
  // The position() function returns a monotonically-increasing
  // number which, if stored, can later be used to determine the
  // relative position of the argument returned by the following
  // call to next(). Note that if multiple scanners are used to
  // extract arguments from multiple sources, then the end
  // position of the previous scanner should be used as the
  // start position of the next.
  //
  class scanner
  {
    public:
    virtual
    ~scanner ();

    virtual bool
    more () = 0;

    virtual const char*
    peek () = 0;

    virtual const char*
    next () = 0;

    virtual void
    skip () = 0;

    virtual std::size_t
    position () = 0;
  };

  class argv_scanner: public scanner
  {
    public:
    argv_scanner (int& argc,
                  char** argv,
                  bool erase = false,
                  std::size_t start_position = 0);

    argv_scanner (int start,
                  int& argc,
                  char** argv,
                  bool erase = false,
                  std::size_t start_position = 0);

    int
    end () const;

    virtual bool
    more ();

    virtual const char*
    peek ();

    virtual const char*
    next ();

    virtual void
    skip ();

    virtual std::size_t
    position ();

    protected:
    std::size_t start_position_;
    int i_;
    int& argc_;
    char** argv_;
    bool erase_;
  };

  template <typename X>
  struct parser;
}

#include <vector>

#include <string>

#include <cstdint>

#include <libbrep/types.hxx>

#include <load/options-types.hxx>

class options
{
  public:
  options ();

  options (int& argc,
           char** argv,
           bool erase = false,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  options (int start,
           int& argc,
           char** argv,
           bool erase = false,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  options (int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  options (int start,
           int& argc,
           char** argv,
           int& end,
           bool erase = false,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  options (::cli::scanner&,
           ::cli::unknown_mode option = ::cli::unknown_mode::fail,
           ::cli::unknown_mode argument = ::cli::unknown_mode::stop);

  // Option accessors and modifiers.
  //
  const bool&
  ignore_unknown () const;

  bool&
  ignore_unknown ();

  void
  ignore_unknown (const bool&);

  const bool&
  force () const;

  bool&
  force ();

  void
  force (const bool&);

  const bool&
  shallow () const;

  bool&
  shallow ();

  void
  shallow (const bool&);

  const bool&
  ignore_unresolv_tests () const;

  bool&
  ignore_unresolv_tests ();

  void
  ignore_unresolv_tests (const bool&);

  const brep::ignore_unresolved_conditional_dependencies&
  ignore_unresolv_cond () const;

  brep::ignore_unresolved_conditional_dependencies&
  ignore_unresolv_cond ();

  void
  ignore_unresolv_cond (const brep::ignore_unresolved_conditional_dependencies&);

  bool
  ignore_unresolv_cond_specified () const;

  void
  ignore_unresolv_cond_specified (bool);

  const std::string&
  tenant () const;

  std::string&
  tenant ();

  void
  tenant (const std::string&);

  bool
  tenant_specified () const;

  void
  tenant_specified (bool);

  const bool&
  existing_tenant () const;

  bool&
  existing_tenant ();

  void
  existing_tenant (const bool&);

  const bool&
  private_ () const;

  bool&
  private_ ();

  void
  private_ (const bool&);

  const std::string&
  interactive () const;

  std::string&
  interactive ();

  void
  interactive (const std::string&);

  bool
  interactive_specified () const;

  void
  interactive_specified (bool);

  const std::string&
  service_id () const;

  std::string&
  service_id ();

  void
  service_id (const std::string&);

  bool
  service_id_specified () const;

  void
  service_id_specified (bool);

  const std::string&
  service_type () const;

  std::string&
  service_type ();

  void
  service_type (const std::string&);

  bool
  service_type_specified () const;

  void
  service_type_specified (bool);

  const std::string&
  service_data () const;

  std::string&
  service_data ();

  void
  service_data (const std::string&);

  bool
  service_data_specified () const;

  void
  service_data_specified (bool);

  const brep::dir_path&
  metadata () const;

  brep::dir_path&
  metadata ();

  void
  metadata (const brep::dir_path&);

  bool
  metadata_specified () const;

  void
  metadata_specified (bool);

  const bool&
  metadata_changed () const;

  bool&
  metadata_changed ();

  void
  metadata_changed (const bool&);

  const brep::path&
  overrides_file () const;

  brep::path&
  overrides_file ();

  void
  overrides_file (const brep::path&);

  bool
  overrides_file_specified () const;

  void
  overrides_file_specified (bool);

  const std::string&
  db_user () const;

  std::string&
  db_user ();

  void
  db_user (const std::string&);

  bool
  db_user_specified () const;

  void
  db_user_specified (bool);

  const std::string&
  db_password () const;

  std::string&
  db_password ();

  void
  db_password (const std::string&);

  bool
  db_password_specified () const;

  void
  db_password_specified (bool);

  const std::string&
  db_name () const;

  std::string&
  db_name ();

  void
  db_name (const std::string&);

  bool
  db_name_specified () const;

  void
  db_name_specified (bool);

  const std::string&
  db_host () const;

  std::string&
  db_host ();

  void
  db_host (const std::string&);

  bool
  db_host_specified () const;

  void
  db_host_specified (bool);

  const std::uint16_t&
  db_port () const;

  std::uint16_t&
  db_port ();

  void
  db_port (const std::uint16_t&);

  bool
  db_port_specified () const;

  void
  db_port_specified (bool);

  const brep::path&
  bpkg () const;

  brep::path&
  bpkg ();

  void
  bpkg (const brep::path&);

  bool
  bpkg_specified () const;

  void
  bpkg_specified (bool);

  const brep::strings&
  bpkg_option () const;

  brep::strings&
  bpkg_option ();

  void
  bpkg_option (const brep::strings&);

  bool
  bpkg_option_specified () const;

  void
  bpkg_option_specified (bool);

  const brep::path&
  openssl () const;

  brep::path&
  openssl ();

  void
  openssl (const brep::path&);

  bool
  openssl_specified () const;

  void
  openssl_specified (bool);

  const brep::strings&
  openssl_option () const;

  brep::strings&
  openssl_option ();

  void
  openssl_option (const brep::strings&);

  bool
  openssl_option_specified () const;

  void
  openssl_option_specified (bool);

  const std::string&
  pager () const;

  std::string&
  pager ();

  void
  pager (const std::string&);

  bool
  pager_specified () const;

  void
  pager_specified (bool);

  const std::vector<std::string>&
  pager_option () const;

  std::vector<std::string>&
  pager_option ();

  void
  pager_option (const std::vector<std::string>&);

  bool
  pager_option_specified () const;

  void
  pager_option_specified (bool);

  const bool&
  help () const;

  bool&
  help ();

  void
  help (const bool&);

  const bool&
  version () const;

  bool&
  version ();

  void
  version (const bool&);

  // Print usage information.
  //
  static ::cli::usage_para
  print_usage (::std::ostream&,
               ::cli::usage_para = ::cli::usage_para::none);

  // Implementation details.
  //
  protected:
  bool
  _parse (const char*, ::cli::scanner&);

  private:
  bool
  _parse (::cli::scanner&,
          ::cli::unknown_mode option,
          ::cli::unknown_mode argument);

  public:
  bool ignore_unknown_;
  bool force_;
  bool shallow_;
  bool ignore_unresolv_tests_;
  brep::ignore_unresolved_conditional_dependencies ignore_unresolv_cond_;
  bool ignore_unresolv_cond_specified_;
  std::string tenant_;
  bool tenant_specified_;
  bool existing_tenant_;
  bool private__;
  std::string interactive_;
  bool interactive_specified_;
  std::string service_id_;
  bool service_id_specified_;
  std::string service_type_;
  bool service_type_specified_;
  std::string service_data_;
  bool service_data_specified_;
  brep::dir_path metadata_;
  bool metadata_specified_;
  bool metadata_changed_;
  brep::path overrides_file_;
  bool overrides_file_specified_;
  std::string db_user_;
  bool db_user_specified_;
  std::string db_password_;
  bool db_password_specified_;
  std::string db_name_;
  bool db_name_specified_;
  std::string db_host_;
  bool db_host_specified_;
  std::uint16_t db_port_;
  bool db_port_specified_;
  brep::path bpkg_;
  bool bpkg_specified_;
  brep::strings bpkg_option_;
  bool bpkg_option_specified_;
  brep::path openssl_;
  bool openssl_specified_;
  brep::strings openssl_option_;
  bool openssl_option_specified_;
  std::string pager_;
  bool pager_specified_;
  std::vector<std::string> pager_option_;
  bool pager_option_specified_;
  bool help_;
  bool version_;
};

// Print page usage information.
//
::cli::usage_para
print_usage (::std::ostream&,
             ::cli::usage_para = ::cli::usage_para::none);

#include <load/load-options.ixx>

// Begin epilogue.
//
//
// End epilogue.

#endif // LOAD_LOAD_OPTIONS_HXX
