// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#include <odb/pre.hxx>

#include <libbrep/common-odb.hxx>

#include <cassert>
#include <cstring>  // std::memcpy


#include <odb/pgsql/traits.hxx>
#include <odb/pgsql/database.hxx>
#include <odb/pgsql/transaction.hxx>
#include <odb/pgsql/connection.hxx>
#include <odb/pgsql/statement.hxx>
#include <odb/pgsql/statement-cache.hxx>
#include <odb/pgsql/container-statements.hxx>
#include <odb/pgsql/exceptions.hxx>

namespace odb
{
  // _version
  //

  bool access::composite_value_traits< ::brep::_version, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // epoch
    //
    t[0UL] = 0;

    // canonical_upstream
    //
    if (t[1UL])
    {
      i.canonical_upstream_value.capacity (i.canonical_upstream_size);
      grew = true;
    }

    // canonical_release
    //
    if (t[2UL])
    {
      i.canonical_release_value.capacity (i.canonical_release_size);
      grew = true;
    }

    // revision
    //
    t[3UL] = 0;

    // upstream
    //
    if (t[4UL])
    {
      i.upstream_value.capacity (i.upstream_size);
      grew = true;
    }

    // release
    //
    if (t[5UL])
    {
      i.release_value.capacity (i.release_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::_version, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // epoch
    //
    b[n].type = pgsql::bind::integer;
    b[n].buffer = &i.epoch_value;
    b[n].is_null = &i.epoch_null;
    n++;

    // canonical_upstream
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.canonical_upstream_value.data_ptr ();
    b[n].capacity = i.canonical_upstream_value.capacity ();
    b[n].size = &i.canonical_upstream_size;
    b[n].is_null = &i.canonical_upstream_null;
    n++;

    // canonical_release
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.canonical_release_value.data_ptr ();
    b[n].capacity = i.canonical_release_value.capacity ();
    b[n].size = &i.canonical_release_size;
    b[n].is_null = &i.canonical_release_null;
    n++;

    // revision
    //
    b[n].type = pgsql::bind::integer;
    b[n].buffer = &i.revision_value;
    b[n].is_null = &i.revision_null;
    n++;

    // upstream
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.upstream_value.data_ptr ();
    b[n].capacity = i.upstream_value.capacity ();
    b[n].size = &i.upstream_size;
    b[n].is_null = &i.upstream_null;
    n++;

    // release
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.release_value.data_ptr ();
    b[n].capacity = i.release_value.capacity ();
    b[n].size = &i.release_size;
    b[n].is_null = &i.release_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::_version, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // epoch
    //
    {
      ::uint16_t const& v =
        o.epoch;

      bool is_null (false);
      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_image (
        i.epoch_value, is_null, v);
      i.epoch_null = is_null;
    }

    // canonical_upstream
    //
    {
      ::std::string const& v =
        o.canonical_upstream;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.canonical_upstream_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.canonical_upstream_value,
        size,
        is_null,
        v);
      i.canonical_upstream_null = is_null;
      i.canonical_upstream_size = size;
      grew = grew || (cap != i.canonical_upstream_value.capacity ());
    }

    // canonical_release
    //
    {
      ::std::string const& v =
        o.canonical_release;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.canonical_release_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.canonical_release_value,
        size,
        is_null,
        v);
      i.canonical_release_null = is_null;
      i.canonical_release_size = size;
      grew = grew || (cap != i.canonical_release_value.capacity ());
    }

    // revision
    //
    {
      ::butl::optional< short unsigned int > const& v =
        o.revision;

      bool is_null (true);
      pgsql::value_traits<
          ::butl::optional< short unsigned int >,
          pgsql::id_integer >::set_image (
        i.revision_value, is_null, v);
      i.revision_null = is_null;
    }

    // upstream
    //
    {
      ::std::string const& v =
        o.upstream;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.upstream_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.upstream_value,
        size,
        is_null,
        v);
      i.upstream_null = is_null;
      i.upstream_size = size;
      grew = grew || (cap != i.upstream_value.capacity ());
    }

    // release
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.release;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.release_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.release_value,
        size,
        is_null,
        v);
      i.release_null = is_null;
      i.release_size = size;
      grew = grew || (cap != i.release_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::_version, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // epoch
    //
    {
      ::uint16_t& v =
        o.epoch;

      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_value (
        v,
        i.epoch_value,
        i.epoch_null);
    }

    // canonical_upstream
    //
    {
      ::std::string& v =
        o.canonical_upstream;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.canonical_upstream_value,
        i.canonical_upstream_size,
        i.canonical_upstream_null);
    }

    // canonical_release
    //
    {
      ::std::string& v =
        o.canonical_release;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.canonical_release_value,
        i.canonical_release_size,
        i.canonical_release_null);
    }

    // revision
    //
    {
      ::butl::optional< short unsigned int >& v =
        o.revision;

      pgsql::value_traits<
          ::butl::optional< short unsigned int >,
          pgsql::id_integer >::set_value (
        v,
        i.revision_value,
        i.revision_null);
    }

    // upstream
    //
    {
      ::std::string& v =
        o.upstream;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.upstream_value,
        i.upstream_size,
        i.upstream_null);
    }

    // release
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.release;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.release_value,
        i.release_size,
        i.release_null);
    }
  }

  // email
  //

  bool access::composite_value_traits< ::bpkg::email, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // value
    //
    if (t[0UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    // comment
    //
    if (t[1UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::email, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // value
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.value_value.data_ptr ();
    b[n].capacity = i.value_value.capacity ();
    b[n].size = &i.value_size;
    b[n].is_null = &i.value_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::email, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // value
    //
    {
      // From common.hxx:398:58
      ::std::string const& v =
        o;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.value_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.value_value,
        size,
        is_null,
        v);
      i.value_null = is_null;
      i.value_size = size;
      grew = grew || (cap != i.value_value.capacity ());
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::email, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // value
    //
    {
      // From common.hxx:398:58
      ::std::string& v =
        o;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.value_value,
        i.value_size,
        i.value_null);
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // version_constraint
  //

  bool access::composite_value_traits< ::bpkg::version_constraint, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // min_version
    //
    if (composite_value_traits< ::brep::_version, id_pgsql >::grow (
          i.min_version_value, t + 0UL))
      grew = true;

    // max_version
    //
    if (composite_value_traits< ::brep::_version, id_pgsql >::grow (
          i.max_version_value, t + 6UL))
      grew = true;

    // min_open
    //
    t[12UL] = 0;

    // max_open
    //
    t[13UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::bpkg::version_constraint, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // min_version
    //
    composite_value_traits< ::brep::_version, id_pgsql >::bind (
      b + n, i.min_version_value, sk);
    n += 6UL;

    // max_version
    //
    composite_value_traits< ::brep::_version, id_pgsql >::bind (
      b + n, i.max_version_value, sk);
    n += 6UL;

    // min_open
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.min_open_value;
    b[n].is_null = &i.min_open_null;
    n++;

    // max_open
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.max_open_value;
    b[n].is_null = &i.max_open_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::version_constraint, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // min_version
    //
    {
      ::butl::optional< ::bpkg::version > const& v =
        o.min_version;

      // From common.hxx:79:12
      ::brep::_optional_version const& vt =
        (v) ? brep::_version 
      {
         (v)->epoch, (v)->canonical_upstream, (v)->canonical_release, (v)->revision, (v)->upstream, (v)->release 
      } : brep::_optional_version ();

      if (wrapper_traits< ::brep::_optional_version >::get_null (vt))
        composite_value_traits< ::brep::_version, id_pgsql >::set_null (
          i.min_version_value, sk);
      else
      {
        const::brep::_version& vw = 
          wrapper_traits< ::brep::_optional_version >::get_ref (vt);

        if (composite_value_traits< ::brep::_version, id_pgsql >::init (
              i.min_version_value,
              vw,
              sk))
          grew = true;
      }
    }

    // max_version
    //
    {
      ::butl::optional< ::bpkg::version > const& v =
        o.max_version;

      // From common.hxx:79:12
      ::brep::_optional_version const& vt =
        (v) ? brep::_version 
      {
         (v)->epoch, (v)->canonical_upstream, (v)->canonical_release, (v)->revision, (v)->upstream, (v)->release 
      } : brep::_optional_version ();

      if (wrapper_traits< ::brep::_optional_version >::get_null (vt))
        composite_value_traits< ::brep::_version, id_pgsql >::set_null (
          i.max_version_value, sk);
      else
      {
        const::brep::_version& vw = 
          wrapper_traits< ::brep::_optional_version >::get_ref (vt);

        if (composite_value_traits< ::brep::_version, id_pgsql >::init (
              i.max_version_value,
              vw,
              sk))
          grew = true;
      }
    }

    // min_open
    //
    {
      bool const& v =
        o.min_open;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.min_open_value, is_null, v);
      i.min_open_null = is_null;
    }

    // max_open
    //
    {
      bool const& v =
        o.max_open;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.max_open_value, is_null, v);
      i.max_open_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::version_constraint, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // min_version
    //
    {
      ::butl::optional< ::bpkg::version >& v =
        o.min_version;

      ::brep::_optional_version vt;

      if (composite_value_traits< ::brep::_version, id_pgsql >::get_null (
            i.min_version_value))
        wrapper_traits< ::brep::_optional_version >::set_null (vt);
      else
      {
        ::brep::_version& vw =
          wrapper_traits< ::brep::_optional_version >::set_ref (vt);

        composite_value_traits< ::brep::_version, id_pgsql >::init (
          vw,
          i.min_version_value,
          db);
      }

      // From common.hxx:79:12
      v = (vt) ? bpkg::version ((vt)->epoch, std::move ((vt)->upstream), std::move ((vt)->release), (vt)->revision, 0) : brep::optional_version ();
    }

    // max_version
    //
    {
      ::butl::optional< ::bpkg::version >& v =
        o.max_version;

      ::brep::_optional_version vt;

      if (composite_value_traits< ::brep::_version, id_pgsql >::get_null (
            i.max_version_value))
        wrapper_traits< ::brep::_optional_version >::set_null (vt);
      else
      {
        ::brep::_version& vw =
          wrapper_traits< ::brep::_optional_version >::set_ref (vt);

        composite_value_traits< ::brep::_version, id_pgsql >::init (
          vw,
          i.max_version_value,
          db);
      }

      // From common.hxx:79:12
      v = (vt) ? bpkg::version ((vt)->epoch, std::move ((vt)->upstream), std::move ((vt)->release), (vt)->revision, 0) : brep::optional_version ();
    }

    // min_open
    //
    {
      bool& v =
        o.min_open;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.min_open_value,
        i.min_open_null);
    }

    // max_open
    //
    {
      bool& v =
        o.max_open;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.max_open_value,
        i.max_open_null);
    }
  }

  // requirement_alternative
  //

  bool access::composite_value_traits< ::bpkg::requirement_alternative, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // enable
    //
    if (t[0UL])
    {
      i.enable_value.capacity (i.enable_size);
      grew = true;
    }

    // reflect
    //
    if (t[1UL])
    {
      i.reflect_value.capacity (i.reflect_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::requirement_alternative, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // enable
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.enable_value.data_ptr ();
    b[n].capacity = i.enable_value.capacity ();
    b[n].size = &i.enable_size;
    b[n].is_null = &i.enable_null;
    n++;

    // reflect
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.reflect_value.data_ptr ();
    b[n].capacity = i.reflect_value.capacity ();
    b[n].size = &i.reflect_size;
    b[n].is_null = &i.reflect_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::requirement_alternative, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.enable;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.enable_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.enable_value,
        size,
        is_null,
        v);
      i.enable_null = is_null;
      i.enable_size = size;
      grew = grew || (cap != i.enable_value.capacity ());
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.reflect;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.reflect_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.reflect_value,
        size,
        is_null,
        v);
      i.reflect_null = is_null;
      i.reflect_size = size;
      grew = grew || (cap != i.reflect_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::requirement_alternative, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.enable;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.enable_value,
        i.enable_size,
        i.enable_null);
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.reflect;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.reflect_value,
        i.reflect_size,
        i.reflect_null);
    }
  }

  // requirement_alternatives
  //

  bool access::composite_value_traits< ::bpkg::requirement_alternatives, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // buildtime
    //
    t[0UL] = 0;

    // comment
    //
    if (t[1UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::requirement_alternatives, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // buildtime
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.buildtime_value;
    b[n].is_null = &i.buildtime_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::requirement_alternatives, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // buildtime
    //
    {
      bool const& v =
        o.buildtime;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.buildtime_value, is_null, v);
      i.buildtime_null = is_null;
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::requirement_alternatives, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // buildtime
    //
    {
      bool& v =
        o.buildtime;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.buildtime_value,
        i.buildtime_null);
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // build_constraint
  //

  bool access::composite_value_traits< ::bpkg::build_constraint, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // exclusion
    //
    t[0UL] = 0;

    // config
    //
    if (t[1UL])
    {
      i.config_value.capacity (i.config_size);
      grew = true;
    }

    // target
    //
    if (t[2UL])
    {
      i.target_value.capacity (i.target_size);
      grew = true;
    }

    // comment
    //
    if (t[3UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::build_constraint, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // exclusion
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.exclusion_value;
    b[n].is_null = &i.exclusion_null;
    n++;

    // config
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.config_value.data_ptr ();
    b[n].capacity = i.config_value.capacity ();
    b[n].size = &i.config_size;
    b[n].is_null = &i.config_null;
    n++;

    // target
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.target_value.data_ptr ();
    b[n].capacity = i.target_value.capacity ();
    b[n].size = &i.target_size;
    b[n].is_null = &i.target_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::build_constraint, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // exclusion
    //
    {
      bool const& v =
        o.exclusion;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.exclusion_value, is_null, v);
      i.exclusion_null = is_null;
    }

    // config
    //
    {
      ::std::string const& v =
        o.config;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.config_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.config_value,
        size,
        is_null,
        v);
      i.config_null = is_null;
      i.config_size = size;
      grew = grew || (cap != i.config_value.capacity ());
    }

    // target
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.target;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.target_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.target_value,
        size,
        is_null,
        v);
      i.target_null = is_null;
      i.target_size = size;
      grew = grew || (cap != i.target_value.capacity ());
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::build_constraint, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // exclusion
    //
    {
      bool& v =
        o.exclusion;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.exclusion_value,
        i.exclusion_null);
    }

    // config
    //
    {
      ::std::string& v =
        o.config;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.config_value,
        i.config_size,
        i.config_null);
    }

    // target
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.target;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.target_value,
        i.target_size,
        i.target_null);
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // build_class_expr
  //

  bool access::composite_value_traits< ::bpkg::build_class_expr, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // expression
    //
    if (t[0UL])
    {
      i.expression_value.capacity (i.expression_size);
      grew = true;
    }

    // comment
    //
    if (t[1UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::build_class_expr, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // expression
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.expression_value.data_ptr ();
    b[n].capacity = i.expression_value.capacity ();
    b[n].size = &i.expression_size;
    b[n].is_null = &i.expression_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::build_class_expr, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // expression
    //
    {
      // From common.hxx:367:5
      ::std::string const& v =
        o.string ();

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.expression_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.expression_value,
        size,
        is_null,
        v);
      i.expression_null = is_null;
      i.expression_size = size;
      grew = grew || (cap != i.expression_value.capacity ());
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::build_class_expr, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // expression
    //
    {
      // From common.hxx:368:5
      ::std::string v;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.expression_value,
        i.expression_size,
        i.expression_null);

      // From common.hxx:368:5
      o = brep::build_class_expr ((v), "");
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // build_auxiliary
  //

  bool access::composite_value_traits< ::bpkg::build_auxiliary, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // environment_name
    //
    if (t[0UL])
    {
      i.environment_name_value.capacity (i.environment_name_size);
      grew = true;
    }

    // config
    //
    if (t[1UL])
    {
      i.config_value.capacity (i.config_size);
      grew = true;
    }

    // comment
    //
    if (t[2UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::build_auxiliary, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // environment_name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.environment_name_value.data_ptr ();
    b[n].capacity = i.environment_name_value.capacity ();
    b[n].size = &i.environment_name_size;
    b[n].is_null = &i.environment_name_null;
    n++;

    // config
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.config_value.data_ptr ();
    b[n].capacity = i.config_value.capacity ();
    b[n].size = &i.config_size;
    b[n].is_null = &i.config_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::build_auxiliary, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // environment_name
    //
    {
      ::std::string const& v =
        o.environment_name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.environment_name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.environment_name_value,
        size,
        is_null,
        v);
      i.environment_name_null = is_null;
      i.environment_name_size = size;
      grew = grew || (cap != i.environment_name_value.capacity ());
    }

    // config
    //
    {
      ::std::string const& v =
        o.config;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.config_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.config_value,
        size,
        is_null,
        v);
      i.config_null = is_null;
      i.config_size = size;
      grew = grew || (cap != i.config_value.capacity ());
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::build_auxiliary, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // environment_name
    //
    {
      ::std::string& v =
        o.environment_name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.environment_name_value,
        i.environment_name_size,
        i.environment_name_null);
    }

    // config
    //
    {
      ::std::string& v =
        o.config;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.config_value,
        i.config_size,
        i.config_null);
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // canonical_version
  //

  bool access::composite_value_traits< ::brep::canonical_version, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // epoch
    //
    t[0UL] = 0;

    // canonical_upstream
    //
    if (t[1UL])
    {
      i.canonical_upstream_value.capacity (i.canonical_upstream_size);
      grew = true;
    }

    // canonical_release
    //
    if (t[2UL])
    {
      i.canonical_release_value.capacity (i.canonical_release_size);
      grew = true;
    }

    // revision
    //
    t[3UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::canonical_version, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // epoch
    //
    b[n].type = pgsql::bind::integer;
    b[n].buffer = &i.epoch_value;
    b[n].is_null = &i.epoch_null;
    n++;

    // canonical_upstream
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.canonical_upstream_value.data_ptr ();
    b[n].capacity = i.canonical_upstream_value.capacity ();
    b[n].size = &i.canonical_upstream_size;
    b[n].is_null = &i.canonical_upstream_null;
    n++;

    // canonical_release
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.canonical_release_value.data_ptr ();
    b[n].capacity = i.canonical_release_value.capacity ();
    b[n].size = &i.canonical_release_size;
    b[n].is_null = &i.canonical_release_null;
    n++;

    // revision
    //
    b[n].type = pgsql::bind::integer;
    b[n].buffer = &i.revision_value;
    b[n].is_null = &i.revision_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::canonical_version, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // epoch
    //
    {
      ::uint16_t const& v =
        o.epoch;

      bool is_null (false);
      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_image (
        i.epoch_value, is_null, v);
      i.epoch_null = is_null;
    }

    // canonical_upstream
    //
    {
      ::std::string const& v =
        o.canonical_upstream;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.canonical_upstream_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.canonical_upstream_value,
        size,
        is_null,
        v);
      i.canonical_upstream_null = is_null;
      i.canonical_upstream_size = size;
      grew = grew || (cap != i.canonical_upstream_value.capacity ());
    }

    // canonical_release
    //
    {
      ::std::string const& v =
        o.canonical_release;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.canonical_release_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.canonical_release_value,
        size,
        is_null,
        v);
      i.canonical_release_null = is_null;
      i.canonical_release_size = size;
      grew = grew || (cap != i.canonical_release_value.capacity ());
    }

    // revision
    //
    {
      ::uint16_t const& v =
        o.revision;

      bool is_null (false);
      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_image (
        i.revision_value, is_null, v);
      i.revision_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::canonical_version, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // epoch
    //
    {
      ::uint16_t& v =
        o.epoch;

      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_value (
        v,
        i.epoch_value,
        i.epoch_null);
    }

    // canonical_upstream
    //
    {
      ::std::string& v =
        o.canonical_upstream;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.canonical_upstream_value,
        i.canonical_upstream_size,
        i.canonical_upstream_null);
    }

    // canonical_release
    //
    {
      ::std::string& v =
        o.canonical_release;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.canonical_release_value,
        i.canonical_release_size,
        i.canonical_release_null);
    }

    // revision
    //
    {
      ::uint16_t& v =
        o.revision;

      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_value (
        v,
        i.revision_value,
        i.revision_null);
    }
  }

  // upstream_version
  //

  bool access::composite_value_traits< ::brep::upstream_version, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // upstream_
    //
    if (t[0UL])
    {
      i.upstream_value.capacity (i.upstream_size);
      grew = true;
    }

    // release_
    //
    if (t[1UL])
    {
      i.release_value.capacity (i.release_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::upstream_version, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // upstream_
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.upstream_value.data_ptr ();
    b[n].capacity = i.upstream_value.capacity ();
    b[n].size = &i.upstream_size;
    b[n].is_null = &i.upstream_null;
    n++;

    // release_
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.release_value.data_ptr ();
    b[n].capacity = i.release_value.capacity ();
    b[n].size = &i.release_size;
    b[n].is_null = &i.release_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::upstream_version, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // upstream_
    //
    {
      // From common.hxx:225:7
      ::std::string const& v =
        o.upstream;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.upstream_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.upstream_value,
        size,
        is_null,
        v);
      i.upstream_null = is_null;
      i.upstream_size = size;
      grew = grew || (cap != i.upstream_value.capacity ());
    }

    // release_
    //
    {
      // From common.hxx:230:7
      ::brep::optional_string const& v =
        o.release;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.release_value.capacity ());
      pgsql::value_traits<
          ::brep::optional_string,
          pgsql::id_string >::set_image (
        i.release_value,
        size,
        is_null,
        v);
      i.release_null = is_null;
      i.release_size = size;
      grew = grew || (cap != i.release_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::upstream_version, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // upstream_
    //
    {
      // From common.hxx:226:7
      ::std::string v;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.upstream_value,
        i.upstream_size,
        i.upstream_null);

      // From common.hxx:226:7
      o = brep::version (0, std::move (v), std::string (), brep::nullopt, 0);
    }

    // release_
    //
    {
      // From common.hxx:231:7
      ::brep::optional_string v;

      pgsql::value_traits<
          ::brep::optional_string,
          pgsql::id_string >::set_value (
        v,
        i.release_value,
        i.release_size,
        i.release_null);

      // From common.hxx:231:7
      o = brep::version (0, std::move (o.upstream), std::move (v), brep::nullopt, 0);
    }
  }

  // package_id
  //

  bool access::composite_value_traits< ::brep::package_id, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // tenant
    //
    if (t[0UL])
    {
      i.tenant_value.capacity (i.tenant_size);
      grew = true;
    }

    // name
    //
    if (t[1UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // version
    //
    if (composite_value_traits< ::brep::canonical_version, id_pgsql >::grow (
          i.version_value, t + 2UL))
      grew = true;

    return grew;
  }

  void access::composite_value_traits< ::brep::package_id, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // tenant
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.tenant_value.data_ptr ();
    b[n].capacity = i.tenant_value.capacity ();
    b[n].size = &i.tenant_size;
    b[n].is_null = &i.tenant_null;
    n++;

    // name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.name_value.data_ptr ();
    b[n].capacity = i.name_value.capacity ();
    b[n].size = &i.name_size;
    b[n].is_null = &i.name_null;
    n++;

    // version
    //
    composite_value_traits< ::brep::canonical_version, id_pgsql >::bind (
      b + n, i.version_value, sk);
    n += 4UL;
  }

  bool access::composite_value_traits< ::brep::package_id, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // tenant
    //
    {
      ::std::string const& v =
        o.tenant;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.tenant_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.tenant_value,
        size,
        is_null,
        v);
      i.tenant_null = is_null;
      i.tenant_size = size;
      grew = grew || (cap != i.tenant_value.capacity ());
    }

    // name
    //
    {
      ::bpkg::package_name const& v =
        o.name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.name_value.capacity ());
      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_image (
        i.name_value,
        size,
        is_null,
        v);
      i.name_null = is_null;
      i.name_size = size;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // version
    //
    {
      ::brep::canonical_version const& v =
        o.version;

      if (composite_value_traits< ::brep::canonical_version, id_pgsql >::init (
            i.version_value,
            v,
            sk))
        grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::package_id, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // tenant
    //
    {
      ::std::string& v =
        o.tenant;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.tenant_value,
        i.tenant_size,
        i.tenant_null);
    }

    // name
    //
    {
      ::bpkg::package_name& v =
        o.name;

      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // version
    //
    {
      ::brep::canonical_version& v =
        o.version;

      composite_value_traits< ::brep::canonical_version, id_pgsql >::init (
        v,
        i.version_value,
        db);
    }
  }

  // _repository_location
  //

  bool access::composite_value_traits< ::brep::_repository_location, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // url
    //
    if (t[0UL])
    {
      i.url_value.capacity (i.url_size);
      grew = true;
    }

    // type
    //
    if (t[1UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::_repository_location, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // url
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.url_value.data_ptr ();
    b[n].capacity = i.url_value.capacity ();
    b[n].size = &i.url_size;
    b[n].is_null = &i.url_null;
    n++;

    // type
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.type_value.data_ptr ();
    b[n].capacity = i.type_value.capacity ();
    b[n].size = &i.type_size;
    b[n].is_null = &i.type_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::_repository_location, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // url
    //
    {
      ::bpkg::repository_url const& v =
        o.url;

      // From common.hxx:306:14
      ::std::string const& vt =
        (v).string ();

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.url_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.url_value,
        size,
        is_null,
        vt);
      i.url_null = is_null;
      i.url_size = size;
      grew = grew || (cap != i.url_value.capacity ());
    }

    // type
    //
    {
      ::bpkg::repository_type const& v =
        o.type;

      // From common.hxx:298:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.type_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.type_value,
        size,
        is_null,
        vt);
      i.type_null = is_null;
      i.type_size = size;
      grew = grew || (cap != i.type_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::_repository_location, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // url
    //
    {
      ::bpkg::repository_url& v =
        o.url;

      ::std::string vt;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        vt,
        i.url_value,
        i.url_size,
        i.url_null);

      // From common.hxx:306:14
      v = (vt).empty () ? brep::repository_url () : brep::repository_url (vt);
    }

    // type
    //
    {
      ::bpkg::repository_type& v =
        o.type;

      ::std::string vt;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        vt,
        i.type_value,
        i.type_size,
        i.type_null);

      // From common.hxx:298:14
      v = brep::to_repository_type (vt);
    }
  }

  // repository_id
  //

  bool access::composite_value_traits< ::brep::repository_id, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // tenant
    //
    if (t[0UL])
    {
      i.tenant_value.capacity (i.tenant_size);
      grew = true;
    }

    // canonical_name
    //
    if (t[1UL])
    {
      i.canonical_name_value.capacity (i.canonical_name_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::repository_id, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // tenant
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.tenant_value.data_ptr ();
    b[n].capacity = i.tenant_value.capacity ();
    b[n].size = &i.tenant_size;
    b[n].is_null = &i.tenant_null;
    n++;

    // canonical_name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.canonical_name_value.data_ptr ();
    b[n].capacity = i.canonical_name_value.capacity ();
    b[n].size = &i.canonical_name_size;
    b[n].is_null = &i.canonical_name_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::repository_id, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // tenant
    //
    {
      ::std::string const& v =
        o.tenant;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.tenant_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.tenant_value,
        size,
        is_null,
        v);
      i.tenant_null = is_null;
      i.tenant_size = size;
      grew = grew || (cap != i.tenant_value.capacity ());
    }

    // canonical_name
    //
    {
      ::std::string const& v =
        o.canonical_name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.canonical_name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.canonical_name_value,
        size,
        is_null,
        v);
      i.canonical_name_null = is_null;
      i.canonical_name_size = size;
      grew = grew || (cap != i.canonical_name_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::repository_id, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // tenant
    //
    {
      ::std::string& v =
        o.tenant;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.tenant_value,
        i.tenant_size,
        i.tenant_null);
    }

    // canonical_name
    //
    {
      ::std::string& v =
        o.canonical_name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.canonical_name_value,
        i.canonical_name_size,
        i.canonical_name_null);
    }
  }

  // public_key_id
  //

  bool access::composite_value_traits< ::brep::public_key_id, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // tenant
    //
    if (t[0UL])
    {
      i.tenant_value.capacity (i.tenant_size);
      grew = true;
    }

    // fingerprint
    //
    if (t[1UL])
    {
      i.fingerprint_value.capacity (i.fingerprint_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::public_key_id, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // tenant
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.tenant_value.data_ptr ();
    b[n].capacity = i.tenant_value.capacity ();
    b[n].size = &i.tenant_size;
    b[n].is_null = &i.tenant_null;
    n++;

    // fingerprint
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.fingerprint_value.data_ptr ();
    b[n].capacity = i.fingerprint_value.capacity ();
    b[n].size = &i.fingerprint_size;
    b[n].is_null = &i.fingerprint_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::public_key_id, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // tenant
    //
    {
      ::std::string const& v =
        o.tenant;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.tenant_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.tenant_value,
        size,
        is_null,
        v);
      i.tenant_null = is_null;
      i.tenant_size = size;
      grew = grew || (cap != i.tenant_value.capacity ());
    }

    // fingerprint
    //
    {
      ::std::string const& v =
        o.fingerprint;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.fingerprint_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.fingerprint_value,
        size,
        is_null,
        v);
      i.fingerprint_null = is_null;
      i.fingerprint_size = size;
      grew = grew || (cap != i.fingerprint_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::public_key_id, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // tenant
    //
    {
      ::std::string& v =
        o.tenant;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.tenant_value,
        i.tenant_size,
        i.tenant_null);
    }

    // fingerprint
    //
    {
      ::std::string& v =
        o.fingerprint;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.fingerprint_value,
        i.fingerprint_size,
        i.fingerprint_null);
    }
  }

  // build_toolchain
  //

  bool access::composite_value_traits< ::brep::build_toolchain, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // version
    //
    if (composite_value_traits< ::brep::_version, id_pgsql >::grow (
          i.version_value, t + 1UL))
      grew = true;

    return grew;
  }

  void access::composite_value_traits< ::brep::build_toolchain, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.name_value.data_ptr ();
    b[n].capacity = i.name_value.capacity ();
    b[n].size = &i.name_size;
    b[n].is_null = &i.name_null;
    n++;

    // version
    //
    composite_value_traits< ::brep::_version, id_pgsql >::bind (
      b + n, i.version_value, sk);
    n += 6UL;
  }

  bool access::composite_value_traits< ::brep::build_toolchain, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // name
    //
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.name_value,
        size,
        is_null,
        v);
      i.name_null = is_null;
      i.name_size = size;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // version
    //
    {
      ::bpkg::version const& v =
        o.version;

      // From common.hxx:66:12
      ::brep::_version const& vt =
        brep::_version 
      {
         (v).epoch, (v).canonical_upstream, (v).canonical_release, (v).revision, (v).upstream, (v).release 
      };


      if (composite_value_traits< ::brep::_version, id_pgsql >::init (
            i.version_value,
            vt,
            sk))
        grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_toolchain, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // version
    //
    {
      ::bpkg::version& v =
        o.version;

      ::brep::_version vt;

      composite_value_traits< ::brep::_version, id_pgsql >::init (
        vt,
        i.version_value,
        db);

      // From common.hxx:66:12
      v = bpkg::version ((vt).epoch, std::move ((vt).upstream), std::move ((vt).release), (vt).revision, 0);
    }
  }

  // build_class_expr_key
  //

  bool access::composite_value_traits< ::brep::build_class_expr_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // inner
    //
    t[1UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::build_class_expr_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::build_class_expr_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::build_class_expr_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::build_class_expr_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // inner
    //
    {
      ::brep::build_class_expr_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::build_class_expr_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_class_expr_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::build_class_expr_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::build_class_expr_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // inner
    //
    {
      ::brep::build_class_expr_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::build_class_expr_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // build_constraint_key
  //

  bool access::composite_value_traits< ::brep::build_constraint_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // inner
    //
    t[1UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::build_constraint_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::build_constraint_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::build_constraint_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::build_constraint_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // inner
    //
    {
      ::brep::build_constraint_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::build_constraint_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_constraint_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::build_constraint_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::build_constraint_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // inner
    //
    {
      ::brep::build_constraint_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::build_constraint_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // build_auxiliary_key
  //

  bool access::composite_value_traits< ::brep::build_auxiliary_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // inner
    //
    t[1UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::build_auxiliary_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::build_auxiliary_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::build_auxiliary_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::build_auxiliary_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // inner
    //
    {
      ::brep::build_auxiliary_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::build_auxiliary_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_auxiliary_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::build_auxiliary_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::build_auxiliary_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // inner
    //
    {
      ::brep::build_auxiliary_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::build_auxiliary_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // requirement_alternative_key
  //

  bool access::composite_value_traits< ::brep::requirement_alternative_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // inner
    //
    t[1UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::requirement_alternative_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::requirement_alternative_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::requirement_alternative_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::requirement_alternative_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // inner
    //
    {
      ::brep::requirement_alternative_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::requirement_alternative_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::requirement_alternative_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::requirement_alternative_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::requirement_alternative_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // inner
    //
    {
      ::brep::requirement_alternative_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::requirement_alternative_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // requirement_key
  //

  bool access::composite_value_traits< ::brep::requirement_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // middle
    //
    t[1UL] = 0;

    // inner
    //
    t[2UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::requirement_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // middle
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.middle_value;
    b[n].is_null = &i.middle_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::requirement_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::requirement_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::requirement_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // middle
    //
    {
      ::brep::requirement_key::middle_type const& v =
        o.middle;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::requirement_key::middle_type,
          pgsql::id_bigint >::set_image (
        i.middle_value, is_null, v);
      i.middle_null = is_null;
    }

    // inner
    //
    {
      ::brep::requirement_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::requirement_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::requirement_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::requirement_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::requirement_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // middle
    //
    {
      ::brep::requirement_key::middle_type& v =
        o.middle;

      pgsql::value_traits<
          ::brep::requirement_key::middle_type,
          pgsql::id_bigint >::set_value (
        v,
        i.middle_value,
        i.middle_null);
    }

    // inner
    //
    {
      ::brep::requirement_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::requirement_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // tenant_service
  //

  bool access::composite_value_traits< ::brep::tenant_service, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (t[0UL])
    {
      i.id_value.capacity (i.id_size);
      grew = true;
    }

    // type
    //
    if (t[1UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    // ref_count
    //
    t[2UL] = 0;

    // data
    //
    if (t[3UL])
    {
      i.data_value.capacity (i.data_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::tenant_service, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // id
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.id_value.data_ptr ();
    b[n].capacity = i.id_value.capacity ();
    b[n].size = &i.id_size;
    b[n].is_null = &i.id_null;
    n++;

    // type
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.type_value.data_ptr ();
    b[n].capacity = i.type_value.capacity ();
    b[n].size = &i.type_size;
    b[n].is_null = &i.type_null;
    n++;

    // ref_count
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.ref_count_value;
    b[n].is_null = &i.ref_count_null;
    n++;

    // data
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.data_value.data_ptr ();
    b[n].capacity = i.data_value.capacity ();
    b[n].size = &i.data_size;
    b[n].is_null = &i.data_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::tenant_service, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // id
    //
    {
      ::std::string const& v =
        o.id;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.id_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.id_value,
        size,
        is_null,
        v);
      i.id_null = is_null;
      i.id_size = size;
      grew = grew || (cap != i.id_value.capacity ());
    }

    // type
    //
    {
      ::std::string const& v =
        o.type;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.type_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.type_value,
        size,
        is_null,
        v);
      i.type_null = is_null;
      i.type_size = size;
      grew = grew || (cap != i.type_value.capacity ());
    }

    // ref_count
    //
    {
      ::uint64_t const& v =
        o.ref_count;

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.ref_count_value, is_null, v);
      i.ref_count_null = is_null;
    }

    // data
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.data;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.data_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.data_value,
        size,
        is_null,
        v);
      i.data_null = is_null;
      i.data_size = size;
      grew = grew || (cap != i.data_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::tenant_service, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::std::string& v =
        o.id;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.id_value,
        i.id_size,
        i.id_null);
    }

    // type
    //
    {
      ::std::string& v =
        o.type;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.type_value,
        i.type_size,
        i.type_null);
    }

    // ref_count
    //
    {
      ::uint64_t& v =
        o.ref_count;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        v,
        i.ref_count_value,
        i.ref_count_null);
    }

    // data
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.data;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.data_value,
        i.data_size,
        i.data_null);
    }
  }
}

#include <odb/post.hxx>
