/* This file was generated by ODB, object-relational mapping (ORM)
 * compiler for C++.
 */

DROP TABLE IF EXISTS "build_delay" CASCADE;

DROP TABLE IF EXISTS "build_results" CASCADE;

DROP TABLE IF EXISTS "build_auxiliary_machines" CASCADE;

DROP TABLE IF EXISTS "build" CASCADE;

DROP TABLE IF EXISTS "schema_version";

CREATE TABLE "build" (
  "package_tenant" TEXT NOT NULL,
  "package_name" CITEXT NOT NULL,
  "package_version_epoch" INTEGER NOT NULL,
  "package_version_canonical_upstream" TEXT NOT NULL,
  "package_version_canonical_release" TEXT NOT NULL COLLATE "C",
  "package_version_revision" INTEGER NOT NULL,
  "target" TEXT NOT NULL,
  "target_config_name" TEXT NOT NULL,
  "package_config_name" TEXT NOT NULL,
  "toolchain_name" TEXT NOT NULL,
  "toolchain_version_epoch" INTEGER NOT NULL,
  "toolchain_version_canonical_upstream" TEXT NOT NULL,
  "toolchain_version_canonical_release" TEXT NOT NULL COLLATE "C",
  "toolchain_version_revision" INTEGER NOT NULL,
  "package_version_upstream" TEXT NOT NULL,
  "package_version_release" TEXT NULL,
  "toolchain_version_upstream" TEXT NOT NULL,
  "toolchain_version_release" TEXT NULL,
  "state" TEXT NOT NULL,
  "interactive" TEXT NULL,
  "timestamp" BIGINT NOT NULL,
  "force" TEXT NOT NULL,
  "status" TEXT NULL,
  "soft_timestamp" BIGINT NOT NULL,
  "hard_timestamp" BIGINT NOT NULL,
  "agent_fingerprint" TEXT NULL,
  "agent_challenge" TEXT NULL,
  "controller_checksum" TEXT NOT NULL,
  "machine_checksum" TEXT NOT NULL,
  "agent_checksum" TEXT NULL,
  "worker_checksum" TEXT NULL,
  "dependency_checksum" TEXT NULL,
  "machine" TEXT NOT NULL,
  "machine_summary" TEXT NOT NULL,
  PRIMARY KEY ("package_tenant",
               "package_name",
               "package_version_epoch",
               "package_version_canonical_upstream",
               "package_version_canonical_release",
               "package_version_revision",
               "target",
               "target_config_name",
               "package_config_name",
               "toolchain_name",
               "toolchain_version_epoch",
               "toolchain_version_canonical_upstream",
               "toolchain_version_canonical_release",
               "toolchain_version_revision"));

CREATE INDEX "build_timestamp_i"
  ON "build" ("timestamp");

CREATE TABLE "build_auxiliary_machines" (
  "package_tenant" TEXT NOT NULL,
  "package_name" CITEXT NOT NULL,
  "package_version_epoch" INTEGER NOT NULL,
  "package_version_canonical_upstream" TEXT NOT NULL,
  "package_version_canonical_release" TEXT NOT NULL COLLATE "C",
  "package_version_revision" INTEGER NOT NULL,
  "target" TEXT NOT NULL,
  "target_config_name" TEXT NOT NULL,
  "package_config_name" TEXT NOT NULL,
  "toolchain_name" TEXT NOT NULL,
  "toolchain_version_epoch" INTEGER NOT NULL,
  "toolchain_version_canonical_upstream" TEXT NOT NULL,
  "toolchain_version_canonical_release" TEXT NOT NULL COLLATE "C",
  "toolchain_version_revision" INTEGER NOT NULL,
  "index" BIGINT NOT NULL,
  "name" TEXT NOT NULL,
  "summary" TEXT NOT NULL,
  CONSTRAINT "object_id_fk"
    FOREIGN KEY ("package_tenant",
                 "package_name",
                 "package_version_epoch",
                 "package_version_canonical_upstream",
                 "package_version_canonical_release",
                 "package_version_revision",
                 "target",
                 "target_config_name",
                 "package_config_name",
                 "toolchain_name",
                 "toolchain_version_epoch",
                 "toolchain_version_canonical_upstream",
                 "toolchain_version_canonical_release",
                 "toolchain_version_revision")
    REFERENCES "build" ("package_tenant",
                        "package_name",
                        "package_version_epoch",
                        "package_version_canonical_upstream",
                        "package_version_canonical_release",
                        "package_version_revision",
                        "target",
                        "target_config_name",
                        "package_config_name",
                        "toolchain_name",
                        "toolchain_version_epoch",
                        "toolchain_version_canonical_upstream",
                        "toolchain_version_canonical_release",
                        "toolchain_version_revision")
    ON DELETE CASCADE);

CREATE INDEX "build_auxiliary_machines_object_id_i"
  ON "build_auxiliary_machines" (
    "package_tenant",
    "package_name",
    "package_version_epoch",
    "package_version_canonical_upstream",
    "package_version_canonical_release",
    "package_version_revision",
    "target",
    "target_config_name",
    "package_config_name",
    "toolchain_name",
    "toolchain_version_epoch",
    "toolchain_version_canonical_upstream",
    "toolchain_version_canonical_release",
    "toolchain_version_revision");

CREATE INDEX "build_auxiliary_machines_index_i"
  ON "build_auxiliary_machines" ("index");

CREATE TABLE "build_results" (
  "package_tenant" TEXT NOT NULL,
  "package_name" CITEXT NOT NULL,
  "package_version_epoch" INTEGER NOT NULL,
  "package_version_canonical_upstream" TEXT NOT NULL,
  "package_version_canonical_release" TEXT NOT NULL COLLATE "C",
  "package_version_revision" INTEGER NOT NULL,
  "target" TEXT NOT NULL,
  "target_config_name" TEXT NOT NULL,
  "package_config_name" TEXT NOT NULL,
  "toolchain_name" TEXT NOT NULL,
  "toolchain_version_epoch" INTEGER NOT NULL,
  "toolchain_version_canonical_upstream" TEXT NOT NULL,
  "toolchain_version_canonical_release" TEXT NOT NULL COLLATE "C",
  "toolchain_version_revision" INTEGER NOT NULL,
  "index" BIGINT NOT NULL,
  "operation" TEXT NOT NULL,
  "status" TEXT NOT NULL,
  "log" TEXT NOT NULL,
  CONSTRAINT "object_id_fk"
    FOREIGN KEY ("package_tenant",
                 "package_name",
                 "package_version_epoch",
                 "package_version_canonical_upstream",
                 "package_version_canonical_release",
                 "package_version_revision",
                 "target",
                 "target_config_name",
                 "package_config_name",
                 "toolchain_name",
                 "toolchain_version_epoch",
                 "toolchain_version_canonical_upstream",
                 "toolchain_version_canonical_release",
                 "toolchain_version_revision")
    REFERENCES "build" ("package_tenant",
                        "package_name",
                        "package_version_epoch",
                        "package_version_canonical_upstream",
                        "package_version_canonical_release",
                        "package_version_revision",
                        "target",
                        "target_config_name",
                        "package_config_name",
                        "toolchain_name",
                        "toolchain_version_epoch",
                        "toolchain_version_canonical_upstream",
                        "toolchain_version_canonical_release",
                        "toolchain_version_revision")
    ON DELETE CASCADE);

CREATE INDEX "build_results_object_id_i"
  ON "build_results" (
    "package_tenant",
    "package_name",
    "package_version_epoch",
    "package_version_canonical_upstream",
    "package_version_canonical_release",
    "package_version_revision",
    "target",
    "target_config_name",
    "package_config_name",
    "toolchain_name",
    "toolchain_version_epoch",
    "toolchain_version_canonical_upstream",
    "toolchain_version_canonical_release",
    "toolchain_version_revision");

CREATE INDEX "build_results_index_i"
  ON "build_results" ("index");

CREATE TABLE "build_delay" (
  "package_tenant" TEXT NOT NULL,
  "package_name" CITEXT NOT NULL,
  "package_version_epoch" INTEGER NOT NULL,
  "package_version_canonical_upstream" TEXT NOT NULL,
  "package_version_canonical_release" TEXT NOT NULL COLLATE "C",
  "package_version_revision" INTEGER NOT NULL,
  "target" TEXT NOT NULL,
  "target_config_name" TEXT NOT NULL,
  "package_config_name" TEXT NOT NULL,
  "toolchain_name" TEXT NOT NULL,
  "toolchain_version_epoch" INTEGER NOT NULL,
  "toolchain_version_canonical_upstream" TEXT NOT NULL,
  "toolchain_version_canonical_release" TEXT NOT NULL COLLATE "C",
  "toolchain_version_revision" INTEGER NOT NULL,
  "package_version_upstream" TEXT NOT NULL,
  "package_version_release" TEXT NULL,
  "toolchain_version_upstream" TEXT NOT NULL,
  "toolchain_version_release" TEXT NULL,
  "report_soft_timestamp" BIGINT NOT NULL,
  "report_hard_timestamp" BIGINT NOT NULL,
  "package_timestamp" BIGINT NOT NULL,
  PRIMARY KEY ("package_tenant",
               "package_name",
               "package_version_epoch",
               "package_version_canonical_upstream",
               "package_version_canonical_release",
               "package_version_revision",
               "target",
               "target_config_name",
               "package_config_name",
               "toolchain_name",
               "toolchain_version_epoch",
               "toolchain_version_canonical_upstream",
               "toolchain_version_canonical_release",
               "toolchain_version_revision"));

CREATE TABLE "schema_version" (
  "name" TEXT NOT NULL PRIMARY KEY,
  "version" BIGINT NOT NULL,
  "migration" BOOLEAN NOT NULL);

INSERT INTO "schema_version" (
  "name", "version", "migration")
  VALUES ('build', 29, FALSE);

