// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#ifndef LIBBREP_BUILD_ODB_HXX
#define LIBBREP_BUILD_ODB_HXX

#include <odb/version.hxx>

#if ODB_VERSION != 20500UL
#error ODB runtime version mismatch
#endif

#include <odb/pre.hxx>

#include <libbrep/build.hxx>

#include <libbrep/build-package-odb.hxx>
#include <libbrep/common-odb.hxx>

#include <memory>
#include <cstddef>
#include <utility>

#include <odb/core.hxx>
#include <odb/traits.hxx>
#include <odb/callback.hxx>
#include <odb/wrapper-traits.hxx>
#include <odb/pointer-traits.hxx>
#include <odb/container-traits.hxx>
#include <odb/session.hxx>
#include <odb/cache-traits.hxx>
#include <odb/prepared-query.hxx>
#include <odb/result.hxx>
#include <odb/simple-object-result.hxx>
#include <odb/view-image.hxx>
#include <odb/view-result.hxx>

#include <odb/details/unused.hxx>
#include <odb/details/shared-ptr.hxx>

namespace odb
{
  // build
  //
  template <>
  struct class_traits< ::brep::build >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::build >
  {
    public:
    typedef ::brep::build object_type;
    typedef ::std::shared_ptr< ::brep::build > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::brep::build_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // toolchain
  //
  template <>
  struct class_traits< ::brep::toolchain >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::toolchain >
  {
    public:
    typedef ::brep::toolchain view_type;
    typedef ::brep::toolchain* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // package_build
  //
  template <>
  struct class_traits< ::brep::package_build >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::package_build >
  {
    public:
    typedef ::brep::package_build view_type;
    typedef ::brep::package_build* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // package_build_count
  //
  template <>
  struct class_traits< ::brep::package_build_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::package_build_count >
  {
    public:
    typedef ::brep::package_build_count view_type;
    typedef ::brep::package_build_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // package_build_id
  //
  template <>
  struct class_traits< ::brep::package_build_id >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::brep::package_build_id >
  {
    public:
    typedef ::brep::package_build_id view_type;
    typedef ::brep::package_build_id* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // build_delay
  //
  template <>
  struct class_traits< ::brep::build_delay >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::brep::build_delay >
  {
    public:
    typedef ::brep::build_delay object_type;
    typedef ::std::shared_ptr< ::brep::build_delay > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::brep::build_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };
}

#include <odb/details/buffer.hxx>

#include <odb/pgsql/version.hxx>
#include <odb/pgsql/forward.hxx>
#include <odb/pgsql/binding.hxx>
#include <odb/pgsql/pgsql-types.hxx>
#include <odb/pgsql/query.hxx>

namespace odb
{
  // operation_result
  //
  template <>
  class access::composite_value_traits< ::bbot::operation_result, id_pgsql >
  {
    public:
    typedef ::bbot::operation_result value_type;

    struct image_type
    {
      // operation
      //
      details::buffer operation_value;
      std::size_t operation_size;
      bool operation_null;

      // status
      //
      details::buffer status_value;
      std::size_t status_size;
      bool status_null;

      // log
      //
      details::buffer log_value;
      std::size_t log_size;
      bool log_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 3UL;
  };

  // build_id
  //
  template <>
  class access::composite_value_traits< ::brep::build_id, id_pgsql >
  {
    public:
    typedef ::brep::build_id value_type;

    struct image_type
    {
      // package
      //
      composite_value_traits< ::brep::package_id, id_pgsql >::image_type package_value;

      // target
      //
      details::buffer target_value;
      std::size_t target_size;
      bool target_null;

      // target_config_name
      //
      details::buffer target_config_name_value;
      std::size_t target_config_name_size;
      bool target_config_name_null;

      // package_config_name
      //
      details::buffer package_config_name_value;
      std::size_t package_config_name_size;
      bool package_config_name_null;

      // toolchain_name
      //
      details::buffer toolchain_name_value;
      std::size_t toolchain_name_size;
      bool toolchain_name_null;

      // toolchain_version
      //
      composite_value_traits< ::brep::canonical_version, id_pgsql >::image_type toolchain_version_value;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 14UL;
  };

  // build_machine
  //
  template <>
  class access::composite_value_traits< ::brep::build_machine, id_pgsql >
  {
    public:
    typedef ::brep::build_machine value_type;

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // summary
      //
      details::buffer summary_value;
      std::size_t summary_size;
      bool summary_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          pgsql::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              pgsql::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // build
  //
  template <typename A>
  struct query_columns< ::brep::build, id_pgsql, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // package
      //
      struct package_class_1_
      {
        package_class_1_ ()
        {
        }

        // tenant
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        tenant_type_;

        static const tenant_type_ tenant;

        // name
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::bpkg::package_name,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        name_type_;

        static const name_type_ name;

        // version
        //
        struct version_class_2_
        {
          version_class_2_ ()
          {
          }

          // epoch
          //
          typedef
          pgsql::query_column<
            pgsql::value_traits<
              ::uint16_t,
              pgsql::id_integer >::query_type,
            pgsql::id_integer >
          epoch_type_;

          static const epoch_type_ epoch;

          // canonical_upstream
          //
          typedef
          pgsql::query_column<
            pgsql::value_traits<
              ::std::string,
              pgsql::id_string >::query_type,
            pgsql::id_string >
          canonical_upstream_type_;

          static const canonical_upstream_type_ canonical_upstream;

          // canonical_release
          //
          typedef
          pgsql::query_column<
            pgsql::value_traits<
              ::std::string,
              pgsql::id_string >::query_type,
            pgsql::id_string >
          canonical_release_type_;

          static const canonical_release_type_ canonical_release;

          // revision
          //
          typedef
          pgsql::query_column<
            pgsql::value_traits<
              ::uint16_t,
              pgsql::id_integer >::query_type,
            pgsql::id_integer >
          revision_type_;

          static const revision_type_ revision;
        };

        static const version_class_2_ version;
      };

      static const package_class_1_ package;

      // target
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::butl::target_triplet,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      target_type_;

      static const target_type_ target;

      // target_config_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      target_config_name_type_;

      static const target_config_name_type_ target_config_name;

      // package_config_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      package_config_name_type_;

      static const package_config_name_type_ package_config_name;

      // toolchain_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      toolchain_name_type_;

      static const toolchain_name_type_ toolchain_name;

      // toolchain_version
      //
      struct toolchain_version_class_1_
      {
        toolchain_version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        revision_type_;

        static const revision_type_ revision;
      };

      static const toolchain_version_class_1_ toolchain_version;
    };

    static const id_class_ id;

    // package_version
    //
    struct package_version_class_
    {
      package_version_class_ ()
      {
      }

      // upstream
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      release_type_;

      static const release_type_ release;
    };

    static const package_version_class_ package_version;

    // toolchain_version
    //
    struct toolchain_version_class_
    {
      toolchain_version_class_ ()
      {
      }

      // upstream
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      release_type_;

      static const release_type_ release;
    };

    static const toolchain_version_class_ toolchain_version;

    // state
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    state_type_;

    static const state_type_ state;

    // interactive
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    interactive_type_;

    static const interactive_type_ interactive;

    // timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    timestamp_type_;

    static const timestamp_type_ timestamp;

    // force
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    force_type_;

    static const force_type_ force;

    // status
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    status_type_;

    static const status_type_ status;

    // soft_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    soft_timestamp_type_;

    static const soft_timestamp_type_ soft_timestamp;

    // hard_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    hard_timestamp_type_;

    static const hard_timestamp_type_ hard_timestamp;

    // agent_fingerprint
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    agent_fingerprint_type_;

    static const agent_fingerprint_type_ agent_fingerprint;

    // agent_challenge
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    agent_challenge_type_;

    static const agent_challenge_type_ agent_challenge;

    // controller_checksum
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    controller_checksum_type_;

    static const controller_checksum_type_ controller_checksum;

    // machine_checksum
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    machine_checksum_type_;

    static const machine_checksum_type_ machine_checksum;

    // agent_checksum
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    agent_checksum_type_;

    static const agent_checksum_type_ agent_checksum;

    // worker_checksum
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    worker_checksum_type_;

    static const worker_checksum_type_ worker_checksum;

    // dependency_checksum
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::basic_string< char >,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    dependency_checksum_type_;

    static const dependency_checksum_type_ dependency_checksum;

    // machine_name
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    machine_name_type_;

    static const machine_name_type_ machine_name;

    // machine_summary
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::std::string,
        pgsql::id_string >::query_type,
      pgsql::id_string >
    machine_summary_type_;

    static const machine_summary_type_ machine_summary;
  };

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::tenant_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::
  tenant (A::table_name, "\"package_tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::name_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::
  name (A::table_name, "\"package_name\"", "(?)::CITEXT");

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::epoch_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::
  epoch (A::table_name, "\"package_version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::canonical_upstream_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::
  canonical_upstream (A::table_name, "\"package_version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::canonical_release_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::
  canonical_release (A::table_name, "\"package_version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::revision_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::
  revision (A::table_name, "\"package_version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version_class_2_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_::version;

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::package_class_1_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::package;

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::target_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::
  target (A::table_name, "\"target\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::target_config_name_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::
  target_config_name (A::table_name, "\"target_config_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::package_config_name_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::
  package_config_name (A::table_name, "\"package_config_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_name_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::
  toolchain_name (A::table_name, "\"toolchain_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version_class_1_::epoch_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version_class_1_::
  epoch (A::table_name, "\"toolchain_version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version_class_1_::canonical_upstream_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version_class_1_::
  canonical_upstream (A::table_name, "\"toolchain_version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version_class_1_::canonical_release_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version_class_1_::
  canonical_release (A::table_name, "\"toolchain_version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version_class_1_::revision_type_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version_class_1_::
  revision (A::table_name, "\"toolchain_version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version_class_1_
  query_columns< ::brep::build, id_pgsql, A >::id_class_::toolchain_version;

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::id_class_
  query_columns< ::brep::build, id_pgsql, A >::id;

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::package_version_class_::upstream_type_
  query_columns< ::brep::build, id_pgsql, A >::package_version_class_::
  upstream (A::table_name, "\"package_version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::package_version_class_::release_type_
  query_columns< ::brep::build, id_pgsql, A >::package_version_class_::
  release (A::table_name, "\"package_version_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::package_version_class_
  query_columns< ::brep::build, id_pgsql, A >::package_version;

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::toolchain_version_class_::upstream_type_
  query_columns< ::brep::build, id_pgsql, A >::toolchain_version_class_::
  upstream (A::table_name, "\"toolchain_version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::toolchain_version_class_::release_type_
  query_columns< ::brep::build, id_pgsql, A >::toolchain_version_class_::
  release (A::table_name, "\"toolchain_version_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::toolchain_version_class_
  query_columns< ::brep::build, id_pgsql, A >::toolchain_version;

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::state_type_
  query_columns< ::brep::build, id_pgsql, A >::
  state (A::table_name, "\"state\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::interactive_type_
  query_columns< ::brep::build, id_pgsql, A >::
  interactive (A::table_name, "\"interactive\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::timestamp_type_
  query_columns< ::brep::build, id_pgsql, A >::
  timestamp (A::table_name, "\"timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::force_type_
  query_columns< ::brep::build, id_pgsql, A >::
  force (A::table_name, "\"force\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::status_type_
  query_columns< ::brep::build, id_pgsql, A >::
  status (A::table_name, "\"status\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::soft_timestamp_type_
  query_columns< ::brep::build, id_pgsql, A >::
  soft_timestamp (A::table_name, "\"soft_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::hard_timestamp_type_
  query_columns< ::brep::build, id_pgsql, A >::
  hard_timestamp (A::table_name, "\"hard_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::agent_fingerprint_type_
  query_columns< ::brep::build, id_pgsql, A >::
  agent_fingerprint (A::table_name, "\"agent_fingerprint\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::agent_challenge_type_
  query_columns< ::brep::build, id_pgsql, A >::
  agent_challenge (A::table_name, "\"agent_challenge\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::controller_checksum_type_
  query_columns< ::brep::build, id_pgsql, A >::
  controller_checksum (A::table_name, "\"controller_checksum\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::machine_checksum_type_
  query_columns< ::brep::build, id_pgsql, A >::
  machine_checksum (A::table_name, "\"machine_checksum\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::agent_checksum_type_
  query_columns< ::brep::build, id_pgsql, A >::
  agent_checksum (A::table_name, "\"agent_checksum\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::worker_checksum_type_
  query_columns< ::brep::build, id_pgsql, A >::
  worker_checksum (A::table_name, "\"worker_checksum\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::dependency_checksum_type_
  query_columns< ::brep::build, id_pgsql, A >::
  dependency_checksum (A::table_name, "\"dependency_checksum\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::machine_name_type_
  query_columns< ::brep::build, id_pgsql, A >::
  machine_name (A::table_name, "\"machine\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build, id_pgsql, A >::machine_summary_type_
  query_columns< ::brep::build, id_pgsql, A >::
  machine_summary (A::table_name, "\"machine_summary\"", 0);

  template <typename A>
  struct pointer_query_columns< ::brep::build, id_pgsql, A >:
    query_columns< ::brep::build, id_pgsql, A >
  {
  };

  template <>
  class access::object_traits_impl< ::brep::build, id_pgsql >:
    public access::object_traits< ::brep::build >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::brep::build_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::build_id, id_pgsql >::image_type id_value;

      // package_version
      //
      composite_value_traits< ::brep::upstream_version, id_pgsql >::image_type package_version_value;

      // toolchain_version
      //
      composite_value_traits< ::brep::upstream_version, id_pgsql >::image_type toolchain_version_value;

      // state
      //
      details::buffer state_value;
      std::size_t state_size;
      bool state_null;

      // interactive
      //
      details::buffer interactive_value;
      std::size_t interactive_size;
      bool interactive_null;

      // timestamp
      //
      long long timestamp_value;
      bool timestamp_null;

      // force
      //
      details::buffer force_value;
      std::size_t force_size;
      bool force_null;

      // status
      //
      details::buffer status_value;
      std::size_t status_size;
      bool status_null;

      // soft_timestamp
      //
      long long soft_timestamp_value;
      bool soft_timestamp_null;

      // hard_timestamp
      //
      long long hard_timestamp_value;
      bool hard_timestamp_null;

      // agent_fingerprint
      //
      details::buffer agent_fingerprint_value;
      std::size_t agent_fingerprint_size;
      bool agent_fingerprint_null;

      // agent_challenge
      //
      details::buffer agent_challenge_value;
      std::size_t agent_challenge_size;
      bool agent_challenge_null;

      // controller_checksum
      //
      details::buffer controller_checksum_value;
      std::size_t controller_checksum_size;
      bool controller_checksum_null;

      // machine_checksum
      //
      details::buffer machine_checksum_value;
      std::size_t machine_checksum_size;
      bool machine_checksum_null;

      // agent_checksum
      //
      details::buffer agent_checksum_value;
      std::size_t agent_checksum_size;
      bool agent_checksum_null;

      // worker_checksum
      //
      details::buffer worker_checksum_value;
      std::size_t worker_checksum_size;
      bool worker_checksum_null;

      // dependency_checksum
      //
      details::buffer dependency_checksum_value;
      std::size_t dependency_checksum_size;
      bool dependency_checksum_null;

      // machine_name
      //
      details::buffer machine_name_value;
      std::size_t machine_name_size;
      bool machine_name_null;

      // machine_summary
      //
      details::buffer machine_summary_value;
      std::size_t machine_summary_size;
      bool machine_summary_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    // auxiliary_machines
    //
    struct auxiliary_machines_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 14UL;
      static const std::size_t data_column_count = 17UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::std::vector< ::brep::build_machine > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< auxiliary_machines_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // results
    //
    struct results_traits
    {
      static const char select_name[];
      static const char insert_name[];
      static const char delete_name[];

      static const unsigned int insert_types[];

      static const std::size_t id_column_count = 14UL;
      static const std::size_t data_column_count = 18UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::bbot::operation_results container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef pgsql::container_statements< results_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_pgsql >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (pgsql::bind*,
            const pgsql::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // auxiliary_machines_section
    //
    struct auxiliary_machines_section_traits
    {
      typedef object_traits_impl<object_type, id_pgsql>::image_type image_type;
      typedef object_traits_impl<object_type, id_pgsql>::id_image_type id_image_type;

      static const std::size_t id_column_count = 14UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);

      static void
      update (extra_statement_cache_type&, const object_type&);
    };

    // results_section
    //
    struct results_section_traits
    {
      typedef object_traits_impl<object_type, id_pgsql>::image_type image_type;
      typedef object_traits_impl<object_type, id_pgsql>::id_image_type id_image_type;

      static const std::size_t id_column_count = 14UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);

      static void
      update (extra_statement_cache_type&, const object_type&);
    };

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 34UL;
    static const std::size_t id_column_count = 14UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static bool
    load (connection&, object_type&, section&);

    static bool
    update (connection&, const object_type&, const section&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char update_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];
    static const unsigned int update_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::build, id_common >:
    public access::object_traits_impl< ::brep::build, id_pgsql >
  {
  };

  // toolchain
  //
  template <>
  class access::view_traits_impl< ::brep::toolchain, id_pgsql >:
    public access::view_traits< ::brep::toolchain >
  {
    public:
    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // epoch
      //
      int epoch_value;
      bool epoch_null;

      // canonical_upstream
      //
      details::buffer canonical_upstream_value;
      std::size_t canonical_upstream_size;
      bool canonical_upstream_null;

      // canonical_release
      //
      details::buffer canonical_release_value;
      std::size_t canonical_release_size;
      bool canonical_release_null;

      // revision
      //
      int revision_value;
      bool revision_null;

      // version
      //
      composite_value_traits< ::brep::upstream_version, id_pgsql >::image_type version_value;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 7UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::toolchain, id_common >:
    public access::view_traits_impl< ::brep::toolchain, id_pgsql >
  {
  };

  // package_build
  //
  template <>
  class access::view_traits_impl< ::brep::package_build, id_pgsql >:
    public access::view_traits< ::brep::package_build >
  {
    public:
    struct image_type
    {
      // build
      //
      object_traits_impl< ::brep::build, id_pgsql >::image_type build_value;

      // archived
      //
      bool archived_value;
      bool archived_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 35UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::package_build, id_common >:
    public access::view_traits_impl< ::brep::package_build, id_pgsql >
  {
  };

  // package_build_count
  //
  template <>
  class access::view_traits_impl< ::brep::package_build_count, id_pgsql >:
    public access::view_traits< ::brep::package_build_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::package_build_count, id_common >:
    public access::view_traits_impl< ::brep::package_build_count, id_pgsql >
  {
  };

  // package_build_id
  //
  template <>
  class access::view_traits_impl< ::brep::package_build_id, id_pgsql >:
    public access::view_traits< ::brep::package_build_id >
  {
    public:
    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::build_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    typedef pgsql::view_statements<view_type> statements_type;

    typedef pgsql::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 14UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char query_statement_name[];
  };

  template <>
  class access::view_traits_impl< ::brep::package_build_id, id_common >:
    public access::view_traits_impl< ::brep::package_build_id, id_pgsql >
  {
  };

  // build_delay
  //
  template <typename A>
  struct query_columns< ::brep::build_delay, id_pgsql, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // package
      //
      struct package_class_1_
      {
        package_class_1_ ()
        {
        }

        // tenant
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        tenant_type_;

        static const tenant_type_ tenant;

        // name
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::bpkg::package_name,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        name_type_;

        static const name_type_ name;

        // version
        //
        struct version_class_2_
        {
          version_class_2_ ()
          {
          }

          // epoch
          //
          typedef
          pgsql::query_column<
            pgsql::value_traits<
              ::uint16_t,
              pgsql::id_integer >::query_type,
            pgsql::id_integer >
          epoch_type_;

          static const epoch_type_ epoch;

          // canonical_upstream
          //
          typedef
          pgsql::query_column<
            pgsql::value_traits<
              ::std::string,
              pgsql::id_string >::query_type,
            pgsql::id_string >
          canonical_upstream_type_;

          static const canonical_upstream_type_ canonical_upstream;

          // canonical_release
          //
          typedef
          pgsql::query_column<
            pgsql::value_traits<
              ::std::string,
              pgsql::id_string >::query_type,
            pgsql::id_string >
          canonical_release_type_;

          static const canonical_release_type_ canonical_release;

          // revision
          //
          typedef
          pgsql::query_column<
            pgsql::value_traits<
              ::uint16_t,
              pgsql::id_integer >::query_type,
            pgsql::id_integer >
          revision_type_;

          static const revision_type_ revision;
        };

        static const version_class_2_ version;
      };

      static const package_class_1_ package;

      // target
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::butl::target_triplet,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      target_type_;

      static const target_type_ target;

      // target_config_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      target_config_name_type_;

      static const target_config_name_type_ target_config_name;

      // package_config_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      package_config_name_type_;

      static const package_config_name_type_ package_config_name;

      // toolchain_name
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      toolchain_name_type_;

      static const toolchain_name_type_ toolchain_name;

      // toolchain_version
      //
      struct toolchain_version_class_1_
      {
        toolchain_version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::std::string,
            pgsql::id_string >::query_type,
          pgsql::id_string >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        pgsql::query_column<
          pgsql::value_traits<
            ::uint16_t,
            pgsql::id_integer >::query_type,
          pgsql::id_integer >
        revision_type_;

        static const revision_type_ revision;
      };

      static const toolchain_version_class_1_ toolchain_version;
    };

    static const id_class_ id;

    // package_version
    //
    struct package_version_class_
    {
      package_version_class_ ()
      {
      }

      // upstream
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      release_type_;

      static const release_type_ release;
    };

    static const package_version_class_ package_version;

    // toolchain_version
    //
    struct toolchain_version_class_
    {
      toolchain_version_class_ ()
      {
      }

      // upstream
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      pgsql::query_column<
        pgsql::value_traits<
          ::std::basic_string< char >,
          pgsql::id_string >::query_type,
        pgsql::id_string >
      release_type_;

      static const release_type_ release;
    };

    static const toolchain_version_class_ toolchain_version;

    // report_soft_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    report_soft_timestamp_type_;

    static const report_soft_timestamp_type_ report_soft_timestamp;

    // report_hard_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    report_hard_timestamp_type_;

    static const report_hard_timestamp_type_ report_hard_timestamp;

    // package_timestamp
    //
    typedef
    pgsql::query_column<
      pgsql::value_traits<
        ::uint64_t,
        pgsql::id_bigint >::query_type,
      pgsql::id_bigint >
    package_timestamp_type_;

    static const package_timestamp_type_ package_timestamp;
  };

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::tenant_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::
  tenant (A::table_name, "\"package_tenant\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::name_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::
  name (A::table_name, "\"package_name\"", "(?)::CITEXT");

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::epoch_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::
  epoch (A::table_name, "\"package_version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::canonical_upstream_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::
  canonical_upstream (A::table_name, "\"package_version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::canonical_release_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::
  canonical_release (A::table_name, "\"package_version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::revision_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version_class_2_::
  revision (A::table_name, "\"package_version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version_class_2_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_::version;

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_class_1_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package;

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::target_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::
  target (A::table_name, "\"target\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::target_config_name_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::
  target_config_name (A::table_name, "\"target_config_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::package_config_name_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::
  package_config_name (A::table_name, "\"package_config_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_name_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::
  toolchain_name (A::table_name, "\"toolchain_name\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version_class_1_::epoch_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version_class_1_::
  epoch (A::table_name, "\"toolchain_version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version_class_1_::canonical_upstream_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version_class_1_::
  canonical_upstream (A::table_name, "\"toolchain_version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version_class_1_::canonical_release_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version_class_1_::
  canonical_release (A::table_name, "\"toolchain_version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version_class_1_::revision_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version_class_1_::
  revision (A::table_name, "\"toolchain_version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version_class_1_
  query_columns< ::brep::build_delay, id_pgsql, A >::id_class_::toolchain_version;

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::id_class_
  query_columns< ::brep::build_delay, id_pgsql, A >::id;

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::package_version_class_::upstream_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::package_version_class_::
  upstream (A::table_name, "\"package_version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::package_version_class_::release_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::package_version_class_::
  release (A::table_name, "\"package_version_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::package_version_class_
  query_columns< ::brep::build_delay, id_pgsql, A >::package_version;

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::toolchain_version_class_::upstream_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::toolchain_version_class_::
  upstream (A::table_name, "\"toolchain_version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::toolchain_version_class_::release_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::toolchain_version_class_::
  release (A::table_name, "\"toolchain_version_release\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::toolchain_version_class_
  query_columns< ::brep::build_delay, id_pgsql, A >::toolchain_version;

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::report_soft_timestamp_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::
  report_soft_timestamp (A::table_name, "\"report_soft_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::report_hard_timestamp_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::
  report_hard_timestamp (A::table_name, "\"report_hard_timestamp\"", 0);

  template <typename A>
  const typename query_columns< ::brep::build_delay, id_pgsql, A >::package_timestamp_type_
  query_columns< ::brep::build_delay, id_pgsql, A >::
  package_timestamp (A::table_name, "\"package_timestamp\"", 0);

  template <typename A>
  struct pointer_query_columns< ::brep::build_delay, id_pgsql, A >:
    query_columns< ::brep::build_delay, id_pgsql, A >
  {
  };

  template <>
  class access::object_traits_impl< ::brep::build_delay, id_pgsql >:
    public access::object_traits< ::brep::build_delay >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::brep::build_id, id_pgsql >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::brep::build_id, id_pgsql >::image_type id_value;

      // package_version
      //
      composite_value_traits< ::brep::upstream_version, id_pgsql >::image_type package_version_value;

      // toolchain_version
      //
      composite_value_traits< ::brep::upstream_version, id_pgsql >::image_type toolchain_version_value;

      // report_soft_timestamp
      //
      long long report_soft_timestamp_value;
      bool report_soft_timestamp_null;

      // report_hard_timestamp
      //
      long long report_hard_timestamp_value;
      bool report_hard_timestamp_null;

      // package_timestamp
      //
      long long package_timestamp_value;
      bool package_timestamp_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (pgsql::bind*,
          image_type&,
          pgsql::statement_kind);

    static void
    bind (pgsql::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          pgsql::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef pgsql::object_statements<object_type> statements_type;

    typedef pgsql::query_base query_base_type;

    static const std::size_t column_count = 21UL;
    static const std::size_t id_column_count = 14UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    static const char persist_statement_name[];
    static const char find_statement_name[];
    static const char update_statement_name[];
    static const char erase_statement_name[];
    static const char query_statement_name[];
    static const char erase_query_statement_name[];

    static const unsigned int persist_statement_types[];
    static const unsigned int find_statement_types[];
    static const unsigned int update_statement_types[];

    static const std::size_t batch = 1UL;

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::brep::build_delay, id_common >:
    public access::object_traits_impl< ::brep::build_delay, id_pgsql >
  {
  };

  // build
  //
  // toolchain
  //
  struct access::view_traits_impl< ::brep::toolchain, id_pgsql >::query_columns
  {
    // build
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build, id_pgsql > >
    build;

    // build_package
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_package,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_package, id_pgsql > >
    build_package;
  };

  // package_build
  //
  struct access::view_traits_impl< ::brep::package_build, id_pgsql >::query_columns
  {
    // build
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build, id_pgsql > >
    build;

    // build_package
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_package,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_package, id_pgsql > >
    build_package;

    // build_tenant
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_tenant,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_tenant, id_pgsql > >
    build_tenant;
  };

  // package_build_count
  //
  struct access::view_traits_impl< ::brep::package_build_count, id_pgsql >::query_columns
  {
    // build
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build, id_pgsql > >
    build;

    // build_package
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_package,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_package, id_pgsql > >
    build_package;

    // build_tenant
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_tenant,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_tenant, id_pgsql > >
    build_tenant;
  };

  // package_build_id
  //
  struct access::view_traits_impl< ::brep::package_build_id, id_pgsql >::query_columns
  {
    // build
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build, id_pgsql > >
    build;

    // build_package
    //
    typedef
    odb::pointer_query_columns<
      ::brep::build_package,
      id_pgsql,
      odb::access::object_traits_impl< ::brep::build_package, id_pgsql > >
    build_package;
  };

  // build_delay
  //
}

#include <libbrep/build-odb.ixx>

#include <odb/post.hxx>

#endif // LIBBREP_BUILD_ODB_HXX
