// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#include <odb/pre.hxx>

#include <libbrep/build-odb.hxx>

#include <cassert>
#include <cstring>  // std::memcpy

#include <odb/schema-catalog-impl.hxx>

#include <odb/pgsql/traits.hxx>
#include <odb/pgsql/database.hxx>
#include <odb/pgsql/transaction.hxx>
#include <odb/pgsql/connection.hxx>
#include <odb/pgsql/statement.hxx>
#include <odb/pgsql/statement-cache.hxx>
#include <odb/pgsql/simple-object-statements.hxx>
#include <odb/pgsql/view-statements.hxx>
#include <odb/pgsql/section-statements.hxx>
#include <odb/pgsql/container-statements.hxx>
#include <odb/pgsql/exceptions.hxx>
#include <odb/pgsql/prepared-query.hxx>
#include <odb/pgsql/simple-object-result.hxx>
#include <odb/pgsql/view-result.hxx>

namespace odb
{
  // operation_result
  //

  bool access::composite_value_traits< ::bbot::operation_result, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // operation
    //
    if (t[0UL])
    {
      i.operation_value.capacity (i.operation_size);
      grew = true;
    }

    // status
    //
    if (t[1UL])
    {
      i.status_value.capacity (i.status_size);
      grew = true;
    }

    // log
    //
    if (t[2UL])
    {
      i.log_value.capacity (i.log_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bbot::operation_result, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // operation
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.operation_value.data_ptr ();
    b[n].capacity = i.operation_value.capacity ();
    b[n].size = &i.operation_size;
    b[n].is_null = &i.operation_null;
    n++;

    // status
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.status_value.data_ptr ();
    b[n].capacity = i.status_value.capacity ();
    b[n].size = &i.status_size;
    b[n].is_null = &i.status_null;
    n++;

    // log
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.log_value.data_ptr ();
    b[n].capacity = i.log_value.capacity ();
    b[n].size = &i.log_size;
    b[n].is_null = &i.log_null;
    n++;
  }

  bool access::composite_value_traits< ::bbot::operation_result, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // operation
    //
    {
      ::std::string const& v =
        o.operation;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.operation_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.operation_value,
        size,
        is_null,
        v);
      i.operation_null = is_null;
      i.operation_size = size;
      grew = grew || (cap != i.operation_value.capacity ());
    }

    // status
    //
    {
      ::bbot::result_status const& v =
        o.status;

      // From build.hxx:35:12
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.status_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.status_value,
        size,
        is_null,
        vt);
      i.status_null = is_null;
      i.status_size = size;
      grew = grew || (cap != i.status_value.capacity ());
    }

    // log
    //
    {
      ::std::string const& v =
        o.log;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.log_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.log_value,
        size,
        is_null,
        v);
      i.log_null = is_null;
      i.log_size = size;
      grew = grew || (cap != i.log_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bbot::operation_result, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // operation
    //
    {
      ::std::string& v =
        o.operation;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.operation_value,
        i.operation_size,
        i.operation_null);
    }

    // status
    //
    {
      ::bbot::result_status& v =
        o.status;

      ::std::string vt;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        vt,
        i.status_value,
        i.status_size,
        i.status_null);

      // From build.hxx:35:12
      v = bbot::to_result_status (vt);
    }

    // log
    //
    {
      ::std::string& v =
        o.log;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.log_value,
        i.log_size,
        i.log_null);
    }
  }

  // build_id
  //

  bool access::composite_value_traits< ::brep::build_id, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // package
    //
    if (composite_value_traits< ::brep::package_id, id_pgsql >::grow (
          i.package_value, t + 0UL))
      grew = true;

    // target
    //
    if (t[6UL])
    {
      i.target_value.capacity (i.target_size);
      grew = true;
    }

    // target_config_name
    //
    if (t[7UL])
    {
      i.target_config_name_value.capacity (i.target_config_name_size);
      grew = true;
    }

    // package_config_name
    //
    if (t[8UL])
    {
      i.package_config_name_value.capacity (i.package_config_name_size);
      grew = true;
    }

    // toolchain_name
    //
    if (t[9UL])
    {
      i.toolchain_name_value.capacity (i.toolchain_name_size);
      grew = true;
    }

    // toolchain_version
    //
    if (composite_value_traits< ::brep::canonical_version, id_pgsql >::grow (
          i.toolchain_version_value, t + 10UL))
      grew = true;

    return grew;
  }

  void access::composite_value_traits< ::brep::build_id, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // package
    //
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.package_value, sk);
    n += 6UL;

    // target
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.target_value.data_ptr ();
    b[n].capacity = i.target_value.capacity ();
    b[n].size = &i.target_size;
    b[n].is_null = &i.target_null;
    n++;

    // target_config_name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.target_config_name_value.data_ptr ();
    b[n].capacity = i.target_config_name_value.capacity ();
    b[n].size = &i.target_config_name_size;
    b[n].is_null = &i.target_config_name_null;
    n++;

    // package_config_name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.package_config_name_value.data_ptr ();
    b[n].capacity = i.package_config_name_value.capacity ();
    b[n].size = &i.package_config_name_size;
    b[n].is_null = &i.package_config_name_null;
    n++;

    // toolchain_name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.toolchain_name_value.data_ptr ();
    b[n].capacity = i.toolchain_name_value.capacity ();
    b[n].size = &i.toolchain_name_size;
    b[n].is_null = &i.toolchain_name_null;
    n++;

    // toolchain_version
    //
    composite_value_traits< ::brep::canonical_version, id_pgsql >::bind (
      b + n, i.toolchain_version_value, sk);
    n += 4UL;
  }

  bool access::composite_value_traits< ::brep::build_id, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // package
    //
    {
      ::brep::package_id const& v =
        o.package;

      if (composite_value_traits< ::brep::package_id, id_pgsql >::init (
            i.package_value,
            v,
            sk))
        grew = true;
    }

    // target
    //
    {
      ::butl::target_triplet const& v =
        o.target;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.target_value.capacity ());
      pgsql::value_traits<
          ::butl::target_triplet,
          pgsql::id_string >::set_image (
        i.target_value,
        size,
        is_null,
        v);
      i.target_null = is_null;
      i.target_size = size;
      grew = grew || (cap != i.target_value.capacity ());
    }

    // target_config_name
    //
    {
      ::std::string const& v =
        o.target_config_name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.target_config_name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.target_config_name_value,
        size,
        is_null,
        v);
      i.target_config_name_null = is_null;
      i.target_config_name_size = size;
      grew = grew || (cap != i.target_config_name_value.capacity ());
    }

    // package_config_name
    //
    {
      ::std::string const& v =
        o.package_config_name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.package_config_name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.package_config_name_value,
        size,
        is_null,
        v);
      i.package_config_name_null = is_null;
      i.package_config_name_size = size;
      grew = grew || (cap != i.package_config_name_value.capacity ());
    }

    // toolchain_name
    //
    {
      ::std::string const& v =
        o.toolchain_name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.toolchain_name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.toolchain_name_value,
        size,
        is_null,
        v);
      i.toolchain_name_null = is_null;
      i.toolchain_name_size = size;
      grew = grew || (cap != i.toolchain_name_value.capacity ());
    }

    // toolchain_version
    //
    {
      ::brep::canonical_version const& v =
        o.toolchain_version;

      if (composite_value_traits< ::brep::canonical_version, id_pgsql >::init (
            i.toolchain_version_value,
            v,
            sk))
        grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_id, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // package
    //
    {
      ::brep::package_id& v =
        o.package;

      composite_value_traits< ::brep::package_id, id_pgsql >::init (
        v,
        i.package_value,
        db);
    }

    // target
    //
    {
      ::butl::target_triplet& v =
        o.target;

      pgsql::value_traits<
          ::butl::target_triplet,
          pgsql::id_string >::set_value (
        v,
        i.target_value,
        i.target_size,
        i.target_null);
    }

    // target_config_name
    //
    {
      ::std::string& v =
        o.target_config_name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.target_config_name_value,
        i.target_config_name_size,
        i.target_config_name_null);
    }

    // package_config_name
    //
    {
      ::std::string& v =
        o.package_config_name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.package_config_name_value,
        i.package_config_name_size,
        i.package_config_name_null);
    }

    // toolchain_name
    //
    {
      ::std::string& v =
        o.toolchain_name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.toolchain_name_value,
        i.toolchain_name_size,
        i.toolchain_name_null);
    }

    // toolchain_version
    //
    {
      ::brep::canonical_version& v =
        o.toolchain_version;

      composite_value_traits< ::brep::canonical_version, id_pgsql >::init (
        v,
        i.toolchain_version_value,
        db);
    }
  }

  // build_machine
  //

  bool access::composite_value_traits< ::brep::build_machine, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // summary
    //
    if (t[1UL])
    {
      i.summary_value.capacity (i.summary_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_machine, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.name_value.data_ptr ();
    b[n].capacity = i.name_value.capacity ();
    b[n].size = &i.name_size;
    b[n].is_null = &i.name_null;
    n++;

    // summary
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.summary_value.data_ptr ();
    b[n].capacity = i.summary_value.capacity ();
    b[n].size = &i.summary_size;
    b[n].is_null = &i.summary_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::build_machine, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // name
    //
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.name_value,
        size,
        is_null,
        v);
      i.name_null = is_null;
      i.name_size = size;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // summary
    //
    {
      ::std::string const& v =
        o.summary;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.summary_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.summary_value,
        size,
        is_null,
        v);
      i.summary_null = is_null;
      i.summary_size = size;
      grew = grew || (cap != i.summary_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::build_machine, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // summary
    //
    {
      ::std::string& v =
        o.summary;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.summary_value,
        i.summary_size,
        i.summary_null);
    }
  }

  // build
  //

  const char access::object_traits_impl< ::brep::build, id_pgsql >::
  persist_statement_name[] = "persist_brep_build";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::
  find_statement_name[] = "find_brep_build";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::
  update_statement_name[] = "update_brep_build";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::
  erase_statement_name[] = "erase_brep_build";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::
  query_statement_name[] = "query_brep_build";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_build";

  const unsigned int access::object_traits_impl< ::brep::build, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::build, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid
  };

  const unsigned int access::object_traits_impl< ::brep::build, id_pgsql >::
  update_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid
  };

  struct access::object_traits_impl< ::brep::build, id_pgsql >::extra_statement_cache_type
  {
    pgsql::container_statements_impl< auxiliary_machines_traits > auxiliary_machines;
    pgsql::container_statements_impl< results_traits > results;

    pgsql::section_statements< ::brep::build, auxiliary_machines_section_traits > auxiliary_machines_section;
    pgsql::section_statements< ::brep::build, results_section_traits > results_section;

    extra_statement_cache_type (
      pgsql::connection& c,
      image_type& im,
      id_image_type& idim,
      pgsql::binding& id,
      pgsql::binding& idv,
      pgsql::native_binding& idn,
      const unsigned int* idt)
    : auxiliary_machines (c, id, idn, idt),
      results (c, id, idn, idt),
      auxiliary_machines_section (c, im, idim, id, idv, idn, idt),
      results_section (c, im, idim, id, idv, idn, idt)
    {
    }
  };

  // auxiliary_machines
  //

  const char access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  select_name[] = "select_brep_build_auxiliary_machines";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  insert_name[] = "insert_brep_build_auxiliary_machines";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  delete_name[] = "delete_brep_build_auxiliary_machines";

  const unsigned int access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  select_statement[] =
  "SELECT "
  "\"build_auxiliary_machines\".\"index\", "
  "\"build_auxiliary_machines\".\"name\", "
  "\"build_auxiliary_machines\".\"summary\" "
  "FROM \"build_auxiliary_machines\" "
  "WHERE \"build_auxiliary_machines\".\"package_tenant\"=$1 AND \"build_auxiliary_machines\".\"package_name\"=$2::CITEXT AND \"build_auxiliary_machines\".\"package_version_epoch\"=$3 AND \"build_auxiliary_machines\".\"package_version_canonical_upstream\"=$4 AND \"build_auxiliary_machines\".\"package_version_canonical_release\"=$5 AND \"build_auxiliary_machines\".\"package_version_revision\"=$6 AND \"build_auxiliary_machines\".\"target\"=$7 AND \"build_auxiliary_machines\".\"target_config_name\"=$8 AND \"build_auxiliary_machines\".\"package_config_name\"=$9 AND \"build_auxiliary_machines\".\"toolchain_name\"=$10 AND \"build_auxiliary_machines\".\"toolchain_version_epoch\"=$11 AND \"build_auxiliary_machines\".\"toolchain_version_canonical_upstream\"=$12 AND \"build_auxiliary_machines\".\"toolchain_version_canonical_release\"=$13 AND \"build_auxiliary_machines\".\"toolchain_version_revision\"=$14 ORDER BY \"build_auxiliary_machines\".\"index\"";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  insert_statement[] =
  "INSERT INTO \"build_auxiliary_machines\" "
  "(\"package_tenant\", "
  "\"package_name\", "
  "\"package_version_epoch\", "
  "\"package_version_canonical_upstream\", "
  "\"package_version_canonical_release\", "
  "\"package_version_revision\", "
  "\"target\", "
  "\"target_config_name\", "
  "\"package_config_name\", "
  "\"toolchain_name\", "
  "\"toolchain_version_epoch\", "
  "\"toolchain_version_canonical_upstream\", "
  "\"toolchain_version_canonical_release\", "
  "\"toolchain_version_revision\", "
  "\"index\", "
  "\"name\", "
  "\"summary\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17)";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  delete_statement[] =
  "DELETE FROM \"build_auxiliary_machines\" "
  "WHERE \"package_tenant\"=$1 AND \"package_name\"=$2::CITEXT AND \"package_version_epoch\"=$3 AND \"package_version_canonical_upstream\"=$4 AND \"package_version_canonical_release\"=$5 AND \"package_version_revision\"=$6 AND \"target\"=$7 AND \"target_config_name\"=$8 AND \"package_config_name\"=$9 AND \"toolchain_name\"=$10 AND \"toolchain_version_epoch\"=$11 AND \"toolchain_version_canonical_upstream\"=$12 AND \"toolchain_version_canonical_release\"=$13 AND \"toolchain_version_revision\"=$14";

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // results
  //

  const char access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  select_name[] = "select_brep_build_results";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  insert_name[] = "insert_brep_build_results";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  delete_name[] = "delete_brep_build_results";

  const unsigned int access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  select_statement[] =
  "SELECT "
  "\"build_results\".\"index\", "
  "\"build_results\".\"operation\", "
  "\"build_results\".\"status\", "
  "\"build_results\".\"log\" "
  "FROM \"build_results\" "
  "WHERE \"build_results\".\"package_tenant\"=$1 AND \"build_results\".\"package_name\"=$2::CITEXT AND \"build_results\".\"package_version_epoch\"=$3 AND \"build_results\".\"package_version_canonical_upstream\"=$4 AND \"build_results\".\"package_version_canonical_release\"=$5 AND \"build_results\".\"package_version_revision\"=$6 AND \"build_results\".\"target\"=$7 AND \"build_results\".\"target_config_name\"=$8 AND \"build_results\".\"package_config_name\"=$9 AND \"build_results\".\"toolchain_name\"=$10 AND \"build_results\".\"toolchain_version_epoch\"=$11 AND \"build_results\".\"toolchain_version_canonical_upstream\"=$12 AND \"build_results\".\"toolchain_version_canonical_release\"=$13 AND \"build_results\".\"toolchain_version_revision\"=$14 ORDER BY \"build_results\".\"index\"";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  insert_statement[] =
  "INSERT INTO \"build_results\" "
  "(\"package_tenant\", "
  "\"package_name\", "
  "\"package_version_epoch\", "
  "\"package_version_canonical_upstream\", "
  "\"package_version_canonical_release\", "
  "\"package_version_revision\", "
  "\"target\", "
  "\"target_config_name\", "
  "\"package_config_name\", "
  "\"toolchain_name\", "
  "\"toolchain_version_epoch\", "
  "\"toolchain_version_canonical_upstream\", "
  "\"toolchain_version_canonical_release\", "
  "\"toolchain_version_revision\", "
  "\"index\", "
  "\"operation\", "
  "\"status\", "
  "\"log\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18)";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  delete_statement[] =
  "DELETE FROM \"build_results\" "
  "WHERE \"package_tenant\"=$1 AND \"package_name\"=$2::CITEXT AND \"package_version_epoch\"=$3 AND \"package_version_canonical_upstream\"=$4 AND \"package_version_canonical_release\"=$5 AND \"package_version_revision\"=$6 AND \"target\"=$7 AND \"target_config_name\"=$8 AND \"package_config_name\"=$9 AND \"toolchain_name\"=$10 AND \"toolchain_version_epoch\"=$11 AND \"toolchain_version_canonical_upstream\"=$12 AND \"toolchain_version_canonical_release\"=$13 AND \"toolchain_version_revision\"=$14";

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // auxiliary_machines_section
  //

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // auxiliary_machines
    //
    {
      ::std::vector< ::brep::build_machine >& v =
        obj.auxiliary_machines;

      auxiliary_machines_traits::load (
        v,
        esc.auxiliary_machines);
    }
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::auxiliary_machines_section_traits::
  update (extra_statement_cache_type& esc, const object_type& obj)
  {
    // auxiliary_machines
    //
    {
      ::std::vector< ::brep::build_machine > const& v =
        obj.auxiliary_machines;

      auxiliary_machines_traits::update (
        v,
        esc.auxiliary_machines);
    }
  }

  // results_section
  //

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // results
    //
    {
      ::bbot::operation_results& v =
        obj.results;

      results_traits::load (
        v,
        esc.results);
    }
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::results_section_traits::
  update (extra_statement_cache_type& esc, const object_type& obj)
  {
    // results
    //
    {
      ::bbot::operation_results const& v =
        obj.results;

      results_traits::update (
        v,
        esc.results);
    }
  }

  access::object_traits_impl< ::brep::build, id_pgsql >::id_type
  access::object_traits_impl< ::brep::build, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      composite_value_traits< ::brep::build_id, id_pgsql >::init (
        id,
        i.id_value,
        db);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::build, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::build_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // package_version
    //
    if (composite_value_traits< ::brep::upstream_version, id_pgsql >::grow (
          i.package_version_value, t + 14UL))
      grew = true;

    // toolchain_version
    //
    if (composite_value_traits< ::brep::upstream_version, id_pgsql >::grow (
          i.toolchain_version_value, t + 16UL))
      grew = true;

    // state
    //
    if (t[18UL])
    {
      i.state_value.capacity (i.state_size);
      grew = true;
    }

    // interactive
    //
    if (t[19UL])
    {
      i.interactive_value.capacity (i.interactive_size);
      grew = true;
    }

    // timestamp
    //
    t[20UL] = 0;

    // force
    //
    if (t[21UL])
    {
      i.force_value.capacity (i.force_size);
      grew = true;
    }

    // status
    //
    if (t[22UL])
    {
      i.status_value.capacity (i.status_size);
      grew = true;
    }

    // soft_timestamp
    //
    t[23UL] = 0;

    // hard_timestamp
    //
    t[24UL] = 0;

    // agent_fingerprint
    //
    if (t[25UL])
    {
      i.agent_fingerprint_value.capacity (i.agent_fingerprint_size);
      grew = true;
    }

    // agent_challenge
    //
    if (t[26UL])
    {
      i.agent_challenge_value.capacity (i.agent_challenge_size);
      grew = true;
    }

    // controller_checksum
    //
    if (t[27UL])
    {
      i.controller_checksum_value.capacity (i.controller_checksum_size);
      grew = true;
    }

    // machine_checksum
    //
    if (t[28UL])
    {
      i.machine_checksum_value.capacity (i.machine_checksum_size);
      grew = true;
    }

    // agent_checksum
    //
    if (t[29UL])
    {
      i.agent_checksum_value.capacity (i.agent_checksum_size);
      grew = true;
    }

    // worker_checksum
    //
    if (t[30UL])
    {
      i.worker_checksum_value.capacity (i.worker_checksum_size);
      grew = true;
    }

    // dependency_checksum
    //
    if (t[31UL])
    {
      i.dependency_checksum_value.capacity (i.dependency_checksum_size);
      grew = true;
    }

    // machine_name
    //
    if (t[32UL])
    {
      i.machine_name_value.capacity (i.machine_name_size);
      grew = true;
    }

    // machine_summary
    //
    if (t[33UL])
    {
      i.machine_summary_value.capacity (i.machine_summary_size);
      grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      composite_value_traits< ::brep::build_id, id_pgsql >::bind (
        b + n, i.id_value, sk);
      n += 14UL;
    }

    // package_version
    //
    composite_value_traits< ::brep::upstream_version, id_pgsql >::bind (
      b + n, i.package_version_value, sk);
    n += 2UL;

    // toolchain_version
    //
    composite_value_traits< ::brep::upstream_version, id_pgsql >::bind (
      b + n, i.toolchain_version_value, sk);
    n += 2UL;

    // state
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.state_value.data_ptr ();
    b[n].capacity = i.state_value.capacity ();
    b[n].size = &i.state_size;
    b[n].is_null = &i.state_null;
    n++;

    // interactive
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.interactive_value.data_ptr ();
    b[n].capacity = i.interactive_value.capacity ();
    b[n].size = &i.interactive_size;
    b[n].is_null = &i.interactive_null;
    n++;

    // timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.timestamp_value;
    b[n].is_null = &i.timestamp_null;
    n++;

    // force
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.force_value.data_ptr ();
    b[n].capacity = i.force_value.capacity ();
    b[n].size = &i.force_size;
    b[n].is_null = &i.force_null;
    n++;

    // status
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.status_value.data_ptr ();
    b[n].capacity = i.status_value.capacity ();
    b[n].size = &i.status_size;
    b[n].is_null = &i.status_null;
    n++;

    // soft_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.soft_timestamp_value;
    b[n].is_null = &i.soft_timestamp_null;
    n++;

    // hard_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.hard_timestamp_value;
    b[n].is_null = &i.hard_timestamp_null;
    n++;

    // agent_fingerprint
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.agent_fingerprint_value.data_ptr ();
    b[n].capacity = i.agent_fingerprint_value.capacity ();
    b[n].size = &i.agent_fingerprint_size;
    b[n].is_null = &i.agent_fingerprint_null;
    n++;

    // agent_challenge
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.agent_challenge_value.data_ptr ();
    b[n].capacity = i.agent_challenge_value.capacity ();
    b[n].size = &i.agent_challenge_size;
    b[n].is_null = &i.agent_challenge_null;
    n++;

    // controller_checksum
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.controller_checksum_value.data_ptr ();
    b[n].capacity = i.controller_checksum_value.capacity ();
    b[n].size = &i.controller_checksum_size;
    b[n].is_null = &i.controller_checksum_null;
    n++;

    // machine_checksum
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.machine_checksum_value.data_ptr ();
    b[n].capacity = i.machine_checksum_value.capacity ();
    b[n].size = &i.machine_checksum_size;
    b[n].is_null = &i.machine_checksum_null;
    n++;

    // agent_checksum
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.agent_checksum_value.data_ptr ();
    b[n].capacity = i.agent_checksum_value.capacity ();
    b[n].size = &i.agent_checksum_size;
    b[n].is_null = &i.agent_checksum_null;
    n++;

    // worker_checksum
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.worker_checksum_value.data_ptr ();
    b[n].capacity = i.worker_checksum_value.capacity ();
    b[n].size = &i.worker_checksum_size;
    b[n].is_null = &i.worker_checksum_null;
    n++;

    // dependency_checksum
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.dependency_checksum_value.data_ptr ();
    b[n].capacity = i.dependency_checksum_value.capacity ();
    b[n].size = &i.dependency_checksum_size;
    b[n].is_null = &i.dependency_checksum_null;
    n++;

    // machine_name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.machine_name_value.data_ptr ();
    b[n].capacity = i.machine_name_value.capacity ();
    b[n].size = &i.machine_name_size;
    b[n].is_null = &i.machine_name_null;
    n++;

    // machine_summary
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.machine_summary_value.data_ptr ();
    b[n].capacity = i.machine_summary_value.capacity ();
    b[n].size = &i.machine_summary_size;
    b[n].is_null = &i.machine_summary_null;
    n++;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    pgsql::statement_kind sk (pgsql::statement_select);
    composite_value_traits< ::brep::build_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
  }

  bool access::object_traits_impl< ::brep::build, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::brep::build_id const& v =
        o.id;

      if (composite_value_traits< ::brep::build_id, id_pgsql >::init (
            i.id_value,
            v,
            sk))
        grew = true;
    }

    // package_version
    //
    {
      ::brep::upstream_version const& v =
        o.package_version;

      if (composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
            i.package_version_value,
            v,
            sk))
        grew = true;
    }

    // toolchain_version
    //
    {
      ::brep::upstream_version const& v =
        o.toolchain_version;

      if (composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
            i.toolchain_version_value,
            v,
            sk))
        grew = true;
    }

    // state
    //
    {
      ::brep::build_state const& v =
        o.state;

      // From build.hxx:186:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.state_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.state_value,
        size,
        is_null,
        vt);
      i.state_null = is_null;
      i.state_size = size;
      grew = grew || (cap != i.state_value.capacity ());
    }

    // interactive
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.interactive;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.interactive_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.interactive_value,
        size,
        is_null,
        v);
      i.interactive_null = is_null;
      i.interactive_size = size;
      grew = grew || (cap != i.interactive_value.capacity ());
    }

    // timestamp
    //
    {
      ::brep::build::timestamp_type const& v =
        o.timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.timestamp_value, is_null, vt);
      i.timestamp_null = is_null;
    }

    // force
    //
    {
      ::brep::force_state const& v =
        o.force;

      // From build.hxx:208:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.force_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.force_value,
        size,
        is_null,
        vt);
      i.force_null = is_null;
      i.force_size = size;
      grew = grew || (cap != i.force_value.capacity ());
    }

    // status
    //
    {
      ::butl::optional< ::bbot::result_status > const& v =
        o.status;

      // From build.hxx:218:14
      ::brep::optional_string const& vt =
        (v) ? bbot::to_string ( * (v)) : brep::optional_string ();

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.status_value.capacity ());
      pgsql::value_traits<
          ::brep::optional_string,
          pgsql::id_string >::set_image (
        i.status_value,
        size,
        is_null,
        vt);
      i.status_null = is_null;
      i.status_size = size;
      grew = grew || (cap != i.status_value.capacity ());
    }

    // soft_timestamp
    //
    {
      ::brep::build::timestamp_type const& v =
        o.soft_timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.soft_timestamp_value, is_null, vt);
      i.soft_timestamp_null = is_null;
    }

    // hard_timestamp
    //
    {
      ::brep::build::timestamp_type const& v =
        o.hard_timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.hard_timestamp_value, is_null, vt);
      i.hard_timestamp_null = is_null;
    }

    // agent_fingerprint
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.agent_fingerprint;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.agent_fingerprint_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.agent_fingerprint_value,
        size,
        is_null,
        v);
      i.agent_fingerprint_null = is_null;
      i.agent_fingerprint_size = size;
      grew = grew || (cap != i.agent_fingerprint_value.capacity ());
    }

    // agent_challenge
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.agent_challenge;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.agent_challenge_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.agent_challenge_value,
        size,
        is_null,
        v);
      i.agent_challenge_null = is_null;
      i.agent_challenge_size = size;
      grew = grew || (cap != i.agent_challenge_value.capacity ());
    }

    // controller_checksum
    //
    {
      ::std::string const& v =
        o.controller_checksum;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.controller_checksum_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.controller_checksum_value,
        size,
        is_null,
        v);
      i.controller_checksum_null = is_null;
      i.controller_checksum_size = size;
      grew = grew || (cap != i.controller_checksum_value.capacity ());
    }

    // machine_checksum
    //
    {
      ::std::string const& v =
        o.machine_checksum;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.machine_checksum_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.machine_checksum_value,
        size,
        is_null,
        v);
      i.machine_checksum_null = is_null;
      i.machine_checksum_size = size;
      grew = grew || (cap != i.machine_checksum_value.capacity ());
    }

    // agent_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.agent_checksum;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.agent_checksum_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.agent_checksum_value,
        size,
        is_null,
        v);
      i.agent_checksum_null = is_null;
      i.agent_checksum_size = size;
      grew = grew || (cap != i.agent_checksum_value.capacity ());
    }

    // worker_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.worker_checksum;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.worker_checksum_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.worker_checksum_value,
        size,
        is_null,
        v);
      i.worker_checksum_null = is_null;
      i.worker_checksum_size = size;
      grew = grew || (cap != i.worker_checksum_value.capacity ());
    }

    // dependency_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.dependency_checksum;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.dependency_checksum_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.dependency_checksum_value,
        size,
        is_null,
        v);
      i.dependency_checksum_null = is_null;
      i.dependency_checksum_size = size;
      grew = grew || (cap != i.dependency_checksum_value.capacity ());
    }

    // machine_name
    //
    {
      // From build.hxx:396:7
      ::std::string const& v =
        o.machine.name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.machine_name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.machine_name_value,
        size,
        is_null,
        v);
      i.machine_name_null = is_null;
      i.machine_name_size = size;
      grew = grew || (cap != i.machine_name_value.capacity ());
    }

    // machine_summary
    //
    {
      // From build.hxx:399:7
      ::std::string const& v =
        o.machine.summary;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.machine_summary_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.machine_summary_value,
        size,
        is_null,
        v);
      i.machine_summary_null = is_null;
      i.machine_summary_size = size;
      grew = grew || (cap != i.machine_summary_value.capacity ());
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::build_id& v =
        o.id;

      composite_value_traits< ::brep::build_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // package_version
    //
    {
      // From build.hxx:381:7
      ::brep::upstream_version v;

      composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
        v,
        i.package_version_value,
        db);

      // From build.hxx:381:7
      o.package_version.init (o.id.package.version, (v));
    }

    // toolchain_version
    //
    {
      // From build.hxx:387:7
      ::brep::upstream_version v;

      composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
        v,
        i.toolchain_version_value,
        db);

      // From build.hxx:387:7
      o.toolchain_version.init (o.id.toolchain_version, (v));
    }

    // state
    //
    {
      ::brep::build_state& v =
        o.state;

      ::std::string vt;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        vt,
        i.state_value,
        i.state_size,
        i.state_null);

      // From build.hxx:186:14
      v = brep::to_build_state (vt);
    }

    // interactive
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.interactive;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.interactive_value,
        i.interactive_size,
        i.interactive_null);
    }

    // timestamp
    //
    {
      ::brep::build::timestamp_type& v =
        o.timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.timestamp_value,
        i.timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // force
    //
    {
      ::brep::force_state& v =
        o.force;

      ::std::string vt;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        vt,
        i.force_value,
        i.force_size,
        i.force_null);

      // From build.hxx:208:14
      v = brep::to_force_state (vt);
    }

    // status
    //
    {
      ::butl::optional< ::bbot::result_status >& v =
        o.status;

      ::brep::optional_string vt;

      pgsql::value_traits<
          ::brep::optional_string,
          pgsql::id_string >::set_value (
        vt,
        i.status_value,
        i.status_size,
        i.status_null);

      // From build.hxx:218:14
      v = (vt) ? bbot::to_result_status ( * (vt)) : brep::optional_result_status ();
    }

    // soft_timestamp
    //
    {
      ::brep::build::timestamp_type& v =
        o.soft_timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.soft_timestamp_value,
        i.soft_timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // hard_timestamp
    //
    {
      ::brep::build::timestamp_type& v =
        o.hard_timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.hard_timestamp_value,
        i.hard_timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // agent_fingerprint
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.agent_fingerprint;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.agent_fingerprint_value,
        i.agent_fingerprint_size,
        i.agent_fingerprint_null);
    }

    // agent_challenge
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.agent_challenge;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.agent_challenge_value,
        i.agent_challenge_size,
        i.agent_challenge_null);
    }

    // controller_checksum
    //
    {
      ::std::string& v =
        o.controller_checksum;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.controller_checksum_value,
        i.controller_checksum_size,
        i.controller_checksum_null);
    }

    // machine_checksum
    //
    {
      ::std::string& v =
        o.machine_checksum;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.machine_checksum_value,
        i.machine_checksum_size,
        i.machine_checksum_null);
    }

    // agent_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.agent_checksum;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.agent_checksum_value,
        i.agent_checksum_size,
        i.agent_checksum_null);
    }

    // worker_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.worker_checksum;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.worker_checksum_value,
        i.worker_checksum_size,
        i.worker_checksum_null);
    }

    // dependency_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.dependency_checksum;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.dependency_checksum_value,
        i.dependency_checksum_size,
        i.dependency_checksum_null);
    }

    // machine_name
    //
    {
      // From build.hxx:396:7
      ::std::string& v =
        o.machine.name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.machine_name_value,
        i.machine_name_size,
        i.machine_name_null);
    }

    // machine_summary
    //
    {
      // From build.hxx:399:7
      ::std::string& v =
        o.machine.summary;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.machine_summary_value,
        i.machine_summary_size,
        i.machine_summary_null);
    }
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    pgsql::statement_kind sk (pgsql::statement_select);
    {
      if (composite_value_traits< ::brep::build_id, id_pgsql >::init (
            i.id_value,
            id,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::build, id_pgsql >::persist_statement[] =
  "INSERT INTO \"build\" "
  "(\"package_tenant\", "
  "\"package_name\", "
  "\"package_version_epoch\", "
  "\"package_version_canonical_upstream\", "
  "\"package_version_canonical_release\", "
  "\"package_version_revision\", "
  "\"target\", "
  "\"target_config_name\", "
  "\"package_config_name\", "
  "\"toolchain_name\", "
  "\"toolchain_version_epoch\", "
  "\"toolchain_version_canonical_upstream\", "
  "\"toolchain_version_canonical_release\", "
  "\"toolchain_version_revision\", "
  "\"package_version_upstream\", "
  "\"package_version_release\", "
  "\"toolchain_version_upstream\", "
  "\"toolchain_version_release\", "
  "\"state\", "
  "\"interactive\", "
  "\"timestamp\", "
  "\"force\", "
  "\"status\", "
  "\"soft_timestamp\", "
  "\"hard_timestamp\", "
  "\"agent_fingerprint\", "
  "\"agent_challenge\", "
  "\"controller_checksum\", "
  "\"machine_checksum\", "
  "\"agent_checksum\", "
  "\"worker_checksum\", "
  "\"dependency_checksum\", "
  "\"machine\", "
  "\"machine_summary\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $30, $31, $32, $33, $34)";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::find_statement[] =
  "SELECT "
  "\"build\".\"package_tenant\", "
  "\"build\".\"package_name\"::TEXT, "
  "\"build\".\"package_version_epoch\", "
  "\"build\".\"package_version_canonical_upstream\", "
  "\"build\".\"package_version_canonical_release\", "
  "\"build\".\"package_version_revision\", "
  "\"build\".\"target\", "
  "\"build\".\"target_config_name\", "
  "\"build\".\"package_config_name\", "
  "\"build\".\"toolchain_name\", "
  "\"build\".\"toolchain_version_epoch\", "
  "\"build\".\"toolchain_version_canonical_upstream\", "
  "\"build\".\"toolchain_version_canonical_release\", "
  "\"build\".\"toolchain_version_revision\", "
  "\"build\".\"package_version_upstream\", "
  "\"build\".\"package_version_release\", "
  "\"build\".\"toolchain_version_upstream\", "
  "\"build\".\"toolchain_version_release\", "
  "\"build\".\"state\", "
  "\"build\".\"interactive\", "
  "\"build\".\"timestamp\", "
  "\"build\".\"force\", "
  "\"build\".\"status\", "
  "\"build\".\"soft_timestamp\", "
  "\"build\".\"hard_timestamp\", "
  "\"build\".\"agent_fingerprint\", "
  "\"build\".\"agent_challenge\", "
  "\"build\".\"controller_checksum\", "
  "\"build\".\"machine_checksum\", "
  "\"build\".\"agent_checksum\", "
  "\"build\".\"worker_checksum\", "
  "\"build\".\"dependency_checksum\", "
  "\"build\".\"machine\", "
  "\"build\".\"machine_summary\" "
  "FROM \"build\" "
  "WHERE \"build\".\"package_tenant\"=$1 AND \"build\".\"package_name\"=$2::CITEXT AND \"build\".\"package_version_epoch\"=$3 AND \"build\".\"package_version_canonical_upstream\"=$4 AND \"build\".\"package_version_canonical_release\"=$5 AND \"build\".\"package_version_revision\"=$6 AND \"build\".\"target\"=$7 AND \"build\".\"target_config_name\"=$8 AND \"build\".\"package_config_name\"=$9 AND \"build\".\"toolchain_name\"=$10 AND \"build\".\"toolchain_version_epoch\"=$11 AND \"build\".\"toolchain_version_canonical_upstream\"=$12 AND \"build\".\"toolchain_version_canonical_release\"=$13 AND \"build\".\"toolchain_version_revision\"=$14";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::update_statement[] =
  "UPDATE \"build\" "
  "SET "
  "\"package_version_upstream\"=$1, "
  "\"package_version_release\"=$2, "
  "\"toolchain_version_upstream\"=$3, "
  "\"toolchain_version_release\"=$4, "
  "\"state\"=$5, "
  "\"interactive\"=$6, "
  "\"timestamp\"=$7, "
  "\"force\"=$8, "
  "\"status\"=$9, "
  "\"soft_timestamp\"=$10, "
  "\"hard_timestamp\"=$11, "
  "\"agent_fingerprint\"=$12, "
  "\"agent_challenge\"=$13, "
  "\"controller_checksum\"=$14, "
  "\"machine_checksum\"=$15, "
  "\"agent_checksum\"=$16, "
  "\"worker_checksum\"=$17, "
  "\"dependency_checksum\"=$18, "
  "\"machine\"=$19, "
  "\"machine_summary\"=$20 "
  "WHERE \"package_tenant\"=$21 AND \"package_name\"=$22::CITEXT AND \"package_version_epoch\"=$23 AND \"package_version_canonical_upstream\"=$24 AND \"package_version_canonical_release\"=$25 AND \"package_version_revision\"=$26 AND \"target\"=$27 AND \"target_config_name\"=$28 AND \"package_config_name\"=$29 AND \"toolchain_name\"=$30 AND \"toolchain_version_epoch\"=$31 AND \"toolchain_version_canonical_upstream\"=$32 AND \"toolchain_version_canonical_release\"=$33 AND \"toolchain_version_revision\"=$34";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::erase_statement[] =
  "DELETE FROM \"build\" "
  "WHERE \"package_tenant\"=$1 AND \"package_name\"=$2::CITEXT AND \"package_version_epoch\"=$3 AND \"package_version_canonical_upstream\"=$4 AND \"package_version_canonical_release\"=$5 AND \"package_version_revision\"=$6 AND \"target\"=$7 AND \"target_config_name\"=$8 AND \"package_config_name\"=$9 AND \"toolchain_name\"=$10 AND \"toolchain_version_epoch\"=$11 AND \"toolchain_version_canonical_upstream\"=$12 AND \"toolchain_version_canonical_release\"=$13 AND \"toolchain_version_revision\"=$14";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::query_statement[] =
  "SELECT "
  "\"build\".\"package_tenant\", "
  "\"build\".\"package_name\"::TEXT, "
  "\"build\".\"package_version_epoch\", "
  "\"build\".\"package_version_canonical_upstream\", "
  "\"build\".\"package_version_canonical_release\", "
  "\"build\".\"package_version_revision\", "
  "\"build\".\"target\", "
  "\"build\".\"target_config_name\", "
  "\"build\".\"package_config_name\", "
  "\"build\".\"toolchain_name\", "
  "\"build\".\"toolchain_version_epoch\", "
  "\"build\".\"toolchain_version_canonical_upstream\", "
  "\"build\".\"toolchain_version_canonical_release\", "
  "\"build\".\"toolchain_version_revision\", "
  "\"build\".\"package_version_upstream\", "
  "\"build\".\"package_version_release\", "
  "\"build\".\"toolchain_version_upstream\", "
  "\"build\".\"toolchain_version_release\", "
  "\"build\".\"state\", "
  "\"build\".\"interactive\", "
  "\"build\".\"timestamp\", "
  "\"build\".\"force\", "
  "\"build\".\"status\", "
  "\"build\".\"soft_timestamp\", "
  "\"build\".\"hard_timestamp\", "
  "\"build\".\"agent_fingerprint\", "
  "\"build\".\"agent_challenge\", "
  "\"build\".\"controller_checksum\", "
  "\"build\".\"machine_checksum\", "
  "\"build\".\"agent_checksum\", "
  "\"build\".\"worker_checksum\", "
  "\"build\".\"dependency_checksum\", "
  "\"build\".\"machine\", "
  "\"build\".\"machine_summary\" "
  "FROM \"build\"";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"build\"";

  const char access::object_traits_impl< ::brep::build, id_pgsql >::table_name[] =
  "\"build\"";

  void access::object_traits_impl< ::brep::build, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // auxiliary_machines
    //
    {
      ::std::vector< ::brep::build_machine > const& v =
        obj.auxiliary_machines;

      auxiliary_machines_traits::persist (
        v,
        esc.auxiliary_machines);
    }

    // results
    //
    {
      ::bbot::operation_results const& v =
        obj.results;

      results_traits::persist (
        v,
        esc.results);
    }

    obj.auxiliary_machines_section.reset (true, false);

    obj.results_section.reset (true, false);

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace pgsql;
    using pgsql::update_statement;

    callback (db, obj, callback_event::pre_update);

    pgsql::transaction& tr (pgsql::transaction::current ());
    pgsql::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    if (obj.auxiliary_machines_section.loaded ())
    {
      auxiliary_machines_section_traits::update (esc, obj);
    }

    if (obj.results_section.loaded ())
    {
      results_section_traits::update (esc, obj);
    }

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // auxiliary_machines
    //
    {
      auxiliary_machines_traits::erase (
        esc.auxiliary_machines);
    }

    // results
    //
    {
      results_traits::erase (
        esc.results);
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::build, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::build, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::build, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::build, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::build, id_pgsql >::
  load (connection& conn, object_type& obj, section& s)
  {
    using namespace pgsql;

    pgsql::connection& c (static_cast<pgsql::connection&> (conn));
    statements_type& sts (c.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    bool r (false);

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    if (!r && &s == &obj.auxiliary_machines_section)
    {
      auxiliary_machines_section_traits::load (esc, obj);
      r = true;
    }

    if (!r && &s == &obj.results_section)
    {
      results_section_traits::load (esc, obj);
      r = true;
    }

    sts.load_delayed (0);
    l.unlock ();
    return r;
  }

  bool access::object_traits_impl< ::brep::build, id_pgsql >::
  update (connection& conn, const object_type& obj, const section& s)
  {
    using namespace pgsql;

    pgsql::connection& c (static_cast<pgsql::connection&> (conn));
    statements_type& sts (c.statement_cache ().find_object<object_type> ());
    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (&s == &obj.auxiliary_machines_section)auxiliary_machines_section_traits::update (esc, obj);
    else if (&s == &obj.results_section)results_section_traits::update (esc, obj);
    else
      return false;

    return true;
  }

  bool access::object_traits_impl< ::brep::build, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::build, id_pgsql >::
  load_ (statements_type& sts,
         object_type& obj,
         bool reload)
  {
    ODB_POTENTIALLY_UNUSED (reload);

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    if (reload)
    {
      if (obj.auxiliary_machines_section.loaded ())
      {
        auxiliary_machines_section_traits::load (esc, obj);
        obj.auxiliary_machines_section.reset (true, false);
      }
    }
    else
      obj.auxiliary_machines_section.reset ();

    if (reload)
    {
      if (obj.results_section.loaded ())
      {
        results_section_traits::load (esc, obj);
        obj.results_section.reset (true, false);
      }
    }
    else
      obj.results_section.reset ();
  }

  result< access::object_traits_impl< ::brep::build, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::build, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        false,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::build, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::build, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::build, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // toolchain
  //

  const char access::view_traits_impl< ::brep::toolchain, id_pgsql >::
  query_statement_name[] = "query_brep_toolchain";

  bool access::view_traits_impl< ::brep::toolchain, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // epoch
    //
    t[1UL] = 0;

    // canonical_upstream
    //
    if (t[2UL])
    {
      i.canonical_upstream_value.capacity (i.canonical_upstream_size);
      grew = true;
    }

    // canonical_release
    //
    if (t[3UL])
    {
      i.canonical_release_value.capacity (i.canonical_release_size);
      grew = true;
    }

    // revision
    //
    t[4UL] = 0;

    // version
    //
    if (composite_value_traits< ::brep::upstream_version, id_pgsql >::grow (
          i.version_value, t + 5UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::brep::toolchain, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.name_value.data_ptr ();
    b[n].capacity = i.name_value.capacity ();
    b[n].size = &i.name_size;
    b[n].is_null = &i.name_null;
    n++;

    // epoch
    //
    b[n].type = pgsql::bind::integer;
    b[n].buffer = &i.epoch_value;
    b[n].is_null = &i.epoch_null;
    n++;

    // canonical_upstream
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.canonical_upstream_value.data_ptr ();
    b[n].capacity = i.canonical_upstream_value.capacity ();
    b[n].size = &i.canonical_upstream_size;
    b[n].is_null = &i.canonical_upstream_null;
    n++;

    // canonical_release
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.canonical_release_value.data_ptr ();
    b[n].capacity = i.canonical_release_value.capacity ();
    b[n].size = &i.canonical_release_size;
    b[n].is_null = &i.canonical_release_null;
    n++;

    // revision
    //
    b[n].type = pgsql::bind::integer;
    b[n].buffer = &i.revision_value;
    b[n].is_null = &i.revision_null;
    n++;

    // version
    //
    composite_value_traits< ::brep::upstream_version, id_pgsql >::bind (
      b + n, i.version_value, sk);
    n += 2UL;
  }

  void access::view_traits_impl< ::brep::toolchain, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // epoch
    //
    {
      // From build.hxx:448:23
      ::uint16_t& v =
        o.version_.epoch;

      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_value (
        v,
        i.epoch_value,
        i.epoch_null);
    }

    // canonical_upstream
    //
    {
      // From build.hxx:452:23
      ::std::string& v =
        o.version_.canonical_upstream;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.canonical_upstream_value,
        i.canonical_upstream_size,
        i.canonical_upstream_null);
    }

    // canonical_release
    //
    {
      // From build.hxx:456:23
      ::std::string& v =
        o.version_.canonical_release;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.canonical_release_value,
        i.canonical_release_size,
        i.canonical_release_null);
    }

    // revision
    //
    {
      // From build.hxx:460:23
      ::uint16_t& v =
        o.version_.revision;

      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_value (
        v,
        i.revision_value,
        i.revision_null);
    }

    // version
    //
    {
      // From build.hxx:445:7
      ::brep::upstream_version v;

      composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
        v,
        i.version_value,
        db);

      // From build.hxx:445:7
      o.version.init (o.version_, (v));
    }
  }

  access::view_traits_impl< ::brep::toolchain, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::toolchain, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT DISTINCT "
      "\"build\".\"toolchain_name\", "
      "\"build\".\"toolchain_version_epoch\", "
      "\"build\".\"toolchain_version_canonical_upstream\", "
      "\"build\".\"toolchain_version_canonical_release\", "
      "\"build\".\"toolchain_version_revision\", "
      "\"build\".\"toolchain_version_upstream\", "
      "\"build\".\"toolchain_version_release\" ");

    r += "FROM \"build\"";

    r += " INNER JOIN \"build_package\" ON";
    // From build.hxx:430:5
    r += brep::operator == (query_columns::build::id.package, query_columns::build_package::id) && query_columns::build_package::buildable;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::toolchain, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::toolchain, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::toolchain, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::toolchain, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // package_build
  //

  const char access::view_traits_impl< ::brep::package_build, id_pgsql >::
  query_statement_name[] = "query_brep_package_build";

  bool access::view_traits_impl< ::brep::package_build, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // build
    //
    if (object_traits_impl< ::brep::build, id_pgsql >::grow (
          i.build_value, t + 0UL))
      grew = true;

    // archived
    //
    t[34UL] = 0;

    return grew;
  }

  void access::view_traits_impl< ::brep::package_build, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // build
    //
    object_traits_impl< ::brep::build, id_pgsql >::bind (
      b + n, i.build_value, sk);
    n += 34UL;

    // archived
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.archived_value;
    b[n].is_null = &i.archived_null;
    n++;
  }

  void access::view_traits_impl< ::brep::package_build, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (*db));

    // build pre
    //
    typedef ::brep::build build_object_type;
    typedef object_traits_impl<build_object_type, id_pgsql> build_object_traits;
    typedef build_object_traits::pointer_type build_pointer_type;
    typedef build_object_traits::pointer_traits build_pointer_traits;
    typedef build_object_traits::pointer_cache_traits build_cache_traits;

    build_object_traits::id_type build_id;
    build_pointer_type build_p;
    build_pointer_traits::guard build_pg;
    build_cache_traits::insert_guard build_ig;
    build_object_type* build_o (0);

    {
      if (!composite_value_traits< build_object_traits::id_type, id_pgsql >::get_null (
            i.build_value.id_value))
      {
        build_id = build_object_traits::id (i.build_value);
        build_p = build_cache_traits::find (*db, build_id);

        if (build_pointer_traits::null_ptr (build_p))
        {
          build_p = object_factory<build_object_type, build_pointer_type>::create ();
          build_pg.reset (build_p);
          build_ig.reset (build_cache_traits::insert (*db, build_id, build_p));
          build_o = build_pointer_traits::get_ptr (build_p);
        }
      }
    }

    // build
    //
    {
      if (build_o != 0)
      {
        build_object_traits::callback (*db, *build_o, callback_event::pre_load);
        build_object_traits::init (*build_o, i.build_value, db);
        build_object_traits::statements_type& sts (
          conn.statement_cache ().find_object<build_object_type> ());
        build_object_traits::load_ (sts, *build_o, false);
      }
    }

    // archived
    //
    {
      bool& v =
        o.archived;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.archived_value,
        i.archived_null);
    }

    // build post
    //
    {
      if (build_o != 0)
      {
        build_object_traits::callback (*db, *build_o, callback_event::post_load);
        build_cache_traits::load (build_ig.position ());
        build_ig.release ();
        build_pg.release ();
      }

      // If a compiler error points to the line below, then
      // it most likely means that a pointer used in view
      // member cannot be initialized from an object pointer.
      //
      o.build = ::std::shared_ptr< ::brep::build > (
        std::move (build_p));
    }
  }

  access::view_traits_impl< ::brep::package_build, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::package_build, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"build\".\"package_tenant\", "
      "\"build\".\"package_name\"::TEXT, "
      "\"build\".\"package_version_epoch\", "
      "\"build\".\"package_version_canonical_upstream\", "
      "\"build\".\"package_version_canonical_release\", "
      "\"build\".\"package_version_revision\", "
      "\"build\".\"target\", "
      "\"build\".\"target_config_name\", "
      "\"build\".\"package_config_name\", "
      "\"build\".\"toolchain_name\", "
      "\"build\".\"toolchain_version_epoch\", "
      "\"build\".\"toolchain_version_canonical_upstream\", "
      "\"build\".\"toolchain_version_canonical_release\", "
      "\"build\".\"toolchain_version_revision\", "
      "\"build\".\"package_version_upstream\", "
      "\"build\".\"package_version_release\", "
      "\"build\".\"toolchain_version_upstream\", "
      "\"build\".\"toolchain_version_release\", "
      "\"build\".\"state\", "
      "\"build\".\"interactive\", "
      "\"build\".\"timestamp\", "
      "\"build\".\"force\", "
      "\"build\".\"status\", "
      "\"build\".\"soft_timestamp\", "
      "\"build\".\"hard_timestamp\", "
      "\"build\".\"agent_fingerprint\", "
      "\"build\".\"agent_challenge\", "
      "\"build\".\"controller_checksum\", "
      "\"build\".\"machine_checksum\", "
      "\"build\".\"agent_checksum\", "
      "\"build\".\"worker_checksum\", "
      "\"build\".\"dependency_checksum\", "
      "\"build\".\"machine\", "
      "\"build\".\"machine_summary\", "
      "\"build_tenant\".\"archived\" ");

    r += "FROM \"build\"";

    r += " INNER JOIN \"build_package\" ON";
    // From build.hxx:474:5
    r += brep::operator == (query_columns::build::id.package, query_columns::build_package::id) && query_columns::build_package::buildable;

    r += " LEFT JOIN \"build_tenant\" ON";
    // From build.hxx:477:5
    r += query_columns::build_package::id.tenant == query_columns::build_tenant::id;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::package_build, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::package_build, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::package_build, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::package_build, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // package_build_count
  //

  const char access::view_traits_impl< ::brep::package_build_count, id_pgsql >::
  query_statement_name[] = "query_brep_package_build_count";

  bool access::view_traits_impl< ::brep::package_build_count, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = 0;

    return grew;
  }

  void access::view_traits_impl< ::brep::package_build_count, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::brep::package_build_count, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::brep::package_build_count, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::package_build_count, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "count(\"build\".\"package_name\") ");

    r += "FROM \"build\"";

    r += " INNER JOIN \"build_package\" ON";
    // From build.hxx:486:5
    r += brep::operator == (query_columns::build::id.package, query_columns::build_package::id) && query_columns::build_package::buildable;

    r += " LEFT JOIN \"build_tenant\" ON";
    // From build.hxx:489:5
    r += query_columns::build_package::id.tenant == query_columns::build_tenant::id;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::package_build_count, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::package_build_count, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::package_build_count, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::package_build_count, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // package_build_id
  //

  const char access::view_traits_impl< ::brep::package_build_id, id_pgsql >::
  query_statement_name[] = "query_brep_package_build_id";

  bool access::view_traits_impl< ::brep::package_build_id, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::build_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::brep::package_build_id, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // id
    //
    composite_value_traits< ::brep::build_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
    n += 14UL;
  }

  void access::view_traits_impl< ::brep::package_build_id, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::build_id& v =
        o.id;

      composite_value_traits< ::brep::build_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }
  }

  access::view_traits_impl< ::brep::package_build_id, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::package_build_id, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"build\".\"package_tenant\", "
      "\"build\".\"package_name\"::TEXT, "
      "\"build\".\"package_version_epoch\", "
      "\"build\".\"package_version_canonical_upstream\", "
      "\"build\".\"package_version_canonical_release\", "
      "\"build\".\"package_version_revision\", "
      "\"build\".\"target\", "
      "\"build\".\"target_config_name\", "
      "\"build\".\"package_config_name\", "
      "\"build\".\"toolchain_name\", "
      "\"build\".\"toolchain_version_epoch\", "
      "\"build\".\"toolchain_version_canonical_upstream\", "
      "\"build\".\"toolchain_version_canonical_release\", "
      "\"build\".\"toolchain_version_revision\" ");

    r += "FROM \"build\"";

    r += " INNER JOIN \"build_package\" ON";
    // From build.hxx:504:5
    r += brep::operator == (query_columns::build::id.package, query_columns::build_package::id) && query_columns::build_package::buildable;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::package_build_id, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::package_build_id, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::package_build_id, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::package_build_id, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // build_delay
  //

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  persist_statement_name[] = "persist_brep_build_delay";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  find_statement_name[] = "find_brep_build_delay";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  update_statement_name[] = "update_brep_build_delay";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  erase_statement_name[] = "erase_brep_build_delay";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  query_statement_name[] = "query_brep_build_delay";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_build_delay";

  const unsigned int access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::int8_oid
  };

  const unsigned int access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid
  };

  const unsigned int access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  update_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid
  };

  struct access::object_traits_impl< ::brep::build_delay, id_pgsql >::extra_statement_cache_type
  {
    extra_statement_cache_type (
      pgsql::connection&,
      image_type&,
      id_image_type&,
      pgsql::binding&,
      pgsql::binding&,
      pgsql::native_binding&,
      const unsigned int*)
    {
    }
  };

  access::object_traits_impl< ::brep::build_delay, id_pgsql >::id_type
  access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      composite_value_traits< ::brep::build_id, id_pgsql >::init (
        id,
        i.id_value,
        db);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::build_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // package_version
    //
    if (composite_value_traits< ::brep::upstream_version, id_pgsql >::grow (
          i.package_version_value, t + 14UL))
      grew = true;

    // toolchain_version
    //
    if (composite_value_traits< ::brep::upstream_version, id_pgsql >::grow (
          i.toolchain_version_value, t + 16UL))
      grew = true;

    // report_soft_timestamp
    //
    t[18UL] = 0;

    // report_hard_timestamp
    //
    t[19UL] = 0;

    // package_timestamp
    //
    t[20UL] = 0;

    return grew;
  }

  void access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      composite_value_traits< ::brep::build_id, id_pgsql >::bind (
        b + n, i.id_value, sk);
      n += 14UL;
    }

    // package_version
    //
    composite_value_traits< ::brep::upstream_version, id_pgsql >::bind (
      b + n, i.package_version_value, sk);
    n += 2UL;

    // toolchain_version
    //
    composite_value_traits< ::brep::upstream_version, id_pgsql >::bind (
      b + n, i.toolchain_version_value, sk);
    n += 2UL;

    // report_soft_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.report_soft_timestamp_value;
    b[n].is_null = &i.report_soft_timestamp_null;
    n++;

    // report_hard_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.report_hard_timestamp_value;
    b[n].is_null = &i.report_hard_timestamp_null;
    n++;

    // package_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.package_timestamp_value;
    b[n].is_null = &i.package_timestamp_null;
    n++;
  }

  void access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    pgsql::statement_kind sk (pgsql::statement_select);
    composite_value_traits< ::brep::build_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
  }

  bool access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::brep::build_id const& v =
        o.id;

      if (composite_value_traits< ::brep::build_id, id_pgsql >::init (
            i.id_value,
            v,
            sk))
        grew = true;
    }

    // package_version
    //
    {
      ::brep::upstream_version const& v =
        o.package_version;

      if (composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
            i.package_version_value,
            v,
            sk))
        grew = true;
    }

    // toolchain_version
    //
    {
      ::brep::upstream_version const& v =
        o.toolchain_version;

      if (composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
            i.toolchain_version_value,
            v,
            sk))
        grew = true;
    }

    // report_soft_timestamp
    //
    {
      ::butl::timestamp const& v =
        o.report_soft_timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.report_soft_timestamp_value, is_null, vt);
      i.report_soft_timestamp_null = is_null;
    }

    // report_hard_timestamp
    //
    {
      ::butl::timestamp const& v =
        o.report_hard_timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.report_hard_timestamp_value, is_null, vt);
      i.report_hard_timestamp_null = is_null;
    }

    // package_timestamp
    //
    {
      ::butl::timestamp const& v =
        o.package_timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.package_timestamp_value, is_null, vt);
      i.package_timestamp_null = is_null;
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::build_id& v =
        o.id;

      composite_value_traits< ::brep::build_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // package_version
    //
    {
      // From build.hxx:568:7
      ::brep::upstream_version v;

      composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
        v,
        i.package_version_value,
        db);

      // From build.hxx:568:7
      o.package_version.init (o.id.package.version, (v));
    }

    // toolchain_version
    //
    {
      // From build.hxx:574:7
      ::brep::upstream_version v;

      composite_value_traits< ::brep::upstream_version, id_pgsql >::init (
        v,
        i.toolchain_version_value,
        db);

      // From build.hxx:574:7
      o.toolchain_version.init (o.id.toolchain_version, (v));
    }

    // report_soft_timestamp
    //
    {
      ::butl::timestamp& v =
        o.report_soft_timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.report_soft_timestamp_value,
        i.report_soft_timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // report_hard_timestamp
    //
    {
      ::butl::timestamp& v =
        o.report_hard_timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.report_hard_timestamp_value,
        i.report_hard_timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // package_timestamp
    //
    {
      ::butl::timestamp& v =
        o.package_timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.package_timestamp_value,
        i.package_timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }
  }

  void access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    pgsql::statement_kind sk (pgsql::statement_select);
    {
      if (composite_value_traits< ::brep::build_id, id_pgsql >::init (
            i.id_value,
            id,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::persist_statement[] =
  "INSERT INTO \"build_delay\" "
  "(\"package_tenant\", "
  "\"package_name\", "
  "\"package_version_epoch\", "
  "\"package_version_canonical_upstream\", "
  "\"package_version_canonical_release\", "
  "\"package_version_revision\", "
  "\"target\", "
  "\"target_config_name\", "
  "\"package_config_name\", "
  "\"toolchain_name\", "
  "\"toolchain_version_epoch\", "
  "\"toolchain_version_canonical_upstream\", "
  "\"toolchain_version_canonical_release\", "
  "\"toolchain_version_revision\", "
  "\"package_version_upstream\", "
  "\"package_version_release\", "
  "\"toolchain_version_upstream\", "
  "\"toolchain_version_release\", "
  "\"report_soft_timestamp\", "
  "\"report_hard_timestamp\", "
  "\"package_timestamp\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21)";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::find_statement[] =
  "SELECT "
  "\"build_delay\".\"package_tenant\", "
  "\"build_delay\".\"package_name\"::TEXT, "
  "\"build_delay\".\"package_version_epoch\", "
  "\"build_delay\".\"package_version_canonical_upstream\", "
  "\"build_delay\".\"package_version_canonical_release\", "
  "\"build_delay\".\"package_version_revision\", "
  "\"build_delay\".\"target\", "
  "\"build_delay\".\"target_config_name\", "
  "\"build_delay\".\"package_config_name\", "
  "\"build_delay\".\"toolchain_name\", "
  "\"build_delay\".\"toolchain_version_epoch\", "
  "\"build_delay\".\"toolchain_version_canonical_upstream\", "
  "\"build_delay\".\"toolchain_version_canonical_release\", "
  "\"build_delay\".\"toolchain_version_revision\", "
  "\"build_delay\".\"package_version_upstream\", "
  "\"build_delay\".\"package_version_release\", "
  "\"build_delay\".\"toolchain_version_upstream\", "
  "\"build_delay\".\"toolchain_version_release\", "
  "\"build_delay\".\"report_soft_timestamp\", "
  "\"build_delay\".\"report_hard_timestamp\", "
  "\"build_delay\".\"package_timestamp\" "
  "FROM \"build_delay\" "
  "WHERE \"build_delay\".\"package_tenant\"=$1 AND \"build_delay\".\"package_name\"=$2::CITEXT AND \"build_delay\".\"package_version_epoch\"=$3 AND \"build_delay\".\"package_version_canonical_upstream\"=$4 AND \"build_delay\".\"package_version_canonical_release\"=$5 AND \"build_delay\".\"package_version_revision\"=$6 AND \"build_delay\".\"target\"=$7 AND \"build_delay\".\"target_config_name\"=$8 AND \"build_delay\".\"package_config_name\"=$9 AND \"build_delay\".\"toolchain_name\"=$10 AND \"build_delay\".\"toolchain_version_epoch\"=$11 AND \"build_delay\".\"toolchain_version_canonical_upstream\"=$12 AND \"build_delay\".\"toolchain_version_canonical_release\"=$13 AND \"build_delay\".\"toolchain_version_revision\"=$14";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::update_statement[] =
  "UPDATE \"build_delay\" "
  "SET "
  "\"package_version_upstream\"=$1, "
  "\"package_version_release\"=$2, "
  "\"toolchain_version_upstream\"=$3, "
  "\"toolchain_version_release\"=$4, "
  "\"report_soft_timestamp\"=$5, "
  "\"report_hard_timestamp\"=$6, "
  "\"package_timestamp\"=$7 "
  "WHERE \"package_tenant\"=$8 AND \"package_name\"=$9::CITEXT AND \"package_version_epoch\"=$10 AND \"package_version_canonical_upstream\"=$11 AND \"package_version_canonical_release\"=$12 AND \"package_version_revision\"=$13 AND \"target\"=$14 AND \"target_config_name\"=$15 AND \"package_config_name\"=$16 AND \"toolchain_name\"=$17 AND \"toolchain_version_epoch\"=$18 AND \"toolchain_version_canonical_upstream\"=$19 AND \"toolchain_version_canonical_release\"=$20 AND \"toolchain_version_revision\"=$21";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::erase_statement[] =
  "DELETE FROM \"build_delay\" "
  "WHERE \"package_tenant\"=$1 AND \"package_name\"=$2::CITEXT AND \"package_version_epoch\"=$3 AND \"package_version_canonical_upstream\"=$4 AND \"package_version_canonical_release\"=$5 AND \"package_version_revision\"=$6 AND \"target\"=$7 AND \"target_config_name\"=$8 AND \"package_config_name\"=$9 AND \"toolchain_name\"=$10 AND \"toolchain_version_epoch\"=$11 AND \"toolchain_version_canonical_upstream\"=$12 AND \"toolchain_version_canonical_release\"=$13 AND \"toolchain_version_revision\"=$14";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::query_statement[] =
  "SELECT "
  "\"build_delay\".\"package_tenant\", "
  "\"build_delay\".\"package_name\"::TEXT, "
  "\"build_delay\".\"package_version_epoch\", "
  "\"build_delay\".\"package_version_canonical_upstream\", "
  "\"build_delay\".\"package_version_canonical_release\", "
  "\"build_delay\".\"package_version_revision\", "
  "\"build_delay\".\"target\", "
  "\"build_delay\".\"target_config_name\", "
  "\"build_delay\".\"package_config_name\", "
  "\"build_delay\".\"toolchain_name\", "
  "\"build_delay\".\"toolchain_version_epoch\", "
  "\"build_delay\".\"toolchain_version_canonical_upstream\", "
  "\"build_delay\".\"toolchain_version_canonical_release\", "
  "\"build_delay\".\"toolchain_version_revision\", "
  "\"build_delay\".\"package_version_upstream\", "
  "\"build_delay\".\"package_version_release\", "
  "\"build_delay\".\"toolchain_version_upstream\", "
  "\"build_delay\".\"toolchain_version_release\", "
  "\"build_delay\".\"report_soft_timestamp\", "
  "\"build_delay\".\"report_hard_timestamp\", "
  "\"build_delay\".\"package_timestamp\" "
  "FROM \"build_delay\"";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"build_delay\"";

  const char access::object_traits_impl< ::brep::build_delay, id_pgsql >::table_name[] =
  "\"build_delay\"";

  void access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace pgsql;
    using pgsql::update_statement;

    callback (db, obj, callback_event::pre_update);

    pgsql::transaction& tr (pgsql::transaction::current ());
    pgsql::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::build_delay, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  result< access::object_traits_impl< ::brep::build_delay, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        false,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::build_delay, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }
}

namespace odb
{
  static bool
  create_schema (database& db, unsigned short pass, bool drop)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (drop);

    if (drop)
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("DROP TABLE IF EXISTS \"build_delay\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"build_results\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"build_auxiliary_machines\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"build\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"schema_version\"");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("CREATE TABLE \"build\" (\n"
                      "  \"package_tenant\" TEXT NOT NULL,\n"
                      "  \"package_name\" CITEXT NOT NULL,\n"
                      "  \"package_version_epoch\" INTEGER NOT NULL,\n"
                      "  \"package_version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"package_version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"package_version_revision\" INTEGER NOT NULL,\n"
                      "  \"target\" TEXT NOT NULL,\n"
                      "  \"target_config_name\" TEXT NOT NULL,\n"
                      "  \"package_config_name\" TEXT NOT NULL,\n"
                      "  \"toolchain_name\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_epoch\" INTEGER NOT NULL,\n"
                      "  \"toolchain_version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"toolchain_version_revision\" INTEGER NOT NULL,\n"
                      "  \"package_version_upstream\" TEXT NOT NULL,\n"
                      "  \"package_version_release\" TEXT NULL,\n"
                      "  \"toolchain_version_upstream\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_release\" TEXT NULL,\n"
                      "  \"state\" TEXT NOT NULL,\n"
                      "  \"interactive\" TEXT NULL,\n"
                      "  \"timestamp\" BIGINT NOT NULL,\n"
                      "  \"force\" TEXT NOT NULL,\n"
                      "  \"status\" TEXT NULL,\n"
                      "  \"soft_timestamp\" BIGINT NOT NULL,\n"
                      "  \"hard_timestamp\" BIGINT NOT NULL,\n"
                      "  \"agent_fingerprint\" TEXT NULL,\n"
                      "  \"agent_challenge\" TEXT NULL,\n"
                      "  \"controller_checksum\" TEXT NOT NULL,\n"
                      "  \"machine_checksum\" TEXT NOT NULL,\n"
                      "  \"agent_checksum\" TEXT NULL,\n"
                      "  \"worker_checksum\" TEXT NULL,\n"
                      "  \"dependency_checksum\" TEXT NULL,\n"
                      "  \"machine\" TEXT NOT NULL,\n"
                      "  \"machine_summary\" TEXT NOT NULL,\n"
                      "  PRIMARY KEY (\"package_tenant\",\n"
                      "               \"package_name\",\n"
                      "               \"package_version_epoch\",\n"
                      "               \"package_version_canonical_upstream\",\n"
                      "               \"package_version_canonical_release\",\n"
                      "               \"package_version_revision\",\n"
                      "               \"target\",\n"
                      "               \"target_config_name\",\n"
                      "               \"package_config_name\",\n"
                      "               \"toolchain_name\",\n"
                      "               \"toolchain_version_epoch\",\n"
                      "               \"toolchain_version_canonical_upstream\",\n"
                      "               \"toolchain_version_canonical_release\",\n"
                      "               \"toolchain_version_revision\"))");
          db.execute ("CREATE INDEX \"build_timestamp_i\"\n"
                      "  ON \"build\" (\"timestamp\")");
          db.execute ("CREATE TABLE \"build_auxiliary_machines\" (\n"
                      "  \"package_tenant\" TEXT NOT NULL,\n"
                      "  \"package_name\" CITEXT NOT NULL,\n"
                      "  \"package_version_epoch\" INTEGER NOT NULL,\n"
                      "  \"package_version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"package_version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"package_version_revision\" INTEGER NOT NULL,\n"
                      "  \"target\" TEXT NOT NULL,\n"
                      "  \"target_config_name\" TEXT NOT NULL,\n"
                      "  \"package_config_name\" TEXT NOT NULL,\n"
                      "  \"toolchain_name\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_epoch\" INTEGER NOT NULL,\n"
                      "  \"toolchain_version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"toolchain_version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"name\" TEXT NOT NULL,\n"
                      "  \"summary\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"package_tenant\",\n"
                      "                 \"package_name\",\n"
                      "                 \"package_version_epoch\",\n"
                      "                 \"package_version_canonical_upstream\",\n"
                      "                 \"package_version_canonical_release\",\n"
                      "                 \"package_version_revision\",\n"
                      "                 \"target\",\n"
                      "                 \"target_config_name\",\n"
                      "                 \"package_config_name\",\n"
                      "                 \"toolchain_name\",\n"
                      "                 \"toolchain_version_epoch\",\n"
                      "                 \"toolchain_version_canonical_upstream\",\n"
                      "                 \"toolchain_version_canonical_release\",\n"
                      "                 \"toolchain_version_revision\")\n"
                      "    REFERENCES \"build\" (\"package_tenant\",\n"
                      "                        \"package_name\",\n"
                      "                        \"package_version_epoch\",\n"
                      "                        \"package_version_canonical_upstream\",\n"
                      "                        \"package_version_canonical_release\",\n"
                      "                        \"package_version_revision\",\n"
                      "                        \"target\",\n"
                      "                        \"target_config_name\",\n"
                      "                        \"package_config_name\",\n"
                      "                        \"toolchain_name\",\n"
                      "                        \"toolchain_version_epoch\",\n"
                      "                        \"toolchain_version_canonical_upstream\",\n"
                      "                        \"toolchain_version_canonical_release\",\n"
                      "                        \"toolchain_version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"build_auxiliary_machines_object_id_i\"\n"
                      "  ON \"build_auxiliary_machines\" (\n"
                      "    \"package_tenant\",\n"
                      "    \"package_name\",\n"
                      "    \"package_version_epoch\",\n"
                      "    \"package_version_canonical_upstream\",\n"
                      "    \"package_version_canonical_release\",\n"
                      "    \"package_version_revision\",\n"
                      "    \"target\",\n"
                      "    \"target_config_name\",\n"
                      "    \"package_config_name\",\n"
                      "    \"toolchain_name\",\n"
                      "    \"toolchain_version_epoch\",\n"
                      "    \"toolchain_version_canonical_upstream\",\n"
                      "    \"toolchain_version_canonical_release\",\n"
                      "    \"toolchain_version_revision\")");
          db.execute ("CREATE INDEX \"build_auxiliary_machines_index_i\"\n"
                      "  ON \"build_auxiliary_machines\" (\"index\")");
          db.execute ("CREATE TABLE \"build_results\" (\n"
                      "  \"package_tenant\" TEXT NOT NULL,\n"
                      "  \"package_name\" CITEXT NOT NULL,\n"
                      "  \"package_version_epoch\" INTEGER NOT NULL,\n"
                      "  \"package_version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"package_version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"package_version_revision\" INTEGER NOT NULL,\n"
                      "  \"target\" TEXT NOT NULL,\n"
                      "  \"target_config_name\" TEXT NOT NULL,\n"
                      "  \"package_config_name\" TEXT NOT NULL,\n"
                      "  \"toolchain_name\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_epoch\" INTEGER NOT NULL,\n"
                      "  \"toolchain_version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"toolchain_version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"operation\" TEXT NOT NULL,\n"
                      "  \"status\" TEXT NOT NULL,\n"
                      "  \"log\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"package_tenant\",\n"
                      "                 \"package_name\",\n"
                      "                 \"package_version_epoch\",\n"
                      "                 \"package_version_canonical_upstream\",\n"
                      "                 \"package_version_canonical_release\",\n"
                      "                 \"package_version_revision\",\n"
                      "                 \"target\",\n"
                      "                 \"target_config_name\",\n"
                      "                 \"package_config_name\",\n"
                      "                 \"toolchain_name\",\n"
                      "                 \"toolchain_version_epoch\",\n"
                      "                 \"toolchain_version_canonical_upstream\",\n"
                      "                 \"toolchain_version_canonical_release\",\n"
                      "                 \"toolchain_version_revision\")\n"
                      "    REFERENCES \"build\" (\"package_tenant\",\n"
                      "                        \"package_name\",\n"
                      "                        \"package_version_epoch\",\n"
                      "                        \"package_version_canonical_upstream\",\n"
                      "                        \"package_version_canonical_release\",\n"
                      "                        \"package_version_revision\",\n"
                      "                        \"target\",\n"
                      "                        \"target_config_name\",\n"
                      "                        \"package_config_name\",\n"
                      "                        \"toolchain_name\",\n"
                      "                        \"toolchain_version_epoch\",\n"
                      "                        \"toolchain_version_canonical_upstream\",\n"
                      "                        \"toolchain_version_canonical_release\",\n"
                      "                        \"toolchain_version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"build_results_object_id_i\"\n"
                      "  ON \"build_results\" (\n"
                      "    \"package_tenant\",\n"
                      "    \"package_name\",\n"
                      "    \"package_version_epoch\",\n"
                      "    \"package_version_canonical_upstream\",\n"
                      "    \"package_version_canonical_release\",\n"
                      "    \"package_version_revision\",\n"
                      "    \"target\",\n"
                      "    \"target_config_name\",\n"
                      "    \"package_config_name\",\n"
                      "    \"toolchain_name\",\n"
                      "    \"toolchain_version_epoch\",\n"
                      "    \"toolchain_version_canonical_upstream\",\n"
                      "    \"toolchain_version_canonical_release\",\n"
                      "    \"toolchain_version_revision\")");
          db.execute ("CREATE INDEX \"build_results_index_i\"\n"
                      "  ON \"build_results\" (\"index\")");
          db.execute ("CREATE TABLE \"build_delay\" (\n"
                      "  \"package_tenant\" TEXT NOT NULL,\n"
                      "  \"package_name\" CITEXT NOT NULL,\n"
                      "  \"package_version_epoch\" INTEGER NOT NULL,\n"
                      "  \"package_version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"package_version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"package_version_revision\" INTEGER NOT NULL,\n"
                      "  \"target\" TEXT NOT NULL,\n"
                      "  \"target_config_name\" TEXT NOT NULL,\n"
                      "  \"package_config_name\" TEXT NOT NULL,\n"
                      "  \"toolchain_name\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_epoch\" INTEGER NOT NULL,\n"
                      "  \"toolchain_version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"toolchain_version_revision\" INTEGER NOT NULL,\n"
                      "  \"package_version_upstream\" TEXT NOT NULL,\n"
                      "  \"package_version_release\" TEXT NULL,\n"
                      "  \"toolchain_version_upstream\" TEXT NOT NULL,\n"
                      "  \"toolchain_version_release\" TEXT NULL,\n"
                      "  \"report_soft_timestamp\" BIGINT NOT NULL,\n"
                      "  \"report_hard_timestamp\" BIGINT NOT NULL,\n"
                      "  \"package_timestamp\" BIGINT NOT NULL,\n"
                      "  PRIMARY KEY (\"package_tenant\",\n"
                      "               \"package_name\",\n"
                      "               \"package_version_epoch\",\n"
                      "               \"package_version_canonical_upstream\",\n"
                      "               \"package_version_canonical_release\",\n"
                      "               \"package_version_revision\",\n"
                      "               \"target\",\n"
                      "               \"target_config_name\",\n"
                      "               \"package_config_name\",\n"
                      "               \"toolchain_name\",\n"
                      "               \"toolchain_version_epoch\",\n"
                      "               \"toolchain_version_canonical_upstream\",\n"
                      "               \"toolchain_version_canonical_release\",\n"
                      "               \"toolchain_version_revision\"))");
          return true;
        }
        case 2:
        {
          db.execute ("CREATE TABLE \"schema_version\" (\n"
                      "  \"name\" TEXT NOT NULL PRIMARY KEY,\n"
                      "  \"version\" BIGINT NOT NULL,\n"
                      "  \"migration\" BOOLEAN NOT NULL)");
          db.execute ("INSERT INTO \"schema_version\" (\n"
                      "  \"name\", \"version\", \"migration\")\n"
                      "  VALUES ('build', 29, FALSE)");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_create_entry
  create_schema_entry_ (
    id_pgsql,
    "build",
    &create_schema);

  static const schema_catalog_migrate_entry
  migrate_schema_entry_28_ (
    id_pgsql,
    "build",
    28ULL,
    0);

  static bool
  migrate_schema_29 (database& db, unsigned short pass, bool pre)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (pre);

    if (pre)
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"schema_version\"\n"
                      "  SET \"version\" = 29, \"migration\" = TRUE\n"
                      "  WHERE \"name\" = 'build'");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"schema_version\"\n"
                      "  SET \"migration\" = FALSE\n"
                      "  WHERE \"name\" = 'build'");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_migrate_entry
  migrate_schema_entry_29_ (
    id_pgsql,
    "build",
    29ULL,
    &migrate_schema_29);
}

#include <odb/post.hxx>
