// file      : libbrep/version.hxx.in -*- C++ -*-
// license   : MIT; see accompanying LICENSE file

#ifndef BREP_VERSION // Note: using the version macro itself.

// The numeric version format is AAAAABBBBBCCCCCDDDE where:
//
// AAAAA - major version number
// BBBBB - minor version number
// CCCCC - bugfix version number
// DDD   - alpha / beta (DDD + 500) version number
// E     - final (0) / snapshot (1)
//
// When DDDE is not 0, 1 is subtracted from AAAAABBBBBCCCCC. For example:
//
// Version      AAAAABBBBBCCCCCDDDE
//
// 0.1.0        0000000001000000000
// 0.1.2        0000000001000020000
// 1.2.3        0000100002000030000
// 2.2.0-a.1    0000200001999990010
// 3.0.0-b.2    0000299999999995020
// 2.2.0-a.1.z  0000200001999990011
//
#define BREP_VERSION       17999990001ULL
#define BREP_VERSION_STR   "0.18.0-a.0.20251008154705.ed0171a1b943"
#define BREP_VERSION_ID    "0.18.0-a.0.ed0171a1b943"

#define BREP_VERSION_MAJOR 0
#define BREP_VERSION_MINOR 18
#define BREP_VERSION_PATCH 0

#define BREP_PRE_RELEASE   true

#define BREP_SNAPSHOT      20251008154705ULL
#define BREP_SNAPSHOT_ID   "ed0171a1b943"

#include <libbutl/version.hxx>

#ifdef LIBBUTL_VERSION
#  if !((LIBBUTL_VERSION > 17999990001ULL || (LIBBUTL_VERSION == 17999990001ULL && LIBBUTL_SNAPSHOT >= 1ULL)) && LIBBUTL_VERSION < 17999990010ULL)
#    error incompatible libbutl version, libbutl [0.18.0-a.0.1 0.18.0-a.1) is required
#  endif
#endif

#include <libbpkg/version.hxx>

#ifdef LIBBPKG_VERSION
#  if !((LIBBPKG_VERSION > 17999990001ULL || (LIBBPKG_VERSION == 17999990001ULL && LIBBPKG_SNAPSHOT >= 1ULL)) && LIBBPKG_VERSION < 17999990010ULL)
#    error incompatible libbpkg version, libbpkg [0.18.0-a.0.1 0.18.0-a.1) is required
#  endif
#endif

#include <libbbot/version.hxx>

#ifdef LIBBBOT_VERSION
#  if !((LIBBBOT_VERSION > 17999990001ULL || (LIBBBOT_VERSION == 17999990001ULL && LIBBBOT_SNAPSHOT >= 1ULL)) && LIBBBOT_VERSION < 17999990010ULL)
#    error incompatible libbbot version, libbbot [0.18.0-a.0.1 0.18.0-a.1) is required
#  endif
#endif

#include <odb/version.hxx>

#ifdef LIBODB_VERSION_FULL
#  if !(LIBODB_VERSION_FULL >= 200005000000000ULL && LIBODB_VERSION_FULL < 299999999990001ULL)
#    error incompatible libodb version, libodb ^2.5.0 is required
#  endif
#endif

#include <odb/pgsql/version.hxx>

#ifdef LIBODB_PGSQL_VERSION_FULL
#  if !(LIBODB_PGSQL_VERSION_FULL >= 200005000000000ULL && LIBODB_PGSQL_VERSION_FULL < 299999999990001ULL)
#    error incompatible libodb-pgsql version, libodb-pgsql ^2.5.0 is required
#  endif
#endif

// For now these are the same.
//
#define LIBBREP_VERSION BREP_VERSION
#define LIBBREP_VERSION_STR BREP_VERSION_STR
#define LIBBREP_VERSION_ID BREP_VERSION_ID

#endif // BREP_VERSION
