// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#include <odb/pre.hxx>

#include <libbrep/package-odb.hxx>

#include <cassert>
#include <cstring>  // std::memcpy

#include <odb/schema-catalog-impl.hxx>

#include <odb/pgsql/traits.hxx>
#include <odb/pgsql/database.hxx>
#include <odb/pgsql/transaction.hxx>
#include <odb/pgsql/connection.hxx>
#include <odb/pgsql/statement.hxx>
#include <odb/pgsql/statement-cache.hxx>
#include <odb/pgsql/simple-object-statements.hxx>
#include <odb/pgsql/view-statements.hxx>
#include <odb/pgsql/section-statements.hxx>
#include <odb/pgsql/container-statements.hxx>
#include <odb/pgsql/exceptions.hxx>
#include <odb/pgsql/prepared-query.hxx>
#include <odb/pgsql/simple-object-result.hxx>
#include <odb/pgsql/view-result.hxx>

namespace odb
{
  // priority
  //

  bool access::composite_value_traits< ::bpkg::priority, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // value
    //
    t[0UL] = 0;

    // comment
    //
    if (t[1UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::priority, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // value
    //
    b[n].type = pgsql::bind::integer;
    b[n].buffer = &i.value_value;
    b[n].is_null = &i.value_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::priority, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // value
    //
    {
      ::bpkg::priority::value_type const& v =
        o.value;

      bool is_null (false);
      pgsql::value_traits<
          ::bpkg::priority::value_type,
          pgsql::id_integer >::set_image (
        i.value_value, is_null, v);
      i.value_null = is_null;
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::priority, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // value
    //
    {
      ::bpkg::priority::value_type& v =
        o.value;

      pgsql::value_traits<
          ::bpkg::priority::value_type,
          pgsql::id_integer >::set_value (
        v,
        i.value_value,
        i.value_null);
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // licenses
  //

  bool access::composite_value_traits< ::bpkg::licenses, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // comment
    //
    if (t[0UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::licenses, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::licenses, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::licenses, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // manifest_url
  //

  bool access::composite_value_traits< ::bpkg::manifest_url, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // value
    //
    if (t[0UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    // comment
    //
    if (t[1UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::manifest_url, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // value
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.value_value.data_ptr ();
    b[n].capacity = i.value_value.capacity ();
    b[n].size = &i.value_size;
    b[n].is_null = &i.value_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::manifest_url, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // value
    //
    {
      // From package.hxx:70:5
      ::std::string const& v =
        o.string ();

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.value_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.value_value,
        size,
        is_null,
        v);
      i.value_null = is_null;
      i.value_size = size;
      grew = grew || (cap != i.value_value.capacity ());
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::manifest_url, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // value
    //
    {
      // From package.hxx:71:5
      ::std::string v;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.value_value,
        i.value_size,
        i.value_null);

      // From package.hxx:71:5
      o = brep::manifest_url ((v), "");
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // dependency
  //

  bool access::composite_value_traits< ::brep::dependency, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // constraint
    //
    if (composite_value_traits< ::bpkg::version_constraint, id_pgsql >::grow (
          i.constraint_value, t + 1UL))
      grew = true;

    // package
    //
    if (composite_value_traits< ::brep::package_id, id_pgsql >::grow (
          i.package_value, t + 15UL))
      grew = true;

    return grew;
  }

  void access::composite_value_traits< ::brep::dependency, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.name_value.data_ptr ();
    b[n].capacity = i.name_value.capacity ();
    b[n].size = &i.name_size;
    b[n].is_null = &i.name_null;
    n++;

    // constraint
    //
    composite_value_traits< ::bpkg::version_constraint, id_pgsql >::bind (
      b + n, i.constraint_value, sk);
    n += 14UL;

    // package
    //
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.package_value, sk);
    n += 6UL;
  }

  bool access::composite_value_traits< ::brep::dependency, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // name
    //
    {
      ::bpkg::package_name const& v =
        o.name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.name_value.capacity ());
      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_image (
        i.name_value,
        size,
        is_null,
        v);
      i.name_null = is_null;
      i.name_size = size;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // constraint
    //
    {
      ::butl::optional< ::bpkg::version_constraint > const& v =
        o.constraint;

      if (wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::get_null (v))
        composite_value_traits< ::bpkg::version_constraint, id_pgsql >::set_null (
          i.constraint_value, sk);
      else
      {
        const::bpkg::version_constraint& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::get_ref (v);

        if (composite_value_traits< ::bpkg::version_constraint, id_pgsql >::init (
              i.constraint_value,
              vw,
              sk))
          grew = true;
      }
    }

    // package
    //
    {
      ::odb::lazy_shared_ptr< ::brep::package > const& v =
        o.package;

      typedef object_traits< ::brep::package > obj_traits;
      typedef odb::pointer_traits< ::odb::lazy_shared_ptr< ::brep::package > > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.package_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        composite_value_traits< obj_traits::id_type, id_pgsql >::set_null (i.package_value, sk);
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::dependency, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::bpkg::package_name& v =
        o.name;

      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // constraint
    //
    {
      ::butl::optional< ::bpkg::version_constraint >& v =
        o.constraint;

      if (composite_value_traits< ::bpkg::version_constraint, id_pgsql >::get_null (
            i.constraint_value))
        wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_null (v);
      else
      {
        ::bpkg::version_constraint& vw =
          wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_ref (v);

        composite_value_traits< ::bpkg::version_constraint, id_pgsql >::init (
          vw,
          i.constraint_value,
          db);
      }
    }

    // package
    //
    {
      ::odb::lazy_shared_ptr< ::brep::package >& v =
        o.package;

      typedef object_traits< ::brep::package > obj_traits;
      typedef odb::pointer_traits< ::odb::lazy_shared_ptr< ::brep::package > > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.package_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.package_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }
  }

  // dependency_alternative
  //

  bool access::composite_value_traits< ::brep::dependency_alternative, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // enable
    //
    if (t[0UL])
    {
      i.enable_value.capacity (i.enable_size);
      grew = true;
    }

    // reflect
    //
    if (t[1UL])
    {
      i.reflect_value.capacity (i.reflect_size);
      grew = true;
    }

    // prefer
    //
    if (t[2UL])
    {
      i.prefer_value.capacity (i.prefer_size);
      grew = true;
    }

    // accept
    //
    if (t[3UL])
    {
      i.accept_value.capacity (i.accept_size);
      grew = true;
    }

    // require
    //
    if (t[4UL])
    {
      i.require_value.capacity (i.require_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::dependency_alternative, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // enable
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.enable_value.data_ptr ();
    b[n].capacity = i.enable_value.capacity ();
    b[n].size = &i.enable_size;
    b[n].is_null = &i.enable_null;
    n++;

    // reflect
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.reflect_value.data_ptr ();
    b[n].capacity = i.reflect_value.capacity ();
    b[n].size = &i.reflect_size;
    b[n].is_null = &i.reflect_null;
    n++;

    // prefer
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.prefer_value.data_ptr ();
    b[n].capacity = i.prefer_value.capacity ();
    b[n].size = &i.prefer_size;
    b[n].is_null = &i.prefer_null;
    n++;

    // accept
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.accept_value.data_ptr ();
    b[n].capacity = i.accept_value.capacity ();
    b[n].size = &i.accept_size;
    b[n].is_null = &i.accept_null;
    n++;

    // require
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.require_value.data_ptr ();
    b[n].capacity = i.require_value.capacity ();
    b[n].size = &i.require_size;
    b[n].is_null = &i.require_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::dependency_alternative, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.enable;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.enable_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.enable_value,
        size,
        is_null,
        v);
      i.enable_null = is_null;
      i.enable_size = size;
      grew = grew || (cap != i.enable_value.capacity ());
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.reflect;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.reflect_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.reflect_value,
        size,
        is_null,
        v);
      i.reflect_null = is_null;
      i.reflect_size = size;
      grew = grew || (cap != i.reflect_value.capacity ());
    }

    // prefer
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.prefer;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.prefer_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.prefer_value,
        size,
        is_null,
        v);
      i.prefer_null = is_null;
      i.prefer_size = size;
      grew = grew || (cap != i.prefer_value.capacity ());
    }

    // accept
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.accept;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.accept_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.accept_value,
        size,
        is_null,
        v);
      i.accept_null = is_null;
      i.accept_size = size;
      grew = grew || (cap != i.accept_value.capacity ());
    }

    // require
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.require;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.require_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.require_value,
        size,
        is_null,
        v);
      i.require_null = is_null;
      i.require_size = size;
      grew = grew || (cap != i.require_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::dependency_alternative, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.enable;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.enable_value,
        i.enable_size,
        i.enable_null);
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.reflect;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.reflect_value,
        i.reflect_size,
        i.reflect_null);
    }

    // prefer
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.prefer;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.prefer_value,
        i.prefer_size,
        i.prefer_null);
    }

    // accept
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.accept;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.accept_value,
        i.accept_size,
        i.accept_null);
    }

    // require
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.require;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.require_value,
        i.require_size,
        i.require_null);
    }
  }

  // dependency_alternatives
  //

  bool access::composite_value_traits< ::brep::dependency_alternatives, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // buildtime
    //
    t[0UL] = 0;

    // comment
    //
    if (t[1UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::dependency_alternatives, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // buildtime
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.buildtime_value;
    b[n].is_null = &i.buildtime_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::dependency_alternatives, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // buildtime
    //
    {
      bool const& v =
        o.buildtime;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.buildtime_value, is_null, v);
      i.buildtime_null = is_null;
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::dependency_alternatives, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // buildtime
    //
    {
      bool& v =
        o.buildtime;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.buildtime_value,
        i.buildtime_null);
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // test_dependency
  //

  bool access::composite_value_traits< ::brep::test_dependency, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // dependency base
    //
    if (composite_value_traits< ::brep::dependency, id_pgsql >::grow (
          i, t + 0UL))
      grew = true;

    // type
    //
    if (t[21UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    // buildtime
    //
    t[22UL] = 0;

    // enable
    //
    if (t[23UL])
    {
      i.enable_value.capacity (i.enable_size);
      grew = true;
    }

    // reflect
    //
    if (t[24UL])
    {
      i.reflect_value.capacity (i.reflect_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::test_dependency, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // dependency base
    //
    composite_value_traits< ::brep::dependency, id_pgsql >::bind (b + n, i, sk);
    n += 21UL;

    // type
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.type_value.data_ptr ();
    b[n].capacity = i.type_value.capacity ();
    b[n].size = &i.type_size;
    b[n].is_null = &i.type_null;
    n++;

    // buildtime
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.buildtime_value;
    b[n].is_null = &i.buildtime_null;
    n++;

    // enable
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.enable_value.data_ptr ();
    b[n].capacity = i.enable_value.capacity ();
    b[n].size = &i.enable_size;
    b[n].is_null = &i.enable_null;
    n++;

    // reflect
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.reflect_value.data_ptr ();
    b[n].capacity = i.reflect_value.capacity ();
    b[n].size = &i.reflect_size;
    b[n].is_null = &i.reflect_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::test_dependency, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // dependency base
    //
    if (composite_value_traits< ::brep::dependency, id_pgsql >::init (i, o, sk))
      grew = true;

    // type
    //
    {
      ::bpkg::test_dependency_type const& v =
        o.type;

      // From common.hxx:505:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.type_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.type_value,
        size,
        is_null,
        vt);
      i.type_null = is_null;
      i.type_size = size;
      grew = grew || (cap != i.type_value.capacity ());
    }

    // buildtime
    //
    {
      bool const& v =
        o.buildtime;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.buildtime_value, is_null, v);
      i.buildtime_null = is_null;
    }

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.enable;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.enable_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.enable_value,
        size,
        is_null,
        v);
      i.enable_null = is_null;
      i.enable_size = size;
      grew = grew || (cap != i.enable_value.capacity ());
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.reflect;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.reflect_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.reflect_value,
        size,
        is_null,
        v);
      i.reflect_null = is_null;
      i.reflect_size = size;
      grew = grew || (cap != i.reflect_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::test_dependency, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // dependency base
    //
    composite_value_traits< ::brep::dependency, id_pgsql >::init (o, i, db);

    // type
    //
    {
      ::bpkg::test_dependency_type& v =
        o.type;

      ::std::string vt;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        vt,
        i.type_value,
        i.type_size,
        i.type_null);

      // From common.hxx:505:14
      v = brep::to_test_dependency_type (vt);
    }

    // buildtime
    //
    {
      bool& v =
        o.buildtime;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.buildtime_value,
        i.buildtime_null);
    }

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.enable;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.enable_value,
        i.enable_size,
        i.enable_null);
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.reflect;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.reflect_value,
        i.reflect_size,
        i.reflect_null);
    }
  }

  // certificate
  //

  bool access::composite_value_traits< ::brep::certificate, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // fingerprint
    //
    if (t[0UL])
    {
      i.fingerprint_value.capacity (i.fingerprint_size);
      grew = true;
    }

    // name
    //
    if (t[1UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // organization
    //
    if (t[2UL])
    {
      i.organization_value.capacity (i.organization_size);
      grew = true;
    }

    // email
    //
    if (t[3UL])
    {
      i.email_value.capacity (i.email_size);
      grew = true;
    }

    // pem
    //
    if (t[4UL])
    {
      i.pem_value.capacity (i.pem_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::certificate, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // fingerprint
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.fingerprint_value.data_ptr ();
    b[n].capacity = i.fingerprint_value.capacity ();
    b[n].size = &i.fingerprint_size;
    b[n].is_null = &i.fingerprint_null;
    n++;

    // name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.name_value.data_ptr ();
    b[n].capacity = i.name_value.capacity ();
    b[n].size = &i.name_size;
    b[n].is_null = &i.name_null;
    n++;

    // organization
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.organization_value.data_ptr ();
    b[n].capacity = i.organization_value.capacity ();
    b[n].size = &i.organization_size;
    b[n].is_null = &i.organization_null;
    n++;

    // email
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.email_value.data_ptr ();
    b[n].capacity = i.email_value.capacity ();
    b[n].size = &i.email_size;
    b[n].is_null = &i.email_null;
    n++;

    // pem
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.pem_value.data_ptr ();
    b[n].capacity = i.pem_value.capacity ();
    b[n].size = &i.pem_size;
    b[n].is_null = &i.pem_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::certificate, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // fingerprint
    //
    {
      ::std::string const& v =
        o.fingerprint;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.fingerprint_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.fingerprint_value,
        size,
        is_null,
        v);
      i.fingerprint_null = is_null;
      i.fingerprint_size = size;
      grew = grew || (cap != i.fingerprint_value.capacity ());
    }

    // name
    //
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.name_value,
        size,
        is_null,
        v);
      i.name_null = is_null;
      i.name_size = size;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // organization
    //
    {
      ::std::string const& v =
        o.organization;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.organization_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.organization_value,
        size,
        is_null,
        v);
      i.organization_null = is_null;
      i.organization_size = size;
      grew = grew || (cap != i.organization_value.capacity ());
    }

    // email
    //
    {
      ::std::string const& v =
        o.email;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.email_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.email_value,
        size,
        is_null,
        v);
      i.email_null = is_null;
      i.email_size = size;
      grew = grew || (cap != i.email_value.capacity ());
    }

    // pem
    //
    {
      ::std::string const& v =
        o.pem;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.pem_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.pem_value,
        size,
        is_null,
        v);
      i.pem_null = is_null;
      i.pem_size = size;
      grew = grew || (cap != i.pem_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::certificate, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // fingerprint
    //
    {
      ::std::string& v =
        o.fingerprint;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.fingerprint_value,
        i.fingerprint_size,
        i.fingerprint_null);
    }

    // name
    //
    {
      ::std::string& v =
        o.name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // organization
    //
    {
      ::std::string& v =
        o.organization;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.organization_value,
        i.organization_size,
        i.organization_null);
    }

    // email
    //
    {
      ::std::string& v =
        o.email;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.email_value,
        i.email_size,
        i.email_null);
    }

    // pem
    //
    {
      ::std::string& v =
        o.pem;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.pem_value,
        i.pem_size,
        i.pem_null);
    }
  }

  // tenant
  //

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::
  persist_statement_name[] = "persist_brep_tenant";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::
  find_statement_name[] = "find_brep_tenant";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::
  update_statement_name[] = "update_brep_tenant";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::
  erase_statement_name[] = "erase_brep_tenant";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::
  query_statement_name[] = "query_brep_tenant";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_tenant";

  const unsigned int access::object_traits_impl< ::brep::tenant, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::tenant, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::tenant, id_pgsql >::
  update_statement_types[] =
  {
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  struct access::object_traits_impl< ::brep::tenant, id_pgsql >::extra_statement_cache_type
  {
    extra_statement_cache_type (
      pgsql::connection&,
      image_type&,
      id_image_type&,
      pgsql::binding&,
      pgsql::binding&,
      pgsql::native_binding&,
      const unsigned int*)
    {
    }
  };

  access::object_traits_impl< ::brep::tenant, id_pgsql >::id_type
  access::object_traits_impl< ::brep::tenant, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        id,
        i.id_value,
        i.id_size,
        i.id_null);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::tenant, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (t[0UL])
    {
      i.id_value.capacity (i.id_size);
      grew = true;
    }

    // private_
    //
    t[1UL] = 0;

    // interactive
    //
    if (t[2UL])
    {
      i.interactive_value.capacity (i.interactive_size);
      grew = true;
    }

    // creation_timestamp
    //
    t[3UL] = 0;

    // archived
    //
    t[4UL] = 0;

    // service
    //
    if (composite_value_traits< ::brep::tenant_service, id_pgsql >::grow (
          i.service_value, t + 5UL))
      grew = true;

    // unloaded_timestamp
    //
    t[9UL] = 0;

    // unloaded_notify_interval
    //
    t[10UL] = 0;

    // queued_timestamp
    //
    t[11UL] = 0;

    // build_toolchain
    //
    if (composite_value_traits< ::brep::build_toolchain, id_pgsql >::grow (
          i.build_toolchain_value, t + 12UL))
      grew = true;

    return grew;
  }

  void access::object_traits_impl< ::brep::tenant, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      b[n].type = pgsql::bind::text;
      b[n].buffer = i.id_value.data_ptr ();
      b[n].capacity = i.id_value.capacity ();
      b[n].size = &i.id_size;
      b[n].is_null = &i.id_null;
      n++;
    }

    // private_
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.private_value;
    b[n].is_null = &i.private_null;
    n++;

    // interactive
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.interactive_value.data_ptr ();
    b[n].capacity = i.interactive_value.capacity ();
    b[n].size = &i.interactive_size;
    b[n].is_null = &i.interactive_null;
    n++;

    // creation_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.creation_timestamp_value;
    b[n].is_null = &i.creation_timestamp_null;
    n++;

    // archived
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.archived_value;
    b[n].is_null = &i.archived_null;
    n++;

    // service
    //
    composite_value_traits< ::brep::tenant_service, id_pgsql >::bind (
      b + n, i.service_value, sk);
    n += 4UL;

    // unloaded_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.unloaded_timestamp_value;
    b[n].is_null = &i.unloaded_timestamp_null;
    n++;

    // unloaded_notify_interval
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.unloaded_notify_interval_value;
    b[n].is_null = &i.unloaded_notify_interval_null;
    n++;

    // queued_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.queued_timestamp_value;
    b[n].is_null = &i.queued_timestamp_null;
    n++;

    // build_toolchain
    //
    composite_value_traits< ::brep::build_toolchain, id_pgsql >::bind (
      b + n, i.build_toolchain_value, sk);
    n += 7UL;
  }

  void access::object_traits_impl< ::brep::tenant, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.id_value.data_ptr ();
    b[n].capacity = i.id_value.capacity ();
    b[n].size = &i.id_size;
    b[n].is_null = &i.id_null;
  }

  bool access::object_traits_impl< ::brep::tenant, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::std::string const& v =
        o.id;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.id_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.id_value,
        size,
        is_null,
        v);
      i.id_null = is_null;
      i.id_size = size;
      grew = grew || (cap != i.id_value.capacity ());
    }

    // private_
    //
    {
      bool const& v =
        o.private_;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.private_value, is_null, v);
      i.private_null = is_null;
    }

    // interactive
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.interactive;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.interactive_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.interactive_value,
        size,
        is_null,
        v);
      i.interactive_null = is_null;
      i.interactive_size = size;
      grew = grew || (cap != i.interactive_value.capacity ());
    }

    // creation_timestamp
    //
    {
      ::butl::timestamp const& v =
        o.creation_timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.creation_timestamp_value, is_null, vt);
      i.creation_timestamp_null = is_null;
    }

    // archived
    //
    {
      bool const& v =
        o.archived;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.archived_value, is_null, v);
      i.archived_null = is_null;
    }

    // service
    //
    {
      ::butl::optional< ::brep::tenant_service > const& v =
        o.service;

      if (wrapper_traits< ::butl::optional< ::brep::tenant_service > >::get_null (v))
        composite_value_traits< ::brep::tenant_service, id_pgsql >::set_null (
          i.service_value, sk);
      else
      {
        const::brep::tenant_service& vw = 
          wrapper_traits< ::butl::optional< ::brep::tenant_service > >::get_ref (v);

        if (composite_value_traits< ::brep::tenant_service, id_pgsql >::init (
              i.service_value,
              vw,
              sk))
          grew = true;
      }
    }

    // unloaded_timestamp
    //
    {
      ::butl::optional< ::std::chrono::time_point< ::std::chrono::system_clock, ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > > const& v =
        o.unloaded_timestamp;

      // From common.hxx:133:14
      ::brep::optional_uint64 const& vt =
        (v) ? std::chrono::duration_cast < std::chrono::nanoseconds > ((v)->time_since_epoch ()).count () : brep::optional_uint64 ();

      bool is_null (true);
      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_image (
        i.unloaded_timestamp_value, is_null, vt);
      i.unloaded_timestamp_null = is_null;
    }

    // unloaded_notify_interval
    //
    {
      ::butl::optional< ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > const& v =
        o.unloaded_notify_interval;

      // From common.hxx:150:14
      ::brep::optional_uint64 const& vt =
        (v) ? std::chrono::duration_cast < std::chrono::nanoseconds > ( * (v)).count () : brep::optional_uint64 ();

      bool is_null (true);
      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_image (
        i.unloaded_notify_interval_value, is_null, vt);
      i.unloaded_notify_interval_null = is_null;
    }

    // queued_timestamp
    //
    {
      ::butl::optional< ::std::chrono::time_point< ::std::chrono::system_clock, ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > > const& v =
        o.queued_timestamp;

      // From common.hxx:133:14
      ::brep::optional_uint64 const& vt =
        (v) ? std::chrono::duration_cast < std::chrono::nanoseconds > ((v)->time_since_epoch ()).count () : brep::optional_uint64 ();

      bool is_null (true);
      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_image (
        i.queued_timestamp_value, is_null, vt);
      i.queued_timestamp_null = is_null;
    }

    // build_toolchain
    //
    {
      ::butl::optional< ::brep::build_toolchain > const& v =
        o.build_toolchain;

      if (wrapper_traits< ::butl::optional< ::brep::build_toolchain > >::get_null (v))
        composite_value_traits< ::brep::build_toolchain, id_pgsql >::set_null (
          i.build_toolchain_value, sk);
      else
      {
        const::brep::build_toolchain& vw = 
          wrapper_traits< ::butl::optional< ::brep::build_toolchain > >::get_ref (v);

        if (composite_value_traits< ::brep::build_toolchain, id_pgsql >::init (
              i.build_toolchain_value,
              vw,
              sk))
          grew = true;
      }
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::tenant, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::std::string& v =
        o.id;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.id_value,
        i.id_size,
        i.id_null);
    }

    // private_
    //
    {
      bool& v =
        o.private_;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.private_value,
        i.private_null);
    }

    // interactive
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.interactive;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.interactive_value,
        i.interactive_size,
        i.interactive_null);
    }

    // creation_timestamp
    //
    {
      ::butl::timestamp& v =
        o.creation_timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.creation_timestamp_value,
        i.creation_timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // archived
    //
    {
      bool& v =
        o.archived;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.archived_value,
        i.archived_null);
    }

    // service
    //
    {
      ::butl::optional< ::brep::tenant_service >& v =
        o.service;

      if (composite_value_traits< ::brep::tenant_service, id_pgsql >::get_null (
            i.service_value))
        wrapper_traits< ::butl::optional< ::brep::tenant_service > >::set_null (v);
      else
      {
        ::brep::tenant_service& vw =
          wrapper_traits< ::butl::optional< ::brep::tenant_service > >::set_ref (v);

        composite_value_traits< ::brep::tenant_service, id_pgsql >::init (
          vw,
          i.service_value,
          db);
      }
    }

    // unloaded_timestamp
    //
    {
      ::butl::optional< ::std::chrono::time_point< ::std::chrono::system_clock, ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > >& v =
        o.unloaded_timestamp;

      ::brep::optional_uint64 vt;

      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_value (
        vt,
        i.unloaded_timestamp_value,
        i.unloaded_timestamp_null);

      // From common.hxx:133:14
      v = (vt) ? brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds ( * (vt)))) : brep::optional_timestamp ();
    }

    // unloaded_notify_interval
    //
    {
      ::butl::optional< ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > >& v =
        o.unloaded_notify_interval;

      ::brep::optional_uint64 vt;

      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_value (
        vt,
        i.unloaded_notify_interval_value,
        i.unloaded_notify_interval_null);

      // From common.hxx:150:14
      v = (vt) ? brep::duration (std::chrono::nanoseconds ( * (vt))) : brep::optional_duration ();
    }

    // queued_timestamp
    //
    {
      ::butl::optional< ::std::chrono::time_point< ::std::chrono::system_clock, ::std::chrono::duration< long int, ::std::ratio< 1, 1000000000 > > > >& v =
        o.queued_timestamp;

      ::brep::optional_uint64 vt;

      pgsql::value_traits<
          ::brep::optional_uint64,
          pgsql::id_bigint >::set_value (
        vt,
        i.queued_timestamp_value,
        i.queued_timestamp_null);

      // From common.hxx:133:14
      v = (vt) ? brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds ( * (vt)))) : brep::optional_timestamp ();
    }

    // build_toolchain
    //
    {
      ::butl::optional< ::brep::build_toolchain >& v =
        o.build_toolchain;

      if (composite_value_traits< ::brep::build_toolchain, id_pgsql >::get_null (
            i.build_toolchain_value))
        wrapper_traits< ::butl::optional< ::brep::build_toolchain > >::set_null (v);
      else
      {
        ::brep::build_toolchain& vw =
          wrapper_traits< ::butl::optional< ::brep::build_toolchain > >::set_ref (v);

        composite_value_traits< ::brep::build_toolchain, id_pgsql >::init (
          vw,
          i.build_toolchain_value,
          db);
      }
    }
  }

  void access::object_traits_impl< ::brep::tenant, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    {
      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.id_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.id_value,
        size,
        is_null,
        id);
      i.id_null = is_null;
      i.id_size = size;
      grew = grew || (cap != i.id_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::persist_statement[] =
  "INSERT INTO \"tenant\" "
  "(\"id\", "
  "\"private\", "
  "\"interactive\", "
  "\"creation_timestamp\", "
  "\"archived\", "
  "\"service_id\", "
  "\"service_type\", "
  "\"service_ref_count\", "
  "\"service_data\", "
  "\"unloaded_timestamp\", "
  "\"unloaded_notify_interval\", "
  "\"queued_timestamp\", "
  "\"build_toolchain_name\", "
  "\"build_toolchain_version_epoch\", "
  "\"build_toolchain_version_canonical_upstream\", "
  "\"build_toolchain_version_canonical_release\", "
  "\"build_toolchain_version_revision\", "
  "\"build_toolchain_version_upstream\", "
  "\"build_toolchain_version_release\") "
  "VALUES "
  "($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19)";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::find_statement[] =
  "SELECT "
  "\"tenant\".\"id\", "
  "\"tenant\".\"private\", "
  "\"tenant\".\"interactive\", "
  "\"tenant\".\"creation_timestamp\", "
  "\"tenant\".\"archived\", "
  "\"tenant\".\"service_id\", "
  "\"tenant\".\"service_type\", "
  "\"tenant\".\"service_ref_count\", "
  "\"tenant\".\"service_data\", "
  "\"tenant\".\"unloaded_timestamp\", "
  "\"tenant\".\"unloaded_notify_interval\", "
  "\"tenant\".\"queued_timestamp\", "
  "\"tenant\".\"build_toolchain_name\", "
  "\"tenant\".\"build_toolchain_version_epoch\", "
  "\"tenant\".\"build_toolchain_version_canonical_upstream\", "
  "\"tenant\".\"build_toolchain_version_canonical_release\", "
  "\"tenant\".\"build_toolchain_version_revision\", "
  "\"tenant\".\"build_toolchain_version_upstream\", "
  "\"tenant\".\"build_toolchain_version_release\" "
  "FROM \"tenant\" "
  "WHERE \"tenant\".\"id\"=$1";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::update_statement[] =
  "UPDATE \"tenant\" "
  "SET "
  "\"private\"=$1, "
  "\"interactive\"=$2, "
  "\"creation_timestamp\"=$3, "
  "\"archived\"=$4, "
  "\"service_id\"=$5, "
  "\"service_type\"=$6, "
  "\"service_ref_count\"=$7, "
  "\"service_data\"=$8, "
  "\"unloaded_timestamp\"=$9, "
  "\"unloaded_notify_interval\"=$10, "
  "\"queued_timestamp\"=$11, "
  "\"build_toolchain_name\"=$12, "
  "\"build_toolchain_version_epoch\"=$13, "
  "\"build_toolchain_version_canonical_upstream\"=$14, "
  "\"build_toolchain_version_canonical_release\"=$15, "
  "\"build_toolchain_version_revision\"=$16, "
  "\"build_toolchain_version_upstream\"=$17, "
  "\"build_toolchain_version_release\"=$18 "
  "WHERE \"id\"=$19";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::erase_statement[] =
  "DELETE FROM \"tenant\" "
  "WHERE \"id\"=$1";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::query_statement[] =
  "SELECT "
  "\"tenant\".\"id\", "
  "\"tenant\".\"private\", "
  "\"tenant\".\"interactive\", "
  "\"tenant\".\"creation_timestamp\", "
  "\"tenant\".\"archived\", "
  "\"tenant\".\"service_id\", "
  "\"tenant\".\"service_type\", "
  "\"tenant\".\"service_ref_count\", "
  "\"tenant\".\"service_data\", "
  "\"tenant\".\"unloaded_timestamp\", "
  "\"tenant\".\"unloaded_notify_interval\", "
  "\"tenant\".\"queued_timestamp\", "
  "\"tenant\".\"build_toolchain_name\", "
  "\"tenant\".\"build_toolchain_version_epoch\", "
  "\"tenant\".\"build_toolchain_version_canonical_upstream\", "
  "\"tenant\".\"build_toolchain_version_canonical_release\", "
  "\"tenant\".\"build_toolchain_version_revision\", "
  "\"tenant\".\"build_toolchain_version_upstream\", "
  "\"tenant\".\"build_toolchain_version_release\" "
  "FROM \"tenant\"";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"tenant\"";

  const char access::object_traits_impl< ::brep::tenant, id_pgsql >::table_name[] =
  "\"tenant\"";

  void access::object_traits_impl< ::brep::tenant, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::tenant, id_pgsql >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace pgsql;
    using pgsql::update_statement;

    callback (db, obj, callback_event::pre_update);

    pgsql::transaction& tr (pgsql::transaction::current ());
    pgsql::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::brep::tenant, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::tenant, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::tenant, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::tenant, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::tenant, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::tenant, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  result< access::object_traits_impl< ::brep::tenant, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::tenant, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        false,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::tenant, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::tenant, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::tenant, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // tenant_id
  //

  const char access::view_traits_impl< ::brep::tenant_id, id_pgsql >::
  query_statement_name[] = "query_brep_tenant_id";

  bool access::view_traits_impl< ::brep::tenant_id, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // value
    //
    if (t[0UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    return grew;
  }

  void access::view_traits_impl< ::brep::tenant_id, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // value
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.value_value.data_ptr ();
    b[n].capacity = i.value_value.capacity ();
    b[n].size = &i.value_size;
    b[n].is_null = &i.value_null;
    n++;
  }

  void access::view_traits_impl< ::brep::tenant_id, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // value
    //
    {
      ::std::string& v =
        o.value;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.value_value,
        i.value_size,
        i.value_null);
    }
  }

  access::view_traits_impl< ::brep::tenant_id, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::tenant_id, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"id\" ");

    r += "FROM \"tenant\"";

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::tenant_id, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::tenant_id, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::tenant_id, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::tenant_id, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // repository
  //

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::
  persist_statement_name[] = "persist_brep_repository";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::
  find_statement_name[] = "find_brep_repository";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::
  update_statement_name[] = "update_brep_repository";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::
  erase_statement_name[] = "erase_brep_repository";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::
  query_statement_name[] = "query_brep_repository";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_repository";

  const unsigned int access::object_traits_impl< ::brep::repository, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::bool_oid
  };

  const unsigned int access::object_traits_impl< ::brep::repository, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::repository, id_pgsql >::
  update_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  struct access::object_traits_impl< ::brep::repository, id_pgsql >::extra_statement_cache_type
  {
    pgsql::container_statements_impl< complements_traits > complements;
    pgsql::container_statements_impl< prerequisites_traits > prerequisites;

    extra_statement_cache_type (
      pgsql::connection& c,
      image_type&,
      id_image_type&,
      pgsql::binding& id,
      pgsql::binding&,
      pgsql::native_binding& idn,
      const unsigned int* idt)
    : complements (c, id, idn, idt),
      prerequisites (c, id, idn, idt)
    {
    }
  };

  // complements
  //

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  select_name[] = "select_brep_repository_complements";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  insert_name[] = "insert_brep_repository_complements";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  delete_name[] = "delete_brep_repository_complements";

  const unsigned int access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  select_statement[] =
  "SELECT "
  "\"repository_complements\".\"index\", "
  "\"repository_complements\".\"complement_tenant\", "
  "\"repository_complements\".\"complement_canonical_name\" "
  "FROM \"repository_complements\" "
  "WHERE \"repository_complements\".\"repository_tenant\"=$1 AND \"repository_complements\".\"repository_canonical_name\"=$2 ORDER BY \"repository_complements\".\"index\"";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  insert_statement[] =
  "INSERT INTO \"repository_complements\" "
  "(\"repository_tenant\", "
  "\"repository_canonical_name\", "
  "\"index\", "
  "\"complement_tenant\", "
  "\"complement_canonical_name\") "
  "VALUES "
  "($1, $2, $3, $4, $5)";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  delete_statement[] =
  "DELETE FROM \"repository_complements\" "
  "WHERE \"repository_tenant\"=$1 AND \"repository_canonical_name\"=$2";

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< ::brep::repository_id, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< ::brep::repository_id, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      typedef object_traits< ::brep::repository > obj_traits;
      typedef odb::pointer_traits< value_type > wptr_traits;
      typedef odb::pointer_traits< wptr_traits::strong_pointer_type > ptr_traits;

      wptr_traits::strong_pointer_type sp (wptr_traits::lock (v));
      bool is_null (ptr_traits::null_ptr (sp));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (sp));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.value_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        throw null_pointer ();
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      typedef object_traits< ::brep::repository > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.value_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.value_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::complements_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // prerequisites
  //

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  select_name[] = "select_brep_repository_prerequisites";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  insert_name[] = "insert_brep_repository_prerequisites";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  delete_name[] = "delete_brep_repository_prerequisites";

  const unsigned int access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  select_statement[] =
  "SELECT "
  "\"repository_prerequisites\".\"index\", "
  "\"repository_prerequisites\".\"prerequisite_tenant\", "
  "\"repository_prerequisites\".\"prerequisite_canonical_name\" "
  "FROM \"repository_prerequisites\" "
  "WHERE \"repository_prerequisites\".\"repository_tenant\"=$1 AND \"repository_prerequisites\".\"repository_canonical_name\"=$2 ORDER BY \"repository_prerequisites\".\"index\"";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  insert_statement[] =
  "INSERT INTO \"repository_prerequisites\" "
  "(\"repository_tenant\", "
  "\"repository_canonical_name\", "
  "\"index\", "
  "\"prerequisite_tenant\", "
  "\"prerequisite_canonical_name\") "
  "VALUES "
  "($1, $2, $3, $4, $5)";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  delete_statement[] =
  "DELETE FROM \"repository_prerequisites\" "
  "WHERE \"repository_tenant\"=$1 AND \"repository_canonical_name\"=$2";

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< ::brep::repository_id, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< ::brep::repository_id, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      typedef object_traits< ::brep::repository > obj_traits;
      typedef odb::pointer_traits< value_type > wptr_traits;
      typedef odb::pointer_traits< wptr_traits::strong_pointer_type > ptr_traits;

      wptr_traits::strong_pointer_type sp (wptr_traits::lock (v));
      bool is_null (ptr_traits::null_ptr (sp));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (sp));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.value_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        throw null_pointer ();
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      typedef object_traits< ::brep::repository > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.value_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.value_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::prerequisites_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  access::object_traits_impl< ::brep::repository, id_pgsql >::id_type
  access::object_traits_impl< ::brep::repository, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      composite_value_traits< ::brep::repository_id, id_pgsql >::init (
        id,
        i.id_value,
        db);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::repository, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::repository_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // location
    //
    if (composite_value_traits< ::brep::_repository_location, id_pgsql >::grow (
          i.location_value, t + 2UL))
      grew = true;

    // display_name
    //
    if (t[4UL])
    {
      i.display_name_value.capacity (i.display_name_size);
      grew = true;
    }

    // priority
    //
    t[5UL] = 0;

    // interface_url
    //
    if (t[6UL])
    {
      i.interface_url_value.capacity (i.interface_url_size);
      grew = true;
    }

    // email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.email_value, t + 7UL))
      grew = true;

    // summary
    //
    if (t[9UL])
    {
      i.summary_value.capacity (i.summary_size);
      grew = true;
    }

    // description
    //
    if (t[10UL])
    {
      i.description_value.capacity (i.description_size);
      grew = true;
    }

    // cache_location
    //
    if (composite_value_traits< ::brep::_repository_location, id_pgsql >::grow (
          i.cache_location_value, t + 11UL))
      grew = true;

    // certificate
    //
    if (composite_value_traits< ::brep::certificate, id_pgsql >::grow (
          i.certificate_value, t + 13UL))
      grew = true;

    // packages_timestamp
    //
    t[18UL] = 0;

    // repositories_timestamp
    //
    t[19UL] = 0;

    // internal
    //
    t[20UL] = 0;

    // buildable
    //
    t[21UL] = 0;

    return grew;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      composite_value_traits< ::brep::repository_id, id_pgsql >::bind (
        b + n, i.id_value, sk);
      n += 2UL;
    }

    // location
    //
    composite_value_traits< ::brep::_repository_location, id_pgsql >::bind (
      b + n, i.location_value, sk);
    n += 2UL;

    // display_name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.display_name_value.data_ptr ();
    b[n].capacity = i.display_name_value.capacity ();
    b[n].size = &i.display_name_size;
    b[n].is_null = &i.display_name_null;
    n++;

    // priority
    //
    b[n].type = pgsql::bind::integer;
    b[n].buffer = &i.priority_value;
    b[n].is_null = &i.priority_null;
    n++;

    // interface_url
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.interface_url_value.data_ptr ();
    b[n].capacity = i.interface_url_value.capacity ();
    b[n].size = &i.interface_url_size;
    b[n].is_null = &i.interface_url_null;
    n++;

    // email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.email_value, sk);
    n += 2UL;

    // summary
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.summary_value.data_ptr ();
    b[n].capacity = i.summary_value.capacity ();
    b[n].size = &i.summary_size;
    b[n].is_null = &i.summary_null;
    n++;

    // description
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.description_value.data_ptr ();
    b[n].capacity = i.description_value.capacity ();
    b[n].size = &i.description_size;
    b[n].is_null = &i.description_null;
    n++;

    // cache_location
    //
    composite_value_traits< ::brep::_repository_location, id_pgsql >::bind (
      b + n, i.cache_location_value, sk);
    n += 2UL;

    // certificate
    //
    composite_value_traits< ::brep::certificate, id_pgsql >::bind (
      b + n, i.certificate_value, sk);
    n += 5UL;

    // packages_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.packages_timestamp_value;
    b[n].is_null = &i.packages_timestamp_null;
    n++;

    // repositories_timestamp
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.repositories_timestamp_value;
    b[n].is_null = &i.repositories_timestamp_null;
    n++;

    // internal
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.internal_value;
    b[n].is_null = &i.internal_null;
    n++;

    // buildable
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.buildable_value;
    b[n].is_null = &i.buildable_null;
    n++;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    pgsql::statement_kind sk (pgsql::statement_select);
    composite_value_traits< ::brep::repository_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
  }

  bool access::object_traits_impl< ::brep::repository, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::brep::repository_id const& v =
        o.id;

      if (composite_value_traits< ::brep::repository_id, id_pgsql >::init (
            i.id_value,
            v,
            sk))
        grew = true;
    }

    // location
    //
    {
      ::bpkg::repository_location const& v =
        o.location;

      // From common.hxx:323:14
      ::brep::_repository_location const& vt =
        brep::_repository_location 
      {
         (v).url (), (v).empty () ? brep::repository_type::pkg : (v).type () 
      };


      if (composite_value_traits< ::brep::_repository_location, id_pgsql >::init (
            i.location_value,
            vt,
            sk))
        grew = true;
    }

    // display_name
    //
    {
      ::std::string const& v =
        o.display_name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.display_name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.display_name_value,
        size,
        is_null,
        v);
      i.display_name_null = is_null;
      i.display_name_size = size;
      grew = grew || (cap != i.display_name_value.capacity ());
    }

    // priority
    //
    {
      ::uint16_t const& v =
        o.priority;

      bool is_null (false);
      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_image (
        i.priority_value, is_null, v);
      i.priority_null = is_null;
    }

    // interface_url
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.interface_url;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.interface_url_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.interface_url_value,
        size,
        is_null,
        v);
      i.interface_url_null = is_null;
      i.interface_url_size = size;
      grew = grew || (cap != i.interface_url_value.capacity ());
    }

    // email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // summary
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.summary;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.summary_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.summary_value,
        size,
        is_null,
        v);
      i.summary_null = is_null;
      i.summary_size = size;
      grew = grew || (cap != i.summary_value.capacity ());
    }

    // description
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.description;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.description_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.description_value,
        size,
        is_null,
        v);
      i.description_null = is_null;
      i.description_size = size;
      grew = grew || (cap != i.description_value.capacity ());
    }

    // cache_location
    //
    {
      ::bpkg::repository_location const& v =
        o.cache_location;

      // From common.hxx:323:14
      ::brep::_repository_location const& vt =
        brep::_repository_location 
      {
         (v).url (), (v).empty () ? brep::repository_type::pkg : (v).type () 
      };


      if (composite_value_traits< ::brep::_repository_location, id_pgsql >::init (
            i.cache_location_value,
            vt,
            sk))
        grew = true;
    }

    // certificate
    //
    {
      ::butl::optional< ::brep::certificate > const& v =
        o.certificate;

      if (wrapper_traits< ::butl::optional< ::brep::certificate > >::get_null (v))
        composite_value_traits< ::brep::certificate, id_pgsql >::set_null (
          i.certificate_value, sk);
      else
      {
        const::brep::certificate& vw = 
          wrapper_traits< ::butl::optional< ::brep::certificate > >::get_ref (v);

        if (composite_value_traits< ::brep::certificate, id_pgsql >::init (
              i.certificate_value,
              vw,
              sk))
          grew = true;
      }
    }

    // packages_timestamp
    //
    {
      ::butl::timestamp const& v =
        o.packages_timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.packages_timestamp_value, is_null, vt);
      i.packages_timestamp_null = is_null;
    }

    // repositories_timestamp
    //
    {
      ::butl::timestamp const& v =
        o.repositories_timestamp;

      // From common.hxx:123:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_image (
        i.repositories_timestamp_value, is_null, vt);
      i.repositories_timestamp_null = is_null;
    }

    // internal
    //
    {
      bool const& v =
        o.internal;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.internal_value, is_null, v);
      i.internal_null = is_null;
    }

    // buildable
    //
    {
      bool const& v =
        o.buildable;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.buildable_value, is_null, v);
      i.buildable_null = is_null;
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::repository_id& v =
        o.id;

      composite_value_traits< ::brep::repository_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // location
    //
    {
      // From package.hxx:435:7
      ::bpkg::repository_location v;

      ::brep::_repository_location vt;

      composite_value_traits< ::brep::_repository_location, id_pgsql >::init (
        vt,
        i.location_value,
        db);

      // From common.hxx:323:14
      v = brep::repository_location (std::move ((vt).url), (vt).type);
      // From package.hxx:435:7
      o.location = std::move (v);
      assert (o.canonical_name == o.location.canonical_name ());
    }

    // display_name
    //
    {
      ::std::string& v =
        o.display_name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.display_name_value,
        i.display_name_size,
        i.display_name_null);
    }

    // priority
    //
    {
      ::uint16_t& v =
        o.priority;

      pgsql::value_traits<
          ::uint16_t,
          pgsql::id_integer >::set_value (
        v,
        i.priority_value,
        i.priority_null);
    }

    // interface_url
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.interface_url;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.interface_url_value,
        i.interface_url_size,
        i.interface_url_null);
    }

    // email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.email_value,
          db);
      }
    }

    // summary
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.summary;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.summary_value,
        i.summary_size,
        i.summary_null);
    }

    // description
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.description;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.description_value,
        i.description_size,
        i.description_null);
    }

    // cache_location
    //
    {
      ::bpkg::repository_location& v =
        o.cache_location;

      ::brep::_repository_location vt;

      composite_value_traits< ::brep::_repository_location, id_pgsql >::init (
        vt,
        i.cache_location_value,
        db);

      // From common.hxx:323:14
      v = brep::repository_location (std::move ((vt).url), (vt).type);
    }

    // certificate
    //
    {
      ::butl::optional< ::brep::certificate >& v =
        o.certificate;

      if (composite_value_traits< ::brep::certificate, id_pgsql >::get_null (
            i.certificate_value))
        wrapper_traits< ::butl::optional< ::brep::certificate > >::set_null (v);
      else
      {
        ::brep::certificate& vw =
          wrapper_traits< ::butl::optional< ::brep::certificate > >::set_ref (v);

        composite_value_traits< ::brep::certificate, id_pgsql >::init (
          vw,
          i.certificate_value,
          db);
      }
    }

    // packages_timestamp
    //
    {
      ::butl::timestamp& v =
        o.packages_timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.packages_timestamp_value,
        i.packages_timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // repositories_timestamp
    //
    {
      ::butl::timestamp& v =
        o.repositories_timestamp;

      ::uint64_t vt;

      pgsql::value_traits<
          ::uint64_t,
          pgsql::id_bigint >::set_value (
        vt,
        i.repositories_timestamp_value,
        i.repositories_timestamp_null);

      // From common.hxx:123:14
      v = brep::timestamp (std::chrono::duration_cast < brep::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // internal
    //
    {
      bool& v =
        o.internal;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.internal_value,
        i.internal_null);
    }

    // buildable
    //
    {
      bool& v =
        o.buildable;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.buildable_value,
        i.buildable_null);
    }
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    pgsql::statement_kind sk (pgsql::statement_select);
    {
      if (composite_value_traits< ::brep::repository_id, id_pgsql >::init (
            i.id_value,
            id,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::persist_statement[] =
  "INSERT INTO \"repository\" "
  "(\"tenant\", "
  "\"canonical_name\", "
  "\"location_url\", "
  "\"location_type\", "
  "\"display_name\", "
  "\"priority\", "
  "\"interface_url\", "
  "\"email\", "
  "\"email_comment\", "
  "\"summary\", "
  "\"description\", "
  "\"cache_location_url\", "
  "\"cache_location_type\", "
  "\"certificate_fingerprint\", "
  "\"certificate_name\", "
  "\"certificate_organization\", "
  "\"certificate_email\", "
  "\"certificate_pem\", "
  "\"packages_timestamp\", "
  "\"repositories_timestamp\", "
  "\"internal\", "
  "\"buildable\") "
  "VALUES "
  "($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21, $22)";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::find_statement[] =
  "SELECT "
  "\"repository\".\"tenant\", "
  "\"repository\".\"canonical_name\", "
  "\"repository\".\"location_url\", "
  "\"repository\".\"location_type\", "
  "\"repository\".\"display_name\", "
  "\"repository\".\"priority\", "
  "\"repository\".\"interface_url\", "
  "\"repository\".\"email\", "
  "\"repository\".\"email_comment\", "
  "\"repository\".\"summary\", "
  "\"repository\".\"description\", "
  "\"repository\".\"cache_location_url\", "
  "\"repository\".\"cache_location_type\", "
  "\"repository\".\"certificate_fingerprint\", "
  "\"repository\".\"certificate_name\", "
  "\"repository\".\"certificate_organization\", "
  "\"repository\".\"certificate_email\", "
  "\"repository\".\"certificate_pem\", "
  "\"repository\".\"packages_timestamp\", "
  "\"repository\".\"repositories_timestamp\", "
  "\"repository\".\"internal\", "
  "\"repository\".\"buildable\" "
  "FROM \"repository\" "
  "WHERE \"repository\".\"tenant\"=$1 AND \"repository\".\"canonical_name\"=$2";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::update_statement[] =
  "UPDATE \"repository\" "
  "SET "
  "\"location_url\"=$1, "
  "\"location_type\"=$2, "
  "\"display_name\"=$3, "
  "\"priority\"=$4, "
  "\"interface_url\"=$5, "
  "\"email\"=$6, "
  "\"email_comment\"=$7, "
  "\"summary\"=$8, "
  "\"description\"=$9, "
  "\"cache_location_url\"=$10, "
  "\"cache_location_type\"=$11, "
  "\"certificate_fingerprint\"=$12, "
  "\"certificate_name\"=$13, "
  "\"certificate_organization\"=$14, "
  "\"certificate_email\"=$15, "
  "\"certificate_pem\"=$16, "
  "\"packages_timestamp\"=$17, "
  "\"repositories_timestamp\"=$18, "
  "\"internal\"=$19, "
  "\"buildable\"=$20 "
  "WHERE \"tenant\"=$21 AND \"canonical_name\"=$22";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::erase_statement[] =
  "DELETE FROM \"repository\" "
  "WHERE \"tenant\"=$1 AND \"canonical_name\"=$2";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::query_statement[] =
  "SELECT "
  "\"repository\".\"tenant\", "
  "\"repository\".\"canonical_name\", "
  "\"repository\".\"location_url\", "
  "\"repository\".\"location_type\", "
  "\"repository\".\"display_name\", "
  "\"repository\".\"priority\", "
  "\"repository\".\"interface_url\", "
  "\"repository\".\"email\", "
  "\"repository\".\"email_comment\", "
  "\"repository\".\"summary\", "
  "\"repository\".\"description\", "
  "\"repository\".\"cache_location_url\", "
  "\"repository\".\"cache_location_type\", "
  "\"repository\".\"certificate_fingerprint\", "
  "\"repository\".\"certificate_name\", "
  "\"repository\".\"certificate_organization\", "
  "\"repository\".\"certificate_email\", "
  "\"repository\".\"certificate_pem\", "
  "\"repository\".\"packages_timestamp\", "
  "\"repository\".\"repositories_timestamp\", "
  "\"repository\".\"internal\", "
  "\"repository\".\"buildable\" "
  "FROM \"repository\"";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"repository\"";

  const char access::object_traits_impl< ::brep::repository, id_pgsql >::table_name[] =
  "\"repository\"";

  void access::object_traits_impl< ::brep::repository, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // complements
    //
    {
      ::std::vector< ::odb::lazy_weak_ptr< ::brep::repository > > const& v =
        obj.complements;

      complements_traits::persist (
        v,
        esc.complements);
    }

    // prerequisites
    //
    {
      ::std::vector< ::odb::lazy_weak_ptr< ::brep::repository > > const& v =
        obj.prerequisites;

      prerequisites_traits::persist (
        v,
        esc.prerequisites);
    }

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace pgsql;
    using pgsql::update_statement;

    callback (db, obj, callback_event::pre_update);

    pgsql::transaction& tr (pgsql::transaction::current ());
    pgsql::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // complements
    //
    {
      ::std::vector< ::odb::lazy_weak_ptr< ::brep::repository > > const& v =
        obj.complements;

      complements_traits::update (
        v,
        esc.complements);
    }

    // prerequisites
    //
    {
      ::std::vector< ::odb::lazy_weak_ptr< ::brep::repository > > const& v =
        obj.prerequisites;

      prerequisites_traits::update (
        v,
        esc.prerequisites);
    }

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // complements
    //
    {
      complements_traits::erase (
        esc.complements);
    }

    // prerequisites
    //
    {
      prerequisites_traits::erase (
        esc.prerequisites);
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::repository, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::repository, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::repository, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::repository, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::repository, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::repository, id_pgsql >::
  load_ (statements_type& sts,
         object_type& obj,
         bool reload)
  {
    ODB_POTENTIALLY_UNUSED (reload);

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // complements
    //
    {
      ::std::vector< ::odb::lazy_weak_ptr< ::brep::repository > >& v =
        obj.complements;

      complements_traits::load (
        v,
        esc.complements);
    }

    // prerequisites
    //
    {
      ::std::vector< ::odb::lazy_weak_ptr< ::brep::repository > >& v =
        obj.prerequisites;

      prerequisites_traits::load (
        v,
        esc.prerequisites);
    }
  }

  result< access::object_traits_impl< ::brep::repository, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::repository, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        false,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::repository, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::repository, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::repository, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // repository_count
  //

  const char access::view_traits_impl< ::brep::repository_count, id_pgsql >::
  query_statement_name[] = "query_brep_repository_count";

  bool access::view_traits_impl< ::brep::repository_count, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = 0;

    return grew;
  }

  void access::view_traits_impl< ::brep::repository_count, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::brep::repository_count, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::brep::repository_count, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::repository_count, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "count(\"repository\".\"tenant\") ");

    r += "FROM \"repository\"";

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::repository_count, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::repository_count, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::repository_count, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::repository_count, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // typed_text
  //

  bool access::composite_value_traits< ::brep::typed_text, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // text
    //
    if (t[0UL])
    {
      i.text_value.capacity (i.text_size);
      grew = true;
    }

    // type
    //
    if (t[1UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::typed_text, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // text
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.text_value.data_ptr ();
    b[n].capacity = i.text_value.capacity ();
    b[n].size = &i.text_size;
    b[n].is_null = &i.text_null;
    n++;

    // type
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.type_value.data_ptr ();
    b[n].capacity = i.type_value.capacity ();
    b[n].size = &i.type_size;
    b[n].is_null = &i.type_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::typed_text, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // text
    //
    {
      ::std::string const& v =
        o.text;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.text_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.text_value,
        size,
        is_null,
        v);
      i.text_null = is_null;
      i.text_size = size;
      grew = grew || (cap != i.text_value.capacity ());
    }

    // type
    //
    {
      ::bpkg::text_type const& v =
        o.type;

      // From package.hxx:54:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.type_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.type_value,
        size,
        is_null,
        vt);
      i.type_null = is_null;
      i.type_size = size;
      grew = grew || (cap != i.type_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::typed_text, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // text
    //
    {
      ::std::string& v =
        o.text;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.text_value,
        i.text_size,
        i.text_null);
    }

    // type
    //
    {
      ::bpkg::text_type& v =
        o.type;

      ::std::string vt;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        vt,
        i.type_value,
        i.type_size,
        i.type_null);

      // From package.hxx:54:14
      v = * brep::to_text_type (vt);
    }
  }

  // public_key
  //

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::
  persist_statement_name[] = "persist_brep_public_key";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::
  find_statement_name[] = "find_brep_public_key";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::
  update_statement_name[] = "update_brep_public_key";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::
  erase_statement_name[] = "erase_brep_public_key";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::
  query_statement_name[] = "query_brep_public_key";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_public_key";

  const unsigned int access::object_traits_impl< ::brep::public_key, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::public_key, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::public_key, id_pgsql >::
  update_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  struct access::object_traits_impl< ::brep::public_key, id_pgsql >::extra_statement_cache_type
  {
    extra_statement_cache_type (
      pgsql::connection&,
      image_type&,
      id_image_type&,
      pgsql::binding&,
      pgsql::binding&,
      pgsql::native_binding&,
      const unsigned int*)
    {
    }
  };

  access::object_traits_impl< ::brep::public_key, id_pgsql >::id_type
  access::object_traits_impl< ::brep::public_key, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      composite_value_traits< ::brep::public_key_id, id_pgsql >::init (
        id,
        i.id_value,
        db);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::public_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::public_key_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // data
    //
    if (t[2UL])
    {
      i.data_value.capacity (i.data_size);
      grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::public_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      composite_value_traits< ::brep::public_key_id, id_pgsql >::bind (
        b + n, i.id_value, sk);
      n += 2UL;
    }

    // data
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.data_value.data_ptr ();
    b[n].capacity = i.data_value.capacity ();
    b[n].size = &i.data_size;
    b[n].is_null = &i.data_null;
    n++;
  }

  void access::object_traits_impl< ::brep::public_key, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    pgsql::statement_kind sk (pgsql::statement_select);
    composite_value_traits< ::brep::public_key_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
  }

  bool access::object_traits_impl< ::brep::public_key, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::brep::public_key_id const& v =
        o.id;

      if (composite_value_traits< ::brep::public_key_id, id_pgsql >::init (
            i.id_value,
            v,
            sk))
        grew = true;
    }

    // data
    //
    {
      // From package.hxx:510:45
      ::std::string const& v =
        o;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.data_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.data_value,
        size,
        is_null,
        v);
      i.data_null = is_null;
      i.data_size = size;
      grew = grew || (cap != i.data_value.capacity ());
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::public_key, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::public_key_id& v =
        o.id;

      composite_value_traits< ::brep::public_key_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // data
    //
    {
      // From package.hxx:510:45
      ::std::string& v =
        o;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.data_value,
        i.data_size,
        i.data_null);
    }
  }

  void access::object_traits_impl< ::brep::public_key, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    pgsql::statement_kind sk (pgsql::statement_select);
    {
      if (composite_value_traits< ::brep::public_key_id, id_pgsql >::init (
            i.id_value,
            id,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::persist_statement[] =
  "INSERT INTO \"public_key\" "
  "(\"tenant\", "
  "\"fingerprint\", "
  "\"data\") "
  "VALUES "
  "($1, $2, $3)";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::find_statement[] =
  "SELECT "
  "\"public_key\".\"tenant\", "
  "\"public_key\".\"fingerprint\", "
  "\"public_key\".\"data\" "
  "FROM \"public_key\" "
  "WHERE \"public_key\".\"tenant\"=$1 AND \"public_key\".\"fingerprint\"=$2";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::update_statement[] =
  "UPDATE \"public_key\" "
  "SET "
  "\"data\"=$1 "
  "WHERE \"tenant\"=$2 AND \"fingerprint\"=$3";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::erase_statement[] =
  "DELETE FROM \"public_key\" "
  "WHERE \"tenant\"=$1 AND \"fingerprint\"=$2";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::query_statement[] =
  "SELECT "
  "\"public_key\".\"tenant\", "
  "\"public_key\".\"fingerprint\", "
  "\"public_key\".\"data\" "
  "FROM \"public_key\"";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"public_key\"";

  const char access::object_traits_impl< ::brep::public_key, id_pgsql >::table_name[] =
  "\"public_key\"";

  void access::object_traits_impl< ::brep::public_key, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::public_key, id_pgsql >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace pgsql;
    using pgsql::update_statement;

    callback (db, obj, callback_event::pre_update);

    pgsql::transaction& tr (pgsql::transaction::current ());
    pgsql::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::brep::public_key, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::public_key, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::public_key, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::public_key, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::public_key, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::public_key, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  result< access::object_traits_impl< ::brep::public_key, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::public_key, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        false,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::public_key, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::public_key, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::public_key, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // package_build_config
  //

  bool access::composite_value_traits< ::brep::package_build_config, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // arguments
    //
    if (t[1UL])
    {
      i.arguments_value.capacity (i.arguments_size);
      grew = true;
    }

    // comment
    //
    if (t[2UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    // email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.email_value, t + 3UL))
      grew = true;

    // warning_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.warning_email_value, t + 5UL))
      grew = true;

    // error_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.error_email_value, t + 7UL))
      grew = true;

    return grew;
  }

  void access::composite_value_traits< ::brep::package_build_config, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.name_value.data_ptr ();
    b[n].capacity = i.name_value.capacity ();
    b[n].size = &i.name_size;
    b[n].is_null = &i.name_null;
    n++;

    // arguments
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.arguments_value.data_ptr ();
    b[n].capacity = i.arguments_value.capacity ();
    b[n].size = &i.arguments_size;
    b[n].is_null = &i.arguments_null;
    n++;

    // comment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.comment_value.data_ptr ();
    b[n].capacity = i.comment_value.capacity ();
    b[n].size = &i.comment_size;
    b[n].is_null = &i.comment_null;
    n++;

    // email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.email_value, sk);
    n += 2UL;

    // warning_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.warning_email_value, sk);
    n += 2UL;

    // error_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.error_email_value, sk);
    n += 2UL;
  }

  bool access::composite_value_traits< ::brep::package_build_config, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // name
    //
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.name_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.name_value,
        size,
        is_null,
        v);
      i.name_null = is_null;
      i.name_size = size;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // arguments
    //
    {
      ::std::string const& v =
        o.arguments;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.arguments_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.arguments_value,
        size,
        is_null,
        v);
      i.arguments_null = is_null;
      i.arguments_size = size;
      grew = grew || (cap != i.arguments_value.capacity ());
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.comment_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.comment_value,
        size,
        is_null,
        v);
      i.comment_null = is_null;
      i.comment_size = size;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    // email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // warning_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.warning_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.warning_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.warning_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // error_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.error_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.error_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.error_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::package_build_config, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // arguments
    //
    {
      ::std::string& v =
        o.arguments;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.arguments_value,
        i.arguments_size,
        i.arguments_null);
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }

    // email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.email_value,
          db);
      }
    }

    // warning_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.warning_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.warning_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.warning_email_value,
          db);
      }
    }

    // error_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.error_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.error_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.error_email_value,
          db);
      }
    }
  }

  // package_build_bot_key_key
  //

  bool access::composite_value_traits< ::brep::package_build_bot_key_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // inner
    //
    t[1UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::package_build_bot_key_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::package_build_bot_key_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::package_build_bot_key_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::package_build_bot_key_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // inner
    //
    {
      ::brep::package_build_bot_key_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::package_build_bot_key_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::package_build_bot_key_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::package_build_bot_key_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::package_build_bot_key_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // inner
    //
    {
      ::brep::package_build_bot_key_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::package_build_bot_key_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // reviews_summary
  //

  bool access::composite_value_traits< ::brep::reviews_summary, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // pass
    //
    t[0UL] = 0;

    // fail
    //
    t[1UL] = 0;

    // manifest_file
    //
    if (t[2UL])
    {
      i.manifest_file_value.capacity (i.manifest_file_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::reviews_summary, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // pass
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.pass_value;
    b[n].is_null = &i.pass_null;
    n++;

    // fail
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.fail_value;
    b[n].is_null = &i.fail_null;
    n++;

    // manifest_file
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.manifest_file_value.data_ptr ();
    b[n].capacity = i.manifest_file_value.capacity ();
    b[n].size = &i.manifest_file_size;
    b[n].is_null = &i.manifest_file_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::reviews_summary, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // pass
    //
    {
      ::std::size_t const& v =
        o.pass;

      bool is_null (false);
      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_image (
        i.pass_value, is_null, v);
      i.pass_null = is_null;
    }

    // fail
    //
    {
      ::std::size_t const& v =
        o.fail;

      bool is_null (false);
      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_image (
        i.fail_value, is_null, v);
      i.fail_null = is_null;
    }

    // manifest_file
    //
    {
      ::butl::path const& v =
        o.manifest_file;

      // From common.hxx:100:14
      ::std::string const& vt =
        (v).string ();

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.manifest_file_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.manifest_file_value,
        size,
        is_null,
        vt);
      i.manifest_file_null = is_null;
      i.manifest_file_size = size;
      grew = grew || (cap != i.manifest_file_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::reviews_summary, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // pass
    //
    {
      ::std::size_t& v =
        o.pass;

      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_value (
        v,
        i.pass_value,
        i.pass_null);
    }

    // fail
    //
    {
      ::std::size_t& v =
        o.fail;

      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_value (
        v,
        i.fail_value,
        i.fail_null);
    }

    // manifest_file
    //
    {
      ::butl::path& v =
        o.manifest_file;

      ::std::string vt;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        vt,
        i.manifest_file_value,
        i.manifest_file_size,
        i.manifest_file_null);

      // From common.hxx:100:14
      v = brep::path (vt);
    }
  }

  // _license_key
  //

  bool access::composite_value_traits< ::brep::package::_license_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // inner
    //
    t[1UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::package::_license_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::package::_license_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::package::_license_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::package::_license_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // inner
    //
    {
      ::brep::package::_license_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::package::_license_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::package::_license_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::package::_license_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::package::_license_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // inner
    //
    {
      ::brep::package::_license_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::package::_license_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // _dependency_alternative_key
  //

  bool access::composite_value_traits< ::brep::package::_dependency_alternative_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // inner
    //
    t[1UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::package::_dependency_alternative_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::package::_dependency_alternative_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::package::_dependency_alternative_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::package::_dependency_alternative_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // inner
    //
    {
      ::brep::package::_dependency_alternative_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::package::_dependency_alternative_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::package::_dependency_alternative_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::package::_dependency_alternative_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::package::_dependency_alternative_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // inner
    //
    {
      ::brep::package::_dependency_alternative_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::package::_dependency_alternative_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // _dependency_key
  //

  bool access::composite_value_traits< ::brep::package::_dependency_key, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = 0;

    // middle
    //
    t[1UL] = 0;

    // inner
    //
    t[2UL] = 0;

    return grew;
  }

  void access::composite_value_traits< ::brep::package::_dependency_key, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // middle
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.middle_value;
    b[n].is_null = &i.middle_null;
    n++;

    // inner
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::brep::package::_dependency_key, id_pgsql >::
  init (image_type& i,
        const value_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // outer
    //
    {
      ::brep::package::_dependency_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::package::_dependency_key::outer_type,
          pgsql::id_bigint >::set_image (
        i.outer_value, is_null, v);
      i.outer_null = is_null;
    }

    // middle
    //
    {
      ::brep::package::_dependency_key::middle_type const& v =
        o.middle;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::package::_dependency_key::middle_type,
          pgsql::id_bigint >::set_image (
        i.middle_value, is_null, v);
      i.middle_null = is_null;
    }

    // inner
    //
    {
      ::brep::package::_dependency_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      pgsql::value_traits<
          ::brep::package::_dependency_key::inner_type,
          pgsql::id_bigint >::set_image (
        i.inner_value, is_null, v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::brep::package::_dependency_key, id_pgsql >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::brep::package::_dependency_key::outer_type& v =
        o.outer;

      pgsql::value_traits<
          ::brep::package::_dependency_key::outer_type,
          pgsql::id_bigint >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // middle
    //
    {
      ::brep::package::_dependency_key::middle_type& v =
        o.middle;

      pgsql::value_traits<
          ::brep::package::_dependency_key::middle_type,
          pgsql::id_bigint >::set_value (
        v,
        i.middle_value,
        i.middle_null);
    }

    // inner
    //
    {
      ::brep::package::_dependency_key::inner_type& v =
        o.inner;

      pgsql::value_traits<
          ::brep::package::_dependency_key::inner_type,
          pgsql::id_bigint >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // package
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::
  persist_statement_name[] = "persist_brep_package";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::
  find_statement_name[] = "find_brep_package";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::
  update_statement_name[] = "update_brep_package";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::
  erase_statement_name[] = "erase_brep_package";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::
  query_statement_name[] = "query_brep_package";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::
  erase_query_statement_name[] = "erase_query_brep_package";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::
  persist_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::text_oid
  };

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::
  find_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid
  };

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::
  update_statement_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid
  };

  const char alias_traits<  ::brep::repository,
    id_pgsql,
    access::object_traits_impl< ::brep::package, id_pgsql >::internal_repository_tag>::
  table_name[] = "\"internal_repository\"";

  struct access::object_traits_impl< ::brep::package, id_pgsql >::extra_statement_cache_type
  {
    pgsql::container_statements_impl< license_alternatives_traits > license_alternatives;
    pgsql::container_statements_impl< licenses_traits > licenses;
    pgsql::container_statements_impl< topics_traits > topics;
    pgsql::container_statements_impl< keywords_traits > keywords;
    pgsql::container_statements_impl< dependencies_traits > dependencies;
    pgsql::container_statements_impl< dependency_alternatives_traits > dependency_alternatives;
    pgsql::container_statements_impl< dependency_alternative_dependencies_traits > dependency_alternative_dependencies;
    pgsql::container_statements_impl< requirements_traits > requirements;
    pgsql::container_statements_impl< requirement_alternatives_traits > requirement_alternatives;
    pgsql::container_statements_impl< requirement_alternative_requirements_traits > requirement_alternative_requirements;
    pgsql::container_statements_impl< tests_traits > tests;
    pgsql::container_statements_impl< builds_traits > builds;
    pgsql::container_statements_impl< build_constraints_traits > build_constraints;
    pgsql::container_statements_impl< build_auxiliaries_traits > build_auxiliaries;
    pgsql::container_statements_impl< build_bot_keys_traits > build_bot_keys;
    pgsql::container_statements_impl< build_configs_traits > build_configs;
    pgsql::container_statements_impl< build_config_builds_traits > build_config_builds;
    pgsql::container_statements_impl< build_config_constraints_traits > build_config_constraints;
    pgsql::container_statements_impl< build_config_auxiliaries_traits > build_config_auxiliaries;
    pgsql::container_statements_impl< build_config_bot_keys_traits > build_config_bot_keys;
    pgsql::container_statements_impl< other_repositories_traits > other_repositories;

    pgsql::section_statements< ::brep::package, build_section_traits > build_section;
    pgsql::section_statements< ::brep::package, unused_section_traits > unused_section;
    pgsql::section_statements< ::brep::package, reviews_section_traits > reviews_section;

    extra_statement_cache_type (
      pgsql::connection& c,
      image_type& im,
      id_image_type& idim,
      pgsql::binding& id,
      pgsql::binding& idv,
      pgsql::native_binding& idn,
      const unsigned int* idt)
    : license_alternatives (c, id, idn, idt),
      licenses (c, id, idn, idt),
      topics (c, id, idn, idt),
      keywords (c, id, idn, idt),
      dependencies (c, id, idn, idt),
      dependency_alternatives (c, id, idn, idt),
      dependency_alternative_dependencies (c, id, idn, idt),
      requirements (c, id, idn, idt),
      requirement_alternatives (c, id, idn, idt),
      requirement_alternative_requirements (c, id, idn, idt),
      tests (c, id, idn, idt),
      builds (c, id, idn, idt),
      build_constraints (c, id, idn, idt),
      build_auxiliaries (c, id, idn, idt),
      build_bot_keys (c, id, idn, idt),
      build_configs (c, id, idn, idt),
      build_config_builds (c, id, idn, idt),
      build_config_constraints (c, id, idn, idt),
      build_config_auxiliaries (c, id, idn, idt),
      build_config_bot_keys (c, id, idn, idt),
      other_repositories (c, id, idn, idt),
      build_section (c, im, idim, id, idv, idn, idt),
      unused_section (c, im, idim, id, idv, idn, idt),
      reviews_section (c, im, idim, id, idv, idn, idt)
    {
    }
  };

  // license_alternatives
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  select_name[] = "select_brep_package_license_alternatives";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  insert_name[] = "insert_brep_package_license_alternatives";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  delete_name[] = "delete_brep_package_license_alternatives";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  select_statement[] =
  "SELECT "
  "\"package_license_alternatives\".\"index\", "
  "\"package_license_alternatives\".\"comment\" "
  "FROM \"package_license_alternatives\" "
  "WHERE \"package_license_alternatives\".\"tenant\"=$1 AND \"package_license_alternatives\".\"name\"=$2::CITEXT AND \"package_license_alternatives\".\"version_epoch\"=$3 AND \"package_license_alternatives\".\"version_canonical_upstream\"=$4 AND \"package_license_alternatives\".\"version_canonical_release\"=$5 AND \"package_license_alternatives\".\"version_revision\"=$6 ORDER BY \"package_license_alternatives\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  insert_statement[] =
  "INSERT INTO \"package_license_alternatives\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  delete_statement[] =
  "DELETE FROM \"package_license_alternatives\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::license_alternatives_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // licenses
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  select_name[] = "select_brep_package_licenses";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  insert_name[] = "insert_brep_package_licenses";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  delete_name[] = "delete_brep_package_licenses";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  select_statement[] =
  "SELECT "
  "\"package_licenses\".\"alternative_index\", "
  "\"package_licenses\".\"index\", "
  "\"package_licenses\".\"license\" "
  "FROM \"package_licenses\" "
  "WHERE \"package_licenses\".\"tenant\"=$1 AND \"package_licenses\".\"name\"=$2::CITEXT AND \"package_licenses\".\"version_epoch\"=$3 AND \"package_licenses\".\"version_canonical_upstream\"=$4 AND \"package_licenses\".\"version_canonical_release\"=$5 AND \"package_licenses\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  insert_statement[] =
  "INSERT INTO \"package_licenses\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"alternative_index\", "
  "\"index\", "
  "\"license\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  delete_statement[] =
  "DELETE FROM \"package_licenses\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = d.value_value.data_ptr ();
    b[n].capacity = d.value_value.capacity ();
    b[n].size = &d.value_size;
    b[n].is_null = &d.value_null;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (t[2UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.value_value.capacity ());
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_image (
        i.value_value,
        size,
        is_null,
        v);
      i.value_null = is_null;
      i.value_size = size;
      grew = grew || (cap != i.value_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_value (
        v,
        i.value_value,
        i.value_size,
        i.value_null);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::licenses_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // topics
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  select_name[] = "select_brep_package_topics";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  insert_name[] = "insert_brep_package_topics";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  delete_name[] = "delete_brep_package_topics";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  select_statement[] =
  "SELECT "
  "\"package_topics\".\"index\", "
  "\"package_topics\".\"topic\" "
  "FROM \"package_topics\" "
  "WHERE \"package_topics\".\"tenant\"=$1 AND \"package_topics\".\"name\"=$2::CITEXT AND \"package_topics\".\"version_epoch\"=$3 AND \"package_topics\".\"version_canonical_upstream\"=$4 AND \"package_topics\".\"version_canonical_release\"=$5 AND \"package_topics\".\"version_revision\"=$6 ORDER BY \"package_topics\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  insert_statement[] =
  "INSERT INTO \"package_topics\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"topic\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  delete_statement[] =
  "DELETE FROM \"package_topics\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = d.value_value.data_ptr ();
    b[n].capacity = d.value_value.capacity ();
    b[n].size = &d.value_size;
    b[n].is_null = &d.value_null;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (t[1UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.value_value.capacity ());
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_image (
        i.value_value,
        size,
        is_null,
        v);
      i.value_null = is_null;
      i.value_size = size;
      grew = grew || (cap != i.value_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_value (
        v,
        i.value_value,
        i.value_size,
        i.value_null);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::topics_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // keywords
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  select_name[] = "select_brep_package_keywords";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  insert_name[] = "insert_brep_package_keywords";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  delete_name[] = "delete_brep_package_keywords";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  select_statement[] =
  "SELECT "
  "\"package_keywords\".\"index\", "
  "\"package_keywords\".\"keyword\" "
  "FROM \"package_keywords\" "
  "WHERE \"package_keywords\".\"tenant\"=$1 AND \"package_keywords\".\"name\"=$2::CITEXT AND \"package_keywords\".\"version_epoch\"=$3 AND \"package_keywords\".\"version_canonical_upstream\"=$4 AND \"package_keywords\".\"version_canonical_release\"=$5 AND \"package_keywords\".\"version_revision\"=$6 ORDER BY \"package_keywords\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  insert_statement[] =
  "INSERT INTO \"package_keywords\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"keyword\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  delete_statement[] =
  "DELETE FROM \"package_keywords\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = d.value_value.data_ptr ();
    b[n].capacity = d.value_value.capacity ();
    b[n].size = &d.value_size;
    b[n].is_null = &d.value_null;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (t[1UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.value_value.capacity ());
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_image (
        i.value_value,
        size,
        is_null,
        v);
      i.value_null = is_null;
      i.value_size = size;
      grew = grew || (cap != i.value_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_value (
        v,
        i.value_value,
        i.value_size,
        i.value_null);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::keywords_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // dependencies
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  select_name[] = "select_brep_package_dependencies";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  insert_name[] = "insert_brep_package_dependencies";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  delete_name[] = "delete_brep_package_dependencies";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  select_statement[] =
  "SELECT "
  "\"package_dependencies\".\"index\", "
  "\"package_dependencies\".\"buildtime\", "
  "\"package_dependencies\".\"comment\" "
  "FROM \"package_dependencies\" "
  "WHERE \"package_dependencies\".\"tenant\"=$1 AND \"package_dependencies\".\"name\"=$2::CITEXT AND \"package_dependencies\".\"version_epoch\"=$3 AND \"package_dependencies\".\"version_canonical_upstream\"=$4 AND \"package_dependencies\".\"version_canonical_release\"=$5 AND \"package_dependencies\".\"version_revision\"=$6 ORDER BY \"package_dependencies\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  insert_statement[] =
  "INSERT INTO \"package_dependencies\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"buildtime\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  delete_statement[] =
  "DELETE FROM \"package_dependencies\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependencies_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // dependency_alternatives
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  select_name[] = "select_brep_package_dependency_alternatives";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  insert_name[] = "insert_brep_package_dependency_alternatives";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  delete_name[] = "delete_brep_package_dependency_alternatives";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  select_statement[] =
  "SELECT "
  "\"package_dependency_alternatives\".\"dependency_index\", "
  "\"package_dependency_alternatives\".\"index\", "
  "\"package_dependency_alternatives\".\"enable\", "
  "\"package_dependency_alternatives\".\"reflect\", "
  "\"package_dependency_alternatives\".\"prefer\", "
  "\"package_dependency_alternatives\".\"accept\", "
  "\"package_dependency_alternatives\".\"require\" "
  "FROM \"package_dependency_alternatives\" "
  "WHERE \"package_dependency_alternatives\".\"tenant\"=$1 AND \"package_dependency_alternatives\".\"name\"=$2::CITEXT AND \"package_dependency_alternatives\".\"version_epoch\"=$3 AND \"package_dependency_alternatives\".\"version_canonical_upstream\"=$4 AND \"package_dependency_alternatives\".\"version_canonical_release\"=$5 AND \"package_dependency_alternatives\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  insert_statement[] =
  "INSERT INTO \"package_dependency_alternatives\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"dependency_index\", "
  "\"index\", "
  "\"enable\", "
  "\"reflect\", "
  "\"prefer\", "
  "\"accept\", "
  "\"require\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  delete_statement[] =
  "DELETE FROM \"package_dependency_alternatives\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternatives_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // dependency_alternative_dependencies
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  select_name[] = "select_brep_package_dependency_alternative_dependencies";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  insert_name[] = "insert_brep_package_dependency_alternative_dependencies";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  delete_name[] = "delete_brep_package_dependency_alternative_dependencies";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  select_statement[] =
  "SELECT "
  "\"package_dependency_alternative_dependencies\".\"dependency_index\", "
  "\"package_dependency_alternative_dependencies\".\"alternative_index\", "
  "\"package_dependency_alternative_dependencies\".\"index\", "
  "\"package_dependency_alternative_dependencies\".\"dep_name\"::TEXT, "
  "\"package_dependency_alternative_dependencies\".\"dep_min_version_epoch\", "
  "\"package_dependency_alternative_dependencies\".\"dep_min_version_canonical_upstream\", "
  "\"package_dependency_alternative_dependencies\".\"dep_min_version_canonical_release\", "
  "\"package_dependency_alternative_dependencies\".\"dep_min_version_revision\", "
  "\"package_dependency_alternative_dependencies\".\"dep_min_version_upstream\", "
  "\"package_dependency_alternative_dependencies\".\"dep_min_version_release\", "
  "\"package_dependency_alternative_dependencies\".\"dep_max_version_epoch\", "
  "\"package_dependency_alternative_dependencies\".\"dep_max_version_canonical_upstream\", "
  "\"package_dependency_alternative_dependencies\".\"dep_max_version_canonical_release\", "
  "\"package_dependency_alternative_dependencies\".\"dep_max_version_revision\", "
  "\"package_dependency_alternative_dependencies\".\"dep_max_version_upstream\", "
  "\"package_dependency_alternative_dependencies\".\"dep_max_version_release\", "
  "\"package_dependency_alternative_dependencies\".\"dep_min_open\", "
  "\"package_dependency_alternative_dependencies\".\"dep_max_open\", "
  "\"package_dependency_alternative_dependencies\".\"dep_package_tenant\", "
  "\"package_dependency_alternative_dependencies\".\"dep_package_name\"::TEXT, "
  "\"package_dependency_alternative_dependencies\".\"dep_package_version_epoch\", "
  "\"package_dependency_alternative_dependencies\".\"dep_package_version_canonical_upstream\", "
  "\"package_dependency_alternative_dependencies\".\"dep_package_version_canonical_release\", "
  "\"package_dependency_alternative_dependencies\".\"dep_package_version_revision\" "
  "FROM \"package_dependency_alternative_dependencies\" "
  "WHERE \"package_dependency_alternative_dependencies\".\"tenant\"=$1 AND \"package_dependency_alternative_dependencies\".\"name\"=$2::CITEXT AND \"package_dependency_alternative_dependencies\".\"version_epoch\"=$3 AND \"package_dependency_alternative_dependencies\".\"version_canonical_upstream\"=$4 AND \"package_dependency_alternative_dependencies\".\"version_canonical_release\"=$5 AND \"package_dependency_alternative_dependencies\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  insert_statement[] =
  "INSERT INTO \"package_dependency_alternative_dependencies\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"dependency_index\", "
  "\"alternative_index\", "
  "\"index\", "
  "\"dep_name\", "
  "\"dep_min_version_epoch\", "
  "\"dep_min_version_canonical_upstream\", "
  "\"dep_min_version_canonical_release\", "
  "\"dep_min_version_revision\", "
  "\"dep_min_version_upstream\", "
  "\"dep_min_version_release\", "
  "\"dep_max_version_epoch\", "
  "\"dep_max_version_canonical_upstream\", "
  "\"dep_max_version_canonical_release\", "
  "\"dep_max_version_revision\", "
  "\"dep_max_version_upstream\", "
  "\"dep_max_version_release\", "
  "\"dep_min_open\", "
  "\"dep_max_open\", "
  "\"dep_package_tenant\", "
  "\"dep_package_name\", "
  "\"dep_package_version_epoch\", "
  "\"dep_package_version_canonical_upstream\", "
  "\"dep_package_version_canonical_release\", "
  "\"dep_package_version_revision\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10::CITEXT, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21, $22, $23, $24, $25, $26::CITEXT, $27, $28, $29, $30)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  delete_statement[] =
  "DELETE FROM \"package_dependency_alternative_dependencies\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 3UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 3UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::dependency_alternative_dependencies_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // requirements
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  select_name[] = "select_brep_package_requirements";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  insert_name[] = "insert_brep_package_requirements";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  delete_name[] = "delete_brep_package_requirements";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  select_statement[] =
  "SELECT "
  "\"package_requirements\".\"index\", "
  "\"package_requirements\".\"buildtime\", "
  "\"package_requirements\".\"comment\" "
  "FROM \"package_requirements\" "
  "WHERE \"package_requirements\".\"tenant\"=$1 AND \"package_requirements\".\"name\"=$2::CITEXT AND \"package_requirements\".\"version_epoch\"=$3 AND \"package_requirements\".\"version_canonical_upstream\"=$4 AND \"package_requirements\".\"version_canonical_release\"=$5 AND \"package_requirements\".\"version_revision\"=$6 ORDER BY \"package_requirements\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  insert_statement[] =
  "INSERT INTO \"package_requirements\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"buildtime\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  delete_statement[] =
  "DELETE FROM \"package_requirements\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirements_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // requirement_alternatives
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  select_name[] = "select_brep_package_requirement_alternatives";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  insert_name[] = "insert_brep_package_requirement_alternatives";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  delete_name[] = "delete_brep_package_requirement_alternatives";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  select_statement[] =
  "SELECT "
  "\"package_requirement_alternatives\".\"requirement_index\", "
  "\"package_requirement_alternatives\".\"index\", "
  "\"package_requirement_alternatives\".\"enable\", "
  "\"package_requirement_alternatives\".\"reflect\" "
  "FROM \"package_requirement_alternatives\" "
  "WHERE \"package_requirement_alternatives\".\"tenant\"=$1 AND \"package_requirement_alternatives\".\"name\"=$2::CITEXT AND \"package_requirement_alternatives\".\"version_epoch\"=$3 AND \"package_requirement_alternatives\".\"version_canonical_upstream\"=$4 AND \"package_requirement_alternatives\".\"version_canonical_release\"=$5 AND \"package_requirement_alternatives\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  insert_statement[] =
  "INSERT INTO \"package_requirement_alternatives\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"requirement_index\", "
  "\"index\", "
  "\"enable\", "
  "\"reflect\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  delete_statement[] =
  "DELETE FROM \"package_requirement_alternatives\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternatives_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // requirement_alternative_requirements
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  select_name[] = "select_brep_package_requirement_alternative_requirements";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  insert_name[] = "insert_brep_package_requirement_alternative_requirements";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  delete_name[] = "delete_brep_package_requirement_alternative_requirements";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  select_statement[] =
  "SELECT "
  "\"package_requirement_alternative_requirements\".\"requirement_index\", "
  "\"package_requirement_alternative_requirements\".\"alternative_index\", "
  "\"package_requirement_alternative_requirements\".\"index\", "
  "\"package_requirement_alternative_requirements\".\"id\" "
  "FROM \"package_requirement_alternative_requirements\" "
  "WHERE \"package_requirement_alternative_requirements\".\"tenant\"=$1 AND \"package_requirement_alternative_requirements\".\"name\"=$2::CITEXT AND \"package_requirement_alternative_requirements\".\"version_epoch\"=$3 AND \"package_requirement_alternative_requirements\".\"version_canonical_upstream\"=$4 AND \"package_requirement_alternative_requirements\".\"version_canonical_release\"=$5 AND \"package_requirement_alternative_requirements\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  insert_statement[] =
  "INSERT INTO \"package_requirement_alternative_requirements\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"requirement_index\", "
  "\"alternative_index\", "
  "\"index\", "
  "\"id\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  delete_statement[] =
  "DELETE FROM \"package_requirement_alternative_requirements\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 3UL;

    // value
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = d.value_value.data_ptr ();
    b[n].capacity = d.value_value.capacity ();
    b[n].size = &d.value_size;
    b[n].is_null = &d.value_null;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (t[3UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.value_value.capacity ());
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_image (
        i.value_value,
        size,
        is_null,
        v);
      i.value_null = is_null;
      i.value_size = size;
      grew = grew || (cap != i.value_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      pgsql::value_traits<
          value_type,
          pgsql::id_string >::set_value (
        v,
        i.value_value,
        i.value_size,
        i.value_null);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::requirement_alternative_requirements_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // tests
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  select_name[] = "select_brep_package_tests";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  insert_name[] = "insert_brep_package_tests";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  delete_name[] = "delete_brep_package_tests";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  select_statement[] =
  "SELECT "
  "\"package_tests\".\"index\", "
  "\"package_tests\".\"test_name\"::TEXT, "
  "\"package_tests\".\"test_min_version_epoch\", "
  "\"package_tests\".\"test_min_version_canonical_upstream\", "
  "\"package_tests\".\"test_min_version_canonical_release\", "
  "\"package_tests\".\"test_min_version_revision\", "
  "\"package_tests\".\"test_min_version_upstream\", "
  "\"package_tests\".\"test_min_version_release\", "
  "\"package_tests\".\"test_max_version_epoch\", "
  "\"package_tests\".\"test_max_version_canonical_upstream\", "
  "\"package_tests\".\"test_max_version_canonical_release\", "
  "\"package_tests\".\"test_max_version_revision\", "
  "\"package_tests\".\"test_max_version_upstream\", "
  "\"package_tests\".\"test_max_version_release\", "
  "\"package_tests\".\"test_min_open\", "
  "\"package_tests\".\"test_max_open\", "
  "\"package_tests\".\"test_package_tenant\", "
  "\"package_tests\".\"test_package_name\"::TEXT, "
  "\"package_tests\".\"test_package_version_epoch\", "
  "\"package_tests\".\"test_package_version_canonical_upstream\", "
  "\"package_tests\".\"test_package_version_canonical_release\", "
  "\"package_tests\".\"test_package_version_revision\", "
  "\"package_tests\".\"test_type\", "
  "\"package_tests\".\"test_buildtime\", "
  "\"package_tests\".\"test_enable\", "
  "\"package_tests\".\"test_reflect\" "
  "FROM \"package_tests\" "
  "WHERE \"package_tests\".\"tenant\"=$1 AND \"package_tests\".\"name\"=$2::CITEXT AND \"package_tests\".\"version_epoch\"=$3 AND \"package_tests\".\"version_canonical_upstream\"=$4 AND \"package_tests\".\"version_canonical_release\"=$5 AND \"package_tests\".\"version_revision\"=$6 ORDER BY \"package_tests\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  insert_statement[] =
  "INSERT INTO \"package_tests\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"test_name\", "
  "\"test_min_version_epoch\", "
  "\"test_min_version_canonical_upstream\", "
  "\"test_min_version_canonical_release\", "
  "\"test_min_version_revision\", "
  "\"test_min_version_upstream\", "
  "\"test_min_version_release\", "
  "\"test_max_version_epoch\", "
  "\"test_max_version_canonical_upstream\", "
  "\"test_max_version_canonical_release\", "
  "\"test_max_version_revision\", "
  "\"test_max_version_upstream\", "
  "\"test_max_version_release\", "
  "\"test_min_open\", "
  "\"test_max_open\", "
  "\"test_package_tenant\", "
  "\"test_package_name\", "
  "\"test_package_version_epoch\", "
  "\"test_package_version_canonical_upstream\", "
  "\"test_package_version_canonical_release\", "
  "\"test_package_version_revision\", "
  "\"test_type\", "
  "\"test_buildtime\", "
  "\"test_enable\", "
  "\"test_reflect\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8::CITEXT, $9, $10, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21, $22, $23, $24::CITEXT, $25, $26, $27, $28, $29, $30, $31, $32)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  delete_statement[] =
  "DELETE FROM \"package_tests\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::tests_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // builds
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  select_name[] = "select_brep_package_builds";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  insert_name[] = "insert_brep_package_builds";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  delete_name[] = "delete_brep_package_builds";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  select_statement[] =
  "SELECT "
  "\"package_builds\".\"index\", "
  "\"package_builds\".\"expression\", "
  "\"package_builds\".\"comment\" "
  "FROM \"package_builds\" "
  "WHERE \"package_builds\".\"tenant\"=$1 AND \"package_builds\".\"name\"=$2::CITEXT AND \"package_builds\".\"version_epoch\"=$3 AND \"package_builds\".\"version_canonical_upstream\"=$4 AND \"package_builds\".\"version_canonical_release\"=$5 AND \"package_builds\".\"version_revision\"=$6 ORDER BY \"package_builds\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  insert_statement[] =
  "INSERT INTO \"package_builds\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"expression\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  delete_statement[] =
  "DELETE FROM \"package_builds\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::builds_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // build_constraints
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  select_name[] = "select_brep_package_build_constraints";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  insert_name[] = "insert_brep_package_build_constraints";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  delete_name[] = "delete_brep_package_build_constraints";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  select_statement[] =
  "SELECT "
  "\"package_build_constraints\".\"index\", "
  "\"package_build_constraints\".\"exclusion\", "
  "\"package_build_constraints\".\"config\", "
  "\"package_build_constraints\".\"target\", "
  "\"package_build_constraints\".\"comment\" "
  "FROM \"package_build_constraints\" "
  "WHERE \"package_build_constraints\".\"tenant\"=$1 AND \"package_build_constraints\".\"name\"=$2::CITEXT AND \"package_build_constraints\".\"version_epoch\"=$3 AND \"package_build_constraints\".\"version_canonical_upstream\"=$4 AND \"package_build_constraints\".\"version_canonical_release\"=$5 AND \"package_build_constraints\".\"version_revision\"=$6 ORDER BY \"package_build_constraints\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  insert_statement[] =
  "INSERT INTO \"package_build_constraints\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"exclusion\", "
  "\"config\", "
  "\"target\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  delete_statement[] =
  "DELETE FROM \"package_build_constraints\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_constraints_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // build_auxiliaries
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  select_name[] = "select_brep_package_build_auxiliaries";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  insert_name[] = "insert_brep_package_build_auxiliaries";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  delete_name[] = "delete_brep_package_build_auxiliaries";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  select_statement[] =
  "SELECT "
  "\"package_build_auxiliaries\".\"index\", "
  "\"package_build_auxiliaries\".\"environment_name\", "
  "\"package_build_auxiliaries\".\"config\", "
  "\"package_build_auxiliaries\".\"comment\" "
  "FROM \"package_build_auxiliaries\" "
  "WHERE \"package_build_auxiliaries\".\"tenant\"=$1 AND \"package_build_auxiliaries\".\"name\"=$2::CITEXT AND \"package_build_auxiliaries\".\"version_epoch\"=$3 AND \"package_build_auxiliaries\".\"version_canonical_upstream\"=$4 AND \"package_build_auxiliaries\".\"version_canonical_release\"=$5 AND \"package_build_auxiliaries\".\"version_revision\"=$6 ORDER BY \"package_build_auxiliaries\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  insert_statement[] =
  "INSERT INTO \"package_build_auxiliaries\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"environment_name\", "
  "\"config\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  delete_statement[] =
  "DELETE FROM \"package_build_auxiliaries\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_auxiliaries_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // build_bot_keys
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  select_name[] = "select_brep_package_build_bot_keys";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  insert_name[] = "insert_brep_package_build_bot_keys";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  delete_name[] = "delete_brep_package_build_bot_keys";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  select_statement[] =
  "SELECT "
  "\"package_build_bot_keys\".\"index\", "
  "\"package_build_bot_keys\".\"key_tenant\", "
  "\"package_build_bot_keys\".\"key_fingerprint\" "
  "FROM \"package_build_bot_keys\" "
  "WHERE \"package_build_bot_keys\".\"tenant\"=$1 AND \"package_build_bot_keys\".\"name\"=$2::CITEXT AND \"package_build_bot_keys\".\"version_epoch\"=$3 AND \"package_build_bot_keys\".\"version_canonical_upstream\"=$4 AND \"package_build_bot_keys\".\"version_canonical_release\"=$5 AND \"package_build_bot_keys\".\"version_revision\"=$6 ORDER BY \"package_build_bot_keys\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  insert_statement[] =
  "INSERT INTO \"package_build_bot_keys\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"key_tenant\", "
  "\"key_fingerprint\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  delete_statement[] =
  "DELETE FROM \"package_build_bot_keys\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< ::brep::public_key_id, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< ::brep::public_key_id, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      typedef object_traits< ::brep::public_key > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.value_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        throw null_pointer ();
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      typedef object_traits< ::brep::public_key > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.value_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.value_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_bot_keys_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // build_configs
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  select_name[] = "select_brep_package_build_configs";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  insert_name[] = "insert_brep_package_build_configs";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  delete_name[] = "delete_brep_package_build_configs";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  select_statement[] =
  "SELECT "
  "\"package_build_configs\".\"index\", "
  "\"package_build_configs\".\"config_name\", "
  "\"package_build_configs\".\"config_arguments\", "
  "\"package_build_configs\".\"config_comment\", "
  "\"package_build_configs\".\"config_email\", "
  "\"package_build_configs\".\"config_email_comment\", "
  "\"package_build_configs\".\"config_warning_email\", "
  "\"package_build_configs\".\"config_warning_email_comment\", "
  "\"package_build_configs\".\"config_error_email\", "
  "\"package_build_configs\".\"config_error_email_comment\" "
  "FROM \"package_build_configs\" "
  "WHERE \"package_build_configs\".\"tenant\"=$1 AND \"package_build_configs\".\"name\"=$2::CITEXT AND \"package_build_configs\".\"version_epoch\"=$3 AND \"package_build_configs\".\"version_canonical_upstream\"=$4 AND \"package_build_configs\".\"version_canonical_release\"=$5 AND \"package_build_configs\".\"version_revision\"=$6 ORDER BY \"package_build_configs\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  insert_statement[] =
  "INSERT INTO \"package_build_configs\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"config_name\", "
  "\"config_arguments\", "
  "\"config_comment\", "
  "\"config_email\", "
  "\"config_email_comment\", "
  "\"config_warning_email\", "
  "\"config_warning_email_comment\", "
  "\"config_error_email\", "
  "\"config_error_email_comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12, $13, $14, $15, $16)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  delete_statement[] =
  "DELETE FROM \"package_build_configs\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_configs_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // build_config_builds
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  select_name[] = "select_brep_package_build_config_builds";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  insert_name[] = "insert_brep_package_build_config_builds";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  delete_name[] = "delete_brep_package_build_config_builds";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  select_statement[] =
  "SELECT "
  "\"package_build_config_builds\".\"config_index\", "
  "\"package_build_config_builds\".\"index\", "
  "\"package_build_config_builds\".\"expression\", "
  "\"package_build_config_builds\".\"comment\" "
  "FROM \"package_build_config_builds\" "
  "WHERE \"package_build_config_builds\".\"tenant\"=$1 AND \"package_build_config_builds\".\"name\"=$2::CITEXT AND \"package_build_config_builds\".\"version_epoch\"=$3 AND \"package_build_config_builds\".\"version_canonical_upstream\"=$4 AND \"package_build_config_builds\".\"version_canonical_release\"=$5 AND \"package_build_config_builds\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  insert_statement[] =
  "INSERT INTO \"package_build_config_builds\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"config_index\", "
  "\"index\", "
  "\"expression\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  delete_statement[] =
  "DELETE FROM \"package_build_config_builds\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_builds_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // build_config_constraints
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  select_name[] = "select_brep_package_build_config_constraints";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  insert_name[] = "insert_brep_package_build_config_constraints";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  delete_name[] = "delete_brep_package_build_config_constraints";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::bool_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  select_statement[] =
  "SELECT "
  "\"package_build_config_constraints\".\"config_index\", "
  "\"package_build_config_constraints\".\"index\", "
  "\"package_build_config_constraints\".\"exclusion\", "
  "\"package_build_config_constraints\".\"config\", "
  "\"package_build_config_constraints\".\"target\", "
  "\"package_build_config_constraints\".\"comment\" "
  "FROM \"package_build_config_constraints\" "
  "WHERE \"package_build_config_constraints\".\"tenant\"=$1 AND \"package_build_config_constraints\".\"name\"=$2::CITEXT AND \"package_build_config_constraints\".\"version_epoch\"=$3 AND \"package_build_config_constraints\".\"version_canonical_upstream\"=$4 AND \"package_build_config_constraints\".\"version_canonical_release\"=$5 AND \"package_build_config_constraints\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  insert_statement[] =
  "INSERT INTO \"package_build_config_constraints\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"config_index\", "
  "\"index\", "
  "\"exclusion\", "
  "\"config\", "
  "\"target\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11, $12)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  delete_statement[] =
  "DELETE FROM \"package_build_config_constraints\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_constraints_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // build_config_auxiliaries
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  select_name[] = "select_brep_package_build_config_auxiliaries";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  insert_name[] = "insert_brep_package_build_config_auxiliaries";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  delete_name[] = "delete_brep_package_build_config_auxiliaries";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  select_statement[] =
  "SELECT "
  "\"package_build_config_auxiliaries\".\"config_index\", "
  "\"package_build_config_auxiliaries\".\"index\", "
  "\"package_build_config_auxiliaries\".\"environment_name\", "
  "\"package_build_config_auxiliaries\".\"config\", "
  "\"package_build_config_auxiliaries\".\"comment\" "
  "FROM \"package_build_config_auxiliaries\" "
  "WHERE \"package_build_config_auxiliaries\".\"tenant\"=$1 AND \"package_build_config_auxiliaries\".\"name\"=$2::CITEXT AND \"package_build_config_auxiliaries\".\"version_epoch\"=$3 AND \"package_build_config_auxiliaries\".\"version_canonical_upstream\"=$4 AND \"package_build_config_auxiliaries\".\"version_canonical_release\"=$5 AND \"package_build_config_auxiliaries\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  insert_statement[] =
  "INSERT INTO \"package_build_config_auxiliaries\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"config_index\", "
  "\"index\", "
  "\"environment_name\", "
  "\"config\", "
  "\"comment\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10, $11)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  delete_statement[] =
  "DELETE FROM \"package_build_config_auxiliaries\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_pgsql >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_pgsql >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_auxiliaries_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // build_config_bot_keys
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  select_name[] = "select_brep_package_build_config_bot_keys";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  insert_name[] = "insert_brep_package_build_config_bot_keys";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  delete_name[] = "delete_brep_package_build_config_bot_keys";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  select_statement[] =
  "SELECT "
  "\"package_build_config_bot_keys\".\"config_index\", "
  "\"package_build_config_bot_keys\".\"index\", "
  "\"package_build_config_bot_keys\".\"key_tenant\", "
  "\"package_build_config_bot_keys\".\"key_fingerprint\" "
  "FROM \"package_build_config_bot_keys\" "
  "WHERE \"package_build_config_bot_keys\".\"tenant\"=$1 AND \"package_build_config_bot_keys\".\"name\"=$2::CITEXT AND \"package_build_config_bot_keys\".\"version_epoch\"=$3 AND \"package_build_config_bot_keys\".\"version_canonical_upstream\"=$4 AND \"package_build_config_bot_keys\".\"version_canonical_release\"=$5 AND \"package_build_config_bot_keys\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  insert_statement[] =
  "INSERT INTO \"package_build_config_bot_keys\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"config_index\", "
  "\"index\", "
  "\"key_tenant\", "
  "\"key_fingerprint\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  delete_statement[] =
  "DELETE FROM \"package_build_config_bot_keys\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_pgsql >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< ::brep::public_key_id, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_pgsql >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< ::brep::public_key_id, id_pgsql >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_pgsql >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      typedef object_traits< ::brep::public_key > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.value_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        throw null_pointer ();
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_pgsql >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      typedef object_traits< ::brep::public_key > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.value_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.value_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_config_bot_keys_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // other_repositories
  //

  const char access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  select_name[] = "select_brep_package_other_repositories";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  insert_name[] = "insert_brep_package_other_repositories";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  delete_name[] = "delete_brep_package_other_repositories";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  insert_types[] =
  {
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid
  };

  const char access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  select_statement[] =
  "SELECT "
  "\"package_other_repositories\".\"index\", "
  "\"package_other_repositories\".\"repository_tenant\", "
  "\"package_other_repositories\".\"repository_canonical_name\" "
  "FROM \"package_other_repositories\" "
  "WHERE \"package_other_repositories\".\"tenant\"=$1 AND \"package_other_repositories\".\"name\"=$2::CITEXT AND \"package_other_repositories\".\"version_epoch\"=$3 AND \"package_other_repositories\".\"version_canonical_upstream\"=$4 AND \"package_other_repositories\".\"version_canonical_release\"=$5 AND \"package_other_repositories\".\"version_revision\"=$6 ORDER BY \"package_other_repositories\".\"index\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  insert_statement[] =
  "INSERT INTO \"package_other_repositories\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"index\", "
  "\"repository_tenant\", "
  "\"repository_canonical_name\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9)";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  delete_statement[] =
  "DELETE FROM \"package_other_repositories\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace pgsql;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< ::brep::repository_id, id_pgsql >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = 0;

    // value
    //
    if (composite_value_traits< ::brep::repository_id, id_pgsql >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_image (
        i.index_value, is_null, *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      typedef object_traits< ::brep::repository > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.value_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        throw null_pointer ();
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      pgsql::value_traits<
          index_type,
          pgsql::id_bigint >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      typedef object_traits< ::brep::repository > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.value_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.value_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  delete_ (void* d)
  {
    using namespace pgsql;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::other_repositories_traits::
  erase (statements_type& sts)
  {
    using namespace pgsql;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // build_section
  //

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // builds
    //
    {
      ::brep::build_class_exprs& v =
        obj.builds;

      builds_traits::load (
        v,
        esc.builds);
    }

    // build_constraints
    //
    {
      ::brep::package::build_constraints_type& v =
        obj.build_constraints;

      build_constraints_traits::load (
        v,
        esc.build_constraints);
    }

    // build_configs
    //
    {
      ::brep::package_build_configs& v =
        obj.build_configs;

      build_configs_traits::load (
        v,
        esc.build_configs);
    }

    // build_config_builds
    //
    {
      ::brep::build_class_exprs_map v;

      build_config_builds_traits::load (
        v,
        esc.build_config_builds);

      // From package.hxx:927:7
      odb::nested_set (obj.build_configs, & brep::package_build_config::builds, std::move (v));
    }

    // build_config_constraints
    //
    {
      ::brep::build_constraints_map v;

      build_config_constraints_traits::load (
        v,
        esc.build_config_constraints);

      // From package.hxx:938:7
      odb::nested_set (obj.build_configs, & brep::package_build_config::constraints, std::move (v));
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::build_section_traits::
  update (extra_statement_cache_type& esc, const object_type& obj)
  {
    // builds
    //
    {
      ::brep::build_class_exprs const& v =
        obj.builds;

      builds_traits::update (
        v,
        esc.builds);
    }

    // build_constraints
    //
    {
      ::brep::package::build_constraints_type const& v =
        obj.build_constraints;

      build_constraints_traits::update (
        v,
        esc.build_constraints);
    }

    // build_configs
    //
    {
      ::brep::package_build_configs const& v =
        obj.build_configs;

      build_configs_traits::update (
        v,
        esc.build_configs);
    }

    // build_config_builds
    //
    {
      // From package.hxx:925:7
      ::brep::build_class_exprs_map const& v =
        odb::nested_get (obj.build_configs, & brep::package_build_config::builds);

      build_config_builds_traits::update (
        v,
        esc.build_config_builds);
    }

    // build_config_constraints
    //
    {
      // From package.hxx:936:7
      ::brep::build_constraints_map const& v =
        odb::nested_get (obj.build_configs, & brep::package_build_config::constraints);

      build_config_constraints_traits::update (
        v,
        esc.build_config_constraints);
    }
  }

  // unused_section
  //

  void access::object_traits_impl< ::brep::package, id_pgsql >::unused_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // build_auxiliaries
    //
    {
      ::brep::package::build_auxiliaries_type& v =
        obj.build_auxiliaries;

      build_auxiliaries_traits::load (
        v,
        esc.build_auxiliaries);
    }

    // build_bot_keys
    //
    {
      ::brep::package_build_bot_keys& v =
        obj.build_bot_keys;

      build_bot_keys_traits::load (
        v,
        esc.build_bot_keys);
    }

    // build_config_auxiliaries
    //
    {
      ::brep::build_auxiliaries_map v;

      build_config_auxiliaries_traits::load (
        v,
        esc.build_config_auxiliaries);

      // From package.hxx:949:7
      odb::nested_set (obj.build_configs, & brep::package_build_config::auxiliaries, std::move (v));
    }

    // build_config_bot_keys
    //
    {
      ::brep::package_build_bot_keys_map v;

      build_config_bot_keys_traits::load (
        v,
        esc.build_config_bot_keys);

      // From package.hxx:960:7
      odb::nested_set (obj.build_configs, & brep::package_build_config::bot_keys, std::move (v));
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::unused_section_traits::
  update (extra_statement_cache_type& esc, const object_type& obj)
  {
    // build_auxiliaries
    //
    {
      ::brep::package::build_auxiliaries_type const& v =
        obj.build_auxiliaries;

      build_auxiliaries_traits::update (
        v,
        esc.build_auxiliaries);
    }

    // build_bot_keys
    //
    {
      ::brep::package_build_bot_keys const& v =
        obj.build_bot_keys;

      build_bot_keys_traits::update (
        v,
        esc.build_bot_keys);
    }

    // build_config_auxiliaries
    //
    {
      // From package.hxx:947:7
      ::brep::build_auxiliaries_map const& v =
        odb::nested_get (obj.build_configs, & brep::package_build_config::auxiliaries);

      build_config_auxiliaries_traits::update (
        v,
        esc.build_config_auxiliaries);
    }

    // build_config_bot_keys
    //
    {
      // From package.hxx:958:7
      ::brep::package_build_bot_keys_map const& v =
        odb::nested_get (obj.build_configs, & brep::package_build_config::bot_keys);

      build_config_bot_keys_traits::update (
        v,
        esc.build_config_bot_keys);
    }
  }

  // reviews_section
  //

  std::size_t access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  bind (pgsql::bind* b,
        const pgsql::bind* id,
        std::size_t id_size,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);

    // reviews
    //
    composite_value_traits< ::brep::reviews_summary, id_pgsql >::bind (
      b + n, i.reviews_value, sk);
    n += 3UL;

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    return n;
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // reviews
    //
    if (composite_value_traits< ::brep::reviews_summary, id_pgsql >::grow (
          i.reviews_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // reviews
    //
    {
      ::butl::optional< ::brep::reviews_summary >& v =
        o.reviews;

      if (composite_value_traits< ::brep::reviews_summary, id_pgsql >::get_null (
            i.reviews_value))
        wrapper_traits< ::butl::optional< ::brep::reviews_summary > >::set_null (v);
      else
      {
        ::brep::reviews_summary& vw =
          wrapper_traits< ::butl::optional< ::brep::reviews_summary > >::set_ref (v);

        composite_value_traits< ::brep::reviews_summary, id_pgsql >::init (
          vw,
          i.reviews_value,
          db);
      }
    }
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  init (image_type& i,
        const object_type& o)
  {
    using namespace pgsql;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // reviews
    //
    {
      ::butl::optional< ::brep::reviews_summary > const& v =
        o.reviews;

      if (wrapper_traits< ::butl::optional< ::brep::reviews_summary > >::get_null (v))
        composite_value_traits< ::brep::reviews_summary, id_pgsql >::set_null (
          i.reviews_value, sk);
      else
      {
        const::brep::reviews_summary& vw = 
          wrapper_traits< ::butl::optional< ::brep::reviews_summary > >::get_ref (v);

        if (composite_value_traits< ::brep::reviews_summary, id_pgsql >::init (
              i.reviews_value,
              vw,
              sk))
          grew = true;
      }
    }

    return grew;
  }

  const char access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  select_statement[] =
  "SELECT "
  "\"package\".\"reviews_pass\", "
  "\"package\".\"reviews_fail\", "
  "\"package\".\"reviews_manifest_file\" "
  "FROM \"package\" "
  "WHERE \"package\".\"tenant\"=$1 AND \"package\".\"name\"=$2::CITEXT AND \"package\".\"version_epoch\"=$3 AND \"package\".\"version_canonical_upstream\"=$4 AND \"package\".\"version_canonical_release\"=$5 AND \"package\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  update_statement[] =
  "UPDATE \"package\" "
  "SET "
  "\"reviews_pass\"=$1, "
  "\"reviews_fail\"=$2, "
  "\"reviews_manifest_file\"=$3 "
  "WHERE \"tenant\"=$4 AND \"name\"=$5::CITEXT AND \"version_epoch\"=$6 AND \"version_canonical_upstream\"=$7 AND \"version_canonical_release\"=$8 AND \"version_revision\"=$9";

  void access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    using namespace pgsql;
    using pgsql::select_statement;

    statements_type& sts (esc.reviews_section);

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, 0, 0, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::no_data)
      throw object_not_persistent ();

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, 0, 0, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    init (obj, im, &sts.connection ().database ());
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  update (extra_statement_cache_type& esc, const object_type& obj)
  {
    using namespace pgsql;
    using pgsql::update_statement;

    statements_type& sts (esc.reviews_section);

    image_type& im (sts.image ());
    const binding& id (sts.idv_binding ());
    binding& imb (sts.update_image_binding ());

    if (init (im, obj))
      im.version++;

    if (im.version != sts.update_image_version () ||
        id.version != sts.update_id_binding_version () ||
        imb.version == 0)
    {
      bind (imb.bind, id.bind, id.count, im, statement_update);
      sts.update_image_version (im.version);
      sts.update_id_binding_version (id.version);
      imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();
  }

  const char access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  select_name[] = "select_brep_package_reviews_section";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  update_name[] = "update_brep_package_reviews_section";

  const unsigned int access::object_traits_impl< ::brep::package, id_pgsql >::reviews_section_traits::
  update_types[] =
  {
    pgsql::int8_oid,
    pgsql::int8_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid,
    pgsql::text_oid,
    pgsql::text_oid,
    pgsql::int4_oid
  };

  access::object_traits_impl< ::brep::package, id_pgsql >::id_type
  access::object_traits_impl< ::brep::package, id_pgsql >::
  id (const image_type& i)
  {
    pgsql::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      composite_value_traits< ::brep::package_id, id_pgsql >::init (
        id,
        i.id_value,
        db);
    }

    return id;
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::package_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // version
    //
    if (composite_value_traits< ::brep::package::upstream_version_type, id_pgsql >::grow (
          i.version_value, t + 6UL))
      grew = true;

    // upstream_version
    //
    if (t[8UL])
    {
      i.upstream_version_value.capacity (i.upstream_version_size);
      grew = true;
    }

    // project
    //
    if (t[9UL])
    {
      i.project_value.capacity (i.project_size);
      grew = true;
    }

    // priority
    //
    if (composite_value_traits< ::brep::package::priority_type, id_pgsql >::grow (
          i.priority_value, t + 10UL))
      grew = true;

    // summary
    //
    if (t[12UL])
    {
      i.summary_value.capacity (i.summary_size);
      grew = true;
    }

    // description
    //
    if (composite_value_traits< ::brep::typed_text, id_pgsql >::grow (
          i.description_value, t + 13UL))
      grew = true;

    // package_description
    //
    if (composite_value_traits< ::brep::typed_text, id_pgsql >::grow (
          i.package_description_value, t + 15UL))
      grew = true;

    // changes
    //
    if (composite_value_traits< ::brep::typed_text, id_pgsql >::grow (
          i.changes_value, t + 17UL))
      grew = true;

    // url
    //
    if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::grow (
          i.url_value, t + 19UL))
      grew = true;

    // doc_url
    //
    if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::grow (
          i.doc_url_value, t + 21UL))
      grew = true;

    // src_url
    //
    if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::grow (
          i.src_url_value, t + 23UL))
      grew = true;

    // package_url
    //
    if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::grow (
          i.package_url_value, t + 25UL))
      grew = true;

    // email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.email_value, t + 27UL))
      grew = true;

    // package_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.package_email_value, t + 29UL))
      grew = true;

    // build_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.build_email_value, t + 31UL))
      grew = true;

    // build_warning_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.build_warning_email_value, t + 33UL))
      grew = true;

    // build_error_email
    //
    if (composite_value_traits< ::bpkg::email, id_pgsql >::grow (
          i.build_error_email_value, t + 35UL))
      grew = true;

    // internal_repository
    //
    if (composite_value_traits< ::brep::repository_id, id_pgsql >::grow (
          i.internal_repository_value, t + 37UL))
      grew = true;

    // location
    //
    if (t[39UL])
    {
      i.location_value.capacity (i.location_size);
      grew = true;
    }

    // fragment
    //
    if (t[40UL])
    {
      i.fragment_value.capacity (i.fragment_size);
      grew = true;
    }

    // sha256sum
    //
    if (t[41UL])
    {
      i.sha256sum_value.capacity (i.sha256sum_size);
      grew = true;
    }

    // buildable
    //
    t[42UL] = 0;

    // unbuildable_reason
    //
    if (t[43UL])
    {
      i.unbuildable_reason_value.capacity (i.unbuildable_reason_size);
      grew = true;
    }

    // custom_bot
    //
    t[44UL] = 0;

    // search_index
    //
    if (t[45UL])
    {
      i.search_index_value.capacity (i.search_index_size);
      grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      composite_value_traits< ::brep::package_id, id_pgsql >::bind (
        b + n, i.id_value, sk);
      n += 6UL;
    }

    // version
    //
    composite_value_traits< ::brep::package::upstream_version_type, id_pgsql >::bind (
      b + n, i.version_value, sk);
    n += 2UL;

    // upstream_version
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.upstream_version_value.data_ptr ();
    b[n].capacity = i.upstream_version_value.capacity ();
    b[n].size = &i.upstream_version_size;
    b[n].is_null = &i.upstream_version_null;
    n++;

    // project
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.project_value.data_ptr ();
    b[n].capacity = i.project_value.capacity ();
    b[n].size = &i.project_size;
    b[n].is_null = &i.project_null;
    n++;

    // priority
    //
    composite_value_traits< ::brep::package::priority_type, id_pgsql >::bind (
      b + n, i.priority_value, sk);
    n += 2UL;

    // summary
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.summary_value.data_ptr ();
    b[n].capacity = i.summary_value.capacity ();
    b[n].size = &i.summary_size;
    b[n].is_null = &i.summary_null;
    n++;

    // description
    //
    composite_value_traits< ::brep::typed_text, id_pgsql >::bind (
      b + n, i.description_value, sk);
    n += 2UL;

    // package_description
    //
    composite_value_traits< ::brep::typed_text, id_pgsql >::bind (
      b + n, i.package_description_value, sk);
    n += 2UL;

    // changes
    //
    composite_value_traits< ::brep::typed_text, id_pgsql >::bind (
      b + n, i.changes_value, sk);
    n += 2UL;

    // url
    //
    composite_value_traits< ::bpkg::manifest_url, id_pgsql >::bind (
      b + n, i.url_value, sk);
    n += 2UL;

    // doc_url
    //
    composite_value_traits< ::bpkg::manifest_url, id_pgsql >::bind (
      b + n, i.doc_url_value, sk);
    n += 2UL;

    // src_url
    //
    composite_value_traits< ::bpkg::manifest_url, id_pgsql >::bind (
      b + n, i.src_url_value, sk);
    n += 2UL;

    // package_url
    //
    composite_value_traits< ::bpkg::manifest_url, id_pgsql >::bind (
      b + n, i.package_url_value, sk);
    n += 2UL;

    // email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.email_value, sk);
    n += 2UL;

    // package_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.package_email_value, sk);
    n += 2UL;

    // build_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.build_email_value, sk);
    n += 2UL;

    // build_warning_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.build_warning_email_value, sk);
    n += 2UL;

    // build_error_email
    //
    composite_value_traits< ::bpkg::email, id_pgsql >::bind (
      b + n, i.build_error_email_value, sk);
    n += 2UL;

    // reviews
    //
    if (sk == statement_insert)
    {
      composite_value_traits< ::brep::reviews_summary, id_pgsql >::bind (
        b + n, i.reviews_value, sk);
      n += 3UL;
    }

    // internal_repository
    //
    composite_value_traits< ::brep::repository_id, id_pgsql >::bind (
      b + n, i.internal_repository_value, sk);
    n += 2UL;

    // location
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.location_value.data_ptr ();
    b[n].capacity = i.location_value.capacity ();
    b[n].size = &i.location_size;
    b[n].is_null = &i.location_null;
    n++;

    // fragment
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.fragment_value.data_ptr ();
    b[n].capacity = i.fragment_value.capacity ();
    b[n].size = &i.fragment_size;
    b[n].is_null = &i.fragment_null;
    n++;

    // sha256sum
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.sha256sum_value.data_ptr ();
    b[n].capacity = i.sha256sum_value.capacity ();
    b[n].size = &i.sha256sum_size;
    b[n].is_null = &i.sha256sum_null;
    n++;

    // buildable
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.buildable_value;
    b[n].is_null = &i.buildable_null;
    n++;

    // unbuildable_reason
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.unbuildable_reason_value.data_ptr ();
    b[n].capacity = i.unbuildable_reason_value.capacity ();
    b[n].size = &i.unbuildable_reason_size;
    b[n].is_null = &i.unbuildable_reason_null;
    n++;

    // custom_bot
    //
    b[n].type = pgsql::bind::boolean_;
    b[n].buffer = &i.custom_bot_value;
    b[n].is_null = &i.custom_bot_null;
    n++;

    // search_index
    //
    b[n].type = pgsql::bind::text;
    b[n].buffer = i.search_index_value.data_ptr ();
    b[n].capacity = i.search_index_value.capacity ();
    b[n].size = &i.search_index_size;
    b[n].is_null = &i.search_index_null;
    n++;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::
  bind (pgsql::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    pgsql::statement_kind sk (pgsql::statement_select);
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::
  init (image_type& i,
        const object_type& o,
        pgsql::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace pgsql;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::brep::package_id const& v =
        o.id;

      if (composite_value_traits< ::brep::package_id, id_pgsql >::init (
            i.id_value,
            v,
            sk))
        grew = true;
    }

    // version
    //
    {
      ::brep::package::upstream_version_type const& v =
        o.version;

      if (composite_value_traits< ::brep::package::upstream_version_type, id_pgsql >::init (
            i.version_value,
            v,
            sk))
        grew = true;
    }

    // upstream_version
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.upstream_version;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.upstream_version_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.upstream_version_value,
        size,
        is_null,
        v);
      i.upstream_version_null = is_null;
      i.upstream_version_size = size;
      grew = grew || (cap != i.upstream_version_value.capacity ());
    }

    // project
    //
    {
      ::bpkg::package_name const& v =
        o.project;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.project_value.capacity ());
      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_image (
        i.project_value,
        size,
        is_null,
        v);
      i.project_null = is_null;
      i.project_size = size;
      grew = grew || (cap != i.project_value.capacity ());
    }

    // priority
    //
    {
      ::brep::package::priority_type const& v =
        o.priority;

      if (composite_value_traits< ::brep::package::priority_type, id_pgsql >::init (
            i.priority_value,
            v,
            sk))
        grew = true;
    }

    // summary
    //
    {
      ::std::string const& v =
        o.summary;

      bool is_null (false);
      std::size_t size (0);
      std::size_t cap (i.summary_value.capacity ());
      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_image (
        i.summary_value,
        size,
        is_null,
        v);
      i.summary_null = is_null;
      i.summary_size = size;
      grew = grew || (cap != i.summary_value.capacity ());
    }

    // description
    //
    {
      ::butl::optional< ::brep::typed_text > const& v =
        o.description;

      if (wrapper_traits< ::butl::optional< ::brep::typed_text > >::get_null (v))
        composite_value_traits< ::brep::typed_text, id_pgsql >::set_null (
          i.description_value, sk);
      else
      {
        const::brep::typed_text& vw = 
          wrapper_traits< ::butl::optional< ::brep::typed_text > >::get_ref (v);

        if (composite_value_traits< ::brep::typed_text, id_pgsql >::init (
              i.description_value,
              vw,
              sk))
          grew = true;
      }
    }

    // package_description
    //
    {
      ::butl::optional< ::brep::typed_text > const& v =
        o.package_description;

      if (wrapper_traits< ::butl::optional< ::brep::typed_text > >::get_null (v))
        composite_value_traits< ::brep::typed_text, id_pgsql >::set_null (
          i.package_description_value, sk);
      else
      {
        const::brep::typed_text& vw = 
          wrapper_traits< ::butl::optional< ::brep::typed_text > >::get_ref (v);

        if (composite_value_traits< ::brep::typed_text, id_pgsql >::init (
              i.package_description_value,
              vw,
              sk))
          grew = true;
      }
    }

    // changes
    //
    {
      ::butl::optional< ::brep::typed_text > const& v =
        o.changes;

      if (wrapper_traits< ::butl::optional< ::brep::typed_text > >::get_null (v))
        composite_value_traits< ::brep::typed_text, id_pgsql >::set_null (
          i.changes_value, sk);
      else
      {
        const::brep::typed_text& vw = 
          wrapper_traits< ::butl::optional< ::brep::typed_text > >::get_ref (v);

        if (composite_value_traits< ::brep::typed_text, id_pgsql >::init (
              i.changes_value,
              vw,
              sk))
          grew = true;
      }
    }

    // url
    //
    {
      ::butl::optional< ::bpkg::manifest_url > const& v =
        o.url;

      if (wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::get_null (v))
        composite_value_traits< ::bpkg::manifest_url, id_pgsql >::set_null (
          i.url_value, sk);
      else
      {
        const::bpkg::manifest_url& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::get_ref (v);

        if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::init (
              i.url_value,
              vw,
              sk))
          grew = true;
      }
    }

    // doc_url
    //
    {
      ::butl::optional< ::bpkg::manifest_url > const& v =
        o.doc_url;

      if (wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::get_null (v))
        composite_value_traits< ::bpkg::manifest_url, id_pgsql >::set_null (
          i.doc_url_value, sk);
      else
      {
        const::bpkg::manifest_url& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::get_ref (v);

        if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::init (
              i.doc_url_value,
              vw,
              sk))
          grew = true;
      }
    }

    // src_url
    //
    {
      ::butl::optional< ::bpkg::manifest_url > const& v =
        o.src_url;

      if (wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::get_null (v))
        composite_value_traits< ::bpkg::manifest_url, id_pgsql >::set_null (
          i.src_url_value, sk);
      else
      {
        const::bpkg::manifest_url& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::get_ref (v);

        if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::init (
              i.src_url_value,
              vw,
              sk))
          grew = true;
      }
    }

    // package_url
    //
    {
      ::butl::optional< ::bpkg::manifest_url > const& v =
        o.package_url;

      if (wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::get_null (v))
        composite_value_traits< ::bpkg::manifest_url, id_pgsql >::set_null (
          i.package_url_value, sk);
      else
      {
        const::bpkg::manifest_url& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::get_ref (v);

        if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::init (
              i.package_url_value,
              vw,
              sk))
          grew = true;
      }
    }

    // email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // package_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.package_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.package_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.package_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // build_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.build_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.build_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.build_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // build_warning_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.build_warning_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.build_warning_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.build_warning_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // build_error_email
    //
    {
      ::butl::optional< ::bpkg::email > const& v =
        o.build_error_email;

      if (wrapper_traits< ::butl::optional< ::bpkg::email > >::get_null (v))
        composite_value_traits< ::bpkg::email, id_pgsql >::set_null (
          i.build_error_email_value, sk);
      else
      {
        const::bpkg::email& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::email > >::get_ref (v);

        if (composite_value_traits< ::bpkg::email, id_pgsql >::init (
              i.build_error_email_value,
              vw,
              sk))
          grew = true;
      }
    }

    // reviews
    //
    if (sk == statement_insert)
    {
      ::butl::optional< ::brep::reviews_summary > const& v =
        o.reviews;

      if (wrapper_traits< ::butl::optional< ::brep::reviews_summary > >::get_null (v))
        composite_value_traits< ::brep::reviews_summary, id_pgsql >::set_null (
          i.reviews_value, sk);
      else
      {
        const::brep::reviews_summary& vw = 
          wrapper_traits< ::butl::optional< ::brep::reviews_summary > >::get_ref (v);

        if (composite_value_traits< ::brep::reviews_summary, id_pgsql >::init (
              i.reviews_value,
              vw,
              sk))
          grew = true;
      }
    }

    // internal_repository
    //
    {
      ::odb::lazy_shared_ptr< ::brep::repository > const& v =
        o.internal_repository;

      typedef object_traits< ::brep::repository > obj_traits;
      typedef odb::pointer_traits< ::odb::lazy_shared_ptr< ::brep::repository > > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        if (composite_value_traits< obj_traits::id_type, id_pgsql >::init (
              i.internal_repository_value,
              ptr_id,
              sk))
          grew = true;
      }
      else
        composite_value_traits< obj_traits::id_type, id_pgsql >::set_null (i.internal_repository_value, sk);
    }

    // location
    //
    {
      ::butl::optional< ::butl::basic_path< char, ::butl::any_path_kind< char > > > const& v =
        o.location;

      // From common.hxx:105:14
      ::brep::optional_string const& vt =
        (v) ? (v)->string () : brep::optional_string ();

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.location_value.capacity ());
      pgsql::value_traits<
          ::brep::optional_string,
          pgsql::id_string >::set_image (
        i.location_value,
        size,
        is_null,
        vt);
      i.location_null = is_null;
      i.location_size = size;
      grew = grew || (cap != i.location_value.capacity ());
    }

    // fragment
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.fragment;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.fragment_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.fragment_value,
        size,
        is_null,
        v);
      i.fragment_null = is_null;
      i.fragment_size = size;
      grew = grew || (cap != i.fragment_value.capacity ());
    }

    // sha256sum
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.sha256sum;

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.sha256sum_value.capacity ());
      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_image (
        i.sha256sum_value,
        size,
        is_null,
        v);
      i.sha256sum_null = is_null;
      i.sha256sum_size = size;
      grew = grew || (cap != i.sha256sum_value.capacity ());
    }

    // buildable
    //
    {
      bool const& v =
        o.buildable;

      bool is_null (false);
      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_image (
        i.buildable_value, is_null, v);
      i.buildable_null = is_null;
    }

    // unbuildable_reason
    //
    {
      ::butl::optional< ::brep::unbuildable_reason > const& v =
        o.unbuildable_reason;

      // From common.hxx:488:14
      ::brep::optional_string const& vt =
        (v) ? to_string ( * (v)) : brep::optional_string ();

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.unbuildable_reason_value.capacity ());
      pgsql::value_traits<
          ::brep::optional_string,
          pgsql::id_string >::set_image (
        i.unbuildable_reason_value,
        size,
        is_null,
        vt);
      i.unbuildable_reason_null = is_null;
      i.unbuildable_reason_size = size;
      grew = grew || (cap != i.unbuildable_reason_value.capacity ());
    }

    // custom_bot
    //
    {
      ::butl::optional< bool > const& v =
        o.custom_bot;

      bool is_null (true);
      pgsql::value_traits<
          ::butl::optional< bool >,
          pgsql::id_boolean >::set_image (
        i.custom_bot_value, is_null, v);
      i.custom_bot_null = is_null;
    }

    // search_index
    //
    {
      // From package.hxx:980:7
      ::brep::weighted_text const& v =
        o.search_text ();

      bool is_null (true);
      std::size_t size (0);
      std::size_t cap (i.search_index_value.capacity ());
      pgsql::value_traits<
          ::brep::weighted_text,
          pgsql::id_string >::set_image (
        i.search_index_value,
        size,
        is_null,
        v);
      i.search_index_null = is_null;
      i.search_index_size = size;
      grew = grew || (cap != i.search_index_value.capacity ());
    }

    return grew;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::package_id& v =
        o.id;

      composite_value_traits< ::brep::package_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // version
    //
    {
      // From package.hxx:801:32
      ::brep::package::upstream_version_type v;

      composite_value_traits< ::brep::package::upstream_version_type, id_pgsql >::init (
        v,
        i.version_value,
        db);

      // From package.hxx:801:32
      o.version.init (o.id.version, (v));
    }

    // upstream_version
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.upstream_version;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.upstream_version_value,
        i.upstream_version_size,
        i.upstream_version_null);
    }

    // project
    //
    {
      ::bpkg::package_name& v =
        o.project;

      pgsql::value_traits<
          ::bpkg::package_name,
          pgsql::id_string >::set_value (
        v,
        i.project_value,
        i.project_size,
        i.project_null);
    }

    // priority
    //
    {
      ::brep::package::priority_type& v =
        o.priority;

      composite_value_traits< ::brep::package::priority_type, id_pgsql >::init (
        v,
        i.priority_value,
        db);
    }

    // summary
    //
    {
      ::std::string& v =
        o.summary;

      pgsql::value_traits<
          ::std::string,
          pgsql::id_string >::set_value (
        v,
        i.summary_value,
        i.summary_size,
        i.summary_null);
    }

    // description
    //
    {
      ::butl::optional< ::brep::typed_text >& v =
        o.description;

      if (composite_value_traits< ::brep::typed_text, id_pgsql >::get_null (
            i.description_value))
        wrapper_traits< ::butl::optional< ::brep::typed_text > >::set_null (v);
      else
      {
        ::brep::typed_text& vw =
          wrapper_traits< ::butl::optional< ::brep::typed_text > >::set_ref (v);

        composite_value_traits< ::brep::typed_text, id_pgsql >::init (
          vw,
          i.description_value,
          db);
      }
    }

    // package_description
    //
    {
      ::butl::optional< ::brep::typed_text >& v =
        o.package_description;

      if (composite_value_traits< ::brep::typed_text, id_pgsql >::get_null (
            i.package_description_value))
        wrapper_traits< ::butl::optional< ::brep::typed_text > >::set_null (v);
      else
      {
        ::brep::typed_text& vw =
          wrapper_traits< ::butl::optional< ::brep::typed_text > >::set_ref (v);

        composite_value_traits< ::brep::typed_text, id_pgsql >::init (
          vw,
          i.package_description_value,
          db);
      }
    }

    // changes
    //
    {
      ::butl::optional< ::brep::typed_text >& v =
        o.changes;

      if (composite_value_traits< ::brep::typed_text, id_pgsql >::get_null (
            i.changes_value))
        wrapper_traits< ::butl::optional< ::brep::typed_text > >::set_null (v);
      else
      {
        ::brep::typed_text& vw =
          wrapper_traits< ::butl::optional< ::brep::typed_text > >::set_ref (v);

        composite_value_traits< ::brep::typed_text, id_pgsql >::init (
          vw,
          i.changes_value,
          db);
      }
    }

    // url
    //
    {
      ::butl::optional< ::bpkg::manifest_url >& v =
        o.url;

      if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::get_null (
            i.url_value))
        wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::set_null (v);
      else
      {
        ::bpkg::manifest_url& vw =
          wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::set_ref (v);

        composite_value_traits< ::bpkg::manifest_url, id_pgsql >::init (
          vw,
          i.url_value,
          db);
      }
    }

    // doc_url
    //
    {
      ::butl::optional< ::bpkg::manifest_url >& v =
        o.doc_url;

      if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::get_null (
            i.doc_url_value))
        wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::set_null (v);
      else
      {
        ::bpkg::manifest_url& vw =
          wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::set_ref (v);

        composite_value_traits< ::bpkg::manifest_url, id_pgsql >::init (
          vw,
          i.doc_url_value,
          db);
      }
    }

    // src_url
    //
    {
      ::butl::optional< ::bpkg::manifest_url >& v =
        o.src_url;

      if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::get_null (
            i.src_url_value))
        wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::set_null (v);
      else
      {
        ::bpkg::manifest_url& vw =
          wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::set_ref (v);

        composite_value_traits< ::bpkg::manifest_url, id_pgsql >::init (
          vw,
          i.src_url_value,
          db);
      }
    }

    // package_url
    //
    {
      ::butl::optional< ::bpkg::manifest_url >& v =
        o.package_url;

      if (composite_value_traits< ::bpkg::manifest_url, id_pgsql >::get_null (
            i.package_url_value))
        wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::set_null (v);
      else
      {
        ::bpkg::manifest_url& vw =
          wrapper_traits< ::butl::optional< ::bpkg::manifest_url > >::set_ref (v);

        composite_value_traits< ::bpkg::manifest_url, id_pgsql >::init (
          vw,
          i.package_url_value,
          db);
      }
    }

    // email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.email_value,
          db);
      }
    }

    // package_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.package_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.package_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.package_email_value,
          db);
      }
    }

    // build_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.build_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.build_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.build_email_value,
          db);
      }
    }

    // build_warning_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.build_warning_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.build_warning_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.build_warning_email_value,
          db);
      }
    }

    // build_error_email
    //
    {
      ::butl::optional< ::bpkg::email >& v =
        o.build_error_email;

      if (composite_value_traits< ::bpkg::email, id_pgsql >::get_null (
            i.build_error_email_value))
        wrapper_traits< ::butl::optional< ::bpkg::email > >::set_null (v);
      else
      {
        ::bpkg::email& vw =
          wrapper_traits< ::butl::optional< ::bpkg::email > >::set_ref (v);

        composite_value_traits< ::bpkg::email, id_pgsql >::init (
          vw,
          i.build_error_email_value,
          db);
      }
    }

    // internal_repository
    //
    {
      ::odb::lazy_shared_ptr< ::brep::repository >& v =
        o.internal_repository;

      typedef object_traits< ::brep::repository > obj_traits;
      typedef odb::pointer_traits< ::odb::lazy_shared_ptr< ::brep::repository > > ptr_traits;

      if (composite_value_traits< obj_traits::id_type, id_pgsql >::get_null (
            i.internal_repository_value))
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        composite_value_traits< obj_traits::id_type, id_pgsql >::init (
          ptr_id,
          i.internal_repository_value,
          db);

        v = ptr_traits::pointer_type (
          *static_cast<pgsql::database*> (db), ptr_id);
      }
    }

    // location
    //
    {
      ::butl::optional< ::butl::basic_path< char, ::butl::any_path_kind< char > > >& v =
        o.location;

      ::brep::optional_string vt;

      pgsql::value_traits<
          ::brep::optional_string,
          pgsql::id_string >::set_value (
        vt,
        i.location_value,
        i.location_size,
        i.location_null);

      // From common.hxx:105:14
      v = (vt) ? brep::path ( * (vt)) : brep::optional_path ();
    }

    // fragment
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.fragment;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.fragment_value,
        i.fragment_size,
        i.fragment_null);
    }

    // sha256sum
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.sha256sum;

      pgsql::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          pgsql::id_string >::set_value (
        v,
        i.sha256sum_value,
        i.sha256sum_size,
        i.sha256sum_null);
    }

    // buildable
    //
    {
      bool& v =
        o.buildable;

      pgsql::value_traits<
          bool,
          pgsql::id_boolean >::set_value (
        v,
        i.buildable_value,
        i.buildable_null);
    }

    // unbuildable_reason
    //
    {
      ::butl::optional< ::brep::unbuildable_reason >& v =
        o.unbuildable_reason;

      ::brep::optional_string vt;

      pgsql::value_traits<
          ::brep::optional_string,
          pgsql::id_string >::set_value (
        vt,
        i.unbuildable_reason_value,
        i.unbuildable_reason_size,
        i.unbuildable_reason_null);

      // From common.hxx:488:14
      v = (vt) ? brep::to_unbuildable_reason ( * (vt)) : brep::optional_unbuildable_reason ();
    }

    // custom_bot
    //
    {
      ::butl::optional< bool >& v =
        o.custom_bot;

      pgsql::value_traits<
          ::butl::optional< bool >,
          pgsql::id_boolean >::set_value (
        v,
        i.custom_bot_value,
        i.custom_bot_null);
    }

    // search_index
    //
    {
      // From package.hxx:980:7
      ::brep::weighted_text v;

      pgsql::value_traits<
          ::brep::weighted_text,
          pgsql::id_string >::set_value (
        v,
        i.search_index_value,
        i.search_index_size,
        i.search_index_null);

      // From package.hxx:980:7
      o.search_text (v);
    }
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    pgsql::statement_kind sk (pgsql::statement_select);
    {
      if (composite_value_traits< ::brep::package_id, id_pgsql >::init (
            i.id_value,
            id,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::brep::package, id_pgsql >::persist_statement[] =
  "INSERT INTO \"package\" "
  "(\"tenant\", "
  "\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_upstream\", "
  "\"version_release\", "
  "\"upstream_version\", "
  "\"project\", "
  "\"priority\", "
  "\"priority_comment\", "
  "\"summary\", "
  "\"description\", "
  "\"description_type\", "
  "\"package_description\", "
  "\"package_description_type\", "
  "\"changes\", "
  "\"changes_type\", "
  "\"url\", "
  "\"url_comment\", "
  "\"doc_url\", "
  "\"doc_url_comment\", "
  "\"src_url\", "
  "\"src_url_comment\", "
  "\"package_url\", "
  "\"package_url_comment\", "
  "\"email\", "
  "\"email_comment\", "
  "\"package_email\", "
  "\"package_email_comment\", "
  "\"build_email\", "
  "\"build_email_comment\", "
  "\"build_warning_email\", "
  "\"build_warning_email_comment\", "
  "\"build_error_email\", "
  "\"build_error_email_comment\", "
  "\"reviews_pass\", "
  "\"reviews_fail\", "
  "\"reviews_manifest_file\", "
  "\"internal_repository_tenant\", "
  "\"internal_repository_canonical_name\", "
  "\"location\", "
  "\"fragment\", "
  "\"sha256sum\", "
  "\"buildable\", "
  "\"unbuildable_reason\", "
  "\"custom_bot\", "
  "\"search_index\") "
  "VALUES "
  "($1, $2::CITEXT, $3, $4, $5, $6, $7, $8, $9, $10::CITEXT, $11, $12, $13, $14, $15, $16, $17, $18, $19, $20, $21, $22, $23, $24, $25, $26, $27, $28, $29, $30, $31, $32, $33, $34, $35, $36, $37, $38, $39, $40, $41, $42, $43, $44, $45, $46, $47, $48, to_tsvector($49::weighted_text))";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::find_statement[] =
  "SELECT "
  "\"package\".\"tenant\", "
  "\"package\".\"name\"::TEXT, "
  "\"package\".\"version_epoch\", "
  "\"package\".\"version_canonical_upstream\", "
  "\"package\".\"version_canonical_release\", "
  "\"package\".\"version_revision\", "
  "\"package\".\"version_upstream\", "
  "\"package\".\"version_release\", "
  "\"package\".\"upstream_version\", "
  "\"package\".\"project\"::TEXT, "
  "\"package\".\"priority\", "
  "\"package\".\"priority_comment\", "
  "\"package\".\"summary\", "
  "\"package\".\"description\", "
  "\"package\".\"description_type\", "
  "\"package\".\"package_description\", "
  "\"package\".\"package_description_type\", "
  "\"package\".\"changes\", "
  "\"package\".\"changes_type\", "
  "\"package\".\"url\", "
  "\"package\".\"url_comment\", "
  "\"package\".\"doc_url\", "
  "\"package\".\"doc_url_comment\", "
  "\"package\".\"src_url\", "
  "\"package\".\"src_url_comment\", "
  "\"package\".\"package_url\", "
  "\"package\".\"package_url_comment\", "
  "\"package\".\"email\", "
  "\"package\".\"email_comment\", "
  "\"package\".\"package_email\", "
  "\"package\".\"package_email_comment\", "
  "\"package\".\"build_email\", "
  "\"package\".\"build_email_comment\", "
  "\"package\".\"build_warning_email\", "
  "\"package\".\"build_warning_email_comment\", "
  "\"package\".\"build_error_email\", "
  "\"package\".\"build_error_email_comment\", "
  "\"package\".\"internal_repository_tenant\", "
  "\"package\".\"internal_repository_canonical_name\", "
  "\"package\".\"location\", "
  "\"package\".\"fragment\", "
  "\"package\".\"sha256sum\", "
  "\"package\".\"buildable\", "
  "\"package\".\"unbuildable_reason\", "
  "\"package\".\"custom_bot\", "
  "COALESCE('',\"package\".\"search_index\") "
  "FROM \"package\" "
  "WHERE \"package\".\"tenant\"=$1 AND \"package\".\"name\"=$2::CITEXT AND \"package\".\"version_epoch\"=$3 AND \"package\".\"version_canonical_upstream\"=$4 AND \"package\".\"version_canonical_release\"=$5 AND \"package\".\"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::update_statement[] =
  "UPDATE \"package\" "
  "SET "
  "\"version_upstream\"=$1, "
  "\"version_release\"=$2, "
  "\"upstream_version\"=$3, "
  "\"project\"=$4::CITEXT, "
  "\"priority\"=$5, "
  "\"priority_comment\"=$6, "
  "\"summary\"=$7, "
  "\"description\"=$8, "
  "\"description_type\"=$9, "
  "\"package_description\"=$10, "
  "\"package_description_type\"=$11, "
  "\"changes\"=$12, "
  "\"changes_type\"=$13, "
  "\"url\"=$14, "
  "\"url_comment\"=$15, "
  "\"doc_url\"=$16, "
  "\"doc_url_comment\"=$17, "
  "\"src_url\"=$18, "
  "\"src_url_comment\"=$19, "
  "\"package_url\"=$20, "
  "\"package_url_comment\"=$21, "
  "\"email\"=$22, "
  "\"email_comment\"=$23, "
  "\"package_email\"=$24, "
  "\"package_email_comment\"=$25, "
  "\"build_email\"=$26, "
  "\"build_email_comment\"=$27, "
  "\"build_warning_email\"=$28, "
  "\"build_warning_email_comment\"=$29, "
  "\"build_error_email\"=$30, "
  "\"build_error_email_comment\"=$31, "
  "\"internal_repository_tenant\"=$32, "
  "\"internal_repository_canonical_name\"=$33, "
  "\"location\"=$34, "
  "\"fragment\"=$35, "
  "\"sha256sum\"=$36, "
  "\"buildable\"=$37, "
  "\"unbuildable_reason\"=$38, "
  "\"custom_bot\"=$39, "
  "\"search_index\"=to_tsvector($40::weighted_text) "
  "WHERE \"tenant\"=$41 AND \"name\"=$42::CITEXT AND \"version_epoch\"=$43 AND \"version_canonical_upstream\"=$44 AND \"version_canonical_release\"=$45 AND \"version_revision\"=$46";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::erase_statement[] =
  "DELETE FROM \"package\" "
  "WHERE \"tenant\"=$1 AND \"name\"=$2::CITEXT AND \"version_epoch\"=$3 AND \"version_canonical_upstream\"=$4 AND \"version_canonical_release\"=$5 AND \"version_revision\"=$6";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::query_statement[] =
  "SELECT\n"
  "\"package\".\"tenant\",\n"
  "\"package\".\"name\"::TEXT,\n"
  "\"package\".\"version_epoch\",\n"
  "\"package\".\"version_canonical_upstream\",\n"
  "\"package\".\"version_canonical_release\",\n"
  "\"package\".\"version_revision\",\n"
  "\"package\".\"version_upstream\",\n"
  "\"package\".\"version_release\",\n"
  "\"package\".\"upstream_version\",\n"
  "\"package\".\"project\"::TEXT,\n"
  "\"package\".\"priority\",\n"
  "\"package\".\"priority_comment\",\n"
  "\"package\".\"summary\",\n"
  "\"package\".\"description\",\n"
  "\"package\".\"description_type\",\n"
  "\"package\".\"package_description\",\n"
  "\"package\".\"package_description_type\",\n"
  "\"package\".\"changes\",\n"
  "\"package\".\"changes_type\",\n"
  "\"package\".\"url\",\n"
  "\"package\".\"url_comment\",\n"
  "\"package\".\"doc_url\",\n"
  "\"package\".\"doc_url_comment\",\n"
  "\"package\".\"src_url\",\n"
  "\"package\".\"src_url_comment\",\n"
  "\"package\".\"package_url\",\n"
  "\"package\".\"package_url_comment\",\n"
  "\"package\".\"email\",\n"
  "\"package\".\"email_comment\",\n"
  "\"package\".\"package_email\",\n"
  "\"package\".\"package_email_comment\",\n"
  "\"package\".\"build_email\",\n"
  "\"package\".\"build_email_comment\",\n"
  "\"package\".\"build_warning_email\",\n"
  "\"package\".\"build_warning_email_comment\",\n"
  "\"package\".\"build_error_email\",\n"
  "\"package\".\"build_error_email_comment\",\n"
  "\"package\".\"internal_repository_tenant\",\n"
  "\"package\".\"internal_repository_canonical_name\",\n"
  "\"package\".\"location\",\n"
  "\"package\".\"fragment\",\n"
  "\"package\".\"sha256sum\",\n"
  "\"package\".\"buildable\",\n"
  "\"package\".\"unbuildable_reason\",\n"
  "\"package\".\"custom_bot\",\n"
  "COALESCE('',\"package\".\"search_index\")\n"
  "FROM \"package\"\n"
  "LEFT JOIN \"repository\" AS \"internal_repository\" ON \"internal_repository\".\"tenant\"=\"package\".\"internal_repository_tenant\" AND \"internal_repository\".\"canonical_name\"=\"package\".\"internal_repository_canonical_name\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::erase_query_statement[] =
  "DELETE FROM \"package\"";

  const char access::object_traits_impl< ::brep::package, id_pgsql >::table_name[] =
  "\"package\"";

  void access::object_traits_impl< ::brep::package, id_pgsql >::
  persist (database& db, const object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // license_alternatives
    //
    {
      ::brep::package::license_alternatives_type const& v =
        obj.license_alternatives;

      license_alternatives_traits::persist (
        v,
        esc.license_alternatives);
    }

    // licenses
    //
    {
      // From package.hxx:813:7
      ::brep::package::_licenses_type const& v =
        odb::nested_get (obj.license_alternatives);

      licenses_traits::persist (
        v,
        esc.licenses);
    }

    // topics
    //
    {
      ::butl::small_vector< ::std::basic_string< char >, 5 > const& v =
        obj.topics;

      topics_traits::persist (
        v,
        esc.topics);
    }

    // keywords
    //
    {
      ::butl::small_vector< ::std::basic_string< char >, 5 > const& v =
        obj.keywords;

      keywords_traits::persist (
        v,
        esc.keywords);
    }

    // dependencies
    //
    {
      ::brep::package::dependencies_type const& v =
        obj.dependencies;

      dependencies_traits::persist (
        v,
        esc.dependencies);
    }

    // dependency_alternatives
    //
    {
      // From package.hxx:843:7
      ::brep::package::_dependency_alternatives_type const& v =
        odb::nested_get (obj.dependencies);

      dependency_alternatives_traits::persist (
        v,
        esc.dependency_alternatives);
    }

    // dependency_alternative_dependencies
    //
    {
      // From package.hxx:857:7
      ::brep::package::_dependency_alternative_dependencies_type const& v =
        odb::nested2_get (obj.dependencies);

      dependency_alternative_dependencies_traits::persist (
        v,
        esc.dependency_alternative_dependencies);
    }

    // requirements
    //
    {
      ::brep::package::requirements_type const& v =
        obj.requirements;

      requirements_traits::persist (
        v,
        esc.requirements);
    }

    // requirement_alternatives
    //
    {
      // From package.hxx:875:7
      ::brep::requirement_alternatives_map const& v =
        odb::nested_get (obj.requirements);

      requirement_alternatives_traits::persist (
        v,
        esc.requirement_alternatives);
    }

    // requirement_alternative_requirements
    //
    {
      // From package.hxx:884:7
      ::brep::requirement_alternative_requirements_map const& v =
        odb::nested2_get (obj.requirements);

      requirement_alternative_requirements_traits::persist (
        v,
        esc.requirement_alternative_requirements);
    }

    // tests
    //
    {
      ::butl::small_vector< ::brep::test_dependency, 1 > const& v =
        obj.tests;

      tests_traits::persist (
        v,
        esc.tests);
    }

    // builds
    //
    {
      ::brep::build_class_exprs const& v =
        obj.builds;

      builds_traits::persist (
        v,
        esc.builds);
    }

    // build_constraints
    //
    {
      ::brep::package::build_constraints_type const& v =
        obj.build_constraints;

      build_constraints_traits::persist (
        v,
        esc.build_constraints);
    }

    // build_auxiliaries
    //
    {
      ::brep::package::build_auxiliaries_type const& v =
        obj.build_auxiliaries;

      build_auxiliaries_traits::persist (
        v,
        esc.build_auxiliaries);
    }

    // build_bot_keys
    //
    {
      ::brep::package_build_bot_keys const& v =
        obj.build_bot_keys;

      build_bot_keys_traits::persist (
        v,
        esc.build_bot_keys);
    }

    // build_configs
    //
    {
      ::brep::package_build_configs const& v =
        obj.build_configs;

      build_configs_traits::persist (
        v,
        esc.build_configs);
    }

    // build_config_builds
    //
    {
      // From package.hxx:925:7
      ::brep::build_class_exprs_map const& v =
        odb::nested_get (obj.build_configs, & brep::package_build_config::builds);

      build_config_builds_traits::persist (
        v,
        esc.build_config_builds);
    }

    // build_config_constraints
    //
    {
      // From package.hxx:936:7
      ::brep::build_constraints_map const& v =
        odb::nested_get (obj.build_configs, & brep::package_build_config::constraints);

      build_config_constraints_traits::persist (
        v,
        esc.build_config_constraints);
    }

    // build_config_auxiliaries
    //
    {
      // From package.hxx:947:7
      ::brep::build_auxiliaries_map const& v =
        odb::nested_get (obj.build_configs, & brep::package_build_config::auxiliaries);

      build_config_auxiliaries_traits::persist (
        v,
        esc.build_config_auxiliaries);
    }

    // build_config_bot_keys
    //
    {
      // From package.hxx:958:7
      ::brep::package_build_bot_keys_map const& v =
        odb::nested_get (obj.build_configs, & brep::package_build_config::bot_keys);

      build_config_bot_keys_traits::persist (
        v,
        esc.build_config_bot_keys);
    }

    // other_repositories
    //
    {
      ::std::vector< ::odb::lazy_shared_ptr< ::brep::repository > > const& v =
        obj.other_repositories;

      other_repositories_traits::persist (
        v,
        esc.other_repositories);
    }

    obj.build_section.reset (true, false);

    obj.unused_section.reset (true, false);

    obj.reviews_section.reset (true, false);

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace pgsql;
    using pgsql::update_statement;

    callback (db, obj, callback_event::pre_update);

    pgsql::transaction& tr (pgsql::transaction::current ());
    pgsql::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // license_alternatives
    //
    {
      ::brep::package::license_alternatives_type const& v =
        obj.license_alternatives;

      license_alternatives_traits::update (
        v,
        esc.license_alternatives);
    }

    // licenses
    //
    {
      // From package.hxx:813:7
      ::brep::package::_licenses_type const& v =
        odb::nested_get (obj.license_alternatives);

      licenses_traits::update (
        v,
        esc.licenses);
    }

    // topics
    //
    {
      ::butl::small_vector< ::std::basic_string< char >, 5 > const& v =
        obj.topics;

      topics_traits::update (
        v,
        esc.topics);
    }

    // keywords
    //
    {
      ::butl::small_vector< ::std::basic_string< char >, 5 > const& v =
        obj.keywords;

      keywords_traits::update (
        v,
        esc.keywords);
    }

    // dependencies
    //
    {
      ::brep::package::dependencies_type const& v =
        obj.dependencies;

      dependencies_traits::update (
        v,
        esc.dependencies);
    }

    // dependency_alternatives
    //
    {
      // From package.hxx:843:7
      ::brep::package::_dependency_alternatives_type const& v =
        odb::nested_get (obj.dependencies);

      dependency_alternatives_traits::update (
        v,
        esc.dependency_alternatives);
    }

    // dependency_alternative_dependencies
    //
    {
      // From package.hxx:857:7
      ::brep::package::_dependency_alternative_dependencies_type const& v =
        odb::nested2_get (obj.dependencies);

      dependency_alternative_dependencies_traits::update (
        v,
        esc.dependency_alternative_dependencies);
    }

    // requirements
    //
    {
      ::brep::package::requirements_type const& v =
        obj.requirements;

      requirements_traits::update (
        v,
        esc.requirements);
    }

    // requirement_alternatives
    //
    {
      // From package.hxx:875:7
      ::brep::requirement_alternatives_map const& v =
        odb::nested_get (obj.requirements);

      requirement_alternatives_traits::update (
        v,
        esc.requirement_alternatives);
    }

    // requirement_alternative_requirements
    //
    {
      // From package.hxx:884:7
      ::brep::requirement_alternative_requirements_map const& v =
        odb::nested2_get (obj.requirements);

      requirement_alternative_requirements_traits::update (
        v,
        esc.requirement_alternative_requirements);
    }

    // tests
    //
    {
      ::butl::small_vector< ::brep::test_dependency, 1 > const& v =
        obj.tests;

      tests_traits::update (
        v,
        esc.tests);
    }

    // other_repositories
    //
    {
      ::std::vector< ::odb::lazy_shared_ptr< ::brep::repository > > const& v =
        obj.other_repositories;

      other_repositories_traits::update (
        v,
        esc.other_repositories);
    }

    if (obj.build_section.loaded ())
    {
      build_section_traits::update (esc, obj);
    }

    if (obj.reviews_section.loaded ())
    {
      reviews_section_traits::update (esc, obj);
    }

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::
  erase (database& db, const id_type& id)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // license_alternatives
    //
    {
      license_alternatives_traits::erase (
        esc.license_alternatives);
    }

    // licenses
    //
    {
      licenses_traits::erase (
        esc.licenses);
    }

    // topics
    //
    {
      topics_traits::erase (
        esc.topics);
    }

    // keywords
    //
    {
      keywords_traits::erase (
        esc.keywords);
    }

    // dependencies
    //
    {
      dependencies_traits::erase (
        esc.dependencies);
    }

    // dependency_alternatives
    //
    {
      dependency_alternatives_traits::erase (
        esc.dependency_alternatives);
    }

    // dependency_alternative_dependencies
    //
    {
      dependency_alternative_dependencies_traits::erase (
        esc.dependency_alternative_dependencies);
    }

    // requirements
    //
    {
      requirements_traits::erase (
        esc.requirements);
    }

    // requirement_alternatives
    //
    {
      requirement_alternatives_traits::erase (
        esc.requirement_alternatives);
    }

    // requirement_alternative_requirements
    //
    {
      requirement_alternative_requirements_traits::erase (
        esc.requirement_alternative_requirements);
    }

    // tests
    //
    {
      tests_traits::erase (
        esc.tests);
    }

    // builds
    //
    {
      builds_traits::erase (
        esc.builds);
    }

    // build_constraints
    //
    {
      build_constraints_traits::erase (
        esc.build_constraints);
    }

    // build_auxiliaries
    //
    {
      build_auxiliaries_traits::erase (
        esc.build_auxiliaries);
    }

    // build_bot_keys
    //
    {
      build_bot_keys_traits::erase (
        esc.build_bot_keys);
    }

    // build_configs
    //
    {
      build_configs_traits::erase (
        esc.build_configs);
    }

    // build_config_builds
    //
    {
      build_config_builds_traits::erase (
        esc.build_config_builds);
    }

    // build_config_constraints
    //
    {
      build_config_constraints_traits::erase (
        esc.build_config_constraints);
    }

    // build_config_auxiliaries
    //
    {
      build_config_auxiliaries_traits::erase (
        esc.build_config_auxiliaries);
    }

    // build_config_bot_keys
    //
    {
      build_config_bot_keys_traits::erase (
        esc.build_config_bot_keys);
    }

    // other_repositories
    //
    {
      other_repositories_traits::erase (
        esc.other_repositories);
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::brep::package, id_pgsql >::pointer_type
  access::object_traits_impl< ::brep::package, id_pgsql >::
  find (database& db, const id_type& id)
  {
    using namespace pgsql;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::
  reload (database& db, object_type& obj)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::
  load (connection& conn, object_type& obj, section& s)
  {
    using namespace pgsql;

    pgsql::connection& c (static_cast<pgsql::connection&> (conn));
    statements_type& sts (c.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    bool r (false);

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    if (!r && &s == &obj.build_section)
    {
      build_section_traits::load (esc, obj);
      r = true;
    }

    if (!r && &s == &obj.unused_section)
    {
      unused_section_traits::load (esc, obj);
      r = true;
    }

    if (!r && &s == &obj.reviews_section)
    {
      reviews_section_traits::load (esc, obj);
      r = true;
    }

    sts.load_delayed (0);
    l.unlock ();
    return r;
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::
  update (connection& conn, const object_type& obj, const section& s)
  {
    using namespace pgsql;

    pgsql::connection& c (static_cast<pgsql::connection&> (conn));
    statements_type& sts (c.statement_cache ().find_object<object_type> ());
    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (&s == &obj.build_section)build_section_traits::update (esc, obj);
    else if (&s == &obj.unused_section)unused_section_traits::update (esc, obj);
    else if (&s == &obj.reviews_section)reviews_section_traits::update (esc, obj);
    else
      return false;

    return true;
  }

  bool access::object_traits_impl< ::brep::package, id_pgsql >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace pgsql;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::brep::package, id_pgsql >::
  load_ (statements_type& sts,
         object_type& obj,
         bool reload)
  {
    ODB_POTENTIALLY_UNUSED (reload);

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // license_alternatives
    //
    {
      ::brep::package::license_alternatives_type& v =
        obj.license_alternatives;

      license_alternatives_traits::load (
        v,
        esc.license_alternatives);
    }

    // licenses
    //
    {
      ::brep::package::_licenses_type v;

      licenses_traits::load (
        v,
        esc.licenses);

      // From package.hxx:814:7
      odb::nested_set (obj.license_alternatives, std::move (v));
    }

    // topics
    //
    {
      ::butl::small_vector< ::std::basic_string< char >, 5 >& v =
        obj.topics;

      topics_traits::load (
        v,
        esc.topics);
    }

    // keywords
    //
    {
      ::butl::small_vector< ::std::basic_string< char >, 5 >& v =
        obj.keywords;

      keywords_traits::load (
        v,
        esc.keywords);
    }

    // dependencies
    //
    {
      ::brep::package::dependencies_type& v =
        obj.dependencies;

      dependencies_traits::load (
        v,
        esc.dependencies);
    }

    // dependency_alternatives
    //
    {
      ::brep::package::_dependency_alternatives_type v;

      dependency_alternatives_traits::load (
        v,
        esc.dependency_alternatives);

      // From package.hxx:844:7
      odb::nested_set (obj.dependencies, std::move (v));
    }

    // dependency_alternative_dependencies
    //
    {
      ::brep::package::_dependency_alternative_dependencies_type v;

      dependency_alternative_dependencies_traits::load (
        v,
        esc.dependency_alternative_dependencies);

      // From package.hxx:858:7
      odb::nested2_set (obj.dependencies, std::move (v));
    }

    // requirements
    //
    {
      ::brep::package::requirements_type& v =
        obj.requirements;

      requirements_traits::load (
        v,
        esc.requirements);
    }

    // requirement_alternatives
    //
    {
      ::brep::requirement_alternatives_map v;

      requirement_alternatives_traits::load (
        v,
        esc.requirement_alternatives);

      // From package.hxx:876:7
      odb::nested_set (obj.requirements, std::move (v));
    }

    // requirement_alternative_requirements
    //
    {
      ::brep::requirement_alternative_requirements_map v;

      requirement_alternative_requirements_traits::load (
        v,
        esc.requirement_alternative_requirements);

      // From package.hxx:885:7
      odb::nested2_set (obj.requirements, std::move (v));
    }

    // tests
    //
    {
      ::butl::small_vector< ::brep::test_dependency, 1 >& v =
        obj.tests;

      tests_traits::load (
        v,
        esc.tests);
    }

    // other_repositories
    //
    {
      ::std::vector< ::odb::lazy_shared_ptr< ::brep::repository > >& v =
        obj.other_repositories;

      other_repositories_traits::load (
        v,
        esc.other_repositories);
    }

    if (reload)
    {
      if (obj.build_section.loaded ())
      {
        build_section_traits::load (esc, obj);
        obj.build_section.reset (true, false);
      }
    }
    else
      obj.build_section.reset ();

    if (reload)
    {
      if (obj.unused_section.loaded ())
      {
        unused_section_traits::load (esc, obj);
        obj.unused_section.reset (true, false);
      }
    }
    else
      obj.unused_section.reset ();

    if (reload)
    {
      if (obj.reviews_section.loaded ())
      {
        reviews_section_traits::load (esc, obj);
        obj.reviews_section.reset (true, false);
      }
    }
    else
      obj.reviews_section.reset ();
  }

  result< access::object_traits_impl< ::brep::package, id_pgsql >::object_type >
  access::object_traits_impl< ::brep::package, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += "\n";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        text,
        true,
        true,
        q.parameter_types (),
        q.parameter_count (),
        q.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) pgsql::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::brep::package, id_pgsql >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace pgsql;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      erase_query_statement_name,
      text,
      q.parameter_types (),
      q.parameter_count (),
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::brep::package, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += "\n";
      text += q.clause ();
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        text,
        true,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::brep::package, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // package_count
  //

  const char access::view_traits_impl< ::brep::package_count, id_pgsql >::
  query_statement_name[] = "query_brep_package_count";

  bool access::view_traits_impl< ::brep::package_count, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = 0;

    return grew;
  }

  void access::view_traits_impl< ::brep::package_count, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::brep::package_count, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::brep::package_count, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::package_count, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "count(\"package\".\"tenant\") ");

    r += "FROM \"package\"";

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::brep::package_count, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::package_count, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::package_count, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::package_count, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // latest_package_search_rank
  //

  const char access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::
  query_statement_name[] = "query_brep_latest_package_search_rank";

  bool access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::package_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // rank
    //
    t[6UL] = 0;

    return grew;
  }

  void access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // id
    //
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
    n += 6UL;

    // rank
    //
    b[n].type = pgsql::bind::double_;
    b[n].buffer = &i.rank_value;
    b[n].is_null = &i.rank_null;
    n++;
  }

  void access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::package_id& v =
        o.id;

      composite_value_traits< ::brep::package_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // rank
    //
    {
      double& v =
        o.rank;

      pgsql::value_traits<
          double,
          pgsql::id_double >::set_value (
        v,
        i.rank_value,
        i.rank_null);
    }
  }

  access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT * FROM search_latest_packages" + q);
    return r;
  }

  result< access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::latest_package_search_rank, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // latest_package_count
  //

  const char access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::
  query_statement_name[] = "query_brep_latest_package_count";

  bool access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = 0;

    return grew;
  }

  void access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT count(*) FROM search_latest_packages" + q);
    return r;
  }

  result< access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::latest_package_count, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // package_search_rank
  //

  const char access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::
  query_statement_name[] = "query_brep_package_search_rank";

  bool access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::package_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // rank
    //
    t[6UL] = 0;

    return grew;
  }

  void access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // id
    //
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
    n += 6UL;

    // rank
    //
    b[n].type = pgsql::bind::double_;
    b[n].buffer = &i.rank_value;
    b[n].is_null = &i.rank_null;
    n++;
  }

  void access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::package_id& v =
        o.id;

      composite_value_traits< ::brep::package_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }

    // rank
    //
    {
      double& v =
        o.rank;

      pgsql::value_traits<
          double,
          pgsql::id_double >::set_value (
        v,
        i.rank_value,
        i.rank_null);
    }
  }

  access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT * FROM search_packages" + q);
    return r;
  }

  result< access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::package_search_rank, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // package_search_count
  //

  const char access::view_traits_impl< ::brep::package_search_count, id_pgsql >::
  query_statement_name[] = "query_brep_package_search_count";

  bool access::view_traits_impl< ::brep::package_search_count, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = 0;

    return grew;
  }

  void access::view_traits_impl< ::brep::package_search_count, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = pgsql::bind::bigint;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::brep::package_search_count, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      pgsql::value_traits<
          ::std::size_t,
          pgsql::id_bigint >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::brep::package_search_count, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::package_search_count, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT count(*) FROM search_packages" + q);
    return r;
  }

  result< access::view_traits_impl< ::brep::package_search_count, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::package_search_count, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::package_search_count, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::package_search_count, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // latest_package
  //

  const char access::view_traits_impl< ::brep::latest_package, id_pgsql >::
  query_statement_name[] = "query_brep_latest_package";

  bool access::view_traits_impl< ::brep::latest_package, id_pgsql >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::brep::package_id, id_pgsql >::grow (
          i.id_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::brep::latest_package, id_pgsql >::
  bind (pgsql::bind* b,
        image_type& i)
  {
    using namespace pgsql;

    pgsql::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // id
    //
    composite_value_traits< ::brep::package_id, id_pgsql >::bind (
      b + n, i.id_value, sk);
    n += 6UL;
  }

  void access::view_traits_impl< ::brep::latest_package, id_pgsql >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::brep::package_id& v =
        o.id;

      composite_value_traits< ::brep::package_id, id_pgsql >::init (
        v,
        i.id_value,
        db);
    }
  }

  access::view_traits_impl< ::brep::latest_package, id_pgsql >::query_base_type
  access::view_traits_impl< ::brep::latest_package, id_pgsql >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT * FROM latest_package" + q);
    return r;
  }

  result< access::view_traits_impl< ::brep::latest_package, id_pgsql >::view_type >
  access::view_traits_impl< ::brep::latest_package, id_pgsql >::
  query (database& db, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      pgsql::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        sts.connection (),
        query_statement_name,
        qs.clause (),
        false,
        true,
        qs.parameter_types (),
        qs.parameter_count (),
        qs.parameters_binding (),
        imb));

    st->execute ();
    st->deallocate ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) pgsql::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::brep::latest_package, id_pgsql >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::connection& conn (
      static_cast<pgsql::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<pgsql::prepared_query_impl> r (
      new (shared) pgsql::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        sts.connection (),
        n,
        r->query.clause (),
        false,
        true,
        r->query.parameter_types (),
        r->query.parameter_count (),
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::brep::latest_package, id_pgsql >::
  execute_query (prepared_query_impl& q)
  {
    using namespace pgsql;
    using odb::details::shared;
    using odb::details::shared_ptr;

    pgsql::prepared_query_impl& pq (
      static_cast<pgsql::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    pgsql::transaction& tr (pgsql::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) pgsql::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }
}

namespace odb
{
  static bool
  create_schema (database& db, unsigned short pass, bool drop)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (drop);

    if (drop)
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("DROP TABLE IF EXISTS \"package_other_repositories\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_build_config_bot_keys\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_build_config_auxiliaries\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_build_config_constraints\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_build_config_builds\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_build_configs\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_build_bot_keys\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_build_auxiliaries\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_build_constraints\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_builds\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_tests\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_requirement_alternative_requirements\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_requirement_alternatives\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_requirements\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_dependency_alternative_dependencies\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_dependency_alternatives\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_dependencies\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_keywords\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_topics\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_licenses\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package_license_alternatives\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"package\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"public_key\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"repository_prerequisites\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"repository_complements\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"repository\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"tenant\" CASCADE");
          db.execute ("DROP TABLE IF EXISTS \"schema_version\"");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("CREATE TABLE \"tenant\" (\n"
                      "  \"id\" TEXT NOT NULL PRIMARY KEY,\n"
                      "  \"private\" BOOLEAN NOT NULL,\n"
                      "  \"interactive\" TEXT NULL,\n"
                      "  \"creation_timestamp\" BIGINT NOT NULL,\n"
                      "  \"archived\" BOOLEAN NOT NULL,\n"
                      "  \"service_id\" TEXT NULL,\n"
                      "  \"service_type\" TEXT NULL,\n"
                      "  \"service_ref_count\" BIGINT NULL,\n"
                      "  \"service_data\" TEXT NULL,\n"
                      "  \"unloaded_timestamp\" BIGINT NULL,\n"
                      "  \"unloaded_notify_interval\" BIGINT NULL,\n"
                      "  \"queued_timestamp\" BIGINT NULL,\n"
                      "  \"build_toolchain_name\" TEXT NULL,\n"
                      "  \"build_toolchain_version_epoch\" INTEGER NULL,\n"
                      "  \"build_toolchain_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"build_toolchain_version_canonical_release\" TEXT NULL,\n"
                      "  \"build_toolchain_version_revision\" INTEGER NULL,\n"
                      "  \"build_toolchain_version_upstream\" TEXT NULL,\n"
                      "  \"build_toolchain_version_release\" TEXT NULL)");
          db.execute ("CREATE UNIQUE INDEX \"tenant_service_i\"\n"
                      "  ON \"tenant\" (\n"
                      "    \"service_id\",\n"
                      "    \"service_type\")");
          db.execute ("CREATE INDEX \"tenant_service_id_i\"\n"
                      "  ON \"tenant\" (\"service_id\")");
          db.execute ("CREATE INDEX \"tenant_unloaded_timestamp_i\"\n"
                      "  ON \"tenant\" (\"unloaded_timestamp\")");
          db.execute ("CREATE TABLE \"repository\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"canonical_name\" TEXT NOT NULL,\n"
                      "  \"location_url\" TEXT NOT NULL,\n"
                      "  \"location_type\" TEXT NOT NULL,\n"
                      "  \"display_name\" TEXT NOT NULL,\n"
                      "  \"priority\" INTEGER NOT NULL,\n"
                      "  \"interface_url\" TEXT NULL,\n"
                      "  \"email\" TEXT NULL,\n"
                      "  \"email_comment\" TEXT NULL,\n"
                      "  \"summary\" TEXT NULL,\n"
                      "  \"description\" TEXT NULL,\n"
                      "  \"cache_location_url\" TEXT NOT NULL,\n"
                      "  \"cache_location_type\" TEXT NOT NULL,\n"
                      "  \"certificate_fingerprint\" TEXT NULL,\n"
                      "  \"certificate_name\" TEXT NULL,\n"
                      "  \"certificate_organization\" TEXT NULL,\n"
                      "  \"certificate_email\" TEXT NULL,\n"
                      "  \"certificate_pem\" TEXT NULL,\n"
                      "  \"packages_timestamp\" BIGINT NOT NULL,\n"
                      "  \"repositories_timestamp\" BIGINT NOT NULL,\n"
                      "  \"internal\" BOOLEAN NOT NULL,\n"
                      "  \"buildable\" BOOLEAN NOT NULL,\n"
                      "  PRIMARY KEY (\"tenant\",\n"
                      "               \"canonical_name\"),\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE TABLE \"repository_complements\" (\n"
                      "  \"repository_tenant\" TEXT NOT NULL,\n"
                      "  \"repository_canonical_name\" TEXT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"complement_tenant\" TEXT NOT NULL,\n"
                      "  \"complement_canonical_name\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"repository_tenant_fk\"\n"
                      "    FOREIGN KEY (\"repository_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"repository_fk\"\n"
                      "    FOREIGN KEY (\"repository_tenant\",\n"
                      "                 \"repository_canonical_name\")\n"
                      "    REFERENCES \"repository\" (\"tenant\",\n"
                      "                             \"canonical_name\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"complement_tenant_fk\"\n"
                      "    FOREIGN KEY (\"complement_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"complement_fk\"\n"
                      "    FOREIGN KEY (\"complement_tenant\",\n"
                      "                 \"complement_canonical_name\")\n"
                      "    REFERENCES \"repository\" (\"tenant\",\n"
                      "                             \"canonical_name\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"repository_complements_repository_i\"\n"
                      "  ON \"repository_complements\" (\n"
                      "    \"repository_tenant\",\n"
                      "    \"repository_canonical_name\")");
          db.execute ("CREATE INDEX \"repository_complements_index_i\"\n"
                      "  ON \"repository_complements\" (\"index\")");
          db.execute ("CREATE TABLE \"repository_prerequisites\" (\n"
                      "  \"repository_tenant\" TEXT NOT NULL,\n"
                      "  \"repository_canonical_name\" TEXT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"prerequisite_tenant\" TEXT NOT NULL,\n"
                      "  \"prerequisite_canonical_name\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"repository_tenant_fk\"\n"
                      "    FOREIGN KEY (\"repository_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"repository_fk\"\n"
                      "    FOREIGN KEY (\"repository_tenant\",\n"
                      "                 \"repository_canonical_name\")\n"
                      "    REFERENCES \"repository\" (\"tenant\",\n"
                      "                             \"canonical_name\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"prerequisite_tenant_fk\"\n"
                      "    FOREIGN KEY (\"prerequisite_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"prerequisite_fk\"\n"
                      "    FOREIGN KEY (\"prerequisite_tenant\",\n"
                      "                 \"prerequisite_canonical_name\")\n"
                      "    REFERENCES \"repository\" (\"tenant\",\n"
                      "                             \"canonical_name\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"repository_prerequisites_repository_i\"\n"
                      "  ON \"repository_prerequisites\" (\n"
                      "    \"repository_tenant\",\n"
                      "    \"repository_canonical_name\")");
          db.execute ("CREATE INDEX \"repository_prerequisites_index_i\"\n"
                      "  ON \"repository_prerequisites\" (\"index\")");
          db.execute ("CREATE TABLE \"public_key\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"fingerprint\" TEXT NOT NULL,\n"
                      "  \"data\" TEXT NOT NULL,\n"
                      "  PRIMARY KEY (\"tenant\",\n"
                      "               \"fingerprint\"),\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE TABLE \"package\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"version_upstream\" TEXT NOT NULL,\n"
                      "  \"version_release\" TEXT NULL,\n"
                      "  \"upstream_version\" TEXT NULL,\n"
                      "  \"project\" CITEXT NOT NULL,\n"
                      "  \"priority\" INTEGER NOT NULL,\n"
                      "  \"priority_comment\" TEXT NOT NULL,\n"
                      "  \"summary\" TEXT NOT NULL,\n"
                      "  \"description\" TEXT NULL,\n"
                      "  \"description_type\" TEXT NULL,\n"
                      "  \"package_description\" TEXT NULL,\n"
                      "  \"package_description_type\" TEXT NULL,\n"
                      "  \"changes\" TEXT NULL,\n"
                      "  \"changes_type\" TEXT NULL,\n"
                      "  \"url\" TEXT NULL,\n"
                      "  \"url_comment\" TEXT NULL,\n"
                      "  \"doc_url\" TEXT NULL,\n"
                      "  \"doc_url_comment\" TEXT NULL,\n"
                      "  \"src_url\" TEXT NULL,\n"
                      "  \"src_url_comment\" TEXT NULL,\n"
                      "  \"package_url\" TEXT NULL,\n"
                      "  \"package_url_comment\" TEXT NULL,\n"
                      "  \"email\" TEXT NULL,\n"
                      "  \"email_comment\" TEXT NULL,\n"
                      "  \"package_email\" TEXT NULL,\n"
                      "  \"package_email_comment\" TEXT NULL,\n"
                      "  \"build_email\" TEXT NULL,\n"
                      "  \"build_email_comment\" TEXT NULL,\n"
                      "  \"build_warning_email\" TEXT NULL,\n"
                      "  \"build_warning_email_comment\" TEXT NULL,\n"
                      "  \"build_error_email\" TEXT NULL,\n"
                      "  \"build_error_email_comment\" TEXT NULL,\n"
                      "  \"reviews_pass\" BIGINT NULL,\n"
                      "  \"reviews_fail\" BIGINT NULL,\n"
                      "  \"reviews_manifest_file\" TEXT NULL,\n"
                      "  \"internal_repository_tenant\" TEXT NULL,\n"
                      "  \"internal_repository_canonical_name\" TEXT NULL,\n"
                      "  \"location\" TEXT NULL,\n"
                      "  \"fragment\" TEXT NULL,\n"
                      "  \"sha256sum\" TEXT NULL,\n"
                      "  \"buildable\" BOOLEAN NOT NULL,\n"
                      "  \"unbuildable_reason\" TEXT NULL,\n"
                      "  \"custom_bot\" BOOLEAN NULL,\n"
                      "  \"search_index\" tsvector NULL,\n"
                      "  PRIMARY KEY (\"tenant\",\n"
                      "               \"name\",\n"
                      "               \"version_epoch\",\n"
                      "               \"version_canonical_upstream\",\n"
                      "               \"version_canonical_release\",\n"
                      "               \"version_revision\"),\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"internal_repository_tenant_fk\"\n"
                      "    FOREIGN KEY (\"internal_repository_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"internal_repository_fk\"\n"
                      "    FOREIGN KEY (\"internal_repository_tenant\",\n"
                      "                 \"internal_repository_canonical_name\")\n"
                      "    REFERENCES \"repository\" (\"tenant\",\n"
                      "                             \"canonical_name\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"package_search_index_i\"\n"
                      "  ON \"package\" USING GIN (\"search_index\")");
          db.execute ("CREATE TABLE \"package_license_alternatives\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"comment\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_license_alternatives_object_id_i\"\n"
                      "  ON \"package_license_alternatives\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_license_alternatives_index_i\"\n"
                      "  ON \"package_license_alternatives\" (\"index\")");
          db.execute ("CREATE TABLE \"package_licenses\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"alternative_index\" BIGINT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"license\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_licenses_object_id_i\"\n"
                      "  ON \"package_licenses\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE TABLE \"package_topics\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"topic\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_topics_object_id_i\"\n"
                      "  ON \"package_topics\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_topics_index_i\"\n"
                      "  ON \"package_topics\" (\"index\")");
          db.execute ("CREATE TABLE \"package_keywords\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"keyword\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_keywords_object_id_i\"\n"
                      "  ON \"package_keywords\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_keywords_index_i\"\n"
                      "  ON \"package_keywords\" (\"index\")");
          db.execute ("CREATE TABLE \"package_dependencies\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"buildtime\" BOOLEAN NOT NULL,\n"
                      "  \"comment\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_dependencies_object_id_i\"\n"
                      "  ON \"package_dependencies\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_dependencies_index_i\"\n"
                      "  ON \"package_dependencies\" (\"index\")");
          db.execute ("CREATE TABLE \"package_dependency_alternatives\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"dependency_index\" BIGINT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"enable\" TEXT NULL,\n"
                      "  \"reflect\" TEXT NULL,\n"
                      "  \"prefer\" TEXT NULL,\n"
                      "  \"accept\" TEXT NULL,\n"
                      "  \"require\" TEXT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_dependency_alternatives_object_id_i\"\n"
                      "  ON \"package_dependency_alternatives\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE TABLE \"package_dependency_alternative_dependencies\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"dependency_index\" BIGINT NOT NULL,\n"
                      "  \"alternative_index\" BIGINT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"dep_name\" CITEXT NOT NULL,\n"
                      "  \"dep_min_version_epoch\" INTEGER NULL,\n"
                      "  \"dep_min_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"dep_min_version_canonical_release\" TEXT NULL,\n"
                      "  \"dep_min_version_revision\" INTEGER NULL,\n"
                      "  \"dep_min_version_upstream\" TEXT NULL,\n"
                      "  \"dep_min_version_release\" TEXT NULL,\n"
                      "  \"dep_max_version_epoch\" INTEGER NULL,\n"
                      "  \"dep_max_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"dep_max_version_canonical_release\" TEXT NULL,\n"
                      "  \"dep_max_version_revision\" INTEGER NULL,\n"
                      "  \"dep_max_version_upstream\" TEXT NULL,\n"
                      "  \"dep_max_version_release\" TEXT NULL,\n"
                      "  \"dep_min_open\" BOOLEAN NULL,\n"
                      "  \"dep_max_open\" BOOLEAN NULL,\n"
                      "  \"dep_package_tenant\" TEXT NULL,\n"
                      "  \"dep_package_name\" CITEXT NULL,\n"
                      "  \"dep_package_version_epoch\" INTEGER NULL,\n"
                      "  \"dep_package_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"dep_package_version_canonical_release\" TEXT NULL COLLATE \"C\",\n"
                      "  \"dep_package_version_revision\" INTEGER NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"dep_package_tenant_fk\"\n"
                      "    FOREIGN KEY (\"dep_package_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"dep_package_fk\"\n"
                      "    FOREIGN KEY (\"dep_package_tenant\",\n"
                      "                 \"dep_package_name\",\n"
                      "                 \"dep_package_version_epoch\",\n"
                      "                 \"dep_package_version_canonical_upstream\",\n"
                      "                 \"dep_package_version_canonical_release\",\n"
                      "                 \"dep_package_version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"package_dependency_alternative_dependencies_object_id_i\"\n"
                      "  ON \"package_dependency_alternative_dependencies\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE TABLE \"package_requirements\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"buildtime\" BOOLEAN NOT NULL,\n"
                      "  \"comment\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_requirements_object_id_i\"\n"
                      "  ON \"package_requirements\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_requirements_index_i\"\n"
                      "  ON \"package_requirements\" (\"index\")");
          db.execute ("CREATE TABLE \"package_requirement_alternatives\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"requirement_index\" BIGINT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"enable\" TEXT NULL,\n"
                      "  \"reflect\" TEXT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_requirement_alternatives_object_id_i\"\n"
                      "  ON \"package_requirement_alternatives\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE TABLE \"package_requirement_alternative_requirements\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"requirement_index\" BIGINT NOT NULL,\n"
                      "  \"alternative_index\" BIGINT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"id\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_requirement_alternative_requirements_object_id_i\"\n"
                      "  ON \"package_requirement_alternative_requirements\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE TABLE \"package_tests\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"test_name\" CITEXT NOT NULL,\n"
                      "  \"test_min_version_epoch\" INTEGER NULL,\n"
                      "  \"test_min_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"test_min_version_canonical_release\" TEXT NULL,\n"
                      "  \"test_min_version_revision\" INTEGER NULL,\n"
                      "  \"test_min_version_upstream\" TEXT NULL,\n"
                      "  \"test_min_version_release\" TEXT NULL,\n"
                      "  \"test_max_version_epoch\" INTEGER NULL,\n"
                      "  \"test_max_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"test_max_version_canonical_release\" TEXT NULL,\n"
                      "  \"test_max_version_revision\" INTEGER NULL,\n"
                      "  \"test_max_version_upstream\" TEXT NULL,\n"
                      "  \"test_max_version_release\" TEXT NULL,\n"
                      "  \"test_min_open\" BOOLEAN NULL,\n"
                      "  \"test_max_open\" BOOLEAN NULL,\n"
                      "  \"test_package_tenant\" TEXT NULL,\n"
                      "  \"test_package_name\" CITEXT NULL,\n"
                      "  \"test_package_version_epoch\" INTEGER NULL,\n"
                      "  \"test_package_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"test_package_version_canonical_release\" TEXT NULL COLLATE \"C\",\n"
                      "  \"test_package_version_revision\" INTEGER NULL,\n"
                      "  \"test_type\" TEXT NOT NULL,\n"
                      "  \"test_buildtime\" BOOLEAN NOT NULL,\n"
                      "  \"test_enable\" TEXT NULL,\n"
                      "  \"test_reflect\" TEXT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"test_package_tenant_fk\"\n"
                      "    FOREIGN KEY (\"test_package_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"test_package_fk\"\n"
                      "    FOREIGN KEY (\"test_package_tenant\",\n"
                      "                 \"test_package_name\",\n"
                      "                 \"test_package_version_epoch\",\n"
                      "                 \"test_package_version_canonical_upstream\",\n"
                      "                 \"test_package_version_canonical_release\",\n"
                      "                 \"test_package_version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"package_tests_object_id_i\"\n"
                      "  ON \"package_tests\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_tests_index_i\"\n"
                      "  ON \"package_tests\" (\"index\")");
          db.execute ("CREATE TABLE \"package_builds\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"expression\" TEXT NOT NULL,\n"
                      "  \"comment\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_builds_object_id_i\"\n"
                      "  ON \"package_builds\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_builds_index_i\"\n"
                      "  ON \"package_builds\" (\"index\")");
          db.execute ("CREATE TABLE \"package_build_constraints\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"exclusion\" BOOLEAN NOT NULL,\n"
                      "  \"config\" TEXT NOT NULL,\n"
                      "  \"target\" TEXT NULL,\n"
                      "  \"comment\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_build_constraints_object_id_i\"\n"
                      "  ON \"package_build_constraints\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_build_constraints_index_i\"\n"
                      "  ON \"package_build_constraints\" (\"index\")");
          db.execute ("CREATE TABLE \"package_build_auxiliaries\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"environment_name\" TEXT NOT NULL,\n"
                      "  \"config\" TEXT NOT NULL,\n"
                      "  \"comment\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_build_auxiliaries_object_id_i\"\n"
                      "  ON \"package_build_auxiliaries\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_build_auxiliaries_index_i\"\n"
                      "  ON \"package_build_auxiliaries\" (\"index\")");
          db.execute ("CREATE TABLE \"package_build_bot_keys\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"key_tenant\" TEXT NOT NULL,\n"
                      "  \"key_fingerprint\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"key_tenant_fk\"\n"
                      "    FOREIGN KEY (\"key_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"key_fk\"\n"
                      "    FOREIGN KEY (\"key_tenant\",\n"
                      "                 \"key_fingerprint\")\n"
                      "    REFERENCES \"public_key\" (\"tenant\",\n"
                      "                             \"fingerprint\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"package_build_bot_keys_object_id_i\"\n"
                      "  ON \"package_build_bot_keys\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_build_bot_keys_index_i\"\n"
                      "  ON \"package_build_bot_keys\" (\"index\")");
          db.execute ("CREATE TABLE \"package_build_configs\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"config_name\" TEXT NOT NULL,\n"
                      "  \"config_arguments\" TEXT NOT NULL,\n"
                      "  \"config_comment\" TEXT NOT NULL,\n"
                      "  \"config_email\" TEXT NULL,\n"
                      "  \"config_email_comment\" TEXT NULL,\n"
                      "  \"config_warning_email\" TEXT NULL,\n"
                      "  \"config_warning_email_comment\" TEXT NULL,\n"
                      "  \"config_error_email\" TEXT NULL,\n"
                      "  \"config_error_email_comment\" TEXT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_build_configs_object_id_i\"\n"
                      "  ON \"package_build_configs\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_build_configs_index_i\"\n"
                      "  ON \"package_build_configs\" (\"index\")");
          db.execute ("CREATE TABLE \"package_build_config_builds\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"config_index\" BIGINT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"expression\" TEXT NOT NULL,\n"
                      "  \"comment\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_build_config_builds_object_id_i\"\n"
                      "  ON \"package_build_config_builds\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE TABLE \"package_build_config_constraints\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"config_index\" BIGINT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"exclusion\" BOOLEAN NOT NULL,\n"
                      "  \"config\" TEXT NOT NULL,\n"
                      "  \"target\" TEXT NULL,\n"
                      "  \"comment\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_build_config_constraints_object_id_i\"\n"
                      "  ON \"package_build_config_constraints\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE TABLE \"package_build_config_auxiliaries\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"config_index\" BIGINT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"environment_name\" TEXT NOT NULL,\n"
                      "  \"config\" TEXT NOT NULL,\n"
                      "  \"comment\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"package_build_config_auxiliaries_object_id_i\"\n"
                      "  ON \"package_build_config_auxiliaries\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE TABLE \"package_build_config_bot_keys\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"config_index\" BIGINT NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"key_tenant\" TEXT NOT NULL,\n"
                      "  \"key_fingerprint\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"key_tenant_fk\"\n"
                      "    FOREIGN KEY (\"key_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"key_fk\"\n"
                      "    FOREIGN KEY (\"key_tenant\",\n"
                      "                 \"key_fingerprint\")\n"
                      "    REFERENCES \"public_key\" (\"tenant\",\n"
                      "                             \"fingerprint\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"package_build_config_bot_keys_object_id_i\"\n"
                      "  ON \"package_build_config_bot_keys\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE TABLE \"package_other_repositories\" (\n"
                      "  \"tenant\" TEXT NOT NULL,\n"
                      "  \"name\" CITEXT NOT NULL,\n"
                      "  \"version_epoch\" INTEGER NOT NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NOT NULL,\n"
                      "  \"version_canonical_release\" TEXT NOT NULL COLLATE \"C\",\n"
                      "  \"version_revision\" INTEGER NOT NULL,\n"
                      "  \"index\" BIGINT NOT NULL,\n"
                      "  \"repository_tenant\" TEXT NOT NULL,\n"
                      "  \"repository_canonical_name\" TEXT NOT NULL,\n"
                      "  CONSTRAINT \"tenant_fk\"\n"
                      "    FOREIGN KEY (\"tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"tenant\",\n"
                      "                 \"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\")\n"
                      "    REFERENCES \"package\" (\"tenant\",\n"
                      "                          \"name\",\n"
                      "                          \"version_epoch\",\n"
                      "                          \"version_canonical_upstream\",\n"
                      "                          \"version_canonical_release\",\n"
                      "                          \"version_revision\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"repository_tenant_fk\"\n"
                      "    FOREIGN KEY (\"repository_tenant\")\n"
                      "    REFERENCES \"tenant\" (\"id\")\n"
                      "    INITIALLY DEFERRED,\n"
                      "  CONSTRAINT \"repository_fk\"\n"
                      "    FOREIGN KEY (\"repository_tenant\",\n"
                      "                 \"repository_canonical_name\")\n"
                      "    REFERENCES \"repository\" (\"tenant\",\n"
                      "                             \"canonical_name\")\n"
                      "    INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"package_other_repositories_object_id_i\"\n"
                      "  ON \"package_other_repositories\" (\n"
                      "    \"tenant\",\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\")");
          db.execute ("CREATE INDEX \"package_other_repositories_index_i\"\n"
                      "  ON \"package_other_repositories\" (\"index\")");
          return true;
        }
        case 2:
        {
          db.execute ("CREATE TABLE \"schema_version\" (\n"
                      "  \"name\" TEXT NOT NULL PRIMARY KEY,\n"
                      "  \"version\" BIGINT NOT NULL,\n"
                      "  \"migration\" BOOLEAN NOT NULL)");
          db.execute ("INSERT INTO \"schema_version\" (\n"
                      "  \"name\", \"version\", \"migration\")\n"
                      "  VALUES ('package', 36, FALSE)");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_create_entry
  create_schema_entry_ (
    id_pgsql,
    "package",
    &create_schema);

  static const schema_catalog_migrate_entry
  migrate_schema_entry_34_ (
    id_pgsql,
    "package",
    34ULL,
    0);

  static bool
  migrate_schema_35 (database& db, unsigned short pass, bool pre)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (pre);

    if (pre)
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("ALTER TABLE \"package\"\n"
                      "  ADD COLUMN \"reviews_pass\" BIGINT NULL,\n"
                      "  ADD COLUMN \"reviews_fail\" BIGINT NULL,\n"
                      "  ADD COLUMN \"reviews_manifest_file\" TEXT NULL");
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"schema_version\"\n"
                      "  SET \"version\" = 35, \"migration\" = TRUE\n"
                      "  WHERE \"name\" = 'package'");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"schema_version\"\n"
                      "  SET \"migration\" = FALSE\n"
                      "  WHERE \"name\" = 'package'");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_migrate_entry
  migrate_schema_entry_35_ (
    id_pgsql,
    "package",
    35ULL,
    &migrate_schema_35);

  static bool
  migrate_schema_36 (database& db, unsigned short pass, bool pre)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (pre);

    if (pre)
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("ALTER TABLE \"tenant\"\n"
                      "  ADD COLUMN \"service_ref_count\" BIGINT NULL");
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"schema_version\"\n"
                      "  SET \"version\" = 36, \"migration\" = TRUE\n"
                      "  WHERE \"name\" = 'package'");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"schema_version\"\n"
                      "  SET \"migration\" = FALSE\n"
                      "  WHERE \"name\" = 'package'");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_migrate_entry
  migrate_schema_entry_36_ (
    id_pgsql,
    "package",
    36ULL,
    &migrate_schema_36);
}

#include <odb/post.hxx>
