// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <load/types-parsers.hxx>
//
// End prologue.

#include <load/load-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace cli
{
  // unknown_option
  //
  unknown_option::
  ~unknown_option () noexcept
  {
  }

  void unknown_option::
  print (::std::ostream& os) const
  {
    os << "unknown option '" << option ().c_str () << "'";
  }

  const char* unknown_option::
  what () const noexcept
  {
    return "unknown option";
  }

  // unknown_argument
  //
  unknown_argument::
  ~unknown_argument () noexcept
  {
  }

  void unknown_argument::
  print (::std::ostream& os) const
  {
    os << "unknown argument '" << argument ().c_str () << "'";
  }

  const char* unknown_argument::
  what () const noexcept
  {
    return "unknown argument";
  }

  // missing_value
  //
  missing_value::
  ~missing_value () noexcept
  {
  }

  void missing_value::
  print (::std::ostream& os) const
  {
    os << "missing value for option '" << option ().c_str () << "'";
  }

  const char* missing_value::
  what () const noexcept
  {
    return "missing option value";
  }

  // invalid_value
  //
  invalid_value::
  ~invalid_value () noexcept
  {
  }

  void invalid_value::
  print (::std::ostream& os) const
  {
    os << "invalid value '" << value ().c_str () << "' for option '"
       << option ().c_str () << "'";

    if (!message ().empty ())
      os << ": " << message ().c_str ();
  }

  const char* invalid_value::
  what () const noexcept
  {
    return "invalid option value";
  }

  // eos_reached
  //
  void eos_reached::
  print (::std::ostream& os) const
  {
    os << what ();
  }

  const char* eos_reached::
  what () const noexcept
  {
    return "end of argument stream reached";
  }

  // scanner
  //
  scanner::
  ~scanner ()
  {
  }

  // argv_scanner
  //
  bool argv_scanner::
  more ()
  {
    return i_ < argc_;
  }

  const char* argv_scanner::
  peek ()
  {
    if (i_ < argc_)
      return argv_[i_];
    else
      throw eos_reached ();
  }

  const char* argv_scanner::
  next ()
  {
    if (i_ < argc_)
    {
      const char* r (argv_[i_]);

      if (erase_)
      {
        for (int i (i_ + 1); i < argc_; ++i)
          argv_[i - 1] = argv_[i];

        --argc_;
        argv_[argc_] = 0;
      }
      else
        ++i_;

      ++start_position_;
      return r;
    }
    else
      throw eos_reached ();
  }

  void argv_scanner::
  skip ()
  {
    if (i_ < argc_)
    {
      ++i_;
      ++start_position_;
    }
    else
      throw eos_reached ();
  }

  std::size_t argv_scanner::
  position ()
  {
    return start_position_;
  }

  template <typename X>
  struct parser
  {
    static void
    parse (X& x, bool& xs, scanner& s)
    {
      using namespace std;

      const char* o (s.next ());
      if (s.more ())
      {
        string v (s.next ());
        istringstream is (v);
        if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
          throw invalid_value (o, v);
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <>
  struct parser<bool>
  {
    static void
    parse (bool& x, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
      {
        const char* v (s.next ());

        if (std::strcmp (v, "1")    == 0 ||
            std::strcmp (v, "true") == 0 ||
            std::strcmp (v, "TRUE") == 0 ||
            std::strcmp (v, "True") == 0)
          x = true;
        else if (std::strcmp (v, "0")     == 0 ||
                 std::strcmp (v, "false") == 0 ||
                 std::strcmp (v, "FALSE") == 0 ||
                 std::strcmp (v, "False") == 0)
          x = false;
        else
          throw invalid_value (o, v);
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <>
  struct parser<std::string>
  {
    static void
    parse (std::string& x, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
        x = s.next ();
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename X>
  struct parser<std::pair<X, std::size_t> >
  {
    static void
    parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
    {
      x.second = s.position ();
      parser<X>::parse (x.first, xs, s);
    }
  };

  template <typename X>
  struct parser<std::vector<X> >
  {
    static void
    parse (std::vector<X>& c, bool& xs, scanner& s)
    {
      X x;
      bool dummy;
      parser<X>::parse (x, dummy, s);
      c.push_back (x);
      xs = true;
    }
  };

  template <typename X, typename C>
  struct parser<std::set<X, C> >
  {
    static void
    parse (std::set<X, C>& c, bool& xs, scanner& s)
    {
      X x;
      bool dummy;
      parser<X>::parse (x, dummy, s);
      c.insert (x);
      xs = true;
    }
  };

  template <typename K, typename V, typename C>
  struct parser<std::map<K, V, C> >
  {
    static void
    parse (std::map<K, V, C>& m, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
      {
        std::size_t pos (s.position ());
        std::string ov (s.next ());
        std::string::size_type p = ov.find ('=');

        K k = K ();
        V v = V ();
        std::string kstr (ov, 0, p);
        std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

        int ac (2);
        char* av[] =
        {
          const_cast<char*> (o),
          0
        };

        bool dummy;
        if (!kstr.empty ())
        {
          av[1] = const_cast<char*> (kstr.c_str ());
          argv_scanner s (0, ac, av, false, pos);
          parser<K>::parse (k, dummy, s);
        }

        if (!vstr.empty ())
        {
          av[1] = const_cast<char*> (vstr.c_str ());
          argv_scanner s (0, ac, av, false, pos);
          parser<V>::parse (v, dummy, s);
        }

        m[k] = v;
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename K, typename V, typename C>
  struct parser<std::multimap<K, V, C> >
  {
    static void
    parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
      {
        std::size_t pos (s.position ());
        std::string ov (s.next ());
        std::string::size_type p = ov.find ('=');

        K k = K ();
        V v = V ();
        std::string kstr (ov, 0, p);
        std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

        int ac (2);
        char* av[] =
        {
          const_cast<char*> (o),
          0
        };

        bool dummy;
        if (!kstr.empty ())
        {
          av[1] = const_cast<char*> (kstr.c_str ());
          argv_scanner s (0, ac, av, false, pos);
          parser<K>::parse (k, dummy, s);
        }

        if (!vstr.empty ())
        {
          av[1] = const_cast<char*> (vstr.c_str ());
          argv_scanner s (0, ac, av, false, pos);
          parser<V>::parse (v, dummy, s);
        }

        m.insert (typename std::multimap<K, V, C>::value_type (k, v));
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename X, typename T, T X::*M>
  void
  thunk (X& x, scanner& s)
  {
    parser<T>::parse (x.*M, s);
  }

  template <typename X, bool X::*M>
  void
  thunk (X& x, scanner& s)
  {
    s.next ();
    x.*M = true;
  }

  template <typename X, typename T, T X::*M, bool X::*S>
  void
  thunk (X& x, scanner& s)
  {
    parser<T>::parse (x.*M, x.*S, s);
  }
}

#include <map>

// options
//

options::
options ()
: ignore_unknown_ (),
  force_ (),
  shallow_ (),
  ignore_unresolv_tests_ (),
  ignore_unresolv_cond_ (),
  ignore_unresolv_cond_specified_ (false),
  tenant_ (),
  tenant_specified_ (false),
  existing_tenant_ (),
  private__ (),
  interactive_ (),
  interactive_specified_ (false),
  service_id_ (),
  service_id_specified_ (false),
  service_type_ (),
  service_type_specified_ (false),
  service_data_ (),
  service_data_specified_ (false),
  metadata_ (),
  metadata_specified_ (false),
  metadata_changed_ (),
  overrides_file_ (),
  overrides_file_specified_ (false),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ ("brep_package"),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  bpkg_ ("bpkg"),
  bpkg_specified_ (false),
  bpkg_option_ (),
  bpkg_option_specified_ (false),
  openssl_ ("openssl"),
  openssl_specified_ (false),
  openssl_option_ (),
  openssl_option_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
}

options::
options (int& argc,
         char** argv,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: ignore_unknown_ (),
  force_ (),
  shallow_ (),
  ignore_unresolv_tests_ (),
  ignore_unresolv_cond_ (),
  ignore_unresolv_cond_specified_ (false),
  tenant_ (),
  tenant_specified_ (false),
  existing_tenant_ (),
  private__ (),
  interactive_ (),
  interactive_specified_ (false),
  service_id_ (),
  service_id_specified_ (false),
  service_type_ (),
  service_type_specified_ (false),
  service_data_ (),
  service_data_specified_ (false),
  metadata_ (),
  metadata_specified_ (false),
  metadata_changed_ (),
  overrides_file_ (),
  overrides_file_specified_ (false),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ ("brep_package"),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  bpkg_ ("bpkg"),
  bpkg_specified_ (false),
  bpkg_option_ (),
  bpkg_option_specified_ (false),
  openssl_ ("openssl"),
  openssl_specified_ (false),
  openssl_option_ (),
  openssl_option_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  ::cli::argv_scanner s (argc, argv, erase);
  _parse (s, opt, arg);
}

options::
options (int start,
         int& argc,
         char** argv,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: ignore_unknown_ (),
  force_ (),
  shallow_ (),
  ignore_unresolv_tests_ (),
  ignore_unresolv_cond_ (),
  ignore_unresolv_cond_specified_ (false),
  tenant_ (),
  tenant_specified_ (false),
  existing_tenant_ (),
  private__ (),
  interactive_ (),
  interactive_specified_ (false),
  service_id_ (),
  service_id_specified_ (false),
  service_type_ (),
  service_type_specified_ (false),
  service_data_ (),
  service_data_specified_ (false),
  metadata_ (),
  metadata_specified_ (false),
  metadata_changed_ (),
  overrides_file_ (),
  overrides_file_specified_ (false),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ ("brep_package"),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  bpkg_ ("bpkg"),
  bpkg_specified_ (false),
  bpkg_option_ (),
  bpkg_option_specified_ (false),
  openssl_ ("openssl"),
  openssl_specified_ (false),
  openssl_option_ (),
  openssl_option_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  ::cli::argv_scanner s (start, argc, argv, erase);
  _parse (s, opt, arg);
}

options::
options (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: ignore_unknown_ (),
  force_ (),
  shallow_ (),
  ignore_unresolv_tests_ (),
  ignore_unresolv_cond_ (),
  ignore_unresolv_cond_specified_ (false),
  tenant_ (),
  tenant_specified_ (false),
  existing_tenant_ (),
  private__ (),
  interactive_ (),
  interactive_specified_ (false),
  service_id_ (),
  service_id_specified_ (false),
  service_type_ (),
  service_type_specified_ (false),
  service_data_ (),
  service_data_specified_ (false),
  metadata_ (),
  metadata_specified_ (false),
  metadata_changed_ (),
  overrides_file_ (),
  overrides_file_specified_ (false),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ ("brep_package"),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  bpkg_ ("bpkg"),
  bpkg_specified_ (false),
  bpkg_option_ (),
  bpkg_option_specified_ (false),
  openssl_ ("openssl"),
  openssl_specified_ (false),
  openssl_option_ (),
  openssl_option_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  ::cli::argv_scanner s (argc, argv, erase);
  _parse (s, opt, arg);
  end = s.end ();
}

options::
options (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: ignore_unknown_ (),
  force_ (),
  shallow_ (),
  ignore_unresolv_tests_ (),
  ignore_unresolv_cond_ (),
  ignore_unresolv_cond_specified_ (false),
  tenant_ (),
  tenant_specified_ (false),
  existing_tenant_ (),
  private__ (),
  interactive_ (),
  interactive_specified_ (false),
  service_id_ (),
  service_id_specified_ (false),
  service_type_ (),
  service_type_specified_ (false),
  service_data_ (),
  service_data_specified_ (false),
  metadata_ (),
  metadata_specified_ (false),
  metadata_changed_ (),
  overrides_file_ (),
  overrides_file_specified_ (false),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ ("brep_package"),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  bpkg_ ("bpkg"),
  bpkg_specified_ (false),
  bpkg_option_ (),
  bpkg_option_specified_ (false),
  openssl_ ("openssl"),
  openssl_specified_ (false),
  openssl_option_ (),
  openssl_option_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  ::cli::argv_scanner s (start, argc, argv, erase);
  _parse (s, opt, arg);
  end = s.end ();
}

options::
options (::cli::scanner& s,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: ignore_unknown_ (),
  force_ (),
  shallow_ (),
  ignore_unresolv_tests_ (),
  ignore_unresolv_cond_ (),
  ignore_unresolv_cond_specified_ (false),
  tenant_ (),
  tenant_specified_ (false),
  existing_tenant_ (),
  private__ (),
  interactive_ (),
  interactive_specified_ (false),
  service_id_ (),
  service_id_specified_ (false),
  service_type_ (),
  service_type_specified_ (false),
  service_data_ (),
  service_data_specified_ (false),
  metadata_ (),
  metadata_specified_ (false),
  metadata_changed_ (),
  overrides_file_ (),
  overrides_file_specified_ (false),
  db_user_ (),
  db_user_specified_ (false),
  db_password_ (),
  db_password_specified_ (false),
  db_name_ ("brep_package"),
  db_name_specified_ (false),
  db_host_ (),
  db_host_specified_ (false),
  db_port_ (0),
  db_port_specified_ (false),
  bpkg_ ("bpkg"),
  bpkg_specified_ (false),
  bpkg_option_ (),
  bpkg_option_specified_ (false),
  openssl_ ("openssl"),
  openssl_specified_ (false),
  openssl_option_ (),
  openssl_option_specified_ (false),
  pager_ (),
  pager_specified_ (false),
  pager_option_ (),
  pager_option_specified_ (false),
  help_ (),
  version_ ()
{
  _parse (s, opt, arg);
}

::cli::usage_para options::
print_usage (::std::ostream& os, ::cli::usage_para p)
{
  CLI_POTENTIALLY_UNUSED (os);

  if (p != ::cli::usage_para::none)
    os << ::std::endl;

  os << "\033[1mOPTIONS\033[0m" << ::std::endl;

  os << std::endl
     << "\033[1m--ignore-unknown\033[0m           Ignore unknown manifest entries." << ::std::endl;

  os << std::endl
     << "\033[1m--force\033[0m                    Reload package information regardless of the" << ::std::endl
     << "                           repository manifest file timestamps." << ::std::endl;

  os << std::endl
     << "\033[1m--shallow\033[0m                  Don't load package information from prerequisite or" << ::std::endl
     << "                           complement repositories, don't fail if unable to" << ::std::endl
     << "                           resolve a package dependency, and don't detect" << ::std::endl
     << "                           package dependency cycles." << ::std::endl;

  os << std::endl
     << "\033[1m--ignore-unresolv-tests\033[0m    Ignore tests, examples, and benchmarks package" << ::std::endl
     << "                           manifest entries which cannot be resolved from the" << ::std::endl
     << "                           main package's complement repositories, recursively." << ::std::endl
     << "                           Note that in contrast to --shallow option, such" << ::std::endl
     << "                           entries will be removed from the main package" << ::std::endl
     << "                           manifests outright." << ::std::endl;

  os << std::endl
     << "\033[1m--ignore-unresolv-cond\033[0m \033[4mpkg\033[0m Ignore conditional package dependencies which cannot" << ::std::endl
     << "                           be resolved. The valid \033[4mpkg\033[0m values are \033[1mall\033[0m and \033[1mtests\033[0m." << ::std::endl
     << "                           If \033[1mall\033[0m is specified, then unresolved conditional" << ::std::endl
     << "                           dependencies are ignored in all packages. If \033[1mtests\033[0m" << ::std::endl
     << "                           is specified, then unresolved conditional" << ::std::endl
     << "                           dependencies are only ignored in external tests," << ::std::endl
     << "                           examples, and benchmarks packages." << ::std::endl;

  os << std::endl
     << "\033[1m--tenant\033[0m \033[4mid\033[0m                Tenant the package and repository information should" << ::std::endl
     << "                           be loaded in. If not specified, then the" << ::std::endl
     << "                           single-tenant mode is assumed." << ::std::endl;

  os << std::endl
     << "\033[1m--existing-tenant\033[0m          Load the repository and package information into the" << ::std::endl
     << "                           already created empty tenant rather than into the" << ::std::endl
     << "                           newly created one. Requires the \033[1m--tenant\033[0m option to" << ::std::endl
     << "                           be specified." << ::std::endl;

  os << std::endl
     << "\033[1m--private\033[0m                  Display the tenant packages in the web interface" << ::std::endl
     << "                           only in the tenant view mode." << ::std::endl;

  os << std::endl
     << "\033[1m--interactive\033[0m \033[4mbkp\033[0m          Build the tenant packages interactively, stopping" << ::std::endl
     << "                           builds at the specified breakpoint. Implies" << ::std::endl
     << "                           \033[1m--private\033[0m." << ::std::endl;

  os << std::endl
     << "\033[1m--service-id\033[0m \033[4mid\033[0m            Third party service information to associate with" << ::std::endl
     << "                           the being created tenant. Requires the \033[1m--tenant\033[0m and" << ::std::endl
     << "                           \033[1m--service-type\033[0m options to be specified." << ::std::endl;

  os << std::endl
     << "\033[1m--service-type\033[0m \033[4mtype\033[0m        Type of the service to associate with the being" << ::std::endl
     << "                           created tenant. Requires the \033[1m--service-id\033[0m option to" << ::std::endl
     << "                           be specified." << ::std::endl;

  os << std::endl
     << "\033[1m--service-data\033[0m \033[4mdata\033[0m        Service data to associate with the being created" << ::std::endl
     << "                           tenant. Requires the \033[1m--service-id\033[0m option to be" << ::std::endl
     << "                           specified." << ::std::endl;

  os << std::endl
     << "\033[1m--metadata\033[0m \033[4mdir\033[0m             Directory where the package metadata manifest files" << ::std::endl
     << "                           are located. If specified, then (re-)load the" << ::std::endl
     << "                           metadata if the package information is also" << ::std::endl
     << "                           (re-)loaded or update it if the \033[1m--metadata-changed\033[0m" << ::std::endl
     << "                           option is specified." << ::std::endl
     << ::std::endl
     << "                           The subdirectory hierarchy under this directory is" << ::std::endl
     << "                           expected to be in the following form:" << ::std::endl
     << ::std::endl
     << "                           <project>/<package>/<version>/" << ::std::endl;

  os << std::endl
     << "\033[1m--metadata-changed\033[0m         Update the package metadata even if the package" << ::std::endl
     << "                           information is not reloaded." << ::std::endl;

  os << std::endl
     << "\033[1m--overrides-file\033[0m \033[4mfile\033[0m      Read package manifest overrides from the specified" << ::std::endl
     << "                           manifest fragment file and apply them to packages" << ::std::endl
     << "                           being loaded." << ::std::endl;

  os << std::endl
     << "\033[1m--db-user\033[0m|\033[1m-u\033[0m \033[4muser\033[0m          Database user name. If not specified, then operating" << ::std::endl
     << "                           system (login) name is used." << ::std::endl;

  os << std::endl
     << "\033[1m--db-password\033[0m \033[4mpass\033[0m         Database password. If not specified, then login" << ::std::endl
     << "                           without password is expected to work." << ::std::endl;

  os << std::endl
     << "\033[1m--db-name\033[0m|\033[1m-n\033[0m \033[4mname\033[0m          Database name. If not specified, then \033[1mbrep_package\033[0m" << ::std::endl
     << "                           is used by default." << ::std::endl;

  os << std::endl
     << "\033[1m--db-host\033[0m|\033[1m-h\033[0m \033[4mhost\033[0m          Database host name, address, or socket. If not" << ::std::endl
     << "                           specified, then connect to \033[1mlocalhost\033[0m using the" << ::std::endl
     << "                           operating system-default mechanism (Unix-domain" << ::std::endl
     << "                           socket, etc)." << ::std::endl;

  os << std::endl
     << "\033[1m--db-port\033[0m|\033[1m-p\033[0m \033[4mport\033[0m          Database port number. If not specified, the default" << ::std::endl
     << "                           port is used." << ::std::endl;

  os << std::endl
     << "\033[1m--bpkg\033[0m \033[4mpath\033[0m                The package manager program to be used to fetch" << ::std::endl
     << "                           repository information. This should be the path to" << ::std::endl
     << "                           the \033[1mbpkg\033[0m executable. You can also specify additional" << ::std::endl
     << "                           options that should be passed to the package manager" << ::std::endl
     << "                           program with \033[1m--bpkg-option\033[0m. If the package manager" << ::std::endl
     << "                           program is not explicitly specified, then \033[1mbrep-load\033[0m" << ::std::endl
     << "                           will use \033[1mbpkg\033[0m by default." << ::std::endl;

  os << std::endl
     << "\033[1m--bpkg-option\033[0m \033[4mopt\033[0m          Additional option to be passed to the package" << ::std::endl
     << "                           manager program. See \033[1m--bpkg\033[0m for more information on" << ::std::endl
     << "                           the package manager program. Repeat this option to" << ::std::endl
     << "                           specify multiple package manager options." << ::std::endl;

  os << std::endl
     << "\033[1m--openssl\033[0m \033[4mpath\033[0m             The openssl program to be used for crypto" << ::std::endl
     << "                           operations. You can also specify additional options" << ::std::endl
     << "                           that should be passed to the openssl program with" << ::std::endl
     << "                           \033[1mopenssl-option\033[0m. If the openssl program is not" << ::std::endl
     << "                           explicitly specified, then \033[1mbrep-load\033[0m will use" << ::std::endl
     << "                           \033[1mopenssl\033[0m by default." << ::std::endl;

  os << std::endl
     << "\033[1m--openssl-option\033[0m \033[4mopt\033[0m       Additional option to be passed to the openssl" << ::std::endl
     << "                           program (see \033[1mopenssl\033[0m for details). Repeat this" << ::std::endl
     << "                           option to specify multiple openssl options." << ::std::endl;

  os << std::endl
     << "\033[1m--pager\033[0m \033[4mpath\033[0m               The pager program to be used to show long text." << ::std::endl
     << "                           Commonly used pager programs are \033[1mless\033[0m and \033[1mmore\033[0m. You" << ::std::endl
     << "                           can also specify additional options that should be" << ::std::endl
     << "                           passed to the pager program with \033[1m--pager-option\033[0m. If" << ::std::endl
     << "                           an empty string is specified as the pager program," << ::std::endl
     << "                           then no pager will be used. If the pager program is" << ::std::endl
     << "                           not explicitly specified, then \033[1mbrep-load\033[0m will try to" << ::std::endl
     << "                           use \033[1mless\033[0m. If it is not available, then no pager will" << ::std::endl
     << "                           be used." << ::std::endl;

  os << std::endl
     << "\033[1m--pager-option\033[0m \033[4mopt\033[0m         Additional option to be passed to the pager program." << ::std::endl
     << "                           See \033[1m--pager\033[0m for more information on the pager" << ::std::endl
     << "                           program. Repeat this option to specify multiple" << ::std::endl
     << "                           pager options." << ::std::endl;

  os << std::endl
     << "\033[1m--help\033[0m                     Print usage information and exit." << ::std::endl;

  os << std::endl
     << "\033[1m--version\033[0m                  Print version and exit." << ::std::endl;

  p = ::cli::usage_para::option;

  return p;
}

typedef
std::map<std::string, void (*) (options&, ::cli::scanner&)>
_cli_options_map;

static _cli_options_map _cli_options_map_;

struct _cli_options_map_init
{
  _cli_options_map_init ()
  {
    _cli_options_map_["--ignore-unknown"] =
    &::cli::thunk< options, &options::ignore_unknown_ >;
    _cli_options_map_["--force"] =
    &::cli::thunk< options, &options::force_ >;
    _cli_options_map_["--shallow"] =
    &::cli::thunk< options, &options::shallow_ >;
    _cli_options_map_["--ignore-unresolv-tests"] =
    &::cli::thunk< options, &options::ignore_unresolv_tests_ >;
    _cli_options_map_["--ignore-unresolv-cond"] =
    &::cli::thunk< options, brep::ignore_unresolved_conditional_dependencies, &options::ignore_unresolv_cond_,
      &options::ignore_unresolv_cond_specified_ >;
    _cli_options_map_["--tenant"] =
    &::cli::thunk< options, std::string, &options::tenant_,
      &options::tenant_specified_ >;
    _cli_options_map_["--existing-tenant"] =
    &::cli::thunk< options, &options::existing_tenant_ >;
    _cli_options_map_["--private"] =
    &::cli::thunk< options, &options::private__ >;
    _cli_options_map_["--interactive"] =
    &::cli::thunk< options, std::string, &options::interactive_,
      &options::interactive_specified_ >;
    _cli_options_map_["--service-id"] =
    &::cli::thunk< options, std::string, &options::service_id_,
      &options::service_id_specified_ >;
    _cli_options_map_["--service-type"] =
    &::cli::thunk< options, std::string, &options::service_type_,
      &options::service_type_specified_ >;
    _cli_options_map_["--service-data"] =
    &::cli::thunk< options, std::string, &options::service_data_,
      &options::service_data_specified_ >;
    _cli_options_map_["--metadata"] =
    &::cli::thunk< options, brep::dir_path, &options::metadata_,
      &options::metadata_specified_ >;
    _cli_options_map_["--metadata-changed"] =
    &::cli::thunk< options, &options::metadata_changed_ >;
    _cli_options_map_["--overrides-file"] =
    &::cli::thunk< options, brep::path, &options::overrides_file_,
      &options::overrides_file_specified_ >;
    _cli_options_map_["--db-user"] =
    &::cli::thunk< options, std::string, &options::db_user_,
      &options::db_user_specified_ >;
    _cli_options_map_["-u"] =
    &::cli::thunk< options, std::string, &options::db_user_,
      &options::db_user_specified_ >;
    _cli_options_map_["--db-password"] =
    &::cli::thunk< options, std::string, &options::db_password_,
      &options::db_password_specified_ >;
    _cli_options_map_["--db-name"] =
    &::cli::thunk< options, std::string, &options::db_name_,
      &options::db_name_specified_ >;
    _cli_options_map_["-n"] =
    &::cli::thunk< options, std::string, &options::db_name_,
      &options::db_name_specified_ >;
    _cli_options_map_["--db-host"] =
    &::cli::thunk< options, std::string, &options::db_host_,
      &options::db_host_specified_ >;
    _cli_options_map_["-h"] =
    &::cli::thunk< options, std::string, &options::db_host_,
      &options::db_host_specified_ >;
    _cli_options_map_["--db-port"] =
    &::cli::thunk< options, std::uint16_t, &options::db_port_,
      &options::db_port_specified_ >;
    _cli_options_map_["-p"] =
    &::cli::thunk< options, std::uint16_t, &options::db_port_,
      &options::db_port_specified_ >;
    _cli_options_map_["--bpkg"] =
    &::cli::thunk< options, brep::path, &options::bpkg_,
      &options::bpkg_specified_ >;
    _cli_options_map_["--bpkg-option"] =
    &::cli::thunk< options, brep::strings, &options::bpkg_option_,
      &options::bpkg_option_specified_ >;
    _cli_options_map_["--openssl"] =
    &::cli::thunk< options, brep::path, &options::openssl_,
      &options::openssl_specified_ >;
    _cli_options_map_["--openssl-option"] =
    &::cli::thunk< options, brep::strings, &options::openssl_option_,
      &options::openssl_option_specified_ >;
    _cli_options_map_["--pager"] =
    &::cli::thunk< options, std::string, &options::pager_,
      &options::pager_specified_ >;
    _cli_options_map_["--pager-option"] =
    &::cli::thunk< options, std::vector<std::string>, &options::pager_option_,
      &options::pager_option_specified_ >;
    _cli_options_map_["--help"] =
    &::cli::thunk< options, &options::help_ >;
    _cli_options_map_["--version"] =
    &::cli::thunk< options, &options::version_ >;
  }
};

static _cli_options_map_init _cli_options_map_init_;

bool options::
_parse (const char* o, ::cli::scanner& s)
{
  _cli_options_map::const_iterator i (_cli_options_map_.find (o));

  if (i != _cli_options_map_.end ())
  {
    (*(i->second)) (*this, s);
    return true;
  }

  return false;
}

bool options::
_parse (::cli::scanner& s,
        ::cli::unknown_mode opt_mode,
        ::cli::unknown_mode arg_mode)
{
  // Can't skip combined flags (--no-combined-flags).
  //
  assert (opt_mode != ::cli::unknown_mode::skip);

  bool r = false;
  bool opt = true;

  while (s.more ())
  {
    const char* o = s.peek ();

    if (std::strcmp (o, "--") == 0)
    {
      opt = false;
      s.skip ();
      r = true;
      continue;
    }

    if (opt)
    {
      if (_parse (o, s))
      {
        r = true;
        continue;
      }

      if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
      {
        // Handle combined option values.
        //
        std::string co;
        if (const char* v = std::strchr (o, '='))
        {
          co.assign (o, 0, v - o);
          ++v;

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (co.c_str ()),
            const_cast<char*> (v)
          };

          ::cli::argv_scanner ns (0, ac, av);

          if (_parse (co.c_str (), ns))
          {
            // Parsed the option but not its value?
            //
            if (ns.end () != 2)
              throw ::cli::invalid_value (co, v);

            s.next ();
            r = true;
            continue;
          }
          else
          {
            // Set the unknown option and fall through.
            //
            o = co.c_str ();
          }
        }

        // Handle combined flags.
        //
        char cf[3];
        {
          const char* p = o + 1;
          for (; *p != '\0'; ++p)
          {
            if (!((*p >= 'a' && *p <= 'z') ||
                  (*p >= 'A' && *p <= 'Z') ||
                  (*p >= '0' && *p <= '9')))
              break;
          }

          if (*p == '\0')
          {
            for (p = o + 1; *p != '\0'; ++p)
            {
              std::strcpy (cf, "-");
              cf[1] = *p;
              cf[2] = '\0';

              int ac (1);
              char* av[] =
              {
                cf
              };

              ::cli::argv_scanner ns (0, ac, av);

              if (!_parse (cf, ns))
                break;
            }

            if (*p == '\0')
            {
              // All handled.
              //
              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = cf;
            }
          }
        }

        switch (opt_mode)
        {
          case ::cli::unknown_mode::skip:
          {
            s.skip ();
            r = true;
            continue;
          }
          case ::cli::unknown_mode::stop:
          {
            break;
          }
          case ::cli::unknown_mode::fail:
          {
            throw ::cli::unknown_option (o);
          }
        }

        break;
      }
    }

    switch (arg_mode)
    {
      case ::cli::unknown_mode::skip:
      {
        s.skip ();
        r = true;
        continue;
      }
      case ::cli::unknown_mode::stop:
      {
        break;
      }
      case ::cli::unknown_mode::fail:
      {
        throw ::cli::unknown_argument (o);
      }
    }

    break;
  }

  return r;
}

::cli::usage_para
print_usage (::std::ostream& os, ::cli::usage_para p)
{
  CLI_POTENTIALLY_UNUSED (os);

  if (p != ::cli::usage_para::none)
    os << ::std::endl;

  os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1mbrep-load --help\033[0m" << ::std::endl
     << "\033[1mbrep-load --version\033[0m" << ::std::endl
     << "\033[1mbrep-load\033[0m [\033[4moptions\033[0m] \033[4mloadtab\033[0m\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1mDESCRIPTION\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1mbrep-load\033[0m reads the list of repositories from the specified \033[4mloadtab\033[0m" << ::std::endl
     << "configuration file, fetches their manifest files, and loads the repository and" << ::std::endl
     << "package information into the \033[1mpackage\033[0m database, suitable for consumption by the" << ::std::endl
     << "\033[1mbrep\033[0m web module." << ::std::endl
     << ::std::endl
     << "Note that \033[1mbrep-load\033[0m expects the \033[1mpackage\033[0m database schema to have already been" << ::std::endl
     << "created using \033[1mbrep-migrate(1)\033[0m." << ::std::endl
     << ::std::endl
     << "Also note that \033[1mbrep-load\033[0m requires \033[1mbpkg(1)\033[0m to fetch repository information. See" << ::std::endl
     << "\033[1m--bpkg\033[0m for more information on the package manager program." << ::std::endl;

  p = ::options::print_usage (os, ::cli::usage_para::text);

  if (p != ::cli::usage_para::none)
    os << ::std::endl;

  os << "\033[1mEXIT STATUS\033[0m" << ::std::endl
     << ::std::endl
     << "\033[1m0\033[0m" << ::std::endl
     << "    Success." << ::std::endl
     << "\033[1m1\033[0m" << ::std::endl
     << "    Fatal error." << ::std::endl
     << "\033[1m2\033[0m" << ::std::endl
     << "    An instance of \033[1mbrep-load\033[0m or some other \033[1mbrep\033[0m utility is already running. Try" << ::std::endl
     << "    again." << ::std::endl
     << "\033[1m3\033[0m" << ::std::endl
     << "    Recoverable database error. Try again." << ::std::endl;

  p = ::cli::usage_para::text;

  return p;
}

// Begin epilogue.
//
//
// End epilogue.

