// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#include <odb/pre.hxx>

#include <bpkg/package-odb.hxx>

#include <cassert>
#include <cstring>  // std::memcpy

#include <odb/schema-catalog-impl.hxx>

#include <odb/sqlite/traits.hxx>
#include <odb/sqlite/database.hxx>
#include <odb/sqlite/transaction.hxx>
#include <odb/sqlite/connection.hxx>
#include <odb/sqlite/statement.hxx>
#include <odb/sqlite/statement-cache.hxx>
#include <odb/sqlite/simple-object-statements.hxx>
#include <odb/sqlite/view-statements.hxx>
#include <odb/sqlite/section-statements.hxx>
#include <odb/sqlite/container-statements.hxx>
#include <odb/sqlite/exceptions.hxx>
#include <odb/sqlite/prepared-query.hxx>
#include <odb/sqlite/simple-object-result.hxx>
#include <odb/sqlite/view-result.hxx>

namespace odb
{
  // language
  //

  bool access::composite_value_traits< ::bpkg::language, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // impl
    //
    t[1UL] = false;

    return grew;
  }

  void access::composite_value_traits< ::bpkg::language, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.name_value.data ();
    b[n].size = &i.name_size;
    b[n].capacity = i.name_value.capacity ();
    b[n].is_null = &i.name_null;
    n++;

    // impl
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.impl_value;
    b[n].is_null = &i.impl_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::language, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // name
    //
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t cap (i.name_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.name_value,
        i.name_size,
        is_null,
        v);
      i.name_null = is_null;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // impl
    //
    {
      bool const& v =
        o.impl;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.impl_value,
        is_null,
        v);
      i.impl_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::language, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // impl
    //
    {
      bool& v =
        o.impl;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.impl_value,
        i.impl_null);
    }
  }

  // version_constraint
  //

  bool access::composite_value_traits< ::bpkg::version_constraint, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // min_version
    //
    if (composite_value_traits< ::bpkg::_version, id_sqlite >::grow (
          i.min_version_value, t + 0UL))
      grew = true;

    // max_version
    //
    if (composite_value_traits< ::bpkg::_version, id_sqlite >::grow (
          i.max_version_value, t + 7UL))
      grew = true;

    // min_open
    //
    t[14UL] = false;

    // max_open
    //
    t[15UL] = false;

    return grew;
  }

  void access::composite_value_traits< ::bpkg::version_constraint, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // min_version
    //
    composite_value_traits< ::bpkg::_version, id_sqlite >::bind (
      b + n, i.min_version_value, sk);
    n += 7UL;

    // max_version
    //
    composite_value_traits< ::bpkg::_version, id_sqlite >::bind (
      b + n, i.max_version_value, sk);
    n += 7UL;

    // min_open
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.min_open_value;
    b[n].is_null = &i.min_open_null;
    n++;

    // max_open
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.max_open_value;
    b[n].is_null = &i.max_open_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::version_constraint, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // min_version
    //
    {
      ::butl::optional< ::bpkg::version > const& v =
        o.min_version;

      // From package-common.hxx:230:14
      ::bpkg::_optional_version const& vt =
        (v) ? bpkg::_version 
      {
         (v)->epoch, (v)->canonical_upstream, (v)->canonical_release, (v)->revision, (v)->iteration, (v)->upstream, (v)->release 
      } : bpkg::_optional_version ();

      if (wrapper_traits< ::bpkg::_optional_version >::get_null (vt))
        composite_value_traits< ::bpkg::_version, id_sqlite >::set_null (
          i.min_version_value, sk);
      else
      {
        const::bpkg::_version& vw = 
          wrapper_traits< ::bpkg::_optional_version >::get_ref (vt);

        if (composite_value_traits< ::bpkg::_version, id_sqlite >::init (
              i.min_version_value,
              vw,
              sk))
          grew = true;
      }
    }

    // max_version
    //
    {
      ::butl::optional< ::bpkg::version > const& v =
        o.max_version;

      // From package-common.hxx:230:14
      ::bpkg::_optional_version const& vt =
        (v) ? bpkg::_version 
      {
         (v)->epoch, (v)->canonical_upstream, (v)->canonical_release, (v)->revision, (v)->iteration, (v)->upstream, (v)->release 
      } : bpkg::_optional_version ();

      if (wrapper_traits< ::bpkg::_optional_version >::get_null (vt))
        composite_value_traits< ::bpkg::_version, id_sqlite >::set_null (
          i.max_version_value, sk);
      else
      {
        const::bpkg::_version& vw = 
          wrapper_traits< ::bpkg::_optional_version >::get_ref (vt);

        if (composite_value_traits< ::bpkg::_version, id_sqlite >::init (
              i.max_version_value,
              vw,
              sk))
          grew = true;
      }
    }

    // min_open
    //
    {
      bool const& v =
        o.min_open;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.min_open_value,
        is_null,
        v);
      i.min_open_null = is_null;
    }

    // max_open
    //
    {
      bool const& v =
        o.max_open;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.max_open_value,
        is_null,
        v);
      i.max_open_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::version_constraint, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // min_version
    //
    {
      ::butl::optional< ::bpkg::version >& v =
        o.min_version;

      ::bpkg::_optional_version vt;

      if (composite_value_traits< ::bpkg::_version, id_sqlite >::get_null (
            i.min_version_value))
        wrapper_traits< ::bpkg::_optional_version >::set_null (vt);
      else
      {
        ::bpkg::_version& vw =
          wrapper_traits< ::bpkg::_optional_version >::set_ref (vt);

        composite_value_traits< ::bpkg::_version, id_sqlite >::init (
          vw,
          i.min_version_value,
          db);
      }

      // From package-common.hxx:230:14
      v = (vt) ? bpkg::version ((vt)->epoch, std::move ((vt)->upstream), std::move ((vt)->release), (vt)->revision, (vt)->iteration) : bpkg::optional_version ();
    }

    // max_version
    //
    {
      ::butl::optional< ::bpkg::version >& v =
        o.max_version;

      ::bpkg::_optional_version vt;

      if (composite_value_traits< ::bpkg::_version, id_sqlite >::get_null (
            i.max_version_value))
        wrapper_traits< ::bpkg::_optional_version >::set_null (vt);
      else
      {
        ::bpkg::_version& vw =
          wrapper_traits< ::bpkg::_optional_version >::set_ref (vt);

        composite_value_traits< ::bpkg::_version, id_sqlite >::init (
          vw,
          i.max_version_value,
          db);
      }

      // From package-common.hxx:230:14
      v = (vt) ? bpkg::version ((vt)->epoch, std::move ((vt)->upstream), std::move ((vt)->release), (vt)->revision, (vt)->iteration) : bpkg::optional_version ();
    }

    // min_open
    //
    {
      bool& v =
        o.min_open;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.min_open_value,
        i.min_open_null);
    }

    // max_open
    //
    {
      bool& v =
        o.max_open;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.max_open_value,
        i.max_open_null);
    }
  }

  // dependency
  //

  bool access::composite_value_traits< ::bpkg::dependency, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // constraint
    //
    if (composite_value_traits< ::bpkg::version_constraint, id_sqlite >::grow (
          i.constraint_value, t + 1UL))
      grew = true;

    return grew;
  }

  void access::composite_value_traits< ::bpkg::dependency, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = sqlite::image_traits<
      ::bpkg::package_name,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.name_value.data ();
    b[n].size = &i.name_size;
    b[n].capacity = i.name_value.capacity ();
    b[n].is_null = &i.name_null;
    n++;

    // constraint
    //
    composite_value_traits< ::bpkg::version_constraint, id_sqlite >::bind (
      b + n, i.constraint_value, sk);
    n += 16UL;
  }

  bool access::composite_value_traits< ::bpkg::dependency, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // name
    //
    {
      ::bpkg::package_name const& v =
        o.name;

      bool is_null (false);
      std::size_t cap (i.name_value.capacity ());
      sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::set_image (
        i.name_value,
        i.name_size,
        is_null,
        v);
      i.name_null = is_null;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // constraint
    //
    {
      ::butl::optional< ::bpkg::version_constraint > const& v =
        o.constraint;

      if (wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::get_null (v))
        composite_value_traits< ::bpkg::version_constraint, id_sqlite >::set_null (
          i.constraint_value, sk);
      else
      {
        const::bpkg::version_constraint& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::get_ref (v);

        if (composite_value_traits< ::bpkg::version_constraint, id_sqlite >::init (
              i.constraint_value,
              vw,
              sk))
          grew = true;
      }
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::dependency, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::bpkg::package_name& v =
        o.name;

      sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // constraint
    //
    {
      ::butl::optional< ::bpkg::version_constraint >& v =
        o.constraint;

      if (composite_value_traits< ::bpkg::version_constraint, id_sqlite >::get_null (
            i.constraint_value))
        wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_null (v);
      else
      {
        ::bpkg::version_constraint& vw =
          wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_ref (v);

        composite_value_traits< ::bpkg::version_constraint, id_sqlite >::init (
          vw,
          i.constraint_value,
          db);
      }
    }
  }

  // dependency_alternative
  //

  bool access::composite_value_traits< ::bpkg::dependency_alternative, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // enable
    //
    if (t[0UL])
    {
      i.enable_value.capacity (i.enable_size);
      grew = true;
    }

    // reflect
    //
    if (t[1UL])
    {
      i.reflect_value.capacity (i.reflect_size);
      grew = true;
    }

    // prefer
    //
    if (t[2UL])
    {
      i.prefer_value.capacity (i.prefer_size);
      grew = true;
    }

    // accept
    //
    if (t[3UL])
    {
      i.accept_value.capacity (i.accept_size);
      grew = true;
    }

    // require
    //
    if (t[4UL])
    {
      i.require_value.capacity (i.require_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::dependency_alternative, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // enable
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.enable_value.data ();
    b[n].size = &i.enable_size;
    b[n].capacity = i.enable_value.capacity ();
    b[n].is_null = &i.enable_null;
    n++;

    // reflect
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.reflect_value.data ();
    b[n].size = &i.reflect_size;
    b[n].capacity = i.reflect_value.capacity ();
    b[n].is_null = &i.reflect_null;
    n++;

    // prefer
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.prefer_value.data ();
    b[n].size = &i.prefer_size;
    b[n].capacity = i.prefer_value.capacity ();
    b[n].is_null = &i.prefer_null;
    n++;

    // accept
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.accept_value.data ();
    b[n].size = &i.accept_size;
    b[n].capacity = i.accept_value.capacity ();
    b[n].is_null = &i.accept_null;
    n++;

    // require
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.require_value.data ();
    b[n].size = &i.require_size;
    b[n].capacity = i.require_value.capacity ();
    b[n].is_null = &i.require_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::dependency_alternative, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.enable;

      bool is_null (true);
      std::size_t cap (i.enable_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.enable_value,
        i.enable_size,
        is_null,
        v);
      i.enable_null = is_null;
      grew = grew || (cap != i.enable_value.capacity ());
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.reflect;

      bool is_null (true);
      std::size_t cap (i.reflect_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.reflect_value,
        i.reflect_size,
        is_null,
        v);
      i.reflect_null = is_null;
      grew = grew || (cap != i.reflect_value.capacity ());
    }

    // prefer
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.prefer;

      bool is_null (true);
      std::size_t cap (i.prefer_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.prefer_value,
        i.prefer_size,
        is_null,
        v);
      i.prefer_null = is_null;
      grew = grew || (cap != i.prefer_value.capacity ());
    }

    // accept
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.accept;

      bool is_null (true);
      std::size_t cap (i.accept_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.accept_value,
        i.accept_size,
        is_null,
        v);
      i.accept_null = is_null;
      grew = grew || (cap != i.accept_value.capacity ());
    }

    // require
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.require;

      bool is_null (true);
      std::size_t cap (i.require_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.require_value,
        i.require_size,
        is_null,
        v);
      i.require_null = is_null;
      grew = grew || (cap != i.require_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::dependency_alternative, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.enable;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.enable_value,
        i.enable_size,
        i.enable_null);
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.reflect;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.reflect_value,
        i.reflect_size,
        i.reflect_null);
    }

    // prefer
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.prefer;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.prefer_value,
        i.prefer_size,
        i.prefer_null);
    }

    // accept
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.accept;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.accept_value,
        i.accept_size,
        i.accept_null);
    }

    // require
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.require;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.require_value,
        i.require_size,
        i.require_null);
    }
  }

  // dependency_alternatives
  //

  bool access::composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // buildtime
    //
    t[0UL] = false;

    // comment
    //
    if (t[1UL])
    {
      i.comment_value.capacity (i.comment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // buildtime
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.buildtime_value;
    b[n].is_null = &i.buildtime_null;
    n++;

    // comment
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.comment_value.data ();
    b[n].size = &i.comment_size;
    b[n].capacity = i.comment_value.capacity ();
    b[n].is_null = &i.comment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // buildtime
    //
    {
      bool const& v =
        o.buildtime;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.buildtime_value,
        is_null,
        v);
      i.buildtime_null = is_null;
    }

    // comment
    //
    {
      ::std::string const& v =
        o.comment;

      bool is_null (false);
      std::size_t cap (i.comment_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.comment_value,
        i.comment_size,
        is_null,
        v);
      i.comment_null = is_null;
      grew = grew || (cap != i.comment_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // buildtime
    //
    {
      bool& v =
        o.buildtime;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.buildtime_value,
        i.buildtime_null);
    }

    // comment
    //
    {
      ::std::string& v =
        o.comment;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.comment_value,
        i.comment_size,
        i.comment_null);
    }
  }

  // test_dependency
  //

  bool access::composite_value_traits< ::bpkg::test_dependency, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // dependency base
    //
    if (composite_value_traits< ::bpkg::dependency, id_sqlite >::grow (
          i, t + 0UL))
      grew = true;

    // type
    //
    if (t[17UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    // buildtime
    //
    t[18UL] = false;

    // enable
    //
    if (t[19UL])
    {
      i.enable_value.capacity (i.enable_size);
      grew = true;
    }

    // reflect
    //
    if (t[20UL])
    {
      i.reflect_value.capacity (i.reflect_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::test_dependency, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // dependency base
    //
    composite_value_traits< ::bpkg::dependency, id_sqlite >::bind (b + n, i, sk);
    n += 17UL;

    // type
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.type_value.data ();
    b[n].size = &i.type_size;
    b[n].capacity = i.type_value.capacity ();
    b[n].is_null = &i.type_null;
    n++;

    // buildtime
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.buildtime_value;
    b[n].is_null = &i.buildtime_null;
    n++;

    // enable
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.enable_value.data ();
    b[n].size = &i.enable_size;
    b[n].capacity = i.enable_value.capacity ();
    b[n].is_null = &i.enable_null;
    n++;

    // reflect
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.reflect_value.data ();
    b[n].size = &i.reflect_size;
    b[n].capacity = i.reflect_value.capacity ();
    b[n].is_null = &i.reflect_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::test_dependency, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // dependency base
    //
    if (composite_value_traits< ::bpkg::dependency, id_sqlite >::init (i, o, sk))
      grew = true;

    // type
    //
    {
      ::bpkg::test_dependency_type const& v =
        o.type;

      // From package.hxx:428:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t cap (i.type_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.type_value,
        i.type_size,
        is_null,
        vt);
      i.type_null = is_null;
      grew = grew || (cap != i.type_value.capacity ());
    }

    // buildtime
    //
    {
      bool const& v =
        o.buildtime;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.buildtime_value,
        is_null,
        v);
      i.buildtime_null = is_null;
    }

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.enable;

      bool is_null (true);
      std::size_t cap (i.enable_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.enable_value,
        i.enable_size,
        is_null,
        v);
      i.enable_null = is_null;
      grew = grew || (cap != i.enable_value.capacity ());
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.reflect;

      bool is_null (true);
      std::size_t cap (i.reflect_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.reflect_value,
        i.reflect_size,
        is_null,
        v);
      i.reflect_null = is_null;
      grew = grew || (cap != i.reflect_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::test_dependency, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // dependency base
    //
    composite_value_traits< ::bpkg::dependency, id_sqlite >::init (o, i, db);

    // type
    //
    {
      ::bpkg::test_dependency_type& v =
        o.type;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.type_value,
        i.type_size,
        i.type_null);

      // From package.hxx:428:14
      v = bpkg::to_test_dependency_type (vt);
    }

    // buildtime
    //
    {
      bool& v =
        o.buildtime;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.buildtime_value,
        i.buildtime_null);
    }

    // enable
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.enable;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.enable_value,
        i.enable_size,
        i.enable_null);
    }

    // reflect
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.reflect;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.reflect_value,
        i.reflect_size,
        i.reflect_null);
    }
  }

  // buildfile
  //

  bool access::composite_value_traits< ::bpkg::buildfile, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // path
    //
    if (t[0UL])
    {
      i.path_value.capacity (i.path_size);
      grew = true;
    }

    // content
    //
    if (t[1UL])
    {
      i.content_value.capacity (i.content_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::buildfile, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // path
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.path_value.data ();
    b[n].size = &i.path_size;
    b[n].capacity = i.path_value.capacity ();
    b[n].is_null = &i.path_null;
    n++;

    // content
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.content_value.data ();
    b[n].size = &i.content_size;
    b[n].capacity = i.content_value.capacity ();
    b[n].is_null = &i.content_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::buildfile, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // path
    //
    {
      ::butl::path const& v =
        o.path;

      // From package-common.hxx:72:14
      ::std::string const& vt =
        (v).representation ();

      bool is_null (false);
      std::size_t cap (i.path_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.path_value,
        i.path_size,
        is_null,
        vt);
      i.path_null = is_null;
      grew = grew || (cap != i.path_value.capacity ());
    }

    // content
    //
    {
      ::std::string const& v =
        o.content;

      bool is_null (false);
      std::size_t cap (i.content_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.content_value,
        i.content_size,
        is_null,
        v);
      i.content_null = is_null;
      grew = grew || (cap != i.content_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::buildfile, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // path
    //
    {
      ::butl::path& v =
        o.path;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.path_value,
        i.path_size,
        i.path_null);

      // From package-common.hxx:72:14
      v = bpkg::path (vt);
    }

    // content
    //
    {
      ::std::string& v =
        o.content;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.content_value,
        i.content_size,
        i.content_null);
    }
  }

  // distribution_name_value
  //

  bool access::composite_value_traits< ::bpkg::distribution_name_value, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // value
    //
    if (t[1UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::distribution_name_value, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.name_value.data ();
    b[n].size = &i.name_size;
    b[n].capacity = i.name_value.capacity ();
    b[n].is_null = &i.name_null;
    n++;

    // value
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.value_value.data ();
    b[n].size = &i.value_size;
    b[n].capacity = i.value_value.capacity ();
    b[n].is_null = &i.value_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::distribution_name_value, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // name
    //
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t cap (i.name_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.name_value,
        i.name_size,
        is_null,
        v);
      i.name_null = is_null;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // value
    //
    {
      ::std::string const& v =
        o.value;

      bool is_null (false);
      std::size_t cap (i.value_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.value_value,
        i.value_size,
        is_null,
        v);
      i.value_null = is_null;
      grew = grew || (cap != i.value_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::distribution_name_value, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // value
    //
    {
      ::std::string& v =
        o.value;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.value_value,
        i.value_size,
        i.value_null);
    }
  }

  // configuration
  //

  struct access::object_traits_impl< ::bpkg::configuration, id_sqlite >::extra_statement_cache_type
  {
    extra_statement_cache_type (
      sqlite::connection&,
      image_type&,
      id_image_type&,
      sqlite::binding&,
      sqlite::binding&)
    {
    }
  };

  access::object_traits_impl< ::bpkg::configuration, id_sqlite >::id_type
  access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  id (const id_image_type& i)
  {
    sqlite::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      sqlite::value_traits<
          ::bpkg::optional_uint64_t,
          sqlite::id_integer >::set_value (
        id,
        i.id_value,
        i.id_null);
    }

    return id;
  }

  access::object_traits_impl< ::bpkg::configuration, id_sqlite >::id_type
  access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  id (const image_type& i)
  {
    sqlite::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      sqlite::value_traits<
          ::bpkg::optional_uint64_t,
          sqlite::id_integer >::set_value (
        id,
        i.id_value,
        i.id_null);
    }

    return id;
  }

  bool access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    t[0UL] = false;

    // uuid
    //
    if (t[1UL])
    {
      i.uuid_value.capacity (i.uuid_size);
      grew = true;
    }

    // name
    //
    if (t[2UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // type
    //
    if (t[3UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    // path
    //
    if (t[4UL])
    {
      i.path_value.capacity (i.path_size);
      grew = true;
    }

    // expl
    //
    t[5UL] = false;

    // fetch_cache_mode
    //
    if (t[6UL])
    {
      i.fetch_cache_mode_value.capacity (i.fetch_cache_mode_size);
      grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      b[n].type = sqlite::bind::integer;
      b[n].buffer = &i.id_value;
      b[n].is_null = &i.id_null;
      n++;
    }

    // uuid
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.uuid_value.data ();
    b[n].size = &i.uuid_size;
    b[n].capacity = i.uuid_value.capacity ();
    b[n].is_null = &i.uuid_null;
    n++;

    // name
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.name_value.data ();
    b[n].size = &i.name_size;
    b[n].capacity = i.name_value.capacity ();
    b[n].is_null = &i.name_null;
    n++;

    // type
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.type_value.data ();
    b[n].size = &i.type_size;
    b[n].capacity = i.type_value.capacity ();
    b[n].is_null = &i.type_null;
    n++;

    // path
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.path_value.data ();
    b[n].size = &i.path_size;
    b[n].capacity = i.path_value.capacity ();
    b[n].is_null = &i.path_null;
    n++;

    // expl
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.expl_value;
    b[n].is_null = &i.expl_null;
    n++;

    // fetch_cache_mode
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.fetch_cache_mode_value.data ();
    b[n].size = &i.fetch_cache_mode_size;
    b[n].capacity = i.fetch_cache_mode_value.capacity ();
    b[n].is_null = &i.fetch_cache_mode_null;
    n++;
  }

  void access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  bind (sqlite::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.id_value;
    b[n].is_null = &i.id_null;
  }

  bool access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  init (image_type& i,
        const object_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::bpkg::optional_uint64_t const& v =
        o.id;

      bool is_null (false);
      sqlite::value_traits<
          ::bpkg::optional_uint64_t,
          sqlite::id_integer >::set_image (
        i.id_value,
        is_null,
        v);
      i.id_null = is_null;
    }

    // uuid
    //
    {
      ::bpkg::configuration::uuid_type const& v =
        o.uuid;

      // From package.hxx:42:14
      ::std::string const& vt =
        (v).string ();

      bool is_null (false);
      std::size_t cap (i.uuid_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.uuid_value,
        i.uuid_size,
        is_null,
        vt);
      i.uuid_null = is_null;
      grew = grew || (cap != i.uuid_value.capacity ());
    }

    // name
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.name;

      bool is_null (true);
      std::size_t cap (i.name_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.name_value,
        i.name_size,
        is_null,
        v);
      i.name_null = is_null;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // type
    //
    {
      ::std::string const& v =
        o.type;

      bool is_null (false);
      std::size_t cap (i.type_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.type_value,
        i.type_size,
        is_null,
        v);
      i.type_null = is_null;
      grew = grew || (cap != i.type_value.capacity ());
    }

    // path
    //
    {
      ::butl::dir_path const& v =
        o.path;

      // From package-common.hxx:79:14
      ::std::string const& vt =
        (v).string ();

      bool is_null (false);
      std::size_t cap (i.path_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.path_value,
        i.path_size,
        is_null,
        vt);
      i.path_null = is_null;
      grew = grew || (cap != i.path_value.capacity ());
    }

    // expl
    //
    {
      bool const& v =
        o.expl;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.expl_value,
        is_null,
        v);
      i.expl_null = is_null;
    }

    // fetch_cache_mode
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.fetch_cache_mode;

      bool is_null (true);
      std::size_t cap (i.fetch_cache_mode_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.fetch_cache_mode_value,
        i.fetch_cache_mode_size,
        is_null,
        v);
      i.fetch_cache_mode_null = is_null;
      grew = grew || (cap != i.fetch_cache_mode_value.capacity ());
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::bpkg::optional_uint64_t& v =
        o.id;

      sqlite::value_traits<
          ::bpkg::optional_uint64_t,
          sqlite::id_integer >::set_value (
        v,
        i.id_value,
        i.id_null);
    }

    // uuid
    //
    {
      ::bpkg::configuration::uuid_type& v =
        o.uuid;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.uuid_value,
        i.uuid_size,
        i.uuid_null);

      // From package.hxx:42:14
      v = bpkg::uuid (vt);
    }

    // name
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.name;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // type
    //
    {
      ::std::string& v =
        o.type;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.type_value,
        i.type_size,
        i.type_null);
    }

    // path
    //
    {
      ::butl::dir_path& v =
        o.path;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.path_value,
        i.path_size,
        i.path_null);

      // From package-common.hxx:79:14
      v = bpkg::dir_path (vt);
    }

    // expl
    //
    {
      bool& v =
        o.expl;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.expl_value,
        i.expl_null);
    }

    // fetch_cache_mode
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.fetch_cache_mode;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.fetch_cache_mode_value,
        i.fetch_cache_mode_size,
        i.fetch_cache_mode_null);
    }
  }

  void access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  init (id_image_type& i, const id_type& id)
  {
    {
      bool is_null (false);
      sqlite::value_traits<
          ::bpkg::optional_uint64_t,
          sqlite::id_integer >::set_image (
        i.id_value,
        is_null,
        id);
      i.id_null = is_null;
    }
  }

  const char access::object_traits_impl< ::bpkg::configuration, id_sqlite >::persist_statement[] =
  "INSERT INTO \"main\".\"configuration\" "
  "(\"id\", "
  "\"uuid\", "
  "\"name\", "
  "\"type\", "
  "\"path\", "
  "\"explicit\", "
  "\"fetch_cache_mode\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::configuration, id_sqlite >::find_statement[] =
  "SELECT "
  "\"main\".\"configuration\".\"id\", "
  "\"main\".\"configuration\".\"uuid\", "
  "\"main\".\"configuration\".\"name\", "
  "\"main\".\"configuration\".\"type\", "
  "\"main\".\"configuration\".\"path\", "
  "\"main\".\"configuration\".\"explicit\", "
  "\"main\".\"configuration\".\"fetch_cache_mode\" "
  "FROM \"main\".\"configuration\" "
  "WHERE \"main\".\"configuration\".\"id\"=?";

  const char access::object_traits_impl< ::bpkg::configuration, id_sqlite >::update_statement[] =
  "UPDATE \"main\".\"configuration\" "
  "SET "
  "\"uuid\"=?, "
  "\"name\"=?, "
  "\"type\"=?, "
  "\"path\"=?, "
  "\"explicit\"=?, "
  "\"fetch_cache_mode\"=? "
  "WHERE \"id\"=?";

  const char access::object_traits_impl< ::bpkg::configuration, id_sqlite >::erase_statement[] =
  "DELETE FROM \"main\".\"configuration\" "
  "WHERE \"id\"=?";

  const char access::object_traits_impl< ::bpkg::configuration, id_sqlite >::query_statement[] =
  "SELECT "
  "\"main\".\"configuration\".\"id\", "
  "\"main\".\"configuration\".\"uuid\", "
  "\"main\".\"configuration\".\"name\", "
  "\"main\".\"configuration\".\"type\", "
  "\"main\".\"configuration\".\"path\", "
  "\"main\".\"configuration\".\"explicit\", "
  "\"main\".\"configuration\".\"fetch_cache_mode\" "
  "FROM \"main\".\"configuration\"";

  const char access::object_traits_impl< ::bpkg::configuration, id_sqlite >::erase_query_statement[] =
  "DELETE FROM \"main\".\"configuration\"";

  const char access::object_traits_impl< ::bpkg::configuration, id_sqlite >::table_name[] =
  "\"main\".\"configuration\"";

  void access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  persist (database& db, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              static_cast<const object_type&> (obj),
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    {
      id_image_type& i (sts.id_image ());
      binding& b (sts.id_image_binding ());
      if (i.version != sts.id_image_version () || b.version == 0)
      {
        bind (b.bind, i);
        sts.id_image_version (i.version);
        b.version++;
      }
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    obj.id = id (sts.id_image ());

    callback (db,
              static_cast<const object_type&> (obj),
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace sqlite;
    using sqlite::update_statement;

    callback (db, obj, callback_event::pre_update);

    sqlite::transaction& tr (sqlite::transaction::current ());
    sqlite::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  erase (database& db, const id_type& id)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::bpkg::configuration, id_sqlite >::pointer_type
  access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  find (database& db, const id_type& id)
  {
    using namespace sqlite;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  reload (database& db, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace sqlite;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  result< access::object_traits_impl< ::bpkg::configuration, id_sqlite >::object_type >
  access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        q.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) sqlite::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      text,
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::bpkg::configuration, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // _repository_location
  //

  bool access::composite_value_traits< ::bpkg::_repository_location, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // url
    //
    if (t[0UL])
    {
      i.url_value.capacity (i.url_size);
      grew = true;
    }

    // type
    //
    if (t[1UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::_repository_location, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // url
    //
    b[n].type = sqlite::image_traits<
      ::bpkg::repository_url,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.url_value.data ();
    b[n].size = &i.url_size;
    b[n].capacity = i.url_value.capacity ();
    b[n].is_null = &i.url_null;
    n++;

    // type
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.type_value.data ();
    b[n].size = &i.type_size;
    b[n].capacity = i.type_value.capacity ();
    b[n].is_null = &i.type_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::_repository_location, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // url
    //
    {
      ::bpkg::repository_url const& v =
        o.url;

      bool is_null (false);
      std::size_t cap (i.url_value.capacity ());
      sqlite::value_traits<
          ::bpkg::repository_url,
          sqlite::id_text >::set_image (
        i.url_value,
        i.url_size,
        is_null,
        v);
      i.url_null = is_null;
      grew = grew || (cap != i.url_value.capacity ());
    }

    // type
    //
    {
      ::bpkg::repository_type const& v =
        o.type;

      // From package.hxx:161:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t cap (i.type_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.type_value,
        i.type_size,
        is_null,
        vt);
      i.type_null = is_null;
      grew = grew || (cap != i.type_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::_repository_location, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // url
    //
    {
      ::bpkg::repository_url& v =
        o.url;

      sqlite::value_traits<
          ::bpkg::repository_url,
          sqlite::id_text >::set_value (
        v,
        i.url_value,
        i.url_size,
        i.url_null);
    }

    // type
    //
    {
      ::bpkg::repository_type& v =
        o.type;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.type_value,
        i.type_size,
        i.type_null);

      // From package.hxx:161:14
      v = bpkg::to_repository_type (vt);
    }
  }

  // repository_fragment
  //

  struct access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::extra_statement_cache_type
  {
    sqlite::container_statements_impl< complements_traits > complements;
    sqlite::container_statements_impl< prerequisites_traits > prerequisites;

    extra_statement_cache_type (
      sqlite::connection& c,
      image_type&,
      id_image_type&,
      sqlite::binding& id,
      sqlite::binding&)
    : complements (c, id),
      prerequisites (c, id)
    {
    }
  };

  // complements
  //

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"repository_fragment_complements\".\"complement\" "
  "FROM \"main\".\"repository_fragment_complements\" "
  "WHERE \"main\".\"repository_fragment_complements\".\"repository_fragment\"=?";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"repository_fragment_complements\" "
  "(\"repository_fragment\", "
  "\"complement\") "
  "VALUES "
  "(?, ?)";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"repository_fragment_complements\" "
  "WHERE \"repository_fragment\"=?";

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // value
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = d.value_value.data ();
    b[n].size = &d.value_size;
    b[n].capacity = d.value_value.capacity ();
    b[n].is_null = &d.value_null;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // value
    //
    if (t[0UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  init (data_image_type& i,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // value
    //
    {
      typedef object_traits< ::bpkg::repository > obj_traits;
      typedef odb::pointer_traits< value_type > wptr_traits;
      typedef odb::pointer_traits< wptr_traits::strong_pointer_type > ptr_traits;

      wptr_traits::strong_pointer_type sp (wptr_traits::lock (v));
      bool is_null (ptr_traits::null_ptr (sp));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (sp));

        std::size_t cap (i.value_value.capacity ());
        sqlite::value_traits<
            obj_traits::id_type,
            sqlite::id_text >::set_image (
          i.value_value,
          i.value_size,
          is_null,
          ptr_id);
        i.value_null = is_null;
        grew = grew || (cap != i.value_value.capacity ());
      }
      else
        throw null_pointer ();
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  init (value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // value
    //
    {
      typedef object_traits< ::bpkg::repository > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      if (i.value_null)
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        sqlite::value_traits<
            obj_traits::id_type,
            sqlite::id_text >::set_value (
          ptr_id,
          i.value_value,
          i.value_size,
          i.value_null);

        v = ptr_traits::pointer_type (
          *static_cast<sqlite::database*> (db), ptr_id);
      }
    }
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  insert (const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  select (value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::complements_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // prerequisites
  //

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"repository_fragment_prerequisites\".\"prerequisite\" "
  "FROM \"main\".\"repository_fragment_prerequisites\" "
  "WHERE \"main\".\"repository_fragment_prerequisites\".\"repository_fragment\"=?";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"repository_fragment_prerequisites\" "
  "(\"repository_fragment\", "
  "\"prerequisite\") "
  "VALUES "
  "(?, ?)";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"repository_fragment_prerequisites\" "
  "WHERE \"repository_fragment\"=?";

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // value
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = d.value_value.data ();
    b[n].size = &d.value_size;
    b[n].capacity = d.value_value.capacity ();
    b[n].is_null = &d.value_null;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // value
    //
    if (t[0UL])
    {
      i.value_value.capacity (i.value_size);
      grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  init (data_image_type& i,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // value
    //
    {
      typedef object_traits< ::bpkg::repository > obj_traits;
      typedef odb::pointer_traits< value_type > wptr_traits;
      typedef odb::pointer_traits< wptr_traits::strong_pointer_type > ptr_traits;

      wptr_traits::strong_pointer_type sp (wptr_traits::lock (v));
      bool is_null (ptr_traits::null_ptr (sp));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (sp));

        std::size_t cap (i.value_value.capacity ());
        sqlite::value_traits<
            obj_traits::id_type,
            sqlite::id_text >::set_image (
          i.value_value,
          i.value_size,
          is_null,
          ptr_id);
        i.value_null = is_null;
        grew = grew || (cap != i.value_value.capacity ());
      }
      else
        throw null_pointer ();
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  init (value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // value
    //
    {
      typedef object_traits< ::bpkg::repository > obj_traits;
      typedef odb::pointer_traits< value_type > ptr_traits;

      if (i.value_null)
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        sqlite::value_traits<
            obj_traits::id_type,
            sqlite::id_text >::set_value (
          ptr_id,
          i.value_value,
          i.value_size,
          i.value_null);

        v = ptr_traits::pointer_type (
          *static_cast<sqlite::database*> (db), ptr_id);
      }
    }
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  insert (const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  select (value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::prerequisites_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::id_type
  access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  id (const image_type& i)
  {
    sqlite::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        id,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    return id;
  }

  bool access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // location
    //
    if (composite_value_traits< ::bpkg::_repository_location, id_sqlite >::grow (
          i.location_value, t + 1UL))
      grew = true;

    return grew;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);

    // name
    //
    if (sk != statement_update)
    {
      b[n].type = sqlite::image_traits<
        ::std::string,
        sqlite::id_text>::bind_value;
      b[n].buffer = i.name_value.data ();
      b[n].size = &i.name_size;
      b[n].capacity = i.name_value.capacity ();
      b[n].is_null = &i.name_null;
      n++;
    }

    // location
    //
    composite_value_traits< ::bpkg::_repository_location, id_sqlite >::bind (
      b + n, i.location_value, sk);
    n += 2UL;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  bind (sqlite::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.id_value.data ();
    b[n].size = &i.id_size;
    b[n].capacity = i.id_value.capacity ();
    b[n].is_null = &i.id_null;
  }

  bool access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  init (image_type& i,
        const object_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // name
    //
    if (sk == statement_insert)
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t cap (i.name_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.name_value,
        i.name_size,
        is_null,
        v);
      i.name_null = is_null;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // location
    //
    {
      ::bpkg::repository_location const& v =
        o.location;

      // From package.hxx:167:14
      ::bpkg::_repository_location const& vt =
        bpkg::_repository_location 
      {
         (v).url (), (v).empty () ? bpkg::repository_type::pkg : (v).type () 
      };


      if (composite_value_traits< ::bpkg::_repository_location, id_sqlite >::init (
            i.location_value,
            vt,
            sk))
        grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // location
    //
    {
      // From package.hxx:236:7
      ::bpkg::repository_location v;

      ::bpkg::_repository_location vt;

      composite_value_traits< ::bpkg::_repository_location, id_sqlite >::init (
        vt,
        i.location_value,
        db);

      // From package.hxx:167:14
      v = bpkg::repository_location (std::move ((vt).url), (vt).type);
      // From package.hxx:236:7
      o.location = std::move (v);
      assert (o.name == o.location.canonical_name ());
    }
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    {
      bool is_null (false);
      std::size_t cap (i.id_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.id_value,
        i.id_size,
        is_null,
        id);
      i.id_null = is_null;
      grew = grew || (cap != i.id_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::persist_statement[] =
  "INSERT INTO \"main\".\"repository_fragment\" "
  "(\"name\", "
  "\"url\", "
  "\"type\") "
  "VALUES "
  "(?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::find_statement[] =
  "SELECT "
  "\"main\".\"repository_fragment\".\"name\", "
  "\"main\".\"repository_fragment\".\"url\", "
  "\"main\".\"repository_fragment\".\"type\" "
  "FROM \"main\".\"repository_fragment\" "
  "WHERE \"main\".\"repository_fragment\".\"name\"=?";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::update_statement[] =
  "UPDATE \"main\".\"repository_fragment\" "
  "SET "
  "\"url\"=?, "
  "\"type\"=? "
  "WHERE \"name\"=?";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::erase_statement[] =
  "DELETE FROM \"main\".\"repository_fragment\" "
  "WHERE \"name\"=?";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::query_statement[] =
  "SELECT "
  "\"main\".\"repository_fragment\".\"name\", "
  "\"main\".\"repository_fragment\".\"url\", "
  "\"main\".\"repository_fragment\".\"type\" "
  "FROM \"main\".\"repository_fragment\"";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::erase_query_statement[] =
  "DELETE FROM \"main\".\"repository_fragment\"";

  const char access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::table_name[] =
  "\"main\".\"repository_fragment\"";

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  persist (database& db, const object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // complements
    //
    {
      ::bpkg::repository_fragment::dependencies const& v =
        obj.complements;

      complements_traits::persist (
        v,
        esc.complements);
    }

    // prerequisites
    //
    {
      ::bpkg::repository_fragment::dependencies const& v =
        obj.prerequisites;

      prerequisites_traits::persist (
        v,
        esc.prerequisites);
    }

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace sqlite;
    using sqlite::update_statement;

    callback (db, obj, callback_event::pre_update);

    sqlite::transaction& tr (sqlite::transaction::current ());
    sqlite::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // complements
    //
    {
      ::bpkg::repository_fragment::dependencies const& v =
        obj.complements;

      complements_traits::update (
        v,
        esc.complements);
    }

    // prerequisites
    //
    {
      ::bpkg::repository_fragment::dependencies const& v =
        obj.prerequisites;

      prerequisites_traits::update (
        v,
        esc.prerequisites);
    }

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  erase (database& db, const id_type& id)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // complements
    //
    {
      complements_traits::erase (
        esc.complements);
    }

    // prerequisites
    //
    {
      prerequisites_traits::erase (
        esc.prerequisites);
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::pointer_type
  access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  find (database& db, const id_type& id)
  {
    using namespace sqlite;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  reload (database& db, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace sqlite;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  load_ (statements_type& sts,
         object_type& obj,
         bool reload)
  {
    ODB_POTENTIALLY_UNUSED (reload);

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // complements
    //
    {
      ::bpkg::repository_fragment::dependencies& v =
        obj.complements;

      complements_traits::load (
        v,
        esc.complements);
    }

    // prerequisites
    //
    {
      ::bpkg::repository_fragment::dependencies& v =
        obj.prerequisites;

      prerequisites_traits::load (
        v,
        esc.prerequisites);
    }
  }

  result< access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::object_type >
  access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        q.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) sqlite::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      text,
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // repository_fragment_count
  //

  bool access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = false;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      sqlite::value_traits<
          ::std::size_t,
          sqlite::id_integer >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "count(*) ");

    r += "FROM \"main\".\"repository_fragment\"";

    query_base_type c (
      // From package.hxx:251:5
      query_columns::name != "" && (q.empty () ? query_base_type::true_expr : q));

    c.optimize ();

    if (!c.empty ())
    {
      r += " ";
      r += c.clause_prefix ();
      r += c;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // fragment_type
  //

  bool access::composite_value_traits< ::bpkg::repository::fragment_type, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // friendly_name
    //
    if (t[0UL])
    {
      i.friendly_name_value.capacity (i.friendly_name_size);
      grew = true;
    }

    // fragment
    //
    if (t[1UL])
    {
      i.fragment_value.capacity (i.fragment_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::repository::fragment_type, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // friendly_name
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.friendly_name_value.data ();
    b[n].size = &i.friendly_name_size;
    b[n].capacity = i.friendly_name_value.capacity ();
    b[n].is_null = &i.friendly_name_null;
    n++;

    // fragment
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.fragment_value.data ();
    b[n].size = &i.fragment_size;
    b[n].capacity = i.fragment_value.capacity ();
    b[n].is_null = &i.fragment_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::repository::fragment_type, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // friendly_name
    //
    {
      ::std::string const& v =
        o.friendly_name;

      bool is_null (false);
      std::size_t cap (i.friendly_name_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.friendly_name_value,
        i.friendly_name_size,
        is_null,
        v);
      i.friendly_name_null = is_null;
      grew = grew || (cap != i.friendly_name_value.capacity ());
    }

    // fragment
    //
    {
      ::bpkg::lazy_shared_ptr< ::bpkg::repository_fragment > const& v =
        o.fragment;

      typedef object_traits< ::bpkg::repository_fragment > obj_traits;
      typedef odb::pointer_traits< ::bpkg::lazy_shared_ptr< ::bpkg::repository_fragment > > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        std::size_t cap (i.fragment_value.capacity ());
        sqlite::value_traits<
            obj_traits::id_type,
            sqlite::id_text >::set_image (
          i.fragment_value,
          i.fragment_size,
          is_null,
          ptr_id);
        i.fragment_null = is_null;
        grew = grew || (cap != i.fragment_value.capacity ());
      }
      else
        i.fragment_null = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::repository::fragment_type, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // friendly_name
    //
    {
      ::std::string& v =
        o.friendly_name;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.friendly_name_value,
        i.friendly_name_size,
        i.friendly_name_null);
    }

    // fragment
    //
    {
      ::bpkg::lazy_shared_ptr< ::bpkg::repository_fragment >& v =
        o.fragment;

      typedef object_traits< ::bpkg::repository_fragment > obj_traits;
      typedef odb::pointer_traits< ::bpkg::lazy_shared_ptr< ::bpkg::repository_fragment > > ptr_traits;

      if (i.fragment_null)
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        sqlite::value_traits<
            obj_traits::id_type,
            sqlite::id_text >::set_value (
          ptr_id,
          i.fragment_value,
          i.fragment_size,
          i.fragment_null);

        v = ptr_traits::pointer_type (
          *static_cast<sqlite::database*> (db), ptr_id);
      }
    }
  }

  // repository
  //

  struct access::object_traits_impl< ::bpkg::repository, id_sqlite >::extra_statement_cache_type
  {
    sqlite::container_statements_impl< fragments_traits > fragments;

    extra_statement_cache_type (
      sqlite::connection& c,
      image_type&,
      id_image_type&,
      sqlite::binding& id,
      sqlite::binding&)
    : fragments (c, id)
    {
    }
  };

  // fragments
  //

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"repository_fragments\".\"index\", "
  "\"main\".\"repository_fragments\".\"friendly_name\", "
  "\"main\".\"repository_fragments\".\"fragment\" "
  "FROM \"main\".\"repository_fragments\" "
  "WHERE \"main\".\"repository_fragments\".\"repository\"=? ORDER BY \"main\".\"repository_fragments\".\"index\"";

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"repository_fragments\" "
  "(\"repository\", "
  "\"index\", "
  "\"friendly_name\", "
  "\"fragment\") "
  "VALUES "
  "(?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"repository_fragments\" "
  "WHERE \"repository\"=?";

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = false;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_image (
        i.index_value,
        is_null,
        *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::fragments_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  access::object_traits_impl< ::bpkg::repository, id_sqlite >::id_type
  access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  id (const image_type& i)
  {
    sqlite::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        id,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    return id;
  }

  bool access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // location
    //
    if (composite_value_traits< ::bpkg::_repository_location, id_sqlite >::grow (
          i.location_value, t + 1UL))
      grew = true;

    // certificate
    //
    if (t[3UL])
    {
      i.certificate_value.capacity (i.certificate_size);
      grew = true;
    }

    // local
    //
    t[4UL] = false;

    return grew;
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);

    // name
    //
    if (sk != statement_update)
    {
      b[n].type = sqlite::image_traits<
        ::std::string,
        sqlite::id_text>::bind_value;
      b[n].buffer = i.name_value.data ();
      b[n].size = &i.name_size;
      b[n].capacity = i.name_value.capacity ();
      b[n].is_null = &i.name_null;
      n++;
    }

    // location
    //
    composite_value_traits< ::bpkg::_repository_location, id_sqlite >::bind (
      b + n, i.location_value, sk);
    n += 2UL;

    // certificate
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.certificate_value.data ();
    b[n].size = &i.certificate_size;
    b[n].capacity = i.certificate_value.capacity ();
    b[n].is_null = &i.certificate_null;
    n++;

    // local
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.local_value;
    b[n].is_null = &i.local_null;
    n++;
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  bind (sqlite::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.id_value.data ();
    b[n].size = &i.id_size;
    b[n].capacity = i.id_value.capacity ();
    b[n].is_null = &i.id_null;
  }

  bool access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  init (image_type& i,
        const object_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // name
    //
    if (sk == statement_insert)
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t cap (i.name_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.name_value,
        i.name_size,
        is_null,
        v);
      i.name_null = is_null;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // location
    //
    {
      ::bpkg::repository_location const& v =
        o.location;

      // From package.hxx:167:14
      ::bpkg::_repository_location const& vt =
        bpkg::_repository_location 
      {
         (v).url (), (v).empty () ? bpkg::repository_type::pkg : (v).type () 
      };


      if (composite_value_traits< ::bpkg::_repository_location, id_sqlite >::init (
            i.location_value,
            vt,
            sk))
        grew = true;
    }

    // certificate
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.certificate;

      bool is_null (true);
      std::size_t cap (i.certificate_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.certificate_value,
        i.certificate_size,
        is_null,
        v);
      i.certificate_null = is_null;
      grew = grew || (cap != i.certificate_value.capacity ());
    }

    // local
    //
    {
      ::butl::optional< bool > const& v =
        o.local;

      bool is_null (true);
      sqlite::value_traits<
          ::butl::optional< bool >,
          sqlite::id_integer >::set_image (
        i.local_value,
        is_null,
        v);
      i.local_null = is_null;
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // location
    //
    {
      // From package.hxx:300:7
      ::bpkg::repository_location v;

      ::bpkg::_repository_location vt;

      composite_value_traits< ::bpkg::_repository_location, id_sqlite >::init (
        vt,
        i.location_value,
        db);

      // From package.hxx:167:14
      v = bpkg::repository_location (std::move ((vt).url), (vt).type);
      // From package.hxx:300:7
      o.location = std::move (v);
      assert (o.name == o.location.canonical_name ());
    }

    // certificate
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.certificate;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.certificate_value,
        i.certificate_size,
        i.certificate_null);
    }

    // local
    //
    {
      ::butl::optional< bool >& v =
        o.local;

      sqlite::value_traits<
          ::butl::optional< bool >,
          sqlite::id_integer >::set_value (
        v,
        i.local_value,
        i.local_null);
    }
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    {
      bool is_null (false);
      std::size_t cap (i.id_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.id_value,
        i.id_size,
        is_null,
        id);
      i.id_null = is_null;
      grew = grew || (cap != i.id_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::persist_statement[] =
  "INSERT INTO \"main\".\"repository\" "
  "(\"name\", "
  "\"url\", "
  "\"type\", "
  "\"certificate\", "
  "\"local\") "
  "VALUES "
  "(?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::find_statement[] =
  "SELECT "
  "\"main\".\"repository\".\"name\", "
  "\"main\".\"repository\".\"url\", "
  "\"main\".\"repository\".\"type\", "
  "\"main\".\"repository\".\"certificate\", "
  "\"main\".\"repository\".\"local\" "
  "FROM \"main\".\"repository\" "
  "WHERE \"main\".\"repository\".\"name\"=?";

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::update_statement[] =
  "UPDATE \"main\".\"repository\" "
  "SET "
  "\"url\"=?, "
  "\"type\"=?, "
  "\"certificate\"=?, "
  "\"local\"=? "
  "WHERE \"name\"=?";

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::erase_statement[] =
  "DELETE FROM \"main\".\"repository\" "
  "WHERE \"name\"=?";

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::query_statement[] =
  "SELECT "
  "\"main\".\"repository\".\"name\", "
  "\"main\".\"repository\".\"url\", "
  "\"main\".\"repository\".\"type\", "
  "\"main\".\"repository\".\"certificate\", "
  "\"main\".\"repository\".\"local\" "
  "FROM \"main\".\"repository\"";

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::erase_query_statement[] =
  "DELETE FROM \"main\".\"repository\"";

  const char access::object_traits_impl< ::bpkg::repository, id_sqlite >::table_name[] =
  "\"main\".\"repository\"";

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  persist (database& db, const object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // fragments
    //
    {
      ::bpkg::repository::fragments_type const& v =
        obj.fragments;

      fragments_traits::persist (
        v,
        esc.fragments);
    }

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace sqlite;
    using sqlite::update_statement;

    callback (db, obj, callback_event::pre_update);

    sqlite::transaction& tr (sqlite::transaction::current ());
    sqlite::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // fragments
    //
    {
      ::bpkg::repository::fragments_type const& v =
        obj.fragments;

      fragments_traits::update (
        v,
        esc.fragments);
    }

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  erase (database& db, const id_type& id)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // fragments
    //
    {
      fragments_traits::erase (
        esc.fragments);
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::bpkg::repository, id_sqlite >::pointer_type
  access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  find (database& db, const id_type& id)
  {
    using namespace sqlite;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  reload (database& db, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace sqlite;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  load_ (statements_type& sts,
         object_type& obj,
         bool reload)
  {
    ODB_POTENTIALLY_UNUSED (reload);

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // fragments
    //
    {
      ::bpkg::repository::fragments_type& v =
        obj.fragments;

      fragments_traits::load (
        v,
        esc.fragments);
    }
  }

  result< access::object_traits_impl< ::bpkg::repository, id_sqlite >::object_type >
  access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        q.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) sqlite::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      text,
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::bpkg::repository, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // repository_count
  //

  bool access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = false;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      sqlite::value_traits<
          ::std::size_t,
          sqlite::id_integer >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "count(*) ");

    r += "FROM \"main\".\"repository\"";

    query_base_type c (
      // From package.hxx:311:38
      query_columns::name != "" && (q.empty () ? query_base_type::true_expr : q));

    c.optimize ();

    if (!c.empty ())
    {
      r += " ";
      r += c.clause_prefix ();
      r += c;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // package_location
  //

  bool access::composite_value_traits< ::bpkg::package_location, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // repository_fragment
    //
    if (t[0UL])
    {
      i.repository_fragment_value.capacity (i.repository_fragment_size);
      grew = true;
    }

    // location
    //
    if (t[1UL])
    {
      i.location_value.capacity (i.location_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::package_location, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // repository_fragment
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.repository_fragment_value.data ();
    b[n].size = &i.repository_fragment_size;
    b[n].capacity = i.repository_fragment_value.capacity ();
    b[n].is_null = &i.repository_fragment_null;
    n++;

    // location
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.location_value.data ();
    b[n].size = &i.location_size;
    b[n].capacity = i.location_value.capacity ();
    b[n].is_null = &i.location_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::package_location, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // repository_fragment
    //
    {
      ::bpkg::lazy_shared_ptr< ::bpkg::repository_fragment > const& v =
        o.repository_fragment;

      typedef object_traits< ::bpkg::repository_fragment > obj_traits;
      typedef odb::pointer_traits< ::bpkg::lazy_shared_ptr< ::bpkg::repository_fragment > > ptr_traits;

      bool is_null (ptr_traits::null_ptr (v));
      if (!is_null)
      {
        const obj_traits::id_type& ptr_id (
          ptr_traits::object_id< ptr_traits::element_type  > (v));

        std::size_t cap (i.repository_fragment_value.capacity ());
        sqlite::value_traits<
            obj_traits::id_type,
            sqlite::id_text >::set_image (
          i.repository_fragment_value,
          i.repository_fragment_size,
          is_null,
          ptr_id);
        i.repository_fragment_null = is_null;
        grew = grew || (cap != i.repository_fragment_value.capacity ());
      }
      else
        i.repository_fragment_null = true;
    }

    // location
    //
    {
      ::butl::path const& v =
        o.location;

      // From package-common.hxx:72:14
      ::std::string const& vt =
        (v).representation ();

      bool is_null (false);
      std::size_t cap (i.location_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.location_value,
        i.location_size,
        is_null,
        vt);
      i.location_null = is_null;
      grew = grew || (cap != i.location_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::package_location, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // repository_fragment
    //
    {
      ::bpkg::lazy_shared_ptr< ::bpkg::repository_fragment >& v =
        o.repository_fragment;

      typedef object_traits< ::bpkg::repository_fragment > obj_traits;
      typedef odb::pointer_traits< ::bpkg::lazy_shared_ptr< ::bpkg::repository_fragment > > ptr_traits;

      if (i.repository_fragment_null)
        v = ptr_traits::pointer_type ();
      else
      {
        obj_traits::id_type ptr_id;
        sqlite::value_traits<
            obj_traits::id_type,
            sqlite::id_text >::set_value (
          ptr_id,
          i.repository_fragment_value,
          i.repository_fragment_size,
          i.repository_fragment_null);

        v = ptr_traits::pointer_type (
          *static_cast<sqlite::database*> (db), ptr_id);
      }
    }

    // location
    //
    {
      ::butl::path& v =
        o.location;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.location_value,
        i.location_size,
        i.location_null);

      // From package-common.hxx:72:14
      v = bpkg::path (vt);
    }
  }

  // dependency_alternatives_ex
  //

  bool access::composite_value_traits< ::bpkg::dependency_alternatives_ex, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // dependency_alternatives base
    //
    if (composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >::grow (
          i, t + 0UL))
      grew = true;

    // type
    //
    if (t[2UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::dependency_alternatives_ex, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // dependency_alternatives base
    //
    composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >::bind (b + n, i, sk);
    n += 2UL;

    // type
    //
    b[n].type = sqlite::image_traits<
      ::bpkg::optional_string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.type_value.data ();
    b[n].size = &i.type_size;
    b[n].capacity = i.type_value.capacity ();
    b[n].is_null = &i.type_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::dependency_alternatives_ex, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // dependency_alternatives base
    //
    if (composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >::init (i, o, sk))
      grew = true;

    // type
    //
    {
      ::butl::optional< ::bpkg::test_dependency_type > const& v =
        o.type;

      // From package.hxx:432:14
      ::bpkg::optional_string const& vt =
        (v) ? to_string ( * (v)) : bpkg::optional_string ();

      bool is_null (true);
      std::size_t cap (i.type_value.capacity ());
      sqlite::value_traits<
          ::bpkg::optional_string,
          sqlite::id_text >::set_image (
        i.type_value,
        i.type_size,
        is_null,
        vt);
      i.type_null = is_null;
      grew = grew || (cap != i.type_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::dependency_alternatives_ex, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // dependency_alternatives base
    //
    composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >::init (o, i, db);

    // type
    //
    {
      ::butl::optional< ::bpkg::test_dependency_type >& v =
        o.type;

      ::bpkg::optional_string vt;

      sqlite::value_traits<
          ::bpkg::optional_string,
          sqlite::id_text >::set_value (
        vt,
        i.type_value,
        i.type_size,
        i.type_null);

      // From package.hxx:432:14
      v = (vt) ? bpkg::to_test_dependency_type ( * (vt)) : bpkg::optional_test_dependency_type ();
    }
  }

  // _dependency_alternative_key
  //

  bool access::composite_value_traits< ::bpkg::available_package::_dependency_alternative_key, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = false;

    // inner
    //
    t[1UL] = false;

    return grew;
  }

  void access::composite_value_traits< ::bpkg::available_package::_dependency_alternative_key, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // inner
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::available_package::_dependency_alternative_key, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // outer
    //
    {
      ::bpkg::available_package::_dependency_alternative_key::outer_type const& v =
        o.outer;

      bool is_null (false);
      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_key::outer_type,
          sqlite::id_integer >::set_image (
        i.outer_value,
        is_null,
        v);
      i.outer_null = is_null;
    }

    // inner
    //
    {
      ::bpkg::available_package::_dependency_alternative_key::inner_type const& v =
        o.inner;

      bool is_null (false);
      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_key::inner_type,
          sqlite::id_integer >::set_image (
        i.inner_value,
        is_null,
        v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::available_package::_dependency_alternative_key, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::bpkg::available_package::_dependency_alternative_key::outer_type& v =
        o.outer;

      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_key::outer_type,
          sqlite::id_integer >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // inner
    //
    {
      ::bpkg::available_package::_dependency_alternative_key::inner_type& v =
        o.inner;

      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_key::inner_type,
          sqlite::id_integer >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // _dependency_key
  //

  bool access::composite_value_traits< ::bpkg::available_package::_dependency_key, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // outer
    //
    t[0UL] = false;

    // middle
    //
    t[1UL] = false;

    // inner
    //
    t[2UL] = false;

    return grew;
  }

  void access::composite_value_traits< ::bpkg::available_package::_dependency_key, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // outer
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.outer_value;
    b[n].is_null = &i.outer_null;
    n++;

    // middle
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.middle_value;
    b[n].is_null = &i.middle_null;
    n++;

    // inner
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.inner_value;
    b[n].is_null = &i.inner_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::available_package::_dependency_key, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // outer
    //
    {
      ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::outer_type const& v =
        o.outer;

      bool is_null (false);
      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::outer_type,
          sqlite::id_integer >::set_image (
        i.outer_value,
        is_null,
        v);
      i.outer_null = is_null;
    }

    // middle
    //
    {
      ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::middle_type const& v =
        o.middle;

      bool is_null (false);
      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::middle_type,
          sqlite::id_integer >::set_image (
        i.middle_value,
        is_null,
        v);
      i.middle_null = is_null;
    }

    // inner
    //
    {
      ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::inner_type const& v =
        o.inner;

      bool is_null (false);
      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::inner_type,
          sqlite::id_integer >::set_image (
        i.inner_value,
        is_null,
        v);
      i.inner_null = is_null;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::available_package::_dependency_key, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // outer
    //
    {
      ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::outer_type& v =
        o.outer;

      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::outer_type,
          sqlite::id_integer >::set_value (
        v,
        i.outer_value,
        i.outer_null);
    }

    // middle
    //
    {
      ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::middle_type& v =
        o.middle;

      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::middle_type,
          sqlite::id_integer >::set_value (
        v,
        i.middle_value,
        i.middle_null);
    }

    // inner
    //
    {
      ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::inner_type& v =
        o.inner;

      sqlite::value_traits<
          ::bpkg::available_package::_dependency_alternative_dependencies_type::key_type::inner_type,
          sqlite::id_integer >::set_value (
        v,
        i.inner_value,
        i.inner_null);
    }
  }

  // available_package
  //

  struct access::object_traits_impl< ::bpkg::available_package, id_sqlite >::extra_statement_cache_type
  {
    sqlite::container_statements_impl< languages_traits > languages;
    sqlite::container_statements_impl< locations_traits > locations;
    sqlite::container_statements_impl< dependencies_traits > dependencies;
    sqlite::container_statements_impl< dependency_alternatives_traits > dependency_alternatives;
    sqlite::container_statements_impl< dependency_alternative_dependencies_traits > dependency_alternative_dependencies;
    sqlite::container_statements_impl< tests_traits > tests;
    sqlite::container_statements_impl< buildfiles_traits > buildfiles;
    sqlite::container_statements_impl< distribution_values_traits > distribution_values;

    sqlite::section_statements< ::bpkg::available_package, languages_section_traits > languages_section;

    extra_statement_cache_type (
      sqlite::connection& c,
      image_type& im,
      id_image_type& idim,
      sqlite::binding& id,
      sqlite::binding& idv)
    : languages (c, id),
      locations (c, id),
      dependencies (c, id),
      dependency_alternatives (c, id),
      dependency_alternative_dependencies (c, id),
      tests (c, id),
      buildfiles (c, id),
      distribution_values (c, id),
      languages_section (c, im, idim, id, idv)
    {
    }
  };

  // languages
  //

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"available_package_languages\".\"index\", "
  "\"main\".\"available_package_languages\".\"language_name\", "
  "\"main\".\"available_package_languages\".\"language_impl\" "
  "FROM \"main\".\"available_package_languages\" "
  "WHERE \"main\".\"available_package_languages\".\"name\"=? AND \"main\".\"available_package_languages\".\"version_epoch\"=? AND \"main\".\"available_package_languages\".\"version_canonical_upstream\"=? AND \"main\".\"available_package_languages\".\"version_canonical_release\"=? AND \"main\".\"available_package_languages\".\"version_revision\"=? AND \"main\".\"available_package_languages\".\"version_iteration\"=? ORDER BY \"main\".\"available_package_languages\".\"index\"";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"available_package_languages\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"index\", "
  "\"language_name\", "
  "\"language_impl\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"available_package_languages\" "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = false;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_image (
        i.index_value,
        is_null,
        *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // locations
  //

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"available_package_locations\".\"repository_fragment\", "
  "\"main\".\"available_package_locations\".\"location\" "
  "FROM \"main\".\"available_package_locations\" "
  "WHERE \"main\".\"available_package_locations\".\"name\"=? AND \"main\".\"available_package_locations\".\"version_epoch\"=? AND \"main\".\"available_package_locations\".\"version_canonical_upstream\"=? AND \"main\".\"available_package_locations\".\"version_canonical_release\"=? AND \"main\".\"available_package_locations\".\"version_revision\"=? AND \"main\".\"available_package_locations\".\"version_iteration\"=?";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"available_package_locations\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"repository_fragment\", "
  "\"location\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"available_package_locations\" "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 0UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  init (data_image_type& i,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  init (value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  insert (index_type, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  select (index_type&, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = false;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = false;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = false;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::locations_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = false;
    container_traits_type::erase (fs);
  }

  // dependencies
  //

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"available_package_dependencies\".\"index\", "
  "\"main\".\"available_package_dependencies\".\"buildtime\", "
  "\"main\".\"available_package_dependencies\".\"comment\", "
  "\"main\".\"available_package_dependencies\".\"type\" "
  "FROM \"main\".\"available_package_dependencies\" "
  "WHERE \"main\".\"available_package_dependencies\".\"name\"=? AND \"main\".\"available_package_dependencies\".\"version_epoch\"=? AND \"main\".\"available_package_dependencies\".\"version_canonical_upstream\"=? AND \"main\".\"available_package_dependencies\".\"version_canonical_release\"=? AND \"main\".\"available_package_dependencies\".\"version_revision\"=? AND \"main\".\"available_package_dependencies\".\"version_iteration\"=? ORDER BY \"main\".\"available_package_dependencies\".\"index\"";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"available_package_dependencies\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"index\", "
  "\"buildtime\", "
  "\"comment\", "
  "\"type\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"available_package_dependencies\" "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = false;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_image (
        i.index_value,
        is_null,
        *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependencies_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // dependency_alternatives
  //

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"available_package_dependency_alternatives\".\"dependency_index\", "
  "\"main\".\"available_package_dependency_alternatives\".\"index\", "
  "\"main\".\"available_package_dependency_alternatives\".\"enable\", "
  "\"main\".\"available_package_dependency_alternatives\".\"reflect\", "
  "\"main\".\"available_package_dependency_alternatives\".\"prefer\", "
  "\"main\".\"available_package_dependency_alternatives\".\"accept\", "
  "\"main\".\"available_package_dependency_alternatives\".\"require\" "
  "FROM \"main\".\"available_package_dependency_alternatives\" "
  "WHERE \"main\".\"available_package_dependency_alternatives\".\"name\"=? AND \"main\".\"available_package_dependency_alternatives\".\"version_epoch\"=? AND \"main\".\"available_package_dependency_alternatives\".\"version_canonical_upstream\"=? AND \"main\".\"available_package_dependency_alternatives\".\"version_canonical_release\"=? AND \"main\".\"available_package_dependency_alternatives\".\"version_revision\"=? AND \"main\".\"available_package_dependency_alternatives\".\"version_iteration\"=?";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"available_package_dependency_alternatives\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"dependency_index\", "
  "\"index\", "
  "\"enable\", "
  "\"reflect\", "
  "\"prefer\", "
  "\"accept\", "
  "\"require\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"available_package_dependency_alternatives\" "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_sqlite >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_sqlite >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_sqlite >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_sqlite >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternatives_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // dependency_alternative_dependencies
  //

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dependency_index\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"alternative_index\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"index\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_name\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_min_version_epoch\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_min_version_canonical_upstream\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_min_version_canonical_release\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_min_version_revision\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_min_version_iteration\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_min_version_upstream\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_min_version_release\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_max_version_epoch\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_max_version_canonical_upstream\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_max_version_canonical_release\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_max_version_revision\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_max_version_iteration\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_max_version_upstream\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_max_version_release\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_min_open\", "
  "\"main\".\"available_package_dependency_alternative_dependencies\".\"dep_max_open\" "
  "FROM \"main\".\"available_package_dependency_alternative_dependencies\" "
  "WHERE \"main\".\"available_package_dependency_alternative_dependencies\".\"name\"=? AND \"main\".\"available_package_dependency_alternative_dependencies\".\"version_epoch\"=? AND \"main\".\"available_package_dependency_alternative_dependencies\".\"version_canonical_upstream\"=? AND \"main\".\"available_package_dependency_alternative_dependencies\".\"version_canonical_release\"=? AND \"main\".\"available_package_dependency_alternative_dependencies\".\"version_revision\"=? AND \"main\".\"available_package_dependency_alternative_dependencies\".\"version_iteration\"=?";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"available_package_dependency_alternative_dependencies\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"dependency_index\", "
  "\"alternative_index\", "
  "\"index\", "
  "\"dep_name\", "
  "\"dep_min_version_epoch\", "
  "\"dep_min_version_canonical_upstream\", "
  "\"dep_min_version_canonical_release\", "
  "\"dep_min_version_revision\", "
  "\"dep_min_version_iteration\", "
  "\"dep_min_version_upstream\", "
  "\"dep_min_version_release\", "
  "\"dep_max_version_epoch\", "
  "\"dep_max_version_canonical_upstream\", "
  "\"dep_max_version_canonical_release\", "
  "\"dep_max_version_revision\", "
  "\"dep_max_version_iteration\", "
  "\"dep_max_version_upstream\", "
  "\"dep_max_version_release\", "
  "\"dep_min_open\", "
  "\"dep_max_open\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"available_package_dependency_alternative_dependencies\" "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< key_type, id_sqlite >::bind (
      b + n, d.key_value, sk);
    n += 3UL;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< key_type, id_sqlite >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 3UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      composite_value_traits< key_type, id_sqlite >::init (
        i.key_value,
        *k,
        sk);
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      composite_value_traits< key_type, id_sqlite >::init (
        k,
        i.key_value,
        db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::dependency_alternative_dependencies_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // tests
  //

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"available_package_tests\".\"index\", "
  "\"main\".\"available_package_tests\".\"test_name\", "
  "\"main\".\"available_package_tests\".\"test_min_version_epoch\", "
  "\"main\".\"available_package_tests\".\"test_min_version_canonical_upstream\", "
  "\"main\".\"available_package_tests\".\"test_min_version_canonical_release\", "
  "\"main\".\"available_package_tests\".\"test_min_version_revision\", "
  "\"main\".\"available_package_tests\".\"test_min_version_iteration\", "
  "\"main\".\"available_package_tests\".\"test_min_version_upstream\", "
  "\"main\".\"available_package_tests\".\"test_min_version_release\", "
  "\"main\".\"available_package_tests\".\"test_max_version_epoch\", "
  "\"main\".\"available_package_tests\".\"test_max_version_canonical_upstream\", "
  "\"main\".\"available_package_tests\".\"test_max_version_canonical_release\", "
  "\"main\".\"available_package_tests\".\"test_max_version_revision\", "
  "\"main\".\"available_package_tests\".\"test_max_version_iteration\", "
  "\"main\".\"available_package_tests\".\"test_max_version_upstream\", "
  "\"main\".\"available_package_tests\".\"test_max_version_release\", "
  "\"main\".\"available_package_tests\".\"test_min_open\", "
  "\"main\".\"available_package_tests\".\"test_max_open\", "
  "\"main\".\"available_package_tests\".\"test_type\", "
  "\"main\".\"available_package_tests\".\"test_buildtime\", "
  "\"main\".\"available_package_tests\".\"test_enable\", "
  "\"main\".\"available_package_tests\".\"test_reflect\" "
  "FROM \"main\".\"available_package_tests\" "
  "WHERE \"main\".\"available_package_tests\".\"name\"=? AND \"main\".\"available_package_tests\".\"version_epoch\"=? AND \"main\".\"available_package_tests\".\"version_canonical_upstream\"=? AND \"main\".\"available_package_tests\".\"version_canonical_release\"=? AND \"main\".\"available_package_tests\".\"version_revision\"=? AND \"main\".\"available_package_tests\".\"version_iteration\"=? ORDER BY \"main\".\"available_package_tests\".\"index\"";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"available_package_tests\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"index\", "
  "\"test_name\", "
  "\"test_min_version_epoch\", "
  "\"test_min_version_canonical_upstream\", "
  "\"test_min_version_canonical_release\", "
  "\"test_min_version_revision\", "
  "\"test_min_version_iteration\", "
  "\"test_min_version_upstream\", "
  "\"test_min_version_release\", "
  "\"test_max_version_epoch\", "
  "\"test_max_version_canonical_upstream\", "
  "\"test_max_version_canonical_release\", "
  "\"test_max_version_revision\", "
  "\"test_max_version_iteration\", "
  "\"test_max_version_upstream\", "
  "\"test_max_version_release\", "
  "\"test_min_open\", "
  "\"test_max_open\", "
  "\"test_type\", "
  "\"test_buildtime\", "
  "\"test_enable\", "
  "\"test_reflect\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"available_package_tests\" "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = false;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_image (
        i.index_value,
        is_null,
        *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::tests_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // buildfiles
  //

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"available_package_buildfiles\".\"index\", "
  "\"main\".\"available_package_buildfiles\".\"path\", "
  "\"main\".\"available_package_buildfiles\".\"content\" "
  "FROM \"main\".\"available_package_buildfiles\" "
  "WHERE \"main\".\"available_package_buildfiles\".\"name\"=? AND \"main\".\"available_package_buildfiles\".\"version_epoch\"=? AND \"main\".\"available_package_buildfiles\".\"version_canonical_upstream\"=? AND \"main\".\"available_package_buildfiles\".\"version_canonical_release\"=? AND \"main\".\"available_package_buildfiles\".\"version_revision\"=? AND \"main\".\"available_package_buildfiles\".\"version_iteration\"=? ORDER BY \"main\".\"available_package_buildfiles\".\"index\"";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"available_package_buildfiles\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"index\", "
  "\"path\", "
  "\"content\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"available_package_buildfiles\" "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = false;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_image (
        i.index_value,
        is_null,
        *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::buildfiles_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // distribution_values
  //

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"available_package_distribution_values\".\"index\", "
  "\"main\".\"available_package_distribution_values\".\"dist_name\", "
  "\"main\".\"available_package_distribution_values\".\"dist_value\" "
  "FROM \"main\".\"available_package_distribution_values\" "
  "WHERE \"main\".\"available_package_distribution_values\".\"name\"=? AND \"main\".\"available_package_distribution_values\".\"version_epoch\"=? AND \"main\".\"available_package_distribution_values\".\"version_canonical_upstream\"=? AND \"main\".\"available_package_distribution_values\".\"version_canonical_release\"=? AND \"main\".\"available_package_distribution_values\".\"version_revision\"=? AND \"main\".\"available_package_distribution_values\".\"version_iteration\"=? ORDER BY \"main\".\"available_package_distribution_values\".\"index\"";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"available_package_distribution_values\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"index\", "
  "\"dist_name\", "
  "\"dist_value\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"available_package_distribution_values\" "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = false;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_image (
        i.index_value,
        is_null,
        *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::distribution_values_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // languages_section
  //

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // languages
    //
    {
      ::butl::small_vector< ::bpkg::language, 1 >& v =
        obj.languages;

      languages_traits::load (
        v,
        esc.languages);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::languages_section_traits::
  update (extra_statement_cache_type& esc, const object_type& obj)
  {
    // languages
    //
    {
      ::butl::small_vector< ::bpkg::language, 1 > const& v =
        obj.languages;

      languages_traits::update (
        v,
        esc.languages);
    }
  }

  access::object_traits_impl< ::bpkg::available_package, id_sqlite >::id_type
  access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  id (const image_type& i)
  {
    sqlite::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      composite_value_traits< ::bpkg::package_id, id_sqlite >::init (
        id,
        i.id_value,
        db);
    }

    return id;
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (composite_value_traits< ::bpkg::package_id, id_sqlite >::grow (
          i.id_value, t + 0UL))
      grew = true;

    // version
    //
    if (composite_value_traits< ::bpkg::original_version, id_sqlite >::grow (
          i.version_value, t + 6UL))
      grew = true;

    // upstream_version
    //
    if (t[8UL])
    {
      i.upstream_version_value.capacity (i.upstream_version_size);
      grew = true;
    }

    // type
    //
    if (t[9UL])
    {
      i.type_value.capacity (i.type_size);
      grew = true;
    }

    // project
    //
    if (t[10UL])
    {
      i.project_value.capacity (i.project_size);
      grew = true;
    }

    // alt_naming
    //
    t[11UL] = false;

    // bootstrap_build
    //
    if (t[12UL])
    {
      i.bootstrap_build_value.capacity (i.bootstrap_build_size);
      grew = true;
    }

    // root_build
    //
    if (t[13UL])
    {
      i.root_build_value.capacity (i.root_build_size);
      grew = true;
    }

    // sha256sum
    //
    if (t[14UL])
    {
      i.sha256sum_value.capacity (i.sha256sum_size);
      grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      composite_value_traits< ::bpkg::package_id, id_sqlite >::bind (
        b + n, i.id_value, sk);
      n += 6UL;
    }

    // version
    //
    composite_value_traits< ::bpkg::original_version, id_sqlite >::bind (
      b + n, i.version_value, sk);
    n += 2UL;

    // upstream_version
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.upstream_version_value.data ();
    b[n].size = &i.upstream_version_size;
    b[n].capacity = i.upstream_version_value.capacity ();
    b[n].is_null = &i.upstream_version_null;
    n++;

    // type
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.type_value.data ();
    b[n].size = &i.type_size;
    b[n].capacity = i.type_value.capacity ();
    b[n].is_null = &i.type_null;
    n++;

    // project
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::butl::project_name >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.project_value.data ();
    b[n].size = &i.project_size;
    b[n].capacity = i.project_value.capacity ();
    b[n].is_null = &i.project_null;
    n++;

    // alt_naming
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.alt_naming_value;
    b[n].is_null = &i.alt_naming_null;
    n++;

    // bootstrap_build
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.bootstrap_build_value.data ();
    b[n].size = &i.bootstrap_build_size;
    b[n].capacity = i.bootstrap_build_value.capacity ();
    b[n].is_null = &i.bootstrap_build_null;
    n++;

    // root_build
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.root_build_value.data ();
    b[n].size = &i.root_build_size;
    b[n].capacity = i.root_build_value.capacity ();
    b[n].is_null = &i.root_build_null;
    n++;

    // sha256sum
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.sha256sum_value.data ();
    b[n].size = &i.sha256sum_size;
    b[n].capacity = i.sha256sum_value.capacity ();
    b[n].is_null = &i.sha256sum_null;
    n++;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  bind (sqlite::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    sqlite::statement_kind sk (sqlite::statement_select);
    composite_value_traits< ::bpkg::package_id, id_sqlite >::bind (
      b + n, i.id_value, sk);
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  init (image_type& i,
        const object_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::bpkg::package_id const& v =
        o.id;

      if (composite_value_traits< ::bpkg::package_id, id_sqlite >::init (
            i.id_value,
            v,
            sk))
        grew = true;
    }

    // version
    //
    {
      ::bpkg::original_version const& v =
        o.version;

      if (composite_value_traits< ::bpkg::original_version, id_sqlite >::init (
            i.version_value,
            v,
            sk))
        grew = true;
    }

    // upstream_version
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.upstream_version;

      bool is_null (true);
      std::size_t cap (i.upstream_version_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.upstream_version_value,
        i.upstream_version_size,
        is_null,
        v);
      i.upstream_version_null = is_null;
      grew = grew || (cap != i.upstream_version_value.capacity ());
    }

    // type
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.type;

      bool is_null (true);
      std::size_t cap (i.type_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.type_value,
        i.type_size,
        is_null,
        v);
      i.type_null = is_null;
      grew = grew || (cap != i.type_value.capacity ());
    }

    // project
    //
    {
      ::butl::optional< ::butl::project_name > const& v =
        o.project;

      bool is_null (true);
      std::size_t cap (i.project_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::butl::project_name >,
          sqlite::id_text >::set_image (
        i.project_value,
        i.project_size,
        is_null,
        v);
      i.project_null = is_null;
      grew = grew || (cap != i.project_value.capacity ());
    }

    // alt_naming
    //
    {
      ::butl::optional< bool > const& v =
        o.alt_naming;

      bool is_null (true);
      sqlite::value_traits<
          ::butl::optional< bool >,
          sqlite::id_integer >::set_image (
        i.alt_naming_value,
        is_null,
        v);
      i.alt_naming_null = is_null;
    }

    // bootstrap_build
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.bootstrap_build;

      bool is_null (true);
      std::size_t cap (i.bootstrap_build_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.bootstrap_build_value,
        i.bootstrap_build_size,
        is_null,
        v);
      i.bootstrap_build_null = is_null;
      grew = grew || (cap != i.bootstrap_build_value.capacity ());
    }

    // root_build
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.root_build;

      bool is_null (true);
      std::size_t cap (i.root_build_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.root_build_value,
        i.root_build_size,
        is_null,
        v);
      i.root_build_null = is_null;
      grew = grew || (cap != i.root_build_value.capacity ());
    }

    // sha256sum
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.sha256sum;

      bool is_null (true);
      std::size_t cap (i.sha256sum_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.sha256sum_value,
        i.sha256sum_size,
        is_null,
        v);
      i.sha256sum_null = is_null;
      grew = grew || (cap != i.sha256sum_value.capacity ());
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::bpkg::package_id& v =
        o.id;

      composite_value_traits< ::bpkg::package_id, id_sqlite >::init (
        v,
        i.id_value,
        db);
    }

    // version
    //
    {
      // From package.hxx:643:32
      ::bpkg::original_version v;

      composite_value_traits< ::bpkg::original_version, id_sqlite >::init (
        v,
        i.version_value,
        db);

      // From package.hxx:643:32
      o.version.init (o.id.version, (v));
    }

    // upstream_version
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.upstream_version;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.upstream_version_value,
        i.upstream_version_size,
        i.upstream_version_null);
    }

    // type
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.type;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.type_value,
        i.type_size,
        i.type_null);
    }

    // project
    //
    {
      ::butl::optional< ::butl::project_name >& v =
        o.project;

      sqlite::value_traits<
          ::butl::optional< ::butl::project_name >,
          sqlite::id_text >::set_value (
        v,
        i.project_value,
        i.project_size,
        i.project_null);
    }

    // alt_naming
    //
    {
      ::butl::optional< bool >& v =
        o.alt_naming;

      sqlite::value_traits<
          ::butl::optional< bool >,
          sqlite::id_integer >::set_value (
        v,
        i.alt_naming_value,
        i.alt_naming_null);
    }

    // bootstrap_build
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.bootstrap_build;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.bootstrap_build_value,
        i.bootstrap_build_size,
        i.bootstrap_build_null);
    }

    // root_build
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.root_build;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.root_build_value,
        i.root_build_size,
        i.root_build_null);
    }

    // sha256sum
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.sha256sum;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.sha256sum_value,
        i.sha256sum_size,
        i.sha256sum_null);
    }
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    sqlite::statement_kind sk (sqlite::statement_select);
    {
      if (composite_value_traits< ::bpkg::package_id, id_sqlite >::init (
            i.id_value,
            id,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::persist_statement[] =
  "INSERT INTO \"main\".\"available_package\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"version_upstream\", "
  "\"version_release\", "
  "\"upstream_version\", "
  "\"type\", "
  "\"project\", "
  "\"alt_naming\", "
  "\"bootstrap_build\", "
  "\"root_build\", "
  "\"sha256sum\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::find_statement[] =
  "SELECT "
  "\"main\".\"available_package\".\"name\", "
  "\"main\".\"available_package\".\"version_epoch\", "
  "\"main\".\"available_package\".\"version_canonical_upstream\", "
  "\"main\".\"available_package\".\"version_canonical_release\", "
  "\"main\".\"available_package\".\"version_revision\", "
  "\"main\".\"available_package\".\"version_iteration\", "
  "\"main\".\"available_package\".\"version_upstream\", "
  "\"main\".\"available_package\".\"version_release\", "
  "\"main\".\"available_package\".\"upstream_version\", "
  "\"main\".\"available_package\".\"type\", "
  "\"main\".\"available_package\".\"project\", "
  "\"main\".\"available_package\".\"alt_naming\", "
  "\"main\".\"available_package\".\"bootstrap_build\", "
  "\"main\".\"available_package\".\"root_build\", "
  "\"main\".\"available_package\".\"sha256sum\" "
  "FROM \"main\".\"available_package\" "
  "WHERE \"main\".\"available_package\".\"name\"=? AND \"main\".\"available_package\".\"version_epoch\"=? AND \"main\".\"available_package\".\"version_canonical_upstream\"=? AND \"main\".\"available_package\".\"version_canonical_release\"=? AND \"main\".\"available_package\".\"version_revision\"=? AND \"main\".\"available_package\".\"version_iteration\"=?";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::update_statement[] =
  "UPDATE \"main\".\"available_package\" "
  "SET "
  "\"version_upstream\"=?, "
  "\"version_release\"=?, "
  "\"upstream_version\"=?, "
  "\"type\"=?, "
  "\"project\"=?, "
  "\"alt_naming\"=?, "
  "\"bootstrap_build\"=?, "
  "\"root_build\"=?, "
  "\"sha256sum\"=? "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::erase_statement[] =
  "DELETE FROM \"main\".\"available_package\" "
  "WHERE \"name\"=? AND \"version_epoch\"=? AND \"version_canonical_upstream\"=? AND \"version_canonical_release\"=? AND \"version_revision\"=? AND \"version_iteration\"=?";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::query_statement[] =
  "SELECT "
  "\"main\".\"available_package\".\"name\", "
  "\"main\".\"available_package\".\"version_epoch\", "
  "\"main\".\"available_package\".\"version_canonical_upstream\", "
  "\"main\".\"available_package\".\"version_canonical_release\", "
  "\"main\".\"available_package\".\"version_revision\", "
  "\"main\".\"available_package\".\"version_iteration\", "
  "\"main\".\"available_package\".\"version_upstream\", "
  "\"main\".\"available_package\".\"version_release\", "
  "\"main\".\"available_package\".\"upstream_version\", "
  "\"main\".\"available_package\".\"type\", "
  "\"main\".\"available_package\".\"project\", "
  "\"main\".\"available_package\".\"alt_naming\", "
  "\"main\".\"available_package\".\"bootstrap_build\", "
  "\"main\".\"available_package\".\"root_build\", "
  "\"main\".\"available_package\".\"sha256sum\" "
  "FROM \"main\".\"available_package\"";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::erase_query_statement[] =
  "DELETE FROM \"main\".\"available_package\"";

  const char access::object_traits_impl< ::bpkg::available_package, id_sqlite >::table_name[] =
  "\"main\".\"available_package\"";

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  persist (database& db, const object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // languages
    //
    {
      ::butl::small_vector< ::bpkg::language, 1 > const& v =
        obj.languages;

      languages_traits::persist (
        v,
        esc.languages);
    }

    // locations
    //
    {
      ::butl::small_vector< ::bpkg::package_location, 1 > const& v =
        obj.locations;

      locations_traits::persist (
        v,
        esc.locations);
    }

    // dependencies
    //
    {
      ::bpkg::available_package::dependencies_type const& v =
        obj.dependencies;

      dependencies_traits::persist (
        v,
        esc.dependencies);
    }

    // dependency_alternatives
    //
    {
      // From package.hxx:681:7
      ::std::map< ::odb::nested_key< ::bpkg::dependency_alternatives_ex >, ::bpkg::dependency_alternative > const& v =
        odb::nested_get (obj.dependencies);

      dependency_alternatives_traits::persist (
        v,
        esc.dependency_alternatives);
    }

    // dependency_alternative_dependencies
    //
    {
      // From package.hxx:699:7
      ::std::map< ::odb::nested2_key< ::bpkg::dependency_alternatives_ex >, ::bpkg::dependency > const& v =
        odb::nested2_get (obj.dependencies);

      dependency_alternative_dependencies_traits::persist (
        v,
        esc.dependency_alternative_dependencies);
    }

    // tests
    //
    {
      ::butl::small_vector< ::bpkg::test_dependency, 1 > const& v =
        obj.tests;

      tests_traits::persist (
        v,
        esc.tests);
    }

    // buildfiles
    //
    {
      ::std::vector< ::bpkg::buildfile > const& v =
        obj.buildfiles;

      buildfiles_traits::persist (
        v,
        esc.buildfiles);
    }

    // distribution_values
    //
    {
      ::std::vector< ::bpkg::distribution_name_value > const& v =
        obj.distribution_values;

      distribution_values_traits::persist (
        v,
        esc.distribution_values);
    }

    obj.languages_section.reset (true, false);

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace sqlite;
    using sqlite::update_statement;

    callback (db, obj, callback_event::pre_update);

    sqlite::transaction& tr (sqlite::transaction::current ());
    sqlite::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // locations
    //
    {
      ::butl::small_vector< ::bpkg::package_location, 1 > const& v =
        obj.locations;

      locations_traits::update (
        v,
        esc.locations);
    }

    // dependencies
    //
    {
      ::bpkg::available_package::dependencies_type const& v =
        obj.dependencies;

      dependencies_traits::update (
        v,
        esc.dependencies);
    }

    // dependency_alternatives
    //
    {
      // From package.hxx:681:7
      ::std::map< ::odb::nested_key< ::bpkg::dependency_alternatives_ex >, ::bpkg::dependency_alternative > const& v =
        odb::nested_get (obj.dependencies);

      dependency_alternatives_traits::update (
        v,
        esc.dependency_alternatives);
    }

    // dependency_alternative_dependencies
    //
    {
      // From package.hxx:699:7
      ::std::map< ::odb::nested2_key< ::bpkg::dependency_alternatives_ex >, ::bpkg::dependency > const& v =
        odb::nested2_get (obj.dependencies);

      dependency_alternative_dependencies_traits::update (
        v,
        esc.dependency_alternative_dependencies);
    }

    // tests
    //
    {
      ::butl::small_vector< ::bpkg::test_dependency, 1 > const& v =
        obj.tests;

      tests_traits::update (
        v,
        esc.tests);
    }

    // buildfiles
    //
    {
      ::std::vector< ::bpkg::buildfile > const& v =
        obj.buildfiles;

      buildfiles_traits::update (
        v,
        esc.buildfiles);
    }

    // distribution_values
    //
    {
      ::std::vector< ::bpkg::distribution_name_value > const& v =
        obj.distribution_values;

      distribution_values_traits::update (
        v,
        esc.distribution_values);
    }

    if (obj.languages_section.loaded ())
    {
      languages_section_traits::update (esc, obj);
    }

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  erase (database& db, const id_type& id)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // languages
    //
    {
      languages_traits::erase (
        esc.languages);
    }

    // locations
    //
    {
      locations_traits::erase (
        esc.locations);
    }

    // dependencies
    //
    {
      dependencies_traits::erase (
        esc.dependencies);
    }

    // dependency_alternatives
    //
    {
      dependency_alternatives_traits::erase (
        esc.dependency_alternatives);
    }

    // dependency_alternative_dependencies
    //
    {
      dependency_alternative_dependencies_traits::erase (
        esc.dependency_alternative_dependencies);
    }

    // tests
    //
    {
      tests_traits::erase (
        esc.tests);
    }

    // buildfiles
    //
    {
      buildfiles_traits::erase (
        esc.buildfiles);
    }

    // distribution_values
    //
    {
      distribution_values_traits::erase (
        esc.distribution_values);
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::bpkg::available_package, id_sqlite >::pointer_type
  access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  find (database& db, const id_type& id)
  {
    using namespace sqlite;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  reload (database& db, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  load (connection& conn, object_type& obj, section& s)
  {
    using namespace sqlite;

    sqlite::connection& c (static_cast<sqlite::connection&> (conn));
    statements_type& sts (c.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    bool r (false);

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    if (!r && &s == &obj.languages_section)
    {
      languages_section_traits::load (esc, obj);
      r = true;
    }

    sts.load_delayed (0);
    l.unlock ();
    return r;
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  update (connection& conn, const object_type& obj, const section& s)
  {
    using namespace sqlite;

    sqlite::connection& c (static_cast<sqlite::connection&> (conn));
    statements_type& sts (c.statement_cache ().find_object<object_type> ());
    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (&s == &obj.languages_section)languages_section_traits::update (esc, obj);
    else
      return false;

    return true;
  }

  bool access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace sqlite;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  load_ (statements_type& sts,
         object_type& obj,
         bool reload)
  {
    ODB_POTENTIALLY_UNUSED (reload);

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // locations
    //
    {
      ::butl::small_vector< ::bpkg::package_location, 1 >& v =
        obj.locations;

      locations_traits::load (
        v,
        esc.locations);
    }

    // dependencies
    //
    {
      ::bpkg::available_package::dependencies_type& v =
        obj.dependencies;

      dependencies_traits::load (
        v,
        esc.dependencies);
    }

    // dependency_alternatives
    //
    {
      ::std::map< ::odb::nested_key< ::bpkg::dependency_alternatives_ex >, ::bpkg::dependency_alternative > v;

      dependency_alternatives_traits::load (
        v,
        esc.dependency_alternatives);

      // From package.hxx:682:7
      odb::nested_set (obj.dependencies, std::move (v));
    }

    // dependency_alternative_dependencies
    //
    {
      ::std::map< ::odb::nested2_key< ::bpkg::dependency_alternatives_ex >, ::bpkg::dependency > v;

      dependency_alternative_dependencies_traits::load (
        v,
        esc.dependency_alternative_dependencies);

      // From package.hxx:700:7
      odb::nested2_set (obj.dependencies, std::move (v));
    }

    // tests
    //
    {
      ::butl::small_vector< ::bpkg::test_dependency, 1 >& v =
        obj.tests;

      tests_traits::load (
        v,
        esc.tests);
    }

    // buildfiles
    //
    {
      ::std::vector< ::bpkg::buildfile >& v =
        obj.buildfiles;

      buildfiles_traits::load (
        v,
        esc.buildfiles);
    }

    // distribution_values
    //
    {
      ::std::vector< ::bpkg::distribution_name_value >& v =
        obj.distribution_values;

      distribution_values_traits::load (
        v,
        esc.distribution_values);
    }

    if (reload)
    {
      if (obj.languages_section.loaded ())
      {
        languages_section_traits::load (esc, obj);
        obj.languages_section.reset (true, false);
      }
    }
    else
      obj.languages_section.reset ();
  }

  result< access::object_traits_impl< ::bpkg::available_package, id_sqlite >::object_type >
  access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        q.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) sqlite::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      text,
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::bpkg::available_package, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // available_package_count
  //

  bool access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = false;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      sqlite::value_traits<
          ::std::size_t,
          sqlite::id_integer >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "count(*) ");

    r += "FROM \"main\".\"available_package\"";

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // available_test
  //

  const char alias_traits<  ::bpkg::available_package,
    id_sqlite,
    access::view_traits_impl< ::bpkg::available_test, id_sqlite >::package_tag>::
  table_name[] = "\"package\"";

  bool access::view_traits_impl< ::bpkg::available_test, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // package
    //
    if (object_traits_impl< ::bpkg::available_package, id_sqlite >::grow (
          i.package_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::available_test, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // package
    //
    object_traits_impl< ::bpkg::available_package, id_sqlite >::bind (
      b + n, i.package_value, sk);
    n += 15UL;
  }

  void access::view_traits_impl< ::bpkg::available_test, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (*db));

    // package pre
    //
    typedef ::bpkg::available_package package_object_type;
    typedef object_traits_impl<package_object_type, id_sqlite> package_object_traits;
    typedef package_object_traits::pointer_type package_pointer_type;
    typedef package_object_traits::pointer_traits package_pointer_traits;
    typedef package_object_traits::pointer_cache_traits package_cache_traits;

    package_object_traits::id_type package_id;
    package_pointer_type package_p;
    package_pointer_traits::guard package_pg;
    package_cache_traits::insert_guard package_ig;
    package_object_type* package_o (0);

    {
      if (!composite_value_traits< package_object_traits::id_type, id_sqlite >::get_null (
            i.package_value.id_value))
      {
        package_id = package_object_traits::id (i.package_value);
        package_p = package_cache_traits::find (*db, package_id);

        if (package_pointer_traits::null_ptr (package_p))
        {
          package_p = object_factory<package_object_type, package_pointer_type>::create ();
          package_pg.reset (package_p);
          package_ig.reset (package_cache_traits::insert (*db, package_id, package_p));
          package_o = package_pointer_traits::get_ptr (package_p);
        }
      }
    }

    // package
    //
    {
      if (package_o != 0)
      {
        package_object_traits::callback (*db, *package_o, callback_event::pre_load);
        package_object_traits::init (*package_o, i.package_value, db);
        package_object_traits::statements_type& sts (
          conn.statement_cache ().find_object<package_object_type> ());
        package_object_traits::statements_type::auto_lock l (sts);
        assert (l.locked ()) /* Must be a top-level call. */;

        package_object_traits::id_image_type& i (sts.id_image ());
        package_object_traits::init (i, package_id);
        sqlite::binding& idb (sts.id_image_binding ());
        if (i.version != sts.id_image_version () || idb.version == 0)
        {
          package_object_traits::bind (idb.bind, i);
          sts.id_image_version (i.version);
          idb.version++;
        }

        package_object_traits::load_ (sts, *package_o, false);
        sts.load_delayed (0);
        l.unlock ();
      }
    }

    // package post
    //
    {
      if (package_o != 0)
      {
        package_object_traits::callback (*db, *package_o, callback_event::post_load);
        package_cache_traits::load (package_ig.position ());
        package_ig.release ();
        package_pg.release ();
      }

      // If a compiler error points to the line below, then
      // it most likely means that a pointer used in view
      // member cannot be initialized from an object pointer.
      //
      o.package = ::std::shared_ptr< ::bpkg::available_package > (
        std::move (package_p));
    }
  }

  access::view_traits_impl< ::bpkg::available_test, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::available_test, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"package\".\"name\", "
      "\"package\".\"version_epoch\", "
      "\"package\".\"version_canonical_upstream\", "
      "\"package\".\"version_canonical_release\", "
      "\"package\".\"version_revision\", "
      "\"package\".\"version_iteration\", "
      "\"package\".\"version_upstream\", "
      "\"package\".\"version_release\", "
      "\"package\".\"upstream_version\", "
      "\"package\".\"type\", "
      "\"package\".\"project\", "
      "\"package\".\"alt_naming\", "
      "\"package\".\"bootstrap_build\", "
      "\"package\".\"root_build\", "
      "\"package\".\"sha256sum\" ");

    r += "FROM \"main\".\"available_package\" AS \"package\"";

    r += " INNER JOIN \"main\".\"available_package_dependencies\" AS \"pd\" ON";
    // From package.hxx:765:5
    r += "pd.type IN ('tests', 'examples', 'benchmarks') AND pd.name = " + query_columns::id.name + "AND" + "pd.version_epoch = " + query_columns::id.version.epoch + "AND" + "pd.version_canonical_upstream = " + query_columns::id.version.canonical_upstream + "AND" + "pd.version_canonical_release = " + query_columns::id.version.canonical_release + "AND" + "pd.version_revision = " + query_columns::id.version.revision + "AND" + "pd.version_iteration = " + query_columns::id.version.iteration;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::available_test, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::available_test, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::available_test, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::available_test, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // available_main
  //

  const char alias_traits<  ::bpkg::available_package,
    id_sqlite,
    access::view_traits_impl< ::bpkg::available_main, id_sqlite >::package_tag>::
  table_name[] = "\"package\"";

  bool access::view_traits_impl< ::bpkg::available_main, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // package
    //
    if (object_traits_impl< ::bpkg::available_package, id_sqlite >::grow (
          i.package_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::available_main, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // package
    //
    object_traits_impl< ::bpkg::available_package, id_sqlite >::bind (
      b + n, i.package_value, sk);
    n += 15UL;
  }

  void access::view_traits_impl< ::bpkg::available_main, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (*db));

    // package pre
    //
    typedef ::bpkg::available_package package_object_type;
    typedef object_traits_impl<package_object_type, id_sqlite> package_object_traits;
    typedef package_object_traits::pointer_type package_pointer_type;
    typedef package_object_traits::pointer_traits package_pointer_traits;
    typedef package_object_traits::pointer_cache_traits package_cache_traits;

    package_object_traits::id_type package_id;
    package_pointer_type package_p;
    package_pointer_traits::guard package_pg;
    package_cache_traits::insert_guard package_ig;
    package_object_type* package_o (0);

    {
      if (!composite_value_traits< package_object_traits::id_type, id_sqlite >::get_null (
            i.package_value.id_value))
      {
        package_id = package_object_traits::id (i.package_value);
        package_p = package_cache_traits::find (*db, package_id);

        if (package_pointer_traits::null_ptr (package_p))
        {
          package_p = object_factory<package_object_type, package_pointer_type>::create ();
          package_pg.reset (package_p);
          package_ig.reset (package_cache_traits::insert (*db, package_id, package_p));
          package_o = package_pointer_traits::get_ptr (package_p);
        }
      }
    }

    // package
    //
    {
      if (package_o != 0)
      {
        package_object_traits::callback (*db, *package_o, callback_event::pre_load);
        package_object_traits::init (*package_o, i.package_value, db);
        package_object_traits::statements_type& sts (
          conn.statement_cache ().find_object<package_object_type> ());
        package_object_traits::statements_type::auto_lock l (sts);
        assert (l.locked ()) /* Must be a top-level call. */;

        package_object_traits::id_image_type& i (sts.id_image ());
        package_object_traits::init (i, package_id);
        sqlite::binding& idb (sts.id_image_binding ());
        if (i.version != sts.id_image_version () || idb.version == 0)
        {
          package_object_traits::bind (idb.bind, i);
          sts.id_image_version (i.version);
          idb.version++;
        }

        package_object_traits::load_ (sts, *package_o, false);
        sts.load_delayed (0);
        l.unlock ();
      }
    }

    // package post
    //
    {
      if (package_o != 0)
      {
        package_object_traits::callback (*db, *package_o, callback_event::post_load);
        package_cache_traits::load (package_ig.position ());
        package_ig.release ();
        package_pg.release ();
      }

      // If a compiler error points to the line below, then
      // it most likely means that a pointer used in view
      // member cannot be initialized from an object pointer.
      //
      o.package = ::std::shared_ptr< ::bpkg::available_package > (
        std::move (package_p));
    }
  }

  access::view_traits_impl< ::bpkg::available_main, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::available_main, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT DISTINCT "
      "\"package\".\"name\", "
      "\"package\".\"version_epoch\", "
      "\"package\".\"version_canonical_upstream\", "
      "\"package\".\"version_canonical_release\", "
      "\"package\".\"version_revision\", "
      "\"package\".\"version_iteration\", "
      "\"package\".\"version_upstream\", "
      "\"package\".\"version_release\", "
      "\"package\".\"upstream_version\", "
      "\"package\".\"type\", "
      "\"package\".\"project\", "
      "\"package\".\"alt_naming\", "
      "\"package\".\"bootstrap_build\", "
      "\"package\".\"root_build\", "
      "\"package\".\"sha256sum\" ");

    r += "FROM \"main\".\"available_package\" AS \"package\"";

    r += " INNER JOIN \"main\".\"available_package_tests\" AS \"pt\" ON";
    // From package.hxx:784:5
    r += "pt.name = " + query_columns::id.name + "AND" + "pt.version_epoch = " + query_columns::id.version.epoch + "AND" + "pt.version_canonical_upstream = " + query_columns::id.version.canonical_upstream + "AND" + "pt.version_canonical_release = " + query_columns::id.version.canonical_release + "AND" + "pt.version_revision = " + query_columns::id.version.revision + "AND" + "pt.version_iteration = " + query_columns::id.version.iteration;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::available_main, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::available_main, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::available_main, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::available_main, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // prerequisite_info
  //

  bool access::composite_value_traits< ::bpkg::prerequisite_info, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // constraint
    //
    if (composite_value_traits< ::bpkg::version_constraint, id_sqlite >::grow (
          i.constraint_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::composite_value_traits< ::bpkg::prerequisite_info, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // constraint
    //
    composite_value_traits< ::bpkg::version_constraint, id_sqlite >::bind (
      b + n, i.constraint_value, sk);
    n += 16UL;
  }

  bool access::composite_value_traits< ::bpkg::prerequisite_info, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // constraint
    //
    {
      ::butl::optional< ::bpkg::version_constraint > const& v =
        o.constraint;

      if (wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::get_null (v))
        composite_value_traits< ::bpkg::version_constraint, id_sqlite >::set_null (
          i.constraint_value, sk);
      else
      {
        const::bpkg::version_constraint& vw = 
          wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::get_ref (v);

        if (composite_value_traits< ::bpkg::version_constraint, id_sqlite >::init (
              i.constraint_value,
              vw,
              sk))
          grew = true;
      }
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::prerequisite_info, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // constraint
    //
    {
      ::butl::optional< ::bpkg::version_constraint >& v =
        o.constraint;

      if (composite_value_traits< ::bpkg::version_constraint, id_sqlite >::get_null (
            i.constraint_value))
        wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_null (v);
      else
      {
        ::bpkg::version_constraint& vw =
          wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_ref (v);

        composite_value_traits< ::bpkg::version_constraint, id_sqlite >::init (
          vw,
          i.constraint_value,
          db);
      }
    }
  }

  // _selected_package_ref
  //

  bool access::composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // configuration
    //
    if (t[0UL])
    {
      i.configuration_value.capacity (i.configuration_size);
      grew = true;
    }

    // prerequisite
    //
    if (t[1UL])
    {
      i.prerequisite_value.capacity (i.prerequisite_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // configuration
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.configuration_value.data ();
    b[n].size = &i.configuration_size;
    b[n].capacity = i.configuration_value.capacity ();
    b[n].is_null = &i.configuration_null;
    n++;

    // prerequisite
    //
    b[n].type = sqlite::image_traits<
      ::bpkg::package_name,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.prerequisite_value.data ();
    b[n].size = &i.prerequisite_size;
    b[n].capacity = i.prerequisite_value.capacity ();
    b[n].is_null = &i.prerequisite_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // configuration
    //
    {
      ::butl::uuid const& v =
        o.configuration;

      // From package.hxx:42:14
      ::std::string const& vt =
        (v).string ();

      bool is_null (false);
      std::size_t cap (i.configuration_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.configuration_value,
        i.configuration_size,
        is_null,
        vt);
      i.configuration_null = is_null;
      grew = grew || (cap != i.configuration_value.capacity ());
    }

    // prerequisite
    //
    {
      ::bpkg::package_name const& v =
        o.prerequisite;

      bool is_null (false);
      std::size_t cap (i.prerequisite_value.capacity ());
      sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::set_image (
        i.prerequisite_value,
        i.prerequisite_size,
        is_null,
        v);
      i.prerequisite_null = is_null;
      grew = grew || (cap != i.prerequisite_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // configuration
    //
    {
      ::butl::uuid& v =
        o.configuration;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.configuration_value,
        i.configuration_size,
        i.configuration_null);

      // From package.hxx:42:14
      v = bpkg::uuid (vt);
    }

    // prerequisite
    //
    {
      ::bpkg::package_name& v =
        o.prerequisite;

      sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::set_value (
        v,
        i.prerequisite_value,
        i.prerequisite_size,
        i.prerequisite_null);
    }
  }

  // config_variable
  //

  bool access::composite_value_traits< ::bpkg::config_variable, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // source
    //
    if (t[1UL])
    {
      i.source_value.capacity (i.source_size);
      grew = true;
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::config_variable, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (b);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);
    ODB_POTENTIALLY_UNUSED (n);

    // name
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.name_value.data ();
    b[n].size = &i.name_size;
    b[n].capacity = i.name_value.capacity ();
    b[n].is_null = &i.name_null;
    n++;

    // source
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.source_value.data ();
    b[n].size = &i.source_size;
    b[n].capacity = i.source_value.capacity ();
    b[n].is_null = &i.source_null;
    n++;
  }

  bool access::composite_value_traits< ::bpkg::config_variable, id_sqlite >::
  init (image_type& i,
        const value_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // name
    //
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t cap (i.name_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.name_value,
        i.name_size,
        is_null,
        v);
      i.name_null = is_null;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // source
    //
    {
      ::bpkg::config_source const& v =
        o.source;

      // From package.hxx:964:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t cap (i.source_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.source_value,
        i.source_size,
        is_null,
        vt);
      i.source_null = is_null;
      grew = grew || (cap != i.source_value.capacity ());
    }

    return grew;
  }

  void access::composite_value_traits< ::bpkg::config_variable, id_sqlite >::
  init (value_type& o,
        const image_type&  i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::std::string& v =
        o.name;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // source
    //
    {
      ::bpkg::config_source& v =
        o.source;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.source_value,
        i.source_size,
        i.source_null);

      // From package.hxx:964:14
      v = bpkg::to_config_source (vt);
    }
  }

  // selected_package
  //

  struct access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::extra_statement_cache_type
  {
    sqlite::container_statements_impl< prerequisites_traits > prerequisites;
    sqlite::container_statements_impl< dependency_alternatives_traits > dependency_alternatives;
    sqlite::container_statements_impl< config_variables_traits > config_variables;

    sqlite::section_statements< ::bpkg::selected_package, dependency_alternatives_section_traits > dependency_alternatives_section;
    sqlite::section_statements< ::bpkg::selected_package, manifest_section_traits > manifest_section;

    extra_statement_cache_type (
      sqlite::connection& c,
      image_type& im,
      id_image_type& idim,
      sqlite::binding& id,
      sqlite::binding& idv)
    : prerequisites (c, id),
      dependency_alternatives (c, id),
      config_variables (c, id),
      dependency_alternatives_section (c, im, idim, id, idv),
      manifest_section (c, im, idim, id, idv)
    {
    }
  };

  // prerequisites
  //

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"selected_package_prerequisites\".\"configuration\", "
  "\"main\".\"selected_package_prerequisites\".\"prerequisite\", "
  "\"main\".\"selected_package_prerequisites\".\"min_version_epoch\", "
  "\"main\".\"selected_package_prerequisites\".\"min_version_canonical_upstream\", "
  "\"main\".\"selected_package_prerequisites\".\"min_version_canonical_release\", "
  "\"main\".\"selected_package_prerequisites\".\"min_version_revision\", "
  "\"main\".\"selected_package_prerequisites\".\"min_version_iteration\", "
  "\"main\".\"selected_package_prerequisites\".\"min_version_upstream\", "
  "\"main\".\"selected_package_prerequisites\".\"min_version_release\", "
  "\"main\".\"selected_package_prerequisites\".\"max_version_epoch\", "
  "\"main\".\"selected_package_prerequisites\".\"max_version_canonical_upstream\", "
  "\"main\".\"selected_package_prerequisites\".\"max_version_canonical_release\", "
  "\"main\".\"selected_package_prerequisites\".\"max_version_revision\", "
  "\"main\".\"selected_package_prerequisites\".\"max_version_iteration\", "
  "\"main\".\"selected_package_prerequisites\".\"max_version_upstream\", "
  "\"main\".\"selected_package_prerequisites\".\"max_version_release\", "
  "\"main\".\"selected_package_prerequisites\".\"min_open\", "
  "\"main\".\"selected_package_prerequisites\".\"max_open\" "
  "FROM \"main\".\"selected_package_prerequisites\" "
  "WHERE \"main\".\"selected_package_prerequisites\".\"package\"=?";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"selected_package_prerequisites\" "
  "(\"package\", "
  "\"configuration\", "
  "\"prerequisite\", "
  "\"min_version_epoch\", "
  "\"min_version_canonical_upstream\", "
  "\"min_version_canonical_release\", "
  "\"min_version_revision\", "
  "\"min_version_iteration\", "
  "\"min_version_upstream\", "
  "\"min_version_release\", "
  "\"max_version_epoch\", "
  "\"max_version_canonical_upstream\", "
  "\"max_version_canonical_release\", "
  "\"max_version_revision\", "
  "\"max_version_iteration\", "
  "\"max_version_upstream\", "
  "\"max_version_release\", "
  "\"min_open\", "
  "\"max_open\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"selected_package_prerequisites\" "
  "WHERE \"package\"=?";

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // key
    //
    composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >::bind (
      b + n, d.key_value, sk);
    n += 2UL;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // key
    //
    if (composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >::grow (
          i.key_value, t + 0UL))
      grew = true;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 2UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  init (data_image_type& i,
        const key_type* k,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // key
    //
    if (k != 0)
    {
      // From package.hxx:946:14
      ::bpkg::_selected_package_ref const& vt =
        bpkg::_selected_package_ref (*k);

      if (composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >::init (
            i.key_value,
            vt,
            sk))
        grew = true;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  init (key_type& k,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // key
    //
    {
      ::bpkg::_selected_package_ref vt;

      composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >::init (
        vt,
        i.key_value,
        db);

      // From package.hxx:946:14
      k = std::move (vt).to_ptr ( * db);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  insert (const key_type& k, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &k, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  select (key_type& k, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (k, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::prerequisites_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    container_traits_type::erase (fs);
  }

  // dependency_alternatives
  //

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"selected_package_dependency_alternatives\".\"index\", "
  "\"main\".\"selected_package_dependency_alternatives\".\"position\" "
  "FROM \"main\".\"selected_package_dependency_alternatives\" "
  "WHERE \"main\".\"selected_package_dependency_alternatives\".\"package\"=? ORDER BY \"main\".\"selected_package_dependency_alternatives\".\"index\"";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"selected_package_dependency_alternatives\" "
  "(\"package\", "
  "\"index\", "
  "\"position\") "
  "VALUES "
  "(?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"selected_package_dependency_alternatives\" "
  "WHERE \"package\"=?";

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &d.value_value;
    b[n].is_null = &d.value_null;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = false;

    // value
    //
    t[1UL] = false;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_image (
        i.index_value,
        is_null,
        *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      bool is_null (false);
      sqlite::value_traits<
          value_type,
          sqlite::id_integer >::set_image (
        i.value_value,
        is_null,
        v);
      i.value_null = is_null;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      sqlite::value_traits<
          value_type,
          sqlite::id_integer >::set_value (
        v,
        i.value_value,
        i.value_null);
    }
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());
    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());
    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // config_variables
  //

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"selected_package_config_variables\".\"index\", "
  "\"main\".\"selected_package_config_variables\".\"name\", "
  "\"main\".\"selected_package_config_variables\".\"source\" "
  "FROM \"main\".\"selected_package_config_variables\" "
  "WHERE \"main\".\"selected_package_config_variables\".\"package\"=? ORDER BY \"main\".\"selected_package_config_variables\".\"index\"";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  insert_statement[] =
  "INSERT INTO \"main\".\"selected_package_config_variables\" "
  "(\"package\", "
  "\"index\", "
  "\"name\", "
  "\"source\") "
  "VALUES "
  "(?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  delete_statement[] =
  "DELETE FROM \"main\".\"selected_package_config_variables\" "
  "WHERE \"package\"=?";

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        data_image_type& d)
  {
    using namespace sqlite;

    statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    size_t n (0);

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    // index
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &d.index_value;
    b[n].is_null = &d.index_null;
    n++;

    // value
    //
    composite_value_traits< value_type, id_sqlite >::bind (
      b + n, d.value_value, sk);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  grow (data_image_type& i,
        bool* t)
  {
    bool grew (false);

    // index
    //
    t[0UL] = false;

    // value
    //
    if (composite_value_traits< value_type, id_sqlite >::grow (
          i.value_value, t + 1UL))
      grew = true;

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  init (data_image_type& i,
        index_type* j,
        const value_type& v)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // index
    //
    if (j != 0)
    {
      bool is_null (false);
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_image (
        i.index_value,
        is_null,
        *j);
      i.index_null = is_null;
    }

    // value
    //
    {
      if (composite_value_traits< value_type, id_sqlite >::init (
            i.value_value,
            v,
            sk))
        grew = true;
    }

    if (grew)
      i.version++;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  init (index_type& j,
        value_type& v,
        const data_image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // index
    //
    {
      sqlite::value_traits<
          index_type,
          sqlite::id_integer >::set_value (
        j,
        i.index_value,
        i.index_null);
    }

    // value
    //
    {
      composite_value_traits< value_type, id_sqlite >::init (
        v,
        i.value_value,
        db);
    }
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  insert (index_type i, const value_type& v, void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (di, &i, v);

    if (sts.data_binding_test_version ())
    {
      const binding& id (sts.id_binding ());
      bind (sts.data_bind (), id.bind, id.count, di);
      sts.data_binding_update_version ();
    }

    if (!sts.insert_statement ().execute ())
      throw object_already_persistent ();
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  select (index_type& i, value_type& v, void* d)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (*static_cast< statements_type* > (d));
    data_image_type& di (sts.data_image ());

    init (i, v, di, &sts.connection ().database ());

    select_statement& st (sts.select_statement ());
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, sts.id_binding ().count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  delete_ (void* d)
  {
    using namespace sqlite;

    statements_type& sts (*static_cast< statements_type* > (d));
    sts.delete_statement ().execute ();
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  persist (const container_type& c,
           statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::persist (c, fs);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  load (container_type& c,
        statements_type& sts)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    const binding& id (sts.id_binding ());

    if (sts.data_binding_test_version ())
    {
      bind (sts.data_bind (), id.bind, id.count, sts.data_image ());
      sts.data_binding_update_version ();
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      data_image_type& di (sts.data_image ());
      grow (di, sts.select_image_truncated ());

      if (sts.data_binding_test_version ())
      {
        bind (sts.data_bind (), 0, id.count, di);
        sts.data_binding_update_version ();
        st.refetch ();
      }
    }

    bool more (r != select_statement::no_data);

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::load (c, more, fs);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  update (const container_type& c,
          statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::update (c, fs);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::config_variables_traits::
  erase (statements_type& sts)
  {
    using namespace sqlite;

    functions_type& fs (sts.functions ());
    fs.ordered_ = true;
    container_traits_type::erase (fs);
  }

  // dependency_alternatives_section
  //

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    // dependency_alternatives
    //
    {
      ::bpkg::selected_package::indexes_type& v =
        obj.dependency_alternatives;

      dependency_alternatives_traits::load (
        v,
        esc.dependency_alternatives);
    }
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::dependency_alternatives_section_traits::
  update (extra_statement_cache_type& esc, const object_type& obj)
  {
    // dependency_alternatives
    //
    {
      ::bpkg::selected_package::indexes_type const& v =
        obj.dependency_alternatives;

      dependency_alternatives_traits::update (
        v,
        esc.dependency_alternatives);
    }
  }

  // manifest_section
  //

  std::size_t access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::manifest_section_traits::
  bind (sqlite::bind* b,
        const sqlite::bind* id,
        std::size_t id_size,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);

    // manifest
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.manifest_value.data ();
    b[n].size = &i.manifest_size;
    b[n].capacity = i.manifest_value.capacity ();
    b[n].is_null = &i.manifest_null;
    n++;

    // object_id
    //
    if (id != 0)
      std::memcpy (&b[n], id, id_size * sizeof (id[0]));
    n += id_size;

    return n;
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::manifest_section_traits::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // manifest
    //
    if (t[0UL])
    {
      i.manifest_value.capacity (i.manifest_size);
      grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::manifest_section_traits::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (db);

    // manifest
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.manifest;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.manifest_value,
        i.manifest_size,
        i.manifest_null);
    }
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::manifest_section_traits::
  init (image_type& i,
        const object_type& o)
  {
    using namespace sqlite;

    statement_kind sk (statement_insert);
    ODB_POTENTIALLY_UNUSED (sk);

    bool grew (false);

    // manifest
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.manifest;

      bool is_null (true);
      std::size_t cap (i.manifest_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.manifest_value,
        i.manifest_size,
        is_null,
        v);
      i.manifest_null = is_null;
      grew = grew || (cap != i.manifest_value.capacity ());
    }

    return grew;
  }

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::manifest_section_traits::
  select_statement[] =
  "SELECT "
  "\"main\".\"selected_package\".\"manifest\" "
  "FROM \"main\".\"selected_package\" "
  "WHERE \"main\".\"selected_package\".\"name\"=?";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::manifest_section_traits::
  update_statement[] =
  "UPDATE \"main\".\"selected_package\" "
  "SET "
  "\"manifest\"=? "
  "WHERE \"name\"=?";

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::manifest_section_traits::
  load (extra_statement_cache_type& esc, object_type& obj)
  {
    using namespace sqlite;
    using sqlite::select_statement;

    statements_type& sts (esc.manifest_section);

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, 0, 0, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.select_statement ());
    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::no_data)
      throw object_not_persistent ();

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, 0, 0, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    init (obj, im, &sts.connection ().database ());
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::manifest_section_traits::
  update (extra_statement_cache_type& esc, const object_type& obj)
  {
    using namespace sqlite;
    using sqlite::update_statement;

    statements_type& sts (esc.manifest_section);

    image_type& im (sts.image ());
    const binding& id (sts.idv_binding ());
    binding& imb (sts.update_image_binding ());

    if (init (im, obj))
      im.version++;

    if (im.version != sts.update_image_version () ||
        id.version != sts.update_id_binding_version () ||
        imb.version == 0)
    {
      bind (imb.bind, id.bind, id.count, im, statement_update);
      sts.update_image_version (im.version);
      sts.update_id_binding_version (id.version);
      imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();
  }

  access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::id_type
  access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  id (const image_type& i)
  {
    sqlite::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::set_value (
        id,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    return id;
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // version
    //
    if (composite_value_traits< ::bpkg::_version, id_sqlite >::grow (
          i.version_value, t + 1UL))
      grew = true;

    // state
    //
    if (t[8UL])
    {
      i.state_value.capacity (i.state_size);
      grew = true;
    }

    // substate
    //
    if (t[9UL])
    {
      i.substate_value.capacity (i.substate_size);
      grew = true;
    }

    // hold_package
    //
    t[10UL] = false;

    // hold_version
    //
    t[11UL] = false;

    // repository_fragment
    //
    if (composite_value_traits< ::bpkg::_repository_location, id_sqlite >::grow (
          i.repository_fragment_value, t + 12UL))
      grew = true;

    // archive
    //
    if (t[14UL])
    {
      i.archive_value.capacity (i.archive_size);
      grew = true;
    }

    // purge_archive
    //
    t[15UL] = false;

    // src_root
    //
    if (t[16UL])
    {
      i.src_root_value.capacity (i.src_root_size);
      grew = true;
    }

    // purge_src
    //
    t[17UL] = false;

    // manifest_checksum
    //
    if (t[18UL])
    {
      i.manifest_checksum_value.capacity (i.manifest_checksum_size);
      grew = true;
    }

    // buildfiles_checksum
    //
    if (t[19UL])
    {
      i.buildfiles_checksum_value.capacity (i.buildfiles_checksum_size);
      grew = true;
    }

    // out_root
    //
    if (t[20UL])
    {
      i.out_root_value.capacity (i.out_root_size);
      grew = true;
    }

    // config_checksum
    //
    if (t[21UL])
    {
      i.config_checksum_value.capacity (i.config_checksum_size);
      grew = true;
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);

    // name
    //
    if (sk != statement_update)
    {
      b[n].type = sqlite::image_traits<
        ::bpkg::package_name,
        sqlite::id_text>::bind_value;
      b[n].buffer = i.name_value.data ();
      b[n].size = &i.name_size;
      b[n].capacity = i.name_value.capacity ();
      b[n].is_null = &i.name_null;
      n++;
    }

    // version
    //
    composite_value_traits< ::bpkg::_version, id_sqlite >::bind (
      b + n, i.version_value, sk);
    n += 7UL;

    // state
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.state_value.data ();
    b[n].size = &i.state_size;
    b[n].capacity = i.state_value.capacity ();
    b[n].is_null = &i.state_null;
    n++;

    // substate
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.substate_value.data ();
    b[n].size = &i.substate_size;
    b[n].capacity = i.substate_value.capacity ();
    b[n].is_null = &i.substate_null;
    n++;

    // hold_package
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.hold_package_value;
    b[n].is_null = &i.hold_package_null;
    n++;

    // hold_version
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.hold_version_value;
    b[n].is_null = &i.hold_version_null;
    n++;

    // repository_fragment
    //
    composite_value_traits< ::bpkg::_repository_location, id_sqlite >::bind (
      b + n, i.repository_fragment_value, sk);
    n += 2UL;

    // archive
    //
    b[n].type = sqlite::image_traits<
      ::bpkg::optional_string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.archive_value.data ();
    b[n].size = &i.archive_size;
    b[n].capacity = i.archive_value.capacity ();
    b[n].is_null = &i.archive_null;
    n++;

    // purge_archive
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.purge_archive_value;
    b[n].is_null = &i.purge_archive_null;
    n++;

    // src_root
    //
    b[n].type = sqlite::image_traits<
      ::bpkg::optional_string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.src_root_value.data ();
    b[n].size = &i.src_root_size;
    b[n].capacity = i.src_root_value.capacity ();
    b[n].is_null = &i.src_root_null;
    n++;

    // purge_src
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.purge_src_value;
    b[n].is_null = &i.purge_src_null;
    n++;

    // manifest_checksum
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.manifest_checksum_value.data ();
    b[n].size = &i.manifest_checksum_size;
    b[n].capacity = i.manifest_checksum_value.capacity ();
    b[n].is_null = &i.manifest_checksum_null;
    n++;

    // buildfiles_checksum
    //
    b[n].type = sqlite::image_traits<
      ::butl::optional< ::std::basic_string< char > >,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.buildfiles_checksum_value.data ();
    b[n].size = &i.buildfiles_checksum_size;
    b[n].capacity = i.buildfiles_checksum_value.capacity ();
    b[n].is_null = &i.buildfiles_checksum_null;
    n++;

    // out_root
    //
    b[n].type = sqlite::image_traits<
      ::bpkg::optional_string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.out_root_value.data ();
    b[n].size = &i.out_root_size;
    b[n].capacity = i.out_root_value.capacity ();
    b[n].is_null = &i.out_root_null;
    n++;

    // config_checksum
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.config_checksum_value.data ();
    b[n].size = &i.config_checksum_size;
    b[n].capacity = i.config_checksum_value.capacity ();
    b[n].is_null = &i.config_checksum_null;
    n++;

    // manifest
    //
    if (sk == statement_insert)
    {
      b[n].type = sqlite::image_traits<
        ::butl::optional< ::std::basic_string< char > >,
        sqlite::id_text>::bind_value;
      b[n].buffer = i.manifest_value.data ();
      b[n].size = &i.manifest_size;
      b[n].capacity = i.manifest_value.capacity ();
      b[n].is_null = &i.manifest_null;
      n++;
    }
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  bind (sqlite::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    b[n].type = sqlite::image_traits<
      ::bpkg::package_name,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.id_value.data ();
    b[n].size = &i.id_size;
    b[n].capacity = i.id_value.capacity ();
    b[n].is_null = &i.id_null;
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  init (image_type& i,
        const object_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // name
    //
    if (sk == statement_insert)
    {
      ::bpkg::package_name const& v =
        o.name;

      bool is_null (false);
      std::size_t cap (i.name_value.capacity ());
      sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::set_image (
        i.name_value,
        i.name_size,
        is_null,
        v);
      i.name_null = is_null;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // version
    //
    {
      ::bpkg::selected_package::version_type const& v =
        o.version;

      // From package-common.hxx:213:14
      ::bpkg::_version const& vt =
        bpkg::_version 
      {
         (v).epoch, (v).canonical_upstream, (v).canonical_release, (v).revision, (v).iteration, (v).upstream, (v).release 
      };


      if (composite_value_traits< ::bpkg::_version, id_sqlite >::init (
            i.version_value,
            vt,
            sk))
        grew = true;
    }

    // state
    //
    {
      ::bpkg::package_state const& v =
        o.state;

      // From package.hxx:831:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t cap (i.state_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.state_value,
        i.state_size,
        is_null,
        vt);
      i.state_null = is_null;
      grew = grew || (cap != i.state_value.capacity ());
    }

    // substate
    //
    {
      ::bpkg::package_substate const& v =
        o.substate;

      // From package.hxx:852:14
      ::std::string const& vt =
        to_string (v);

      bool is_null (false);
      std::size_t cap (i.substate_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.substate_value,
        i.substate_size,
        is_null,
        vt);
      i.substate_null = is_null;
      grew = grew || (cap != i.substate_value.capacity ());
    }

    // hold_package
    //
    {
      bool const& v =
        o.hold_package;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.hold_package_value,
        is_null,
        v);
      i.hold_package_null = is_null;
    }

    // hold_version
    //
    {
      bool const& v =
        o.hold_version;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.hold_version_value,
        is_null,
        v);
      i.hold_version_null = is_null;
    }

    // repository_fragment
    //
    {
      ::bpkg::repository_location const& v =
        o.repository_fragment;

      // From package.hxx:167:14
      ::bpkg::_repository_location const& vt =
        bpkg::_repository_location 
      {
         (v).url (), (v).empty () ? bpkg::repository_type::pkg : (v).type () 
      };


      if (composite_value_traits< ::bpkg::_repository_location, id_sqlite >::init (
            i.repository_fragment_value,
            vt,
            sk))
        grew = true;
    }

    // archive
    //
    {
      ::butl::optional< ::butl::basic_path< char, ::butl::any_path_kind< char > > > const& v =
        o.archive;

      // From package-common.hxx:75:14
      ::bpkg::optional_string const& vt =
        (v) ? (v)->string () : bpkg::optional_string ();

      bool is_null (true);
      std::size_t cap (i.archive_value.capacity ());
      sqlite::value_traits<
          ::bpkg::optional_string,
          sqlite::id_text >::set_image (
        i.archive_value,
        i.archive_size,
        is_null,
        vt);
      i.archive_null = is_null;
      grew = grew || (cap != i.archive_value.capacity ());
    }

    // purge_archive
    //
    {
      bool const& v =
        o.purge_archive;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.purge_archive_value,
        is_null,
        v);
      i.purge_archive_null = is_null;
    }

    // src_root
    //
    {
      ::butl::optional< ::butl::basic_path< char, ::butl::dir_path_kind< char > > > const& v =
        o.src_root;

      // From package-common.hxx:82:14
      ::bpkg::optional_string const& vt =
        (v) ? (v)->string () : bpkg::optional_string ();

      bool is_null (true);
      std::size_t cap (i.src_root_value.capacity ());
      sqlite::value_traits<
          ::bpkg::optional_string,
          sqlite::id_text >::set_image (
        i.src_root_value,
        i.src_root_size,
        is_null,
        vt);
      i.src_root_null = is_null;
      grew = grew || (cap != i.src_root_value.capacity ());
    }

    // purge_src
    //
    {
      bool const& v =
        o.purge_src;

      bool is_null (false);
      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_image (
        i.purge_src_value,
        is_null,
        v);
      i.purge_src_null = is_null;
    }

    // manifest_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.manifest_checksum;

      bool is_null (true);
      std::size_t cap (i.manifest_checksum_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.manifest_checksum_value,
        i.manifest_checksum_size,
        is_null,
        v);
      i.manifest_checksum_null = is_null;
      grew = grew || (cap != i.manifest_checksum_value.capacity ());
    }

    // buildfiles_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.buildfiles_checksum;

      bool is_null (true);
      std::size_t cap (i.buildfiles_checksum_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.buildfiles_checksum_value,
        i.buildfiles_checksum_size,
        is_null,
        v);
      i.buildfiles_checksum_null = is_null;
      grew = grew || (cap != i.buildfiles_checksum_value.capacity ());
    }

    // out_root
    //
    {
      ::butl::optional< ::butl::basic_path< char, ::butl::dir_path_kind< char > > > const& v =
        o.out_root;

      // From package-common.hxx:82:14
      ::bpkg::optional_string const& vt =
        (v) ? (v)->string () : bpkg::optional_string ();

      bool is_null (true);
      std::size_t cap (i.out_root_value.capacity ());
      sqlite::value_traits<
          ::bpkg::optional_string,
          sqlite::id_text >::set_image (
        i.out_root_value,
        i.out_root_size,
        is_null,
        vt);
      i.out_root_null = is_null;
      grew = grew || (cap != i.out_root_value.capacity ());
    }

    // config_checksum
    //
    {
      ::std::string const& v =
        o.config_checksum;

      bool is_null (false);
      std::size_t cap (i.config_checksum_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.config_checksum_value,
        i.config_checksum_size,
        is_null,
        v);
      i.config_checksum_null = is_null;
      grew = grew || (cap != i.config_checksum_value.capacity ());
    }

    // manifest
    //
    if (sk == statement_insert)
    {
      ::butl::optional< ::std::basic_string< char > > const& v =
        o.manifest;

      bool is_null (true);
      std::size_t cap (i.manifest_value.capacity ());
      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_image (
        i.manifest_value,
        i.manifest_size,
        is_null,
        v);
      i.manifest_null = is_null;
      grew = grew || (cap != i.manifest_value.capacity ());
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::bpkg::package_name& v =
        o.name;

      sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // version
    //
    {
      ::bpkg::selected_package::version_type& v =
        o.version;

      ::bpkg::_version vt;

      composite_value_traits< ::bpkg::_version, id_sqlite >::init (
        vt,
        i.version_value,
        db);

      // From package-common.hxx:213:14
      v = bpkg::version ((vt).epoch, std::move ((vt).upstream), std::move ((vt).release), (vt).revision, (vt).iteration);
    }

    // state
    //
    {
      ::bpkg::package_state& v =
        o.state;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.state_value,
        i.state_size,
        i.state_null);

      // From package.hxx:831:14
      v = bpkg::to_package_state (vt);
    }

    // substate
    //
    {
      ::bpkg::package_substate& v =
        o.substate;

      ::std::string vt;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        vt,
        i.substate_value,
        i.substate_size,
        i.substate_null);

      // From package.hxx:852:14
      v = bpkg::to_package_substate (vt);
    }

    // hold_package
    //
    {
      bool& v =
        o.hold_package;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.hold_package_value,
        i.hold_package_null);
    }

    // hold_version
    //
    {
      bool& v =
        o.hold_version;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.hold_version_value,
        i.hold_version_null);
    }

    // repository_fragment
    //
    {
      ::bpkg::repository_location& v =
        o.repository_fragment;

      ::bpkg::_repository_location vt;

      composite_value_traits< ::bpkg::_repository_location, id_sqlite >::init (
        vt,
        i.repository_fragment_value,
        db);

      // From package.hxx:167:14
      v = bpkg::repository_location (std::move ((vt).url), (vt).type);
    }

    // archive
    //
    {
      ::butl::optional< ::butl::basic_path< char, ::butl::any_path_kind< char > > >& v =
        o.archive;

      ::bpkg::optional_string vt;

      sqlite::value_traits<
          ::bpkg::optional_string,
          sqlite::id_text >::set_value (
        vt,
        i.archive_value,
        i.archive_size,
        i.archive_null);

      // From package-common.hxx:75:14
      v = (vt) ? bpkg::path ( * (vt)) : bpkg::optional_path ();
    }

    // purge_archive
    //
    {
      bool& v =
        o.purge_archive;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.purge_archive_value,
        i.purge_archive_null);
    }

    // src_root
    //
    {
      ::butl::optional< ::butl::basic_path< char, ::butl::dir_path_kind< char > > >& v =
        o.src_root;

      ::bpkg::optional_string vt;

      sqlite::value_traits<
          ::bpkg::optional_string,
          sqlite::id_text >::set_value (
        vt,
        i.src_root_value,
        i.src_root_size,
        i.src_root_null);

      // From package-common.hxx:82:14
      v = (vt) ? bpkg::dir_path ( * (vt)) : bpkg::optional_dir_path ();
    }

    // purge_src
    //
    {
      bool& v =
        o.purge_src;

      sqlite::value_traits<
          bool,
          sqlite::id_integer >::set_value (
        v,
        i.purge_src_value,
        i.purge_src_null);
    }

    // manifest_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.manifest_checksum;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.manifest_checksum_value,
        i.manifest_checksum_size,
        i.manifest_checksum_null);
    }

    // buildfiles_checksum
    //
    {
      ::butl::optional< ::std::basic_string< char > >& v =
        o.buildfiles_checksum;

      sqlite::value_traits<
          ::butl::optional< ::std::basic_string< char > >,
          sqlite::id_text >::set_value (
        v,
        i.buildfiles_checksum_value,
        i.buildfiles_checksum_size,
        i.buildfiles_checksum_null);
    }

    // out_root
    //
    {
      ::butl::optional< ::butl::basic_path< char, ::butl::dir_path_kind< char > > >& v =
        o.out_root;

      ::bpkg::optional_string vt;

      sqlite::value_traits<
          ::bpkg::optional_string,
          sqlite::id_text >::set_value (
        vt,
        i.out_root_value,
        i.out_root_size,
        i.out_root_null);

      // From package-common.hxx:82:14
      v = (vt) ? bpkg::dir_path ( * (vt)) : bpkg::optional_dir_path ();
    }

    // config_checksum
    //
    {
      ::std::string& v =
        o.config_checksum;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.config_checksum_value,
        i.config_checksum_size,
        i.config_checksum_null);
    }
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    {
      bool is_null (false);
      std::size_t cap (i.id_value.capacity ());
      sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::set_image (
        i.id_value,
        i.id_size,
        is_null,
        id);
      i.id_null = is_null;
      grew = grew || (cap != i.id_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::persist_statement[] =
  "INSERT INTO \"main\".\"selected_package\" "
  "(\"name\", "
  "\"version_epoch\", "
  "\"version_canonical_upstream\", "
  "\"version_canonical_release\", "
  "\"version_revision\", "
  "\"version_iteration\", "
  "\"version_upstream\", "
  "\"version_release\", "
  "\"state\", "
  "\"substate\", "
  "\"hold_package\", "
  "\"hold_version\", "
  "\"repository_fragment_url\", "
  "\"repository_fragment_type\", "
  "\"archive\", "
  "\"purge_archive\", "
  "\"src_root\", "
  "\"purge_src\", "
  "\"manifest_checksum\", "
  "\"buildfiles_checksum\", "
  "\"out_root\", "
  "\"config_checksum\", "
  "\"manifest\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::find_statement[] =
  "SELECT "
  "\"main\".\"selected_package\".\"name\", "
  "\"main\".\"selected_package\".\"version_epoch\", "
  "\"main\".\"selected_package\".\"version_canonical_upstream\", "
  "\"main\".\"selected_package\".\"version_canonical_release\", "
  "\"main\".\"selected_package\".\"version_revision\", "
  "\"main\".\"selected_package\".\"version_iteration\", "
  "\"main\".\"selected_package\".\"version_upstream\", "
  "\"main\".\"selected_package\".\"version_release\", "
  "\"main\".\"selected_package\".\"state\", "
  "\"main\".\"selected_package\".\"substate\", "
  "\"main\".\"selected_package\".\"hold_package\", "
  "\"main\".\"selected_package\".\"hold_version\", "
  "\"main\".\"selected_package\".\"repository_fragment_url\", "
  "\"main\".\"selected_package\".\"repository_fragment_type\", "
  "\"main\".\"selected_package\".\"archive\", "
  "\"main\".\"selected_package\".\"purge_archive\", "
  "\"main\".\"selected_package\".\"src_root\", "
  "\"main\".\"selected_package\".\"purge_src\", "
  "\"main\".\"selected_package\".\"manifest_checksum\", "
  "\"main\".\"selected_package\".\"buildfiles_checksum\", "
  "\"main\".\"selected_package\".\"out_root\", "
  "\"main\".\"selected_package\".\"config_checksum\" "
  "FROM \"main\".\"selected_package\" "
  "WHERE \"main\".\"selected_package\".\"name\"=?";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::update_statement[] =
  "UPDATE \"main\".\"selected_package\" "
  "SET "
  "\"version_epoch\"=?, "
  "\"version_canonical_upstream\"=?, "
  "\"version_canonical_release\"=?, "
  "\"version_revision\"=?, "
  "\"version_iteration\"=?, "
  "\"version_upstream\"=?, "
  "\"version_release\"=?, "
  "\"state\"=?, "
  "\"substate\"=?, "
  "\"hold_package\"=?, "
  "\"hold_version\"=?, "
  "\"repository_fragment_url\"=?, "
  "\"repository_fragment_type\"=?, "
  "\"archive\"=?, "
  "\"purge_archive\"=?, "
  "\"src_root\"=?, "
  "\"purge_src\"=?, "
  "\"manifest_checksum\"=?, "
  "\"buildfiles_checksum\"=?, "
  "\"out_root\"=?, "
  "\"config_checksum\"=? "
  "WHERE \"name\"=?";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::erase_statement[] =
  "DELETE FROM \"main\".\"selected_package\" "
  "WHERE \"name\"=?";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::query_statement[] =
  "SELECT "
  "\"main\".\"selected_package\".\"name\", "
  "\"main\".\"selected_package\".\"version_epoch\", "
  "\"main\".\"selected_package\".\"version_canonical_upstream\", "
  "\"main\".\"selected_package\".\"version_canonical_release\", "
  "\"main\".\"selected_package\".\"version_revision\", "
  "\"main\".\"selected_package\".\"version_iteration\", "
  "\"main\".\"selected_package\".\"version_upstream\", "
  "\"main\".\"selected_package\".\"version_release\", "
  "\"main\".\"selected_package\".\"state\", "
  "\"main\".\"selected_package\".\"substate\", "
  "\"main\".\"selected_package\".\"hold_package\", "
  "\"main\".\"selected_package\".\"hold_version\", "
  "\"main\".\"selected_package\".\"repository_fragment_url\", "
  "\"main\".\"selected_package\".\"repository_fragment_type\", "
  "\"main\".\"selected_package\".\"archive\", "
  "\"main\".\"selected_package\".\"purge_archive\", "
  "\"main\".\"selected_package\".\"src_root\", "
  "\"main\".\"selected_package\".\"purge_src\", "
  "\"main\".\"selected_package\".\"manifest_checksum\", "
  "\"main\".\"selected_package\".\"buildfiles_checksum\", "
  "\"main\".\"selected_package\".\"out_root\", "
  "\"main\".\"selected_package\".\"config_checksum\" "
  "FROM \"main\".\"selected_package\"";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::erase_query_statement[] =
  "DELETE FROM \"main\".\"selected_package\"";

  const char access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::table_name[] =
  "\"main\".\"selected_package\"";

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  persist (database& db, const object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // prerequisites
    //
    {
      ::bpkg::package_prerequisites const& v =
        obj.prerequisites;

      prerequisites_traits::persist (
        v,
        esc.prerequisites);
    }

    // dependency_alternatives
    //
    {
      ::bpkg::selected_package::indexes_type const& v =
        obj.dependency_alternatives;

      dependency_alternatives_traits::persist (
        v,
        esc.dependency_alternatives);
    }

    // config_variables
    //
    {
      ::std::vector< ::bpkg::config_variable > const& v =
        obj.config_variables;

      config_variables_traits::persist (
        v,
        esc.config_variables);
    }

    obj.dependency_alternatives_section.reset (true, false);

    obj.manifest_section.reset (true, false);

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace sqlite;
    using sqlite::update_statement;

    callback (db, obj, callback_event::pre_update);

    sqlite::transaction& tr (sqlite::transaction::current ());
    sqlite::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // prerequisites
    //
    {
      ::bpkg::package_prerequisites const& v =
        obj.prerequisites;

      prerequisites_traits::update (
        v,
        esc.prerequisites);
    }

    // config_variables
    //
    {
      ::std::vector< ::bpkg::config_variable > const& v =
        obj.config_variables;

      config_variables_traits::update (
        v,
        esc.config_variables);
    }

    if (obj.dependency_alternatives_section.loaded ())
    {
      dependency_alternatives_section_traits::update (esc, obj);
    }

    if (obj.manifest_section.loaded ())
    {
      manifest_section_traits::update (esc, obj);
    }

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  erase (database& db, const id_type& id)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // prerequisites
    //
    {
      prerequisites_traits::erase (
        esc.prerequisites);
    }

    // dependency_alternatives
    //
    {
      dependency_alternatives_traits::erase (
        esc.dependency_alternatives);
    }

    // config_variables
    //
    {
      config_variables_traits::erase (
        esc.config_variables);
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::pointer_type
  access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  find (database& db, const id_type& id)
  {
    using namespace sqlite;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  reload (database& db, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  load (connection& conn, object_type& obj, section& s)
  {
    using namespace sqlite;

    sqlite::connection& c (static_cast<sqlite::connection&> (conn));
    statements_type& sts (c.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    bool r (false);

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    if (!r && &s == &obj.dependency_alternatives_section)
    {
      dependency_alternatives_section_traits::load (esc, obj);
      r = true;
    }

    if (!r && &s == &obj.manifest_section)
    {
      manifest_section_traits::load (esc, obj);
      r = true;
    }

    sts.load_delayed (0);
    l.unlock ();
    return r;
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  update (connection& conn, const object_type& obj, const section& s)
  {
    using namespace sqlite;

    sqlite::connection& c (static_cast<sqlite::connection&> (conn));
    statements_type& sts (c.statement_cache ().find_object<object_type> ());
    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    id_image_type& i (sts.id_image ());
    init (i, id (obj));

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (&s == &obj.dependency_alternatives_section)dependency_alternatives_section_traits::update (esc, obj);
    else if (&s == &obj.manifest_section)manifest_section_traits::update (esc, obj);
    else
      return false;

    return true;
  }

  bool access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace sqlite;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  void access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  load_ (statements_type& sts,
         object_type& obj,
         bool reload)
  {
    ODB_POTENTIALLY_UNUSED (reload);

    extra_statement_cache_type& esc (sts.extra_statement_cache ());

    // prerequisites
    //
    {
      ::bpkg::package_prerequisites& v =
        obj.prerequisites;

      prerequisites_traits::load (
        v,
        esc.prerequisites);
    }

    // config_variables
    //
    {
      ::std::vector< ::bpkg::config_variable >& v =
        obj.config_variables;

      config_variables_traits::load (
        v,
        esc.config_variables);
    }

    if (reload)
    {
      if (obj.dependency_alternatives_section.loaded ())
      {
        dependency_alternatives_section_traits::load (esc, obj);
        obj.dependency_alternatives_section.reset (true, false);
      }
    }
    else
      obj.dependency_alternatives_section.reset ();

    if (reload)
    {
      if (obj.manifest_section.loaded ())
      {
        manifest_section_traits::load (esc, obj);
        obj.manifest_section.reset (true, false);
      }
    }
    else
      obj.manifest_section.reset ();
  }

  result< access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::object_type >
  access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        q.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) sqlite::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      text,
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::bpkg::selected_package, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // certificate
  //

  struct access::object_traits_impl< ::bpkg::certificate, id_sqlite >::extra_statement_cache_type
  {
    extra_statement_cache_type (
      sqlite::connection&,
      image_type&,
      id_image_type&,
      sqlite::binding&,
      sqlite::binding&)
    {
    }
  };

  access::object_traits_impl< ::bpkg::certificate, id_sqlite >::id_type
  access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  id (const image_type& i)
  {
    sqlite::database* db (0);
    ODB_POTENTIALLY_UNUSED (db);

    id_type id;
    {
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        id,
        i.id_value,
        i.id_size,
        i.id_null);
    }

    return id;
  }

  bool access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // id
    //
    if (t[0UL])
    {
      i.id_value.capacity (i.id_size);
      grew = true;
    }

    // fingerprint
    //
    if (t[1UL])
    {
      i.fingerprint_value.capacity (i.fingerprint_size);
      grew = true;
    }

    // name
    //
    if (t[2UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // organization
    //
    if (t[3UL])
    {
      i.organization_value.capacity (i.organization_size);
      grew = true;
    }

    // email
    //
    if (t[4UL])
    {
      i.email_value.capacity (i.email_size);
      grew = true;
    }

    // start_date
    //
    t[5UL] = false;

    // end_date
    //
    t[6UL] = false;

    return grew;
  }

  void access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    std::size_t n (0);

    // id
    //
    if (sk != statement_update)
    {
      b[n].type = sqlite::image_traits<
        ::std::string,
        sqlite::id_text>::bind_value;
      b[n].buffer = i.id_value.data ();
      b[n].size = &i.id_size;
      b[n].capacity = i.id_value.capacity ();
      b[n].is_null = &i.id_null;
      n++;
    }

    // fingerprint
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.fingerprint_value.data ();
    b[n].size = &i.fingerprint_size;
    b[n].capacity = i.fingerprint_value.capacity ();
    b[n].is_null = &i.fingerprint_null;
    n++;

    // name
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.name_value.data ();
    b[n].size = &i.name_size;
    b[n].capacity = i.name_value.capacity ();
    b[n].is_null = &i.name_null;
    n++;

    // organization
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.organization_value.data ();
    b[n].size = &i.organization_size;
    b[n].capacity = i.organization_value.capacity ();
    b[n].is_null = &i.organization_null;
    n++;

    // email
    //
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.email_value.data ();
    b[n].size = &i.email_size;
    b[n].capacity = i.email_value.capacity ();
    b[n].is_null = &i.email_null;
    n++;

    // start_date
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.start_date_value;
    b[n].is_null = &i.start_date_null;
    n++;

    // end_date
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.end_date_value;
    b[n].is_null = &i.end_date_null;
    n++;
  }

  void access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  bind (sqlite::bind* b, id_image_type& i)
  {
    std::size_t n (0);
    b[n].type = sqlite::image_traits<
      ::std::string,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.id_value.data ();
    b[n].size = &i.id_size;
    b[n].capacity = i.id_value.capacity ();
    b[n].is_null = &i.id_null;
  }

  bool access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  init (image_type& i,
        const object_type& o,
        sqlite::statement_kind sk)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (sk);

    using namespace sqlite;

    bool grew (false);

    // id
    //
    if (sk == statement_insert)
    {
      ::std::string const& v =
        o.id;

      bool is_null (false);
      std::size_t cap (i.id_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.id_value,
        i.id_size,
        is_null,
        v);
      i.id_null = is_null;
      grew = grew || (cap != i.id_value.capacity ());
    }

    // fingerprint
    //
    {
      ::std::string const& v =
        o.fingerprint;

      bool is_null (false);
      std::size_t cap (i.fingerprint_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.fingerprint_value,
        i.fingerprint_size,
        is_null,
        v);
      i.fingerprint_null = is_null;
      grew = grew || (cap != i.fingerprint_value.capacity ());
    }

    // name
    //
    {
      ::std::string const& v =
        o.name;

      bool is_null (false);
      std::size_t cap (i.name_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.name_value,
        i.name_size,
        is_null,
        v);
      i.name_null = is_null;
      grew = grew || (cap != i.name_value.capacity ());
    }

    // organization
    //
    {
      ::std::string const& v =
        o.organization;

      bool is_null (false);
      std::size_t cap (i.organization_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.organization_value,
        i.organization_size,
        is_null,
        v);
      i.organization_null = is_null;
      grew = grew || (cap != i.organization_value.capacity ());
    }

    // email
    //
    {
      ::std::string const& v =
        o.email;

      bool is_null (false);
      std::size_t cap (i.email_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.email_value,
        i.email_size,
        is_null,
        v);
      i.email_null = is_null;
      grew = grew || (cap != i.email_value.capacity ());
    }

    // start_date
    //
    {
      ::butl::timestamp const& v =
        o.start_date;

      // From package-common.hxx:102:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      sqlite::value_traits<
          ::uint64_t,
          sqlite::id_integer >::set_image (
        i.start_date_value,
        is_null,
        vt);
      i.start_date_null = is_null;
    }

    // end_date
    //
    {
      ::butl::timestamp const& v =
        o.end_date;

      // From package-common.hxx:102:14
      ::uint64_t const& vt =
        std::chrono::duration_cast < std::chrono::nanoseconds > ((v).time_since_epoch ()).count ();

      bool is_null (false);
      sqlite::value_traits<
          ::uint64_t,
          sqlite::id_integer >::set_image (
        i.end_date_value,
        is_null,
        vt);
      i.end_date_null = is_null;
    }

    return grew;
  }

  void access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  init (object_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // id
    //
    {
      ::std::string& v =
        o.id;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.id_value,
        i.id_size,
        i.id_null);
    }

    // fingerprint
    //
    {
      ::std::string& v =
        o.fingerprint;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.fingerprint_value,
        i.fingerprint_size,
        i.fingerprint_null);
    }

    // name
    //
    {
      ::std::string& v =
        o.name;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // organization
    //
    {
      ::std::string& v =
        o.organization;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.organization_value,
        i.organization_size,
        i.organization_null);
    }

    // email
    //
    {
      ::std::string& v =
        o.email;

      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_value (
        v,
        i.email_value,
        i.email_size,
        i.email_null);
    }

    // start_date
    //
    {
      ::butl::timestamp& v =
        o.start_date;

      ::uint64_t vt;

      sqlite::value_traits<
          ::uint64_t,
          sqlite::id_integer >::set_value (
        vt,
        i.start_date_value,
        i.start_date_null);

      // From package-common.hxx:102:14
      v = butl::timestamp (std::chrono::duration_cast < butl::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }

    // end_date
    //
    {
      ::butl::timestamp& v =
        o.end_date;

      ::uint64_t vt;

      sqlite::value_traits<
          ::uint64_t,
          sqlite::id_integer >::set_value (
        vt,
        i.end_date_value,
        i.end_date_null);

      // From package-common.hxx:102:14
      v = butl::timestamp (std::chrono::duration_cast < butl::timestamp::duration > (std::chrono::nanoseconds (vt)));
    }
  }

  void access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  init (id_image_type& i, const id_type& id)
  {
    bool grew (false);
    {
      bool is_null (false);
      std::size_t cap (i.id_value.capacity ());
      sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::set_image (
        i.id_value,
        i.id_size,
        is_null,
        id);
      i.id_null = is_null;
      grew = grew || (cap != i.id_value.capacity ());
    }

    if (grew)
      i.version++;
  }

  const char access::object_traits_impl< ::bpkg::certificate, id_sqlite >::persist_statement[] =
  "INSERT INTO \"main\".\"certificate\" "
  "(\"id\", "
  "\"fingerprint\", "
  "\"name\", "
  "\"organization\", "
  "\"email\", "
  "\"start_date\", "
  "\"end_date\") "
  "VALUES "
  "(?, ?, ?, ?, ?, ?, ?)";

  const char access::object_traits_impl< ::bpkg::certificate, id_sqlite >::find_statement[] =
  "SELECT "
  "\"main\".\"certificate\".\"id\", "
  "\"main\".\"certificate\".\"fingerprint\", "
  "\"main\".\"certificate\".\"name\", "
  "\"main\".\"certificate\".\"organization\", "
  "\"main\".\"certificate\".\"email\", "
  "\"main\".\"certificate\".\"start_date\", "
  "\"main\".\"certificate\".\"end_date\" "
  "FROM \"main\".\"certificate\" "
  "WHERE \"main\".\"certificate\".\"id\"=?";

  const char access::object_traits_impl< ::bpkg::certificate, id_sqlite >::update_statement[] =
  "UPDATE \"main\".\"certificate\" "
  "SET "
  "\"fingerprint\"=?, "
  "\"name\"=?, "
  "\"organization\"=?, "
  "\"email\"=?, "
  "\"start_date\"=?, "
  "\"end_date\"=? "
  "WHERE \"id\"=?";

  const char access::object_traits_impl< ::bpkg::certificate, id_sqlite >::erase_statement[] =
  "DELETE FROM \"main\".\"certificate\" "
  "WHERE \"id\"=?";

  const char access::object_traits_impl< ::bpkg::certificate, id_sqlite >::query_statement[] =
  "SELECT "
  "\"main\".\"certificate\".\"id\", "
  "\"main\".\"certificate\".\"fingerprint\", "
  "\"main\".\"certificate\".\"name\", "
  "\"main\".\"certificate\".\"organization\", "
  "\"main\".\"certificate\".\"email\", "
  "\"main\".\"certificate\".\"start_date\", "
  "\"main\".\"certificate\".\"end_date\" "
  "FROM \"main\".\"certificate\"";

  const char access::object_traits_impl< ::bpkg::certificate, id_sqlite >::erase_query_statement[] =
  "DELETE FROM \"main\".\"certificate\"";

  const char access::object_traits_impl< ::bpkg::certificate, id_sqlite >::table_name[] =
  "\"main\".\"certificate\"";

  void access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  persist (database& db, const object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    callback (db,
              obj,
              callback_event::pre_persist);

    image_type& im (sts.image ());
    binding& imb (sts.insert_image_binding ());

    if (init (im, obj, statement_insert))
      im.version++;

    if (im.version != sts.insert_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_insert);
      sts.insert_image_version (im.version);
      imb.version++;
    }

    insert_statement& st (sts.persist_statement ());
    if (!st.execute ())
      throw object_already_persistent ();

    callback (db,
              obj,
              callback_event::post_persist);
  }

  void access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  update (database& db, const object_type& obj)
  {
    ODB_POTENTIALLY_UNUSED (db);

    using namespace sqlite;
    using sqlite::update_statement;

    callback (db, obj, callback_event::pre_update);

    sqlite::transaction& tr (sqlite::transaction::current ());
    sqlite::connection& conn (tr.connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& idi (sts.id_image ());
    init (idi, id (obj));

    image_type& im (sts.image ());
    if (init (im, obj, statement_update))
      im.version++;

    bool u (false);
    binding& imb (sts.update_image_binding ());
    if (im.version != sts.update_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_update);
      sts.update_image_version (im.version);
      imb.version++;
      u = true;
    }

    binding& idb (sts.id_image_binding ());
    if (idi.version != sts.update_id_image_version () ||
        idb.version == 0)
    {
      if (idi.version != sts.id_image_version () ||
          idb.version == 0)
      {
        bind (idb.bind, idi);
        sts.id_image_version (idi.version);
        idb.version++;
      }

      sts.update_id_image_version (idi.version);

      if (!u)
        imb.version++;
    }

    update_statement& st (sts.update_statement ());
    if (st.execute () == 0)
      throw object_not_persistent ();

    callback (db, obj, callback_event::post_update);
    pointer_cache_traits::update (db, obj);
  }

  void access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  erase (database& db, const id_type& id)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    id_image_type& i (sts.id_image ());
    init (i, id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    if (sts.erase_statement ().execute () != 1)
      throw object_not_persistent ();

    pointer_cache_traits::erase (db, id);
  }

  access::object_traits_impl< ::bpkg::certificate, id_sqlite >::pointer_type
  access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  find (database& db, const id_type& id)
  {
    using namespace sqlite;

    {
      pointer_type p (pointer_cache_traits::find (db, id));

      if (!pointer_traits::null_ptr (p))
        return p;
    }

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);

    if (l.locked ())
    {
      if (!find_ (sts, &id))
        return pointer_type ();
    }

    pointer_type p (
      access::object_factory<object_type, pointer_type>::create ());
    pointer_traits::guard pg (p);

    pointer_cache_traits::insert_guard ig (
      pointer_cache_traits::insert (db, id, p));

    object_type& obj (pointer_traits::get_ref (p));

    if (l.locked ())
    {
      select_statement& st (sts.find_statement ());
      ODB_POTENTIALLY_UNUSED (st);

      callback (db, obj, callback_event::pre_load);
      init (obj, sts.image (), &db);
      load_ (sts, obj, false);
      sts.load_delayed (0);
      l.unlock ();
      callback (db, obj, callback_event::post_load);
      pointer_cache_traits::load (ig.position ());
    }
    else
      sts.delay_load (id, obj, ig.position ());

    ig.release ();
    pg.release ();
    return p;
  }

  bool access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  find (database& db, const id_type& id, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    reference_cache_traits::position_type pos (
      reference_cache_traits::insert (db, id, obj));
    reference_cache_traits::insert_guard ig (pos);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, false);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    reference_cache_traits::load (pos);
    ig.release ();
    return true;
  }

  bool access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  reload (database& db, object_type& obj)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    statements_type::auto_lock l (sts);
    assert (l.locked ()) /* Must be a top-level call. */;

    const id_type& id (object_traits_impl::id (obj));
    if (!find_ (sts, &id))
      return false;

    select_statement& st (sts.find_statement ());
    ODB_POTENTIALLY_UNUSED (st);

    callback (db, obj, callback_event::pre_load);
    init (obj, sts.image (), &db);
    load_ (sts, obj, true);
    sts.load_delayed (0);
    l.unlock ();
    callback (db, obj, callback_event::post_load);
    return true;
  }

  bool access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  find_ (statements_type& sts,
         const id_type* id)
  {
    using namespace sqlite;

    id_image_type& i (sts.id_image ());
    init (i, *id);

    binding& idb (sts.id_image_binding ());
    if (i.version != sts.id_image_version () || idb.version == 0)
    {
      bind (idb.bind, i);
      sts.id_image_version (i.version);
      idb.version++;
    }

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    select_statement& st (sts.find_statement ());

    st.execute ();
    auto_result ar (st);
    select_statement::result r (st.fetch ());

    if (r == select_statement::truncated)
    {
      if (grow (im, sts.select_image_truncated ()))
        im.version++;

      if (im.version != sts.select_image_version ())
      {
        bind (imb.bind, im, statement_select);
        sts.select_image_version (im.version);
        imb.version++;
        st.refetch ();
      }
    }

    return r != select_statement::no_data;
  }

  result< access::object_traits_impl< ::bpkg::certificate, id_sqlite >::object_type >
  access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    q.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        q.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::object_result_impl<object_type> > r (
      new (shared) sqlite::object_result_impl<object_type> (
        q, st, sts, 0));

    return result<object_type> (r);
  }

  unsigned long long access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  erase_query (database& db, const query_base_type& q)
  {
    using namespace sqlite;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));

    std::string text (erase_query_statement);
    if (!q.empty ())
    {
      text += ' ';
      text += q.clause ();
    }

    q.init_parameters ();
    delete_statement st (
      conn,
      text,
      q.parameters_binding ());

    return st.execute ();
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));

    statements_type& sts (
      conn.statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    std::string text (query_statement);
    if (!q.empty ())
    {
      text += " ";
      text += q.clause ();
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = q;
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        text,
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::object_traits_impl< ::bpkg::certificate, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_object<object_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.select_image_binding ());

    if (im.version != sts.select_image_version () ||
        imb.version == 0)
    {
      bind (imb.bind, im, statement_select);
      sts.select_image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::object_result_impl<object_type> (
        pq.query, st, sts, 0));
  }

  // package_dependent
  //

  bool access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // name
    //
    if (t[0UL])
    {
      i.name_value.capacity (i.name_size);
      grew = true;
    }

    // constraint
    //
    if (composite_value_traits< ::bpkg::version_constraint, id_sqlite >::grow (
          i.constraint_value, t + 1UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // name
    //
    b[n].type = sqlite::image_traits<
      ::bpkg::package_name,
      sqlite::id_text>::bind_value;
    b[n].buffer = i.name_value.data ();
    b[n].size = &i.name_size;
    b[n].capacity = i.name_value.capacity ();
    b[n].is_null = &i.name_null;
    n++;

    // constraint
    //
    composite_value_traits< ::bpkg::version_constraint, id_sqlite >::bind (
      b + n, i.constraint_value, sk);
    n += 16UL;
  }

  void access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // name
    //
    {
      ::bpkg::package_name& v =
        o.name;

      sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::set_value (
        v,
        i.name_value,
        i.name_size,
        i.name_null);
    }

    // constraint
    //
    {
      ::butl::optional< ::bpkg::version_constraint >& v =
        o.constraint;

      if (composite_value_traits< ::bpkg::version_constraint, id_sqlite >::get_null (
            i.constraint_value))
        wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_null (v);
      else
      {
        ::bpkg::version_constraint& vw =
          wrapper_traits< ::butl::optional< ::bpkg::version_constraint > >::set_ref (v);

        composite_value_traits< ::bpkg::version_constraint, id_sqlite >::init (
          vw,
          i.constraint_value,
          db);
      }
    }
  }

  access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"pp\".\"package\", "
      "\"pp\".\"min_version_epoch\", "
      "\"pp\".\"min_version_canonical_upstream\", "
      "\"pp\".\"min_version_canonical_release\", "
      "\"pp\".\"min_version_revision\", "
      "\"pp\".\"min_version_iteration\", "
      "\"pp\".\"min_version_upstream\", "
      "\"pp\".\"min_version_release\", "
      "\"pp\".\"max_version_epoch\", "
      "\"pp\".\"max_version_canonical_upstream\", "
      "\"pp\".\"max_version_canonical_release\", "
      "\"pp\".\"max_version_revision\", "
      "\"pp\".\"max_version_iteration\", "
      "\"pp\".\"max_version_upstream\", "
      "\"pp\".\"max_version_release\", "
      "\"pp\".\"min_open\", "
      "\"pp\".\"max_open\" ");

    r += "FROM \"main\".\"selected_package_prerequisites\" AS \"pp\"";

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // fragment_repository_count
  //

  bool access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // result
    //
    t[0UL] = false;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // result
    //
    b[n].type = sqlite::bind::integer;
    b[n].buffer = &i.result_value;
    b[n].is_null = &i.result_null;
    n++;
  }

  void access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    // result
    //
    {
      ::std::size_t& v =
        o.result;

      sqlite::value_traits<
          ::std::size_t,
          sqlite::id_integer >::set_value (
        v,
        i.result_value,
        i.result_null);
    }
  }

  access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "count(*) ");

    r += "FROM \"main\".\"repository_fragments\"";

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // fragment_repository
  //

  bool access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // object
    //
    if (object_traits_impl< ::bpkg::repository, id_sqlite >::grow (
          i.object_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // object
    //
    object_traits_impl< ::bpkg::repository, id_sqlite >::bind (
      b + n, i.object_value, sk);
    n += 5UL;
  }

  void access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (*db));

    // object pre
    //
    typedef ::bpkg::repository object_object_type;
    typedef object_traits_impl<object_object_type, id_sqlite> object_object_traits;
    typedef object_object_traits::pointer_type object_pointer_type;
    typedef object_object_traits::pointer_traits object_pointer_traits;
    typedef object_object_traits::pointer_cache_traits object_cache_traits;

    object_object_traits::id_type object_id;
    object_pointer_type object_p;
    object_pointer_traits::guard object_pg;
    object_cache_traits::insert_guard object_ig;
    object_object_type* object_o (0);

    {
      if (!(i.object_value.name_null))
      {
        object_id = object_object_traits::id (i.object_value);
        object_p = object_cache_traits::find (*db, object_id);

        if (object_pointer_traits::null_ptr (object_p))
        {
          object_p = object_factory<object_object_type, object_pointer_type>::create ();
          object_pg.reset (object_p);
          object_ig.reset (object_cache_traits::insert (*db, object_id, object_p));
          object_o = object_pointer_traits::get_ptr (object_p);
        }
      }
    }

    // object
    //
    {
      if (object_o != 0)
      {
        object_object_traits::callback (*db, *object_o, callback_event::pre_load);
        object_object_traits::init (*object_o, i.object_value, db);
        object_object_traits::statements_type& sts (
          conn.statement_cache ().find_object<object_object_type> ());
        object_object_traits::statements_type::auto_lock l (sts);
        assert (l.locked ()) /* Must be a top-level call. */;

        object_object_traits::id_image_type& i (sts.id_image ());
        object_object_traits::init (i, object_id);
        sqlite::binding& idb (sts.id_image_binding ());
        if (i.version != sts.id_image_version () || idb.version == 0)
        {
          object_object_traits::bind (idb.bind, i);
          sts.id_image_version (i.version);
          idb.version++;
        }

        object_object_traits::load_ (sts, *object_o, false);
        sts.load_delayed (0);
        l.unlock ();
      }
    }

    // object post
    //
    {
      if (object_o != 0)
      {
        object_object_traits::callback (*db, *object_o, callback_event::post_load);
        object_cache_traits::load (object_ig.position ());
        object_ig.release ();
        object_pg.release ();
      }

      // If a compiler error points to the line below, then
      // it most likely means that a pointer used in view
      // member cannot be initialized from an object pointer.
      //
      o.object = ::std::shared_ptr< ::bpkg::repository > (
        std::move (object_p));
    }
  }

  access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"main\".\"repository\".\"name\", "
      "\"main\".\"repository\".\"url\", "
      "\"main\".\"repository\".\"type\", "
      "\"main\".\"repository\".\"certificate\", "
      "\"main\".\"repository\".\"local\" ");

    r += "FROM \"main\".\"repository\"";

    r += " INNER JOIN \"main\".\"repository_fragments\" AS \"rfs\" ON";
    // From package.hxx:1573:5
    r += "rfs.repository = " + query_columns::repository::name;

    r += " INNER JOIN \"main\".\"repository_fragment\" ON";
    // From package.hxx:1575:5
    r += "rfs.fragment = " + query_columns::repository_fragment::name;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // repository_complement_dependent
  //

  const char alias_traits<  ::bpkg::repository,
    id_sqlite,
    access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::complement_tag>::
  table_name[] = "\"complement\"";

  bool access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // object
    //
    if (object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::grow (
          i.object_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // object
    //
    object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::bind (
      b + n, i.object_value, sk);
    n += 3UL;
  }

  void access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (*db));

    // object pre
    //
    typedef ::bpkg::repository_fragment object_object_type;
    typedef object_traits_impl<object_object_type, id_sqlite> object_object_traits;
    typedef object_object_traits::pointer_type object_pointer_type;
    typedef object_object_traits::pointer_traits object_pointer_traits;
    typedef object_object_traits::pointer_cache_traits object_cache_traits;

    object_object_traits::id_type object_id;
    object_pointer_type object_p;
    object_pointer_traits::guard object_pg;
    object_cache_traits::insert_guard object_ig;
    object_object_type* object_o (0);

    {
      if (!(i.object_value.name_null))
      {
        object_id = object_object_traits::id (i.object_value);
        object_p = object_cache_traits::find (*db, object_id);

        if (object_pointer_traits::null_ptr (object_p))
        {
          object_p = object_factory<object_object_type, object_pointer_type>::create ();
          object_pg.reset (object_p);
          object_ig.reset (object_cache_traits::insert (*db, object_id, object_p));
          object_o = object_pointer_traits::get_ptr (object_p);
        }
      }
    }

    // object
    //
    {
      if (object_o != 0)
      {
        object_object_traits::callback (*db, *object_o, callback_event::pre_load);
        object_object_traits::init (*object_o, i.object_value, db);
        object_object_traits::statements_type& sts (
          conn.statement_cache ().find_object<object_object_type> ());
        object_object_traits::statements_type::auto_lock l (sts);
        assert (l.locked ()) /* Must be a top-level call. */;

        object_object_traits::id_image_type& i (sts.id_image ());
        object_object_traits::init (i, object_id);
        sqlite::binding& idb (sts.id_image_binding ());
        if (i.version != sts.id_image_version () || idb.version == 0)
        {
          object_object_traits::bind (idb.bind, i);
          sts.id_image_version (i.version);
          idb.version++;
        }

        object_object_traits::load_ (sts, *object_o, false);
        sts.load_delayed (0);
        l.unlock ();
      }
    }

    // object post
    //
    {
      if (object_o != 0)
      {
        object_object_traits::callback (*db, *object_o, callback_event::post_load);
        object_cache_traits::load (object_ig.position ());
        object_ig.release ();
        object_pg.release ();
      }

      // If a compiler error points to the line below, then
      // it most likely means that a pointer used in view
      // member cannot be initialized from an object pointer.
      //
      o.object = ::std::shared_ptr< ::bpkg::repository_fragment > (
        std::move (object_p));
    }
  }

  access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"main\".\"repository_fragment\".\"name\", "
      "\"main\".\"repository_fragment\".\"url\", "
      "\"main\".\"repository_fragment\".\"type\" ");

    r += "FROM \"main\".\"repository\" AS \"complement\"";

    r += " INNER JOIN \"main\".\"repository_fragment_complements\" AS \"rfc\" ON";
    // From package.hxx:1588:5
    r += "rfc.complement = " + query_columns::complement::name;

    r += " INNER JOIN \"main\".\"repository_fragment\" ON";
    // From package.hxx:1590:5
    r += "rfc.repository_fragment = " + query_columns::repository_fragment::name;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // repository_prerequisite_dependent
  //

  const char alias_traits<  ::bpkg::repository,
    id_sqlite,
    access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::prerequisite_tag>::
  table_name[] = "\"prerequisite\"";

  bool access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // object
    //
    if (object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::grow (
          i.object_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // object
    //
    object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::bind (
      b + n, i.object_value, sk);
    n += 3UL;
  }

  void access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (*db));

    // object pre
    //
    typedef ::bpkg::repository_fragment object_object_type;
    typedef object_traits_impl<object_object_type, id_sqlite> object_object_traits;
    typedef object_object_traits::pointer_type object_pointer_type;
    typedef object_object_traits::pointer_traits object_pointer_traits;
    typedef object_object_traits::pointer_cache_traits object_cache_traits;

    object_object_traits::id_type object_id;
    object_pointer_type object_p;
    object_pointer_traits::guard object_pg;
    object_cache_traits::insert_guard object_ig;
    object_object_type* object_o (0);

    {
      if (!(i.object_value.name_null))
      {
        object_id = object_object_traits::id (i.object_value);
        object_p = object_cache_traits::find (*db, object_id);

        if (object_pointer_traits::null_ptr (object_p))
        {
          object_p = object_factory<object_object_type, object_pointer_type>::create ();
          object_pg.reset (object_p);
          object_ig.reset (object_cache_traits::insert (*db, object_id, object_p));
          object_o = object_pointer_traits::get_ptr (object_p);
        }
      }
    }

    // object
    //
    {
      if (object_o != 0)
      {
        object_object_traits::callback (*db, *object_o, callback_event::pre_load);
        object_object_traits::init (*object_o, i.object_value, db);
        object_object_traits::statements_type& sts (
          conn.statement_cache ().find_object<object_object_type> ());
        object_object_traits::statements_type::auto_lock l (sts);
        assert (l.locked ()) /* Must be a top-level call. */;

        object_object_traits::id_image_type& i (sts.id_image ());
        object_object_traits::init (i, object_id);
        sqlite::binding& idb (sts.id_image_binding ());
        if (i.version != sts.id_image_version () || idb.version == 0)
        {
          object_object_traits::bind (idb.bind, i);
          sts.id_image_version (i.version);
          idb.version++;
        }

        object_object_traits::load_ (sts, *object_o, false);
        sts.load_delayed (0);
        l.unlock ();
      }
    }

    // object post
    //
    {
      if (object_o != 0)
      {
        object_object_traits::callback (*db, *object_o, callback_event::post_load);
        object_cache_traits::load (object_ig.position ());
        object_ig.release ();
        object_pg.release ();
      }

      // If a compiler error points to the line below, then
      // it most likely means that a pointer used in view
      // member cannot be initialized from an object pointer.
      //
      o.object = ::std::shared_ptr< ::bpkg::repository_fragment > (
        std::move (object_p));
    }
  }

  access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"main\".\"repository_fragment\".\"name\", "
      "\"main\".\"repository_fragment\".\"url\", "
      "\"main\".\"repository_fragment\".\"type\" ");

    r += "FROM \"main\".\"repository\" AS \"prerequisite\"";

    r += " INNER JOIN \"main\".\"repository_fragment_prerequisites\" AS \"rfp\" ON";
    // From package.hxx:1603:5
    r += "rfp.prerequisite = " + query_columns::prerequisite::name;

    r += " INNER JOIN \"main\".\"repository_fragment\" ON";
    // From package.hxx:1605:5
    r += "rfp.repository_fragment = " + query_columns::repository_fragment::name;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // repository_fragment_package
  //

  const char alias_traits<  ::bpkg::available_package,
    id_sqlite,
    access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::package_tag>::
  table_name[] = "\"package\"";

  bool access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // package
    //
    if (object_traits_impl< ::bpkg::available_package, id_sqlite >::grow (
          i.package_value, t + 0UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // package
    //
    object_traits_impl< ::bpkg::available_package, id_sqlite >::bind (
      b + n, i.package_value, sk);
    n += 15UL;
  }

  void access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (*db));

    // package pre
    //
    typedef ::bpkg::available_package package_object_type;
    typedef object_traits_impl<package_object_type, id_sqlite> package_object_traits;
    typedef package_object_traits::pointer_type package_pointer_type;
    typedef package_object_traits::pointer_traits package_pointer_traits;
    typedef package_object_traits::pointer_cache_traits package_cache_traits;

    package_object_traits::id_type package_id;
    package_pointer_type package_p;
    package_pointer_traits::guard package_pg;
    package_cache_traits::insert_guard package_ig;
    package_object_type* package_o (0);

    {
      if (!composite_value_traits< package_object_traits::id_type, id_sqlite >::get_null (
            i.package_value.id_value))
      {
        package_id = package_object_traits::id (i.package_value);
        package_p = package_cache_traits::find (*db, package_id);

        if (package_pointer_traits::null_ptr (package_p))
        {
          package_p = object_factory<package_object_type, package_pointer_type>::create ();
          package_pg.reset (package_p);
          package_ig.reset (package_cache_traits::insert (*db, package_id, package_p));
          package_o = package_pointer_traits::get_ptr (package_p);
        }
      }
    }

    // package
    //
    {
      if (package_o != 0)
      {
        package_object_traits::callback (*db, *package_o, callback_event::pre_load);
        package_object_traits::init (*package_o, i.package_value, db);
        package_object_traits::statements_type& sts (
          conn.statement_cache ().find_object<package_object_type> ());
        package_object_traits::statements_type::auto_lock l (sts);
        assert (l.locked ()) /* Must be a top-level call. */;

        package_object_traits::id_image_type& i (sts.id_image ());
        package_object_traits::init (i, package_id);
        sqlite::binding& idb (sts.id_image_binding ());
        if (i.version != sts.id_image_version () || idb.version == 0)
        {
          package_object_traits::bind (idb.bind, i);
          sts.id_image_version (i.version);
          idb.version++;
        }

        package_object_traits::load_ (sts, *package_o, false);
        sts.load_delayed (0);
        l.unlock ();
      }
    }

    // package post
    //
    {
      if (package_o != 0)
      {
        package_object_traits::callback (*db, *package_o, callback_event::post_load);
        package_cache_traits::load (package_ig.position ());
        package_ig.release ();
        package_pg.release ();
      }

      // If a compiler error points to the line below, then
      // it most likely means that a pointer used in view
      // member cannot be initialized from an object pointer.
      //
      o.package = ::std::shared_ptr< ::bpkg::available_package > (
        std::move (package_p));
    }
  }

  access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"package\".\"name\", "
      "\"package\".\"version_epoch\", "
      "\"package\".\"version_canonical_upstream\", "
      "\"package\".\"version_canonical_release\", "
      "\"package\".\"version_revision\", "
      "\"package\".\"version_iteration\", "
      "\"package\".\"version_upstream\", "
      "\"package\".\"version_release\", "
      "\"package\".\"upstream_version\", "
      "\"package\".\"type\", "
      "\"package\".\"project\", "
      "\"package\".\"alt_naming\", "
      "\"package\".\"bootstrap_build\", "
      "\"package\".\"root_build\", "
      "\"package\".\"sha256sum\" ");

    r += "FROM \"main\".\"repository_fragment\"";

    r += " INNER JOIN \"main\".\"available_package_locations\" AS \"pl\" ON";
    // From package.hxx:1617:5
    r += "pl.repository_fragment = " + query_columns::repository_fragment::name;

    r += " INNER JOIN \"main\".\"available_package\" AS \"package\" ON";
    // From package.hxx:1619:5
    r += "pl.name = " + query_columns::package::id.name + "AND" + "pl.version_epoch = " + query_columns::package::id.version.epoch + "AND" + "pl.version_canonical_upstream = " + query_columns::package::id.version.canonical_upstream + "AND" + "pl.version_canonical_release = " + query_columns::package::id.version.canonical_release + "AND" + "pl.version_revision = " + query_columns::package::id.version.revision + "AND" + "pl.version_iteration = " + query_columns::package::id.version.iteration;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }

  // package_repository_fragment
  //

  const char alias_traits<  ::bpkg::available_package,
    id_sqlite,
    access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::package_tag>::
  table_name[] = "\"package\"";

  bool access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::
  grow (image_type& i,
        bool* t)
  {
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (t);

    bool grew (false);

    // package_id
    //
    if (composite_value_traits< ::bpkg::package_id, id_sqlite >::grow (
          i.package_id_value, t + 0UL))
      grew = true;

    // repository_fragment
    //
    if (object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::grow (
          i.repository_fragment_value, t + 6UL))
      grew = true;

    return grew;
  }

  void access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::
  bind (sqlite::bind* b,
        image_type& i)
  {
    using namespace sqlite;

    sqlite::statement_kind sk (statement_select);
    ODB_POTENTIALLY_UNUSED (sk);

    std::size_t n (0);

    // package_id
    //
    composite_value_traits< ::bpkg::package_id, id_sqlite >::bind (
      b + n, i.package_id_value, sk);
    n += 6UL;

    // repository_fragment
    //
    object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::bind (
      b + n, i.repository_fragment_value, sk);
    n += 3UL;
  }

  void access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::
  init (view_type& o,
        const image_type& i,
        database* db)
  {
    ODB_POTENTIALLY_UNUSED (o);
    ODB_POTENTIALLY_UNUSED (i);
    ODB_POTENTIALLY_UNUSED (db);

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (*db));

    // repository_fragment pre
    //
    typedef ::bpkg::repository_fragment repository_fragment_object_type;
    typedef object_traits_impl<repository_fragment_object_type, id_sqlite> repository_fragment_object_traits;
    typedef repository_fragment_object_traits::pointer_type repository_fragment_pointer_type;
    typedef repository_fragment_object_traits::pointer_traits repository_fragment_pointer_traits;
    typedef repository_fragment_object_traits::pointer_cache_traits repository_fragment_cache_traits;

    repository_fragment_object_traits::id_type repository_fragment_id;
    repository_fragment_pointer_type repository_fragment_p;
    repository_fragment_pointer_traits::guard repository_fragment_pg;
    repository_fragment_cache_traits::insert_guard repository_fragment_ig;
    repository_fragment_object_type* repository_fragment_o (0);

    {
      if (!(i.repository_fragment_value.name_null))
      {
        repository_fragment_id = repository_fragment_object_traits::id (i.repository_fragment_value);
        repository_fragment_p = repository_fragment_cache_traits::find (*db, repository_fragment_id);

        if (repository_fragment_pointer_traits::null_ptr (repository_fragment_p))
        {
          repository_fragment_p = object_factory<repository_fragment_object_type, repository_fragment_pointer_type>::create ();
          repository_fragment_pg.reset (repository_fragment_p);
          repository_fragment_ig.reset (repository_fragment_cache_traits::insert (*db, repository_fragment_id, repository_fragment_p));
          repository_fragment_o = repository_fragment_pointer_traits::get_ptr (repository_fragment_p);
        }
      }
    }

    // package_id
    //
    {
      ::bpkg::package_id& v =
        o.package_id;

      composite_value_traits< ::bpkg::package_id, id_sqlite >::init (
        v,
        i.package_id_value,
        db);
    }

    // repository_fragment
    //
    {
      if (repository_fragment_o != 0)
      {
        repository_fragment_object_traits::callback (*db, *repository_fragment_o, callback_event::pre_load);
        repository_fragment_object_traits::init (*repository_fragment_o, i.repository_fragment_value, db);
        repository_fragment_object_traits::statements_type& sts (
          conn.statement_cache ().find_object<repository_fragment_object_type> ());
        repository_fragment_object_traits::statements_type::auto_lock l (sts);
        assert (l.locked ()) /* Must be a top-level call. */;

        repository_fragment_object_traits::id_image_type& i (sts.id_image ());
        repository_fragment_object_traits::init (i, repository_fragment_id);
        sqlite::binding& idb (sts.id_image_binding ());
        if (i.version != sts.id_image_version () || idb.version == 0)
        {
          repository_fragment_object_traits::bind (idb.bind, i);
          sts.id_image_version (i.version);
          idb.version++;
        }

        repository_fragment_object_traits::load_ (sts, *repository_fragment_o, false);
        sts.load_delayed (0);
        l.unlock ();
      }
    }

    // repository_fragment post
    //
    {
      if (repository_fragment_o != 0)
      {
        repository_fragment_object_traits::callback (*db, *repository_fragment_o, callback_event::post_load);
        repository_fragment_cache_traits::load (repository_fragment_ig.position ());
        repository_fragment_ig.release ();
        repository_fragment_pg.release ();
      }

      // If a compiler error points to the line below, then
      // it most likely means that a pointer used in view
      // member cannot be initialized from an object pointer.
      //
      o.repository_fragment = ::std::shared_ptr< ::bpkg::repository_fragment > (
        std::move (repository_fragment_p));
    }
  }

  access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::query_base_type
  access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::
  query_statement (const query_base_type& q)
  {
    query_base_type r (
      "SELECT "
      "\"package\".\"name\", "
      "\"package\".\"version_epoch\", "
      "\"package\".\"version_canonical_upstream\", "
      "\"package\".\"version_canonical_release\", "
      "\"package\".\"version_revision\", "
      "\"package\".\"version_iteration\", "
      "\"main\".\"repository_fragment\".\"name\", "
      "\"main\".\"repository_fragment\".\"url\", "
      "\"main\".\"repository_fragment\".\"type\" ");

    r += "FROM \"main\".\"repository_fragment\"";

    r += " INNER JOIN \"main\".\"available_package_locations\" AS \"pl\" ON";
    // From package.hxx:1638:5
    r += "pl.repository_fragment = " + query_columns::repository_fragment::name;

    r += " INNER JOIN \"main\".\"available_package\" AS \"package\" ON";
    // From package.hxx:1640:5
    r += "pl.name = " + query_columns::package::id.name + "AND" + "pl.version_epoch = " + query_columns::package::id.version.epoch + "AND" + "pl.version_canonical_upstream = " + query_columns::package::id.version.canonical_upstream + "AND" + "pl.version_canonical_release = " + query_columns::package::id.version.canonical_release + "AND" + "pl.version_revision = " + query_columns::package::id.version.revision + "AND" + "pl.version_iteration = " + query_columns::package::id.version.iteration;

    if (!q.empty ())
    {
      r += " ";
      r += q.clause_prefix ();
      r += q;
    }

    return r;
  }

  result< access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::view_type >
  access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::
  query (database& db, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      sqlite::transaction::current ().connection (db));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    const query_base_type& qs (query_statement (q));
    qs.init_parameters ();
    shared_ptr<select_statement> st (
      new (shared) select_statement (
        conn,
        qs.clause (),
        false,
        true,
        qs.parameters_binding (),
        imb));

    st->execute ();

    shared_ptr< odb::view_result_impl<view_type> > r (
      new (shared) sqlite::view_result_impl<view_type> (
        qs, st, sts, 0));

    return result<view_type> (r);
  }

  odb::details::shared_ptr<prepared_query_impl>
  access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::
  prepare_query (connection& c, const char* n, const query_base_type& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::connection& conn (
      static_cast<sqlite::connection&> (c));
    statements_type& sts (
      conn.statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    shared_ptr<sqlite::prepared_query_impl> r (
      new (shared) sqlite::prepared_query_impl (conn));
    r->name = n;
    r->execute = &execute_query;
    r->query = query_statement (q);
    r->stmt.reset (
      new (shared) select_statement (
        conn,
        r->query.clause (),
        false,
        true,
        r->query.parameters_binding (),
        imb));

    return r;
  }

  odb::details::shared_ptr<result_impl>
  access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::
  execute_query (prepared_query_impl& q)
  {
    using namespace sqlite;
    using odb::details::shared;
    using odb::details::shared_ptr;

    sqlite::prepared_query_impl& pq (
      static_cast<sqlite::prepared_query_impl&> (q));
    shared_ptr<select_statement> st (
      odb::details::inc_ref (
        static_cast<select_statement*> (pq.stmt.get ())));

    sqlite::transaction& tr (sqlite::transaction::current ());
    ODB_POTENTIALLY_UNUSED (tr);

    // The connection used by the current transaction and the
    // one used to prepare this statement must be the same.
    //
    assert (q.verify_connection (tr));

    statements_type& sts (
      st->connection ().statement_cache ().find_view<view_type> ());

    image_type& im (sts.image ());
    binding& imb (sts.image_binding ());

    if (im.version != sts.image_version () || imb.version == 0)
    {
      bind (imb.bind, im);
      sts.image_version (im.version);
      imb.version++;
    }

    pq.query.init_parameters ();
    st->execute ();

    return shared_ptr<result_impl> (
      new (shared) sqlite::view_result_impl<view_type> (
        pq.query, st, sts, 0));
  }
}

namespace odb
{
  static bool
  create_schema (database& db, unsigned short pass, bool drop)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (drop);

    if (drop)
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("DROP TABLE IF EXISTS \"main\".\"certificate\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"selected_package_config_variables\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"selected_package_dependency_alternatives\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"selected_package_prerequisites\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"selected_package\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"available_package_distribution_values\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"available_package_buildfiles\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"available_package_tests\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"available_package_dependency_alternative_dependencies\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"available_package_dependency_alternatives\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"available_package_dependencies\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"available_package_locations\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"available_package_languages\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"available_package\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"repository_fragments\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"repository\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"repository_fragment_prerequisites\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"repository_fragment_complements\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"repository_fragment\"");
          db.execute ("DROP TABLE IF EXISTS \"main\".\"configuration\"");
          db.execute ("CREATE TABLE IF NOT EXISTS \"main\".\"schema_version\" (\n"
                      "  \"name\" TEXT NOT NULL PRIMARY KEY,\n"
                      "  \"version\" INTEGER NOT NULL,\n"
                      "  \"migration\" INTEGER NOT NULL)");
          db.execute ("DELETE FROM \"main\".\"schema_version\"\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("CREATE TABLE \"main\".\"configuration\" (\n"
                      "  \"id\" INTEGER NULL PRIMARY KEY AUTOINCREMENT,\n"
                      "  \"uuid\" TEXT NULL,\n"
                      "  \"name\" TEXT NULL,\n"
                      "  \"type\" TEXT NULL,\n"
                      "  \"path\" TEXT NULL,\n"
                      "  \"explicit\" INTEGER NULL,\n"
                      "  \"fetch_cache_mode\" TEXT NULL)");
          db.execute ("CREATE UNIQUE INDEX \"main\".\"configuration_uuid_i\"\n"
                      "  ON \"configuration\" (\"uuid\")");
          db.execute ("CREATE UNIQUE INDEX \"main\".\"configuration_name_i\"\n"
                      "  ON \"configuration\" (\"name\")");
          db.execute ("CREATE UNIQUE INDEX \"main\".\"configuration_path_i\"\n"
                      "  ON \"configuration\" (\"path\")");
          db.execute ("CREATE TABLE \"main\".\"repository_fragment\" (\n"
                      "  \"name\" TEXT NULL PRIMARY KEY,\n"
                      "  \"url\" TEXT NULL,\n"
                      "  \"type\" TEXT NULL)");
          db.execute ("CREATE TABLE \"main\".\"repository_fragment_complements\" (\n"
                      "  \"repository_fragment\" TEXT NULL,\n"
                      "  \"complement\" TEXT NULL,\n"
                      "  CONSTRAINT \"repository_fragment_fk\"\n"
                      "    FOREIGN KEY (\"repository_fragment\")\n"
                      "    REFERENCES \"repository_fragment\" (\"name\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"complement_fk\"\n"
                      "    FOREIGN KEY (\"complement\")\n"
                      "    REFERENCES \"repository\" (\"name\")\n"
                      "    DEFERRABLE INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"main\".\"repository_fragment_complements_repository_fragment_i\"\n"
                      "  ON \"repository_fragment_complements\" (\"repository_fragment\")");
          db.execute ("CREATE TABLE \"main\".\"repository_fragment_prerequisites\" (\n"
                      "  \"repository_fragment\" TEXT NULL,\n"
                      "  \"prerequisite\" TEXT NULL,\n"
                      "  CONSTRAINT \"repository_fragment_fk\"\n"
                      "    FOREIGN KEY (\"repository_fragment\")\n"
                      "    REFERENCES \"repository_fragment\" (\"name\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"prerequisite_fk\"\n"
                      "    FOREIGN KEY (\"prerequisite\")\n"
                      "    REFERENCES \"repository\" (\"name\")\n"
                      "    DEFERRABLE INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"main\".\"repository_fragment_prerequisites_repository_fragment_i\"\n"
                      "  ON \"repository_fragment_prerequisites\" (\"repository_fragment\")");
          db.execute ("CREATE TABLE \"main\".\"repository\" (\n"
                      "  \"name\" TEXT NULL PRIMARY KEY,\n"
                      "  \"url\" TEXT NULL,\n"
                      "  \"type\" TEXT NULL,\n"
                      "  \"certificate\" TEXT NULL,\n"
                      "  \"local\" INTEGER NULL)");
          db.execute ("CREATE TABLE \"main\".\"repository_fragments\" (\n"
                      "  \"repository\" TEXT NULL,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"friendly_name\" TEXT NULL,\n"
                      "  \"fragment\" TEXT NULL,\n"
                      "  CONSTRAINT \"repository_fk\"\n"
                      "    FOREIGN KEY (\"repository\")\n"
                      "    REFERENCES \"repository\" (\"name\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"fragment_fk\"\n"
                      "    FOREIGN KEY (\"fragment\")\n"
                      "    REFERENCES \"repository_fragment\" (\"name\")\n"
                      "    DEFERRABLE INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"main\".\"repository_fragments_repository_i\"\n"
                      "  ON \"repository_fragments\" (\"repository\")");
          db.execute ("CREATE INDEX \"main\".\"repository_fragments_index_i\"\n"
                      "  ON \"repository_fragments\" (\"index\")");
          db.execute ("CREATE TABLE \"main\".\"available_package\" (\n"
                      "  \"name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL COLLATE BINARY,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"version_upstream\" TEXT NULL,\n"
                      "  \"version_release\" TEXT NULL,\n"
                      "  \"upstream_version\" TEXT NULL,\n"
                      "  \"type\" TEXT NULL,\n"
                      "  \"project\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"alt_naming\" INTEGER NULL DEFAULT 0,\n"
                      "  \"bootstrap_build\" TEXT NULL DEFAULT '',\n"
                      "  \"root_build\" TEXT NULL,\n"
                      "  \"sha256sum\" TEXT NULL,\n"
                      "  PRIMARY KEY (\"name\",\n"
                      "               \"version_epoch\",\n"
                      "               \"version_canonical_upstream\",\n"
                      "               \"version_canonical_release\",\n"
                      "               \"version_revision\",\n"
                      "               \"version_iteration\"))");
          db.execute ("CREATE TABLE \"main\".\"available_package_languages\" (\n"
                      "  \"name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL COLLATE BINARY,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"language_name\" TEXT NULL,\n"
                      "  \"language_impl\" INTEGER NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\",\n"
                      "                 \"version_iteration\")\n"
                      "    REFERENCES \"available_package\" (\"name\",\n"
                      "                                    \"version_epoch\",\n"
                      "                                    \"version_canonical_upstream\",\n"
                      "                                    \"version_canonical_release\",\n"
                      "                                    \"version_revision\",\n"
                      "                                    \"version_iteration\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"available_package_languages_object_id_i\"\n"
                      "  ON \"available_package_languages\" (\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\",\n"
                      "    \"version_iteration\")");
          db.execute ("CREATE INDEX \"main\".\"available_package_languages_index_i\"\n"
                      "  ON \"available_package_languages\" (\"index\")");
          db.execute ("CREATE TABLE \"main\".\"available_package_locations\" (\n"
                      "  \"name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL COLLATE BINARY,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"repository_fragment\" TEXT NULL,\n"
                      "  \"location\" TEXT NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\",\n"
                      "                 \"version_iteration\")\n"
                      "    REFERENCES \"available_package\" (\"name\",\n"
                      "                                    \"version_epoch\",\n"
                      "                                    \"version_canonical_upstream\",\n"
                      "                                    \"version_canonical_release\",\n"
                      "                                    \"version_revision\",\n"
                      "                                    \"version_iteration\")\n"
                      "    ON DELETE CASCADE,\n"
                      "  CONSTRAINT \"repository_fragment_fk\"\n"
                      "    FOREIGN KEY (\"repository_fragment\")\n"
                      "    REFERENCES \"repository_fragment\" (\"name\")\n"
                      "    DEFERRABLE INITIALLY DEFERRED)");
          db.execute ("CREATE INDEX \"main\".\"available_package_locations_object_id_i\"\n"
                      "  ON \"available_package_locations\" (\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\",\n"
                      "    \"version_iteration\")");
          db.execute ("CREATE TABLE \"main\".\"available_package_dependencies\" (\n"
                      "  \"name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL COLLATE BINARY,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"buildtime\" INTEGER NULL,\n"
                      "  \"comment\" TEXT NULL,\n"
                      "  \"type\" TEXT NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\",\n"
                      "                 \"version_iteration\")\n"
                      "    REFERENCES \"available_package\" (\"name\",\n"
                      "                                    \"version_epoch\",\n"
                      "                                    \"version_canonical_upstream\",\n"
                      "                                    \"version_canonical_release\",\n"
                      "                                    \"version_revision\",\n"
                      "                                    \"version_iteration\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"available_package_dependencies_object_id_i\"\n"
                      "  ON \"available_package_dependencies\" (\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\",\n"
                      "    \"version_iteration\")");
          db.execute ("CREATE INDEX \"main\".\"available_package_dependencies_index_i\"\n"
                      "  ON \"available_package_dependencies\" (\"index\")");
          db.execute ("CREATE TABLE \"main\".\"available_package_dependency_alternatives\" (\n"
                      "  \"name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL COLLATE BINARY,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"dependency_index\" INTEGER NULL,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"enable\" TEXT NULL,\n"
                      "  \"reflect\" TEXT NULL,\n"
                      "  \"prefer\" TEXT NULL,\n"
                      "  \"accept\" TEXT NULL,\n"
                      "  \"require\" TEXT NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\",\n"
                      "                 \"version_iteration\")\n"
                      "    REFERENCES \"available_package\" (\"name\",\n"
                      "                                    \"version_epoch\",\n"
                      "                                    \"version_canonical_upstream\",\n"
                      "                                    \"version_canonical_release\",\n"
                      "                                    \"version_revision\",\n"
                      "                                    \"version_iteration\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"available_package_dependency_alternatives_object_id_i\"\n"
                      "  ON \"available_package_dependency_alternatives\" (\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\",\n"
                      "    \"version_iteration\")");
          db.execute ("CREATE TABLE \"main\".\"available_package_dependency_alternative_dependencies\" (\n"
                      "  \"name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL COLLATE BINARY,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"dependency_index\" INTEGER NULL,\n"
                      "  \"alternative_index\" INTEGER NULL,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"dep_name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"dep_min_version_epoch\" INTEGER NULL,\n"
                      "  \"dep_min_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"dep_min_version_canonical_release\" TEXT NULL,\n"
                      "  \"dep_min_version_revision\" INTEGER NULL,\n"
                      "  \"dep_min_version_iteration\" INTEGER NULL,\n"
                      "  \"dep_min_version_upstream\" TEXT NULL,\n"
                      "  \"dep_min_version_release\" TEXT NULL,\n"
                      "  \"dep_max_version_epoch\" INTEGER NULL,\n"
                      "  \"dep_max_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"dep_max_version_canonical_release\" TEXT NULL,\n"
                      "  \"dep_max_version_revision\" INTEGER NULL,\n"
                      "  \"dep_max_version_iteration\" INTEGER NULL,\n"
                      "  \"dep_max_version_upstream\" TEXT NULL,\n"
                      "  \"dep_max_version_release\" TEXT NULL,\n"
                      "  \"dep_min_open\" INTEGER NULL,\n"
                      "  \"dep_max_open\" INTEGER NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\",\n"
                      "                 \"version_iteration\")\n"
                      "    REFERENCES \"available_package\" (\"name\",\n"
                      "                                    \"version_epoch\",\n"
                      "                                    \"version_canonical_upstream\",\n"
                      "                                    \"version_canonical_release\",\n"
                      "                                    \"version_revision\",\n"
                      "                                    \"version_iteration\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"available_package_dependency_alternative_dependencies_object_id_i\"\n"
                      "  ON \"available_package_dependency_alternative_dependencies\" (\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\",\n"
                      "    \"version_iteration\")");
          db.execute ("CREATE TABLE \"main\".\"available_package_tests\" (\n"
                      "  \"name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL COLLATE BINARY,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"test_name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"test_min_version_epoch\" INTEGER NULL,\n"
                      "  \"test_min_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"test_min_version_canonical_release\" TEXT NULL,\n"
                      "  \"test_min_version_revision\" INTEGER NULL,\n"
                      "  \"test_min_version_iteration\" INTEGER NULL,\n"
                      "  \"test_min_version_upstream\" TEXT NULL,\n"
                      "  \"test_min_version_release\" TEXT NULL,\n"
                      "  \"test_max_version_epoch\" INTEGER NULL,\n"
                      "  \"test_max_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"test_max_version_canonical_release\" TEXT NULL,\n"
                      "  \"test_max_version_revision\" INTEGER NULL,\n"
                      "  \"test_max_version_iteration\" INTEGER NULL,\n"
                      "  \"test_max_version_upstream\" TEXT NULL,\n"
                      "  \"test_max_version_release\" TEXT NULL,\n"
                      "  \"test_min_open\" INTEGER NULL,\n"
                      "  \"test_max_open\" INTEGER NULL,\n"
                      "  \"test_type\" TEXT NULL,\n"
                      "  \"test_buildtime\" INTEGER NULL DEFAULT 0,\n"
                      "  \"test_enable\" TEXT NULL,\n"
                      "  \"test_reflect\" TEXT NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\",\n"
                      "                 \"version_iteration\")\n"
                      "    REFERENCES \"available_package\" (\"name\",\n"
                      "                                    \"version_epoch\",\n"
                      "                                    \"version_canonical_upstream\",\n"
                      "                                    \"version_canonical_release\",\n"
                      "                                    \"version_revision\",\n"
                      "                                    \"version_iteration\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"available_package_tests_object_id_i\"\n"
                      "  ON \"available_package_tests\" (\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\",\n"
                      "    \"version_iteration\")");
          db.execute ("CREATE INDEX \"main\".\"available_package_tests_index_i\"\n"
                      "  ON \"available_package_tests\" (\"index\")");
          db.execute ("CREATE TABLE \"main\".\"available_package_buildfiles\" (\n"
                      "  \"name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL COLLATE BINARY,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"path\" TEXT NULL,\n"
                      "  \"content\" TEXT NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\",\n"
                      "                 \"version_iteration\")\n"
                      "    REFERENCES \"available_package\" (\"name\",\n"
                      "                                    \"version_epoch\",\n"
                      "                                    \"version_canonical_upstream\",\n"
                      "                                    \"version_canonical_release\",\n"
                      "                                    \"version_revision\",\n"
                      "                                    \"version_iteration\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"available_package_buildfiles_object_id_i\"\n"
                      "  ON \"available_package_buildfiles\" (\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\",\n"
                      "    \"version_iteration\")");
          db.execute ("CREATE INDEX \"main\".\"available_package_buildfiles_index_i\"\n"
                      "  ON \"available_package_buildfiles\" (\"index\")");
          db.execute ("CREATE TABLE \"main\".\"available_package_distribution_values\" (\n"
                      "  \"name\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL COLLATE BINARY,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"dist_name\" TEXT NULL,\n"
                      "  \"dist_value\" TEXT NULL,\n"
                      "  CONSTRAINT \"object_id_fk\"\n"
                      "    FOREIGN KEY (\"name\",\n"
                      "                 \"version_epoch\",\n"
                      "                 \"version_canonical_upstream\",\n"
                      "                 \"version_canonical_release\",\n"
                      "                 \"version_revision\",\n"
                      "                 \"version_iteration\")\n"
                      "    REFERENCES \"available_package\" (\"name\",\n"
                      "                                    \"version_epoch\",\n"
                      "                                    \"version_canonical_upstream\",\n"
                      "                                    \"version_canonical_release\",\n"
                      "                                    \"version_revision\",\n"
                      "                                    \"version_iteration\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"available_package_distribution_values_object_id_i\"\n"
                      "  ON \"available_package_distribution_values\" (\n"
                      "    \"name\",\n"
                      "    \"version_epoch\",\n"
                      "    \"version_canonical_upstream\",\n"
                      "    \"version_canonical_release\",\n"
                      "    \"version_revision\",\n"
                      "    \"version_iteration\")");
          db.execute ("CREATE INDEX \"main\".\"available_package_distribution_values_index_i\"\n"
                      "  ON \"available_package_distribution_values\" (\"index\")");
          db.execute ("CREATE TABLE \"main\".\"selected_package\" (\n"
                      "  \"name\" TEXT NULL PRIMARY KEY COLLATE NOCASE,\n"
                      "  \"version_epoch\" INTEGER NULL,\n"
                      "  \"version_canonical_upstream\" TEXT NULL,\n"
                      "  \"version_canonical_release\" TEXT NULL,\n"
                      "  \"version_revision\" INTEGER NULL,\n"
                      "  \"version_iteration\" INTEGER NULL,\n"
                      "  \"version_upstream\" TEXT NULL,\n"
                      "  \"version_release\" TEXT NULL,\n"
                      "  \"state\" TEXT NULL,\n"
                      "  \"substate\" TEXT NULL,\n"
                      "  \"hold_package\" INTEGER NULL,\n"
                      "  \"hold_version\" INTEGER NULL,\n"
                      "  \"repository_fragment_url\" TEXT NULL,\n"
                      "  \"repository_fragment_type\" TEXT NULL,\n"
                      "  \"archive\" TEXT NULL,\n"
                      "  \"purge_archive\" INTEGER NULL,\n"
                      "  \"src_root\" TEXT NULL,\n"
                      "  \"purge_src\" INTEGER NULL,\n"
                      "  \"manifest_checksum\" TEXT NULL,\n"
                      "  \"buildfiles_checksum\" TEXT NULL,\n"
                      "  \"out_root\" TEXT NULL,\n"
                      "  \"config_checksum\" TEXT NULL DEFAULT '',\n"
                      "  \"manifest\" TEXT NULL)");
          db.execute ("CREATE TABLE \"main\".\"selected_package_prerequisites\" (\n"
                      "  \"package\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"configuration\" TEXT NULL,\n"
                      "  \"prerequisite\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"min_version_epoch\" INTEGER NULL,\n"
                      "  \"min_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"min_version_canonical_release\" TEXT NULL,\n"
                      "  \"min_version_revision\" INTEGER NULL,\n"
                      "  \"min_version_iteration\" INTEGER NULL,\n"
                      "  \"min_version_upstream\" TEXT NULL,\n"
                      "  \"min_version_release\" TEXT NULL,\n"
                      "  \"max_version_epoch\" INTEGER NULL,\n"
                      "  \"max_version_canonical_upstream\" TEXT NULL,\n"
                      "  \"max_version_canonical_release\" TEXT NULL,\n"
                      "  \"max_version_revision\" INTEGER NULL,\n"
                      "  \"max_version_iteration\" INTEGER NULL,\n"
                      "  \"max_version_upstream\" TEXT NULL,\n"
                      "  \"max_version_release\" TEXT NULL,\n"
                      "  \"min_open\" INTEGER NULL,\n"
                      "  \"max_open\" INTEGER NULL,\n"
                      "  CONSTRAINT \"package_fk\"\n"
                      "    FOREIGN KEY (\"package\")\n"
                      "    REFERENCES \"selected_package\" (\"name\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"selected_package_prerequisites_package_i\"\n"
                      "  ON \"selected_package_prerequisites\" (\"package\")");
          db.execute ("CREATE TABLE \"main\".\"selected_package_dependency_alternatives\" (\n"
                      "  \"package\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"position\" INTEGER NULL,\n"
                      "  CONSTRAINT \"package_fk\"\n"
                      "    FOREIGN KEY (\"package\")\n"
                      "    REFERENCES \"selected_package\" (\"name\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"selected_package_dependency_alternatives_package_i\"\n"
                      "  ON \"selected_package_dependency_alternatives\" (\"package\")");
          db.execute ("CREATE INDEX \"main\".\"selected_package_dependency_alternatives_index_i\"\n"
                      "  ON \"selected_package_dependency_alternatives\" (\"index\")");
          db.execute ("CREATE TABLE \"main\".\"selected_package_config_variables\" (\n"
                      "  \"package\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"name\" TEXT NULL,\n"
                      "  \"source\" TEXT NULL,\n"
                      "  CONSTRAINT \"package_fk\"\n"
                      "    FOREIGN KEY (\"package\")\n"
                      "    REFERENCES \"selected_package\" (\"name\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"selected_package_config_variables_package_i\"\n"
                      "  ON \"selected_package_config_variables\" (\"package\")");
          db.execute ("CREATE INDEX \"main\".\"selected_package_config_variables_index_i\"\n"
                      "  ON \"selected_package_config_variables\" (\"index\")");
          db.execute ("CREATE TABLE \"main\".\"certificate\" (\n"
                      "  \"id\" TEXT NULL PRIMARY KEY,\n"
                      "  \"fingerprint\" TEXT NULL,\n"
                      "  \"name\" TEXT NULL,\n"
                      "  \"organization\" TEXT NULL,\n"
                      "  \"email\" TEXT NULL,\n"
                      "  \"start_date\" INTEGER NULL,\n"
                      "  \"end_date\" INTEGER NULL)");
          return true;
        }
        case 2:
        {
          db.execute ("CREATE TABLE IF NOT EXISTS \"main\".\"schema_version\" (\n"
                      "  \"name\" TEXT NOT NULL PRIMARY KEY,\n"
                      "  \"version\" INTEGER NOT NULL,\n"
                      "  \"migration\" INTEGER NOT NULL)");
          db.execute ("INSERT OR IGNORE INTO \"main\".\"schema_version\" (\n"
                      "  \"name\", \"version\", \"migration\")\n"
                      "  VALUES ('', 28, 0)");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_create_entry
  create_schema_entry_ (
    id_sqlite,
    "",
    &create_schema);

  static const schema_catalog_migrate_entry
  migrate_schema_entry_23_ (
    id_sqlite,
    "",
    23ULL,
    0);

  static bool
  migrate_schema_24 (database& db, unsigned short pass, bool pre)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (pre);

    if (pre)
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("ALTER TABLE \"main\".\"selected_package\"\n"
                      "  ADD COLUMN \"config_checksum\" TEXT NULL DEFAULT ''");
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"version\" = 24, \"migration\" = 1\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"migration\" = 0\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_migrate_entry
  migrate_schema_entry_24_ (
    id_sqlite,
    "",
    24ULL,
    &migrate_schema_24);

  static bool
  migrate_schema_25 (database& db, unsigned short pass, bool pre)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (pre);

    if (pre)
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("CREATE TABLE \"main\".\"selected_package_dependency_alternatives\" (\n"
                      "  \"package\" TEXT NULL COLLATE NOCASE,\n"
                      "  \"index\" INTEGER NULL,\n"
                      "  \"position\" INTEGER NULL,\n"
                      "  CONSTRAINT \"package_fk\"\n"
                      "    FOREIGN KEY (\"package\")\n"
                      "    REFERENCES \"selected_package\" (\"name\")\n"
                      "    ON DELETE CASCADE)");
          db.execute ("CREATE INDEX \"main\".\"selected_package_dependency_alternatives_package_i\"\n"
                      "  ON \"selected_package_dependency_alternatives\" (\"package\")");
          db.execute ("CREATE INDEX \"main\".\"selected_package_dependency_alternatives_index_i\"\n"
                      "  ON \"selected_package_dependency_alternatives\" (\"index\")");
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"version\" = 25, \"migration\" = 1\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"selected_package_prerequisites\"\n"
                      "  SET \"config_dependency_index\" = NULL,\n"
                      "    \"config_alternative_index\" = NULL");
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"migration\" = 0\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_migrate_entry
  migrate_schema_entry_25_ (
    id_sqlite,
    "",
    25ULL,
    &migrate_schema_25);

  static bool
  migrate_schema_26 (database& db, unsigned short pass, bool pre)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (pre);

    if (pre)
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("ALTER TABLE \"main\".\"available_package_tests\"\n"
                      "  ADD COLUMN \"test_enable\" TEXT NULL");
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"version\" = 26, \"migration\" = 1\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"migration\" = 0\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_migrate_entry
  migrate_schema_entry_26_ (
    id_sqlite,
    "",
    26ULL,
    &migrate_schema_26);

  static bool
  migrate_schema_27 (database& db, unsigned short pass, bool pre)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (pre);

    if (pre)
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("ALTER TABLE \"main\".\"selected_package\"\n"
                      "  ADD COLUMN \"manifest\" TEXT NULL");
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"version\" = 27, \"migration\" = 1\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"migration\" = 0\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_migrate_entry
  migrate_schema_entry_27_ (
    id_sqlite,
    "",
    27ULL,
    &migrate_schema_27);

  static bool
  migrate_schema_28 (database& db, unsigned short pass, bool pre)
  {
    ODB_POTENTIALLY_UNUSED (db);
    ODB_POTENTIALLY_UNUSED (pass);
    ODB_POTENTIALLY_UNUSED (pre);

    if (pre)
    {
      switch (pass)
      {
        case 1:
        {
          db.execute ("ALTER TABLE \"main\".\"configuration\"\n"
                      "  ADD COLUMN \"fetch_cache_mode\" TEXT NULL");
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"version\" = 28, \"migration\" = 1\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }
    else
    {
      switch (pass)
      {
        case 1:
        {
          return true;
        }
        case 2:
        {
          db.execute ("UPDATE \"main\".\"schema_version\"\n"
                      "  SET \"migration\" = 0\n"
                      "  WHERE \"name\" = ''");
          return false;
        }
      }
    }

    return false;
  }

  static const schema_catalog_migrate_entry
  migrate_schema_entry_28_ (
    id_sqlite,
    "",
    28ULL,
    &migrate_schema_28);
}

#include <odb/post.hxx>
