// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bpkg/types-parsers.hxx>
//
// End prologue.

#include <bpkg/pkg-build-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bpkg
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bpkg
{
  // pkg_build_pkg_options
  //

  pkg_build_pkg_options::
  pkg_build_pkg_options ()
  : upgrade_ (),
    patch_ (),
    deorphan_ (),
    immediate_ (),
    recursive_ (),
    upgrade_immediate_ (),
    patch_immediate_ (),
    deorphan_immediate_ (),
    upgrade_recursive_ (),
    patch_recursive_ (),
    deorphan_recursive_ (),
    dependency_ (),
    keep_out_ (),
    disfigure_ (),
    checkout_root_ (),
    checkout_root_specified_ (false),
    checkout_purge_ (),
    config_name_ (),
    config_name_specified_ (false),
    config_id_ (),
    config_id_specified_ (false),
    config_uuid_ (),
    config_uuid_specified_ (false)
  {
  }

  bool pkg_build_pkg_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool pkg_build_pkg_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool pkg_build_pkg_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool pkg_build_pkg_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool pkg_build_pkg_options::
  parse (::bpkg::cli::scanner& s,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void pkg_build_pkg_options::
  merge (const pkg_build_pkg_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.upgrade_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->upgrade_, a.upgrade_);
    }

    if (a.patch_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->patch_, a.patch_);
    }

    if (a.deorphan_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->deorphan_, a.deorphan_);
    }

    if (a.immediate_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->immediate_, a.immediate_);
    }

    if (a.recursive_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->recursive_, a.recursive_);
    }

    if (a.upgrade_immediate_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->upgrade_immediate_, a.upgrade_immediate_);
    }

    if (a.patch_immediate_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->patch_immediate_, a.patch_immediate_);
    }

    if (a.deorphan_immediate_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->deorphan_immediate_, a.deorphan_immediate_);
    }

    if (a.upgrade_recursive_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->upgrade_recursive_, a.upgrade_recursive_);
    }

    if (a.patch_recursive_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->patch_recursive_, a.patch_recursive_);
    }

    if (a.deorphan_recursive_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->deorphan_recursive_, a.deorphan_recursive_);
    }

    if (a.dependency_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->dependency_, a.dependency_);
    }

    if (a.keep_out_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->keep_out_, a.keep_out_);
    }

    if (a.disfigure_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->disfigure_, a.disfigure_);
    }

    if (a.checkout_root_specified_)
    {
      ::bpkg::cli::parser< dir_path>::merge (
        this->checkout_root_, a.checkout_root_);
      this->checkout_root_specified_ = true;
    }

    if (a.checkout_purge_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->checkout_purge_, a.checkout_purge_);
    }

    if (a.config_name_specified_)
    {
      ::bpkg::cli::parser< strings>::merge (
        this->config_name_, a.config_name_);
      this->config_name_specified_ = true;
    }

    if (a.config_id_specified_)
    {
      ::bpkg::cli::parser< vector<uint64_t>>::merge (
        this->config_id_, a.config_id_);
      this->config_id_specified_ = true;
    }

    if (a.config_uuid_specified_)
    {
      ::bpkg::cli::parser< vector<uuid>>::merge (
        this->config_uuid_, a.config_uuid_);
      this->config_uuid_specified_ = true;
    }
  }

  ::bpkg::cli::usage_para pkg_build_pkg_options::
  print_usage (::std::ostream& os, ::bpkg::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bpkg::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mPKG-BUILD PACKAGE OPTIONS\033[0m" << ::std::endl
       << ::std::endl
       << "The following options (as well as additional configuration variables) can be" << ::std::endl
       << "grouped to apply to a specific \033[4mpkg-spec\033[0m as well as specified globally, in which" << ::std::endl
       << "case they apply to all the specified packages (see \033[1mbpkg-argument-grouping(1)\033[0m" << ::std::endl
       << "for details)." << ::std::endl;

    os << std::endl
       << "\033[1m--upgrade\033[0m|\033[1m-u\033[0m              Upgrade packages to the latest available version that" << ::std::endl
       << "                          satisfies all the constraints." << ::std::endl;

    os << std::endl
       << "\033[1m--patch\033[0m|\033[1m-p\033[0m                Upgrade packages to the latest available patch" << ::std::endl
       << "                          version that satisfies all the constraints." << ::std::endl;

    os << std::endl
       << "\033[1m--deorphan\033[0m                Replace orphaned packages with the best matching" << ::std::endl
       << "                          available package versions which satisfy all the" << ::std::endl
       << "                          constraints." << ::std::endl
       << ::std::endl
       << "                          It may happen that a built package no longer has the" << ::std::endl
       << "                          corresponding package available in the repository it" << ::std::endl
       << "                          came from (for example, as a result of" << ::std::endl
       << "                          \033[1mbpkg-rep-fetch(1)\033[0m or \033[1mbpkg-rep-remove(1)\033[0m). Such a" << ::std::endl
       << "                          package is called an \033[4morphan\033[0m. Without the \033[1m--deorphan\033[0m" << ::std::endl
       << "                          option, upgrading, downgrading, or patching an orphan" << ::std::endl
       << "                          will leave it unchanged if a more suitable version of" << ::std::endl
       << "                          the package is not available. If the \033[1m--deorphan\033[0m" << ::std::endl
       << "                          option is specified, then an orphan will be replaced" << ::std::endl
       << "                          with a non-orphan. In this case, if \033[1m--upgrade\033[0m," << ::std::endl
       << "                          \033[1m--patch\033[0m, or the package version is specified, then" << ::std::endl
       << "                          the new version is selected accordingly. Otherwise," << ::std::endl
       << "                          the closest version to the orphaned version is" << ::std::endl
       << "                          selected using the following preference order: (1)" << ::std::endl
       << "                          same version, revision, and iteration, (2) latest" << ::std::endl
       << "                          iteration of same version and revision, (3) later" << ::std::endl
       << "                          revision of same version, (4) later patch of same" << ::std::endl
       << "                          version, (5) later minor of same version, (6) latest" << ::std::endl
       << "                          available version, including earlier (see Package" << ::std::endl
       << "                          Version (bpkg#package-version) for details)." << ::std::endl;

    os << std::endl
       << "\033[1m--immediate\033[0m|\033[1m-i\033[0m            Also upgrade, patch, or deorphan immediate" << ::std::endl
       << "                          dependencies." << ::std::endl;

    os << std::endl
       << "\033[1m--recursive\033[0m|\033[1m-r\033[0m            Also upgrade, patch, or deorphan all dependencies," << ::std::endl
       << "                          recursively." << ::std::endl;

    os << std::endl
       << "\033[1m--upgrade-immediate\033[0m       Upgrade immediate dependencies." << ::std::endl;

    os << std::endl
       << "\033[1m--patch-immediate\033[0m         Patch immediate dependencies." << ::std::endl;

    os << std::endl
       << "\033[1m--deorphan-immediate\033[0m      Deorphan immediate dependencies." << ::std::endl;

    os << std::endl
       << "\033[1m--upgrade-recursive\033[0m       Upgrade all dependencies, recursively." << ::std::endl;

    os << std::endl
       << "\033[1m--patch-recursive\033[0m         Patch all dependencies, recursively." << ::std::endl;

    os << std::endl
       << "\033[1m--deorphan-recursive\033[0m      Deorphan all dependencies, recursively." << ::std::endl;

    os << std::endl
       << "\033[1m--dependency\033[0m              Build, upgrade, or downgrade a package as a" << ::std::endl
       << "                          dependency rather than to hold." << ::std::endl;

    os << std::endl
       << "\033[1m--keep-out\033[0m                Keep output directories of external packages between" << ::std::endl
       << "                          upgrades and downgrades. Refer to" << ::std::endl
       << "                          \033[1mbpkg-pkg-disfigure(1)\033[0m for details." << ::std::endl;

    os << std::endl
       << "\033[1m--disfigure\033[0m               Disfigure packages between upgrades and downgrades" << ::std::endl
       << "                          effectively causing a from-scratch reconfiguration." << ::std::endl;

    os << std::endl
       << "\033[1m--checkout-root\033[0m \033[4mdir\033[0m       Check out packages that come from version" << ::std::endl
       << "                          control-based repositories into the specified" << ::std::endl
       << "                          directory rather than into the configuration" << ::std::endl
       << "                          directory. Refer to the \033[1m--output-root\033[0m option in" << ::std::endl
       << "                          \033[1mbpkg-pkg-checkout(1)\033[0m for details." << ::std::endl;

    os << std::endl
       << "\033[1m--checkout-purge\033[0m          Remove the checked out package (source) directories" << ::std::endl
       << "                          when the packages are purged. Refer to the" << ::std::endl
       << "                          \033[1m--output-purge\033[0m option in \033[1mbpkg-pkg-checkout(1)\033[0m for" << ::std::endl
       << "                          details." << ::std::endl;

    os << std::endl
       << "\033[1m--config-name\033[0m \033[4mname\033[0m        Name of the linked configuration to build this" << ::std::endl
       << "                          package(s) in. By default, the package is built in" << ::std::endl
       << "                          the current configuration. Repeat this option to" << ::std::endl
       << "                          specify multiple configurations." << ::std::endl;

    os << std::endl
       << "\033[1m--config-id\033[0m \033[4mnum\033[0m           Numeric id of the linked configuration to build this" << ::std::endl
       << "                          package(s) in. By default, the package is built in" << ::std::endl
       << "                          the current configuration. Repeat this option to" << ::std::endl
       << "                          specify multiple configurations." << ::std::endl;

    os << std::endl
       << "\033[1m--config-uuid\033[0m \033[4muuid\033[0m        UUID of the linked configuration to build this" << ::std::endl
       << "                          package(s) in. By default, the package is built in" << ::std::endl
       << "                          the current configuration. Repeat this this option to" << ::std::endl
       << "                          specify multiple configurations." << ::std::endl;

    p = ::bpkg::cli::usage_para::option;

    return p;
  }

  typedef
  std::map<std::string, void (*) (pkg_build_pkg_options&, ::bpkg::cli::scanner&)>
  _cli_pkg_build_pkg_options_map;

  static _cli_pkg_build_pkg_options_map _cli_pkg_build_pkg_options_map_;

  struct _cli_pkg_build_pkg_options_map_init
  {
    _cli_pkg_build_pkg_options_map_init ()
    {
      _cli_pkg_build_pkg_options_map_["--upgrade"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::upgrade_ >;
      _cli_pkg_build_pkg_options_map_["-u"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::upgrade_ >;
      _cli_pkg_build_pkg_options_map_["--patch"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::patch_ >;
      _cli_pkg_build_pkg_options_map_["-p"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::patch_ >;
      _cli_pkg_build_pkg_options_map_["--deorphan"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::deorphan_ >;
      _cli_pkg_build_pkg_options_map_["--immediate"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::immediate_ >;
      _cli_pkg_build_pkg_options_map_["-i"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::immediate_ >;
      _cli_pkg_build_pkg_options_map_["--recursive"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::recursive_ >;
      _cli_pkg_build_pkg_options_map_["-r"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::recursive_ >;
      _cli_pkg_build_pkg_options_map_["--upgrade-immediate"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::upgrade_immediate_ >;
      _cli_pkg_build_pkg_options_map_["--patch-immediate"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::patch_immediate_ >;
      _cli_pkg_build_pkg_options_map_["--deorphan-immediate"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::deorphan_immediate_ >;
      _cli_pkg_build_pkg_options_map_["--upgrade-recursive"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::upgrade_recursive_ >;
      _cli_pkg_build_pkg_options_map_["--patch-recursive"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::patch_recursive_ >;
      _cli_pkg_build_pkg_options_map_["--deorphan-recursive"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::deorphan_recursive_ >;
      _cli_pkg_build_pkg_options_map_["--dependency"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::dependency_ >;
      _cli_pkg_build_pkg_options_map_["--keep-out"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::keep_out_ >;
      _cli_pkg_build_pkg_options_map_["--disfigure"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::disfigure_ >;
      _cli_pkg_build_pkg_options_map_["--checkout-root"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, dir_path, &pkg_build_pkg_options::checkout_root_,
        &pkg_build_pkg_options::checkout_root_specified_ >;
      _cli_pkg_build_pkg_options_map_["--checkout-purge"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, &pkg_build_pkg_options::checkout_purge_ >;
      _cli_pkg_build_pkg_options_map_["--config-name"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, strings, &pkg_build_pkg_options::config_name_,
        &pkg_build_pkg_options::config_name_specified_ >;
      _cli_pkg_build_pkg_options_map_["--config-id"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, vector<uint64_t>, &pkg_build_pkg_options::config_id_,
        &pkg_build_pkg_options::config_id_specified_ >;
      _cli_pkg_build_pkg_options_map_["--config-uuid"] =
      &::bpkg::cli::thunk< pkg_build_pkg_options, vector<uuid>, &pkg_build_pkg_options::config_uuid_,
        &pkg_build_pkg_options::config_uuid_specified_ >;
    }
  };

  static _cli_pkg_build_pkg_options_map_init _cli_pkg_build_pkg_options_map_init_;

  bool pkg_build_pkg_options::
  _parse (const char* o, ::bpkg::cli::scanner& s)
  {
    _cli_pkg_build_pkg_options_map::const_iterator i (_cli_pkg_build_pkg_options_map_.find (o));

    if (i != _cli_pkg_build_pkg_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool pkg_build_pkg_options::
  _parse (::bpkg::cli::scanner& s,
          ::bpkg::cli::unknown_mode opt_mode,
          ::bpkg::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bpkg::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bpkg::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bpkg::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bpkg::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bpkg::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bpkg::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bpkg::cli::unknown_mode::fail:
            {
              throw ::bpkg::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bpkg::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bpkg::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bpkg::cli::unknown_mode::fail:
        {
          throw ::bpkg::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // pkg_build_options
  //

  pkg_build_options::
  pkg_build_options ()
  : yes_ (),
    for__ (),
    for__specified_ (false),
    keep_unused_ (),
    update_dependent_ (),
    leave_dependent_ (),
    configure_only_ (),
    print_only_ (),
    plan_ (),
    plan_specified_ (false),
    no_fetch_ (),
    fetch_shallow_ (),
    mask_repository_ (),
    mask_repository_specified_ (false),
    mask_repository_uuid_ (),
    mask_repository_uuid_specified_ (false),
    no_refinement_ (),
    no_move_ (),
    noop_exit_ (),
    noop_exit_specified_ (false),
    rebuild_checksum_ (),
    rebuild_checksum_specified_ (false),
    no_private_config_ (),
    no_private_config_specified_ (false),
    sys_no_query_ (),
    sys_install_ (),
    sys_no_fetch_ (),
    sys_no_stub_ (),
    sys_yes_ (),
    sys_sudo_ ("sudo"),
    sys_sudo_specified_ (false),
    sys_distribution_ (),
    sys_distribution_specified_ (false),
    sys_architecture_ (),
    sys_architecture_specified_ (false),
    directory_ (),
    directory_specified_ (false)
  {
  }

  bool pkg_build_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool pkg_build_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool pkg_build_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool pkg_build_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    ::bpkg::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool pkg_build_options::
  parse (::bpkg::cli::scanner& s,
         ::bpkg::cli::unknown_mode opt,
         ::bpkg::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void pkg_build_options::
  merge (const pkg_build_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // common_options base
    //
    ::bpkg::common_options::merge (a);

    // pkg_build_pkg_options base
    //
    ::bpkg::pkg_build_pkg_options::merge (a);

    if (a.yes_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->yes_, a.yes_);
    }

    if (a.for__specified_)
    {
      ::bpkg::cli::parser< string>::merge (
        this->for__, a.for__);
      this->for__specified_ = true;
    }

    if (a.keep_unused_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->keep_unused_, a.keep_unused_);
    }

    if (a.update_dependent_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->update_dependent_, a.update_dependent_);
    }

    if (a.leave_dependent_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->leave_dependent_, a.leave_dependent_);
    }

    if (a.configure_only_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->configure_only_, a.configure_only_);
    }

    if (a.print_only_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->print_only_, a.print_only_);
    }

    if (a.plan_specified_)
    {
      ::bpkg::cli::parser< string>::merge (
        this->plan_, a.plan_);
      this->plan_specified_ = true;
    }

    if (a.no_fetch_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->no_fetch_, a.no_fetch_);
    }

    if (a.fetch_shallow_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->fetch_shallow_, a.fetch_shallow_);
    }

    if (a.mask_repository_specified_)
    {
      ::bpkg::cli::parser< strings>::merge (
        this->mask_repository_, a.mask_repository_);
      this->mask_repository_specified_ = true;
    }

    if (a.mask_repository_uuid_specified_)
    {
      ::bpkg::cli::parser< strings>::merge (
        this->mask_repository_uuid_, a.mask_repository_uuid_);
      this->mask_repository_uuid_specified_ = true;
    }

    if (a.no_refinement_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->no_refinement_, a.no_refinement_);
    }

    if (a.no_move_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->no_move_, a.no_move_);
    }

    if (a.noop_exit_specified_)
    {
      ::bpkg::cli::parser< uint16_t>::merge (
        this->noop_exit_, a.noop_exit_);
      this->noop_exit_specified_ = true;
    }

    if (a.rebuild_checksum_specified_)
    {
      ::bpkg::cli::parser< string>::merge (
        this->rebuild_checksum_, a.rebuild_checksum_);
      this->rebuild_checksum_specified_ = true;
    }

    if (a.no_private_config_specified_)
    {
      ::bpkg::cli::parser< uint16_t>::merge (
        this->no_private_config_, a.no_private_config_);
      this->no_private_config_specified_ = true;
    }

    if (a.sys_no_query_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->sys_no_query_, a.sys_no_query_);
    }

    if (a.sys_install_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->sys_install_, a.sys_install_);
    }

    if (a.sys_no_fetch_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->sys_no_fetch_, a.sys_no_fetch_);
    }

    if (a.sys_no_stub_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->sys_no_stub_, a.sys_no_stub_);
    }

    if (a.sys_yes_)
    {
      ::bpkg::cli::parser< bool>::merge (
        this->sys_yes_, a.sys_yes_);
    }

    if (a.sys_sudo_specified_)
    {
      ::bpkg::cli::parser< string>::merge (
        this->sys_sudo_, a.sys_sudo_);
      this->sys_sudo_specified_ = true;
    }

    if (a.sys_distribution_specified_)
    {
      ::bpkg::cli::parser< string>::merge (
        this->sys_distribution_, a.sys_distribution_);
      this->sys_distribution_specified_ = true;
    }

    if (a.sys_architecture_specified_)
    {
      ::bpkg::cli::parser< string>::merge (
        this->sys_architecture_, a.sys_architecture_);
      this->sys_architecture_specified_ = true;
    }

    if (a.directory_specified_)
    {
      ::bpkg::cli::parser< dir_paths>::merge (
        this->directory_, a.directory_);
      this->directory_specified_ = true;
    }
  }

  ::bpkg::cli::usage_para pkg_build_options::
  print_usage (::std::ostream& os, ::bpkg::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bpkg::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mPKG-BUILD GLOBAL OPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m--yes\033[0m|\033[1m-y\033[0m                  Assume the answer to all prompts is \033[1myes\033[0m. Note that" << ::std::endl
       << "                          this excludes the system package manager prompts; see" << ::std::endl
       << "                          \033[1m--sys-yes\033[0m for details." << ::std::endl;

    os << std::endl
       << "\033[1m--for\033[0m|\033[1m-f\033[0m \033[4moperation\033[0m        Instead of the default \033[1mupdate\033[0m build system operation," << ::std::endl
       << "                          perform the \033[1mupdate-for-\033[0m\033[4moperation\033[0m variant where" << ::std::endl
       << "                          \033[4moperation\033[0m is normally \033[1minstall\033[0m or \033[1mtest\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--keep-unused\033[0m|\033[1m-K\033[0m          Don't drop dependency packages that were" << ::std::endl
       << "                          automatically built but will no longer be used." << ::std::endl;

    os << std::endl
       << "\033[1m--update-dependent\033[0m|\033[1m-U\033[0m     Update without confirmation dependent packages that" << ::std::endl
       << "                          are reconfigured due to their dependencies being" << ::std::endl
       << "                          upgraded or downgraded." << ::std::endl;

    os << std::endl
       << "\033[1m--leave-dependent\033[0m|\033[1m-L\033[0m      Don't offer to update dependent packages that are" << ::std::endl
       << "                          reconfigured due to their dependencies being upgraded" << ::std::endl
       << "                          or downgraded." << ::std::endl;

    os << std::endl
       << "\033[1m--configure-only\033[0m|\033[1m-c\033[0m       Configure all the packages but don't update." << ::std::endl;

    os << std::endl
       << "\033[1m--print-only\033[0m              Print to \033[1mstdout\033[0m what would be done without actually" << ::std::endl
       << "                          doing anything." << ::std::endl;

    os << std::endl
       << "\033[1m--plan\033[0m \033[4mheader\033[0m             Print the plan (even if \033[1m--yes\033[0m is specified) and start" << ::std::endl
       << "                          it with the \033[4mheader\033[0m line (unless it is empty)." << ::std::endl;

    os << std::endl
       << "\033[1m--no-fetch\033[0m                Don't fetch repositories specified as part of the" << ::std::endl
       << "                          build command." << ::std::endl;

    os << std::endl
       << "\033[1m--fetch-shallow\033[0m           Don't re-fetch complement and prerequisite" << ::std::endl
       << "                          repositories of repositories specified as part of the" << ::std::endl
       << "                          build command. Refer to the \033[1m--shallow\033[0m option in" << ::std::endl
       << "                          \033[1mbpkg-rep-fetch(1)\033[0m for details." << ::std::endl;

    os << std::endl
       << "\033[1m--mask-repository\033[0m \033[4mrep\033[0m     For the duration of the command execution pretend the" << ::std::endl
       << "                          specified repository was removed as if by performing" << ::std::endl
       << "                          the \033[1mrep-remove\033[0m command. The repository can be" << ::std::endl
       << "                          specified either as a repository name or as a" << ::std::endl
       << "                          repository location (URL or a directory path). Note" << ::std::endl
       << "                          that the repository's complement and prerequisite" << ::std::endl
       << "                          repositories are also considered masked, recursively," << ::std::endl
       << "                          unless they are complements and/or prerequisites of" << ::std::endl
       << "                          other unmasked repositories. Repeat this option to" << ::std::endl
       << "                          mask multiple repositories." << ::std::endl;

    os << std::endl
       << "\033[1m--mask-repository-uuid\033[0m \033[4mv\033[0m  For the duration of the command execution pretend the" << ::std::endl
       << "                          specified repository was removed from the specified" << ::std::endl
       << "                          configuration. Similar to \033[1m--mask-repository\033[0m but only" << ::std::endl
       << "                          masks the repository in a single configuration. The" << ::std::endl
       << "                          option value is a key-value pair in the form:" << ::std::endl
       << ::std::endl
       << "                          \033[4mconfig-uuid\033[0m\033[1m=\033[0m\033[4mrep\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "                          Repeat this option to mask multiple repositories." << ::std::endl;

    os << std::endl
       << "\033[1m--no-refinement\033[0m           Don't try to refine the configuration by offering to" << ::std::endl
       << "                          drop any unused dependencies that were potentially" << ::std::endl
       << "                          left behind on the previous \033[1mpkg-build\033[0m or \033[1mpkg-drop\033[0m" << ::std::endl
       << "                          command execution if the command is otherwise a noop" << ::std::endl
       << "                          (performs no new package builds, upgrades, etc)." << ::std::endl;

    os << std::endl
       << "\033[1m--no-move\033[0m                 Don't move dependency packages between" << ::std::endl
       << "                          configurations. In this mode the \033[1m--config-*\033[0m options" << ::std::endl
       << "                          specify packages' current rather than new locations." << ::std::endl;

    os << std::endl
       << "\033[1m--noop-exit\033[0m \033[4mcode\033[0m          Exit with the specified error code if the command" << ::std::endl
       << "                          execution is a noop (performs no new package builds," << ::std::endl
       << "                          upgrades, etc)." << ::std::endl;

    os << std::endl
       << "\033[1m--rebuild-checksum\033[0m \033[4msum\033[0m    Hash the names, versions, and configurations of all" << ::std::endl
       << "                          the packages that would be built. If the resulting" << ::std::endl
       << "                          checksum matches the specified, then exit without" << ::std::endl
       << "                          building anything (potentially with a special error" << ::std::endl
       << "                          code specified with the \033[1m--noop-exit\033[0m option)." << ::std::endl
       << "                          Otherwise, proceed to build as normal. In both cases," << ::std::endl
       << "                          print the resulting checksum to \033[1mstdout\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--no-private-config\033[0m \033[4mcode\033[0m  If no configuration of a suitable type is linked to" << ::std::endl
       << "                          build a build-time dependency, instead of" << ::std::endl
       << "                          automatically creating a private configuration of" << ::std::endl
       << "                          this type, exit with the specified error code" << ::std::endl
       << "                          printing to \033[1mstdout\033[0m the dependency chain starting from" << ::std::endl
       << "                          the build-time dependency (together with its" << ::std::endl
       << "                          constraint, if present) and ending with the top-level" << ::std::endl
       << "                          dependent (together with their configuration" << ::std::endl
       << "                          directories), one entry per line. For example:" << ::std::endl
       << ::std::endl
       << "                          yacc ^1.0.0" << ::std::endl
       << "                          libbar/1.0.0 /path/to/libbar/cfg/" << ::std::endl
       << "                          libfoo/1.0.0 /path/to/libfoo/cfg/" << ::std::endl
       << ::std::endl
       << "                          See \033[1mbpkg-cfg-create(1)\033[0m for details on linked" << ::std::endl
       << "                          configurations." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-no-query\033[0m            Do not query the system package manager for the" << ::std::endl
       << "                          installed versions of packages specified with the" << ::std::endl
       << "                          \033[1msys\033[0m scheme." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-install\033[0m             Instruct the system package manager to install" << ::std::endl
       << "                          available versions of packages specified with the" << ::std::endl
       << "                          \033[1msys\033[0m scheme that are not already installed. See also" << ::std::endl
       << "                          the \033[1m--sys-no-fetch\033[0m, \033[1m--sys-yes\033[0m, and \033[1m--sys-sudo\033[0m" << ::std::endl
       << "                          options." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-no-fetch\033[0m            Do not fetch the system package manager metadata" << ::std::endl
       << "                          before querying for available versions of packages" << ::std::endl
       << "                          specified with the \033[1msys\033[0m scheme. This option only makes" << ::std::endl
       << "                          sense together with \033[1m--sys-install\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-no-stub\033[0m             Do no require a stub for packages specified with the" << ::std::endl
       << "                          \033[1msys\033[0m scheme. Note that this option has effect only if" << ::std::endl
       << "                          the system package manager interactions are supported" << ::std::endl
       << "                          and not disabled." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-yes\033[0m                 Assume the answer to the system package manager" << ::std::endl
       << "                          prompts is \033[1myes\033[0m. Note that system package manager" << ::std::endl
       << "                          interactions may break your system and you should" << ::std::endl
       << "                          normally only use this option on throw-away setups" << ::std::endl
       << "                          (test virtual machines, etc)." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-sudo\033[0m \033[4mprog\033[0m           The \033[1msudo\033[0m program to use for system package manager" << ::std::endl
       << "                          interactions that normally require administrative" << ::std::endl
       << "                          privileges (fetch package metadata, install packages," << ::std::endl
       << "                          etc). If unspecified, \033[1msudo\033[0m is used by default. Pass" << ::std::endl
       << "                          empty or the special \033[1mfalse\033[0m value to disable the use" << ::std::endl
       << "                          of the \033[1msudo\033[0m program. Note that the \033[1msudo\033[0m program is" << ::std::endl
       << "                          normally only needed if the system package" << ::std::endl
       << "                          installation is enabled with the \033[1m--sys-install\033[0m" << ::std::endl
       << "                          option." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-distribution\033[0m \033[4mname\033[0m   Alternative system/distribution package manager to" << ::std::endl
       << "                          interact with. The valid \033[4mname\033[0m values are \033[1mdebian\033[0m" << ::std::endl
       << "                          (Debian and alike, such as Ubuntu, etc) and \033[1mfedora\033[0m" << ::std::endl
       << "                          (Fedora and alike, such as RHEL, CentOS, etc). Note" << ::std::endl
       << "                          that some package managers may only be supported when" << ::std::endl
       << "                          running on certain host operating systems." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-architecture\033[0m \033[4mname\033[0m   Alternative architecture to use when interacting with" << ::std::endl
       << "                          the system package manager. The valid \033[4mname\033[0m values are" << ::std::endl
       << "                          system/distribution package manager-specific. If" << ::std::endl
       << "                          unspecified, the host architecture is used." << ::std::endl;

    os << std::endl
       << "\033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mdir\033[0m        Assume current configuration is in \033[4mdir\033[0m rather than in" << ::std::endl
       << "                          the current working directory. Repeat this option to" << ::std::endl
       << "                          specify multiple current configurations. If multiple" << ::std::endl
       << "                          configurations are specified, they need not belong to" << ::std::endl
       << "                          the same linked configuration cluster." << ::std::endl;

    p = ::bpkg::cli::usage_para::option;

    // common_options base
    //
    p = ::bpkg::common_options::print_usage (os, p);

    return p;
  }

  typedef
  std::map<std::string, void (*) (pkg_build_options&, ::bpkg::cli::scanner&)>
  _cli_pkg_build_options_map;

  static _cli_pkg_build_options_map _cli_pkg_build_options_map_;

  struct _cli_pkg_build_options_map_init
  {
    _cli_pkg_build_options_map_init ()
    {
      _cli_pkg_build_options_map_["--yes"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::yes_ >;
      _cli_pkg_build_options_map_["-y"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::yes_ >;
      _cli_pkg_build_options_map_["--for"] =
      &::bpkg::cli::thunk< pkg_build_options, string, &pkg_build_options::for__,
        &pkg_build_options::for__specified_ >;
      _cli_pkg_build_options_map_["-f"] =
      &::bpkg::cli::thunk< pkg_build_options, string, &pkg_build_options::for__,
        &pkg_build_options::for__specified_ >;
      _cli_pkg_build_options_map_["--keep-unused"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::keep_unused_ >;
      _cli_pkg_build_options_map_["-K"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::keep_unused_ >;
      _cli_pkg_build_options_map_["--update-dependent"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::update_dependent_ >;
      _cli_pkg_build_options_map_["-U"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::update_dependent_ >;
      _cli_pkg_build_options_map_["--leave-dependent"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::leave_dependent_ >;
      _cli_pkg_build_options_map_["-L"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::leave_dependent_ >;
      _cli_pkg_build_options_map_["--configure-only"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::configure_only_ >;
      _cli_pkg_build_options_map_["-c"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::configure_only_ >;
      _cli_pkg_build_options_map_["--print-only"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::print_only_ >;
      _cli_pkg_build_options_map_["--plan"] =
      &::bpkg::cli::thunk< pkg_build_options, string, &pkg_build_options::plan_,
        &pkg_build_options::plan_specified_ >;
      _cli_pkg_build_options_map_["--no-fetch"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::no_fetch_ >;
      _cli_pkg_build_options_map_["--fetch-shallow"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::fetch_shallow_ >;
      _cli_pkg_build_options_map_["--mask-repository"] =
      &::bpkg::cli::thunk< pkg_build_options, strings, &pkg_build_options::mask_repository_,
        &pkg_build_options::mask_repository_specified_ >;
      _cli_pkg_build_options_map_["--mask-repository-uuid"] =
      &::bpkg::cli::thunk< pkg_build_options, strings, &pkg_build_options::mask_repository_uuid_,
        &pkg_build_options::mask_repository_uuid_specified_ >;
      _cli_pkg_build_options_map_["--no-refinement"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::no_refinement_ >;
      _cli_pkg_build_options_map_["--no-move"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::no_move_ >;
      _cli_pkg_build_options_map_["--noop-exit"] =
      &::bpkg::cli::thunk< pkg_build_options, uint16_t, &pkg_build_options::noop_exit_,
        &pkg_build_options::noop_exit_specified_ >;
      _cli_pkg_build_options_map_["--rebuild-checksum"] =
      &::bpkg::cli::thunk< pkg_build_options, string, &pkg_build_options::rebuild_checksum_,
        &pkg_build_options::rebuild_checksum_specified_ >;
      _cli_pkg_build_options_map_["--no-private-config"] =
      &::bpkg::cli::thunk< pkg_build_options, uint16_t, &pkg_build_options::no_private_config_,
        &pkg_build_options::no_private_config_specified_ >;
      _cli_pkg_build_options_map_["--sys-no-query"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::sys_no_query_ >;
      _cli_pkg_build_options_map_["--sys-install"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::sys_install_ >;
      _cli_pkg_build_options_map_["--sys-no-fetch"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::sys_no_fetch_ >;
      _cli_pkg_build_options_map_["--sys-no-stub"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::sys_no_stub_ >;
      _cli_pkg_build_options_map_["--sys-yes"] =
      &::bpkg::cli::thunk< pkg_build_options, &pkg_build_options::sys_yes_ >;
      _cli_pkg_build_options_map_["--sys-sudo"] =
      &::bpkg::cli::thunk< pkg_build_options, string, &pkg_build_options::sys_sudo_,
        &pkg_build_options::sys_sudo_specified_ >;
      _cli_pkg_build_options_map_["--sys-distribution"] =
      &::bpkg::cli::thunk< pkg_build_options, string, &pkg_build_options::sys_distribution_,
        &pkg_build_options::sys_distribution_specified_ >;
      _cli_pkg_build_options_map_["--sys-architecture"] =
      &::bpkg::cli::thunk< pkg_build_options, string, &pkg_build_options::sys_architecture_,
        &pkg_build_options::sys_architecture_specified_ >;
      _cli_pkg_build_options_map_["--directory"] =
      &::bpkg::cli::thunk< pkg_build_options, dir_paths, &pkg_build_options::directory_,
        &pkg_build_options::directory_specified_ >;
      _cli_pkg_build_options_map_["-d"] =
      &::bpkg::cli::thunk< pkg_build_options, dir_paths, &pkg_build_options::directory_,
        &pkg_build_options::directory_specified_ >;
    }
  };

  static _cli_pkg_build_options_map_init _cli_pkg_build_options_map_init_;

  bool pkg_build_options::
  _parse (const char* o, ::bpkg::cli::scanner& s)
  {
    _cli_pkg_build_options_map::const_iterator i (_cli_pkg_build_options_map_.find (o));

    if (i != _cli_pkg_build_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // common_options base
    //
    if (::bpkg::common_options::_parse (o, s))
      return true;

    // pkg_build_pkg_options base
    //
    if (::bpkg::pkg_build_pkg_options::_parse (o, s))
      return true;

    return false;
  }

  bool pkg_build_options::
  _parse (::bpkg::cli::scanner& s,
          ::bpkg::cli::unknown_mode opt_mode,
          ::bpkg::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bpkg::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bpkg::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bpkg::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bpkg::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bpkg::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bpkg::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bpkg::cli::unknown_mode::fail:
            {
              throw ::bpkg::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bpkg::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bpkg::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bpkg::cli::unknown_mode::fail:
        {
          throw ::bpkg::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bpkg
{
  ::bpkg::cli::usage_para
  print_bpkg_pkg_build_usage (::std::ostream& os, ::bpkg::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bpkg::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbpkg pkg-build\033[0m|\033[1mbuild\033[0m [\033[4moptions\033[0m] [\033[1m--upgrade\033[0m|\033[1m-u\033[0m | \033[1m--patch\033[0m|\033[1m-p\033[0m]" << ::std::endl
       << "                     [\033[4mcfg-var\033[0m... \033[1m--\033[0m] \033[4mpkg-spec\033[0m..." << ::std::endl
       << "\033[1mbpkg pkg-build\033[0m|\033[1mbuild\033[0m [\033[4moptions\033[0m]  \033[1m--upgrade\033[0m|\033[1m-u\033[0m | \033[1m--patch\033[0m|\033[1m-p\033[0m" << ::std::endl
       << "                     [\033[4mcfg-var\033[0m... \033[1m--\033[0m]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[4mpkg-spec\033[0m = [\033[4mflags\033[0m](([\033[4mscheme\033[0m\033[1m:\033[0m]\033[4mpkg\033[0m[\033[4mver-spec\033[0m])\033[1m,\033[0m...[\033[1m@\033[0m\033[4mrep-loc\033[0m] | " << ::std::endl
       << "                   [\033[1m@\033[0m]\033[4mrep-loc\033[0m                             | " << ::std::endl
       << "                   \033[4mfile\033[0m                                   | " << ::std::endl
       << "                   \033[4mdir\033[0m\033[1m/\033[0m)" << ::std::endl
       << "\033[4mflags\033[0m      = \033[1m?\033[0m" << ::std::endl
       << "\033[4mscheme\033[0m     = \033[1msys\033[0m" << ::std::endl
       << "\033[4mver-spec\033[0m   = \033[1m/\033[0m\033[4mversion\033[0m | \033[4mversion-constraint\033[0m\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mpkg-build\033[0m command builds one or more packages including all their" << ::std::endl
       << "dependencies. Besides building new packages, this command is also used to" << ::std::endl
       << "upgrade or downgrade packages that are already present in the configuration." << ::std::endl
       << "And unless the \033[1m--keep-unused\033[0m|\033[1m-K\033[0m\033[0m option is specified, \033[1mpkg-build\033[0m will also drop" << ::std::endl
       << "dependency packages that would otherwise no longer be used." << ::std::endl
       << ::std::endl
       << "The first form (one or more packages are specified) builds new or upgrades (by" << ::std::endl
       << "default or if \033[1m--upgrade\033[0m is specified) or patches (if \033[1m--patch\033[0m is specified) the" << ::std::endl
       << "specified packages. The second form (no arguments but either \033[1m--upgrade\033[0m or" << ::std::endl
       << "\033[1m--patch\033[0m is specified) upgrades or patches all the held packages in the" << ::std::endl
       << "configuration (see below for details on held package)." << ::std::endl
       << ::std::endl
       << "In both forms specifying the \033[1m--immediate\033[0m|\033[1m-i\033[0m\033[0m or \033[1m--recursive\033[0m|\033[1m-r\033[0m\033[0m option causes" << ::std::endl
       << "\033[1mpkg-build\033[0m to also upgrade or patch the immediate or all dependencies of the" << ::std::endl
       << "specified (first form) or held (second form) packages, respectively. Note also" << ::std::endl
       << "that in the first form these options can only be specified with an explicit" << ::std::endl
       << "\033[1m--upgrade\033[0m or \033[1m--patch\033[0m." << ::std::endl
       << ::std::endl
       << "Each package can be specified as just the name (\033[4mpkg\033[0m) with optional version" << ::std::endl
       << "specification (\033[4mver-spec\033[0m), in which case the source code for the package will be" << ::std::endl
       << "automatically fetched from one of the configured repositories. See the" << ::std::endl
       << "\033[1mbpkg-rep-add(1)\033[0m and \033[1mbpkg-rep-fetch(1)\033[0m commands for more information on package" << ::std::endl
       << "repositories. The version specification (\033[4mver-spec\033[0m) can be either the exact" << ::std::endl
       << "version in the \033[1m/\033[0m\033[4mversion\033[0m\033[0m form or the version constraint as described in Package" << ::std::endl
       << "Version Constraint (bpkg#package-version-constraint). If \033[4mver-spec\033[0m is not" << ::std::endl
       << "specified, then the latest available version will be built. To downgrade, the" << ::std::endl
       << "desired version must be specified explicitly. For example:" << ::std::endl
       << ::std::endl
       << "bpkg build foo libfoo/1.2.3 \"bar < 2.0.0\"" << ::std::endl
       << ::std::endl
       << "Alternatively, the package repository location (\033[4mrep-loc\033[0m) can be specified as" << ::std::endl
       << "part of the build command. In this case, if \033[4mver-spec\033[0m is not specified, then the" << ::std::endl
       << "latest available from this repository version will be built. For example:" << ::std::endl
       << ::std::endl
       << "bpkg build foo,libfoo/1.2.3@https://git.example.org/foo.git#master" << ::std::endl
       << ::std::endl
       << "If only the location is specified, then the latest versions of all the packages" << ::std::endl
       << "available directly from this repository will be built (note that this does not" << ::std::endl
       << "include packages available from complement repositories). The \033[1m@\033[0m delimiter can" << ::std::endl
       << "be omitted if the location is a URL. For example:" << ::std::endl
       << ::std::endl
       << "bpkg build https://git.example.org/foo.git#master" << ::std::endl
       << "bpkg build @/path/to/repository/" << ::std::endl
       << ::std::endl
       << "A package name (\033[4mpkg\033[0m) can be prefixed with a package scheme (\033[4mscheme\033[0m). Currently" << ::std::endl
       << "the only recognized scheme is \033[1msys\033[0m which instructs \033[1mpkg-build\033[0m to configure the" << ::std::endl
       << "package as available from the system rather than building it from source." << ::std::endl
       << ::std::endl
       << "The system package version (\033[4mver-spec\033[0m) may not be a version constraint but may" << ::std::endl
       << "be the special '\033[1m/*\033[0m' value, which indicates that the version should be" << ::std::endl
       << "considered unknown but satisfying any version constraint. If unspecified, then" << ::std::endl
       << "\033[1mpkg-build\033[0m will attempt to query the system package manager for the installed" << ::std::endl
       << "version unless the system package manager is unsupported or this functionality" << ::std::endl
       << "is disabled with \033[1m--sys-no-query\033[0m, in which case the '\033[1m/*\033[0m' \033[4mver-spec\033[0m is assumed. If" << ::std::endl
       << "the system package manager is supported, then the automatic installation of an" << ::std::endl
       << "available package can be requested with the \033[1m--sys-install\033[0m option. Note that if" << ::std::endl
       << "the version is not explicitly specified, then at least a stub package must be" << ::std::endl
       << "available from one of the repositories unless the \033[1m--sys-no-stub\033[0m option is" << ::std::endl
       << "specified." << ::std::endl
       << ::std::endl
       << "Finally, a package can be specified as either the path to the package archive" << ::std::endl
       << "(\033[4mfile\033[0m) or to the package directory (\033[4mdir\033[0m\033[1m/\033[0m; note that it must end with a" << ::std::endl
       << "directory separator). See the \033[1mbpkg-pkg-fetch(1)\033[0m and \033[1mbpkg-pkg-unpack(1)\033[0m commands" << ::std::endl
       << "for more information on the semantics of specifying the package as an archive" << ::std::endl
       << "or a directory." << ::std::endl
       << ::std::endl
       << "Additional configuration variables (\033[4mcfg-var\033[0m), if any, should be specified" << ::std::endl
       << "before packages (\033[4mpkg-spec\033[0m) and should be separated with \033[1m--\033[0m. Such variables are" << ::std::endl
       << "effective only when configuring and only for packages that were explicitly" << ::std::endl
       << "specified on the command line (unless global overrides). They can also be" << ::std::endl
       << "specified to only apply to specific packages using the argument grouping" << ::std::endl
       << "mechanism discussed below. See \033[1mbpkg-pkg-configure(1)\033[0m for more information on" << ::std::endl
       << "configuration variables." << ::std::endl
       << ::std::endl
       << "By default a package that is specified explicitly on the command line is built" << ::std::endl
       << "to \033[4mhold\033[0m: it will not be considered for automatic removal if it no longer has" << ::std::endl
       << "any dependents. Only versions from repositories that were added to the" << ::std::endl
       << "configuration (\033[1mbpkg-rep-add(1)\033[0m) are considered as available for build to hold." << ::std::endl
       << ::std::endl
       << "Alternatively, a package can be built (or, more commonly, upgraded/downgraded)" << ::std::endl
       << "as a \033[4mdependency\033[0m by specifying the \033[1m?\033[0m flag (\033[4mflags\033[0m) or the \033[1m--dependency\033[0m option." << ::std::endl
       << "Such a package will only be added to the configuration if it actually has any" << ::std::endl
       << "dependents and once no longer used, it will be automatically dropped. Only" << ::std::endl
       << "versions from prerequisite repositories of dependent packages are considered as" << ::std::endl
       << "available for build as a dependency." << ::std::endl
       << ::std::endl
       << "Packages (both built to hold and as dependencies) that are specified with an" << ::std::endl
       << "explicit package version (\033[4mver-spec\033[0m) or as an archive or directory, will have" << ::std::endl
       << "their versions held, that is, they will not be automatically upgraded." << ::std::endl
       << ::std::endl
       << "As an illustration, let's assume in the following example that the stable" << ::std::endl
       << "repository contains packages \033[1mfoo\033[0m \033[1m1.0.0\033[0m as well as \033[1mlibfoo\033[0m \033[1m1.0.0\033[0m and \033[1m1.1.0\033[0m while" << ::std::endl
       << "testing -- \033[1mlibfoo\033[0m \033[1m2.0.0\033[0m, that testing is complemented by stable, and that \033[1mfoo\033[0m" << ::std::endl
       << "depends on \033[1mlibfoo >= 1.0.0\033[0m:" << ::std::endl
       << ::std::endl
       << "bpkg fetch https://example.org/1/testing" << ::std::endl
       << ::std::endl
       << "bpkg build foo            # build foo    1.0.0 to hold" << ::std::endl
       << "                          # build libfoo 1.1.0 as dependency" << ::std::endl
       << ::std::endl
       << "bpkg build ?libfoo/1.0.0  # downgrade libfoo 1.0.0 as dependency," << ::std::endl
       << "                          #           also hold version 1.0.0" << ::std::endl
       << ::std::endl
       << "bpkg build ?libfoo/2.0.0  # error: 2.0.0 unavailable in dependent's" << ::std::endl
       << "                          #        (foo) repository (stable)" << ::std::endl
       << ::std::endl
       << "bpkg build libfoo/2.0.0   # upgrade libfoo 2.0.0 to hold," << ::std::endl
       << "                          #         also hold version 2.0.0" << ::std::endl
       << ::std::endl
       << "A package can be built in one of the linked configurations instead of the" << ::std::endl
       << "current (or host/build system module, for build-time dependencies)" << ::std::endl
       << "configuration by specifying one of the \033[1m--config-*\033[0m options (see" << ::std::endl
       << "\033[1mbpkg-cfg-create(1)\033[0m for background on linked configurations). For example:" << ::std::endl
       << ::std::endl
       << "bpkg build foo { --config-name=alt-host }+ ?bison" << ::std::endl;

    p = ::bpkg::pkg_build_pkg_options::print_usage (os, ::bpkg::cli::usage_para::text);

    p = ::bpkg::pkg_build_options::print_usage (os, p);

    if (p != ::bpkg::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "See \033[1mbpkg-default-options-files(1)\033[0m for an overview of the default options files." << ::std::endl
       << "For the \033[1mpkg-build\033[0m command the search start directory is the configuration" << ::std::endl
       << "directory. The following options files are searched for in each directory and," << ::std::endl
       << "if found, loaded in the order listed:" << ::std::endl
       << ::std::endl
       << "bpkg.options" << ::std::endl
       << "bpkg-pkg-build.options" << ::std::endl
       << ::std::endl
       << "The following \033[1mpkg-build\033[0m command options cannot be specified in the default" << ::std::endl
       << "options files:" << ::std::endl
       << ::std::endl
       << "--directory|-d" << ::std::endl;

    p = ::bpkg::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

