// -*- C++ -*-
//
// This file was generated by ODB, object-relational mapping (ORM)
// compiler for C++.
//

#ifndef BPKG_PACKAGE_ODB_HXX
#define BPKG_PACKAGE_ODB_HXX

// Begin prologue.
//
#include <libbutl/small-vector-odb.hxx>
#include <bpkg/pointer-traits.hxx>
//
// End prologue.

#include <odb/version.hxx>

#if ODB_VERSION != 20500UL
#error ODB runtime version mismatch
#endif

#include <odb/pre.hxx>

#include <bpkg/package.hxx>

#include <bpkg/package-common-odb.hxx>

#include <memory>
#include <cstddef>
#include <utility>

#include <odb/core.hxx>
#include <odb/traits.hxx>
#include <odb/callback.hxx>
#include <odb/wrapper-traits.hxx>
#include <odb/pointer-traits.hxx>
#include <odb/container-traits.hxx>
#include <odb/session.hxx>
#include <odb/cache-traits.hxx>
#include <odb/prepared-query.hxx>
#include <odb/result.hxx>
#include <odb/simple-object-result.hxx>
#include <odb/view-image.hxx>
#include <odb/view-result.hxx>

#include <odb/details/unused.hxx>
#include <odb/details/shared-ptr.hxx>

namespace odb
{
  // configuration
  //
  template <>
  struct class_traits< ::bpkg::configuration >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::configuration >
  {
    public:
    typedef ::bpkg::configuration object_type;
    typedef ::std::shared_ptr< ::bpkg::configuration > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::bpkg::optional_uint64_t id_type;

    static const bool auto_id = true;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    no_op_pointer_cache_traits<pointer_type>
    pointer_cache_traits;

    typedef
    no_op_reference_cache_traits<object_type>
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // repository_fragment
  //
  template <>
  struct class_traits< ::bpkg::repository_fragment >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::repository_fragment >
  {
    public:
    typedef ::bpkg::repository_fragment object_type;
    typedef ::std::shared_ptr< ::bpkg::repository_fragment > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::std::string id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // repository_fragment_count
  //
  template <>
  struct class_traits< ::bpkg::repository_fragment_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::repository_fragment_count >
  {
    public:
    typedef ::bpkg::repository_fragment_count view_type;
    typedef ::bpkg::repository_fragment_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // repository
  //
  template <>
  struct class_traits< ::bpkg::repository >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::repository >
  {
    public:
    typedef ::bpkg::repository object_type;
    typedef ::std::shared_ptr< ::bpkg::repository > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::std::string id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // repository_count
  //
  template <>
  struct class_traits< ::bpkg::repository_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::repository_count >
  {
    public:
    typedef ::bpkg::repository_count view_type;
    typedef ::bpkg::repository_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // available_package
  //
  template <>
  struct class_traits< ::bpkg::available_package >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::available_package >
  {
    public:
    typedef ::bpkg::available_package object_type;
    typedef ::std::shared_ptr< ::bpkg::available_package > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::bpkg::package_id id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // available_package_count
  //
  template <>
  struct class_traits< ::bpkg::available_package_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::available_package_count >
  {
    public:
    typedef ::bpkg::available_package_count view_type;
    typedef ::bpkg::available_package_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // available_test
  //
  template <>
  struct class_traits< ::bpkg::available_test >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::available_test >
  {
    public:
    typedef ::bpkg::available_test view_type;
    typedef ::bpkg::available_test* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // available_main
  //
  template <>
  struct class_traits< ::bpkg::available_main >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::available_main >
  {
    public:
    typedef ::bpkg::available_main view_type;
    typedef ::bpkg::available_main* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // selected_package
  //
  template <>
  struct class_traits< ::bpkg::selected_package >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::selected_package >
  {
    public:
    typedef ::bpkg::selected_package object_type;
    typedef ::std::shared_ptr< ::bpkg::selected_package > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::bpkg::package_name id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // certificate
  //
  template <>
  struct class_traits< ::bpkg::certificate >
  {
    static const class_kind kind = class_object;
  };

  template <>
  class access::object_traits< ::bpkg::certificate >
  {
    public:
    typedef ::bpkg::certificate object_type;
    typedef ::std::shared_ptr< ::bpkg::certificate > pointer_type;
    typedef odb::pointer_traits<pointer_type> pointer_traits;

    static const bool polymorphic = false;

    typedef ::std::string id_type;

    static const bool auto_id = false;

    static const bool abstract = false;

    static id_type
    id (const object_type&);

    typedef
    odb::pointer_cache_traits<
      pointer_type,
      odb::session >
    pointer_cache_traits;

    typedef
    odb::reference_cache_traits<
      object_type,
      odb::session >
    reference_cache_traits;

    static void
    callback (database&, object_type&, callback_event);

    static void
    callback (database&, const object_type&, callback_event);
  };

  // package_dependent
  //
  template <>
  struct class_traits< ::bpkg::package_dependent >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::package_dependent >
  {
    public:
    typedef ::bpkg::package_dependent view_type;
    typedef ::bpkg::package_dependent* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // fragment_repository_count
  //
  template <>
  struct class_traits< ::bpkg::fragment_repository_count >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::fragment_repository_count >
  {
    public:
    typedef ::bpkg::fragment_repository_count view_type;
    typedef ::bpkg::fragment_repository_count* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // fragment_repository
  //
  template <>
  struct class_traits< ::bpkg::fragment_repository >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::fragment_repository >
  {
    public:
    typedef ::bpkg::fragment_repository view_type;
    typedef ::bpkg::fragment_repository* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // repository_complement_dependent
  //
  template <>
  struct class_traits< ::bpkg::repository_complement_dependent >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::repository_complement_dependent >
  {
    public:
    typedef ::bpkg::repository_complement_dependent view_type;
    typedef ::bpkg::repository_complement_dependent* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // repository_prerequisite_dependent
  //
  template <>
  struct class_traits< ::bpkg::repository_prerequisite_dependent >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::repository_prerequisite_dependent >
  {
    public:
    typedef ::bpkg::repository_prerequisite_dependent view_type;
    typedef ::bpkg::repository_prerequisite_dependent* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // repository_fragment_package
  //
  template <>
  struct class_traits< ::bpkg::repository_fragment_package >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::repository_fragment_package >
  {
    public:
    typedef ::bpkg::repository_fragment_package view_type;
    typedef ::bpkg::repository_fragment_package* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };

  // package_repository_fragment
  //
  template <>
  struct class_traits< ::bpkg::package_repository_fragment >
  {
    static const class_kind kind = class_view;
  };

  template <>
  class access::view_traits< ::bpkg::package_repository_fragment >
  {
    public:
    typedef ::bpkg::package_repository_fragment view_type;
    typedef ::bpkg::package_repository_fragment* pointer_type;

    static void
    callback (database&, view_type&, callback_event);
  };
}

#include <odb/details/buffer.hxx>

#include <odb/sqlite/version.hxx>
#include <odb/sqlite/forward.hxx>
#include <odb/sqlite/binding.hxx>
#include <odb/sqlite/sqlite-types.hxx>
#include <odb/sqlite/query.hxx>

namespace odb
{
  // language
  //
  template <>
  class access::composite_value_traits< ::bpkg::language, id_sqlite >
  {
    public:
    typedef ::bpkg::language value_type;

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // impl
      //
      long long impl_value;
      bool impl_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // version_constraint
  //
  template <>
  class access::composite_value_traits< ::bpkg::version_constraint, id_sqlite >
  {
    public:
    typedef ::bpkg::version_constraint value_type;

    struct image_type
    {
      // min_version
      //
      composite_value_traits< ::bpkg::_version, id_sqlite >::image_type min_version_value;

      // max_version
      //
      composite_value_traits< ::bpkg::_version, id_sqlite >::image_type max_version_value;

      // min_open
      //
      long long min_open_value;
      bool min_open_null;

      // max_open
      //
      long long max_open_value;
      bool max_open_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 16UL;
  };

  // dependency
  //
  template <>
  class access::composite_value_traits< ::bpkg::dependency, id_sqlite >
  {
    public:
    typedef ::bpkg::dependency value_type;

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // constraint
      //
      composite_value_traits< ::bpkg::version_constraint, id_sqlite >::image_type constraint_value;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 17UL;
  };

  // dependency_alternative
  //
  template <>
  class access::composite_value_traits< ::bpkg::dependency_alternative, id_sqlite >
  {
    public:
    typedef ::bpkg::dependency_alternative value_type;

    struct image_type
    {
      // enable
      //
      details::buffer enable_value;
      std::size_t enable_size;
      bool enable_null;

      // reflect
      //
      details::buffer reflect_value;
      std::size_t reflect_size;
      bool reflect_null;

      // prefer
      //
      details::buffer prefer_value;
      std::size_t prefer_size;
      bool prefer_null;

      // accept
      //
      details::buffer accept_value;
      std::size_t accept_size;
      bool accept_null;

      // require
      //
      details::buffer require_value;
      std::size_t require_size;
      bool require_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 5UL;
  };

  // dependency_alternatives
  //
  template <>
  class access::composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >
  {
    public:
    typedef ::bpkg::dependency_alternatives value_type;

    struct image_type
    {
      // buildtime
      //
      long long buildtime_value;
      bool buildtime_null;

      // comment
      //
      details::buffer comment_value;
      std::size_t comment_size;
      bool comment_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // test_dependency
  //
  template <>
  class access::composite_value_traits< ::bpkg::test_dependency, id_sqlite >
  {
    public:
    typedef ::bpkg::test_dependency value_type;

    struct image_type: composite_value_traits< ::bpkg::dependency, id_sqlite >::image_type
    {
      // type
      //
      details::buffer type_value;
      std::size_t type_size;
      bool type_null;

      // buildtime
      //
      long long buildtime_value;
      bool buildtime_null;

      // enable
      //
      details::buffer enable_value;
      std::size_t enable_size;
      bool enable_null;

      // reflect
      //
      details::buffer reflect_value;
      std::size_t reflect_size;
      bool reflect_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 21UL;
  };

  // buildfile
  //
  template <>
  class access::composite_value_traits< ::bpkg::buildfile, id_sqlite >
  {
    public:
    typedef ::bpkg::buildfile value_type;

    struct image_type
    {
      // path
      //
      details::buffer path_value;
      std::size_t path_size;
      bool path_null;

      // content
      //
      details::buffer content_value;
      std::size_t content_size;
      bool content_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // distribution_name_value
  //
  template <>
  class access::composite_value_traits< ::bpkg::distribution_name_value, id_sqlite >
  {
    public:
    typedef ::bpkg::distribution_name_value value_type;

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // value
      //
      details::buffer value_value;
      std::size_t value_size;
      bool value_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // configuration
  //
  template <typename A>
  struct query_columns< ::bpkg::configuration, id_sqlite, A >
  {
    // id
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::odb::wrapper_traits_for_optional_uint64_t::wrapped_type,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    id_type_;

    static const id_type_ id;

    // uuid
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    uuid_type_;

    static const uuid_type_ uuid;

    // name
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    name_type_;

    static const name_type_ name;

    // type
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    type_type_;

    static const type_type_ type;

    // path
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    path_type_;

    static const path_type_ path;

    // expl
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        bool,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    expl_type_;

    static const expl_type_ expl;

    // fetch_cache_mode
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    fetch_cache_mode_type_;

    static const fetch_cache_mode_type_ fetch_cache_mode;
  };

  template <typename A>
  const typename query_columns< ::bpkg::configuration, id_sqlite, A >::id_type_
  query_columns< ::bpkg::configuration, id_sqlite, A >::
  id (A::table_name, "\"id\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::configuration, id_sqlite, A >::uuid_type_
  query_columns< ::bpkg::configuration, id_sqlite, A >::
  uuid (A::table_name, "\"uuid\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::configuration, id_sqlite, A >::name_type_
  query_columns< ::bpkg::configuration, id_sqlite, A >::
  name (A::table_name, "\"name\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::configuration, id_sqlite, A >::type_type_
  query_columns< ::bpkg::configuration, id_sqlite, A >::
  type (A::table_name, "\"type\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::configuration, id_sqlite, A >::path_type_
  query_columns< ::bpkg::configuration, id_sqlite, A >::
  path (A::table_name, "\"path\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::configuration, id_sqlite, A >::expl_type_
  query_columns< ::bpkg::configuration, id_sqlite, A >::
  expl (A::table_name, "\"explicit\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::configuration, id_sqlite, A >::fetch_cache_mode_type_
  query_columns< ::bpkg::configuration, id_sqlite, A >::
  fetch_cache_mode (A::table_name, "\"fetch_cache_mode\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::configuration, id_sqlite, A >:
    query_columns< ::bpkg::configuration, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::configuration, id_sqlite >:
    public access::object_traits< ::bpkg::configuration >
  {
    public:
    struct id_image_type
    {
      long long id_value;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      long long id_value;
      bool id_null;

      // uuid
      //
      details::buffer uuid_value;
      std::size_t uuid_size;
      bool uuid_null;

      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // type
      //
      details::buffer type_value;
      std::size_t type_size;
      bool type_null;

      // path
      //
      details::buffer path_value;
      std::size_t path_size;
      bool path_null;

      // expl
      //
      long long expl_value;
      bool expl_null;

      // fetch_cache_mode
      //
      details::buffer fetch_cache_mode_value;
      std::size_t fetch_cache_mode_size;
      bool fetch_cache_mode_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const id_image_type&);

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 7UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::configuration, id_common >:
    public access::object_traits_impl< ::bpkg::configuration, id_sqlite >
  {
  };

  // _repository_location
  //
  template <>
  class access::composite_value_traits< ::bpkg::_repository_location, id_sqlite >
  {
    public:
    typedef ::bpkg::_repository_location value_type;

    struct image_type
    {
      // url
      //
      details::buffer url_value;
      std::size_t url_size;
      bool url_null;

      // type
      //
      details::buffer type_value;
      std::size_t type_size;
      bool type_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // repository_fragment
  //
  template <typename A>
  struct query_columns< ::bpkg::repository_fragment, id_sqlite, A >
  {
    // name
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    name_type_;

    static const name_type_ name;

    // location
    //
    struct location_class_
    {
      location_class_ ()
      {
      }

      // url
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::bpkg::repository_url,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      url_type_;

      static const url_type_ url;

      // type
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      type_type_;

      static const type_type_ type;
    };

    static const location_class_ location;
  };

  template <typename A>
  const typename query_columns< ::bpkg::repository_fragment, id_sqlite, A >::name_type_
  query_columns< ::bpkg::repository_fragment, id_sqlite, A >::
  name (A::table_name, "\"name\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::repository_fragment, id_sqlite, A >::location_class_::url_type_
  query_columns< ::bpkg::repository_fragment, id_sqlite, A >::location_class_::
  url (A::table_name, "\"url\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::repository_fragment, id_sqlite, A >::location_class_::type_type_
  query_columns< ::bpkg::repository_fragment, id_sqlite, A >::location_class_::
  type (A::table_name, "\"type\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::repository_fragment, id_sqlite, A >::location_class_
  query_columns< ::bpkg::repository_fragment, id_sqlite, A >::location;

  template <typename A>
  struct pointer_query_columns< ::bpkg::repository_fragment, id_sqlite, A >:
    query_columns< ::bpkg::repository_fragment, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >:
    public access::object_traits< ::bpkg::repository_fragment >
  {
    public:
    struct id_image_type
    {
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // location
      //
      composite_value_traits< ::bpkg::_repository_location, id_sqlite >::image_type location_value;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    // complements
    //
    struct complements_traits
    {
      static const std::size_t id_column_count = 1UL;
      static const std::size_t data_column_count = 2UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::bpkg::repository_fragment::dependencies container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::value_type value_type;

      typedef set_functions<value_type> functions_type;
      typedef sqlite::container_statements< complements_traits > statements_type;

      struct data_image_type
      {
        // value
        //
        details::buffer value_value;
        std::size_t value_size;
        bool value_null;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const value_type&);

      static void
      init (value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const value_type&, void*);

      static bool
      select (value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // prerequisites
    //
    struct prerequisites_traits
    {
      static const std::size_t id_column_count = 1UL;
      static const std::size_t data_column_count = 2UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::bpkg::repository_fragment::dependencies container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::value_type value_type;

      typedef set_functions<value_type> functions_type;
      typedef sqlite::container_statements< prerequisites_traits > statements_type;

      struct data_image_type
      {
        // value
        //
        details::buffer value_value;
        std::size_t value_size;
        bool value_null;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const value_type&);

      static void
      init (value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const value_type&, void*);

      static bool
      select (value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 3UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::repository_fragment, id_common >:
    public access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite >
  {
  };

  // repository_fragment_count
  //
  template <>
  class access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >:
    public access::view_traits< ::bpkg::repository_fragment_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::repository_fragment_count, id_common >:
    public access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >
  {
  };

  // fragment_type
  //
  template <>
  class access::composite_value_traits< ::bpkg::repository::fragment_type, id_sqlite >
  {
    public:
    typedef ::bpkg::repository::fragment_type value_type;

    struct image_type
    {
      // friendly_name
      //
      details::buffer friendly_name_value;
      std::size_t friendly_name_size;
      bool friendly_name_null;

      // fragment
      //
      details::buffer fragment_value;
      std::size_t fragment_size;
      bool fragment_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // repository
  //
  template <typename A>
  struct query_columns< ::bpkg::repository, id_sqlite, A >
  {
    // name
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    name_type_;

    static const name_type_ name;

    // location
    //
    struct location_class_
    {
      location_class_ ()
      {
      }

      // url
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::bpkg::repository_url,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      url_type_;

      static const url_type_ url;

      // type
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      type_type_;

      static const type_type_ type;
    };

    static const location_class_ location;

    // certificate
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    certificate_type_;

    static const certificate_type_ certificate;

    // local
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        bool,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    local_type_;

    static const local_type_ local;
  };

  template <typename A>
  const typename query_columns< ::bpkg::repository, id_sqlite, A >::name_type_
  query_columns< ::bpkg::repository, id_sqlite, A >::
  name (A::table_name, "\"name\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::repository, id_sqlite, A >::location_class_::url_type_
  query_columns< ::bpkg::repository, id_sqlite, A >::location_class_::
  url (A::table_name, "\"url\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::repository, id_sqlite, A >::location_class_::type_type_
  query_columns< ::bpkg::repository, id_sqlite, A >::location_class_::
  type (A::table_name, "\"type\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::repository, id_sqlite, A >::location_class_
  query_columns< ::bpkg::repository, id_sqlite, A >::location;

  template <typename A>
  const typename query_columns< ::bpkg::repository, id_sqlite, A >::certificate_type_
  query_columns< ::bpkg::repository, id_sqlite, A >::
  certificate (A::table_name, "\"certificate\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::repository, id_sqlite, A >::local_type_
  query_columns< ::bpkg::repository, id_sqlite, A >::
  local (A::table_name, "\"local\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::repository, id_sqlite, A >:
    query_columns< ::bpkg::repository, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::repository, id_sqlite >:
    public access::object_traits< ::bpkg::repository >
  {
    public:
    struct id_image_type
    {
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // location
      //
      composite_value_traits< ::bpkg::_repository_location, id_sqlite >::image_type location_value;

      // certificate
      //
      details::buffer certificate_value;
      std::size_t certificate_size;
      bool certificate_null;

      // local
      //
      long long local_value;
      bool local_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    // fragments
    //
    struct fragments_traits
    {
      static const std::size_t id_column_count = 1UL;
      static const std::size_t data_column_count = 4UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::bpkg::repository::fragments_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< fragments_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 5UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::repository, id_common >:
    public access::object_traits_impl< ::bpkg::repository, id_sqlite >
  {
  };

  // repository_count
  //
  template <>
  class access::view_traits_impl< ::bpkg::repository_count, id_sqlite >:
    public access::view_traits< ::bpkg::repository_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::repository_count, id_common >:
    public access::view_traits_impl< ::bpkg::repository_count, id_sqlite >
  {
  };

  // package_location
  //
  template <>
  class access::composite_value_traits< ::bpkg::package_location, id_sqlite >
  {
    public:
    typedef ::bpkg::package_location value_type;

    struct image_type
    {
      // repository_fragment
      //
      details::buffer repository_fragment_value;
      std::size_t repository_fragment_size;
      bool repository_fragment_null;

      // location
      //
      details::buffer location_value;
      std::size_t location_size;
      bool location_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // dependency_alternatives_ex
  //
  template <>
  class access::composite_value_traits< ::bpkg::dependency_alternatives_ex, id_sqlite >
  {
    public:
    typedef ::bpkg::dependency_alternatives_ex value_type;

    struct image_type: composite_value_traits< ::bpkg::dependency_alternatives, id_sqlite >::image_type
    {
      // type
      //
      details::buffer type_value;
      std::size_t type_size;
      bool type_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 3UL;
  };

  // _dependency_alternative_key
  //
  template <>
  class access::composite_value_traits< ::bpkg::available_package::_dependency_alternative_key, id_sqlite >
  {
    public:
    typedef ::bpkg::available_package::_dependency_alternative_key value_type;

    struct image_type
    {
      // outer
      //
      long long outer_value;
      bool outer_null;

      // inner
      //
      long long inner_value;
      bool inner_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // _dependency_key
  //
  template <>
  class access::composite_value_traits< ::bpkg::available_package::_dependency_key, id_sqlite >
  {
    public:
    typedef ::bpkg::available_package::_dependency_key value_type;

    struct image_type
    {
      // outer
      //
      long long outer_value;
      bool outer_null;

      // middle
      //
      long long middle_value;
      bool middle_null;

      // inner
      //
      long long inner_value;
      bool inner_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 3UL;
  };

  // available_package
  //
  template <typename A>
  struct query_columns< ::bpkg::available_package, id_sqlite, A >
  {
    // id
    //
    struct id_class_
    {
      id_class_ ()
      {
      }

      // name
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::bpkg::package_name,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      name_type_;

      static const name_type_ name;

      // version
      //
      struct version_class_1_
      {
        version_class_1_ ()
        {
        }

        // epoch
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::uint16_t,
            sqlite::id_integer >::query_type,
          sqlite::id_integer >
        epoch_type_;

        static const epoch_type_ epoch;

        // canonical_upstream
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::std::string,
            sqlite::id_text >::query_type,
          sqlite::id_text >
        canonical_upstream_type_;

        static const canonical_upstream_type_ canonical_upstream;

        // canonical_release
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::std::string,
            sqlite::id_text >::query_type,
          sqlite::id_text >
        canonical_release_type_;

        static const canonical_release_type_ canonical_release;

        // revision
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::uint16_t,
            sqlite::id_integer >::query_type,
          sqlite::id_integer >
        revision_type_;

        static const revision_type_ revision;

        // iteration
        //
        typedef
        sqlite::query_column<
          sqlite::value_traits<
            ::uint32_t,
            sqlite::id_integer >::query_type,
          sqlite::id_integer >
        iteration_type_;

        static const iteration_type_ iteration;
      };

      static const version_class_1_ version;
    };

    static const id_class_ id;

    // version
    //
    struct version_class_
    {
      version_class_ ()
      {
      }

      // upstream
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::basic_string< char >,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      release_type_;

      static const release_type_ release;
    };

    static const version_class_ version;

    // upstream_version
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    upstream_version_type_;

    static const upstream_version_type_ upstream_version;

    // type
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    type_type_;

    static const type_type_ type;

    // project
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::butl::project_name,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    project_type_;

    static const project_type_ project;

    // alt_naming
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        bool,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    alt_naming_type_;

    static const alt_naming_type_ alt_naming;

    // bootstrap_build
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    bootstrap_build_type_;

    static const bootstrap_build_type_ bootstrap_build;

    // root_build
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    root_build_type_;

    static const root_build_type_ root_build;

    // sha256sum
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    sha256sum_type_;

    static const sha256sum_type_ sha256sum;
  };

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::name_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::
  name (A::table_name, "\"name\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::epoch_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::
  epoch (A::table_name, "\"version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::canonical_upstream_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::
  canonical_upstream (A::table_name, "\"version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::canonical_release_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::
  canonical_release (A::table_name, "\"version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::revision_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::
  revision (A::table_name, "\"version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::iteration_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_::
  iteration (A::table_name, "\"version_iteration\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version_class_1_
  query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_::version;

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::id_class_
  query_columns< ::bpkg::available_package, id_sqlite, A >::id;

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::version_class_::upstream_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::version_class_::
  upstream (A::table_name, "\"version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::version_class_::release_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::version_class_::
  release (A::table_name, "\"version_release\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::version_class_
  query_columns< ::bpkg::available_package, id_sqlite, A >::version;

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::upstream_version_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::
  upstream_version (A::table_name, "\"upstream_version\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::type_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::
  type (A::table_name, "\"type\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::project_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::
  project (A::table_name, "\"project\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::alt_naming_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::
  alt_naming (A::table_name, "\"alt_naming\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::bootstrap_build_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::
  bootstrap_build (A::table_name, "\"bootstrap_build\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::root_build_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::
  root_build (A::table_name, "\"root_build\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::available_package, id_sqlite, A >::sha256sum_type_
  query_columns< ::bpkg::available_package, id_sqlite, A >::
  sha256sum (A::table_name, "\"sha256sum\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::available_package, id_sqlite, A >:
    query_columns< ::bpkg::available_package, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::available_package, id_sqlite >:
    public access::object_traits< ::bpkg::available_package >
  {
    public:
    struct id_image_type
    {
      composite_value_traits< ::bpkg::package_id, id_sqlite >::image_type id_value;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      composite_value_traits< ::bpkg::package_id, id_sqlite >::image_type id_value;

      // version
      //
      composite_value_traits< ::bpkg::original_version, id_sqlite >::image_type version_value;

      // upstream_version
      //
      details::buffer upstream_version_value;
      std::size_t upstream_version_size;
      bool upstream_version_null;

      // type
      //
      details::buffer type_value;
      std::size_t type_size;
      bool type_null;

      // project
      //
      details::buffer project_value;
      std::size_t project_size;
      bool project_null;

      // alt_naming
      //
      long long alt_naming_value;
      bool alt_naming_null;

      // bootstrap_build
      //
      details::buffer bootstrap_build_value;
      std::size_t bootstrap_build_size;
      bool bootstrap_build_null;

      // root_build
      //
      details::buffer root_build_value;
      std::size_t root_build_size;
      bool root_build_null;

      // sha256sum
      //
      details::buffer sha256sum_value;
      std::size_t sha256sum_size;
      bool sha256sum_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    // languages
    //
    struct languages_traits
    {
      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::butl::small_vector< ::bpkg::language, 1 > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< languages_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // locations
    //
    struct locations_traits
    {
      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 8UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::butl::small_vector< ::bpkg::package_location, 1 > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< locations_traits > statements_type;

      struct data_image_type
      {
        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const value_type&);

      static void
      init (value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // dependencies
    //
    struct dependencies_traits
    {
      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 10UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::bpkg::available_package::dependencies_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< dependencies_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // dependency_alternatives
    //
    struct dependency_alternatives_traits
    {
      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 13UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::std::map< ::odb::nested_key< ::bpkg::dependency_alternatives_ex >, ::bpkg::dependency_alternative > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef sqlite::container_statements< dependency_alternatives_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_sqlite >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // dependency_alternative_dependencies
    //
    struct dependency_alternative_dependencies_traits
    {
      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 26UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::std::map< ::odb::nested2_key< ::bpkg::dependency_alternatives_ex >, ::bpkg::dependency > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef sqlite::container_statements< dependency_alternative_dependencies_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< key_type, id_sqlite >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // tests
    //
    struct tests_traits
    {
      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 28UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::butl::small_vector< ::bpkg::test_dependency, 1 > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< tests_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // buildfiles
    //
    struct buildfiles_traits
    {
      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::std::vector< ::bpkg::buildfile > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< buildfiles_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // distribution_values
    //
    struct distribution_values_traits
    {
      static const std::size_t id_column_count = 6UL;
      static const std::size_t data_column_count = 9UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::std::vector< ::bpkg::distribution_name_value > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< distribution_values_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // languages_section
    //
    struct languages_section_traits
    {
      typedef object_traits_impl<object_type, id_sqlite>::image_type image_type;
      typedef object_traits_impl<object_type, id_sqlite>::id_image_type id_image_type;

      static const std::size_t id_column_count = 6UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);

      static void
      update (extra_statement_cache_type&, const object_type&);
    };

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 15UL;
    static const std::size_t id_column_count = 6UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static bool
    load (connection&, object_type&, section&);

    static bool
    update (connection&, const object_type&, const section&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::available_package, id_common >:
    public access::object_traits_impl< ::bpkg::available_package, id_sqlite >
  {
  };

  // available_package_count
  //
  template <>
  class access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >:
    public access::view_traits< ::bpkg::available_package_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::available_package_count, id_common >:
    public access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >
  {
  };

  // available_test
  //
  template <>
  class access::view_traits_impl< ::bpkg::available_test, id_sqlite >:
    public access::view_traits< ::bpkg::available_test >
  {
    public:
    struct image_type
    {
      // package
      //
      object_traits_impl< ::bpkg::available_package, id_sqlite >::image_type package_value;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    struct package_tag;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 15UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::available_test, id_common >:
    public access::view_traits_impl< ::bpkg::available_test, id_sqlite >
  {
  };

  // available_main
  //
  template <>
  class access::view_traits_impl< ::bpkg::available_main, id_sqlite >:
    public access::view_traits< ::bpkg::available_main >
  {
    public:
    struct image_type
    {
      // package
      //
      object_traits_impl< ::bpkg::available_package, id_sqlite >::image_type package_value;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    struct package_tag;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 15UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::available_main, id_common >:
    public access::view_traits_impl< ::bpkg::available_main, id_sqlite >
  {
  };

  // prerequisite_info
  //
  template <>
  class access::composite_value_traits< ::bpkg::prerequisite_info, id_sqlite >
  {
    public:
    typedef ::bpkg::prerequisite_info value_type;

    struct image_type
    {
      // constraint
      //
      composite_value_traits< ::bpkg::version_constraint, id_sqlite >::image_type constraint_value;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 16UL;
  };

  // _selected_package_ref
  //
  template <>
  class access::composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >
  {
    public:
    typedef ::bpkg::_selected_package_ref value_type;

    struct image_type
    {
      // configuration
      //
      details::buffer configuration_value;
      std::size_t configuration_size;
      bool configuration_null;

      // prerequisite
      //
      details::buffer prerequisite_value;
      std::size_t prerequisite_size;
      bool prerequisite_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // config_variable
  //
  template <>
  class access::composite_value_traits< ::bpkg::config_variable, id_sqlite >
  {
    public:
    typedef ::bpkg::config_variable value_type;

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // source
      //
      details::buffer source_value;
      std::size_t source_size;
      bool source_null;
    };

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static bool
    init (image_type&,
          const value_type&,
          sqlite::statement_kind);

    static void
    init (value_type&,
          const image_type&,
          database*);

    static bool
    get_null (const image_type&);

    static void
    set_null (image_type&,
              sqlite::statement_kind);

    static const std::size_t column_count = 2UL;
  };

  // selected_package
  //
  template <typename A>
  struct query_columns< ::bpkg::selected_package, id_sqlite, A >
  {
    // name
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::bpkg::package_name,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    name_type_;

    static const name_type_ name;

    // version
    //
    struct version_class_
    {
      version_class_ ()
      {
      }

      // epoch
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::uint16_t,
          sqlite::id_integer >::query_type,
        sqlite::id_integer >
      epoch_type_;

      static const epoch_type_ epoch;

      // canonical_upstream
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      canonical_upstream_type_;

      static const canonical_upstream_type_ canonical_upstream;

      // canonical_release
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      canonical_release_type_;

      static const canonical_release_type_ canonical_release;

      // revision
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          short unsigned int,
          sqlite::id_integer >::query_type,
        sqlite::id_integer >
      revision_type_;

      static const revision_type_ revision;

      // iteration
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::uint32_t,
          sqlite::id_integer >::query_type,
        sqlite::id_integer >
      iteration_type_;

      static const iteration_type_ iteration;

      // upstream
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      upstream_type_;

      static const upstream_type_ upstream;

      // release
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::basic_string< char >,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      release_type_;

      static const release_type_ release;
    };

    static const version_class_ version;

    // state
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    state_type_;

    static const state_type_ state;

    // substate
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    substate_type_;

    static const substate_type_ substate;

    // hold_package
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        bool,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    hold_package_type_;

    static const hold_package_type_ hold_package;

    // hold_version
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        bool,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    hold_version_type_;

    static const hold_version_type_ hold_version;

    // repository_fragment
    //
    struct repository_fragment_class_
    {
      repository_fragment_class_ ()
      {
      }

      // url
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::bpkg::repository_url,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      url_type_;

      static const url_type_ url;

      // type
      //
      typedef
      sqlite::query_column<
        sqlite::value_traits<
          ::std::string,
          sqlite::id_text >::query_type,
        sqlite::id_text >
      type_type_;

      static const type_type_ type;
    };

    static const repository_fragment_class_ repository_fragment;

    // archive
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    archive_type_;

    static const archive_type_ archive;

    // purge_archive
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        bool,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    purge_archive_type_;

    static const purge_archive_type_ purge_archive;

    // src_root
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    src_root_type_;

    static const src_root_type_ src_root;

    // purge_src
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        bool,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    purge_src_type_;

    static const purge_src_type_ purge_src;

    // manifest_checksum
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    manifest_checksum_type_;

    static const manifest_checksum_type_ manifest_checksum;

    // buildfiles_checksum
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    buildfiles_checksum_type_;

    static const buildfiles_checksum_type_ buildfiles_checksum;

    // out_root
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    out_root_type_;

    static const out_root_type_ out_root;

    // config_checksum
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    config_checksum_type_;

    static const config_checksum_type_ config_checksum;

    // manifest
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::basic_string< char >,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    manifest_type_;

    static const manifest_type_ manifest;
  };

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::name_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  name (A::table_name, "\"name\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::epoch_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::
  epoch (A::table_name, "\"version_epoch\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::canonical_upstream_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::
  canonical_upstream (A::table_name, "\"version_canonical_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::canonical_release_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::
  canonical_release (A::table_name, "\"version_canonical_release\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::revision_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::
  revision (A::table_name, "\"version_revision\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::iteration_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::
  iteration (A::table_name, "\"version_iteration\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::upstream_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::
  upstream (A::table_name, "\"version_upstream\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::release_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_::
  release (A::table_name, "\"version_release\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::version_class_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::version;

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::state_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  state (A::table_name, "\"state\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::substate_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  substate (A::table_name, "\"substate\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::hold_package_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  hold_package (A::table_name, "\"hold_package\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::hold_version_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  hold_version (A::table_name, "\"hold_version\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::repository_fragment_class_::url_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::repository_fragment_class_::
  url (A::table_name, "\"repository_fragment_url\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::repository_fragment_class_::type_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::repository_fragment_class_::
  type (A::table_name, "\"repository_fragment_type\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::repository_fragment_class_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::repository_fragment;

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::archive_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  archive (A::table_name, "\"archive\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::purge_archive_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  purge_archive (A::table_name, "\"purge_archive\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::src_root_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  src_root (A::table_name, "\"src_root\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::purge_src_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  purge_src (A::table_name, "\"purge_src\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::manifest_checksum_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  manifest_checksum (A::table_name, "\"manifest_checksum\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::buildfiles_checksum_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  buildfiles_checksum (A::table_name, "\"buildfiles_checksum\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::out_root_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  out_root (A::table_name, "\"out_root\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::config_checksum_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  config_checksum (A::table_name, "\"config_checksum\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::selected_package, id_sqlite, A >::manifest_type_
  query_columns< ::bpkg::selected_package, id_sqlite, A >::
  manifest (A::table_name, "\"manifest\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::selected_package, id_sqlite, A >:
    query_columns< ::bpkg::selected_package, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::selected_package, id_sqlite >:
    public access::object_traits< ::bpkg::selected_package >
  {
    public:
    struct id_image_type
    {
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // version
      //
      composite_value_traits< ::bpkg::_version, id_sqlite >::image_type version_value;

      // state
      //
      details::buffer state_value;
      std::size_t state_size;
      bool state_null;

      // substate
      //
      details::buffer substate_value;
      std::size_t substate_size;
      bool substate_null;

      // hold_package
      //
      long long hold_package_value;
      bool hold_package_null;

      // hold_version
      //
      long long hold_version_value;
      bool hold_version_null;

      // repository_fragment
      //
      composite_value_traits< ::bpkg::_repository_location, id_sqlite >::image_type repository_fragment_value;

      // archive
      //
      details::buffer archive_value;
      std::size_t archive_size;
      bool archive_null;

      // purge_archive
      //
      long long purge_archive_value;
      bool purge_archive_null;

      // src_root
      //
      details::buffer src_root_value;
      std::size_t src_root_size;
      bool src_root_null;

      // purge_src
      //
      long long purge_src_value;
      bool purge_src_null;

      // manifest_checksum
      //
      details::buffer manifest_checksum_value;
      std::size_t manifest_checksum_size;
      bool manifest_checksum_null;

      // buildfiles_checksum
      //
      details::buffer buildfiles_checksum_value;
      std::size_t buildfiles_checksum_size;
      bool buildfiles_checksum_null;

      // out_root
      //
      details::buffer out_root_value;
      std::size_t out_root_size;
      bool out_root_null;

      // config_checksum
      //
      details::buffer config_checksum_value;
      std::size_t config_checksum_size;
      bool config_checksum_null;

      // manifest
      //
      details::buffer manifest_value;
      std::size_t manifest_size;
      bool manifest_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    // prerequisites
    //
    struct prerequisites_traits
    {
      static const std::size_t id_column_count = 1UL;
      static const std::size_t data_column_count = 19UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::bpkg::package_prerequisites container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::key_type key_type;
      typedef container_traits_type::value_type value_type;

      typedef map_functions<key_type, value_type> functions_type;
      typedef sqlite::container_statements< prerequisites_traits > statements_type;

      struct data_image_type
      {
        // key
        //
        composite_value_traits< ::bpkg::_selected_package_ref, id_sqlite >::image_type key_value;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            const key_type*,
            const value_type&);

      static void
      init (key_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (const key_type&, const value_type&, void*);

      static bool
      select (key_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // dependency_alternatives
    //
    struct dependency_alternatives_traits
    {
      static const std::size_t id_column_count = 1UL;
      static const std::size_t data_column_count = 3UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::bpkg::selected_package::indexes_type container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< dependency_alternatives_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        long long value_value;
        bool value_null;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // config_variables
    //
    struct config_variables_traits
    {
      static const std::size_t id_column_count = 1UL;
      static const std::size_t data_column_count = 4UL;

      static const bool versioned = false;

      static const char insert_statement[];
      static const char select_statement[];
      static const char delete_statement[];

      typedef ::std::vector< ::bpkg::config_variable > container_type;
      typedef
      odb::access::container_traits<container_type>
      container_traits_type;
      typedef container_traits_type::index_type index_type;
      typedef container_traits_type::value_type value_type;

      typedef ordered_functions<index_type, value_type> functions_type;
      typedef sqlite::container_statements< config_variables_traits > statements_type;

      struct data_image_type
      {
        // index
        //
        long long index_value;
        bool index_null;

        // value
        //
        composite_value_traits< value_type, id_sqlite >::image_type value_value;

        std::size_t version;
      };

      static void
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            data_image_type&);

      static void
      grow (data_image_type&,
            bool*);

      static void
      init (data_image_type&,
            index_type*,
            const value_type&);

      static void
      init (index_type&,
            value_type&,
            const data_image_type&,
            database*);

      static void
      insert (index_type, const value_type&, void*);

      static bool
      select (index_type&, value_type&, void*);

      static void
      delete_ (void*);

      static void
      persist (const container_type&,
               statements_type&);

      static void
      load (container_type&,
            statements_type&);

      static void
      update (const container_type&,
              statements_type&);

      static void
      erase (statements_type&);
    };

    // dependency_alternatives_section
    //
    struct dependency_alternatives_section_traits
    {
      typedef object_traits_impl<object_type, id_sqlite>::image_type image_type;
      typedef object_traits_impl<object_type, id_sqlite>::id_image_type id_image_type;

      static const std::size_t id_column_count = 1UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 0UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 0UL;

      static const bool versioned = false;

      static void
      load (extra_statement_cache_type&, object_type&);

      static void
      update (extra_statement_cache_type&, const object_type&);
    };

    // manifest_section
    //
    struct manifest_section_traits
    {
      typedef object_traits_impl<object_type, id_sqlite>::image_type image_type;
      typedef object_traits_impl<object_type, id_sqlite>::id_image_type id_image_type;

      static std::size_t
      bind (sqlite::bind*,
            const sqlite::bind* id,
            std::size_t id_size,
            image_type&,
            sqlite::statement_kind);

      static bool
      grow (image_type&,
            bool*);

      static void
      init (object_type&,
            const image_type&,
            database*);

      static bool
      init (image_type&,
            const object_type&);

      static const std::size_t id_column_count = 1UL;
      static const std::size_t managed_optimistic_load_column_count = 0UL;
      static const std::size_t load_column_count = 1UL;
      static const std::size_t managed_optimistic_update_column_count = 0UL;
      static const std::size_t update_column_count = 1UL;

      static const bool versioned = false;

      static const char select_statement[];

      static const char update_statement[];

      typedef sqlite::section_statements< object_type, manifest_section_traits > statements_type;

      static void
      load (extra_statement_cache_type&, object_type&);

      static void
      update (extra_statement_cache_type&, const object_type&);
    };

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 23UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 1UL;
    static const std::size_t separate_update_column_count = 1UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static bool
    load (connection&, object_type&, section&);

    static bool
    update (connection&, const object_type&, const section&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::selected_package, id_common >:
    public access::object_traits_impl< ::bpkg::selected_package, id_sqlite >
  {
  };

  // certificate
  //
  template <typename A>
  struct query_columns< ::bpkg::certificate, id_sqlite, A >
  {
    // id
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    id_type_;

    static const id_type_ id;

    // fingerprint
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    fingerprint_type_;

    static const fingerprint_type_ fingerprint;

    // name
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    name_type_;

    static const name_type_ name;

    // organization
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    organization_type_;

    static const organization_type_ organization;

    // email
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::std::string,
        sqlite::id_text >::query_type,
      sqlite::id_text >
    email_type_;

    static const email_type_ email;

    // start_date
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::uint64_t,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    start_date_type_;

    static const start_date_type_ start_date;

    // end_date
    //
    typedef
    sqlite::query_column<
      sqlite::value_traits<
        ::uint64_t,
        sqlite::id_integer >::query_type,
      sqlite::id_integer >
    end_date_type_;

    static const end_date_type_ end_date;
  };

  template <typename A>
  const typename query_columns< ::bpkg::certificate, id_sqlite, A >::id_type_
  query_columns< ::bpkg::certificate, id_sqlite, A >::
  id (A::table_name, "\"id\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::certificate, id_sqlite, A >::fingerprint_type_
  query_columns< ::bpkg::certificate, id_sqlite, A >::
  fingerprint (A::table_name, "\"fingerprint\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::certificate, id_sqlite, A >::name_type_
  query_columns< ::bpkg::certificate, id_sqlite, A >::
  name (A::table_name, "\"name\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::certificate, id_sqlite, A >::organization_type_
  query_columns< ::bpkg::certificate, id_sqlite, A >::
  organization (A::table_name, "\"organization\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::certificate, id_sqlite, A >::email_type_
  query_columns< ::bpkg::certificate, id_sqlite, A >::
  email (A::table_name, "\"email\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::certificate, id_sqlite, A >::start_date_type_
  query_columns< ::bpkg::certificate, id_sqlite, A >::
  start_date (A::table_name, "\"start_date\"", 0);

  template <typename A>
  const typename query_columns< ::bpkg::certificate, id_sqlite, A >::end_date_type_
  query_columns< ::bpkg::certificate, id_sqlite, A >::
  end_date (A::table_name, "\"end_date\"", 0);

  template <typename A>
  struct pointer_query_columns< ::bpkg::certificate, id_sqlite, A >:
    query_columns< ::bpkg::certificate, id_sqlite, A >
  {
  };

  template <>
  class access::object_traits_impl< ::bpkg::certificate, id_sqlite >:
    public access::object_traits< ::bpkg::certificate >
  {
    public:
    struct id_image_type
    {
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      std::size_t version;
    };

    struct image_type
    {
      // id
      //
      details::buffer id_value;
      std::size_t id_size;
      bool id_null;

      // fingerprint
      //
      details::buffer fingerprint_value;
      std::size_t fingerprint_size;
      bool fingerprint_null;

      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // organization
      //
      details::buffer organization_value;
      std::size_t organization_size;
      bool organization_null;

      // email
      //
      details::buffer email_value;
      std::size_t email_size;
      bool email_null;

      // start_date
      //
      long long start_date_value;
      bool start_date_null;

      // end_date
      //
      long long end_date_value;
      bool end_date_null;

      std::size_t version;
    };

    struct extra_statement_cache_type;

    using object_traits<object_type>::id;

    static id_type
    id (const image_type&);

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&,
          sqlite::statement_kind);

    static void
    bind (sqlite::bind*, id_image_type&);

    static bool
    init (image_type&,
          const object_type&,
          sqlite::statement_kind);

    static void
    init (object_type&,
          const image_type&,
          database*);

    static void
    init (id_image_type&, const id_type&);

    typedef sqlite::object_statements<object_type> statements_type;

    typedef sqlite::query_base query_base_type;

    static const std::size_t column_count = 7UL;
    static const std::size_t id_column_count = 1UL;
    static const std::size_t inverse_column_count = 0UL;
    static const std::size_t readonly_column_count = 0UL;
    static const std::size_t managed_optimistic_column_count = 0UL;

    static const std::size_t separate_load_column_count = 0UL;
    static const std::size_t separate_update_column_count = 0UL;

    static const bool versioned = false;

    static const char persist_statement[];
    static const char find_statement[];
    static const char update_statement[];
    static const char erase_statement[];
    static const char query_statement[];
    static const char erase_query_statement[];

    static const char table_name[];

    static void
    persist (database&, const object_type&);

    static pointer_type
    find (database&, const id_type&);

    static bool
    find (database&, const id_type&, object_type&);

    static bool
    reload (database&, object_type&);

    static void
    update (database&, const object_type&);

    static void
    erase (database&, const id_type&);

    static void
    erase (database&, const object_type&);

    static result<object_type>
    query (database&, const query_base_type&);

    static unsigned long long
    erase_query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);

    public:
    static bool
    find_ (statements_type&,
           const id_type*);

    static void
    load_ (statements_type&,
           object_type&,
           bool reload);
  };

  template <>
  class access::object_traits_impl< ::bpkg::certificate, id_common >:
    public access::object_traits_impl< ::bpkg::certificate, id_sqlite >
  {
  };

  // package_dependent
  //
  template <>
  class access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >:
    public access::view_traits< ::bpkg::package_dependent >
  {
    public:
    struct image_type
    {
      // name
      //
      details::buffer name_value;
      std::size_t name_size;
      bool name_null;

      // constraint
      //
      composite_value_traits< ::bpkg::version_constraint, id_sqlite >::image_type constraint_value;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    typedef sqlite::query_base query_base_type;
    struct query_columns
    {
    };

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 17UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::package_dependent, id_common >:
    public access::view_traits_impl< ::bpkg::package_dependent, id_sqlite >
  {
  };

  // fragment_repository_count
  //
  template <>
  class access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >:
    public access::view_traits< ::bpkg::fragment_repository_count >
  {
    public:
    struct image_type
    {
      // result
      //
      long long result_value;
      bool result_null;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    typedef sqlite::query_base query_base_type;
    struct query_columns
    {
    };

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 1UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::fragment_repository_count, id_common >:
    public access::view_traits_impl< ::bpkg::fragment_repository_count, id_sqlite >
  {
  };

  // fragment_repository
  //
  template <>
  class access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >:
    public access::view_traits< ::bpkg::fragment_repository >
  {
    public:
    struct image_type
    {
      // object
      //
      object_traits_impl< ::bpkg::repository, id_sqlite >::image_type object_value;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 5UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::fragment_repository, id_common >:
    public access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >
  {
  };

  // repository_complement_dependent
  //
  template <>
  class access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >:
    public access::view_traits< ::bpkg::repository_complement_dependent >
  {
    public:
    struct image_type
    {
      // object
      //
      object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::image_type object_value;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    struct complement_tag;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 3UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::repository_complement_dependent, id_common >:
    public access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >
  {
  };

  // repository_prerequisite_dependent
  //
  template <>
  class access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >:
    public access::view_traits< ::bpkg::repository_prerequisite_dependent >
  {
    public:
    struct image_type
    {
      // object
      //
      object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::image_type object_value;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    struct prerequisite_tag;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 3UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_common >:
    public access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >
  {
  };

  // repository_fragment_package
  //
  template <>
  class access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >:
    public access::view_traits< ::bpkg::repository_fragment_package >
  {
    public:
    struct image_type
    {
      // package
      //
      object_traits_impl< ::bpkg::available_package, id_sqlite >::image_type package_value;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    struct package_tag;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 15UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::repository_fragment_package, id_common >:
    public access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >
  {
  };

  // package_repository_fragment
  //
  template <>
  class access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >:
    public access::view_traits< ::bpkg::package_repository_fragment >
  {
    public:
    struct image_type
    {
      // package_id
      //
      composite_value_traits< ::bpkg::package_id, id_sqlite >::image_type package_id_value;

      // repository_fragment
      //
      object_traits_impl< ::bpkg::repository_fragment, id_sqlite >::image_type repository_fragment_value;

      std::size_t version;
    };

    typedef sqlite::view_statements<view_type> statements_type;

    struct package_tag;

    typedef sqlite::query_base query_base_type;
    struct query_columns;

    static const bool versioned = false;

    static bool
    grow (image_type&,
          bool*);

    static void
    bind (sqlite::bind*,
          image_type&);

    static void
    init (view_type&,
          const image_type&,
          database*);

    static const std::size_t column_count = 9UL;

    static query_base_type
    query_statement (const query_base_type&);

    static result<view_type>
    query (database&, const query_base_type&);

    static odb::details::shared_ptr<prepared_query_impl>
    prepare_query (connection&, const char*, const query_base_type&);

    static odb::details::shared_ptr<result_impl>
    execute_query (prepared_query_impl&);
  };

  template <>
  class access::view_traits_impl< ::bpkg::package_repository_fragment, id_common >:
    public access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >
  {
  };

  // configuration
  //
  // repository_fragment
  //
  // repository_fragment_count
  //
  struct access::view_traits_impl< ::bpkg::repository_fragment_count, id_sqlite >::query_columns:
    odb::pointer_query_columns<
      ::bpkg::repository_fragment,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite > >
  {
  };

  // repository
  //
  // repository_count
  //
  struct access::view_traits_impl< ::bpkg::repository_count, id_sqlite >::query_columns:
    odb::pointer_query_columns<
      ::bpkg::repository,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::repository, id_sqlite > >
  {
  };

  // available_package
  //
  // available_package_count
  //
  struct access::view_traits_impl< ::bpkg::available_package_count, id_sqlite >::query_columns:
    odb::pointer_query_columns<
      ::bpkg::available_package,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::available_package, id_sqlite > >
  {
  };

  // available_test
  //
  template <>
  struct alias_traits<
    ::bpkg::available_package,
    id_sqlite,
    access::view_traits_impl< ::bpkg::available_test, id_sqlite >::package_tag>
  {
    static const char table_name[];
  };

  struct access::view_traits_impl< ::bpkg::available_test, id_sqlite >::query_columns:
    odb::pointer_query_columns<
      ::bpkg::available_package,
      id_sqlite,
      odb::alias_traits<
        ::bpkg::available_package,
        id_sqlite,
        access::view_traits_impl< ::bpkg::available_test, id_sqlite >::package_tag> >
  {
  };

  // available_main
  //
  template <>
  struct alias_traits<
    ::bpkg::available_package,
    id_sqlite,
    access::view_traits_impl< ::bpkg::available_main, id_sqlite >::package_tag>
  {
    static const char table_name[];
  };

  struct access::view_traits_impl< ::bpkg::available_main, id_sqlite >::query_columns:
    odb::pointer_query_columns<
      ::bpkg::available_package,
      id_sqlite,
      odb::alias_traits<
        ::bpkg::available_package,
        id_sqlite,
        access::view_traits_impl< ::bpkg::available_main, id_sqlite >::package_tag> >
  {
  };

  // selected_package
  //
  // certificate
  //
  // fragment_repository
  //
  struct access::view_traits_impl< ::bpkg::fragment_repository, id_sqlite >::query_columns
  {
    // repository
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::repository,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::repository, id_sqlite > >
    repository;

    // repository_fragment
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::repository_fragment,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite > >
    repository_fragment;
  };

  // repository_complement_dependent
  //
  template <>
  struct alias_traits<
    ::bpkg::repository,
    id_sqlite,
    access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::complement_tag>
  {
    static const char table_name[];
  };

  struct access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::query_columns
  {
    // complement
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::repository,
      id_sqlite,
      odb::alias_traits< ::bpkg::repository,
        id_sqlite,
        access::view_traits_impl< ::bpkg::repository_complement_dependent, id_sqlite >::complement_tag> >
    complement;

    // repository_fragment
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::repository_fragment,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite > >
    repository_fragment;
  };

  // repository_prerequisite_dependent
  //
  template <>
  struct alias_traits<
    ::bpkg::repository,
    id_sqlite,
    access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::prerequisite_tag>
  {
    static const char table_name[];
  };

  struct access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::query_columns
  {
    // prerequisite
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::repository,
      id_sqlite,
      odb::alias_traits< ::bpkg::repository,
        id_sqlite,
        access::view_traits_impl< ::bpkg::repository_prerequisite_dependent, id_sqlite >::prerequisite_tag> >
    prerequisite;

    // repository_fragment
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::repository_fragment,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite > >
    repository_fragment;
  };

  // repository_fragment_package
  //
  template <>
  struct alias_traits<
    ::bpkg::available_package,
    id_sqlite,
    access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::package_tag>
  {
    static const char table_name[];
  };

  struct access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::query_columns
  {
    // repository_fragment
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::repository_fragment,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite > >
    repository_fragment;

    // package
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::available_package,
      id_sqlite,
      odb::alias_traits< ::bpkg::available_package,
        id_sqlite,
        access::view_traits_impl< ::bpkg::repository_fragment_package, id_sqlite >::package_tag> >
    package;
  };

  // package_repository_fragment
  //
  template <>
  struct alias_traits<
    ::bpkg::available_package,
    id_sqlite,
    access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::package_tag>
  {
    static const char table_name[];
  };

  struct access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::query_columns
  {
    // repository_fragment
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::repository_fragment,
      id_sqlite,
      odb::access::object_traits_impl< ::bpkg::repository_fragment, id_sqlite > >
    repository_fragment;

    // package
    //
    typedef
    odb::pointer_query_columns<
      ::bpkg::available_package,
      id_sqlite,
      odb::alias_traits< ::bpkg::available_package,
        id_sqlite,
        access::view_traits_impl< ::bpkg::package_repository_fragment, id_sqlite >::package_tag> >
    package;
  };
}

#include <bpkg/package-odb.ixx>

#include <odb/post.hxx>

#endif // BPKG_PACKAGE_ODB_HXX
