// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bdep/types-parsers.hxx>
//
// End prologue.

#include <bdep/project-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bdep
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bdep
{
  // configuration_add_options
  //

  configuration_add_options::
  configuration_add_options ()
  : type_ ("target"),
    type_specified_ (false),
    default__ (),
    no_default_ (),
    forward_ (),
    no_forward_ (),
    auto_sync_ (),
    no_auto_sync_ (),
    existing_ (),
    wipe_ ()
  {
  }

  bool configuration_add_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool configuration_add_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool configuration_add_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool configuration_add_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool configuration_add_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void configuration_add_options::
  merge (const configuration_add_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.type_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->type_, a.type_);
      this->type_specified_ = true;
    }

    if (a.default__)
    {
      ::bdep::cli::parser< bool>::merge (
        this->default__, a.default__);
    }

    if (a.no_default_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_default_, a.no_default_);
    }

    if (a.forward_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->forward_, a.forward_);
    }

    if (a.no_forward_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_forward_, a.no_forward_);
    }

    if (a.auto_sync_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->auto_sync_, a.auto_sync_);
    }

    if (a.no_auto_sync_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_auto_sync_, a.no_auto_sync_);
    }

    if (a.existing_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->existing_, a.existing_);
    }

    if (a.wipe_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->wipe_, a.wipe_);
    }
  }

  ::bdep::cli::usage_para configuration_add_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1m--type\033[0m|\033[1m--config-type\033[0m \033[4mtyp\033[0m  The type of the configuration being created. By" << ::std::endl
       << "                          default, configuration of type \033[1mtarget\033[0m is created. See" << ::std::endl
       << "                          \033[1mbpkg-cfg-create(1)\033[0m for background on configuration" << ::std::endl
       << "                          types." << ::std::endl;

    os << std::endl
       << "\033[1m--default\033[0m                 Make the added or created configuration the default." << ::std::endl;

    os << std::endl
       << "\033[1m--no-default\033[0m              Don't make the first added or created configuration" << ::std::endl
       << "                          the default." << ::std::endl;

    os << std::endl
       << "\033[1m--forward\033[0m                 Make the added or created configuration forwarded." << ::std::endl;

    os << std::endl
       << "\033[1m--no-forward\033[0m              Don't make the added or created configuration" << ::std::endl
       << "                          forwarded." << ::std::endl;

    os << std::endl
       << "\033[1m--auto-sync\033[0m               Make the added or created configuration automatically" << ::std::endl
       << "                          synchronized." << ::std::endl;

    os << std::endl
       << "\033[1m--no-auto-sync\033[0m            Don't make the added or created configuration" << ::std::endl
       << "                          automatically synchronized." << ::std::endl;

    os << std::endl
       << "\033[1m--existing\033[0m|\033[1m-e\033[0m             Initialize a \033[1mbpkg\033[0m configuration based on an existing" << ::std::endl
       << "                          build system configuration." << ::std::endl;

    os << std::endl
       << "\033[1m--wipe\033[0m                    Wipe the configuration directory clean before" << ::std::endl
       << "                          creating the new configuration." << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    return p;
  }

  struct _cli_configuration_add_options_desc_type: ::bdep::cli::options
  {
    _cli_configuration_add_options_desc_type ()
    {
      ::bdep::configuration_add_options::fill (*this);
    }
  };

  void configuration_add_options::
  fill (::bdep::cli::options& os)
  {
    // --type
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("--config-type");
      std::string dv ("target");
      ::bdep::cli::option o ("--type", a, false, dv);
      os.push_back (o);
    }

    // --default
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--default", a, true, dv);
      os.push_back (o);
    }

    // --no-default
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-default", a, true, dv);
      os.push_back (o);
    }

    // --forward
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--forward", a, true, dv);
      os.push_back (o);
    }

    // --no-forward
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-forward", a, true, dv);
      os.push_back (o);
    }

    // --auto-sync
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--auto-sync", a, true, dv);
      os.push_back (o);
    }

    // --no-auto-sync
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-auto-sync", a, true, dv);
      os.push_back (o);
    }

    // --existing
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-e");
      std::string dv;
      ::bdep::cli::option o ("--existing", a, true, dv);
      os.push_back (o);
    }

    // --wipe
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--wipe", a, true, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& configuration_add_options::
  description ()
  {
    static _cli_configuration_add_options_desc_type _cli_configuration_add_options_desc_;
    return _cli_configuration_add_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (configuration_add_options&, ::bdep::cli::scanner&)>
  _cli_configuration_add_options_map;

  static _cli_configuration_add_options_map _cli_configuration_add_options_map_;

  struct _cli_configuration_add_options_map_init
  {
    _cli_configuration_add_options_map_init ()
    {
      _cli_configuration_add_options_map_["--type"] =
      &::bdep::cli::thunk< configuration_add_options, string, &configuration_add_options::type_,
        &configuration_add_options::type_specified_ >;
      _cli_configuration_add_options_map_["--config-type"] =
      &::bdep::cli::thunk< configuration_add_options, string, &configuration_add_options::type_,
        &configuration_add_options::type_specified_ >;
      _cli_configuration_add_options_map_["--default"] =
      &::bdep::cli::thunk< configuration_add_options, &configuration_add_options::default__ >;
      _cli_configuration_add_options_map_["--no-default"] =
      &::bdep::cli::thunk< configuration_add_options, &configuration_add_options::no_default_ >;
      _cli_configuration_add_options_map_["--forward"] =
      &::bdep::cli::thunk< configuration_add_options, &configuration_add_options::forward_ >;
      _cli_configuration_add_options_map_["--no-forward"] =
      &::bdep::cli::thunk< configuration_add_options, &configuration_add_options::no_forward_ >;
      _cli_configuration_add_options_map_["--auto-sync"] =
      &::bdep::cli::thunk< configuration_add_options, &configuration_add_options::auto_sync_ >;
      _cli_configuration_add_options_map_["--no-auto-sync"] =
      &::bdep::cli::thunk< configuration_add_options, &configuration_add_options::no_auto_sync_ >;
      _cli_configuration_add_options_map_["--existing"] =
      &::bdep::cli::thunk< configuration_add_options, &configuration_add_options::existing_ >;
      _cli_configuration_add_options_map_["-e"] =
      &::bdep::cli::thunk< configuration_add_options, &configuration_add_options::existing_ >;
      _cli_configuration_add_options_map_["--wipe"] =
      &::bdep::cli::thunk< configuration_add_options, &configuration_add_options::wipe_ >;
    }
  };

  static _cli_configuration_add_options_map_init _cli_configuration_add_options_map_init_;

  bool configuration_add_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_configuration_add_options_map::const_iterator i (_cli_configuration_add_options_map_.find (o));

    if (i != _cli_configuration_add_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool configuration_add_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // configuration_name_options
  //

  configuration_name_options::
  configuration_name_options ()
  : config_name_ (),
    config_name_specified_ (false),
    config_id_ (),
    config_id_specified_ (false)
  {
  }

  bool configuration_name_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool configuration_name_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool configuration_name_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool configuration_name_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool configuration_name_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void configuration_name_options::
  merge (const configuration_name_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // common_options base
    //
    ::bdep::common_options::merge (a);

    if (a.config_name_specified_)
    {
      ::bdep::cli::parser< vector<pair<string, size_t>>>::merge (
        this->config_name_, a.config_name_);
      this->config_name_specified_ = true;
    }

    if (a.config_id_specified_)
    {
      ::bdep::cli::parser< vector<pair<uint64_t, size_t>>>::merge (
        this->config_id_, a.config_id_);
      this->config_id_specified_ = true;
    }
  }

  ::bdep::cli::usage_para configuration_name_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1m--config-name\033[0m|\033[1m-n\033[0m \033[4mname\033[0m     Specify the build configuration as a name." << ::std::endl;

    os << std::endl
       << "\033[1m--config-id\033[0m \033[4mnum\033[0m           Specify the build configuration as an id." << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    // common_options base
    //
    p = ::bdep::common_options::print_usage (os, p);

    return p;
  }

  struct _cli_configuration_name_options_desc_type: ::bdep::cli::options
  {
    _cli_configuration_name_options_desc_type ()
    {
      ::bdep::configuration_name_options::fill (*this);
    }
  };

  void configuration_name_options::
  fill (::bdep::cli::options& os)
  {
    // common_options base
    //
    ::bdep::common_options::fill (os);

    // --config-name
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-n");
      std::string dv;
      ::bdep::cli::option o ("--config-name", a, false, dv);
      os.push_back (o);
    }

    // --config-id
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--config-id", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& configuration_name_options::
  description ()
  {
    static _cli_configuration_name_options_desc_type _cli_configuration_name_options_desc_;
    return _cli_configuration_name_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (configuration_name_options&, ::bdep::cli::scanner&)>
  _cli_configuration_name_options_map;

  static _cli_configuration_name_options_map _cli_configuration_name_options_map_;

  struct _cli_configuration_name_options_map_init
  {
    _cli_configuration_name_options_map_init ()
    {
      _cli_configuration_name_options_map_["--config-name"] =
      &::bdep::cli::thunk< configuration_name_options, vector<pair<string, size_t>>, &configuration_name_options::config_name_,
        &configuration_name_options::config_name_specified_ >;
      _cli_configuration_name_options_map_["-n"] =
      &::bdep::cli::thunk< configuration_name_options, vector<pair<string, size_t>>, &configuration_name_options::config_name_,
        &configuration_name_options::config_name_specified_ >;
      _cli_configuration_name_options_map_["--config-id"] =
      &::bdep::cli::thunk< configuration_name_options, vector<pair<uint64_t, size_t>>, &configuration_name_options::config_id_,
        &configuration_name_options::config_id_specified_ >;
    }
  };

  static _cli_configuration_name_options_map_init _cli_configuration_name_options_map_init_;

  bool configuration_name_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_configuration_name_options_map::const_iterator i (_cli_configuration_name_options_map_.find (o));

    if (i != _cli_configuration_name_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // common_options base
    //
    if (::bdep::common_options::_parse (o, s))
      return true;

    return false;
  }

  bool configuration_name_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // project_options
  //

  project_options::
  project_options ()
  : all_ (),
    config_ (),
    config_specified_ (false),
    directory_ (),
    directory_specified_ (false)
  {
  }

  bool project_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool project_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool project_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool project_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool project_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void project_options::
  merge (const project_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // configuration_name_options base
    //
    ::bdep::configuration_name_options::merge (a);

    if (a.all_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->all_, a.all_);
    }

    if (a.config_specified_)
    {
      ::bdep::cli::parser< vector<pair<dir_path, size_t>>>::merge (
        this->config_, a.config_);
      this->config_specified_ = true;
    }

    if (a.directory_specified_)
    {
      ::bdep::cli::parser< dir_paths>::merge (
        this->directory_, a.directory_);
      this->directory_specified_ = true;
    }
  }

  ::bdep::cli::usage_para project_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1m--all\033[0m|\033[1m-a\033[0m                  Use all build configurations." << ::std::endl;

    os << std::endl
       << "\033[1m--config\033[0m|\033[1m-c\033[0m \033[4mdir\033[0m           Specify the build configuration as a directory." << ::std::endl;

    os << std::endl
       << "\033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mdir\033[0m        Assume project/package is in the specified directory" << ::std::endl
       << "                          rather than in the current working directory." << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    // configuration_name_options base
    //
    p = ::bdep::configuration_name_options::print_usage (os, p);

    return p;
  }

  struct _cli_project_options_desc_type: ::bdep::cli::options
  {
    _cli_project_options_desc_type ()
    {
      ::bdep::project_options::fill (*this);
    }
  };

  void project_options::
  fill (::bdep::cli::options& os)
  {
    // configuration_name_options base
    //
    ::bdep::configuration_name_options::fill (os);

    // --all
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-a");
      std::string dv;
      ::bdep::cli::option o ("--all", a, true, dv);
      os.push_back (o);
    }

    // --config
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-c");
      std::string dv;
      ::bdep::cli::option o ("--config", a, false, dv);
      os.push_back (o);
    }

    // --directory
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-d");
      std::string dv;
      ::bdep::cli::option o ("--directory", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& project_options::
  description ()
  {
    static _cli_project_options_desc_type _cli_project_options_desc_;
    return _cli_project_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (project_options&, ::bdep::cli::scanner&)>
  _cli_project_options_map;

  static _cli_project_options_map _cli_project_options_map_;

  struct _cli_project_options_map_init
  {
    _cli_project_options_map_init ()
    {
      _cli_project_options_map_["--all"] =
      &::bdep::cli::thunk< project_options, &project_options::all_ >;
      _cli_project_options_map_["-a"] =
      &::bdep::cli::thunk< project_options, &project_options::all_ >;
      _cli_project_options_map_["--config"] =
      &::bdep::cli::thunk< project_options, vector<pair<dir_path, size_t>>, &project_options::config_,
        &project_options::config_specified_ >;
      _cli_project_options_map_["-c"] =
      &::bdep::cli::thunk< project_options, vector<pair<dir_path, size_t>>, &project_options::config_,
        &project_options::config_specified_ >;
      _cli_project_options_map_["--directory"] =
      &::bdep::cli::thunk< project_options, dir_paths, &project_options::directory_,
        &project_options::directory_specified_ >;
      _cli_project_options_map_["-d"] =
      &::bdep::cli::thunk< project_options, dir_paths, &project_options::directory_,
        &project_options::directory_specified_ >;
    }
  };

  static _cli_project_options_map_init _cli_project_options_map_init_;

  bool project_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_project_options_map::const_iterator i (_cli_project_options_map_.find (o));

    if (i != _cli_project_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // configuration_name_options base
    //
    if (::bdep::configuration_name_options::_parse (o, s))
      return true;

    return false;
  }

  bool project_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bdep
{
  ::bdep::cli::usage_para
  print_project_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    p = ::bdep::configuration_add_options::print_usage (os, p);

    p = ::bdep::configuration_name_options::print_usage (os, p);

    p = ::bdep::project_options::print_usage (os, p);

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

