// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bbot/types-parsers.hxx>
//
// End prologue.

#include <bbot/worker/worker-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bbot
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bbot
{
  // worker_options
  //

  worker_options::
  worker_options ()
  : help_ (),
    version_ (),
    verbose_ (1),
    verbose_specified_ (false),
    bootstrap_ (),
    startup_ (),
    systemd_daemon_ (),
    build_ (),
    build_specified_ (false),
    environments_ (),
    environments_specified_ (false),
    env_script_ (),
    env_script_specified_ (false),
    env_target_ (),
    env_target_specified_ (false),
    tftp_host_ ("196.254.111.222"),
    tftp_host_specified_ (false)
  {
  }

  bool worker_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bbot::cli::unknown_mode opt,
         ::bbot::cli::unknown_mode arg)
  {
    ::bbot::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool worker_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bbot::cli::unknown_mode opt,
         ::bbot::cli::unknown_mode arg)
  {
    ::bbot::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool worker_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bbot::cli::unknown_mode opt,
         ::bbot::cli::unknown_mode arg)
  {
    ::bbot::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool worker_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bbot::cli::unknown_mode opt,
         ::bbot::cli::unknown_mode arg)
  {
    ::bbot::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool worker_options::
  parse (::bbot::cli::scanner& s,
         ::bbot::cli::unknown_mode opt,
         ::bbot::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  ::bbot::cli::usage_para worker_options::
  print_usage (::std::ostream& os, ::bbot::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bbot::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mOPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m--help\033[0m                    Print usage information and exit." << ::std::endl;

    os << std::endl
       << "\033[1m--version\033[0m                 Print version and exit." << ::std::endl;

    os << std::endl
       << "\033[1m--verbose\033[0m \033[4mlevel\033[0m           Set the diagnostics verbosity to \033[4mlevel\033[0m between 0 and" << ::std::endl
       << "                          6 with level 1 being the default." << ::std::endl;

    os << std::endl
       << "\033[1m--bootstrap\033[0m               Perform the inital machine bootstrap insteading of" << ::std::endl
       << "                          building." << ::std::endl;

    os << std::endl
       << "\033[1m--startup\033[0m                 Perform the environment setup and then re-execute for" << ::std::endl
       << "                          building." << ::std::endl;

    os << std::endl
       << "\033[1m--systemd-daemon\033[0m          Run as a simple systemd daemon." << ::std::endl;

    os << std::endl
       << "\033[1m--build\033[0m \033[4mdir\033[0m               The directory to perform the build in. If not" << ::std::endl
       << "                          specified, then the current working directory is" << ::std::endl
       << "                          used." << ::std::endl;

    os << std::endl
       << "\033[1m--environments\033[0m \033[4mdir\033[0m        The directory containing the environment setup" << ::std::endl
       << "                          executables. If not specified, then the user's home" << ::std::endl
       << "                          directory is used." << ::std::endl;

    os << std::endl
       << "\033[1m--env-script\033[0m \033[4mpath\033[0m         The environment setup executable path. This option is" << ::std::endl
       << "                          normally passed by the worker running in the startup" << ::std::endl
       << "                          mode to the worker executed in the build mode." << ::std::endl;

    os << std::endl
       << "\033[1m--env-target\033[0m \033[4mtarget\033[0m       The environment setup executable target argument." << ::std::endl
       << "                          This option is normally passed by the worker running" << ::std::endl
       << "                          in the startup mode to the worker executed in the" << ::std::endl
       << "                          build mode." << ::std::endl;

    os << std::endl
       << "\033[1m--tftp-host\033[0m \033[4maddr\033[0m          The TFTP host address and, optionally, port to use to" << ::std::endl
       << "                          download the build task and to upload the build" << ::std::endl
       << "                          result. By default the link-local address" << ::std::endl
       << "                          196.254.111.222 with the standard TFTP port (69) is" << ::std::endl
       << "                          used." << ::std::endl;

    p = ::bbot::cli::usage_para::option;

    return p;
  }

  typedef
  std::map<std::string, void (*) (worker_options&, ::bbot::cli::scanner&)>
  _cli_worker_options_map;

  static _cli_worker_options_map _cli_worker_options_map_;

  struct _cli_worker_options_map_init
  {
    _cli_worker_options_map_init ()
    {
      _cli_worker_options_map_["--help"] =
      &::bbot::cli::thunk< worker_options, &worker_options::help_ >;
      _cli_worker_options_map_["--version"] =
      &::bbot::cli::thunk< worker_options, &worker_options::version_ >;
      _cli_worker_options_map_["--verbose"] =
      &::bbot::cli::thunk< worker_options, uint16_t, &worker_options::verbose_,
        &worker_options::verbose_specified_ >;
      _cli_worker_options_map_["--bootstrap"] =
      &::bbot::cli::thunk< worker_options, &worker_options::bootstrap_ >;
      _cli_worker_options_map_["--startup"] =
      &::bbot::cli::thunk< worker_options, &worker_options::startup_ >;
      _cli_worker_options_map_["--systemd-daemon"] =
      &::bbot::cli::thunk< worker_options, &worker_options::systemd_daemon_ >;
      _cli_worker_options_map_["--build"] =
      &::bbot::cli::thunk< worker_options, dir_path, &worker_options::build_,
        &worker_options::build_specified_ >;
      _cli_worker_options_map_["--environments"] =
      &::bbot::cli::thunk< worker_options, dir_path, &worker_options::environments_,
        &worker_options::environments_specified_ >;
      _cli_worker_options_map_["--env-script"] =
      &::bbot::cli::thunk< worker_options, path, &worker_options::env_script_,
        &worker_options::env_script_specified_ >;
      _cli_worker_options_map_["--env-target"] =
      &::bbot::cli::thunk< worker_options, string, &worker_options::env_target_,
        &worker_options::env_target_specified_ >;
      _cli_worker_options_map_["--tftp-host"] =
      &::bbot::cli::thunk< worker_options, string, &worker_options::tftp_host_,
        &worker_options::tftp_host_specified_ >;
    }
  };

  static _cli_worker_options_map_init _cli_worker_options_map_init_;

  bool worker_options::
  _parse (const char* o, ::bbot::cli::scanner& s)
  {
    _cli_worker_options_map::const_iterator i (_cli_worker_options_map_.find (o));

    if (i != _cli_worker_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool worker_options::
  _parse (::bbot::cli::scanner& s,
          ::bbot::cli::unknown_mode opt_mode,
          ::bbot::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bbot::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
        s.skip ();
        r = true;
        continue;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bbot::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bbot::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bbot::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bbot::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bbot::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bbot::cli::unknown_mode::fail:
            {
              throw ::bbot::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bbot::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bbot::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bbot::cli::unknown_mode::fail:
        {
          throw ::bbot::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bbot
{
  ::bbot::cli::usage_para
  print_bbot_worker_usage (::std::ostream& os, ::bbot::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bbot::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbbot-worker --help\033[0m" << ::std::endl
       << "\033[1mbbot-worker --version\033[0m" << ::std::endl
       << "\033[1mbbot-worker --bootstrap\033[0m [\033[4moptions\033[0m]" << ::std::endl
       << "\033[1mbbot-worker --startup\033[0m [\033[4moptions\033[0m]" << ::std::endl
       << "\033[1mbbot-worker\033[0m [\033[4moptions\033[0m] \033[4mmodule\033[0m... \033[4mcfg-var\033[0m...\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbbot-worker\033[0m @@ TODO." << ::std::endl
       << ::std::endl
       << "If the \033[1m--bootstrap\033[0m mode option is specified, then the worker performs the" << ::std::endl
       << "initial machine bootstrap and writes the bootstrap result manifest to stdout\033[0m." << ::std::endl
       << "If the \033[1m--startup\033[0m mode option is specified, then the worker performs the" << ::std::endl
       << "environment setup and then re-executes in the build mode. If neither of the" << ::std::endl
       << "mode options is specified, then the worker proceeds to performing the build" << ::std::endl
       << "task." << ::std::endl;

    p = ::bbot::worker_options::print_usage (os, ::bbot::cli::usage_para::text);

    if (p != ::bbot::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mEXIT STATUS\033[0m" << ::std::endl
       << ::std::endl
       << "Non-zero exit status is returned in case of an error. In the build mode, exit" << ::std::endl
       << "code 2 is used to signal abnormal termination where the worker uploaded the" << ::std::endl
       << "result manifest itself." << ::std::endl;

    p = ::bbot::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

