// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
//
// End prologue.

#include <cassert>

namespace bbot
{
  namespace cli
  {
    // usage_para
    //
    inline usage_para::
    usage_para (value v)
    : v_ (v)
    {
    }

    // unknown_mode
    //
    inline unknown_mode::
    unknown_mode (value v)
    : v_ (v)
    {
    }

    // exception
    //
    inline ::std::ostream&
    operator<< (::std::ostream& os, const exception& e)
    {
      e.print (os);
      return os;
    }

    // unknown_option
    //
    inline unknown_option::
    unknown_option (const std::string& option)
    : option_ (option)
    {
    }

    inline const std::string& unknown_option::
    option () const
    {
      return option_;
    }

    // unknown_argument
    //
    inline unknown_argument::
    unknown_argument (const std::string& argument)
    : argument_ (argument)
    {
    }

    inline const std::string& unknown_argument::
    argument () const
    {
      return argument_;
    }

    // missing_value
    //
    inline missing_value::
    missing_value (const std::string& option)
    : option_ (option)
    {
    }

    inline const std::string& missing_value::
    option () const
    {
      return option_;
    }

    // invalid_value
    //
    inline invalid_value::
    invalid_value (const std::string& option,
                   const std::string& value,
                   const std::string& message)
    : option_ (option),
      value_ (value),
      message_ (message)
    {
    }

    inline const std::string& invalid_value::
    option () const
    {
      return option_;
    }

    inline const std::string& invalid_value::
    value () const
    {
      return value_;
    }

    inline const std::string& invalid_value::
    message () const
    {
      return message_;
    }

    // unexpected_group
    //
    inline unexpected_group::
    unexpected_group (const std::string& argument,
                      const std::string& group)
    : argument_ (argument), group_ (group)
    {
    }

    inline const std::string& unexpected_group::
    argument () const
    {
      return argument_;
    }

    inline const std::string& unexpected_group::
    group () const
    {
      return group_;
    }

    // group_separator
    //
    inline group_separator::
    group_separator (const std::string& encountered,
                     const std::string& expected)
    : encountered_ (encountered), expected_ (expected)
    {
    }

    inline const std::string& group_separator::
    encountered () const
    {
      return encountered_;
    }

    inline const std::string& group_separator::
    expected () const
    {
      return expected_;
    }

    // argv_scanner
    //
    inline argv_scanner::
    argv_scanner (int& argc,
                  char** argv,
                  bool erase,
                  std::size_t sp)
    : start_position_ (sp + 1),
      i_ (1),
      argc_ (argc),
      argv_ (argv),
      erase_ (erase)
    {
    }

    inline argv_scanner::
    argv_scanner (int start,
                  int& argc,
                  char** argv,
                  bool erase,
                  std::size_t sp)
    : start_position_ (sp + static_cast<std::size_t> (start)),
      i_ (start),
      argc_ (argc),
      argv_ (argv),
      erase_ (erase)
    {
    }

    inline int argv_scanner::
    end () const
    {
      return i_;
    }

    // vector_scanner
    //
    inline vector_scanner::
    vector_scanner (const std::vector<std::string>& v,
                    std::size_t i,
                    std::size_t sp)
    : start_position_ (sp), v_ (v), i_ (i)
    {
    }

    inline std::size_t vector_scanner::
    end () const
    {
      return i_;
    }

    inline void vector_scanner::
    reset (std::size_t i, std::size_t sp)
    {
      i_ = i;
      start_position_ = sp;
    }

    // group_scanner
    //
    inline group_scanner::
    group_scanner (scanner& s)
    : scan_ (s), state_ (skipped), i_ (1), j_ (0), group_scan_ (group_)
    {
    }

    inline scanner& group_scanner::
    group ()
    {
      assert (state_ == scanned || state_ == skipped);
      return group_scan_;
    }

    inline const char* group_scanner::
    escape (const char* a)
    {
      switch (sense (a))
      {
        case separator::none:       break;
        case separator::open:       return "\\{";
        case separator::close:      return "\\}";
        case separator::open_plus:  return "\\+{";
        case separator::close_plus: return "\\}+";
      }

      return a;
    }

    inline group_scanner::separator group_scanner::
    sense (const char* s)
    {
      switch (s[0])
      {
        case '{': return s[1] == '\0' ? open  : none;
        case '}':
        {
          switch (s[1])
          {
            case '+': return s[2] == '\0' ? close_plus  : none;
            default:  return s[1] == '\0' ? close       : none;
          }
        }
        case '+':
        {
          switch (s[1])
          {
            case '{': return s[2] == '\0' ? open_plus  : none;
            default:  return                             none;
          }
        }
      }

      return none;
    }
  }
}

namespace bbot
{
}

// Begin epilogue.
//
//
// End epilogue.
