// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bdep/types-parsers.hxx>
#include <bdep/release-parsers.hxx>
//
// End prologue.

#include <bdep/release-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bdep
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bdep
{
  // cmd_release_options
  //

  cmd_release_options::
  cmd_release_options ()
  : revision_ (),
    no_commit_ (),
    no_tag_ (),
    tag_ (),
    current_tag_ (cmd_release_current_tag::keep),
    current_tag_specified_ (false),
    push_ (),
    show_push_ (),
    no_open_ (),
    open_ (),
    amend_ (),
    squash_ (1),
    squash_specified_ (false),
    alpha_ (),
    beta_ (),
    minor_ (),
    major_ (),
    open_beta_ (),
    open_patch_ (),
    open_minor_ (),
    open_major_ (),
    open_base_ (),
    open_base_specified_ (false),
    edit_ (),
    no_edit_ (),
    force_ (),
    force_specified_ (false),
    yes_ (),
    directory_ (),
    directory_specified_ (false)
  {
  }

  bool cmd_release_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_release_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_release_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_release_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_release_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_release_options::
  merge (const cmd_release_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // common_options base
    //
    ::bdep::common_options::merge (a);

    if (a.revision_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->revision_, a.revision_);
    }

    if (a.no_commit_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_commit_, a.no_commit_);
    }

    if (a.no_tag_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_tag_, a.no_tag_);
    }

    if (a.tag_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->tag_, a.tag_);
    }

    if (a.current_tag_specified_)
    {
      ::bdep::cli::parser< cmd_release_current_tag>::merge (
        this->current_tag_, a.current_tag_);
      this->current_tag_specified_ = true;
    }

    if (a.push_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->push_, a.push_);
    }

    if (a.show_push_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->show_push_, a.show_push_);
    }

    if (a.no_open_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_open_, a.no_open_);
    }

    if (a.open_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->open_, a.open_);
    }

    if (a.amend_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->amend_, a.amend_);
    }

    if (a.squash_specified_)
    {
      ::bdep::cli::parser< size_t>::merge (
        this->squash_, a.squash_);
      this->squash_specified_ = true;
    }

    if (a.alpha_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->alpha_, a.alpha_);
    }

    if (a.beta_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->beta_, a.beta_);
    }

    if (a.minor_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->minor_, a.minor_);
    }

    if (a.major_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->major_, a.major_);
    }

    if (a.open_beta_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->open_beta_, a.open_beta_);
    }

    if (a.open_patch_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->open_patch_, a.open_patch_);
    }

    if (a.open_minor_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->open_minor_, a.open_minor_);
    }

    if (a.open_major_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->open_major_, a.open_major_);
    }

    if (a.open_base_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->open_base_, a.open_base_);
      this->open_base_specified_ = true;
    }

    if (a.edit_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->edit_, a.edit_);
    }

    if (a.no_edit_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->no_edit_, a.no_edit_);
    }

    if (a.force_specified_)
    {
      ::bdep::cli::parser< std::set<string>>::merge (
        this->force_, a.force_);
      this->force_specified_ = true;
    }

    if (a.yes_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->yes_, a.yes_);
    }

    if (a.directory_specified_)
    {
      ::bdep::cli::parser< dir_paths>::merge (
        this->directory_, a.directory_);
      this->directory_specified_ = true;
    }
  }

  ::bdep::cli::usage_para cmd_release_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mRELEASE OPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m--revision\033[0m                Release a new package revision instead of a new" << ::std::endl
       << "                          version." << ::std::endl;

    os << std::endl
       << "\033[1m--no-commit\033[0m               Don't commit the changes. Implies \033[1m--no-tag\033[0m and, in" << ::std::endl
       << "                          the version release mode, \033[1m--no-open\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--no-tag\033[0m                  Don't tag the release commit. Tagging can be" << ::std::endl
       << "                          performed later using the \033[1m--tag\033[0m mode option." << ::std::endl;

    os << std::endl
       << "\033[1m--tag\033[0m                     Tag the already released version instead of releasing" << ::std::endl
       << "                          a new one." << ::std::endl;

    os << std::endl
       << "\033[1m--current-tag\033[0m \033[4maction\033[0m      Specify what to do with an existing tag for the" << ::std::endl
       << "                          current version when tagging a new revision. Valid" << ::std::endl
       << "                          values for this option are \033[1mkeep\033[0m (default), \033[1mupdate\033[0m," << ::std::endl
       << "                          and \033[1mremove\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--push\033[0m                    Push the committed changes and tags to the remote." << ::std::endl;

    os << std::endl
       << "\033[1m--show-push\033[0m               Print the push command instead of executing it. This" << ::std::endl
       << "                          allows examining the committed changes and tags" << ::std::endl
       << "                          before pushing them to the remote. Note that the" << ::std::endl
       << "                          command is printed to \033[1mstdout\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--no-open\033[0m                 Don't open the next development cycle. Opening can be" << ::std::endl
       << "                          performed later using the \033[1m--open\033[0m mode option." << ::std::endl;

    os << std::endl
       << "\033[1m--open\033[0m                    Open the next development cycle instead of releasing" << ::std::endl
       << "                          a new version." << ::std::endl;

    os << std::endl
       << "\033[1m--amend\033[0m                   Release a revision by amending the latest commit" << ::std::endl
       << "                          instead of making a new one." << ::std::endl;

    os << std::endl
       << "\033[1m--squash\033[0m \033[4mnum\033[0m              Release a revision by squashing the specified number" << ::std::endl
       << "                          of previous commits and then amending the result." << ::std::endl
       << "                          Requires the \033[1m--amend\033[0m option to be specified." << ::std::endl;

    os << std::endl
       << "\033[1m--alpha\033[0m                   Release an alpha instead of the final version." << ::std::endl;

    os << std::endl
       << "\033[1m--beta\033[0m                    Release a beta version instead of the final version." << ::std::endl;

    os << std::endl
       << "\033[1m--minor\033[0m                   Release the next minor version instead of the current" << ::std::endl
       << "                          patch." << ::std::endl;

    os << std::endl
       << "\033[1m--major\033[0m                   Release the next major version instead of the current" << ::std::endl
       << "                          minor or patch." << ::std::endl;

    os << std::endl
       << "\033[1m--open-beta\033[0m               Open the development cycle with the next beta" << ::std::endl
       << "                          version." << ::std::endl;

    os << std::endl
       << "\033[1m--open-patch\033[0m              Open the development cycle with the next patch" << ::std::endl
       << "                          version. This is the default if the current patch" << ::std::endl
       << "                          version is not 0\033[0m (bugfix release series)." << ::std::endl;

    os << std::endl
       << "\033[1m--open-minor\033[0m              Open the development cycle with the next minor" << ::std::endl
       << "                          version. This is the default if the current patch" << ::std::endl
       << "                          version is 0\033[0m (feature release series)." << ::std::endl;

    os << std::endl
       << "\033[1m--open-major\033[0m              Open the development cycle with the next major" << ::std::endl
       << "                          version." << ::std::endl;

    os << std::endl
       << "\033[1m--open-base\033[0m \033[4mversion\033[0m       Open the development cycle with the specified" << ::std::endl
       << "                          version. The base version should be in the" << ::std::endl
       << "                          \033[4mmajor\033[0m\033[1m.\033[0m\033[4mminor\033[0m.\033[0m\033[4mpatch\033[0m\033[0m form with the opened version" << ::std::endl
       << "                          becoming \033[4mmajor\033[0m\033[1m.\033[0m\033[4mminor\033[0m\033[1m.\033[0m\033[4mpatch\033[0m\033[1m-a.0.z\033[0m\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--edit\033[0m                    Open the commit message for editing." << ::std::endl;

    os << std::endl
       << "\033[1m--no-edit\033[0m                 Don't open the commit message for editing." << ::std::endl;

    os << std::endl
       << "\033[1m--force\033[0m \033[4mcheck\033[0m             Force releasing, disabling the specified check." << ::std::endl
       << "                          Repeat this option to disable multiple checks." << ::std::endl;

    os << std::endl
       << "\033[1m--yes\033[0m|\033[1m-y\033[0m                  Don't prompt for confirmation before releasing." << ::std::endl;

    os << std::endl
       << "\033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mdir\033[0m        Assume project/package is in the specified directory" << ::std::endl
       << "                          rather than in the current working directory." << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    // common_options base
    //
    p = ::bdep::common_options::print_usage (os, p);

    return p;
  }

  struct _cli_cmd_release_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_release_options_desc_type ()
    {
      ::bdep::cmd_release_options::fill (*this);
    }
  };

  void cmd_release_options::
  fill (::bdep::cli::options& os)
  {
    // common_options base
    //
    ::bdep::common_options::fill (os);

    // --revision
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--revision", a, true, dv);
      os.push_back (o);
    }

    // --no-commit
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-commit", a, true, dv);
      os.push_back (o);
    }

    // --no-tag
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-tag", a, true, dv);
      os.push_back (o);
    }

    // --tag
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--tag", a, true, dv);
      os.push_back (o);
    }

    // --current-tag
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--current-tag", a, false, dv);
      os.push_back (o);
    }

    // --push
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--push", a, true, dv);
      os.push_back (o);
    }

    // --show-push
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--show-push", a, true, dv);
      os.push_back (o);
    }

    // --no-open
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-open", a, true, dv);
      os.push_back (o);
    }

    // --open
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--open", a, true, dv);
      os.push_back (o);
    }

    // --amend
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--amend", a, true, dv);
      os.push_back (o);
    }

    // --squash
    //
    {
      ::bdep::cli::option_names a;
      std::string dv ("1");
      ::bdep::cli::option o ("--squash", a, false, dv);
      os.push_back (o);
    }

    // --alpha
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--alpha", a, true, dv);
      os.push_back (o);
    }

    // --beta
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--beta", a, true, dv);
      os.push_back (o);
    }

    // --minor
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--minor", a, true, dv);
      os.push_back (o);
    }

    // --major
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--major", a, true, dv);
      os.push_back (o);
    }

    // --open-beta
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--open-beta", a, true, dv);
      os.push_back (o);
    }

    // --open-patch
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--open-patch", a, true, dv);
      os.push_back (o);
    }

    // --open-minor
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--open-minor", a, true, dv);
      os.push_back (o);
    }

    // --open-major
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--open-major", a, true, dv);
      os.push_back (o);
    }

    // --open-base
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--open-base", a, false, dv);
      os.push_back (o);
    }

    // --edit
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--edit", a, true, dv);
      os.push_back (o);
    }

    // --no-edit
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--no-edit", a, true, dv);
      os.push_back (o);
    }

    // --force
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--force", a, false, dv);
      os.push_back (o);
    }

    // --yes
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-y");
      std::string dv;
      ::bdep::cli::option o ("--yes", a, true, dv);
      os.push_back (o);
    }

    // --directory
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-d");
      std::string dv;
      ::bdep::cli::option o ("--directory", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_release_options::
  description ()
  {
    static _cli_cmd_release_options_desc_type _cli_cmd_release_options_desc_;
    return _cli_cmd_release_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_release_options&, ::bdep::cli::scanner&)>
  _cli_cmd_release_options_map;

  static _cli_cmd_release_options_map _cli_cmd_release_options_map_;

  struct _cli_cmd_release_options_map_init
  {
    _cli_cmd_release_options_map_init ()
    {
      _cli_cmd_release_options_map_["--revision"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::revision_ >;
      _cli_cmd_release_options_map_["--no-commit"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::no_commit_ >;
      _cli_cmd_release_options_map_["--no-tag"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::no_tag_ >;
      _cli_cmd_release_options_map_["--tag"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::tag_ >;
      _cli_cmd_release_options_map_["--current-tag"] =
      &::bdep::cli::thunk< cmd_release_options, cmd_release_current_tag, &cmd_release_options::current_tag_,
        &cmd_release_options::current_tag_specified_ >;
      _cli_cmd_release_options_map_["--push"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::push_ >;
      _cli_cmd_release_options_map_["--show-push"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::show_push_ >;
      _cli_cmd_release_options_map_["--no-open"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::no_open_ >;
      _cli_cmd_release_options_map_["--open"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::open_ >;
      _cli_cmd_release_options_map_["--amend"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::amend_ >;
      _cli_cmd_release_options_map_["--squash"] =
      &::bdep::cli::thunk< cmd_release_options, size_t, &cmd_release_options::squash_,
        &cmd_release_options::squash_specified_ >;
      _cli_cmd_release_options_map_["--alpha"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::alpha_ >;
      _cli_cmd_release_options_map_["--beta"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::beta_ >;
      _cli_cmd_release_options_map_["--minor"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::minor_ >;
      _cli_cmd_release_options_map_["--major"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::major_ >;
      _cli_cmd_release_options_map_["--open-beta"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::open_beta_ >;
      _cli_cmd_release_options_map_["--open-patch"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::open_patch_ >;
      _cli_cmd_release_options_map_["--open-minor"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::open_minor_ >;
      _cli_cmd_release_options_map_["--open-major"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::open_major_ >;
      _cli_cmd_release_options_map_["--open-base"] =
      &::bdep::cli::thunk< cmd_release_options, string, &cmd_release_options::open_base_,
        &cmd_release_options::open_base_specified_ >;
      _cli_cmd_release_options_map_["--edit"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::edit_ >;
      _cli_cmd_release_options_map_["--no-edit"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::no_edit_ >;
      _cli_cmd_release_options_map_["--force"] =
      &::bdep::cli::thunk< cmd_release_options, std::set<string>, &cmd_release_options::force_,
        &cmd_release_options::force_specified_ >;
      _cli_cmd_release_options_map_["--yes"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::yes_ >;
      _cli_cmd_release_options_map_["-y"] =
      &::bdep::cli::thunk< cmd_release_options, &cmd_release_options::yes_ >;
      _cli_cmd_release_options_map_["--directory"] =
      &::bdep::cli::thunk< cmd_release_options, dir_paths, &cmd_release_options::directory_,
        &cmd_release_options::directory_specified_ >;
      _cli_cmd_release_options_map_["-d"] =
      &::bdep::cli::thunk< cmd_release_options, dir_paths, &cmd_release_options::directory_,
        &cmd_release_options::directory_specified_ >;
    }
  };

  static _cli_cmd_release_options_map_init _cli_cmd_release_options_map_init_;

  bool cmd_release_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_release_options_map::const_iterator i (_cli_cmd_release_options_map_.find (o));

    if (i != _cli_cmd_release_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // common_options base
    //
    if (::bdep::common_options::_parse (o, s))
      return true;

    return false;
  }

  bool cmd_release_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bdep
{
  ::bdep::cli::usage_para
  print_bdep_release_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbdep release\033[0m [\033[4moptions\033[0m] [\033[4mprj-spec\033[0m]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[4mprj-spec\033[0m = \033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mprj-dir\033[0m | \033[4mpkg-spec\033[0m" << ::std::endl
       << "\033[4mpkg-spec\033[0m = (\033[4mpkg\033[0m | (\033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mpkg-dir\033[0m))...\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mrelease\033[0m command manages the project's version during the release." << ::std::endl
       << "Specifically, it first changes the snapshot version to the corresponding" << ::std::endl
       << "release version in each project package's \033[1mmanifest\033[0m file, commits these changes" << ::std::endl
       << "(unless \033[1m--no-commit\033[0m is specified), tags this commit (unless \033[1m--no-tag\033[0m is" << ::std::endl
       << "specified), and, if \033[1m--push\033[0m is specified, pushes the changes to the remote." << ::std::endl
       << "Unless \033[1m--no-open\033[0m is specified, the \033[1mrelease\033[0m command then opens the next" << ::std::endl
       << "development cycle by changing the version to a snapshot, committing these" << ::std::endl
       << "changes (unless \033[1m--no-commit\033[0m is specified), and, if \033[1m--push\033[0m is specified, pushing" << ::std::endl
       << "them to the remote. Note that committing, tagging, and pushing is currently" << ::std::endl
       << "only supported for \033[1mgit(1)\033[0m project repositories." << ::std::endl
       << ::std::endl
       << "The \033[1mrelease\033[0m command can also be used to release a new package revision by" << ::std::endl
       << "passing the \033[1m--revision\033[0m option. In this mode \033[1mrelease\033[0m increments the current" << ::std::endl
       << "version's revision component in each project package's \033[1mmanifest\033[0m file, commits" << ::std::endl
       << "these changes (unless \033[1m--no-commit\033[0m is specified), tags this commit (unless" << ::std::endl
       << "\033[1m--no-tag\033[0m is specified), and, if \033[1m--push\033[0m is specified, pushes the changes to the" << ::std::endl
       << "remote. In this mode \033[1mrelease\033[0m can be optionally instructed to update an existing" << ::std::endl
       << "tag for the current version to point to the latest revision" << ::std::endl
       << "(\033[1m--current-tag=update\033[0m) or to remove it (\033[1m--current-tag=remove\033[0m)." << ::std::endl
       << ::std::endl
       << "When releasing a revision, the project's repository index is expected to" << ::std::endl
       << "already contain other changes since for a revision all the associated changes," << ::std::endl
       << "including to version, must belong to a single commit. Alternatively, a revision" << ::std::endl
       << "can be released by amending one or more existing commits using the \033[1m--amend\033[0m and" << ::std::endl
       << "\033[1m--squash\033[0m options. In this case the index may still contain additional changes" << ::std::endl
       << "but is not required to." << ::std::endl
       << ::std::endl
       << "The \033[1mrelease\033[0m command also has a number of \033[4mcontinue modes\033[0m that allow the" << ::std::endl
       << "completion of steps that were previously suppressed with the \033[1m--no-*\033[0m options in" << ::std::endl
       << "the above main modes. These are \033[1m--tag\033[0m which tags the release commit and, if" << ::std::endl
       << "\033[1m--push\033[0m is specified, pushes it to the remote as well as \033[1m--open\033[0m which performs" << ::std::endl
       << "the opening of the next development cycle as described above." << ::std::endl
       << ::std::endl
       << "In all the modes that perform a commit, if the project's repository index" << ::std::endl
       << "already contains other changes, then the commit message is automatically opened" << ::std::endl
       << "for editing unless \033[1m--no-edit\033[0m is specified. The editing of the commit message in" << ::std::endl
       << "the absence of other changes can be requested with the \033[1m--edit\033[0m option." << ::std::endl
       << ::std::endl
       << "Normally, \033[1mrelease\033[0m operates on all the packages in a project. If no project" << ::std::endl
       << "directory is specified, then the current working directory is assumed and all" << ::std::endl
       << "the packages are released, even if the current directory is a package" << ::std::endl
       << "directory. If, however, one or more package directories are specified" << ::std::endl
       << "explicitly with \033[1m--directory\033[0m|\033[1m-d\033[0m\033[0m, then \033[1mrelease\033[0m assumes you know what you are" << ::std::endl
       << "doing and only releases these packages. All the packages being released must" << ::std::endl
       << "have the same version but may have different revisions." << ::std::endl;

    p = ::bdep::cmd_release_options::print_usage (os, ::bdep::cli::usage_para::text);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "See \033[1mbdep-default-options-files(1)\033[0m for an overview of the default options files." << ::std::endl
       << "For the \033[1mrelease\033[0m command the search start directory is the project directory." << ::std::endl
       << "The following options files are searched for in each directory and, if found," << ::std::endl
       << "loaded in the order listed:" << ::std::endl
       << ::std::endl
       << "bdep.options" << ::std::endl
       << "bdep-release.options" << ::std::endl
       << "bdep-release-{version|revision|open|tag}.options # (mode-dependent)" << ::std::endl
       << ::std::endl
       << "The following \033[1mrelease\033[0m command options cannot be specified in the default" << ::std::endl
       << "options files:" << ::std::endl
       << ::std::endl
       << "--directory|-d" << ::std::endl
       << "--revision" << ::std::endl
       << "--open" << ::std::endl
       << "--tag" << ::std::endl;

    p = ::bdep::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

