// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <libbuild2/types-parsers.hxx>
//
// End prologue.

#include <bx/bx-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace build2
{
  namespace build
  {
    namespace cli
    {
      template <typename X>
      struct parser
      {
        static void
        parse (X& x, bool& xs, scanner& s)
        {
          using namespace std;

          const char* o (s.next ());
          if (s.more ())
          {
            string v (s.next ());
            istringstream is (v);
            if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
              throw invalid_value (o, v);
          }
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (X& b, const X& a)
        {
          b = a;
        }
      };

      template <>
      struct parser<bool>
      {
        static void
        parse (bool& x, bool& xs, scanner& s)
        {
          const char* o (s.next ());

          if (s.more ())
          {
            const char* v (s.next ());

            if (std::strcmp (v, "1")    == 0 ||
                std::strcmp (v, "true") == 0 ||
                std::strcmp (v, "TRUE") == 0 ||
                std::strcmp (v, "True") == 0)
              x = true;
            else if (std::strcmp (v, "0")     == 0 ||
                     std::strcmp (v, "false") == 0 ||
                     std::strcmp (v, "FALSE") == 0 ||
                     std::strcmp (v, "False") == 0)
              x = false;
            else
              throw invalid_value (o, v);
          }
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (bool& b, const bool&)
        {
          b = true;
        }
      };

      template <>
      struct parser<std::string>
      {
        static void
        parse (std::string& x, bool& xs, scanner& s)
        {
          const char* o (s.next ());

          if (s.more ())
            x = s.next ();
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (std::string& b, const std::string& a)
        {
          b = a;
        }
      };

      template <typename X>
      struct parser<std::pair<X, std::size_t> >
      {
        static void
        parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
        {
          x.second = s.position ();
          parser<X>::parse (x.first, xs, s);
        }

        static void
        merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
        {
          b = a;
        }
      };

      template <typename X>
      struct parser<std::vector<X> >
      {
        static void
        parse (std::vector<X>& c, bool& xs, scanner& s)
        {
          X x;
          bool dummy;
          parser<X>::parse (x, dummy, s);
          c.push_back (x);
          xs = true;
        }

        static void
        merge (std::vector<X>& b, const std::vector<X>& a)
        {
          b.insert (b.end (), a.begin (), a.end ());
        }
      };

      template <typename X, typename C>
      struct parser<std::set<X, C> >
      {
        static void
        parse (std::set<X, C>& c, bool& xs, scanner& s)
        {
          X x;
          bool dummy;
          parser<X>::parse (x, dummy, s);
          c.insert (x);
          xs = true;
        }

        static void
        merge (std::set<X, C>& b, const std::set<X, C>& a)
        {
          b.insert (a.begin (), a.end ());
        }
      };

      template <typename K, typename V, typename C>
      struct parser<std::map<K, V, C> >
      {
        static void
        parse (std::map<K, V, C>& m, bool& xs, scanner& s)
        {
          const char* o (s.next ());

          if (s.more ())
          {
            std::size_t pos (s.position ());
            std::string ov (s.next ());
            std::string::size_type p = ov.find ('=');

            K k = K ();
            V v = V ();
            std::string kstr (ov, 0, p);
            std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (o),
              0
            };

            bool dummy;
            if (!kstr.empty ())
            {
              av[1] = const_cast<char*> (kstr.c_str ());
              argv_scanner s (0, ac, av, false, pos);
              parser<K>::parse (k, dummy, s);
            }

            if (!vstr.empty ())
            {
              av[1] = const_cast<char*> (vstr.c_str ());
              argv_scanner s (0, ac, av, false, pos);
              parser<V>::parse (v, dummy, s);
            }

            m[k] = v;
          }
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
        {
          for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
               i != a.end (); 
               ++i)
            b[i->first] = i->second;
        }
      };

      template <typename K, typename V, typename C>
      struct parser<std::multimap<K, V, C> >
      {
        static void
        parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
        {
          const char* o (s.next ());

          if (s.more ())
          {
            std::size_t pos (s.position ());
            std::string ov (s.next ());
            std::string::size_type p = ov.find ('=');

            K k = K ();
            V v = V ();
            std::string kstr (ov, 0, p);
            std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (o),
              0
            };

            bool dummy;
            if (!kstr.empty ())
            {
              av[1] = const_cast<char*> (kstr.c_str ());
              argv_scanner s (0, ac, av, false, pos);
              parser<K>::parse (k, dummy, s);
            }

            if (!vstr.empty ())
            {
              av[1] = const_cast<char*> (vstr.c_str ());
              argv_scanner s (0, ac, av, false, pos);
              parser<V>::parse (v, dummy, s);
            }

            m.insert (typename std::multimap<K, V, C>::value_type (k, v));
          }
          else
            throw missing_value (o);

          xs = true;
        }

        static void
        merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
        {
          for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
               i != a.end (); 
               ++i)
            b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                   i->second));
        }
      };

      template <typename X, typename T, T X::*M>
      void
      thunk (X& x, scanner& s)
      {
        parser<T>::parse (x.*M, s);
      }

      template <typename X, bool X::*M>
      void
      thunk (X& x, scanner& s)
      {
        s.next ();
        x.*M = true;
      }

      template <typename X, typename T, T X::*M, bool X::*S>
      void
      thunk (X& x, scanner& s)
      {
        parser<T>::parse (x.*M, x.*S, s);
      }
    }
  }
}

#include <map>

namespace build2
{
  // bx_options
  //

  bx_options::
  bx_options ()
  : build2_metadata_ (),
    build2_metadata_specified_ (false),
    v_ (),
    V_ (),
    quiet_ (),
    verbose_ (1),
    verbose_specified_ (false),
    diag_color_ (),
    no_diag_color_ (),
    pager_ (),
    pager_specified_ (false),
    pager_option_ (),
    pager_option_specified_ (false),
    options_file_ (),
    options_file_specified_ (false),
    default_options_ (),
    default_options_specified_ (false),
    no_default_options_ (),
    help_ (),
    version_ ()
  {
  }

  bool bx_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    ::build2::build::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool bx_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    ::build2::build::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool bx_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    ::build2::build::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool bx_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    ::build2::build::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool bx_options::
  parse (::build2::build::cli::scanner& s,
         ::build2::build::cli::unknown_mode opt,
         ::build2::build::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void bx_options::
  merge (const bx_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.build2_metadata_specified_)
    {
      ::build2::build::cli::parser< uint64_t>::merge (
        this->build2_metadata_, a.build2_metadata_);
      this->build2_metadata_specified_ = true;
    }

    if (a.v_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->v_, a.v_);
    }

    if (a.V_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->V_, a.V_);
    }

    if (a.quiet_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->quiet_, a.quiet_);
    }

    if (a.verbose_specified_)
    {
      ::build2::build::cli::parser< uint16_t>::merge (
        this->verbose_, a.verbose_);
      this->verbose_specified_ = true;
    }

    if (a.diag_color_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->diag_color_, a.diag_color_);
    }

    if (a.no_diag_color_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_diag_color_, a.no_diag_color_);
    }

    if (a.pager_specified_)
    {
      ::build2::build::cli::parser< string>::merge (
        this->pager_, a.pager_);
      this->pager_specified_ = true;
    }

    if (a.pager_option_specified_)
    {
      ::build2::build::cli::parser< strings>::merge (
        this->pager_option_, a.pager_option_);
      this->pager_option_specified_ = true;
    }

    if (a.options_file_specified_)
    {
      ::build2::build::cli::parser< string>::merge (
        this->options_file_, a.options_file_);
      this->options_file_specified_ = true;
    }

    if (a.default_options_specified_)
    {
      ::build2::build::cli::parser< dir_path>::merge (
        this->default_options_, a.default_options_);
      this->default_options_specified_ = true;
    }

    if (a.no_default_options_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->no_default_options_, a.no_default_options_);
    }

    if (a.help_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->help_, a.help_);
    }

    if (a.version_)
    {
      ::build2::build::cli::parser< bool>::merge (
        this->version_, a.version_);
    }
  }

  ::build2::build::cli::usage_para bx_options::
  print_usage (::std::ostream& os, ::build2::build::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::build2::build::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mOPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m-v\033[0m                      Print actual commands being executed. This options is" << ::std::endl
       << "                        equivalent to \033[1m--verbose 2\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m-V\033[0m                      Print all underlying commands being executed. This" << ::std::endl
       << "                        options is equivalent to \033[1m--verbose 3\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--quiet\033[0m|\033[1m-q\033[0m              Run quietly, only printing error messages. This option" << ::std::endl
       << "                        is equivalent to \033[1m--verbose 0\033[0m." << ::std::endl;

    os << std::endl
       << "\033[1m--verbose\033[0m \033[4mlevel\033[0m         Set the diagnostics verbosity to \033[4mlevel\033[0m between 0 and 6." << ::std::endl
       << "                        Level 0 disables any non-error messages while level 6" << ::std::endl
       << "                        produces lots of information, with level 1 being the" << ::std::endl
       << "                        default. The following additional types of diagnostics" << ::std::endl
       << "                        are produced at each level:" << ::std::endl
       << ::std::endl
       << "                        1. High-level information messages." << ::std::endl
       << "                        2. Essential underlying commands being executed." << ::std::endl
       << "                        3. All underlying commands being executed." << ::std::endl
       << "                        4. Information that could be helpful to the user." << ::std::endl
       << "                        5. Information that could be helpful to the developer." << ::std::endl
       << "                        6. Even more detailed information." << ::std::endl;

    os << std::endl
       << "\033[1m--diag-color\033[0m            Use color in diagnostics. If printing to a terminal the" << ::std::endl
       << "                        color is used by default provided the terminal is not" << ::std::endl
       << "                        dumb. Use \033[1m--no-diag-color\033[0m to suppress." << ::std::endl;

    os << std::endl
       << "\033[1m--no-diag-color\033[0m         Don't use color in diagnostics." << ::std::endl;

    os << std::endl
       << "\033[1m--pager\033[0m \033[4mpath\033[0m            The pager program to be used to show long text." << ::std::endl
       << "                        Commonly used pager programs are \033[1mless\033[0m and \033[1mmore\033[0m. You can" << ::std::endl
       << "                        also specify additional options that should be passed" << ::std::endl
       << "                        to the pager program with \033[1m--pager-option\033[0m. If an empty" << ::std::endl
       << "                        string is specified as the pager program, then no pager" << ::std::endl
       << "                        will be used. If the pager program is not explicitly" << ::std::endl
       << "                        specified, then \033[1mb\033[0m will try to use \033[1mless\033[0m. If it is not" << ::std::endl
       << "                        available, then no pager will be used." << ::std::endl;

    os << std::endl
       << "\033[1m--pager-option\033[0m \033[4mopt\033[0m      Additional option to be passed to the pager program." << ::std::endl
       << "                        See \033[1m--pager\033[0m for more information on the pager program." << ::std::endl
       << "                        Repeat this option to specify multiple pager options." << ::std::endl;

    os << std::endl
       << "\033[1m--options-file\033[0m \033[4mfile\033[0m     Read additional options from \033[4mfile\033[0m. Each option should" << ::std::endl
       << "                        appear on a separate line optionally followed by space" << ::std::endl
       << "                        or equal sign (\033[1m=\033[0m) and an option value. Empty lines and" << ::std::endl
       << "                        lines starting with \033[1m#\033[0m are ignored. Option values can be" << ::std::endl
       << "                        enclosed in double (\033[1m\"\033[0m) or single (\033[1m'\033[0m) quotes to preserve" << ::std::endl
       << "                        leading and trailing whitespaces as well as to specify" << ::std::endl
       << "                        empty values. If the value itself contains trailing or" << ::std::endl
       << "                        leading quotes, enclose it with an extra pair of" << ::std::endl
       << "                        quotes, for example \033[1m'\"x\"'\033[0m. Non-leading and non-trailing" << ::std::endl
       << "                        quotes are interpreted as being part of the option" << ::std::endl
       << "                        value." << ::std::endl
       << ::std::endl
       << "                        The semantics of providing options in a file is" << ::std::endl
       << "                        equivalent to providing the same set of options in the" << ::std::endl
       << "                        same order on the command line at the point where the" << ::std::endl
       << "                        \033[1m--options-file\033[0m option is specified except that the" << ::std::endl
       << "                        shell escaping and quoting is not required. Repeat this" << ::std::endl
       << "                        option to specify more than one options file." << ::std::endl;

    os << std::endl
       << "\033[1m--default-options\033[0m \033[4mdir\033[0m   The directory to load additional default options files" << ::std::endl
       << "                        from." << ::std::endl;

    os << std::endl
       << "\033[1m--no-default-options\033[0m    Don't load default options files." << ::std::endl;

    os << std::endl
       << "\033[1m--help\033[0m                  Print usage information and exit." << ::std::endl;

    os << std::endl
       << "\033[1m--version\033[0m               Print version and exit." << ::std::endl;

    p = ::build2::build::cli::usage_para::option;

    return p;
  }

  typedef
  std::map<std::string, void (*) (bx_options&, ::build2::build::cli::scanner&)>
  _cli_bx_options_map;

  static _cli_bx_options_map _cli_bx_options_map_;

  struct _cli_bx_options_map_init
  {
    _cli_bx_options_map_init ()
    {
      _cli_bx_options_map_["--build2-metadata"] =
      &::build2::build::cli::thunk< bx_options, uint64_t, &bx_options::build2_metadata_,
        &bx_options::build2_metadata_specified_ >;
      _cli_bx_options_map_["-v"] =
      &::build2::build::cli::thunk< bx_options, &bx_options::v_ >;
      _cli_bx_options_map_["-V"] =
      &::build2::build::cli::thunk< bx_options, &bx_options::V_ >;
      _cli_bx_options_map_["--quiet"] =
      &::build2::build::cli::thunk< bx_options, &bx_options::quiet_ >;
      _cli_bx_options_map_["-q"] =
      &::build2::build::cli::thunk< bx_options, &bx_options::quiet_ >;
      _cli_bx_options_map_["--verbose"] =
      &::build2::build::cli::thunk< bx_options, uint16_t, &bx_options::verbose_,
        &bx_options::verbose_specified_ >;
      _cli_bx_options_map_["--diag-color"] =
      &::build2::build::cli::thunk< bx_options, &bx_options::diag_color_ >;
      _cli_bx_options_map_["--no-diag-color"] =
      &::build2::build::cli::thunk< bx_options, &bx_options::no_diag_color_ >;
      _cli_bx_options_map_["--pager"] =
      &::build2::build::cli::thunk< bx_options, string, &bx_options::pager_,
        &bx_options::pager_specified_ >;
      _cli_bx_options_map_["--pager-option"] =
      &::build2::build::cli::thunk< bx_options, strings, &bx_options::pager_option_,
        &bx_options::pager_option_specified_ >;
      _cli_bx_options_map_["--options-file"] =
      &::build2::build::cli::thunk< bx_options, string, &bx_options::options_file_,
        &bx_options::options_file_specified_ >;
      _cli_bx_options_map_["--default-options"] =
      &::build2::build::cli::thunk< bx_options, dir_path, &bx_options::default_options_,
        &bx_options::default_options_specified_ >;
      _cli_bx_options_map_["--no-default-options"] =
      &::build2::build::cli::thunk< bx_options, &bx_options::no_default_options_ >;
      _cli_bx_options_map_["--help"] =
      &::build2::build::cli::thunk< bx_options, &bx_options::help_ >;
      _cli_bx_options_map_["--version"] =
      &::build2::build::cli::thunk< bx_options, &bx_options::version_ >;
    }
  };

  static _cli_bx_options_map_init _cli_bx_options_map_init_;

  bool bx_options::
  _parse (const char* o, ::build2::build::cli::scanner& s)
  {
    _cli_bx_options_map::const_iterator i (_cli_bx_options_map_.find (o));

    if (i != _cli_bx_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool bx_options::
  _parse (::build2::build::cli::scanner& s,
          ::build2::build::cli::unknown_mode opt_mode,
          ::build2::build::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::build2::build::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::build2::build::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::build2::build::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::build2::build::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::build2::build::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::build2::build::cli::unknown_mode::stop:
            {
              break;
            }
            case ::build2::build::cli::unknown_mode::fail:
            {
              throw ::build2::build::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::build2::build::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::build2::build::cli::unknown_mode::stop:
        {
          break;
        }
        case ::build2::build::cli::unknown_mode::fail:
        {
          throw ::build2::build::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace build2
{
  ::build2::build::cli::usage_para
  print_bx_usage (::std::ostream& os, ::build2::build::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::build2::build::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbx\033[0m [\033[4moptions\033[0m] \033[4mpath\033[0m [\033[4marg\033[0m...]" << ::std::endl
       << "\033[1mbx\033[0m [\033[4moptions\033[0m] \033[4mtask\033[0m [\033[4marg\033[0m...]" << ::std::endl
       << "\033[1mbx\033[0m [\033[4moptions\033[0m] [\033[1m--\033[0m \033[4marg\033[0m...]\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mbuild2\033[0m shell script and task runner executes a script (first form) or a" << ::std::endl
       << "task (second and third form) with optional arguments." << ::std::endl
       << ::std::endl
       << "The first argument after \033[4moptions\033[0m determines whether it is a shell script path" << ::std::endl
       << "or a task name. It is considered a script if it contains the directory" << ::std::endl
       << "separator or the \033[1m.bx\033[0m extension. Otherwise, it is considered a task name. Absent" << ::std::endl
       << "first argument means the default task. In this case the \033[1m--\033[0m separator must be" << ::std::endl
       << "used if you wish to pass arguments to the default task. Note that neither the" << ::std::endl
       << "script path nor task name can start with \033[1m-\033[0m." << ::std::endl
       << ::std::endl
       << "Note that task running is not yet implemented." << ::std::endl;

    p = ::build2::bx_options::print_usage (os, ::build2::build::cli::usage_para::text);

    if (p != ::build2::build::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "Instead of having a separate config file format for tool configuration, the" << ::std::endl
       << "\033[1mbuild2\033[0m toolchain uses \033[4mdefault options files\033[0m which contain the same options as" << ::std::endl
       << "what can be specified on the command line. The default options files are like" << ::std::endl
       << "options files that one can specify with \033[1m--options-file\033[0m except that they are" << ::std::endl
       << "loaded by default." << ::std::endl
       << ::std::endl
       << "The default options files for \033[1mbx\033[0m are called \033[1mbx.options\033[0m, \033[1mbx-script.options\033[0m" << ::std::endl
       << "(shell script only), and \033[1mbx-task.options\033[0m (task only) and are searched for in" << ::std::endl
       << "the \033[1m.build2/\033[0m subdirectory of the home directory and in the system directory" << ::std::endl
       << "(for example, \033[1m/etc/build2/\033[0m) if configured. Note that besides options the" << ::std::endl
       << "\033[1mbx-task.options\033[0m file can also contain global variable overrides (@@ only for" << ::std::endl
       << "task running?)." << ::std::endl
       << ::std::endl
       << "Once the search is complete, the files are loaded in the reverse order, that" << ::std::endl
       << "is, beginning from the system directory (if any), followed by the home" << ::std::endl
       << "directory, and finishing off with the options specified on the command line." << ::std::endl
       << "For each directory \033[1mbx.options\033[0m, if found, is loaded first, followed by" << ::std::endl
       << "\033[1mbx-script.options\033[0m for a shell script and \033[1mbx-task.options\033[0m for a task. In other" << ::std::endl
       << "words, the files are loaded from the more generic to the more specific with the" << ::std::endl
       << "command line options having the ability to override any values specified in the" << ::std::endl
       << "default options files." << ::std::endl
       << ::std::endl
       << "If a default options file contains \033[1m--no-default-options\033[0m, then the search is" << ::std::endl
       << "stopped at the directory containing this file and no outer files are loaded. If" << ::std::endl
       << "this option is specified on the command line, then none of the default options" << ::std::endl
       << "files are searched for or loaded." << ::std::endl
       << ::std::endl
       << "An additional directory containing default options files can be specified with" << ::std::endl
       << "\033[1m--default-options\033[0m. Its configuration files are loaded after the home directory." << ::std::endl
       << ::std::endl
       << "The order in which default options files are loaded is traced at the verbosity" << ::std::endl
       << "level 3 (\033[1m-V\033[0m option) or higher." << ::std::endl
       << ::std::endl
       << "\033[1mEXIT STATUS\033[0m" << ::std::endl
       << ::std::endl
       << "In case of a script execution, the script exit code is returned. In case of a" << ::std::endl
       << "task execution, non-zero exit status is returned in case of an error." << ::std::endl;

    os << std::endl
       << "\033[1mENVIRONMENT\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mHOME\033[0m environment variable is used to determine the user's home directory." << ::std::endl
       << "If it is not set, then \033[1mgetpwuid(3)\033[0m is used instead. This value is used to" << ::std::endl
       << "shorten paths printed in diagnostics by replacing the home directory with \033[1m~/\033[0m." << ::std::endl
       << "It is also made available to scripts as the \033[1mshell.home\033[0m variable." << ::std::endl
       << ::std::endl
       << "The \033[1mBUILD2_DEF_OPT\033[0m environment variable is used to suppress loading of default" << ::std::endl
       << "options files in nested runner invocations. Its values are \033[1mfalse\033[0m or \033[1m0\033[0m to" << ::std::endl
       << "suppress and \033[1mtrue\033[0m or \033[1m1\033[0m to load." << ::std::endl;

    p = ::build2::build::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

